/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.graphtable;

import com.sas.graphics.data.Filter2TableModel;
import com.sas.graphics.silk.graphtable.FormattedColumnCellRenderer;
import com.sas.graphics.silk.graphtable.GTable;
import com.sas.graphics.silk.graphtable.GTableFilter;
import com.sas.graphics.silk.graphtable.GraphicalColumnCellRenderer;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.util.Print;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.table.GTableModel;
import com.sas.graphics.silk.util.table.SILKTableInterface;
import com.sas.graphics.silk.util.table.TableSorter;
import com.sas.graphics.silk.util.table.TableStyle;
import com.sas.graphics.util.BMPWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class GTablePanel
extends JPanel
implements ListSelectionListener,
SILKTableInterface,
Printable,
Pageable {
    private static final long serialVersionUID = -91006733465943617L;
    protected JApplet applet = null;
    protected GTable table;
    protected GTable header;
    protected GTableModel gtModel;
    protected GTableFilter filterPanel;
    protected JScrollPane scrollPane;
    protected TableStyle style = new TableStyle(0);
    protected TableColumnModel tcm;
    protected TableColumn firstColumn;
    protected JViewport jViewport;
    protected JScrollBar vScrollBar;
    protected ScrollBarUI vScrollUI;
    protected BasicScrollBarUI vScrollBasicUI;
    protected JComponent c;
    protected ComponentUI cUI;
    protected JTableHeader tHeader;
    protected TableHeaderUI tHeaderUI;
    protected Rectangle headerRect;
    protected Dimension viewSize;
    protected Dimension vScrollSize;
    protected Dimension headerSize;
    protected boolean vScrollVis;
    protected boolean rowHeader = false;
    protected boolean showPopMenu;
    protected boolean statistics;
    protected int headerWidth = 0;
    protected int tableWidth;
    protected int paneWidth;
    protected int paneHeight;
    protected int vScrollWidth;
    protected int tableHeight;
    protected int filterHeight = 0;
    protected int headerHeight = 0;
    protected int printMode = 0;
    protected int[] rowHeights = null;
    private boolean sortEnabled = true;
    protected int headerHt = 0;
    private boolean ignoreListEvents = false;
    private static final double MIN_PRINT_SCALE_FACTOR = 0.02;

    public GTablePanel() {
        super(new BorderLayout());
        UIManager.put("ScrollBar.thumb", this.style.headerBackColor);
        UIManager.put("ScrollBar.track", this.style.headerBackColor);
        UIManager.put("button.background", this.style.headerBackColor);
    }

    public GTablePanel(GTableModel gtModel, boolean showFilter, boolean rowHeader, int appWidth, int appHeight) {
        this();
        this.init(gtModel, showFilter, rowHeader, appWidth, appHeight);
    }

    protected void init(GTableModel gtModel, boolean showFilter, boolean rowHeader, int appWidth, int appHeight) {
        this.buildPanel(gtModel, showFilter, rowHeader, appWidth, appHeight);
    }

    public void buildPanel(GTableModel gtModel, boolean showFilter, boolean rowHeader, int appWidth, int appHeight) {
        this.removeAll();
        if (gtModel == null) {
            return;
        }
        int columnCount = gtModel.getColumnCount();
        this.rowHeader = rowHeader;
        this.gtModel = gtModel;
        this.paneWidth = appWidth;
        this.paneHeight = appHeight;
        this.showPopMenu = true;
        this.statistics = showFilter;
        boolean oldShowPopup = true;
        if (this.table != null) {
            oldShowPopup = this.table.showPopMenu;
        }
        this.table = new GTable(gtModel, this.style, "Table ", this.statistics, this.showPopMenu, this.paneWidth, this);
        if (this.table.getTableHeader() != null) {
            this.table.getTableHeader().setReorderingAllowed(false);
        }
        this.table.setAppletContext(this.applet);
        this.tableWidth = this.table.getTableWidth();
        this.table.showPopMenu = oldShowPopup;
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setBorder(new LineBorder(Color.black, 1));
        if (showFilter) {
            this.filterPanel = new GTableFilter(this.table, this.style);
            this.add((Component)this.filterPanel, "South");
            Dimension size = this.filterPanel.getPreferredSize();
            this.filterHeight = size.height;
            this.paneHeight -= this.filterHeight;
        }
        if (rowHeader && this.tableWidth > this.paneWidth) {
            int pad = 0;
            this.showPopMenu = false;
            this.header = new GTable(gtModel, this.style, "Header", this.statistics, this.showPopMenu, this.paneWidth, this);
            this.header.setAppletContext(this.applet);
            this.tcm = this.header.getColumnModel();
            for (int i = columnCount - 1; i > 0; --i) {
                this.header.hideColumn(i);
            }
            this.firstColumn = this.tcm.getColumn(0);
            this.header.setAutoResizeMode(0);
            if (this.table.getTableHeader() != null) {
                this.header.getTableHeader().setReorderingAllowed(false);
            }
            this.headerWidth = this.firstColumn.getPreferredWidth() + this.header.getColumnModel().getColumnMargin() + pad;
            Dimension size = new Dimension(this.headerWidth, 0);
            this.header.setPreferredScrollableViewportSize(size);
            this.firstColumn.setMinWidth(this.headerWidth);
            this.firstColumn.setMaxWidth(this.headerWidth);
            this.table.hideColumn(0);
            this.scrollPane.setRowHeaderView(this.header);
            this.scrollPane.setCorner("UPPER_LEFT_CORNER", this.header.getTableHeader());
            this.table.revalidate();
            this.table.setSyncTable(this.header);
            this.header.setSyncTable(this.table);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.header.getSelectionModel().addListSelectionListener(this);
        }
        this.add((Component)this.scrollPane, "Center");
        this.rowHeights = new int[gtModel.getRowCount()];
        this.resetRowHeights();
        this.updateUIColors(false);
        this.jViewport = this.scrollPane.getViewport();
        this.viewSize = this.jViewport.getViewSize();
        this.vScrollBar = this.scrollPane.getVerticalScrollBar();
        this.vScrollBar.addComponentListener(new ScrollBarComponentListener());
        this.c = this.vScrollBar;
        this.vScrollUI = this.vScrollBar.getUI();
        this.vScrollSize = this.vScrollUI.getPreferredSize(this.c);
        this.vScrollWidth = this.vScrollSize.width;
        this.tHeader = this.table.getTableHeader();
        this.tHeaderUI = this.tHeader.getUI();
        this.cUI = this.tHeaderUI;
        this.headerSize = this.cUI.getPreferredSize(this.tHeader);
        this.headerHeight = this.headerSize.height + 2;
        this.paneHeight -= this.headerHeight;
        this.tableHeight = this.viewSize.height;
        if (this.tableHeight > this.paneHeight) {
            this.paneWidth -= this.vScrollWidth;
        }
        this.resizeColumns();
    }

    public void setShowFilter(boolean show) {
        this.buildPanel(this.gtModel, show, false, this.paneWidth, this.paneHeight);
        if (this.isObsNumberColumnVisible()) {
            this.setObsNumberColumnVisible(false);
        }
        this.table.getSelectionModel().addListSelectionListener(this);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public boolean isFilterOn() {
        return this.statistics;
    }

    public void setRowHeader(boolean b) {
        if (this.isFilterOn()) {
            return;
        }
        this.buildPanel(this.gtModel, this.statistics, b, this.paneWidth, this.paneHeight);
        if (this.isObsNumberColumnVisible()) {
            this.setObsNumberColumnVisible(false);
        }
        this.table.getSelectionModel().addListSelectionListener(this);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public boolean isRowHeaderOn() {
        return this.rowHeader;
    }

    public void setObsNumberColumnVisible(boolean obsNumberColumnVisible) {
        TableSorter ts;
        if (this.isFilterOn() || this.isRowHeaderOn()) {
            return;
        }
        if (this.table != null && (ts = this.table.getGTableModel()) != null) {
            ts.setObsNumberColumnVisible(obsNumberColumnVisible);
            ts.tableChanged(new TableModelEvent((TableModel)ts, -1));
            this.resizeColumns();
        }
    }

    public boolean isObsNumberColumnVisible() {
        if (this.table != null) {
            TableSorter ts = this.table.getGTableModel();
            return ts.isObsNumberColumnVisible();
        }
        return false;
    }

    public boolean isVariableDescriptionUsed() {
        TableModel tm;
        TableSorter ts;
        if (this.table != null && (ts = this.table.getGTableModel()) != null && (tm = ts.getModel()) instanceof Filter2TableModel) {
            return ((Filter2TableModel)tm).isVariableDescriptionUsed();
        }
        return true;
    }

    public void setUseVariableDescription(boolean useVariableDescription) {
        TableModel tm;
        TableSorter ts;
        if (this.table != null && (ts = this.table.getGTableModel()) != null && (tm = ts.getModel()) instanceof Filter2TableModel) {
            ((Filter2TableModel)tm).setUseVariableDescription(useVariableDescription);
            ts.tableChanged(new TableModelEvent((TableModel)ts, -1));
            this.resizeColumns();
        }
    }

    public void setObsColumnHeader(String obsHeader) {
        TableSorter ts;
        if (this.table != null && (ts = this.table.getGTableModel()) != null) {
            ts.setObsColumnHeader(obsHeader);
            ts.tableChanged(new TableModelEvent((TableModel)ts, -1));
        }
    }

    public String getObsColumnHeader() {
        TableSorter ts;
        if (this.table != null && (ts = this.table.getGTableModel()) != null) {
            return ts.getObsColumnHeader();
        }
        return null;
    }

    public void printPanel(int mode) {
        this.printMode = mode;
        try {
            if (this.printMode != 2) {
                Print.print((Object)this, (boolean)false);
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public void resizeColumns() {
        this.resetRowHeights();
        int width = this.paneWidth - this.headerWidth;
        if (this.vScrollBar != null && this.vScrollBar.isVisible()) {
            width -= this.vScrollBar.getWidth();
        }
        if (this.table != null) {
            this.table.resizeColumns(width);
        }
    }

    public void setAppletContext(JApplet app) {
        this.applet = app;
        if (this.table != null) {
            this.table.setAppletContext(this.applet);
        }
        if (this.header != null) {
            this.header.setAppletContext(this.applet);
        }
    }

    public GTable getTable() {
        return this.table;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setHeaderHeight(int height) {
        if (this.table == null) {
            return;
        }
        JTableHeader jth = this.table.getTableHeader();
        if (jth == null) {
            return;
        }
        boolean heightDiff = height > this.headerHt;
        int curHeight = jth.getHeight();
        this.headerHt = Math.max(Math.max(curHeight, height), this.headerHt);
        if (heightDiff) {
            this.table.getTableHeader().setSize(this.table.getTableHeader().getWidth(), this.headerHt);
            if (this.header != null) {
                this.header.getTableHeader().setSize(this.table.getTableHeader().getWidth(), this.headerHt);
                TableColumnModel tcm = this.header.getColumnModel();
                TableColumn firstColumn = tcm.getColumn(0);
                this.headerWidth = firstColumn.getPreferredWidth() + this.header.getColumnModel().getColumnMargin();
                Dimension size = new Dimension(this.headerWidth, 0);
                this.header.setPreferredScrollableViewportSize(size);
                firstColumn.setMinWidth(this.headerWidth);
                firstColumn.setMaxWidth(this.headerWidth);
            }
            this.revalidate();
        }
    }

    public void setRowHeight(int row, int height) {
        if (this.rowHeights == null) {
            return;
        }
        if (this.filterPanel != null) {
            TableSorter tm = this.table.getGTableModel();
            if (tm == null) {
                return;
            }
            if (this.rowHeights.length != tm.getRowCount()) {
                int[] t = this.rowHeights;
                this.rowHeights = new int[tm.getRowCount()];
                int limit = Math.min(this.rowHeights.length, t.length);
                for (int i = 0; i < limit; ++i) {
                    this.rowHeights[i] = t[i];
                }
            }
        }
        if (row < this.rowHeights.length && this.rowHeights[row] < height) {
            this.rowHeights[row] = height;
            if (this.table != null) {
                this.table.setRowHeight(row, this.rowHeights[row]);
            }
            if (this.header != null) {
                this.header.setRowHeight(row, this.rowHeights[row]);
            }
        }
    }

    public void setStyle(int styleId) {
        boolean rebuildScrollPane = true;
        this.style.setStyle(styleId);
        this.updateUIColors(rebuildScrollPane);
        this.table.setStyle(this.style);
        if (this.filterPanel != null) {
            this.filterPanel.setStyle(this.style);
        }
    }

    public void setItemColor(int item, Color color) {
        boolean rebuildScrollPane = false;
        this.style.setItemColor(item, color);
        if (item == 2) {
            rebuildScrollPane = true;
        }
        this.updateUIColors(rebuildScrollPane);
        this.table.setStyle(this.style);
        if (this.filterPanel != null) {
            this.filterPanel.setStyle(this.style);
        }
    }

    public void setTarget(String t) {
        if (this.table != null) {
            this.table.setTarget(t);
        }
        if (this.header != null) {
            this.header.setTarget(t);
        }
    }

    public void setTarget(String columnName, String t) {
        if (this.table != null) {
            this.table.setTarget(columnName, t);
        }
        if (this.header != null) {
            this.header.setTarget(columnName, t);
        }
    }

    public void setNativeLookAndFeel(boolean set) {
        if (this.table != null) {
            this.table.setNativeLookAndFeel(set);
        }
        if (this.header != null) {
            this.table.setNativeLookAndFeel(set);
        }
    }

    public void sortColumn(int columnIndex, boolean ascending) {
        int sortOrder = ascending ? 0 : 1;
        this.sortColumn(columnIndex, sortOrder);
    }

    public void sortColumn(int columnIndex, int sortOrder) {
        if (this.table != null) {
            this.table.sortColumn(columnIndex, sortOrder);
        }
        if (this.header != null) {
            this.header.sortColumn(columnIndex, sortOrder);
        }
    }

    public void saveImageToFile(String imageFileName) {
        GTablePanel panel = this;
        BMPWriter writer = new BMPWriter();
        int width = panel.getWidth();
        int height = panel.getHeight();
        BufferedImage bufImg = new BufferedImage(width, height, 1);
        Graphics g = bufImg.getGraphics();
        panel.printComponents(g);
        try {
            writer.saveBitmap(imageFileName, (Image)bufImg, width, height);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void updateUIColors(boolean rebuild) {
        if (rebuild) {
            UIManager.put("ScrollBar.thumb", this.style.headerBackColor);
            UIManager.put("ScrollBar.track", this.style.headerBackColor);
            UIManager.put("button.background", this.style.headerBackColor);
            this.remove(this.scrollPane);
            this.scrollPane = new JScrollPane(this.table);
            this.scrollPane.setBorder(new LineBorder(Color.black, 1));
            if (this.header != null) {
                this.scrollPane.setRowHeaderView(this.header);
                this.scrollPane.setCorner("UPPER_LEFT_CORNER", this.header.getTableHeader());
                this.table.revalidate();
            }
            this.add((Component)this.scrollPane, "Center");
        }
        if (this.scrollPane != null) {
            this.scrollPane.getViewport().setBackground(this.style.headerBackColor);
        }
        this.setForeground(this.style.headerForeColor);
        this.setBackground(this.style.headerBackColor);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (this.ignoreListEvents) {
            return;
        }
        Object src = evt.getSource();
        if (src instanceof ListSelectionModel) {
            GTable other;
            GTable source;
            this.ignoreListEvents = true;
            if ((ListSelectionModel)src == this.table.getSelectionModel()) {
                source = this.table;
                other = this.header;
            } else {
                source = this.header;
                other = this.table;
            }
            int[] selectedRows = source.getSelectedRows();
            other.clearSelection();
            for (int i = 0; i < selectedRows.length; ++i) {
                other.addRowSelectionInterval(selectedRows[i], selectedRows[i]);
            }
            this.ignoreListEvents = false;
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform defaultXfm = g2.getTransform();
        AffineTransform xfm = new AffineTransform(defaultXfm);
        if (pi >= this.getNumberOfPages()) {
            return 1;
        }
        GTablePanel panel = this;
        double pageX = pf.getImageableWidth();
        double pageY = pf.getImageableHeight();
        if (this.printMode == 0) {
            double compX = panel.getWidth();
            double compY = panel.getHeight();
            double sx = pageX / compX;
            double sy = pageY / compY;
            double scale = Math.min(sx, sy);
            if (sx < 0.02 || sy < 0.02) {
                System.out.println(this.table.GRS(this.table.resourceBundle, "Print.ScaleError.txt", "Table cannot be printed on one page"));
                return 1;
            }
            xfm.translate(pf.getImageableX(), pf.getImageableY());
            xfm.scale(scale, scale);
            g2.setTransform(xfm);
            panel.printComponents(g);
        } else if (this.printMode == 1) {
            double compX = Math.max(this.tableWidth, this.paneWidth);
            double compY = this.tableHeight;
            double sx = pageX / compX;
            double sy = pageY / compY;
            double scale = Math.min(sx, sy);
            if (sx < 0.02 || sy < 0.02) {
                System.out.println(this.table.GRS(this.table.resourceBundle, "Print.ScaleError", "Table cannot be printed on one page"));
                return 1;
            }
            xfm.translate(pf.getImageableX(), pf.getImageableY());
            xfm.scale(scale, scale);
            g2.setTransform(xfm);
            JTableHeader tableHeader = this.table.getTableHeader();
            Dimension headerSize = null;
            headerSize = tableHeader != null ? tableHeader.getSize() : new Dimension(0, 0);
            tableHeader.paint(g2);
            g2.translate(0, headerSize.height);
            this.table.paint(g);
        }
        return 0;
    }

    @Override
    public int getNumberOfPages() {
        int numPages = this.printMode == 1 || this.printMode == 0 ? 1 : 1;
        return numPages;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return (PageFormat)SILKGlobal.getInstance().getPropertyValue(57);
    }

    @Override
    public Printable getPrintable(int pageIndex) {
        return this;
    }

    protected void resetRowHeights() {
        this.headerHt = 0;
        if (this.table == null) {
            return;
        }
        this.rowHeights = new int[this.table.getRowCount()];
        if (this.rowHeights != null) {
            for (int i = 0; i < this.rowHeights.length; ++i) {
                this.rowHeights[i] = 0;
            }
        }
    }

    public Color getCellColor(int row, int column, Object value, TableCellRenderer cellRenderer) {
        return null;
    }

    protected int getIndex(Object value, int column) {
        return 0;
    }

    protected int getNumberOfUniqueValues(int column) {
        return 1;
    }

    public void setSortingEnabled(boolean sortEnabled) {
        if (this.sortEnabled == sortEnabled) {
            return;
        }
        this.sortEnabled = sortEnabled;
        if (this.table == null) {
            return;
        }
        TableSorter tableSorter = this.table.getGTableModel();
        if (tableSorter == null) {
            return;
        }
        if (this.sortEnabled) {
            tableSorter.addMouseListenerToHeaderInTable((JTable)this.table, this.table.ascendingIcon, this.table.descendingIcon, null);
        } else {
            tableSorter.removeMouseListenerToHeaderInTable((JTable)this.table);
        }
    }

    public boolean isSortingEnabled() {
        return this.sortEnabled;
    }

    public boolean setColorRamp(Object column, ColorInterface ramp) {
        if (column == null) {
            return false;
        }
        TableSorter ts = this.table.getGTableModel();
        if (ts == null || this.gtModel == null) {
            return false;
        }
        TableColumnModel tcm = this.table.getColumnModel();
        int idx = ts.getColumnIndexInVisibleModel(this.gtModel.getColumnIndex(column.toString()));
        if (idx < 0) {
            return false;
        }
        int i = tcm.getColumnIndex(column);
        if (i < 0) {
            return false;
        }
        TableColumn col = tcm.getColumn(i);
        if (col == null) {
            return false;
        }
        TableCellRenderer renderer = col.getCellRenderer();
        if (renderer instanceof FormattedColumnCellRenderer) {
            ((FormattedColumnCellRenderer)renderer).setRamp(ramp);
        } else if (renderer instanceof GraphicalColumnCellRenderer) {
            ((GraphicalColumnCellRenderer)renderer).setRamp(ramp);
        }
        this.table.setColorRamp(column, ramp);
        return true;
    }

    public ColorInterface getColorRamp(Object column) {
        if (column == null) {
            return null;
        }
        TableColumnModel tcm = this.table.getColumnModel();
        int i = tcm.getColumnIndex(column);
        if (i < 0) {
            return null;
        }
        TableColumn col = tcm.getColumn(i);
        if (col == null) {
            return null;
        }
        TableCellRenderer renderer = col.getCellRenderer();
        if (renderer instanceof FormattedColumnCellRenderer) {
            return ((FormattedColumnCellRenderer)renderer).getRamp();
        }
        if (renderer instanceof GraphicalColumnCellRenderer) {
            return ((GraphicalColumnCellRenderer)renderer).getRamp();
        }
        return null;
    }

    public boolean isMissing(int row, int column) {
        return false;
    }

    private class ScrollBarComponentListener
    implements ComponentListener {
        private ScrollBarComponentListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            GTablePanel.this.resizeColumns();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            GTablePanel.this.resizeColumns();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            GTablePanel.this.resizeColumns();
        }
    }
}

