/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.graphtable;

import com.sas.graphics.silk.graphtable.GTable;
import com.sas.graphics.silk.util.table.TableSorter;
import com.sas.graphics.silk.util.table.TableStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class GTableFilter
extends JComponent
implements TableModelListener {
    private static final long serialVersionUID = -3093265007301385105L;
    protected static final int FILTER_SUM = 0;
    protected static final int FILTER_MEAN = 1;
    protected static final int FILTER_MEDIAN = 2;
    protected static final int FILTER_MODE = 3;
    protected static final int FILTER_STD = 4;
    protected static final int FILTER_N = 5;
    protected static final int DISCRETE_LAYOUT = 1;
    protected static final int CONTINUOUS_LAYOUT = 2;
    protected int statCount = 6;
    protected String[] helpString = new String[this.statCount];
    protected GTable gTable;
    protected TableSorter model;
    protected JToggleButton sum;
    protected JToggleButton mean;
    protected JToggleButton median;
    protected JToggleButton mode;
    protected JToggleButton std;
    protected JToggleButton N;
    protected ButtonGroup summarize;
    protected JRadioButton overall;
    protected JRadioButton byVar;
    protected JComboBox byColumn;
    protected TitledBorder discreteBorder;
    protected TitledBorder continuousBorder;
    protected Border etched;
    protected String[] columnNames;
    protected String[] columnValues;
    private TableStyle style;
    SummarizeActionListener listener2 = null;

    public GTableFilter(GTable gt, TableStyle style) {
        this.style = style;
        this.setGTable(gt);
    }

    public void setGTable(GTable table) {
        this.gTable = table;
        this.model = table.getGTableModel();
        this.createLayout();
        this.createFilterDialog();
        this.updateUIColors();
        this.gTable.getGTableModel().addTableModelListener((TableModelListener)this);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    @Override
    public int getHeight() {
        return 30;
    }

    public void setStyle(TableStyle st) {
        this.style = st;
        this.updateUIColors();
    }

    private void updateUIColors() {
        int count = this.getComponentCount();
        Color back = this.style.headerBackColor;
        Color fore = this.style.headerForeColor;
        for (int i = 0; i < count; ++i) {
            Component c = this.getComponent(i);
            c.setForeground(fore);
            c.setBackground(back);
        }
    }

    protected void createLayout() {
        this.removeAll();
        int iconWt = 26;
        int iconHt = 24;
        ImageIcon icon = this.getIcon("sigma.gif");
        this.sum = new JToggleButton(icon);
        this.sum.setPreferredSize(new Dimension(iconWt, iconHt));
        icon = this.getIcon("average.gif");
        this.mean = new JToggleButton(icon);
        this.mean.setPreferredSize(new Dimension(iconWt, iconHt));
        icon = this.getIcon("median.gif");
        this.median = new JToggleButton(icon);
        this.median.setPreferredSize(new Dimension(iconWt, iconHt));
        icon = this.getIcon("mode.gif");
        this.mode = new JToggleButton(icon);
        this.mode.setPreferredSize(new Dimension(iconWt, iconHt));
        icon = this.getIcon("std.gif");
        this.std = new JToggleButton(icon);
        this.std.setPreferredSize(new Dimension(iconWt, iconHt));
        icon = this.getIcon("n.gif");
        this.N = new JToggleButton(icon);
        this.N.setPreferredSize(new Dimension(iconWt, iconHt));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.sas.graphics.silk.graphtable.GTable");
        this.helpString[0] = this.gTable.GRS(resourceBundle, "Filter.Help.Sum.txt", "Sum");
        this.helpString[1] = this.gTable.GRS(resourceBundle, "Filter.Help.Mean.txt", "Mean");
        this.helpString[2] = this.gTable.GRS(resourceBundle, "Filter.Help.Median.txt", "Median");
        this.helpString[3] = this.gTable.GRS(resourceBundle, "Filter.Help.Mode.txt", "Mode");
        this.helpString[4] = this.gTable.GRS(resourceBundle, "Filter.Help.STD.txt", "STD");
        this.helpString[5] = this.gTable.GRS(resourceBundle, "Filter.Help.N.txt", "N");
        this.sum.setToolTipText(this.helpString[0]);
        this.mean.setToolTipText(this.helpString[1]);
        this.median.setToolTipText(this.helpString[2]);
        this.mode.setToolTipText(this.helpString[3]);
        this.std.setToolTipText(this.helpString[4]);
        this.N.setToolTipText(this.helpString[5]);
        this.overall = new JRadioButton(this.gTable.GRS(resourceBundle, "Filter.Overall.txt", "Overall"));
        this.overall.setSelected(true);
        this.byVar = new JRadioButton(this.gTable.GRS(resourceBundle, "Filter.ByVariables.txt", "By variables:"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.overall);
        group.add(this.byVar);
        this.byColumn = new JComboBox();
        this.updateByColumn();
        this.byColumn.setEnabled(false);
        SummarizeItemListener listener = new SummarizeItemListener();
        this.sum.addItemListener(listener);
        this.mean.addItemListener(listener);
        this.median.addItemListener(listener);
        this.N.addItemListener(listener);
        this.mode.addItemListener(listener);
        this.std.addItemListener(listener);
        this.listener2 = new SummarizeActionListener();
        this.overall.addActionListener(this.listener2);
        this.byVar.addActionListener(this.listener2);
        this.byColumn.addActionListener(this.listener2);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.sum);
        this.add(this.mean);
        this.add(this.median);
        this.add(this.mode);
        this.add(this.std);
        this.add(this.N);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(new JLabel(this.gTable.GRS(resourceBundle, "Filter.Summarize.txt", "Summarize:")));
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.overall);
        this.add(this.byVar);
        this.add(this.byColumn);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
    }

    protected synchronized void updateByColumn() {
        if (this.byColumn != null) {
            this.byColumn.removeActionListener(this.listener2);
            String s = null;
            if (this.byColumn.getSelectedItem() != null) {
                s = this.byColumn.getSelectedItem().toString();
            }
            this.byColumn.removeAllItems();
            for (int i = 0; i < this.model.getModel().getColumnCount(); ++i) {
                int visIdx = this.model.getColumnIndexInVisibleModel(i + this.model.getMetaColumnCount());
                if (visIdx < 0 || this.model.getModel().getColumnClass(i) != String.class) continue;
                this.byColumn.addItem(this.model.getModel().getColumnName(i));
            }
            if (s != null) {
                this.byColumn.setSelectedItem(s);
            }
            this.byColumn.addActionListener(this.listener2);
        }
    }

    protected void createFilterDialog() {
        this.columnNames = new String[this.model.getColumnCount() - this.model.getMetaColumnCount()];
        for (int i = this.model.getMetaColumnCount(); i < this.model.getColumnCount(); ++i) {
            this.columnNames[i - this.model.getMetaColumnCount()] = this.model.getColumnName(i);
        }
        this.etched = BorderFactory.createEtchedBorder();
    }

    protected ImageIcon getIcon(String filename) {
        String resource = "res/";
        URL url = GTableFilter.class.getResource(resource + filename);
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        return new ImageIcon(image);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateByColumn();
    }

    class SummarizeActionListener
    implements ActionListener {
        SummarizeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == GTableFilter.this.overall) {
                GTableFilter.this.byColumn.setEnabled(false);
                GTableFilter.this.model.setByVariable(null);
            } else if (source == GTableFilter.this.byVar) {
                GTableFilter.this.byColumn.setEnabled(true);
                GTableFilter.this.model.setByVariable((String)GTableFilter.this.byColumn.getSelectedItem());
            } else if (source == GTableFilter.this.byColumn) {
                String item = (String)((JComboBox)source).getSelectedItem();
                GTableFilter.this.model.setByVariable(item);
            }
        }
    }

    class SummarizeItemListener
    implements ItemListener {
        SummarizeItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            int select = e.getStateChange();
            int type = -1;
            if (source == GTableFilter.this.sum) {
                type = 0;
            } else if (source == GTableFilter.this.mean) {
                type = 1;
            } else if (source == GTableFilter.this.median) {
                type = 2;
            } else if (source == GTableFilter.this.mode) {
                type = 3;
            } else if (source == GTableFilter.this.N) {
                type = 5;
            } else if (source == GTableFilter.this.std) {
                type = 4;
            }
            if (select == 1) {
                GTableFilter.this.model.showSummary(type);
            } else {
                GTableFilter.this.model.hideSummary(type);
            }
        }
    }

    class ValueListModel
    implements ListModel {
        String[] values;

        ValueListModel(String[] v) {
            this.values = v;
        }

        public Object getElementAt(int index) {
            return this.values[index];
        }

        @Override
        public int getSize() {
            return this.values.length;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

