/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.graphtable;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class ColumnCellRenderer
extends DefaultTableCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = 18922724826511105L;
    public static final int HEADER_NULL = 0;
    public static final int HEADER_ASCENDING = 1;
    public static final int HEADER_DESCENDING = 2;
    private ImageIcon icon = null;
    private ImageIcon ascendingIcon = null;
    private ImageIcon descendingIcon = null;
    private static int count = 0;

    public ColumnCellRenderer() {
        ++count;
    }

    public ColumnCellRenderer(ImageIcon aIcon, ImageIcon dIcon) {
        this();
        this.ascendingIcon = aIcon;
        this.descendingIcon = dIcon;
        this.setHorizontalTextPosition(2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setIcon(this.icon);
        this.setHorizontalAlignment(2);
        this.setHorizontalAlignment(0);
        return this;
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
    }

    public void setState(int column, int state) {
        this.icon = state == 0 ? null : (state == 1 ? this.ascendingIcon : this.descendingIcon);
    }
}

