/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.fstree;

import com.sas.graphics.util.AboutFrame;
import com.sas.graphics.util.SASIcon;
import com.sas.graphics.util.nld.NLDLink;
import com.sas.graphics.util.nld.NLDModel;
import com.sas.graphics.util.nld.NLDMouseFrame;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDViewer;
import com.sas.graphics.util.nld.VectorLinkModel;
import com.sas.graphics.util.nld.VectorNodeModel;
import com.sas.graphics.util.nld.XMLModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.Scrollable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSTreeViewer
extends NLDViewer
implements Scrollable {
    private static final long serialVersionUID = -3893337408277297625L;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private final int scrollSize = 25;
    private JMenuItem open = null;
    private JCheckBoxMenuItem selN = null;
    private JCheckBoxMenuItem selT = null;
    private JCheckBoxMenuItem hideT = null;
    private JMenu reconciliation = null;
    private JMenuItem moveUp = null;
    private JMenuItem moveDown = null;
    private JMenuItem undo = null;
    private JMenuItem[] csm = null;
    private JPopupMenu popup = null;
    private JRadioButtonMenuItem[] blm = null;
    private boolean handlePopup = true;
    private Color nodeBorderColor = new Color(97, 115, 169);
    private Color rootColor = new Color(204, 226, 139);
    private String buildDate = "0000.0000";
    private boolean orthogonalLinks = false;
    private static NLDNode DUMMY = new NLDNode();
    private boolean centerAlgo = false;
    private boolean nodeSizeFixed = true;
    private HashSet[] reconciliationNodesList = null;
    private HashSet[] savedReconciliationNodesList = null;
    private Vector[] reconNodeOrder = null;
    private int reconciliationIndex = -1;
    private Collection reconciliationNodes = null;
    private Color reconciliationLineColor = Color.blue;
    private float reconLineWidth = 2.0f;
    private Color reconAreaColor = new Color(255, 255, 192);
    private Color nonReconAreaColor = Color.white;
    private boolean outlineReconNodes = true;
    private boolean listCreated = false;
    private static final long nodelist = 11L;
    private static final long linklist = 12L;
    private static final long reconciliation1list = 13L;
    private static final long reconciliation2list = 14L;
    private static final int UNDO_LIMIT = 3;
    private Vector reconLineHistory = null;
    private Object lock = new Object();
    private Vector[] kids = null;
    private TreeSet[] viskids;
    private int[] parent = null;
    private int[] depth = null;
    private int maxDepth = 0;
    protected int root = -1;
    private NLDNode rootNode = null;
    private int defRoot = -1;
    private NLDNode defRootNode = null;
    protected Object context = null;
    private Vector origCollapsedNodes = null;
    Vector nodeOrder = new Vector();
    int[] numDummies;
    int[] numBranches;
    int width;
    int height;
    private double vgap = 0.0;
    boolean first = true;
    public boolean redoBars = false;
    int worldHT = 0;
    double fontSize;
    double[] maxHeight;
    double[] totalWidth;
    double[] vspaces;
    double[] widthFactor;
    double[] maxW;
    int minLoc = 0;
    double maxTotalWidth;
    double maxLabelWidth;
    double vpadding = 0.0;
    int totalDepth = 0;
    Point origin = new Point();
    private static final int RIGHT = 2;
    private static final int LEFT = 1;
    private static final int TOP = 3;
    private static final int BOTTOM = 4;
    private int[] dummyNodesInLayer;
    private int[] actualNodesInLayer;
    double[] widthRatio;
    double[] minLeft;

    public FSTreeViewer() {
        this.setInitialValues();
    }

    public FSTreeViewer(NLDModel m) {
        this.model = m;
        this.setInitialValues();
    }

    private void setInitialValues() {
        this.showLabels = true;
        this.lens = true;
        this.JXDspread = false;
        this.textBorderType = 3;
        this.setTextBorderType(3);
        this.iconType = 0;
        this.backborder = true;
        this.setTextValign(1);
        this.setHalign(1);
        this.setDoubleBuffered(true);
        this.rbstr = "com.sas.graphics.silk.orgchart.fsviewer";
        try {
            this.appRB = ResourceBundle.getBundle(this.rbstr);
        }
        catch (MissingResourceException e) {
            this.appRB = null;
        }
        catch (ClassCastException e) {
            this.appRB = null;
        }
        this.setRBString(this.rbstr);
        if (this.model != null) {
            this.model.setHideLinks(false);
            this.model.setChartType(4);
        }
        this.linkColor = new Color(190, 200, 180);
        this.reconLineHistory = new Vector(3);
    }

    public void copy(NLDViewer viewer) {
        super.copy(viewer);
    }

    protected void createChannel() {
        super.createChannel();
        if (this.channel != null) {
            this.setLens(this.lens);
            if (this.orthogonalLinks) {
                this.channel.glEnable(8);
            } else {
                this.channel.glDisable(8);
            }
            if (this.nodeSizeFixed) {
                this.channel.glEnable(6);
            }
        }
    }

    public JPopupMenu getDefaultPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        String[] menlabs = new String[]{this.GRS("PopupMenu.DWG.ResetView.notrans", "Reset View"), this.GRS("PopupMenu.DWG.ResetReconciliation.notrans", "Reset Reconciliation Line"), this.GRS("PopupMenu.DWG.Select.notrans", "Select..."), this.GRS("PopupMenu.DWG.SelectAll.notrans", "Select All"), this.GRS("PopupMenu.DWG.ShowAll.notrans", "Show All Nodes")};
        String[] commands = new String[]{"reset", "resetReconciliation", "filter", "selAll", "showAll"};
        this.AddToMenu(popup, menlabs[0], commands[0], (ActionListener)((Object)this));
        this.AddToMenu(popup, menlabs[2], commands[2], (ActionListener)((Object)this));
        this.AddToMenu(popup, menlabs[3], commands[3], (ActionListener)((Object)this));
        this.AddToMenu(popup, menlabs[4], commands[4], (ActionListener)((Object)this));
        popup.addSeparator();
        this.reconciliation = new JMenu(this.GRS("PopupMenu.CS.ReconciliationLine.notrans", "Reconciliation Line"));
        if (this.reconciliation != null) {
            popup.add(this.reconciliation);
            this.reconciliation.setName("reconciliation");
            this.moveUp = new JMenuItem(this.GRS("PopupMenu.CS.MoveUp.notrans", "Move Up"));
            if (this.moveUp != null) {
                this.moveUp.setActionCommand("moveUp");
                this.moveUp.addActionListener((ActionListener)((Object)this));
                this.reconciliation.add(this.moveUp);
            }
            if ((this.moveDown = new JMenuItem(this.GRS("PopupMenu.CS.MoveDown.notrans", "Move Down"))) != null) {
                this.moveDown.setActionCommand("moveDown");
                this.moveDown.addActionListener((ActionListener)((Object)this));
                this.reconciliation.add(this.moveDown);
            }
            if ((this.undo = new JMenuItem(this.GRS("PopupMenu.Undo.notrans", "Undo"))) != null) {
                this.undo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FSTreeViewer.this.Undo();
                    }
                });
                this.reconciliation.add(this.undo);
            }
        }
        if (this.applet != null) {
            this.open = this.AddToMenu(popup, this.GRS("PopupMenu.CS.OpenURL.notrans", "Open URL"), "open", (ActionListener)((Object)this), false);
        }
        this.selN = this.AddOnOffToMenu(popup, this.GRS("PopupMenu.CS.SelectNode.notrans", "Select node"), "selN", false, (ItemListener)((Object)this), true);
        this.selT = this.AddOnOffToMenu(popup, this.GRS("PopupMenu.CS.SelectSubtree.notrans", "Select subtree"), "selT", false, (ItemListener)((Object)this), true);
        this.hideT = this.AddOnOffToMenu(popup, this.GRS("PopupMenu.CS.HideSubtree.notrans", "Hide subtree"), "hideT", false, (ItemListener)((Object)this), true);
        JMenuItem[] list = this.applet != null ? new JMenuItem[]{this.open, this.selN, this.selT, this.hideT} : new JMenuItem[]{this.selN, this.selT, this.hideT};
        this.csm = list;
        return popup;
    }

    private void Undo() {
        if (this.reconciliationNodesList == null || this.reconciliationNodesList[0] == null) {
            return;
        }
        if (this.reconLineHistory.size() == 0) {
            return;
        }
        HashSet reconNodes = (HashSet)this.reconLineHistory.elementAt(this.reconLineHistory.size() - 1);
        this.reconLineHistory.remove(this.reconLineHistory.size() - 1);
        this.reconciliationNodesList[0] = reconNodes;
        this.findReconciliationLinePath();
        this.build();
        this.repaint();
    }

    private void saveReconLine() {
        if (this.reconciliationNodesList == null || this.reconciliationNodesList[0] == null) {
            return;
        }
        if (this.reconLineHistory.size() == 3) {
            this.reconLineHistory.remove(0);
        }
        HashSet reconNodes = new HashSet(this.reconciliationNodesList[0]);
        this.reconLineHistory.add(reconNodes);
    }

    public synchronized void mousePressed(MouseEvent e) {
        if (this.preMousePressed(e)) {
            // empty if block
        }
        this.postMousePressed(e);
    }

    protected boolean preMousePressed(MouseEvent e) {
        if (!this.ready) {
            return false;
        }
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger()) {
            if (this.popup == null) {
                this.popup = this.getDefaultPopupMenu();
            }
            this.setPopupLabels();
            this.popup.show(e.getComponent(), x, y);
        }
        this.pressX = this.prevx = x;
        this.pressY = this.prevy = y;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postMousePressed(MouseEvent e) {
        boolean doubleClick = e.getClickCount() > 1;
        int x = e.getX();
        int y = e.getY();
        Object o = null;
        if (!doubleClick) {
            this.context = o = this.pick(x, y);
        }
        int mods = e.getModifiers();
        Object object = this.lock;
        synchronized (object) {
            if ((mods & 1) != 0) {
                this.extsel = true;
            }
            this.drag = false;
            this.lastPressNLDNode = this.pressNLDNode;
            this.pressNLDNode = null;
            if (o instanceof NLDNode) {
                this.pressNLDNode = (NLDNode)o;
                if (this.handleSelected) {
                    this.pressNLDNode = null;
                }
            }
            if (this.extsel) {
                if ((mods & 2) != 0) {
                    this.movenode = true;
                    this.nodeMoved = true;
                } else {
                    this.select = true;
                }
            } else {
                this.pan = true;
            }
        }
    }

    public synchronized void mouseReleased(MouseEvent e) {
        boolean doubleClick;
        if (!this.ready) {
            return;
        }
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus("");
        }
        int x = e.getX();
        int y = e.getY();
        boolean bl = doubleClick = e.getClickCount() > 1;
        if (doubleClick) {
            this.openURL();
            return;
        }
        if (e.isPopupTrigger()) {
            if (this.handlePopup) {
                if (this.popup == null) {
                    Object saveContext = this.context;
                    this.popup = this.getDefaultPopupMenu();
                    this.context = saveContext;
                }
                this.setPopupLabels();
                this.popup.show(e.getComponent(), x, y);
            }
            return;
        }
        if (!this.drag && !this.extsel) {
            if (Math.abs(x - this.pressX) > 3 || Math.abs(y - this.pressY) > 3) {
                return;
            }
            Object o = this.pick(x, y);
            NLDNode relNLDNode = null;
            if (o instanceof NLDNode) {
                relNLDNode = (NLDNode)o;
            }
            if (relNLDNode == null || relNLDNode != this.pressNLDNode) {
                if (!doubleClick && !this.deselAll) {
                    this.model.deselectAll();
                    this.deselAll = true;
                    this.build();
                    this.repaint();
                    this.resetFlags();
                }
                this.showBackgroundURL(x, y);
            }
            return;
        }
        if (this.select || this.extsel) {
            this.channel.glRenderMode(1);
            if (this.drag) {
                int x1 = Math.min(x, this.prevx);
                int dx = Math.abs(x - this.prevx);
                int y1 = Math.min(y, this.prevy);
                int dy = Math.abs(y - this.prevy);
                this.channel.setPickAllHits(true);
                this.channel.gluPickMatrix(x1, y1, dx, dy);
                Stack hit = new Stack();
                this.channel.glSelectBuffer(hit);
                this.channel.glCallList(this.displist, true);
                this.channel.glRenderMode(0);
                this.channel.setPickAllHits(false);
                while (!hit.empty()) {
                    String name = (String)hit.pop();
                    if (name.equals("")) continue;
                    int index = new Integer(name.substring(1));
                    if (name.charAt(0) != 'N') continue;
                    this.model.nodes.setSelected(index, true);
                }
            } else {
                String name;
                int x1 = x;
                int y1 = y;
                int dy = 3;
                int dx = 3;
                this.channel.gluPickMatrix(x1, y1, dx, dy);
                Stack hit = new Stack();
                this.channel.glSelectBuffer(hit);
                this.channel.glCallList(this.displist, true);
                this.channel.glRenderMode(0);
                if (!hit.empty() && !(name = (String)hit.pop()).equals("")) {
                    int index = new Integer(name.substring(1));
                    if (name.charAt(0) == 'N') {
                        boolean newState;
                        boolean bl2 = newState = !this.model.nodes.isSelected(index);
                        if (!this.extsel && !this.deselAll) {
                            this.model.deselectAll();
                        }
                        this.model.nodes.setSelected(index, newState);
                    }
                }
            }
            this.build();
            this.repaint();
            this.deselAll = false;
            this.resetFlags();
            return;
        }
    }

    public synchronized void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equalsIgnoreCase("hp_Applet")) {
            String title = this.GRS("AboutDialog.TitleText.notrans", "SAS/GRAPH\u00ae 9.1 FlatTreeView Applet");
            String version = null;
            if (this.aboutFrame == null) {
                if (this.sasIcon == null) {
                    this.sasIcon = new SASIcon((Component)((Object)this));
                }
                this.aboutFrame = new AboutFrame((Object)this.appRB, this.sasIcon, title, version, this.buildDate, this.useRBsizing);
            }
            if (!this.useRBsizing) {
                this.aboutFrame.setSize(350, 500);
            }
            this.aboutFrame.setVisible(true);
            this.aboutFrame.toFront();
            return;
        }
        if (command.equalsIgnoreCase("hp_Help")) {
            try {
                URL url = new URL(this.applet.getDocumentBase(), this.helpUrlString);
                this.applet.getAppletContext().showDocument(url, this.urlTarget);
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
            return;
        }
        if (command.equalsIgnoreCase("hp_Mouse")) {
            String title = this.GRS("MouseDialog.Title.notrans", "Mouse Help");
            if (this.mouseFrame == null) {
                String[] mouseActions = new String[]{this.GRS("MouseDialog.Key0.notrans", "MOVE = Probe"), this.GRS("MouseDialog.Key1.notrans", "CLICK (a node) = Brings the node to center"), this.GRS("MouseDialog.Key2.notrans", "CLICK (outside a node) = Unselect all nodes"), this.GRS("MouseDialog.Key3.notrans", "Shift + CLICK (a node) = Sel/Unsel the node"), this.GRS("MouseDialog.Key4.notrans", "Shift + DRAG = Select all nodes inside the region"), this.GRS("MouseDialog.Key5.notrans", "Shift + CTRL + DRAG = Move selected node(s)"), this.GRS("MouseDialog.Key6.notrans", "DRAG = Panning/Shifting the focus"), this.GRS("MouseDialog.Key7.notrans", "CTRL + DRAG = Zoom"), this.GRS("MouseDialog.Key8.notrans", "ALT + DRAG = Rotate (About root)"), this.GRS("MouseDialog.Key9.notrans", "CTRL + ALT + DRAG = Change Angular Spread"), this.GRS("MouseDialog.Key10.notrans", "RIGHT = Popup Menu")};
                this.mouseFrame = new NLDMouseFrame(this.appRB, title, mouseActions, this.useRBsizing);
            }
            if (!this.useRBsizing) {
                this.mouseFrame.setSize(350, 280);
            }
            this.mouseFrame.setVisible(true);
            this.mouseFrame.toFront();
            return;
        }
        if (command.equalsIgnoreCase("hp_SAS")) {
            try {
                URL url = new URL(this.applet.getDocumentBase(), "http://www.sas.com");
                this.applet.getAppletContext().showDocument(url, this.urlTarget);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return;
        }
        if (command.equals("reset")) {
            this.reset();
        } else if (command.equalsIgnoreCase("showAll")) {
            this.showAll();
        } else if (command.equalsIgnoreCase("resetRoot")) {
            this.setRoot(this.defRootNode, true);
        } else if (command.equalsIgnoreCase("setRoot")) {
            if (this.context instanceof NLDNode) {
                this.setRoot((NLDNode)this.context, false);
            }
        } else if (command.equals("selAll")) {
            this.selectAll();
        } else if (command.equals("filter")) {
            this.filter();
        } else if (command.equals("moveUp")) {
            if (this.context instanceof NLDNode) {
                this.moveUp((NLDNode)this.context);
            }
        } else if (command.equals("moveDown")) {
            if (this.context instanceof NLDNode) {
                this.moveDown((NLDNode)this.context);
            }
        } else if (command.equalsIgnoreCase("resetReconciliation")) {
            this.resetReconciliation();
        } else {
            this.openURL();
        }
        this.context = null;
    }

    public void setBL(JRadioButtonMenuItem src) {
        for (int i = 0; i < this.blm.length; ++i) {
            if (!src.equals(this.blm[i])) continue;
            this.setTextBorderType(i);
            this.build();
            this.repaint();
            break;
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        String cmd;
        Object obj = evt.getSource();
        if (obj == null) {
            return;
        }
        if (obj instanceof JRadioButtonMenuItem) {
            JRadioButtonMenuItem radio = (JRadioButtonMenuItem)obj;
            cmd = radio.getActionCommand();
            if (cmd.equals("setBL")) {
                this.setBL(radio);
            }
            this.context = null;
        }
        if (obj instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem cmi = (JCheckBoxMenuItem)obj;
            cmd = cmi.getActionCommand();
            if (cmd.equals("hideT")) {
                this.hideSubtree(cmi.getState());
            } else {
                this.selectSubtree(cmd.equals("selT"), cmi.getState(), true);
            }
            this.context = null;
        }
    }

    public void reset() {
        boolean build = false;
        int originY = this.origin.y;
        this.resetOrigin();
        if (!this.isDeselectAll()) {
            this.model.deselectAll();
            this.setDeselectAll(true);
            build = true;
        }
        if (this.isNodeMoved()) {
            this.arrange();
            build = true;
        }
        if (build) {
            this.build();
        }
        this.resetView();
        if (originY != this.origin.y) {
            this.changeSupport.firePropertyChange("adjustYValue", new Integer(originY), new Integer(-this.origin.y));
        }
        this.repaint();
    }

    public void showAll() {
        VectorNodeModel nodes = this.model.nodes;
        nodes.setShowAll();
        this.analyze();
        this.rearrange();
        if (this.worldHT < this.compHeight) {
            this.changeSupport.firePropertyChange("resize", null, new Integer(1));
        }
    }

    private void hideSubtree(boolean state) {
        if (this.context == null || !(this.context instanceof NLDNode)) {
            return;
        }
        this.hideSubtree(this.context, state);
    }

    public void hideSubtree(Object id, boolean state) {
        NLDNode n = null;
        n = id instanceof NLDNode ? (NLDNode)id : this.model.nodes.getNode(id);
        if (n == null) {
            return;
        }
        this.hideSubtree(n.getIndex(), state);
        this.model.nodes.setVisible(n.getIndex(), true);
        this.rearrange();
    }

    private void selectSubtree(boolean tree, boolean state, boolean update) {
        if (this.context == null || !(this.context instanceof NLDNode)) {
            return;
        }
        this.setSelected((NLDNode)this.context, tree, state, update);
    }

    public void setSelected(Object id, boolean tree, boolean state, boolean update) {
        NLDNode n = null;
        n = id instanceof NLDNode ? (NLDNode)id : this.model.nodes.getNode(id);
        if (n == null) {
            return;
        }
        this.setSelected(n, tree, state, update);
    }

    public void setCenterNode(Object id) {
        NLDNode n = null;
        n = id instanceof NLDNode ? (NLDNode)id : this.model.nodes.getNode(id);
        if (n == null) {
            return;
        }
        this.centerNode(n, false);
    }

    public void rebuild() {
        this.build();
        this.repaint();
    }

    public void setSelectCenter(Object id, boolean animate) {
        NLDNode n = null;
        n = id instanceof NLDNode ? (NLDNode)id : this.model.nodes.getNode(id);
        if (n == null) {
            return;
        }
        this.setSelected(id, true);
        this.deselAll = false;
        this.build();
        if (animate) {
            this.centerNode(n, false);
        } else {
            this.centerNode(n);
        }
    }

    public Object pick(int x, int y) {
        this.context = super.pick(x, y, 11L);
        return this.context;
    }

    public boolean isSubtreeSelected(Object obj) {
        NLDNode n = this.getNode(obj);
        return this.isSubtreeSelected(n.getIndex());
    }

    public boolean isRootDefault() {
        return this.root == this.defRoot;
    }

    private void setSelected(NLDNode n, boolean tree, boolean state, boolean update) {
        this.setSelected(n, state);
        if (state) {
            this.setDeselectAll(false);
        }
        if (tree) {
            int i = n.getIndex();
            int nk = this.kids[i].size();
            for (int k = 0; k < nk; ++k) {
                NLDNode kid = (NLDNode)this.kids[i].elementAt(k);
                if (this.parent[kid.getIndex()] != i) continue;
                this.setSelected(kid, true, state, false);
            }
        }
        if (update) {
            this.build();
            this.repaint();
        }
    }

    public void load() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setBounds(this.getBounds());
        this.numNodes = this.model.getNumNodes();
        this.numLinks = this.model.getNumLinks();
        if (this.numNodes == 0 && this.numLinks == 0) {
            Document doc;
            NodeList elems;
            boolean ok = this.model.loadModel((NLDViewer)this);
            if (!ok) {
                this.numLinks = 0;
                this.numNodes = 0;
                this.setCursor(Cursor.getDefaultCursor());
                this.emptyPlot = true;
                if (this.applet != null) {
                    this.applet.getAppletContext().showStatus("");
                }
                return;
            }
            this.numNodes = this.model.getNumNodes();
            this.numLinks = this.model.getNumLinks();
            if (this.numNodes <= 0) {
                this.emptyPlot = true;
                return;
            }
            this.emptyPlot = false;
            if (this.model instanceof XMLModel && (elems = (doc = ((XMLModel)this.model).getDocument()).getElementsByTagName("ReferenceLine")) != null) {
                int num = elems.getLength();
                this.reconciliationNodesList = new HashSet[num];
                this.savedReconciliationNodesList = new HashSet[num];
                for (int i = 0; i < num; ++i) {
                    this.reconciliationNodesList[i] = new HashSet();
                    Element elem = (Element)elems.item(i);
                    NodeList nodes = elem.getElementsByTagName("node");
                    int count = nodes.getLength();
                    for (int j = 0; j < count; ++j) {
                        Node node = nodes.item(j).getFirstChild();
                        if (node == null) continue;
                        this.reconciliationNodesList[i].add(this.model.nodes.getNode((Object)node.getNodeValue().trim()));
                    }
                    this.savedReconciliationNodesList[i] = new HashSet(this.reconciliationNodesList[i]);
                }
            }
        }
        this.enhance();
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.Processing.notrans", "Processing tree..."));
        }
        this.analyze();
        this._setInitialState();
        this.arrange();
        this.setNodeHandles();
        this.setNodeAttr();
        this.setArcAttr();
        this.setTreeArcs();
        for (int i = 0; i < this.numNodes; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            if (n.getColor() != null) continue;
            if (this.parent[n.getIndex()] == -1) {
                n.setColor(this.rootColor);
                this.setNodeBorderColor(n, Color.black);
                continue;
            }
            n.setColor(this.nodeColor);
            this.setNodeBorderColor(n, this.nodeBorderColor);
        }
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.Drawing.notrans", "Drawing tree..."));
        }
        if (this.applet != null) {
            this.document = this.applet.getDocumentBase();
            this.code = this.applet.getCodeBase();
            this.applet.getAppletContext().showStatus("");
        }
        if (this.DEBUG) {
            System.out.println(this.GRS("StatusText.NumberOfNodes.notrans", "number of nodes=") + this.numNodes);
        }
        this.build();
        this.repaint();
        this.setCursor(Cursor.getDefaultCursor());
        this.ready = true;
    }

    private void _hideSubtree(int index) {
        this.model.nodes.setVisible(index, false);
        this.model.nodes.setCollapsed(index, true);
        int nk = this.kids[index].size();
        if (nk == 0) {
            return;
        }
        for (int k = 0; k < nk; ++k) {
            int ki = ((NLDNode)this.kids[index].elementAt(k)).getIndex();
            this._hideSubtree(ki);
        }
    }

    private void _setInitialState() {
        int i;
        VectorNodeModel nodes = this.model.nodes;
        this.selectColor = Color.red;
        boolean fillNodes = false;
        if (this.origCollapsedNodes == null) {
            this.origCollapsedNodes = new Vector();
            fillNodes = true;
        }
        this.model.links.setShowAll();
        for (i = 0; i < this.numNodes; ++i) {
            this.viskids[i].clear();
            if (!nodes.isVisible(i)) continue;
            if (nodes.isCollapsed(i)) {
                if (fillNodes) {
                    this.origCollapsedNodes.add(new Integer(i));
                }
                this._hideSubtree(i);
                nodes.setVisible(i, true);
                continue;
            }
            for (int j = 0; j < this.kids[i].size(); ++j) {
                NLDNode kid = (NLDNode)this.kids[i].elementAt(j);
                if (!kid.isVisible()) continue;
                this.viskids[i].add(kid);
            }
        }
        for (i = 0; i < this.numNodes; ++i) {
            this.depth[i] = -1;
        }
        this.maxDepth = 0;
        this.setDepth(this.root, 0);
        if (this.DEBUG) {
            System.out.println(this.GRS("StatusText.maxDepth.notrans", "max depth=") + this.maxDepth);
        }
        int tot = this.getLeaves(this.root);
        if (this.DEBUG) {
            System.out.println(this.GRS("StatusText.totalLeaves.notrans", "total leaves=") + tot);
        }
        double zoomfac = Math.min(1.0, Math.max(1.0E-8, 30.0 / Math.sqrt(tot)));
        this.setDefaultZoom(zoomfac);
        if (this.centerAlgo) {
            int i2;
            if (this.actualNodesInLayer == null) {
                this.actualNodesInLayer = new int[this.maxDepth + 1];
                this.dummyNodesInLayer = new int[this.maxDepth + 1];
            }
            for (i2 = 0; i2 <= this.maxDepth; ++i2) {
                this.actualNodesInLayer[i2] = 0;
                this.dummyNodesInLayer[i2] = 0;
            }
            for (i2 = 0; i2 < this.numNodes; ++i2) {
                NLDNode n = (NLDNode)nodes.elementAt(i2);
                if (!n.isVisible()) continue;
                int n2 = this.depth[i2];
                this.actualNodesInLayer[n2] = this.actualNodesInLayer[n2] + 1;
                if (this.viskids[i2].size() != 0) continue;
                int j = this.depth[i2] + 1;
                while (j <= this.maxDepth) {
                    int n3 = j++;
                    this.dummyNodesInLayer[n3] = this.dummyNodesInLayer[n3] + 1;
                }
            }
        }
    }

    private void setNodeAttr() {
        double[] minmax = this.computeMinMaxColorValues(0);
        for (int i = 0; i < this.numNodes; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            n.setType(6);
            if (n.getColor() == null) {
                if (minmax[0] == minmax[1]) {
                    n.setColor(this.nodeColor);
                    this.setNodeBorderColor(n, this.nodeBorderColor);
                } else {
                    double cval = n.getColorValue();
                    cval = (cval - minmax[0]) / (minmax[1] - minmax[0]);
                    n.setColor(this.colmap(cval));
                }
            }
            n.setShowLabel(this.showLabels);
            n.setTextColor(this.textColor);
            if (n.getLabel() != null) continue;
            n.setLabel(" ");
        }
    }

    private void setNodeHandles() {
        for (int i = 0; i < this.numNodes; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            n.setHandle(this.kids[i].size() > 0 && this.isSubtreeHidden(i));
        }
    }

    private void setTreeArcs() {
        Vector<double[]> points = new Vector<double[]>();
        for (int i = 0; i < this.numLinks; ++i) {
            NLDLink a = (NLDLink)this.model.links.elementAt(i);
            NLDNode from = (NLDNode)this.model.nodes.elementAt(a.getFromIndex());
            NLDNode to = (NLDNode)this.model.nodes.elementAt(a.getToIndex());
            if (!from.isVisible() || !to.isVisible()) continue;
            int level = this.depth[a.getFromIndex()];
            points = new Vector();
            double[] p1 = from.getLocation(this.channel, this.handleType, this.iconType);
            double[] p2 = to.getLocation(this.channel, this.handleType, this.iconType);
            p1[1] = p1[1] - this.maxHeight[level] / 2.0;
            p2[1] = p2[1] + this.maxHeight[level + 1] / 2.0;
            points.addElement(p1);
            points.addElement(p2);
            a.setPoints(points);
        }
    }

    private void findReconciliationLinePath() {
        this.createReconciliationNodesList();
        if (this.reconciliationNodesList == null || this.reconciliationNodesList.length == 0) {
            return;
        }
        if (this.reconNodeOrder != null) {
            for (int i = 0; i < this.reconNodeOrder.length; ++i) {
                this.reconNodeOrder[i].removeAllElements();
            }
        }
        this.findReconciliationLinePath(this.rootNode, 0, null);
    }

    private void findReconciliationLinePath(NLDNode curNode, int level, HashMap excludeList) {
        Iterator<Object> iter;
        Collection vals;
        if (this.reconciliationNodesList == null || this.reconciliationNodesList.length == 0) {
            return;
        }
        if (this.reconNodeOrder == null) {
            this.reconNodeOrder = new Vector[this.reconciliationNodesList.length];
        }
        int index = curNode.getIndex();
        HashMap childrensExcludeList = new HashMap();
        if (excludeList != null && excludeList.size() > 0 && (vals = excludeList.values()) != null && (iter = vals.iterator()) != null) {
            while (iter.hasNext()) {
                Object o = iter.next();
                childrensExcludeList.put(o, o);
            }
        }
        for (int i = 0; i < this.reconciliationNodesList.length; ++i) {
            if (excludeList != null && excludeList.get(new Integer(i)) != null || this.reconciliationNodesList[i] == null || !this.reconciliationNodesList[i].contains(curNode)) continue;
            if (this.reconNodeOrder[i] == null) {
                this.reconNodeOrder[i] = new Vector();
            }
            this.reconNodeOrder[i].addElement(curNode);
            Integer idx = new Integer(i);
            childrensExcludeList.put(idx, idx);
        }
        int numkids = this.viskids[index].size();
        if (numkids == 0) {
            return;
        }
        iter = this.viskids[index].iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                NLDNode kid = (NLDNode)iter.next();
                this.findReconciliationLinePath(kid, level + 1, childrensExcludeList);
            }
        }
    }

    private void setArcAttr() {
        double[] minmax = this.computeMinMaxColorValues(1);
        if (minmax[0] == minmax[1]) {
            this.setColorMappingLinks(false);
        }
        for (int i = 0; i < this.numLinks; ++i) {
            NLDLink a = (NLDLink)this.model.links.elementAt(i);
            if (a.getColor() != null) continue;
            if (minmax[0] == minmax[1]) {
                a.setColor(this.linkColor);
                continue;
            }
            double cval = a.getColorValue();
            cval = (cval - minmax[0]) / (minmax[1] - minmax[0]);
            a.setColor(this.colmap(cval));
        }
    }

    private void resetArcAttr() {
        this.showAllLinks();
    }

    private void enhance() {
        int i;
        VectorLinkModel links = this.model.links;
        this.kids = new Vector[this.numNodes];
        this.parent = new int[this.numNodes];
        for (int i2 = 0; i2 < this.numNodes; ++i2) {
            this.kids[i2] = new Vector();
            this.parent[i2] = -1;
        }
        for (i = 0; i < this.numLinks; ++i) {
            NLDLink a = (NLDLink)links.elementAt(i);
            if (!a.isVisible()) continue;
            int to = a.getToIndex();
            int from = a.getFromIndex();
            if (to < 0 || from < 0 || to >= this.numNodes || from >= this.numNodes || this.parent[to] >= this.numNodes || this.parent[from] >= this.numNodes || to == from) {
                a.setCulled(true);
                if (!this.DEBUG) continue;
                System.out.println(this.GRS("StatusText.linkFrom.notrans", "Link from ") + from + this.GRS("StatusText.to.notrans", " to ") + to + this.GRS("StatusText.isIgnored1.notrans", " is invalid and therefore ignored."));
                continue;
            }
            if (this.parent[to] == -1) {
                int anchester = from;
                boolean cycle = false;
                while (!cycle && this.parent[anchester] != -1) {
                    if (this.parent[anchester] == to) {
                        cycle = true;
                        continue;
                    }
                    anchester = this.parent[anchester];
                }
                if (cycle) {
                    if (this.DEBUG) {
                        System.out.println(this.GRS("StatusText.linkFrom.notrans", "Link from ") + from + this.GRS("StatusText.to.notrans", " to ") + to + this.GRS("StatusText.isIgnored2.notrans", " creates cycle and therefore ignored."));
                    }
                    a.setCulled(true);
                    continue;
                }
                this.parent[to] = from;
                this.kids[from].addElement(this.model.nodes.elementAt(to));
                continue;
            }
            if (this.DEBUG) {
                System.out.println(this.GRS("StatusText.linkFrom.notrans", "Link from ") + from + this.GRS("StatusText.to.notrans", " to ") + to + this.GRS("StatusText.isIgnored3.notrans", " creates multiple parents for ") + to + this.GRS("StatusText.isIgnored4.notrans", " and therefore ignored."));
            }
            a.setCulled(true);
        }
        this.viskids = new TreeSet[this.numNodes];
        for (i = 0; i < this.numNodes; ++i) {
            this.viskids[i] = new TreeSet();
            for (int j = 0; j < this.kids[i].size(); ++j) {
                NLDNode n = (NLDNode)this.kids[i].elementAt(j);
                if (!n.isVisible()) continue;
                if (this.isSubtreeHidden(n.getIndex())) {
                    this.hideSubtree(n.getIndex(), true);
                }
                n.setVisible(true);
                this.viskids[i].add(n);
            }
        }
    }

    private void arrangeNodesInOrder(NLDNode start, int level) {
        Vector v = (Vector)this.nodeOrder.get(level);
        v.add(start);
        if (level == this.maxDepth) {
            return;
        }
        int index = start.getIndex();
        int nkids = this.viskids[index].size();
        if (nkids == 0) {
            int i = level + 1;
            while (i <= this.maxDepth) {
                ((Vector)this.nodeOrder.get(i)).add(DUMMY);
                int n = i++;
                this.numDummies[n] = this.numDummies[n] + 1;
            }
        } else {
            Vector v2 = (Vector)this.nodeOrder.get(level + 1);
            if (v2.size() > 0 && v2.lastElement() != DUMMY) {
                v2.add(DUMMY);
                int n = level + 1;
                this.numDummies[n] = this.numDummies[n] + 1;
                int n2 = level + 1;
                this.numBranches[n2] = this.numBranches[n2] + 1;
            }
            for (NLDNode kid : this.viskids[index]) {
                this.arrangeNodesInOrder(kid, level + 1);
            }
        }
    }

    private void analyze() {
        int i;
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.analyzingChart.notrans", "Analyzing chart..."));
        }
        Vector<Integer> roots = new Vector<Integer>();
        for (i = 0; i < this.numNodes; ++i) {
            if (this.parent[i] != -1) continue;
            if (roots.size() == 0) {
                this.root = i;
            }
            roots.addElement(new Integer(i));
        }
        this.rootNode = (NLDNode)this.model.nodes.elementAt(this.root);
        if (roots.size() > 1) {
            int pr = 0;
            if (this.DEBUG) {
                System.out.println(this.GRS("StatusText.forest.notrans", "Multiple roots, graph is a forest."));
                System.out.println(this.GRS("StatusText.onlyTree.notrans", "Only the tree with Root ") + this.rootNode.getID() + this.GRS("StatusText.isDisplayed.notrans", " is displayed."));
                System.out.println(this.GRS("StatusText.notDisplayed.notrans", "The tree(s) not displayed are:"));
            }
            for (int i2 = 1; i2 < roots.size(); ++i2) {
                pr = (Integer)roots.elementAt(i2);
                NLDNode n = (NLDNode)this.model.nodes.elementAt(pr);
                this.hideSubtree(n, true);
                if (!this.DEBUG) continue;
                System.out.println(this.GRS("StatusText.forest.notrans", "\tRoot ") + i2 + this.GRS("StatusText.id.notrans", " ID: ") + n.getID());
            }
        }
        this.depth = new int[this.numNodes];
        for (i = 0; i < this.numNodes; ++i) {
            this.depth[i] = -1;
        }
        this.totalDepth = 0;
        this.setAllDepth(this.root, 0);
        this.maxDepth = this.getMaxDepth(this.root, 0);
        this.numDummies = new int[this.maxDepth + 1];
        this.numBranches = new int[this.maxDepth + 1];
        for (i = 0; i <= this.maxDepth; ++i) {
            this.numDummies[i] = 0;
            this.numBranches[i] = 0;
        }
        if (this.DEBUG) {
            System.out.println(this.GRS("StatusText.maxDepth.notrans", "max depth=") + this.maxDepth);
        }
        int tot = this.getLeaves(this.root);
        if (this.DEBUG) {
            System.out.println(this.GRS("StatusText.totalLeaves.notrans", "total leaves=") + tot);
        }
        if (this.centerAlgo) {
            int i3;
            if (this.actualNodesInLayer == null) {
                this.actualNodesInLayer = new int[this.maxDepth + 1];
                this.dummyNodesInLayer = new int[this.maxDepth + 1];
            }
            for (i3 = 0; i3 <= this.maxDepth; ++i3) {
                this.actualNodesInLayer[i3] = 0;
                this.dummyNodesInLayer[i3] = 0;
            }
            for (i3 = 0; i3 < this.numNodes; ++i3) {
                NLDNode n = (NLDNode)this.model.nodes.elementAt(i3);
                if (!n.isVisible()) continue;
                if (this.depth[i3] == -1) {
                    System.out.println(n.getLabel());
                }
                int n2 = this.depth[i3];
                this.actualNodesInLayer[n2] = this.actualNodesInLayer[n2] + 1;
                if (this.viskids[i3].size() != 0) continue;
                int j = this.depth[i3] + 1;
                while (j <= this.maxDepth) {
                    int n3 = j++;
                    this.dummyNodesInLayer[n3] = this.dummyNodesInLayer[n3] + 1;
                }
            }
        }
    }

    private void rearrange() {
        int i;
        VectorNodeModel nodes = this.model.nodes;
        this.model.links.setShowAll();
        for (i = 0; i < this.numNodes; ++i) {
            this.viskids[i].clear();
            if (nodes.isCollapsed(i)) continue;
            for (int j = 0; j < this.kids[i].size(); ++j) {
                NLDNode kid = (NLDNode)this.kids[i].elementAt(j);
                if (!kid.isVisible()) continue;
                this.viskids[i].add(kid);
            }
        }
        for (i = 0; i < this.numNodes; ++i) {
            this.depth[i] = -1;
        }
        this.maxDepth = 0;
        this.setDepth(this.root, 0);
        if (this.DEBUG) {
            System.out.println(this.GRS("StatusText.maxDepth.notrans", "max depth=") + this.maxDepth);
        }
        if (this.centerAlgo) {
            this.actualNodesInLayer = new int[this.maxDepth + 1];
            this.dummyNodesInLayer = new int[this.maxDepth + 1];
            for (i = 0; i <= this.maxDepth; ++i) {
                this.dummyNodesInLayer[i] = 0;
                this.actualNodesInLayer[i] = 0;
            }
            for (i = 0; i < this.numNodes; ++i) {
                NLDNode n = (NLDNode)nodes.elementAt(i);
                if (!n.isVisible()) continue;
                int n2 = this.depth[i];
                this.actualNodesInLayer[n2] = this.actualNodesInLayer[n2] + 1;
                if (this.viskids[i].size() != 0) continue;
                int j = this.depth[i] + 1;
                while (j <= this.maxDepth) {
                    int n3 = j++;
                    this.dummyNodesInLayer[n3] = this.dummyNodesInLayer[n3] + 1;
                }
            }
        }
        int tot = this.getLeaves(this.root);
        if (this.DEBUG) {
            System.out.println(this.GRS("StatusText.totalLeaves.notrans", "total leaves=") + tot);
        }
        double zoomfac = Math.min(1.0, Math.max(1.0E-8, 30.0 / Math.sqrt(tot)));
        this.setDefaultZoom(zoomfac);
        this.arrange();
        this.setNodeHandles();
        this.setTreeArcs();
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.drawingChart.notrans", "Drawing chart..."));
        }
        this.build();
        this.revalidate();
        this.repaint();
        this.setVisible(true);
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus("");
        }
    }

    private void checkBars(boolean dirty) {
        if (dirty) {
            this.redoBars = true;
            this.changeSupport.firePropertyChange("resize", null, new Integer(1));
        }
    }

    private void arrange() {
        int i;
        this.building = true;
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.placingNodes.notrans", "Placing nodes..."));
        }
        Dimension d = this.getSize();
        this.width = d.width;
        this.height = this.compHeight;
        int saveHT = this.worldHT;
        this.worldHT = 0;
        this.vgap = this.fontSize = this.getTextSize(this.getFont());
        int curSize = this.nodeOrder.size();
        int step1 = Math.min(curSize, this.maxDepth + 1);
        for (i = 0; i < step1; ++i) {
            ((Vector)this.nodeOrder.elementAt(i)).removeAllElements();
        }
        if (step1 == curSize) {
            for (i = step1; i < this.maxDepth + 1; ++i) {
                this.nodeOrder.add(new Vector());
            }
        } else {
            for (i = step1; i < curSize; ++i) {
                this.nodeOrder.removeElementAt(step1);
            }
        }
        for (i = 0; i <= this.maxDepth; ++i) {
            this.numDummies[i] = 0;
            this.numBranches[i] = 0;
        }
        this.arrangeNodesInOrder(this.rootNode, 0);
        if (this.centerAlgo) {
            this.computeSizes_center();
        } else {
            this.computeSizes();
        }
        this.proj();
        this.placeNodes();
        this.setVerticalLens(this.lensLocs, this.lensRange, this.lensValues, this.textCutoffs);
        this.findReconciliationLinePath();
        this.checkBars(saveHT != this.worldHT);
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus("");
        }
    }

    private void computeSizes() {
        int i;
        int i2;
        this.worldHT = 0;
        if (this.maxHeight == null || this.maxDepth >= this.maxHeight.length) {
            this.maxHeight = new double[this.maxDepth + 1];
            this.totalWidth = new double[this.maxDepth + 1];
            this.vspaces = new double[this.maxDepth + 1];
            this.widthFactor = new double[this.maxDepth + 1];
            this.lensValues = new double[this.totalDepth + 1];
            this.maxTotalWidth = 0.0;
        }
        this.maxW = new double[this.maxDepth + 1];
        this.vpadding = 0.0;
        for (int i3 = 0; i3 <= this.maxDepth; ++i3) {
            this.maxHeight[i3] = 0.0;
            this.totalWidth[i3] = 0.0;
            this.widthFactor[i3] = 1.0;
            this.maxW[i3] = 0.0;
            this.lensValues[i3] = 1.0;
        }
        this.maxTotalWidth = 0.0;
        this.maxLabelWidth = 0.0;
        Font saveFont = this.channel.glGetFont();
        for (int i4 = 0; i4 < this.numNodes; ++i4) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i4);
            if (!n.isVisible()) continue;
            String label = n.getLabel();
            Font font = n.getFont();
            if (font != null) {
                this.channel.glSelect2DFont(font);
            } else {
                this.channel.glSelect2DFont(saveFont);
            }
            double labelWidth = this.channel.glGetTextWidth(label + "  ");
            if (n.isCollapsed()) {
                labelWidth += this.channel.glGetTextWidth("+");
            }
            double labelHeight = 1.25 * this.channel.glGetTextHeight(label);
            if (this.depth[i4] == -1) continue;
            if (labelWidth > this.maxW[this.depth[i4]]) {
                this.maxW[this.depth[i4]] = labelWidth;
            }
            if (this.maxLabelWidth < labelWidth) {
                this.maxLabelWidth = labelWidth;
            }
            this.maxHeight[this.depth[i4]] = Math.max(this.maxHeight[this.depth[i4]], labelHeight);
        }
        this.channel.glSelect2DFont(saveFont);
        this.minLoc = 0;
        this.maxW[0] = this.maxLabelWidth;
        this.maxHeight[0] = (int)Math.max(this.maxHeight[this.maxDepth], this.maxHeight[0]);
        int num = ((Vector)this.nodeOrder.elementAt(this.maxDepth)).size();
        this.totalWidth[this.maxDepth] = (double)(num - this.numDummies[this.maxDepth]) * this.maxW[this.maxDepth] * 1.1;
        if (this.totalWidth[this.maxDepth] > 1.0) {
            this.totalWidth[this.maxDepth] = Math.max(1.01, ((double)num - 0.5 * (double)this.numBranches[this.maxDepth]) * 1.1 * this.maxLabelWidth);
            this.widthFactor[this.maxDepth] = 1.0 / this.totalWidth[this.maxDepth];
            this.lensValues[this.maxDepth] = Math.pow(this.totalWidth[this.maxDepth], 2.0);
        }
        this.maxTotalWidth = this.totalWidth[this.maxDepth];
        for (i2 = 0; i2 < this.maxDepth; ++i2) {
            num = ((Vector)this.nodeOrder.elementAt(i2)).size();
            this.totalWidth[i2] = (double)(num - this.numDummies[i2]) * this.maxW[i2] * 1.1;
            if (this.totalWidth[i2] > 1.0) {
                this.totalWidth[i2] = Math.max(1.01, ((double)num - 0.5 * (double)this.numBranches[i2]) * 1.1 * this.maxLabelWidth);
                this.widthFactor[i2] = 1.0 / this.totalWidth[i2];
                this.lensValues[i2] = Math.pow(this.totalWidth[i2], 2.0);
            }
            this.maxHeight[0] = (int)Math.max(this.maxHeight[i2], this.maxHeight[0]);
            this.maxTotalWidth = Math.max(this.maxTotalWidth, this.totalWidth[i2]);
        }
        if (this.lensLocs == null) {
            this.lensLocs = new double[this.totalDepth + 1];
            for (i2 = 0; i2 <= this.maxDepth; ++i2) {
                this.lensLocs[i2] = 0.5;
            }
        } else {
            double[] newLensLocs = new double[this.totalDepth + 1];
            if (this.lensLocs.length > this.maxDepth) {
                System.arraycopy(this.lensLocs, 0, newLensLocs, 0, this.maxDepth + 1);
            } else {
                System.arraycopy(this.lensLocs, 0, newLensLocs, 0, this.lensLocs.length);
                for (int i5 = this.lensLocs.length; i5 <= this.maxDepth; ++i5) {
                    newLensLocs[i5] = 0.5;
                }
            }
            this.lensLocs = newLensLocs;
        }
        this.vspaces[0] = this.vgap;
        this.lensRange = new double[this.totalDepth + 1];
        this.lensRange[0] = -this.vspaces[0] - this.maxHeight[0] - this.vgap;
        for (i = 0; i < this.maxDepth; ++i) {
            this.vspaces[i + 1] = this.vspaces[i] + this.maxHeight[i] + 2.0 * this.vgap;
            this.lensRange[i] = -this.vspaces[i + 1] + this.vgap;
        }
        for (i = this.maxDepth; i <= this.totalDepth; ++i) {
            this.lensRange[i] = this.lensRange[i - 1] - this.maxHeight[this.maxDepth] - 2.0 * this.vgap;
        }
        this.worldHT = (int)(-this.lensRange[this.totalDepth]);
        if (this.compHeight > this.worldHT + 25) {
            this.vpadding = (this.compHeight - this.worldHT) / (this.totalDepth + 1);
            int dsize = (int)this.vpadding / 3;
            this.vgap += (double)dsize;
            this.vspaces[0] = this.vspaces[0] + (double)dsize;
            int i6 = 0;
            while (i6 < this.maxDepth) {
                int n = i6 + 1;
                this.vspaces[n] = this.vspaces[n] + ((double)(i6 + 1) * this.vpadding + (double)dsize);
                int n2 = i6;
                this.lensRange[n2] = this.lensRange[n2] - (double)(i6 + 1) * this.vpadding;
                int n3 = i6++;
                this.maxHeight[n3] = this.maxHeight[n3] + (double)dsize;
            }
            int n = this.maxDepth;
            this.maxHeight[n] = this.maxHeight[n] + (double)dsize;
            for (i6 = this.maxDepth; i6 <= this.totalDepth; ++i6) {
                int n4 = i6;
                this.lensRange[n4] = this.lensRange[n4] - (double)(i6 + 1) * this.vpadding;
            }
            this.worldHT = this.compHeight;
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        boolean hadPadding = this.vpadding > 0.0;
        super.setBounds(x, y, w, h);
        if (!this.ready) {
            return;
        }
        if (this.worldHT == 0 && this.compHeight > 0 || this.worldHT + 25 < this.compHeight || hadPadding) {
            this.arrange();
            this.setTreeArcs();
            this.build();
            this.revalidate();
            this.repaint();
        } else if (this.worldHT > 0) {
            if (this.worldHT > this.compHeight) {
                if (this.origin.y > 0 && this.origin.y + this.compHeight > this.worldHT) {
                    this.origin.y = this.worldHT - this.compHeight;
                } else if (Math.abs(this.origin.y - this.compHeight) > this.worldHT) {
                    this.origin.y = this.compHeight - this.worldHT;
                }
            } else if (this.worldHT < this.compHeight) {
                this.origin.y = 0;
            }
        }
        this.setOrigin(this.origin, false, false);
        this.checkBars(true);
        this.redoBars = true;
    }

    private void placeNodes() {
        for (int i = this.maxDepth; i >= 0; --i) {
            Vector layer = (Vector)this.nodeOrder.elementAt(i);
            int layerSize = layer.size();
            double nodeHeight = this.maxHeight[i];
            double yval = this.vspaces[i] + nodeHeight / 2.0;
            boolean skipDummy = this.totalWidth[i] <= 1.0;
            double nodesize = skipDummy ? this.maxW[i] : this.maxLabelWidth / this.totalWidth[i];
            NLDNode firstNode = (NLDNode)layer.firstElement();
            int start = 0;
            while (firstNode == DUMMY) {
                firstNode = (NLDNode)layer.elementAt(++start);
            }
            double xval = this.totalWidth[i] > 1.0 ? -0.55 * nodesize : 0.5 - this.totalWidth[i] / 2.0 - 0.55 * nodesize;
            boolean isPrevDummy = true;
            for (int j = 0; j < layerSize; ++j) {
                NLDNode n = (NLDNode)layer.elementAt(j);
                if (n != DUMMY) {
                    n.setPosition(xval += 1.1 * nodesize, -yval);
                    n.setHeight(nodeHeight);
                    if (this.nodeSizeFixed) {
                        if (this.totalWidth[i] > 1.0) {
                            n.setSize(nodesize * this.totalWidth[i] / this.pixsize);
                        } else {
                            n.setSize(nodesize / this.pixsize);
                        }
                    } else {
                        n.setSize(nodesize);
                    }
                    isPrevDummy = false;
                    continue;
                }
                if (skipDummy) continue;
                if (isPrevDummy) {
                    xval += 1.1 * nodesize;
                    continue;
                }
                isPrevDummy = true;
                xval += 0.55 * nodesize;
            }
        }
        if (this.vspaces[this.maxDepth] + this.maxHeight[this.maxDepth] + this.vgap > (double)this.worldHT) {
            this.worldHT = (int)(this.vspaces[this.maxDepth] + this.maxHeight[this.maxDepth] + this.vgap);
        }
    }

    private void hideSubtree(NLDNode n, boolean hide) {
        n.setVisible(!hide);
        int index = n.getIndex();
        int nk = this.kids[index].size();
        if (nk == 0) {
            return;
        }
        for (int k = 0; k < nk; ++k) {
            this.hideSubtree((NLDNode)this.kids[index].elementAt(k), hide);
        }
        n.setCollapsed(hide);
    }

    private boolean isSubtreeHidden(NLDNode n) {
        int index = n.getIndex();
        int nk = this.kids[index].size();
        if (nk == 0) {
            return false;
        }
        for (int k = 0; k < nk; ++k) {
            if (!((NLDNode)this.kids[index].elementAt(k)).isVisible()) continue;
            return false;
        }
        return true;
    }

    private double[] computeMinMaxColorValues(int modelType) {
        double[] minmax = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        switch (modelType) {
            case 0: {
                for (int i = 0; i < this.model.nodes.size(); ++i) {
                    Object o = this.model.nodes.getValue(16, i);
                    if (!(o instanceof Number)) continue;
                    double cval = ((Number)o).doubleValue();
                    minmax[0] = Math.min(cval, minmax[0]);
                    minmax[1] = Math.max(cval, minmax[1]);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.model.links.size(); ++i) {
                    Object o = this.model.links.getValue(10, i);
                    if (!(o instanceof Number)) continue;
                    double cval = ((Number)o).doubleValue();
                    minmax[0] = Math.min(cval, minmax[0]);
                    minmax[1] = Math.max(cval, minmax[1]);
                }
                break;
            }
        }
        if (minmax[0] == Double.MAX_VALUE && minmax[1] == Double.MIN_VALUE) {
            minmax[0] = minmax[1];
        }
        return minmax;
    }

    private void hideSubtree(int index, boolean hide) {
        this.model.nodes.setVisible(index, !hide);
        int nk = this.kids[index].size();
        if (nk == 0) {
            return;
        }
        for (int k = 0; k < nk; ++k) {
            int ki = ((NLDNode)this.kids[index].elementAt(k)).getIndex();
            this.hideSubtree(ki, hide);
        }
        this.model.nodes.setCollapsed(index, hide);
    }

    private void setRoot(NLDNode n, boolean reset) {
        int i;
        VectorNodeModel nodes = this.model.nodes;
        if (reset) {
            nodes.setShowAll();
            this.rootNode = this.defRootNode;
            this.root = this.defRoot;
            Vector<Integer> roots = new Vector<Integer>();
            for (int i2 = 0; i2 < this.numNodes; ++i2) {
                if (this.parent[i2] != -1) continue;
                roots.addElement(new Integer(i2));
            }
            if (roots.size() > 1) {
                int pr = 0;
                for (int i3 = 1; i3 < roots.size(); ++i3) {
                    pr = (Integer)roots.elementAt(i3);
                    this.hideSubtree(pr, true);
                }
            }
        } else {
            for (int i4 = 0; i4 < this.numNodes; ++i4) {
                nodes.setVisible(i4, false);
            }
            this.rootNode = n;
            this.root = n.getIndex();
            this.hideSubtree(this.root, false);
        }
        this.resetArcAttr();
        for (i = 0; i < this.numNodes; ++i) {
            this.viskids[i].clear();
            for (int j = 0; j < this.kids[i].size(); ++j) {
                NLDNode kid = (NLDNode)this.kids[i].elementAt(j);
                if (!kid.isVisible()) continue;
                this.viskids[i].add(kid);
            }
        }
        for (i = 0; i < this.numNodes; ++i) {
            this.depth[i] = -1;
        }
        this.maxDepth = 0;
        this.setDepth(this.root, 0);
        if (this.DEBUG) {
            System.out.println(this.GRS("StatusText.maxDepth.notrans", "max depth=") + this.maxDepth);
        }
        int tot = this.getLeaves(this.root);
        if (this.DEBUG) {
            System.out.println(this.GRS("StatusText.totalLeaves.notrans", "total leaves=") + tot);
        }
        double zoomfac = Math.min(1.0, Math.max(1.0E-8, 30.0 / Math.sqrt(tot)));
        this.setDefaultZoom(zoomfac);
        this.arrange();
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.drawingTree.notrans", "Drawing tree..."));
        }
        this.centerx = n.getCurXPosition();
        this.centery = n.getCurYPosition();
        this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
        this.build();
        this.revalidate();
        this.repaint();
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus("");
        }
    }

    private void moveUp(NLDNode n) {
        this.saveReconLine();
        int index = this.removeNodeFromReconciliation(n);
        if (index < 0) {
            return;
        }
        int pid = this.parent[n.getIndex()];
        if (pid < 0) {
            return;
        }
        NLDNode parent = this.model.nodes.getNode(pid);
        if (!this.reconciliationNodesList[index].contains(parent)) {
            this.reconciliationNodesList[index].add(parent);
        }
        this.removeAllDescendentsFromReconLine(parent, index);
        this.findReconciliationLinePath();
        this.build();
        this.repaint();
    }

    private void removeAllDescendentsFromReconLine(NLDNode ancestor, int reconLineIndex) {
        int ancestorIdx = ancestor.getIndex();
        int num = this.kids[ancestorIdx].size();
        for (int i = 0; i < num; ++i) {
            NLDNode obj = (NLDNode)this.kids[ancestorIdx].elementAt(i);
            if (this.reconciliationNodesList[reconLineIndex].contains(obj)) {
                this.reconciliationNodesList[reconLineIndex].remove(obj);
                continue;
            }
            this.removeAllDescendentsFromReconLine(obj, reconLineIndex);
        }
    }

    private void resetReconciliation() {
        for (int i = 0; i < this.reconciliationNodesList.length; ++i) {
            this.reconciliationNodesList[i].clear();
            this.reconciliationNodesList[i].addAll(this.savedReconciliationNodesList[i]);
        }
        this.model.deselectAll();
        this.findReconciliationLinePath();
        this.build();
        this.repaint();
    }

    private boolean isNodeOnReconciliation(NLDNode n) {
        if (n == null) {
            return false;
        }
        if (this.reconciliationNodesList == null) {
            return false;
        }
        for (int i = 0; i < this.reconciliationNodesList.length; ++i) {
            if (this.reconciliationNodesList[i] == null || !this.reconciliationNodesList[i].contains(n)) continue;
            return true;
        }
        return false;
    }

    private int removeNodeFromReconciliation(NLDNode n) {
        int reconLineIndex = -1;
        if (n == null) {
            return reconLineIndex;
        }
        if (this.reconciliationNodesList == null) {
            return reconLineIndex;
        }
        for (int i = 0; i < this.reconciliationNodesList.length; ++i) {
            if (this.reconciliationNodesList[i] == null || !this.reconciliationNodesList[i].contains(n)) continue;
            reconLineIndex = i;
            this.reconciliationNodesList[i].remove(n);
            break;
        }
        return reconLineIndex;
    }

    private void moveDown(NLDNode n) {
        this.saveReconLine();
        int index = this.removeNodeFromReconciliation(n);
        if (index < 0) {
            return;
        }
        int id = n.getIndex();
        int num = this.kids[id].size();
        for (int i = 0; i < num; ++i) {
            NLDNode obj = (NLDNode)this.kids[id].elementAt(i);
            if (this.reconciliationNodesList[index].contains(obj)) continue;
            this.reconciliationNodesList[index].add(obj);
        }
        this.hideSubtree((Object)n, false);
        this.findReconciliationLinePath();
        this.build();
        this.repaint();
    }

    private boolean isSubtreeHidden(int index) {
        if (this.kids == null || index < 0 || index >= this.kids.length) {
            return true;
        }
        int nk = this.kids[index].size();
        if (nk == 0) {
            return false;
        }
        for (int k = 0; k < nk; ++k) {
            NLDNode ki = (NLDNode)this.kids[index].elementAt(k);
            if (!ki.isVisible()) continue;
            return false;
        }
        return true;
    }

    private int getLeaves(int i) {
        int nl;
        NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
        if (!n.isVisible()) {
            nl = 0;
        } else if (this.viskids[i].size() == 0) {
            nl = 1;
        } else {
            nl = 0;
            Iterator iter = this.viskids[i].iterator();
            while (iter.hasNext()) {
                int ki = ((NLDNode)iter.next()).getIndex();
                nl += this.getLeaves(ki);
            }
        }
        return nl;
    }

    private int getMaxDepth(int i, int d) {
        if (!this.model.nodes.isVisible(i)) {
            return d;
        }
        if (this.viskids == null) {
            return d;
        }
        int depth = d;
        Iterator iter = this.viskids[i].iterator();
        while (iter.hasNext()) {
            int ki = ((NLDNode)iter.next()).getIndex();
            depth = Math.max(depth, this.getMaxDepth(ki, d + 1));
        }
        return depth;
    }

    private void setDepth(int i, int d) {
        if (d > this.maxDepth) {
            this.maxDepth = d;
        }
        this.depth[i] = d;
        if (!this.model.nodes.isVisible(i)) {
            return;
        }
        if (this.viskids == null) {
            return;
        }
        Iterator iter = this.viskids[i].iterator();
        while (iter.hasNext()) {
            int ki = ((NLDNode)iter.next()).getIndex();
            this.setDepth(ki, d + 1);
        }
    }

    private void setAllDepth(int i, int d) {
        if (d > this.totalDepth) {
            this.totalDepth = d;
        }
        this.depth[i] = d;
        if (!this.model.nodes.isVisible(i)) {
            return;
        }
        if (this.kids == null) {
            return;
        }
        Iterator iter = this.kids[i].iterator();
        while (iter.hasNext()) {
            int ki = ((NLDNode)iter.next()).getIndex();
            this.setAllDepth(ki, d + 1);
        }
    }

    private void openURL() {
        this.openURL(this.context);
        this.context = null;
    }

    private boolean isSubtreeSelected(int index) {
        NLDNode node = (NLDNode)this.model.nodes.get(index);
        boolean selected = node.isSelected();
        if (!selected) {
            return false;
        }
        int i = index;
        int nk = this.kids[i].size();
        int k = 0;
        while (k < nk & selected) {
            int ki = ((NLDNode)this.kids[i].elementAt(k)).getIndex();
            selected = this.isSubtreeSelected(ki);
            ++k;
        }
        return selected;
    }

    private void setPopupLabels() {
        if (this.context instanceof NLDNode) {
            NLDNode n = (NLDNode)this.context;
            String urlStr = this.getUrlString(n);
            if (this.open != null) {
                this.open.removeActionListener((ActionListener)((Object)this));
                if (urlStr != null && !urlStr.equals("")) {
                    this.open.setText(urlStr);
                    this.open.setEnabled(true);
                } else {
                    this.open.setText(this.getAction(n));
                    this.open.setEnabled(false);
                }
                this.open.addActionListener((ActionListener)((Object)this));
            }
            this.selN.removeItemListener((ItemListener)((Object)this));
            this.selN.setEnabled(true);
            this.selN.setState(this.isSelected(n));
            this.selN.addItemListener((ItemListener)((Object)this));
            this.selT.removeItemListener((ItemListener)((Object)this));
            this.selT.setEnabled(true);
            this.selT.setState(this.isSubtreeSelected(n));
            this.selT.addItemListener((ItemListener)((Object)this));
            this.hideT.removeItemListener((ItemListener)((Object)this));
            this.hideT.setEnabled(true);
            this.hideT.setState(this.isSubtreeHidden(n));
            this.hideT.addItemListener((ItemListener)((Object)this));
            this.reconciliation.setEnabled(this.isNodeOnReconciliation(n));
            if (this.undo != null) {
                this.undo.setEnabled(this.reconLineHistory.size() > 0);
            }
        } else {
            String action;
            if (this.open != null && (action = this.model.getAction()) != null) {
                this.open.setText(action);
            }
            for (int m = 0; m < this.csm.length; ++m) {
                if (this.csm[m] == null) continue;
                this.csm[m].removeActionListener((ActionListener)((Object)this));
                this.csm[m].setEnabled(false);
                this.csm[m].addActionListener((ActionListener)((Object)this));
            }
            this.reconciliation.setEnabled(false);
        }
    }

    public void setHandlePopup(boolean val) {
        this.handlePopup = val;
    }

    public void setBuildDate(String bldDate) {
        if (bldDate != null) {
            this.buildDate = bldDate;
        }
    }

    public void setNodeBorderColor(Color c) {
        if (c == null) {
            return;
        }
        this.nodeBorderColor = c;
    }

    public void setNodeBorderColor(Color c, boolean applyToNodes) {
        this.setNodeBorderColor(c);
        if (applyToNodes && this.model.nodes != null) {
            for (int i = 0; i < this.numNodes; ++i) {
                NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
                this.setNodeBorderColor(n, c);
            }
        }
    }

    protected void removeLayers(int remove) {
    }

    public void addNotify() {
        super.addNotify();
        this.createChannel();
        this.setBackground(this.background);
    }

    protected boolean loadLayer(NLDNode parent, int index) {
        this.model.loadLayer(parent, index);
        this.numNodes = this.model.nodes.size();
        this.numLinks = this.model.links.size();
        for (int i = 0; i < this.numNodes; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            n.setTextColor(this.textColor);
            n.setSelectColor(this.reconciliationLineColor);
        }
        return true;
    }

    protected void dispError(String err) {
        System.out.println(err);
        this.setCursor(Cursor.getDefaultCursor());
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.done.notrans", "Done"));
        }
    }

    public void setOrthogonalLinks(boolean value) {
        this.orthogonalLinks = value;
        if (this.channel != null) {
            if (this.orthogonalLinks) {
                this.channel.glEnable(8);
            } else {
                this.channel.glDisable(8);
            }
        }
    }

    public int getWorldHeight() {
        return this.worldHT;
    }

    public int getWorldWidth() {
        return this.getWidth();
    }

    public void resetOrigin() {
        this.origin.x = 0;
        this.origin.y = 0;
        this.setOrigin(this.origin, false, false);
    }

    public void setOrigin(Point p, boolean scaleX, boolean scaleY) {
        this.origin.x = 0;
        this.origin.y = p.y;
        this.centery = p.y;
        if (this.channel != null) {
            this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
        }
        if (this.ready) {
            this.repaint();
        }
    }

    public Point getOrigin() {
        return this.origin;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    public Dimension getPreferredSize() {
        Dimension d = this.getSize();
        if (d.width == 0) {
            d.width = 100;
        }
        d.height = this.worldHT;
        return d;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        int unitIncrement = 10;
        if (orientation == 1) {
            currentPosition = visibleRect.y;
            if (this.maxHeight != null && this.maxHeight[0] != 0.0) {
                unitIncrement = (int)this.maxHeight[0];
            }
        }
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / unitIncrement * unitIncrement;
            return newPosition == 0 ? unitIncrement : newPosition;
        }
        return (currentPosition / unitIncrement + 1) * unitIncrement - currentPosition;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int unitIncrement = 10;
        if (this.maxHeight != null && this.maxHeight[0] != 0.0) {
            unitIncrement = (int)this.maxHeight[0];
        }
        return visibleRect.height - unitIncrement;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public int getPreferredHeight() {
        return Math.max(this.compHeight, this.worldHT);
    }

    public int getPreferredWidth() {
        Dimension d = this.getPreferredSize();
        return d.width;
    }

    public synchronized void build() {
        int polygonMode;
        if (this.ignoreBuild) {
            return;
        }
        if (this.model == null) {
            return;
        }
        this.DEBUG("DWG.build");
        if (this.channel == null) {
            this.rebuildRequired = true;
            return;
        }
        this.building = true;
        this.channel.glNewList(13L);
        this.channel.glLoadName((Object)"");
        if (this.reconNodeOrder != null && this.reconNodeOrder.length > 0) {
            this.channel.setBackgroundColor(this.reconAreaColor);
            polygonMode = this.channel.getPolygonMode();
            int borderType = this.channel.getBorderType();
            this.channel.setBorderType(0);
            this.channel.glPolygonMode(3);
            int numLines = this.reconNodeOrder.length;
            for (int i = 0; i < numLines; ++i) {
                int j;
                if (this.reconNodeOrder[i] == null) continue;
                this.channel.glColor(this.nonReconAreaColor);
                this.channel.glBegin(2);
                this.channel.glVertex(-1.0, 0.0);
                int numVertices = this.reconNodeOrder[i].size() + 1;
                if (numVertices == 0) continue;
                double[] xValues = new double[2 * numVertices];
                double[] yValues = new double[2 * numVertices];
                for (j = 0; j < this.reconNodeOrder[i].size(); ++j) {
                    double[] p2;
                    double[] p;
                    NLDNode n1 = (NLDNode)this.reconNodeOrder[i].elementAt(j);
                    int idx1 = (j + 1) * 2;
                    int idx2 = (j + 1) * 2 + 1;
                    if (j == 0) {
                        this.channel.glVertex(-1.0, 0.0);
                        p = n1.getLocation(this.channel, this.handleType, this.iconType);
                        this.channel.glVertex(-1.0, p[1]);
                        this.channel.glVertex(p[0], p[1]);
                        xValues[0] = -1.0;
                        yValues[0] = p[1];
                        xValues[1] = p[0];
                        yValues[1] = p[1];
                    }
                    if (j == this.reconNodeOrder[i].size() - 1) {
                        p = n1.getLocation(this.channel, this.handleType, this.iconType);
                        this.channel.glVertex(p[0], p[1]);
                        this.channel.glVertex(2.0, p[1]);
                        xValues[idx1] = p[0];
                        yValues[idx1] = p[1];
                        xValues[idx2] = 2.0;
                        yValues[idx2] = p[1];
                        this.channel.glVertex(2.0, 0.0);
                        continue;
                    }
                    NLDNode n2 = (NLDNode)this.reconNodeOrder[i].elementAt(j + 1);
                    double[] p1 = n1.getLocation(this.channel, this.handleType, this.iconType);
                    if (p1[1] > (p2 = n2.getLocation(this.channel, this.handleType, this.iconType))[1]) {
                        p1 = this.getNodeJoinPoint(n1, 4);
                        p2 = this.getNodeJoinPoint(n2, 3);
                    } else if (p1[1] < p2[1]) {
                        p1 = this.getNodeJoinPoint(n1, 3);
                        p2 = this.getNodeJoinPoint(n2, 4);
                    }
                    xValues[idx1] = p1[0];
                    yValues[idx1] = p1[1];
                    xValues[idx2] = p2[0];
                    yValues[idx2] = p2[1];
                    this.channel.glVertex(xValues[idx1], yValues[idx1]);
                    this.channel.glVertex(xValues[idx2], yValues[idx2]);
                }
                this.channel.glEnd();
                this.channel.glColor(this.reconciliationLineColor);
                this.channel.glLineWidth(this.reconLineWidth);
                this.channel.glEnable(7);
                this.channel.glLineStipple(1, 65520);
                this.channel.glBegin(1);
                this.channel.glVertex(-1.0, 0.0);
                for (j = 0; j < numVertices; ++j) {
                    this.channel.glVertex(xValues[j * 2], yValues[j * 2]);
                    this.channel.glVertex(xValues[j * 2 + 1], yValues[j * 2 + 1]);
                }
                this.channel.glVertex(2.0, 0.0);
                this.channel.glDisable(7);
                this.channel.glEnd();
            }
            this.channel.glLineWidth(1.0f);
            this.channel.glPolygonMode(polygonMode);
            this.channel.setBorderType(borderType);
        }
        this.channel.glEndList();
        this.channel.glNewList(12L);
        this.channel.glLoadName((Object)"");
        this.buildLinks();
        this.channel.glLoadName((Object)"");
        this.channel.glEndList();
        this.channel.glNewList(11L);
        this.channel.glLoadName((Object)"");
        this.buildNodes();
        this.channel.glLoadName((Object)"");
        this.channel.glEndList();
        if (this.outlineReconNodes && this.reconNodeOrder != null && this.reconNodeOrder.length > 0) {
            this.channel.glNewList(14L);
            this.channel.glLoadName((Object)"");
            polygonMode = this.channel.getPolygonMode();
            int numLines = this.reconNodeOrder.length;
            this.channel.glColor(this.reconciliationLineColor);
            this.channel.glLineWidth(this.reconLineWidth);
            for (int i = 0; i < numLines; ++i) {
                this.channel.glPolygonMode(2);
                for (NLDNode n : this.reconciliationNodesList[i]) {
                    if (!n.isVisible()) continue;
                    double[] sz = n.getSize(this.channel, this.handleType, this.iconType);
                    double xpos = n.getCurXPosition();
                    double ypos = n.getCurYPosition();
                    double x1 = xpos - sz[0] / 2.0;
                    double x2 = xpos + sz[0] / 2.0;
                    double y1 = ypos - sz[1] / 2.0;
                    double y2 = ypos + sz[1] / 2.0;
                    this.channel.glBegin(2);
                    this.channel.glVertex(x1, y1);
                    this.channel.glVertex(x2, y1);
                    this.channel.glVertex(x2, y2);
                    this.channel.glVertex(x1, y2);
                    this.channel.glVertex(x1, y1);
                    this.channel.glEnd();
                }
            }
            this.channel.glLineWidth(1.0f);
            this.channel.glPolygonMode(polygonMode);
            this.channel.setBorderType(this.borderType);
            this.channel.glLoadName((Object)"");
            this.channel.glEndList();
        }
        this.channel.glNewList(this.displist);
        this.channel.glCallList(13L);
        this.channel.glCallList(12L);
        this.channel.glCallList(11L);
        this.channel.glEndList();
        this.rebuilt = true;
        this.building = false;
    }

    private double[] getNodeJoinPoint(NLDNode n, int joinPoint) {
        if (n == null) {
            return null;
        }
        double[] p1 = n.getLocation(this.channel, this.handleType, this.iconType);
        double size = n.getSize() * 0.54;
        double ht = n.getHeight() * 0.54;
        double[] p = new double[2];
        switch (joinPoint) {
            case 1: {
                p[0] = p1[0] - size;
                p[1] = p1[1];
                return p;
            }
            case 2: {
                p[0] = p1[0] + size;
                p[1] = p1[1];
                return p;
            }
            case 3: {
                p[0] = p1[0];
                p[1] = p1[1] + ht;
                return p;
            }
            case 4: {
                p[0] = p1[0];
                p[1] = p1[1] - ht;
                return p;
            }
        }
        return null;
    }

    public synchronized void mouseDragged(MouseEvent e) {
        if (!this.ready) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int xd = this.prevx - x;
        int yd = this.prevy - y;
        this.drag = true;
        if (this.movenode) {
            double[] win1 = new double[3];
            double[] obj1 = new double[3];
            double[] win2 = new double[3];
            double[] obj2 = new double[3];
            double[] delta = new double[2];
            win1[0] = x;
            win1[1] = y;
            win2[0] = this.prevx;
            win2[1] = this.prevy;
            this.channel.gluUnProject(win1, obj1);
            this.channel.gluUnProject(win2, obj2);
            delta[0] = obj1[0] - obj2[0];
            delta[1] = obj1[1] - obj2[1];
            for (int i = 0; i < this.numNodes; ++i) {
                NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
                if (!this.model.nodes.isSelected(i)) continue;
                n.setPosition(n.getCurXPosition() + delta[0], n.getCurYPosition() + delta[1]);
            }
            this.build();
            this.repaint();
            this.prevx = x;
            this.prevy = y;
        } else if (this.pan) {
            int i;
            int index = 0;
            if ((double)this.prevy > this.lensScreenRange[this.lensScreenRange.length - 1]) {
                index = this.lensScreenRange.length - 1;
            } else {
                while ((double)this.prevy > this.lensScreenRange[index]) {
                    ++index;
                }
            }
            double newLoc = this.lensScreenLocs[index] - (double)(x - this.prevx) * this.widthFactor[index];
            newLoc = Math.max(this.maxLabelWidth / 2.0, Math.min((double)this.compWidth - this.maxLabelWidth / 2.0, newLoc));
            double[] s = new double[]{newLoc, this.lensScreenRange[index]};
            double[] w = new double[]{0.0, 0.0};
            this.channel.gluUnProject(s, w);
            this.lensLocs[index] = w[0];
            this.lensScreenLocs[index] = newLoc;
            for (i = 0; i < this.lensLocs.length; ++i) {
                this.lensLocs[i] = w[0];
                this.lensScreenLocs[i] = newLoc;
            }
            if (this.centerAlgo) {
                for (i = 0; i < this.lensLocs.length; ++i) {
                    this.lensLocs[i] = w[0];
                    this.lensScreenLocs[i] = newLoc;
                }
            }
            if (this.nodeSizeFixed) {
                this.channel.glNewList(11L);
                this.channel.glLoadName((Object)"");
                this.buildNodes();
                this.channel.glLoadName((Object)"");
                this.channel.glEndList();
            }
            this.prevx = x;
            this.prevy = y;
            this.repaint();
        } else if (this.select || this.extsel) {
            this.repaint();
            Graphics gc = this.getGraphics();
            gc.setColor(Color.white);
            gc.setXORMode(Color.black);
            int xp = Math.min(x, this.prevx);
            int yp = Math.min(y, this.prevy);
            int w = Math.abs(xd);
            int h = Math.abs(yd);
            gc.drawRect(xp, yp, w, h);
            gc.dispose();
        }
    }

    public int[] getLayerLocations() {
        if (!this.ready) {
            return null;
        }
        int[] lh = new int[this.maxDepth + 2];
        lh[0] = 0;
        for (int i = 0; i <= this.maxDepth; ++i) {
            lh[i + 1] = (int)this.lensScreenRange[i];
        }
        return lh;
    }

    public Collection getReconciliationLine(int which) {
        if (this.reconNodeOrder == null || which < 0 || which >= this.reconNodeOrder.length || this.reconNodeOrder[which] == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.reconNodeOrder[which].size(); ++i) {
            NLDNode n = (NLDNode)this.reconNodeOrder[which].elementAt(i);
            v.add(n.getID());
        }
        return v;
    }

    public boolean setReconciliationLine(Collection nodeList) {
        if (nodeList == null) {
            return false;
        }
        this.listCreated = false;
        this.reconciliationNodes = nodeList;
        return true;
    }

    public boolean setReconciliationLine(int layerIndex) {
        if (layerIndex < 0 || this.ready && layerIndex > this.maxDepth) {
            return false;
        }
        this.listCreated = false;
        this.reconciliationIndex = layerIndex;
        return true;
    }

    private void createReconciliationNodesList() {
        if (this.listCreated) {
            return;
        }
        if (this.reconciliationIndex >= 0 && this.reconciliationIndex < this.maxDepth) {
            this.reconciliationNodesList = new HashSet[1];
            this.savedReconciliationNodesList = new HashSet[1];
            if (this.reconciliationIndex == 0) {
                this.reconciliationNodesList[0] = new HashSet();
                this.reconciliationNodesList[0].add(this.rootNode);
                this.reconciliationIndex = -1;
                return;
            }
            HashSet<NLDNode> prevLayer = new HashSet<NLDNode>();
            HashSet curLayer = null;
            prevLayer.add(this.rootNode);
            for (int i = 0; i < this.reconciliationIndex; ++i) {
                curLayer = new HashSet();
                for (NLDNode node : prevLayer) {
                    Vector offsprings = this.kids[node.getIndex()];
                    curLayer.addAll(offsprings);
                }
                prevLayer = curLayer;
            }
            this.reconciliationNodesList[0] = curLayer;
            this.savedReconciliationNodesList[0] = new HashSet(this.reconciliationNodesList[0]);
            this.reconciliationIndex = -1;
        } else if (this.reconciliationNodes != null) {
            Iterator i = this.reconciliationNodes.iterator();
            if (i == null) {
                return;
            }
            if (this.reconciliationNodesList == null) {
                this.reconciliationNodesList = new HashSet[1];
                this.savedReconciliationNodesList = new HashSet[1];
                this.reconciliationNodesList[0] = new HashSet();
            } else {
                this.reconciliationNodesList[0].clear();
            }
            while (i.hasNext()) {
                NLDNode n;
                Object o = i.next();
                if (o == null || (n = this.model.nodes.getNode((Object)o.toString())) == null) continue;
                this.reconciliationNodesList[0].add(n);
            }
            this.savedReconciliationNodesList[0] = new HashSet(this.reconciliationNodesList[0]);
        }
        this.listCreated = true;
    }

    private void computeSizes_center() {
        int i;
        int i2;
        if (this.maxHeight == null || this.maxDepth >= this.maxHeight.length) {
            this.maxHeight = new double[this.maxDepth + 1];
            this.totalWidth = new double[this.maxDepth + 1];
            this.vspaces = new double[this.maxDepth + 1];
            this.widthFactor = new double[this.maxDepth + 1];
            this.widthRatio = new double[this.maxDepth + 1];
            this.lensValues = new double[this.totalDepth + 1];
            this.minLeft = new double[this.maxDepth + 1];
            this.maxTotalWidth = 0.0;
        }
        this.maxW = new double[this.maxDepth + 1];
        for (int i3 = 0; i3 <= this.maxDepth; ++i3) {
            this.maxHeight[i3] = 0.0;
            this.totalWidth[i3] = 0.0;
            this.minLeft[i3] = 0.0;
            this.widthFactor[i3] = 1.0;
            this.widthRatio[i3] = 1.0;
            this.maxW[i3] = 0.0;
            this.lensValues[i3] = 1.0;
        }
        Font saveFont = this.channel.glGetFont();
        for (int i4 = 0; i4 < this.numNodes; ++i4) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i4);
            if (!n.isVisible()) continue;
            String label = n.getLabel();
            Font font = n.getFont();
            if (font != null) {
                this.channel.glSelect2DFont(font);
            } else {
                this.channel.glSelect2DFont(saveFont);
            }
            double labelWidth = this.channel.glGetTextWidth(label + "  ");
            if (n.isCollapsed()) {
                labelWidth += this.channel.glGetTextWidth("+");
            }
            double labelHeight = 1.25 * this.channel.glGetTextHeight(label);
            if (this.depth[i4] == -1) continue;
            if (labelWidth > this.maxW[this.depth[i4]]) {
                this.maxW[this.depth[i4]] = labelWidth;
            }
            if (this.maxLabelWidth < labelWidth) {
                this.maxLabelWidth = labelWidth;
            }
            this.maxHeight[this.depth[i4]] = Math.max(this.maxHeight[this.depth[i4]], labelHeight);
        }
        this.channel.glSelect2DFont(saveFont);
        this.maxHeight[0] = (int)Math.max(this.maxHeight[this.maxDepth], this.maxHeight[0]);
        this.maxW[0] = this.maxLabelWidth;
        this.minLoc = 0;
        int num = ((Vector)this.nodeOrder.elementAt(this.maxDepth)).size();
        this.totalWidth[this.maxDepth] = (double)(num - this.numDummies[this.maxDepth]) * this.maxW[this.maxDepth] * 1.1;
        if (this.totalWidth[this.maxDepth] > 1.0) {
            this.totalWidth[this.maxDepth] = ((double)num - 0.5 * (double)this.numBranches[this.maxDepth]) * 1.1 * this.maxLabelWidth;
            this.widthFactor[this.maxDepth] = 1.0 / this.totalWidth[this.maxDepth];
            this.lensValues[this.maxDepth] = Math.pow(this.totalWidth[this.maxDepth], 2.0);
        }
        this.maxTotalWidth = this.totalWidth[this.maxDepth];
        for (i2 = 0; i2 < this.maxDepth; ++i2) {
            num = ((Vector)this.nodeOrder.elementAt(i2)).size();
            this.totalWidth[i2] = (double)(num - this.numDummies[i2]) * this.maxW[i2] * 1.1;
            if (this.totalWidth[i2] > 1.0) {
                this.totalWidth[i2] = ((double)num - 0.5 * (double)this.numBranches[i2]) * 1.1 * this.maxLabelWidth;
                this.widthFactor[i2] = 1.0 / this.totalWidth[i2];
                this.widthRatio[i2] = this.totalWidth[i2] / this.totalWidth[this.maxDepth];
                this.lensValues[i2] = Math.pow(this.totalWidth[i2], 2.0);
            }
            this.maxHeight[0] = (int)Math.max(this.maxHeight[i2], this.maxHeight[0]);
            this.maxTotalWidth = Math.max(this.maxTotalWidth, this.totalWidth[i2]);
        }
        this.vspaces[0] = this.vgap;
        this.lensRange = new double[this.totalDepth + 1];
        if (this.lensLocs == null) {
            this.lensLocs = new double[this.maxDepth + 1];
            for (i2 = 0; i2 <= this.maxDepth; ++i2) {
                this.lensLocs[i2] = 0.5;
            }
        } else {
            double[] newLensLocs = new double[this.totalDepth + 1];
            if (this.lensLocs.length > this.maxDepth) {
                System.arraycopy(this.lensLocs, 0, newLensLocs, 0, this.maxDepth + 1);
            } else {
                System.arraycopy(this.lensLocs, 0, newLensLocs, 0, this.lensLocs.length);
                for (int i5 = this.lensLocs.length; i5 <= this.maxDepth; ++i5) {
                    newLensLocs[i5] = 0.5;
                }
            }
            this.lensLocs = newLensLocs;
        }
        this.lensRange[0] = -this.vspaces[0] - this.maxHeight[0] - this.vgap;
        for (i = 0; i < this.maxDepth; ++i) {
            this.vspaces[i + 1] = this.vspaces[i] + this.maxHeight[i] + 2.0 * this.vgap;
            this.lensRange[i] = -this.vspaces[i + 1] + this.vgap;
        }
        for (i = this.maxDepth; i <= this.totalDepth; ++i) {
            this.lensRange[i] = this.lensRange[i - 1] - this.maxHeight[this.maxDepth] - 2.0 * this.vgap;
        }
        this.worldHT = (int)(-this.lensRange[this.totalDepth]);
        if (this.compHeight > this.worldHT + 25) {
            this.vpadding = (this.compHeight - this.worldHT) / (this.totalDepth + 1);
            int dsize = (int)this.vpadding / 3;
            this.vgap += (double)dsize;
            this.vspaces[0] = this.vspaces[0] + (double)dsize;
            int i6 = 0;
            while (i6 < this.maxDepth) {
                int n = i6 + 1;
                this.vspaces[n] = this.vspaces[n] + ((double)(i6 + 1) * this.vpadding + (double)dsize);
                int n2 = i6;
                this.lensRange[n2] = this.lensRange[n2] - ((double)(i6 + 1) * this.vpadding - (double)dsize);
                int n3 = i6++;
                this.maxHeight[n3] = this.maxHeight[n3] + (double)dsize;
            }
            int n = this.maxDepth;
            this.maxHeight[n] = this.maxHeight[n] + (double)dsize;
            for (i6 = this.maxDepth; i6 <= this.totalDepth; ++i6) {
                int n4 = i6;
                this.lensRange[n4] = this.lensRange[n4] - ((double)(i6 + 1) * this.vpadding - (double)dsize);
            }
            this.worldHT = this.compHeight;
        }
        this.worldHT = (int)(this.vspaces[this.maxDepth] + this.maxHeight[this.maxDepth] + this.vgap);
    }

    public void buildNodes() {
        if (this.numNodes == 0) {
            return;
        }
        int visibleNodes = 0;
        if (this.nodeSizeFixed) {
            for (int i = this.maxDepth; i >= 0; --i) {
                Vector layer = (Vector)this.nodeOrder.elementAt(i);
                int layerSize = layer.size();
                double lensPos = this.lensLocs[i];
                int index = layerSize - 1;
                NLDNode n = (NLDNode)layer.elementAt(index);
                while ((!n.isVisible() || n == DUMMY || n.getCurXPosition() > lensPos) && index > 0) {
                    if (n != DUMMY && n.isVisible() && n.isShowLabel()) {
                        n.buildLabel(this.channel, this.handleType, this.iconType, this.texthalign, this.textvalign, (double)this.getWidth(), (double)this.getHeight(), this.zoomval);
                        ++visibleNodes;
                    }
                    n = (NLDNode)layer.elementAt(--index);
                }
                for (int j = 0; j <= index; ++j) {
                    n = (NLDNode)layer.elementAt(j);
                    if (n == DUMMY || !n.isVisible() || !n.isShowLabel()) continue;
                    n.buildLabel(this.channel, this.handleType, this.iconType, this.texthalign, this.textvalign, (double)this.getWidth(), (double)this.getHeight(), this.zoomval);
                    ++visibleNodes;
                }
            }
        } else {
            int i;
            for (i = 0; i < this.numNodes; ++i) {
                ((NLDNode)this.model.nodes.elementAt(i)).build(this.channel, this.handleType, this.iconType, this.texthalign, this.textvalign, (double)this.getWidth(), (double)this.getHeight(), this.zoomval);
            }
            for (i = 0; i < this.numNodes; ++i) {
                NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
                if (!n.isVisible()) continue;
                ++visibleNodes;
                if (!n.isShowLabel()) continue;
                n.buildLabel(this.channel, this.handleType, this.iconType, this.texthalign, this.textvalign, (double)this.getWidth(), (double)this.getHeight(), this.zoomval);
            }
        }
        if (this.getGraphics() instanceof Graphics2D) {
            if (visibleNodes < 100) {
                this.channel.glEnable(9);
                ((Graphics2D)this.getGraphics()).addRenderingHints(ANTIALIAS_ON);
            } else {
                this.channel.glDisable(9);
                ((Graphics2D)this.getGraphics()).addRenderingHints(ANTIALIAS_OFF);
            }
        }
    }

    public Color getReconciliationLineColor() {
        return this.reconciliationLineColor;
    }

    public void setReconciliationLineColor(Color reconciliationLineColor) {
        this.reconciliationLineColor = reconciliationLineColor;
    }
}

