/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.dtree;

import com.sas.graphics.silk.dtree.DTreeNode;
import com.sas.graphics.silk.dtree.TreeCanvas;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.Text;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class TreeLink {
    protected DTreeNode from;
    protected DTreeNode to;
    protected int space;
    protected TreeCanvas tree;
    protected int lineWidth;
    protected Color color;
    String upperText;
    String lowerText;
    Rectangle2D upperTextBox = null;
    Rectangle2D lowerTextBox = null;
    public Rectangle aboveRect;
    public Rectangle belowRect;

    public TreeLink(DTreeNode parent, DTreeNode child) {
        this.from = parent;
        this.to = child;
        this.space = DTreeNode.getNodeSpacing();
    }

    public TreeLink(DTreeNode parent, DTreeNode child, TreeCanvas c) {
        this.from = parent;
        this.to = child;
        this.space = DTreeNode.getNodeSpacing();
        this.tree = c;
    }

    public void setLineWidth(int widthIn) {
        if (widthIn > 0) {
            this.lineWidth = widthIn;
        }
    }

    public int getLineWidth() {
        if (this.tree.linkWidth == -1) {
            if (this.tree.minLinkWidth == this.tree.maxLinkWidth) {
                return 1;
            }
            double d = (double)this.lineWidth / ((double)this.tree.maxLinkWidth - (double)this.tree.minLinkWidth) * 10.0;
            int rc = Math.max((int)d, 1);
            return rc;
        }
        if (this.tree.linkWidth == -2) {
            double i = this.to.getNodeSize();
            double root = this.tree.rootSize;
            double ratio = i / root;
            return (int)Math.ceil(ratio * 10.0);
        }
        return this.tree.linkWidth;
    }

    public Color getColor() {
        if (this.tree.useLinkColorRamp && this.tree.linkColorRamp != null && this.tree.linkWidth < 0) {
            this.color = this.tree.linkColorRamp.queryDouble((double)this.lineWidth, (double)this.tree.minLinkWidth, (double)this.tree.maxLinkWidth, false, null);
            return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), (int)(255.0 * this.tree.linkTransparency));
        }
        return this.tree.linkSolidColor;
    }

    public void drawVerticalStraight(Graphics2D g) {
        Rectangle a = new Rectangle(this.from.getBounds());
        Rectangle b = new Rectangle(this.to.getBounds());
        int space = DTreeNode.getNodeSpacing();
        g.setColor(this.getColor());
        if (this.getLineWidth() == 1) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(this.getLineWidth(), 0, 1, 0.0f, null, 0.0f));
            g.drawLine((a.x + (a.x + a.width)) / 2, a.y + a.height - space + this.from.getCollapse().getBounds().height, (b.x + (b.x + b.width)) / 2, b.y + space);
            g.setStroke(oldStroke);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath path = new GeneralPath();
            path.moveTo((a.x + (a.x + a.width)) / 2 - this.getLineWidth() / 2, a.y + a.height - space + this.from.getCollapse().getBounds().height);
            path.lineTo((b.x + (b.x + b.width)) / 2 - this.getLineWidth() / 2, b.y + space);
            path.lineTo((b.x + (b.x + b.width)) / 2 + this.getLineWidth() / 2, b.y + space);
            path.lineTo((a.x + (a.x + a.width)) / 2 + this.getLineWidth() / 2, a.y + a.height - space + this.from.getCollapse().getBounds().height);
            path.lineTo((a.x + (a.x + a.width)) / 2 - this.getLineWidth() / 2, a.y + a.height - space + this.from.getCollapse().getBounds().height);
            g.fill(path);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.tree.linkTextVisible) {
            String upperText = null;
            String lowerText = null;
            if (this.from != null) {
                upperText = this.from.getBelowText();
            }
            if (this.to != null) {
                lowerText = this.to.getAboveText();
            }
            Rectangle2D r = null;
            Rectangle2D r2 = null;
            int y0 = a.y + a.height - space;
            if (this.from.getCollapse().isVisible()) {
                y0 += this.from.getCollapse().getBounds().height;
            }
            int y1 = b.y + space;
            int yDist = y1 - y0;
            Text txt = this.tree.linkText;
            FontRenderContext frc = g.getFontRenderContext();
            if (upperText != null && upperText.length() > 0) {
                r = txt.getStringBounds(upperText, frc);
                if (r.getWidth() > this.from.getBounds().getWidth()) {
                    upperText = this.clipText(upperText, txt, frc, this.from.getBounds().getWidth());
                    r = txt.getStringBounds(upperText, frc);
                }
                txt.drawText(g, upperText, new Point((a.x + (a.x + a.width)) / 2 - (int)r.getWidth() / 2, y0 + yDist / 4));
                this.aboveRect = new Rectangle((a.x + (a.x + a.width)) / 2 - (int)r.getWidth() / 2, y0 + yDist / 4 - (int)r.getHeight(), (int)r.getWidth(), (int)r.getHeight());
            }
            if (lowerText != null && lowerText.length() > 0) {
                r2 = txt.getStringBounds(lowerText, frc);
                if (r2.getWidth() > this.from.getBounds().getWidth()) {
                    lowerText = this.clipText(lowerText, txt, frc, this.from.getBounds().getWidth());
                    r2 = txt.getStringBounds(lowerText, frc);
                }
                txt.drawText(g, lowerText, new Point((b.x + (b.x + b.width)) / 2 - (int)r2.getWidth() / 2, y1 - yDist / 4 + (int)r2.getHeight() / 2));
                this.belowRect = new Rectangle((b.x + (b.x + b.width)) / 2 - (int)r2.getWidth() / 2, y1 - yDist / 4 + (int)r2.getHeight() / 2 - (int)r2.getHeight(), (int)r2.getWidth(), (int)r2.getHeight());
            }
        }
    }

    public void drawHorizontalStraight(Graphics2D g) {
        Rectangle a = new Rectangle(this.from.getBounds());
        Rectangle b = new Rectangle(this.to.getBounds());
        g.setColor(this.getColor());
        if (this.getLineWidth() == 1) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(this.getLineWidth(), 0, 1, 0.0f, null, 0.0f));
            g.drawLine(a.x + a.width - this.space + this.from.getCollapse().getBounds().width, (a.y + (a.y + a.height)) / 2, b.x + this.space, (b.y + (b.y + b.height)) / 2);
            g.setStroke(oldStroke);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath path = new GeneralPath();
            path.moveTo(a.x + a.width - this.space + this.from.getCollapse().getBounds().width, (a.y + (a.y + a.height)) / 2 - this.getLineWidth() / 2);
            path.lineTo(b.x + this.space, (b.y + (b.y + b.height)) / 2 - this.getLineWidth() / 2);
            path.lineTo(b.x + this.space, (b.y + (b.y + b.height)) / 2 + this.getLineWidth() / 2);
            path.lineTo(a.x + a.width - this.space + this.from.getCollapse().getBounds().width, (a.y + (a.y + a.height)) / 2 + this.getLineWidth() / 2);
            path.lineTo(a.x + a.width - this.space + this.from.getCollapse().getBounds().width, (a.y + (a.y + a.height)) / 2 - this.getLineWidth() / 2);
            g.fill(path);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        int x0 = a.x + a.width - this.space + this.from.getCollapse().getBounds().width;
        int x1 = b.x + this.space;
        int xDist = x1 - x0;
        Rectangle2D r = null;
        Rectangle2D r2 = null;
        String upperText = null;
        String lowerText = null;
        if (this.from != null) {
            upperText = this.from.getBelowText();
        }
        if (this.to != null) {
            lowerText = this.to.getAboveText();
        }
        Text txt = this.tree.linkText;
        if (this.tree.linkTextVisible) {
            FontRenderContext frc = g.getFontRenderContext();
            if (upperText != null && upperText.length() > 0) {
                r = txt.getStringBounds(upperText, frc);
                if (r.getWidth() > this.from.getBounds().getWidth()) {
                    upperText = this.clipText(upperText, txt, frc, this.from.getBounds().getWidth());
                    r = txt.getStringBounds(upperText, frc);
                }
                txt.drawText(g, upperText, new Point(10 + x0, (a.y + (a.y + a.height)) / 2 - (int)r.getHeight() / 2));
                this.aboveRect = new Rectangle(10 + x0, (a.y + (a.y + a.height)) / 2 - (int)r.getHeight() / 2 - (int)r.getHeight(), (int)r.getWidth(), (int)r.getHeight());
            }
            if (lowerText != null && lowerText.length() > 0) {
                r2 = txt.getStringBounds(lowerText, frc);
                if (r2.getWidth() > this.from.getBounds().getWidth()) {
                    lowerText = this.clipText(lowerText, txt, frc, this.from.getBounds().getWidth());
                    r2 = txt.getStringBounds(lowerText, frc);
                }
                txt.drawText(g, lowerText, new Point(10 + x0 + xDist / 2, (b.y + (b.y + b.height)) / 2 - (int)r2.getHeight() / 2));
                this.belowRect = new Rectangle(10 + x0 + xDist / 2, (b.y + (b.y + b.height)) / 2 - (int)r2.getHeight() / 2 - (int)r2.getHeight(), (int)r2.getWidth(), (int)r2.getHeight());
            }
        }
    }

    public void drawVerticalTriangle(Graphics2D g) {
        Rectangle a = new Rectangle(this.from.getBounds());
        Rectangle b = new Rectangle(this.to.getBounds());
        int space = DTreeNode.getNodeSpacing();
        Color f = this.getColor();
        GeneralPath tri = new GeneralPath();
        tri.moveTo((a.x + (a.x + a.width)) / 2, a.y + a.height - space + this.from.getCollapse().getBounds().height);
        tri.lineTo(b.x + space, b.y + space);
        tri.lineTo(b.x + b.width - space, b.y + space);
        g.setColor(f);
        g.fill(tri);
    }

    public void drawHorizontalTriangle(Graphics2D g) {
        Rectangle a = new Rectangle(this.from.getBounds());
        Rectangle b = new Rectangle(this.to.getBounds());
        int space = DTreeNode.getNodeSpacing();
        Color f = this.getColor();
        GeneralPath tri = new GeneralPath();
        tri.moveTo(a.x + a.width - space + this.from.getCollapse().getBounds().width, a.y + a.height / 2);
        tri.lineTo(b.x + space, b.y + space);
        tri.lineTo(b.x + space, b.y + b.height - space);
        g.setColor(f);
        g.fill(tri);
    }

    public void drawHorizontalManhattan(Graphics2D g) {
        Rectangle a = new Rectangle(this.from.getBounds());
        Rectangle b = new Rectangle(this.to.getBounds());
        int x0 = a.x + a.width - this.space + this.from.getCollapse().getBounds().width;
        int x1 = b.x + this.space;
        int xDist = x1 - x0;
        Rectangle2D r = null;
        Rectangle2D r2 = null;
        String upperText = null;
        String lowerText = null;
        if (this.from != null) {
            upperText = this.from.getBelowText();
        }
        if (this.to != null) {
            lowerText = this.to.getAboveText();
        }
        Text txt = this.tree.linkText;
        if (this.tree.linkTextVisible) {
            FontRenderContext frc = g.getFontRenderContext();
            if (upperText != null && upperText.length() > 0) {
                r = txt.getStringBounds(upperText, frc);
                if (r.getWidth() > this.from.getBounds().getWidth() * this.tree.xScale) {
                    upperText = this.clipText(upperText, txt, frc, this.from.getBounds().getWidth());
                    r = txt.getStringBounds(upperText, frc);
                }
                txt.drawText(g, upperText, new Point(10 + x0, (a.y + (a.y + a.height)) / 2 - (int)r.getHeight() / 2));
                this.aboveRect = new Rectangle(10 + x0, (a.y + (a.y + a.height)) / 2 - (int)r.getHeight() / 2 - (int)r.getHeight(), (int)r.getWidth(), (int)r.getHeight());
            }
            if (lowerText != null && lowerText.length() > 0) {
                r2 = txt.getStringBounds(lowerText, frc);
                if (r2.getWidth() > this.from.getBounds().getWidth() * this.tree.xScale) {
                    lowerText = this.clipText(lowerText, txt, frc, this.from.getBounds().getWidth());
                    r2 = txt.getStringBounds(lowerText, frc);
                }
                txt.drawText(g, lowerText, new Point(10 + x0 + xDist / 2, (b.y + (b.y + b.height)) / 2 - (int)r2.getHeight() / 2));
                this.belowRect = new Rectangle(10 + x0 + xDist / 2, (b.y + (b.y + b.height)) / 2 - (int)r2.getHeight() / 2 - (int)r2.getHeight(), (int)r2.getWidth(), (int)r2.getHeight());
            }
        }
        Stroke oldStroke = g.getStroke();
        g.setColor(this.getColor());
        g.setStroke(new BasicStroke(this.getLineWidth(), 0, 1, 0.0f, null, 0.0f));
        GeneralPath p = new GeneralPath();
        p.moveTo(x0, (a.y + (a.y + a.height)) / 2);
        p.lineTo(x0 + xDist / 2, (a.y + (a.y + a.height)) / 2);
        p.lineTo(x0 + xDist / 2, (b.y + (b.y + b.height)) / 2);
        p.lineTo(x1, (b.y + (b.y + b.height)) / 2);
        g.draw(p);
        g.setStroke(oldStroke);
    }

    public void drawVerticalManhattan(Graphics2D g) {
        this.upperText = this.from.getBelowText();
        this.lowerText = this.to.getAboveText();
        Rectangle a = new Rectangle(this.from.getBounds());
        Rectangle b = new Rectangle(this.to.getBounds());
        int y0 = a.y + a.height - this.space;
        if (this.from.getCollapse().isVisible()) {
            y0 += this.from.getCollapse().getBounds().height;
        }
        int y1 = b.y + this.space;
        int yDist = y1 - y0;
        Text txt = this.tree.linkText;
        Font oldFont = txt.getFont();
        txt.setFont((Object)oldFont.deriveFont((float)((double)oldFont.getSize() * this.tree.yScale)));
        FontRenderContext frc = g.getFontRenderContext();
        if (this.tree.linkTextVisible) {
            if (this.upperText != null && this.upperText.length() > 0) {
                this.upperTextBox = txt.getStringBounds(this.upperText, frc);
                if (this.upperTextBox.getWidth() > this.from.getBounds().getWidth()) {
                    this.upperText = this.clipText(this.upperText, txt, frc, this.from.getBounds().getWidth());
                    this.upperTextBox = txt.getStringBounds(this.upperText, frc);
                }
                txt.drawText(g, this.upperText, new Point((a.x + (a.x + a.width)) / 2 - (int)this.upperTextBox.getWidth() / 2, y0 + yDist / 4));
                this.aboveRect = new Rectangle((a.x + (a.x + a.width)) / 2 - (int)this.upperTextBox.getWidth() / 2, y0 + yDist / 4 - (int)this.upperTextBox.getHeight(), (int)this.upperTextBox.getWidth(), (int)this.upperTextBox.getHeight());
            }
            if (this.lowerText != null && this.lowerText.length() > 0) {
                this.lowerTextBox = txt.getStringBounds(this.lowerText, frc);
                if (this.lowerTextBox.getWidth() > this.to.getBounds().getWidth()) {
                    this.lowerText = this.clipText(this.lowerText, txt, frc, this.to.getBounds().getWidth());
                    Font font = txt.getFont();
                    Font dpiFont = font.deriveFont((float)SILKUtilities.adjustFontSize((int)font.getSize()));
                    this.lowerTextBox = dpiFont.getStringBounds(this.lowerText, frc);
                }
                txt.drawText(g, this.lowerText, new Point((b.x + (b.x + b.width)) / 2 - (int)this.lowerTextBox.getWidth() / 2, y1 - yDist / 4 + (int)this.lowerTextBox.getHeight() / 2));
                this.belowRect = new Rectangle((b.x + (b.x + b.width)) / 2 - (int)this.lowerTextBox.getWidth() / 2, y1 - yDist / 4 + (int)this.lowerTextBox.getHeight() / 2 - (int)this.lowerTextBox.getHeight(), (int)this.lowerTextBox.getWidth(), (int)this.lowerTextBox.getHeight());
            }
        }
        txt.setFont((Object)oldFont);
        Stroke oldStroke = g.getStroke();
        g.setColor(this.getColor());
        g.setStroke(new BasicStroke(this.getLineWidth(), 0, 1, 0.0f, null, 0.0f));
        GeneralPath p = new GeneralPath();
        p.moveTo((a.x + (a.x + a.width)) / 2, y0);
        if (this.tree.linkTextVisible && this.upperText != null && this.upperText.length() > 0) {
            p.lineTo((a.x + (a.x + a.width)) / 2, (float)(y0 + yDist / 4) - (float)this.upperTextBox.getHeight());
            p.moveTo((a.x + (a.x + a.width)) / 2, (float)(y0 + yDist / 4) + (float)this.upperTextBox.getHeight() / 4.0f);
        }
        p.lineTo((a.x + (a.x + a.width)) / 2, y0 + yDist / 2);
        p.lineTo((b.x + (b.x + b.width)) / 2, y0 + yDist / 2);
        if (this.tree.linkTextVisible && this.lowerText != null && this.lowerText.length() > 0) {
            p.lineTo((b.x + (b.x + b.width)) / 2, (float)(y1 - yDist / 4 + (int)this.lowerTextBox.getHeight() / 2) - (float)this.lowerTextBox.getHeight());
            p.moveTo((b.x + (b.x + b.width)) / 2, (float)(y1 - yDist / 4 + (int)this.lowerTextBox.getHeight() / 2) + (float)this.lowerTextBox.getHeight() / 4.0f);
        }
        p.lineTo((b.x + (b.x + b.width)) / 2, y1);
        g.draw(p);
        g.setStroke(oldStroke);
    }

    private String clipText(String text, Text txt, FontRenderContext frc, double maxWidth) {
        String str;
        block1: {
            str = text;
            Rectangle2D stringBounds = txt.getStringBounds("...", frc);
            do {
                StringBuilder stringBuilder = new StringBuilder();
                if (!(txt.getStringBounds(stringBuilder.append(str).append("...").toString(), frc).getWidth() > maxWidth - stringBounds.getWidth())) break block1;
            } while ((str = str.substring(0, str.length() - 1)).length() != 0);
            return str;
        }
        return str + "...";
    }
}

