/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.dtree;

import com.sas.graphics.silk.dtree.TreeCanvas;
import com.sas.graphics.silk.dtree.closeButton;
import com.sas.graphics.silk.dtree.minimizeButton;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.FontManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;

public class TreeLegend
extends JComponent {
    private static final long serialVersionUID = 3484207445438656099L;
    closeButton close;
    minimizeButton min;
    TreeCanvas tree;
    boolean minimized = false;
    BufferedImage image;
    double alpha = 0.35;
    Color backColor = Color.white;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.dtree.silk_dtree_NLS");

    public TreeLegend(TreeCanvas t) {
        this.backColor = new Color(249, 249, 251, (int)(this.alpha * 255.0));
        this.tree = t;
        this.setLayout(null);
        this.close = new closeButton();
        this.add(this.close);
        this.close.addActionListener(this.tree);
        this.close.setActionCommand("CloseLegend");
        this.min = new minimizeButton();
        this.add(this.min);
        this.min.addActionListener(this.tree);
        this.min.setActionCommand("MinimizeLegend");
        this.addMouseListener(this.tree);
        this.addMouseMotionListener(this.tree);
    }

    public double getTransparency() {
        return this.alpha;
    }

    public void setTransparency(double d) {
        this.alpha = d;
    }

    public Color getBackgroundColor() {
        return this.backColor;
    }

    public void setBackgroundColor(int red, int green, int blue) {
        this.backColor = new Color(red, green, blue, (int)(this.alpha * 255.0));
    }

    @Override
    public void paint(Graphics g) {
        Color c2;
        Color c1;
        Graphics2D g2 = (Graphics2D)g;
        Stroke oldStroke = g2.getStroke();
        this.close.setBounds(this.getWidth() - 17, 2, 15, 15);
        this.min.setBounds(this.getWidth() - 34, 2, 15, 15);
        g2.setColor(new Color(this.backColor.getRed(), this.backColor.getGreen(), this.backColor.getBlue(), (int)(this.alpha * 255.0)));
        g2.fill3DRect(0, 0, this.getWidth(), this.getHeight(), true);
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke(1.0f));
        g2.drawLine(2, 16, this.getWidth() - 4, 16);
        int width = this.getWidth() - 4;
        g2.setFont(FontManager.getFont((String)"SansSerif", (int)0, (int)10));
        FontRenderContext frc = g2.getFontRenderContext();
        int textHeight = (int)g2.getFont().getStringBounds("T", frc).getHeight();
        g2.drawString(ResourceLoader.getResourceString((Object)this.rb, (String)"TreeLegend.Node_Size.txt", (String)"Node Size"), 5, 16 + textHeight);
        int gradientWidth = width - 10;
        int gradientHeight = 10;
        ColorInterface cr = this.tree.nodeColorRamp;
        Color[] clrs = null;
        if (cr != null) {
            clrs = cr.getColors();
            c1 = clrs[0];
            c2 = clrs[clrs.length - 1];
        } else {
            c1 = this.tree.nodeBackground.getSolidBackground();
            if (c1 == null) {
                c1 = Color.black;
            }
            if ((c2 = c1) == null) {
                c2 = Color.black;
            }
        }
        GradientPaint nodeSizeGradient = new GradientPaint(0.0f, 0.0f, new Color(c1.getRed(), c1.getGreen(), c1.getBlue(), 100), gradientWidth, 0.0f, new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), 100));
        g2.setPaint(nodeSizeGradient);
        g2.fillRect(5, 18 + textHeight, gradientWidth, gradientHeight);
        g2.setColor(Color.black);
        g2.setFont(FontManager.getFont((String)"SansSerif", (int)0, (int)8));
        int numTextHeight = (int)g2.getFont().getStringBounds("T", frc).getHeight();
        g2.drawString(String.valueOf(this.tree.minNodeSize), 5, 18 + numTextHeight + textHeight + gradientHeight);
        g2.drawString(String.valueOf(this.tree.maxNodeSize), 5 + gradientWidth - (int)g.getFont().getStringBounds(String.valueOf(this.tree.maxNodeSize), frc).getWidth(), 18 + numTextHeight + textHeight + gradientHeight);
        g2.setFont(FontManager.getFont((String)"SansSerif", (int)0, (int)10));
        g2.drawString(ResourceLoader.getResourceString((Object)this.rb, (String)"TreeLegend.Link_Width.txt", (String)"Link Width"), 5, 20 + 2 * textHeight + numTextHeight + gradientHeight);
        cr = this.tree.linkColorRamp;
        if (cr != null) {
            clrs = cr.getColors();
            c1 = clrs[0];
            c2 = clrs[clrs.length - 1];
            nodeSizeGradient = new GradientPaint(0.0f, 0.0f, new Color(c1.getRed(), c1.getGreen(), c1.getBlue(), 100), gradientWidth, 0.0f, new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), 100));
            g2.setPaint(nodeSizeGradient);
        } else {
            g2.setColor(this.tree.linkSolidColor);
        }
        g2.fillRect(5, 22 + 2 * textHeight + numTextHeight + gradientHeight, gradientWidth, gradientHeight);
        g2.setColor(Color.black);
        g2.setFont(FontManager.getFont((String)"SansSerif", (int)0, (int)8));
        g2.drawString(String.valueOf(this.tree.minLinkWidth), 5, 22 + 2 * numTextHeight + 2 * textHeight + 2 * gradientHeight);
        g2.drawString(String.valueOf(this.tree.maxLinkWidth), 5 + gradientWidth - (int)g.getFont().getStringBounds(String.valueOf(this.tree.minLinkWidth), frc).getWidth(), 22 + 2 * numTextHeight + 2 * textHeight + 2 * gradientHeight);
        super.paint(g2);
        g2.setStroke(oldStroke);
    }

    public JButton getCloseButton() {
        return this.close;
    }
}

