/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.dtree;

import com.sas.graphics.silk.DecisionTree;
import com.sas.graphics.silk.dtree.DTreeLayout;
import com.sas.graphics.silk.dtree.DTreeNode;
import com.sas.graphics.silk.dtree.EnglishRuleDialog;
import com.sas.graphics.silk.dtree.GraphNodeRenderer;
import com.sas.graphics.silk.dtree.NodeRenderer;
import com.sas.graphics.silk.dtree.NodeTooltip;
import com.sas.graphics.silk.dtree.PrintPreview;
import com.sas.graphics.silk.dtree.PrintableNode;
import com.sas.graphics.silk.dtree.PrintablePage;
import com.sas.graphics.silk.dtree.SurrogateDialog;
import com.sas.graphics.silk.dtree.TextNodeRenderer;
import com.sas.graphics.silk.dtree.TreeLegend;
import com.sas.graphics.silk.dtree.TreeLink;
import com.sas.graphics.silk.event.DrilldownEvent;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.event.TreeModelEvent;
import com.sas.graphics.silk.event.TreeModelListenerInterface;
import com.sas.graphics.silk.info.SILKChartInfo;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.CompositeChartPrintInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.ImageListInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PrintPreviewInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.TextInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.interfaces.TreeModelInterface;
import com.sas.graphics.silk.interfaces.TreeNodeInterface;
import com.sas.graphics.silk.ui.DTreeNodePanel;
import com.sas.graphics.silk.ui.DecisionTreePanel;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.Footnote;
import com.sas.graphics.silk.util.GraphBackground;
import com.sas.graphics.silk.util.ImagePaginator;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.Print;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.silk.util.Title;
import com.sas.graphics.silk.util.ToolTipDefaults;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import com.sas.graphics.util.StringCompare;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.TreeNode;

public class TreeCanvas
extends JComponent
implements ActionListener,
MouseListener,
MouseMotionListener,
TreeModelListenerInterface,
PropertyInterface,
TextListenerInterface,
Printable,
Pageable,
CompositeChartPrintInterface,
PrintPreviewInterface,
GraphInterface {
    private static final long serialVersionUID = -4125336944814731628L;
    protected Point parentOffset = new Point(75, 100);
    protected Point unscaledParentOffset = new Point(75, 100);
    DTreeNode xMinNode;
    DTreeNode xMaxNode;
    DTreeNode yMinNode;
    DTreeNode yMaxNode;
    public TreeModelInterface tree;
    DTreeNode root;
    DTreeNode focusNode;
    Vector flaggedNodes;
    Vector selectedNodes;
    int linkStringWidth = 0;
    public NodeTooltip toolTip;
    public boolean chartTipsOn = true;
    public Object tipText = null;
    public Point tipLocation = null;
    Point rbStart;
    Point rbEnd;
    public boolean adjusted = true;
    public boolean isPrinting = false;
    public Rectangle nodeSize = new Rectangle(0, 0, 200, 100);
    public Rectangle originalNodeSize = new Rectangle(0, 0, 200, 100);
    public boolean invalid = true;
    public int xZoomPercentage = 100;
    public int yZoomPercentage = 100;
    private boolean holdDisplay = false;
    protected DTreeNode primarySelection = null;
    public Title titles = null;
    public Footnote footnote = null;
    public TreeLegend legend;
    private boolean legendDragging = false;
    private Point legendMousePosition = null;
    private Point legendPosition = null;
    public Vector mouseListeners = new Vector();
    public ImageListInterface imageList;
    protected int actionMode = 6;
    protected Vector links;
    public int initialDisplayLevel = Integer.MAX_VALUE;
    private BasicStroke linkStroke = new BasicStroke(5.0f, 1, 1, 0.0f, null, 0.0f);
    public GraphPropertiesDialog propertiesDialog = null;
    public JPopupMenu menu = null;
    SurrogateDialog sDialog = null;
    EnglishRuleDialog eDialog = null;
    public int orientation = 1;
    public GraphBackground background = null;
    public boolean nodeContentsChanged = true;
    public boolean emptyNodes = false;
    public boolean showNodeLabels = true;
    public Text nodeText = new Text();
    public Text flaggedNodeText = new Text();
    public double rootSize = 0.0;
    public int numBars = 3;
    public int numStacks = 3;
    public boolean linkTextVisible = true;
    public Text linkText = new Text();
    public boolean areChartTipsOn = true;
    public double xScale = 1.0;
    public double yScale = 1.0;
    public Style style = null;
    public int linkStyle = 0;
    public boolean hasNodeGraphs = false;
    public Color linkSolidColor = Color.black;
    public boolean useLinkColorRamp = false;
    public ColorInterface linkColorRamp = null;
    public double linkTransparency = 1.0;
    public int linkWidth = 1;
    public boolean showNodeGraphs = false;
    public boolean showFlaggedNodeGraphs = false;
    public ColorInterface nodeColorRamp = null;
    public boolean useNodeColorRamp = true;
    public GraphBackground nodeBackground = null;
    public GraphBackground flaggedNodeBackground = null;
    public double[] nodeGraphAxisRange = null;
    public boolean useNodeGraphAxisRange = false;
    public int nodeGraphOrientation = 1;
    public int minLinkWidth = 0;
    public int maxLinkWidth = 1;
    public double minNodeSize = 0.0;
    public double maxNodeSize = 0.0;
    public Color primarySelectionColor = Color.red;
    public int nodeOutlineWidth = 1;
    public int flaggedNodeOutlineWidth = 12;
    public boolean userSetNodeSize = false;
    public Color[] userSetRampColors = null;
    public boolean nodesUseTipText = false;
    PropertyList pending = null;
    boolean showPopup = true;
    public NodeRenderer nodeRenderer = null;
    public NodeRenderer graphNodeRenderer = null;
    Rectangle treeBounds = new Rectangle();
    public Rectangle defaultTreeBounds = new Rectangle();
    Frame parentFrame = null;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.dtree.silk_dtree_NLS");
    ResourceBundle rbSilk = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
    protected Vector drilldownListeners = null;
    private boolean fitToPageMode = true;
    private BufferedImage bufImage = null;
    private ImagePaginator imagePaginator = null;
    private int printMode = 3;
    private GraphPanel graphPanel = null;
    private DecisionTreePanel dtreePanel = null;
    private DTreeNodePanel nodePanel = null;
    private TitlePanel titlePanel = null;
    private Timer tooltipTimer = null;
    private TooltipHandler tooltipHandler = null;
    private MouseEvent tempME = null;
    protected ToolTipDefaults tipDefaults = null;
    private Object id = null;
    private boolean flaggedNodeSupported = true;
    private static int[] supportedPrintModes = new int[]{3, 1, 4};
    private Point mouseBeginPoint = new Point(0, 0);
    public ArrayList<PrintableNode> printableNodes = new ArrayList();
    public ArrayList<PrintablePage> printablePages = new ArrayList();
    public HashMap<Integer, BufferedImage> previewImages = new HashMap();
    public static final int BFS = 0;
    public static final int DFS = 1;
    public static int PAGEHEIGHT;
    public int pageOrder = 0;
    public int userTreeDepth = -1;
    public int maxTreeDepth = -1;
    public boolean rebuild = false;
    public PrintPreview previewDialog;
    private HashMap<PrintableNode, ArrayList<PrintablePage>> printableNodePageLookup = new HashMap();
    private PrintableNode xMinPrintNode;
    private PrintableNode xMaxPrintNode;
    private PrintableNode yMinPrintNode;
    private PrintableNode yMaxPrintNode;
    private PrintableNode printableRoot;
    private BufferedImage printImage;
    private Rectangle printTreeBounds = new Rectangle();
    private static int PRINTABLE_PAGE_WIDTH;
    private static int PRINTABLE_PAGE_HEIGHT;
    private static int PAGEWIDTH;
    private PageFormat mPageFormat;
    private Title printTilte = new Title();
    private Footnote printFootnote = new Footnote();
    private boolean printHeader = false;
    private boolean printFooter = false;
    private static final int TITLE_SIZE = 16;
    private static final int FOOTNOTE_SIZE = 12;
    private static final int SUB_TITLE_SIZE = 12;
    private static final int SUPPRESSION_SIZE = -1;
    private static final int PRINT_TITLE_HEIGHT = 25;
    private static final int PAGE_NUMBER_WIDTH = 10;
    private static final int PAGE_NUMBER_HEIGHT = 20;
    private static final int PRINT_SUBTITLE_HEIGHT = 20;
    private static final int PRINT_FOOTNOTE_HEIGHT = 20;

    public TreeCanvas(TreeModelInterface treeData) {
        this.setHoldDisplay(true);
        this.tree = treeData;
        if (this.tree != null) {
            this.tree.addTreeModelListener(this);
        }
        this.setAutoscrolls(true);
        this.drilldownListeners = new Vector();
        this.setNodeText((TextStyleInterface)new Text(), false);
        this.setNodeText((TextStyleInterface)new Text(), true);
        this.linkText.setJustifySupported(false);
        this.linkText.setFormatSupported(false);
        this.buildTree();
        this.selectedNodes = new Vector();
        this.flaggedNodes = new Vector();
        this.setFocusNode(this.root);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.legend = new TreeLegend(this);
        this.legend.setBounds(10, 10, 150, 100);
        this.legendPosition = new Point(10, 10);
        this.add(this.legend);
        this.setLegendVisible(false);
        this.registerKeyboardAction(this, "CNTRL-F", KeyStroke.getKeyStroke(70, 2, false), 0);
        this.registerKeyboardAction(this, "RIGHT-ARROW", KeyStroke.getKeyStroke(39, 0, false), 0);
        this.registerKeyboardAction(this, "LEFT-ARROW", KeyStroke.getKeyStroke(37, 0, false), 0);
        this.registerKeyboardAction(this, "UP-ARROW", KeyStroke.getKeyStroke(38, 0, false), 0);
        this.registerKeyboardAction(this, "DOWN-ARROW", KeyStroke.getKeyStroke(40, 0, false), 0);
        this.registerKeyboardAction(this, "SPACEBAR", KeyStroke.getKeyStroke(32, 0, false), 0);
        this.registerKeyboardAction(this, "SHIFT-SPACEBAR", KeyStroke.getKeyStroke(32, 1, false), 0);
        this.registerKeyboardAction(this, "CTRL-SPACEBAR", KeyStroke.getKeyStroke(32, 2, false), 0);
        this.registerKeyboardAction(this, "SHIFT-CTRL-SPACEBAR", KeyStroke.getKeyStroke(32, 3, false), 0);
        this.registerKeyboardAction(this, "EXPANDALL", KeyStroke.getKeyStroke(69, 2, false), 0);
        this.background = new GraphBackground((JComponent)this);
        this.toolTip = new NodeTooltip();
        this.tempME = new MouseEvent(this, -1, 0L, 0, 0, 0, 0, false);
        this.tipDefaults = new ToolTipDefaults();
        this.tooltipHandler = new TooltipHandler();
        this.tooltipTimer = new Timer(this.tipDefaults.delay, this.tooltipHandler);
        this.tooltipTimer.start();
        this.nodeColorRamp = new ColorRamp(null, (Object)new double[]{this.minNodeSize, this.maxNodeSize}, 0L);
        this.linkColorRamp = new ColorRamp(null, (Object)new double[]{this.minLinkWidth, this.maxLinkWidth}, 0L);
        this.setColorScheme(SILKGlobal.getInstance().getPropertyValue(0));
        this.nodeBackground = new GraphBackground((JComponent)this);
        FillStyleElement fill = this.style.getFillStyleElement("GraphDataStyleDefault");
        this.nodeBackground.setSolidBackground((Object)fill.getFillColor());
        this.flaggedNodeBackground = new GraphBackground((JComponent)this);
        fill = this.style.getFillStyleElement("Selection");
        this.flaggedNodeBackground.setSolidBackground((Object)fill.getFillColor());
        this.pending = new PropertyList();
        this.nodeRenderer = new TextNodeRenderer(this);
        this.graphNodeRenderer = new GraphNodeRenderer(this);
        this.titles = new Title();
        this.titles.addTextListener((TextListenerInterface)this);
        this.footnote = new Footnote();
        this.footnote.addTextListener((TextListenerInterface)this);
        this.setupDefaults();
        SILKGlobal.register((PropertyInterface)this);
    }

    private void setupDefaults() {
        Properties defaults = ResourceLoader.loadProperties((String)"com/sas/graphics/silk/dtree/DecisionTree.config");
        this.nodeText.setFont((Object)FontManager.getFont((String)ResourceLoader.getResourceString((Object)defaults, (String)"NodeText.FontName", (String)"Monospaced"), (int)Text.getFontStyleForString((String)ResourceLoader.getResourceString((Object)defaults, (String)"NodeText.FontStyle", (String)"Plain")), (int)ResourceLoader.getResourceInteger((Object)defaults, (String)"NodeText.FontSize", (int)12)));
    }

    public Object getFocusNodeId() {
        if (this.focusNode == null) {
            return null;
        }
        return this.focusNode.getID();
    }

    public boolean setNodeText(TextStyleInterface textIn, boolean flagged) {
        if (textIn == null) {
            return false;
        }
        Text txt = new Text(textIn);
        txt.setColorSupported(false);
        txt.setJustifySupported(false);
        txt.setFormatSupported(false);
        txt.addTextListener((TextListenerInterface)this);
        if (flagged) {
            this.flaggedNodeText = txt;
        } else {
            this.nodeText = txt;
        }
        this.nodeContentsChanged = true;
        return true;
    }

    public void dispose() {
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(70, 2, false));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, 0, false));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, 0, false));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0, false));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0, false));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 0, false));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 1, false));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 2, false));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 3, false));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(69, 2, false));
        if (this.tooltipTimer != null) {
            this.tooltipTimer.stop();
            if (this.tooltipHandler != null) {
                this.tooltipTimer.removeActionListener(this.tooltipHandler);
            }
        }
        this.tooltipTimer = null;
        this.tipDefaults = null;
        this.tooltipHandler = null;
        this.parentOffset = null;
        this.unscaledParentOffset = null;
        this.yMaxNode = null;
        this.yMinNode = null;
        this.xMaxNode = null;
        this.xMinNode = null;
        if (this.tree != null) {
            this.tree.removeTreeModelListener(this);
        }
        this.tree = null;
        this.root = null;
        this.focusNode = null;
        this.flaggedNodes = null;
        this.selectedNodes = null;
        this.toolTip = null;
        this.tipText = null;
        this.tipLocation = null;
        this.rbStart = null;
        this.rbEnd = null;
        this.nodeSize = null;
        this.originalNodeSize = null;
        this.primarySelection = null;
        this.titles = null;
        this.footnote = null;
        this.legend = null;
        this.legendMousePosition = null;
        this.legendPosition = null;
        this.mouseListeners = null;
        this.imageList = null;
        this.links = null;
        this.linkStroke = null;
        this.propertiesDialog = null;
        this.menu = null;
        this.sDialog = null;
        this.eDialog = null;
        this.background.dispose();
        this.background = null;
        this.nodeText = null;
        this.flaggedNodeText = null;
        this.linkText = null;
        this.linkSolidColor = null;
        this.linkColorRamp = null;
        this.nodeColorRamp = null;
        this.nodeBackground = null;
        this.flaggedNodeBackground = null;
        this.nodeGraphAxisRange = null;
        this.primarySelectionColor = null;
        this.userSetRampColors = null;
        this.pending = null;
        this.nodeRenderer = null;
        this.graphNodeRenderer = null;
        if (this.graphPanel != null) {
            this.graphPanel.removePropertyListener((PropertyInterface)this);
        }
        this.graphPanel = null;
        if (this.dtreePanel != null) {
            this.dtreePanel.removePropertyListener(this);
        }
        this.dtreePanel = null;
        if (this.nodePanel != null) {
            this.nodePanel.removePropertyListener(this);
        }
        this.nodePanel = null;
        if (this.titlePanel != null) {
            this.titlePanel.removePropertyListener((PropertyInterface)this);
        }
        this.titlePanel = null;
        this.rb = null;
        this.rbSilk = null;
        this.id = null;
        SILKGlobal.unregister((PropertyInterface)this);
    }

    @Override
    public void addNotify() {
        Container con;
        for (con = this.getParent(); con != null && !(con instanceof Frame); con = con.getParent()) {
        }
        this.parentFrame = (Frame)con;
        if (!GraphicsEnvironment.isHeadless()) {
            this.createPropertyDialog(this);
            if (this.menu == null) {
                this.menu = this.getPopupMenu();
            }
            this.sDialog = new SurrogateDialog(this.parentFrame);
            this.eDialog = new EnglishRuleDialog(this.parentFrame, this);
        }
        super.addNotify();
        this.repaint();
    }

    public Dialog getDialog(Object id, Object listener) {
        if (id.toString().equalsIgnoreCase("Properties")) {
            if (this.propertiesDialog == null) {
                this.createPropertyDialog(listener);
            }
            return this.propertiesDialog;
        }
        return null;
    }

    private void createPropertyDialog(Object listener) {
        Window parent = null;
        if (listener != null && listener instanceof Component) {
            parent = SwingUtilities.getWindowAncestor(this);
        }
        if (this.propertiesDialog == null) {
            TreeCanvas pi = listener instanceof PropertyInterface ? (PropertyInterface)listener : this;
            JComponent jc = listener instanceof JComponent ? (JComponent)listener : this;
            this.propertiesDialog = new GraphPropertiesDialog((Frame)parent, ResourceLoader.getResourceString((Object)this.rb, (String)"TreeCanvas.Tree_Properties.txt", (String)"Tree Properties"));
            this.graphPanel = new GraphPanel((PropertyInterface)pi, (PropertyInterface)this.toolTip);
            this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"TreeCanvas.Graph.txt", (String)"Graph"), (Component)this.graphPanel);
            GraphPropertiesDialog.PropertiesTreeNode node = this.propertiesDialog.getRootNode((Object)"Chart", true);
            if (this.getId() == null) {
                this.setId(this.generateDefaultChartId(this));
            }
            node.setDisplayName(this.getId().toString());
            this.dtreePanel = new DecisionTreePanel(pi);
            this.nodePanel = new DTreeNodePanel(pi);
            GraphPropertiesDialog.PropertiesTreeNode treeNode = node.createChild((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"TreeCanvas.Tree.txt", (String)"Tree"));
            treeNode.setPanel((Component)this.dtreePanel);
            GraphPropertiesDialog.PropertiesTreeNode panelNode = node.createChild((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"TreeCanvas.Nodes.txt", (String)"Nodes"));
            panelNode.setPanel((Component)this.nodePanel);
            this.titlePanel = new TitlePanel((PropertyInterface)pi, jc);
            this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"TreeCanvas.Title_Footnote.txt", (String)"Title/Footnote"), (Component)this.titlePanel);
            this.propertiesDialog.setSelectedNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"TreeCanvas.Tree.txt", (String)"Tree"));
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = MenuUtilities.getPopupMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/DecisionTreeMenu.xml"), (ActionListener)this);
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.menu, (String)"VIEW_CHART_TIPS", (boolean)this.areChartTipsOn);
            if (this.legend != null) {
                MenuUtilities.setMenuItemSelected((JPopupMenu)this.menu, (String)"VIEW_LEGEND", (boolean)this.legend.isVisible());
            }
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.menu, (String)"VIEW_FIT_TO_PAGE", (boolean)this.fitToPageMode);
            if (!this.fitToPageMode) {
                String mi = "";
                switch (this.xZoomPercentage) {
                    case 25: {
                        mi = "VIEW_25_PERCENT";
                        break;
                    }
                    case 50: {
                        mi = "VIEW_50_PERCENT";
                        break;
                    }
                    case 75: {
                        mi = "VIEW_75_PERCENT";
                        break;
                    }
                    case 100: {
                        mi = "VIEW_100_PERCENT";
                    }
                }
                MenuUtilities.setMenuItemSelected((JPopupMenu)this.menu, (String)mi, (boolean)true);
            }
        }
        return this.menu;
    }

    public void setHoldDisplay(boolean hold) {
        this.holdDisplay = hold;
    }

    public Text getNodeText(boolean flagged) {
        return flagged ? this.flaggedNodeText : this.nodeText;
    }

    private Dimension getLargestNodeSize(TreeNode node, Graphics g) {
        Graphics2D g2 = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
        }
        if (node == null) {
            return null;
        }
        Dimension rc = new Dimension();
        Enumeration<TreeNode> children = null;
        if (node instanceof TreeNodeInterface) {
            rc = this.nodeRenderer.getSize(this.nodesUseTipText ? ((TreeNodeInterface)node).getToolTipText() : ((TreeNodeInterface)node).getNodeText(), node, g2, this.emptyNodes, this.tree.isFlagged(((TreeNodeInterface)node).getId()));
            children = this.tree.getChildren(((TreeNodeInterface)node).getId()).elements();
        } else {
            children = node.children();
            rc = this.nodeRenderer.getSize(node.toString(), node, g2, this.emptyNodes, this.tree.isFlagged(node.toString()));
        }
        if (children != null) {
            while (children.hasMoreElements()) {
                TreeNode obj = children.nextElement();
                if (!(obj instanceof TreeNode)) continue;
                TreeNode n = obj;
                Dimension d = this.getLargestNodeSize(n, g2);
                if (d.width > rc.width) {
                    rc.width = d.width;
                }
                if (d.height <= rc.height) continue;
                rc.height = d.height;
            }
        }
        return rc;
    }

    protected void setNodeSize() {
        if (!this.nodeContentsChanged) {
            return;
        }
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        Dimension d = this.getLargestNodeSize(this.tree.getRoot(), g2);
        if (d == null) {
            return;
        }
        d.width += 2 * DTreeNode.getNodeSpacing();
        d.height += 2 * DTreeNode.getNodeSpacing();
        Rectangle rc = new Rectangle(d);
        rc.width = Math.max(rc.width, 50);
        rc.height = Math.max(rc.height, 50);
        this.nodeSize.width = rc.width;
        this.nodeSize.height = rc.height;
        this.originalNodeSize.width = rc.width;
        this.originalNodeSize.height = rc.height;
        this.nodeContentsChanged = false;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command == null) {
            return;
        }
        if (command.equals("CNTRL-F")) {
            if (this.focusNode == null) {
                return;
            }
            if (this.tree.isFlagged(this.focusNode.getID())) {
                if (this.flaggedNodes.size() == 1) {
                    this.nodeContentsChanged = true;
                }
                this.tree.setFlagged(this.focusNode.getID(), false);
                this.flaggedNodes.remove(this.focusNode);
                if (this.nodeContentsChanged) {
                    this.rebuildNodes();
                }
            } else {
                if (this.flaggedNodes.size() == 0) {
                    this.nodeContentsChanged = true;
                }
                this.tree.setFlagged(this.focusNode.getID(), true);
                this.flaggedNodes.addElement(this.focusNode);
                if (this.nodeContentsChanged) {
                    this.rebuildNodes();
                }
            }
            if (this.fitToPageMode) {
                this.fitToPage();
            }
            this.revalidate();
        } else if (command.equals("SPACEBAR") || command.equals("SHIFT-SPACEBAR")) {
            boolean wasSelected = this.tree.isSelected(this.focusNode.getID());
            for (int i = 0; i < this.selectedNodes.size(); ++i) {
                DTreeNode t = this.searchForNode(this.root, this.selectedNodes.elementAt(i));
                this.tree.setSelected(t.getID(), 0);
            }
            this.selectedNodes = new Vector();
            this.primarySelection = null;
            if (!wasSelected) {
                if (command.equals("SHIFT-SPACEBAR")) {
                    this.tree.setSelected(this.focusNode.getID(), 2);
                    this.primarySelection = this.focusNode;
                } else {
                    this.tree.setSelected(this.focusNode.getID(), 1);
                }
                this.selectedNodes.addElement(this.focusNode.getID());
            }
        } else if (command.equals("CTRL-SPACEBAR") || command.equals("SHIFT-CTRL-SPACEBAR")) {
            if (this.tree.isSelected(this.focusNode.getID())) {
                this.tree.setSelected(this.focusNode.getID(), 0);
                for (int i = 0; i < this.selectedNodes.size(); ++i) {
                    if (!this.selectedNodes.elementAt(i).equals(this.focusNode.getID())) continue;
                    this.selectedNodes.removeElementAt(i);
                }
            } else {
                if (command.equals("CTRL-SPACEBAR")) {
                    this.tree.setSelected(this.focusNode.getID(), 1);
                } else {
                    this.tree.setSelected(this.focusNode.getID(), 2);
                    this.primarySelection = this.focusNode;
                }
                this.selectedNodes.addElement(this.focusNode.getID());
            }
        } else if (command.equals("RIGHT-ARROW")) {
            DTreeNode t = null;
            t = this.orientation == 1 ? this.focusNode.getRightRelative(true) : this.focusNode.getChild();
            if (t != null) {
                this.setFocusNode(t);
            }
        } else if (command.equals("LEFT-ARROW")) {
            DTreeNode t = null;
            t = this.orientation == 1 ? this.focusNode.getLeftRelative(true) : this.focusNode.getParentNode();
            if (t != null) {
                this.setFocusNode(t);
            }
        } else if (command.equals("UP-ARROW")) {
            if (this.focusNode == null) {
                return;
            }
            DTreeNode t = this.orientation == 1 ? this.focusNode.getParentNode() : this.focusNode.getLeftRelative(true);
            if (t != null) {
                this.setFocusNode(t);
            }
        } else if (command.equals("DOWN-ARROW")) {
            if (this.focusNode == null) {
                return;
            }
            DTreeNode t = this.orientation == 1 ? this.focusNode.getChild() : this.focusNode.getRightRelative(true);
            if (t != null) {
                this.setFocusNode(t);
            }
        } else if ("TOOLS_EXPAND_ALL_NODES".equalsIgnoreCase(command) || command.equals("EXPANDALL")) {
            this.expandAll(this.focusNode);
        } else if (command.equals("CloseLegend")) {
            this.legend.setVisible(false);
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.menu, (String)"VIEW_LEGEND", (boolean)false);
            this.updateTree();
        } else if (command.equals("MinimizeLegend")) {
            this.legend.minimized = !this.legend.minimized;
            this.removeAll();
            if (this.legend.minimized) {
                this.legend.setBounds(5, this.getHeight() - 16, 100, 16);
            } else {
                this.legend.setBounds(this.legendPosition.x, this.legendPosition.y, 150, 100);
            }
            this.updateTree();
        } else if ("GRAPH_PROPERTIES".equalsIgnoreCase(command)) {
            this.propertiesDialog.setVisible(true);
        } else if ("COPY".equalsIgnoreCase(command)) {
            CopyToClipboard.toClipboard((JComponent)this);
        } else if ("PRINT".equalsIgnoreCase(command)) {
            Print.print((Object)this);
        } else if ("ACTION_MODE_SELECT".equalsIgnoreCase(command)) {
            this.setActionMode(6);
        } else if ("ACTION_MODE_PAN".equalsIgnoreCase(command)) {
            this.setActionMode(4);
        } else if ("ACTION_MODE_FLAG".equalsIgnoreCase(command)) {
            this.setActionMode(16);
        } else if ("VIEW_NODE_TEXT".equalsIgnoreCase(command)) {
            this.nodeText.setVisible(!this.nodeText.isVisible());
        } else if ("VIEW_CHART_TIPS".equalsIgnoreCase(command)) {
            this.areChartTipsOn = !this.areChartTipsOn;
        } else if ("VIEW_LEGEND".equalsIgnoreCase(command)) {
            this.legend.setVisible(!this.legend.isVisible());
        } else if ("VIEW_100_PERCENT".equalsIgnoreCase(command)) {
            this.setZoom(100);
        } else if ("VIEW_75_PERCENT".equalsIgnoreCase(command)) {
            this.setZoom(75);
        } else if ("VIEW_50_PERCENT".equalsIgnoreCase(command)) {
            this.setZoom(50);
        } else if ("VIEW_25_PERCENT".equalsIgnoreCase(command)) {
            this.setZoom(25);
        } else if ("VIEW_FIT_TO_PAGE".equalsIgnoreCase(command)) {
            this.fitToPageMode = true;
            this.fitToPage();
        } else if (command.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"TreeCanvas.Surrogate.txt", (String)"Surrogate"))) {
            this.sDialog.setVisible(true);
        } else if ("TOOLS_ENGLISH_RULE".equalsIgnoreCase(command)) {
            this.eDialog.setVisible(true);
        } else if ("TOOLS_CLEAR_ALL_FLAGGED_NODES".equalsIgnoreCase(command)) {
            this.clearAllFlaggedNodes();
        } else if ("DEBUG__SAVE_AS_XML".equalsIgnoreCase(command)) {
            Container c;
            for (c = this.getParent(); c != null && !(c instanceof DecisionTree); c = c.getParent()) {
            }
            if (c instanceof DecisionTree) {
                SILKParser.saveAsXML((Object)c, null, (boolean)true);
            }
        } else {
            DTreeNode t = (DTreeNode)((JComponent)ae.getSource()).getParent();
            this.tree.setCollapsed(t.getID(), !t.getCollapse().getCollapsed());
            if (t.getCollapse().getCollapsed()) {
                t.pruneChildren();
            } else {
                this.buildSubtree(this.root, 1);
            }
            this.buildTree();
            Rectangle r = t.getBounds();
            if (r.x > this.getWidth() || r.y > this.getHeight() || r.x < 0 || r.y < 0) {
                this.setFocusNode(t);
            }
            this.revalidate();
            if (this.fitToPageMode) {
                this.fitToPage();
            }
        }
    }

    private void setZoom(int zoomAmount) {
        this.fitToPageMode = false;
        this.setScale(zoomAmount, zoomAmount);
        this.rebuildNodes();
        this.updateTree();
        if (this.root != null) {
            this.scrollRectToVisible(this.root.getBounds());
        }
        this.revalidate();
    }

    public void fitToPage() {
        Dimension rect = this.getViewportExtents();
        if (rect.width == 0 || rect.height == 0 || this.defaultTreeBounds.width == 0 || this.defaultTreeBounds.height == 0) {
            return;
        }
        double a = (double)rect.width / (double)this.defaultTreeBounds.width;
        double b = (double)rect.height / (double)this.defaultTreeBounds.height;
        int x = (int)(a * 100.0);
        int y = (int)(b * 100.0);
        this.setScale(x, y);
        this.rebuildNodes();
        this.updateTree();
        this.revalidate();
    }

    public void clearAllFlaggedNodes() {
        for (int i = 0; i < this.flaggedNodes.size(); ++i) {
            DTreeNode n = (DTreeNode)this.flaggedNodes.elementAt(i);
            this.tree.setFlagged(n.getID(), false);
        }
        this.flaggedNodes = new Vector();
        this.nodeContentsChanged = true;
        this.rebuildNodes();
    }

    public void setLegendVisible(boolean vis) {
        this.legend.setVisible(vis);
    }

    public boolean getLegendVisible() {
        return this.legend.isVisible();
    }

    public void expandAll(DTreeNode t) {
        if (t == null) {
            return;
        }
        this.recursiveExpand(t);
        this.rebuildNodes();
        this.updateTree();
        if (this.fitToPageMode) {
            this.defaultTreeBounds.x = (int)((double)this.treeBounds.x / this.xScale);
            this.defaultTreeBounds.y = (int)((double)this.treeBounds.y / this.yScale);
            this.defaultTreeBounds.width = (int)((double)this.treeBounds.width / this.xScale);
            this.defaultTreeBounds.height = (int)((double)this.treeBounds.height / this.yScale);
            this.fitToPage();
        }
        this.revalidate();
    }

    protected void recursiveExpand(DTreeNode t) {
        t.getCollapse().setColapsed(false);
        this.tree.setCollapsed(t.getID(), false);
        this.buildSubtree(t, 0);
        for (DTreeNode c = t.getChild(); c != null; c = c.getSibling()) {
            this.recursiveExpand(c);
        }
    }

    public DTreeNode getNodeForID(Object ID) {
        return this.searchForNode(this.root, ID);
    }

    private DTreeNode searchForNode(DTreeNode t, Object ID) {
        if (t == null) {
            return null;
        }
        if (t.getID().equals(ID)) {
            return t;
        }
        DTreeNode target = null;
        for (DTreeNode c = t.getChild(); c != null; c = c.getSibling()) {
            target = this.searchForNode(c, ID);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    public void buildTree() {
        double[] linkRange;
        if (this.holdDisplay) {
            return;
        }
        if (this.tree.getVariable("Linkwidth") != null) {
            this.linkWidth = -1;
        }
        if (!this.userSetNodeSize) {
            this.minNodeSize = 2.147483647E9;
            this.maxNodeSize = -2.147483648E9;
        }
        this.minLinkWidth = Integer.MAX_VALUE;
        this.maxLinkWidth = Integer.MIN_VALUE;
        Graphics2D g = (Graphics2D)this.getGraphics();
        this.setNodeSize();
        TreeNode r = this.tree.getRoot();
        if (r == null) {
            return;
        }
        if (!this.tree.isDefined(26) || !this.tree.isDefined(27)) {
            return;
        }
        this.rootSize = Double.NaN;
        if (r instanceof TreeNodeInterface) {
            this.rootSize = ((TreeNodeInterface)r).getNodeSize();
        }
        this.root = new DTreeNode(r, this);
        TreeNodeInterface tni = null;
        if (r instanceof TreeNodeInterface) {
            tni = (TreeNodeInterface)r;
        }
        if (!this.userSetNodeSize && tni != null) {
            if (this.tree.isDefined(2)) {
                if (tni.getNodeColorValue() > this.maxNodeSize) {
                    this.maxNodeSize = tni.getNodeColorValue();
                }
                if (tni.getNodeColorValue() < this.minNodeSize) {
                    this.minNodeSize = tni.getNodeColorValue();
                }
            } else {
                if (tni.getNodeSize() > this.maxNodeSize) {
                    this.maxNodeSize = tni.getNodeSize();
                }
                if (tni.getNodeSize() < this.minNodeSize) {
                    this.minNodeSize = tni.getNodeSize();
                }
            }
        }
        if ((linkRange = this.tree.getVariableMinMax(29)) != null && linkRange.length == 2) {
            this.minLinkWidth = (int)Math.floor(linkRange[0]);
            this.maxLinkWidth = (int)Math.ceil(linkRange[1]);
        } else {
            this.minLinkWidth = 1;
            this.maxLinkWidth = 1;
        }
        double[][] gData = new double[this.numBars][this.numStacks];
        int count = 0;
        if (tni != null && tni.getGraphData() != null) {
            double[] gdata = tni.getGraphData();
            for (int i = 0; i < this.numBars; ++i) {
                for (int j = 0; j < this.numStacks; ++j) {
                    gData[i][j] = gdata[count++];
                }
            }
        }
        this.root.setGraphData(gData);
        this.yMinNode = this.yMaxNode = this.root;
        this.xMaxNode = this.yMaxNode;
        this.xMinNode = this.yMaxNode;
        this.buildSubtree(this.root, 1);
        this.root.setBounds(new Rectangle(this.nodeSize));
        if (this.orientation == 0 && this.linkTextVisible && g != null) {
            FontRenderContext frc = g.getFontRenderContext();
            String str = "MM";
            int w = (int)this.linkText.getStringBounds(str, frc).getWidth();
            this.parentOffset.x = Math.min(25 + (w *= this.linkStringWidth), this.nodeSize.width * 2);
            this.unscaledParentOffset.x = Math.min(25 + w, this.nodeSize.width * 2);
        } else {
            this.unscaledParentOffset.x = 75;
            this.parentOffset.x = 75;
        }
        if (this.focusNode != null) {
            this.setFocusNode(this.searchForNode(this.root, this.focusNode.getID()));
        }
        this.nodeColorRamp.setRange(this.minNodeSize, this.maxNodeSize);
        this.linkColorRamp.setRange((double)this.minLinkWidth, (double)this.maxLinkWidth);
        this.updateTree();
        if (this.xScale < 0.05) {
            this.xScale = 1.0;
        }
        if (this.yScale < 0.05) {
            this.yScale = 1.0;
        }
        this.defaultTreeBounds.x = (int)((double)this.treeBounds.x / this.xScale);
        this.defaultTreeBounds.y = (int)((double)this.treeBounds.y / this.yScale);
        this.defaultTreeBounds.width = (int)((double)this.treeBounds.width / this.xScale);
        this.defaultTreeBounds.height = (int)((double)this.treeBounds.height / this.yScale);
        this.revalidate();
    }

    public void rebuildNodes() {
        if (this.getGraphics() != null) {
            this.setNodeSize();
        }
        this.setScale(this.xZoomPercentage, this.yZoomPercentage);
        if (this.root != null) {
            this.resetSubtree(this.root);
        }
        this.updateTree();
    }

    private void resetSubtree(DTreeNode t) {
        t.setBounds(new Rectangle(this.nodeSize));
        for (DTreeNode c = t.getChild(); c != null; c = c.getSibling()) {
            this.resetSubtree(c);
        }
    }

    public void updateTree() {
        if (this.holdDisplay || this.root == null) {
            return;
        }
        this.removeAll();
        this.adjusted = true;
        this.yMaxNode = null;
        this.yMinNode = null;
        this.xMaxNode = null;
        this.xMinNode = null;
        DTreeLayout.treeLayout(this.root, this.orientation, this.parentOffset);
        this.PositionNode(this.root, new Point());
        int xOffset = this.xMinNode.getBounds().x > 0 ? 0 : Math.abs(this.xMinNode.getBounds().x);
        int yOffset = this.yMinNode.getBounds().y > 0 ? 0 : Math.abs(this.yMinNode.getBounds().y) + this.titles.getBounds().height;
        this.repositionTreeToZero(this.root, xOffset, yOffset);
        this.treeBounds.x = this.xMinNode.getBounds().x;
        this.treeBounds.y = this.yMinNode.getBounds().y;
        this.treeBounds.width = this.xMaxNode.getBounds().x + this.xMaxNode.getBounds().width - this.xMinNode.getBounds().x;
        this.treeBounds.height = this.yMaxNode.getBounds().y + this.yMaxNode.getBounds().height - this.yMinNode.getBounds().y;
        if (this.legend != null) {
            this.add(this.legend);
        }
        int yloc = 0;
        yloc = this.orientation == 1 ? this.root.getBounds().y - this.titles.getBounds().height : this.yMinNode.getBounds().y - this.titles.getBounds().height;
        this.titles.setComponentBounds(0, yloc, this.getWidth(), this.getHeight());
        this.footnote.setComponentBounds(0, 0, this.getWidth(), this.yMaxNode.getBounds().y + this.yMaxNode.getBounds().height + this.footnote.getBounds().height);
    }

    private void repositionTreeToZero(DTreeNode node, int xOffset, int yOffset) {
        Rectangle r = node.getBounds();
        r.x += xOffset;
        r.y += yOffset;
        node.setBounds(r);
        for (DTreeNode c = node.getChild(); c != null; c = c.getSibling()) {
            this.repositionTreeToZero(c, xOffset, yOffset);
        }
    }

    private boolean isValidNode(DTreeNode node) {
        return node != null && this.tree != null && node == this.searchForNode(this.root, node.getID());
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isPrinting && this.printMode == 4) {
            g.drawImage(this.printImage, 0, 0, this);
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.invalid) {
            this.setHoldDisplay(false);
            this.buildTree();
            this.maintainFocusContext();
            this.invalid = false;
        }
        Stroke oldStroke = g2.getStroke();
        if (this.root == null) {
            return;
        }
        if (this.adjusted) {
            this.addTreeNode(this.root);
            this.adjusted = false;
        }
        this.background.drawBackground(g2, (Component)this);
        this.titles.draw((Object)g2, false);
        this.footnote.draw((Object)g2, false);
        g2.setStroke(this.linkStroke);
        this.links = new Vector();
        if (this.orientation == 0) {
            this.drawLinkHorizontal(this.root, g);
        } else {
            this.drawLinkVertical(this.root, g);
        }
        g2.setStroke(oldStroke);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isPrinting && this.printMode == 4) {
            g.drawImage(this.printImage, 0, 0, this);
            return;
        }
        if (this.rbStart != null && this.rbEnd != null) {
            g.setXORMode(this.getBackground());
            g.setColor(Color.black);
            int x1 = Math.min(this.rbStart.x, this.rbEnd.x);
            int y1 = Math.min(this.rbStart.y, this.rbEnd.y);
            int x2 = Math.max(this.rbStart.x, this.rbEnd.x) - x1;
            int y2 = Math.max(this.rbStart.y, this.rbEnd.y) - y1;
            g.drawRect(x1, y1, x2, y2);
        }
        if (this.tipText != null && this.areChartTipsOn && g instanceof Graphics2D) {
            Point tipLoc = new Point(this.tipLocation);
            Rectangle clipBounds = g.getClipBounds();
            Dimension textSize = this.toolTip.getSize(this.tipText, (Graphics2D)g, this);
            if (clipBounds != null && textSize != null) {
                if (tipLoc.x - textSize.width < clipBounds.x) {
                    tipLoc.x = textSize.width + clipBounds.x + 6;
                }
                if (tipLoc.y - textSize.height < clipBounds.y) {
                    tipLoc.y = textSize.height + clipBounds.y + 2;
                }
            }
            this.toolTip.paint(this, (Graphics2D)g, tipLoc, this.tipText);
        }
    }

    @Override
    public int getNumberOfPages() {
        PageFormat pageFormat = this.getPageFormat(0);
        switch (this.printMode) {
            case 1: {
                this.createPrintObjects(pageFormat);
                return this.imagePaginator.getNumberOfPages();
            }
            case 3: {
                this.createPrintObjects(pageFormat);
                return 1;
            }
            case 4: {
                this.createBookPages(pageFormat);
                return this.previewImages.size();
            }
        }
        return 0;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        PageFormat pf = this.getPageFormat();
        if (pf == null) {
            pf = (PageFormat)SILKGlobal.getInstance().getPropertyValue(57);
        }
        return pf;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    private void createPrintObjects(PageFormat pageFormat) {
        if (this.bufImage == null) {
            int prefWidth = this.getWidth();
            int prefHeight = this.getHeight();
            this.bufImage = new BufferedImage(prefWidth, prefHeight, 1);
            this.paint(this.bufImage.getGraphics());
        }
        if (this.imagePaginator == null) {
            this.imagePaginator = new ImagePaginator(this.bufImage);
            if (!this.imagePaginator.isSplit() && pageFormat != null) {
                this.imagePaginator.splitViewToPages(pageFormat);
            }
        }
    }

    private void disposePrintObjects() {
        this.bufImage = null;
        if (this.imagePaginator != null) {
            this.imagePaginator.disposeImages();
        }
        this.imagePaginator = null;
    }

    public void createBookPages(PageFormat pf) {
        if (this.mPageFormat == null) {
            this.mPageFormat = new PageFormat();
            this.calculatePrintableArea(pf);
            if (this.canFitNodeInPage()) {
                this.createPrintTree();
            }
        } else if (this.isPageFormatChanged(pf) || this.rebuild) {
            this.calculatePrintableArea(pf);
            if (this.canFitNodeInPage()) {
                this.createPrintTree();
            }
        }
    }

    public int getPrintMode() {
        return this.printMode;
    }

    public boolean setPrintMode(int printMode) {
        switch (printMode) {
            case 1: 
            case 3: 
            case 4: {
                this.printMode = printMode;
                return true;
            }
        }
        return false;
    }

    public int[] getSupportedPrintModes() {
        return supportedPrintModes;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        this.createPrintObjects(pageFormat);
        switch (this.printMode) {
            case 1: {
                this.createPrintObjects(pageFormat);
                Image img = this.imagePaginator.getImage(pageIndex);
                if (pageIndex == this.imagePaginator.getNumberOfPages() - 1) {
                    this.disposePrintObjects();
                }
                if (img != null) {
                    int x = (int)((pageFormat.getWidth() - pageFormat.getImageableWidth()) / 2.0);
                    int y = (int)((pageFormat.getHeight() - pageFormat.getImageableHeight()) / 2.0);
                    graphics.drawImage(img, x, y, this);
                    return 0;
                }
                return 1;
            }
            case 3: {
                this.createPrintObjects(pageFormat);
                if (pageIndex == 0) {
                    Graphics2D g2 = (Graphics2D)graphics;
                    Dimension d = new Dimension(this.bufImage.getWidth(), this.bufImage.getHeight());
                    double scaleX = pageFormat.getImageableWidth() / (double)d.width;
                    double scaleY = pageFormat.getImageableHeight() / (double)d.height;
                    double scale = Math.min(scaleX, scaleY);
                    double w = scale * (double)d.width;
                    double ht = scale * (double)d.height;
                    int xTrans = (int)Math.max((pageFormat.getImageableWidth() - w) / 2.0, 0.0);
                    int yTrans = (int)Math.max((pageFormat.getImageableHeight() - ht) / 2.0, 0.0);
                    g2.translate(pageFormat.getImageableX() + (double)xTrans, pageFormat.getImageableY() + (double)yTrans);
                    AffineTransform defaultXfm = g2.getTransform();
                    AffineTransform xfm = new AffineTransform(defaultXfm);
                    xfm.scale(scale, scale);
                    g2.setTransform(xfm);
                    g2.drawImage((Image)this.bufImage, 0, 0, this);
                    this.disposePrintObjects();
                    return 0;
                }
                return 1;
            }
            case 4: {
                this.createBookPages(pageFormat);
                Graphics2D g2 = (Graphics2D)graphics;
                BufferedImage image = this.previewImages.get(pageIndex + 1);
                if (pageIndex == this.getNumberOfPages()) {
                    this.previewImages.clear();
                }
                if (image != null) {
                    Hashtable<RenderingHints.Key, Object> hints = new Hashtable<RenderingHints.Key, Object>();
                    hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    g2.addRenderingHints(hints);
                    g2.drawImage((Image)image, 0, 0, this);
                    return 0;
                }
                this.previewImages.clear();
                return 1;
            }
        }
        return 1;
    }

    public int numPages(PageFormat pf) {
        int rc = this.numPagesX(pf) * this.numPagesY(pf);
        return Math.max(1, rc);
    }

    public int numPagesX(PageFormat pf) {
        int rc = this.getScrollableArea().width / (int)pf.getImageableWidth();
        return rc;
    }

    public int numPagesY(PageFormat pf) {
        int rc = this.getScrollableArea().height / (int)pf.getImageableHeight();
        return rc;
    }

    protected void buildSubtree(DTreeNode t, int level) {
        int i;
        String a = t.getAboveText();
        String b = t.getBelowText();
        if (a != null && a.length() > this.linkStringWidth) {
            this.linkStringWidth = a.length();
        }
        if (b != null && b.length() > this.linkStringWidth) {
            this.linkStringWidth = b.length();
        }
        if (this.tree.isSelected(t.getID())) {
            this.selectedNodes.addElement(t.getID());
        }
        t.getCollapse().removeActionListener(this);
        t.getCollapse().addActionListener(this);
        t.removeMouseListener(this);
        t.addMouseListener(this);
        t.removeMouseMotionListener(this);
        t.addMouseMotionListener(this);
        for (i = 0; i < this.mouseListeners.size(); ++i) {
            t.addMouseListener((MouseListener)this.mouseListeners.elementAt(i));
        }
        Vector childrenNodes = this.tree.getChildren(t.getID());
        Vector<DTreeNode> children = new Vector<DTreeNode>();
        for (i = 0; i < childrenNodes.size(); ++i) {
            TreeNode tn = (TreeNode)childrenNodes.elementAt(i);
            TreeNodeInterface r = tn instanceof TreeNodeInterface ? (TreeNodeInterface)tn : null;
            DTreeNode node = new DTreeNode(tn, this);
            if (!this.userSetNodeSize && r != null) {
                if (this.tree.isDefined(2)) {
                    if (r.getNodeColorValue() > this.maxNodeSize) {
                        this.maxNodeSize = r.getNodeColorValue();
                    }
                    if (r.getNodeColorValue() < this.minNodeSize) {
                        this.minNodeSize = r.getNodeColorValue();
                    }
                } else {
                    if (r.getNodeSize() > this.maxNodeSize) {
                        this.maxNodeSize = r.getNodeSize();
                    }
                    if (r.getNodeSize() < this.minNodeSize) {
                        this.minNodeSize = r.getNodeSize();
                    }
                }
            }
            if (r != null && r.getGraphData() != null) {
                double[] g = r.getGraphData();
                double[][] gData = new double[this.numBars][this.numStacks];
                int count = 0;
                for (int q = 0; q < this.numBars; ++q) {
                    for (int j = 0; j < this.numStacks; ++j) {
                        gData[q][j] = g[count++];
                    }
                }
                node.setGraphData(gData);
            }
            children.addElement(node);
        }
        if (children.size() > 0) {
            t.setHasChildren(true);
        }
        if (this.invalid && level >= this.initialDisplayLevel) {
            this.tree.removeTreeModelListener(this);
            this.tree.recursiveSetCollapsed(t.getID(), true);
            t.getCollapse().setColapsed(true);
            this.tree.addTreeModelListener(this);
            return;
        }
        if (t.getCollapse().getCollapsed()) {
            return;
        }
        for (i = 0; i < children.size(); ++i) {
            ((DTreeNode)children.elementAt(i)).setBounds(new Rectangle(this.nodeSize));
            this.buildSubtree((DTreeNode)children.elementAt(i), level + 1);
            TreeLink link = new TreeLink(t, (DTreeNode)children.elementAt(i), this);
            link.setLineWidth(((DTreeNode)children.elementAt(i)).getLinkWidth());
            ((DTreeNode)children.elementAt(i)).setLink(link);
            if (this.searchForNode(this.root, ((DTreeNode)children.elementAt(i)).getID()) != null) continue;
            t.setChild((DTreeNode)children.elementAt(i));
        }
    }

    protected void drawLinkHorizontal(DTreeNode t, Graphics g) {
        if (t.getCollapse().getCollapsed() || t.getBounds().x + t.getBounds().width > this.getBounds().width) {
            return;
        }
        for (DTreeNode c = t.getChild(); c != null; c = c.getSibling()) {
            switch (this.linkStyle) {
                case 1: {
                    c.getLink().drawHorizontalStraight((Graphics2D)g);
                    break;
                }
                case 0: {
                    c.getLink().drawHorizontalManhattan((Graphics2D)g);
                    break;
                }
                case 2: {
                    c.getLink().drawHorizontalTriangle((Graphics2D)g);
                }
            }
            if (this.links != null) {
                this.links.addElement(c.getLink());
            }
            if (c.getChild() == null) continue;
            this.drawLinkHorizontal(c, g);
        }
    }

    protected void drawLinkVertical(DTreeNode t, Graphics g) {
        if (t.getCollapse().getCollapsed() || t.getBounds().y + t.getBounds().height > this.getBounds().height) {
            return;
        }
        for (DTreeNode c = t.getChild(); c != null; c = c.getSibling()) {
            switch (this.linkStyle) {
                case 1: {
                    c.getLink().drawVerticalStraight((Graphics2D)g);
                    break;
                }
                case 0: {
                    c.getLink().drawVerticalManhattan((Graphics2D)g);
                    break;
                }
                case 2: {
                    c.getLink().drawVerticalTriangle((Graphics2D)g);
                }
            }
            if (this.links != null) {
                this.links.addElement(c.getLink());
            }
            if (c.getChild() == null) continue;
            this.drawLinkVertical(c, g);
        }
    }

    public void setFocusNode(DTreeNode node) {
        if (node == null) {
            return;
        }
        if (this.focusNode != null) {
            this.focusNode.isFocus = false;
        }
        node.isFocus = true;
        this.focusNode = node;
        String surrString = this.focusNode.getSurrogateString();
        if (surrString != null) {
            Vector<String> v = new Vector<String>();
            StringTokenizer st = new StringTokenizer(surrString, ":");
            Object[] o = null;
            while (st.hasMoreTokens()) {
                v.addElement(st.nextToken());
            }
            o = new Object[v.size()];
            for (int j = 0; j < v.size(); ++j) {
                o[j] = v.elementAt(j);
            }
            this.sDialog.JList1.setListData(o);
        }
        this.eDialog.setNode(this.focusNode.getID());
        this.scrollRectToVisible(this.focusNode.getBounds());
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orient) {
        if (orient != 1 && orient != 0) {
            return;
        }
        this.orientation = orient;
        if (this.fitToPageMode) {
            this.setScale(100, 100);
        }
        this.buildTree();
        if (this.fitToPageMode) {
            this.fitToPage();
        }
    }

    public DTreeNode getRoot() {
        if (this.root == null) {
            TreeNode n = this.tree.getRoot();
            if (n != null) {
                return new DTreeNode(n, this);
            }
            return null;
        }
        return this.root;
    }

    private void PositionNode(DTreeNode pParent, Point p) {
        Rectangle b = pParent.getBounds();
        b.x = p.x;
        b.y = p.y;
        pParent.setBounds(new Rectangle(b));
        if (this.xMaxNode == null || this.xMaxNode.getBounds().x < b.x) {
            this.xMaxNode = pParent;
        }
        if (this.xMinNode == null || this.xMinNode.getBounds().x > b.x) {
            this.xMinNode = pParent;
        }
        if (this.yMaxNode == null || this.yMaxNode.getBounds().y < b.y) {
            this.yMaxNode = pParent;
        }
        if (this.yMinNode == null || this.yMinNode.getBounds().y > b.y) {
            this.yMinNode = pParent;
        }
        Point ptChild = new Point(p.x, p.y);
        this.treeBounds.x = this.xMinNode.getBounds().x;
        this.treeBounds.y = this.yMinNode.getBounds().y;
        this.treeBounds.width = this.xMaxNode.getBounds().x + this.xMaxNode.getBounds().width - this.treeBounds.x;
        this.treeBounds.height = this.yMaxNode.getBounds().y + this.yMaxNode.getBounds().height - this.treeBounds.y;
        for (DTreeNode pChild = pParent.getChild(); pChild != null; pChild = pChild.getSibling()) {
            ptChild.x += pChild.getBounds().x;
            ptChild.y += pChild.getBounds().y;
            this.PositionNode(pChild, ptChild);
        }
    }

    protected void addTreeNode(DTreeNode t) {
        if (!t.hasChildren()) {
            t.getCollapse().setVisible(false);
        }
        Rectangle r = t.getBounds();
        int space = DTreeNode.getNodeSpacing();
        int wdth = t.getBounds().width;
        if (this.orientation == 0) {
            t.getCollapse().setBounds(wdth - space, r.height / 2 - space / 2, space, space);
        } else {
            t.getCollapse().setBounds(wdth / 2 - space / 2, (int)((double)r.height) - space, space, space);
        }
        this.add(t);
        if (t.getSibling() != null) {
            this.addTreeNode(t.getSibling());
        }
        if (t.getChild() != null) {
            this.addTreeNode(t.getChild());
        }
    }

    public boolean getNodeProbeVisible() {
        return this.areChartTipsOn;
    }

    public void setNodeProbeVisible(boolean b) {
        this.areChartTipsOn = b;
        if (this.menu != null) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.menu, (String)"VIEW_CHART_TIPS", (boolean)this.areChartTipsOn);
        }
    }

    public double[] calculateAxisExtents() {
        double[] d = this.tree.calculateGraphAxisExtents(this.numBars, this.numStacks);
        return d;
    }

    public boolean setActionMode(int s) {
        if (s == 3) {
            this.fitToPageMode = false;
        }
        if (s == 6 || s == 4 || s == 16 || s == 3) {
            this.actionMode = s;
            return true;
        }
        return false;
    }

    public int getActionMode() {
        return this.actionMode;
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        if (this.tooltipTimer != null) {
            this.tooltipTimer.removeActionListener(this.tooltipHandler);
            this.tooltipTimer.addActionListener(this.tooltipHandler);
            this.tooltipTimer.restart();
        }
        if (me.getSource() == this.legend) {
            return;
        }
        if (me.getSource() == this) {
            this.requestFocus();
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.tooltipTimer.restart();
        if (this.actionMode == 6 && me.getSource() == this.legend && this.legend.minimized) {
            this.legend.minimized = false;
            this.legend.setBounds(this.legendPosition.x, this.legendPosition.y, 150, 100);
            this.updateTree();
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.tooltipTimer.restart();
        int flags = me.getModifiers();
        if (this.menu != null && (flags & 4) != 0 && this.showPopup) {
            int x = me.getX();
            int y = me.getY();
            if (me.getSource() instanceof DTreeNode) {
                x += ((DTreeNode)me.getSource()).getBounds().x;
                y += ((DTreeNode)me.getSource()).getBounds().y;
            }
            this.menu.show(this, x, y);
        }
        if (this.actionMode == 6) {
            if (me.getSource() == this.legend) {
                this.legendDragging = true;
                this.legendMousePosition = new Point(me.getX(), me.getY());
                return;
            }
            boolean wasSelected = false;
            if (this.focusNode != null) {
                wasSelected = this.tree.isSelected(this.focusNode.getID());
            }
            if (!me.isControlDown()) {
                for (int i = 0; i < this.selectedNodes.size(); ++i) {
                    this.tree.setSelected(this.selectedNodes.elementAt(i), 0);
                }
                this.selectedNodes = new Vector();
                this.primarySelection = null;
            }
            if (me.getSource() == this) {
                this.rbStart = new Point(me.getX(), me.getY());
                return;
            }
            DTreeNode node = (DTreeNode)me.getSource();
            wasSelected = this.tree.isSelected(node.getID());
            if (wasSelected) {
                this.tree.setSelected(node.getID(), 0);
                for (int i = 0; i < this.selectedNodes.size(); ++i) {
                    if (!this.selectedNodes.elementAt(i).equals(node.getID())) continue;
                    this.selectedNodes.removeElementAt(i);
                }
            } else {
                if (me.isShiftDown()) {
                    this.tree.setSelected(node.getID(), 2);
                    this.primarySelection = node;
                } else {
                    this.tree.setSelected(node.getID(), 1);
                }
                this.selectedNodes.addElement(node.getID());
                this.setFocusNode(node);
            }
        } else if (this.actionMode == 4) {
            if (me.getSource() == this) {
                this.mouseBeginPoint = new Point(me.getX(), me.getY());
            } else if (me.getSource() instanceof DTreeNode) {
                DTreeNode nc = (DTreeNode)me.getSource();
                this.mouseBeginPoint = new Point(me.getX() + nc.getBounds().x, me.getY() + nc.getBounds().y);
            }
        } else if (this.actionMode == 16) {
            if (me.getSource() instanceof DTreeNode) {
                DTreeNode node = (DTreeNode)me.getSource();
                if (this.tree.isFlagged(node.getID())) {
                    if (this.flaggedNodes.size() == 1) {
                        this.nodeContentsChanged = true;
                    }
                    this.tree.setFlagged(node.getID(), false);
                    this.flaggedNodes.remove(node);
                    if (this.nodeContentsChanged) {
                        this.rebuildNodes();
                        if (this.fitToPageMode) {
                            this.fitToPage();
                        }
                        this.revalidate();
                    }
                } else {
                    if (this.flaggedNodes.size() == 0) {
                        this.nodeContentsChanged = true;
                    }
                    this.tree.setFlagged(node.getID(), true);
                    this.flaggedNodes.addElement(node);
                    if (this.nodeContentsChanged) {
                        this.rebuildNodes();
                        if (this.fitToPageMode) {
                            this.fitToPage();
                        }
                        this.revalidate();
                    }
                }
            }
        } else if (this.actionMode == 3) {
            if (me.getSource() == this) {
                this.mouseBeginPoint = new Point(me.getX(), me.getY());
            } else if (me.getSource() instanceof DTreeNode) {
                DTreeNode nc = (DTreeNode)me.getSource();
                this.mouseBeginPoint = new Point(me.getX() + nc.getBounds().x, me.getY() + nc.getBounds().y);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.tipText = null;
        this.tooltipTimer.stop();
        this.tooltipTimer.removeActionListener(this.tooltipHandler);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.tooltipTimer.restart();
        this.legendDragging = false;
        this.legendMousePosition = null;
        if (this.rbStart == null || this.rbEnd == null) {
            return;
        }
        int x1 = Math.min(this.rbStart.x, this.rbEnd.x);
        int y1 = Math.min(this.rbStart.y, this.rbEnd.y);
        int x2 = Math.max(this.rbStart.x, this.rbEnd.x) - x1;
        int y2 = Math.max(this.rbStart.y, this.rbEnd.y) - y1;
        Rectangle rb = new Rectangle(x1, y1, x2, y2);
        this.bbSelect(rb, this.root);
        this.rbEnd = null;
        this.rbStart = null;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.tooltipTimer.restart();
        if (this.actionMode == 6) {
            if (this.legendDragging) {
                int x = me.getX() + this.legend.getBounds().x - this.legendMousePosition.x;
                int y = me.getY() + this.legend.getBounds().y - this.legendMousePosition.y;
                this.legend.setLocation(x, y);
                this.legendPosition = new Point(x, y);
            } else {
                this.rbEnd = new Point(me.getX(), me.getY());
            }
        } else if (this.actionMode == 4) {
            int y;
            int x;
            if (me.getSource() instanceof DTreeNode) {
                DTreeNode nc = (DTreeNode)me.getSource();
                x = this.mouseBeginPoint.x - (me.getX() + nc.getBounds().x);
                y = this.mouseBeginPoint.y - (me.getY() + nc.getBounds().y);
            } else {
                x = this.mouseBeginPoint.x - me.getX();
                y = this.mouseBeginPoint.y - me.getY();
            }
            Rectangle r = this.getVisibleRect();
            r.translate(x, y);
            this.scrollRectToVisible(r);
        } else if (this.actionMode == 3) {
            int deltay = this.mouseBeginPoint.y - me.getY();
            int deltax = this.mouseBeginPoint.x - me.getX();
            double yper = (double)deltay / (double)this.getHeight();
            double xper = (double)deltax / (double)this.getWidth();
            yper = 1.0 + yper;
            xper = 1.0 + xper;
            int xzoom = (int)((double)this.xZoomPercentage * xper);
            xzoom = Math.max(25, xzoom);
            xzoom = Math.min(200, xzoom);
            int yzoom = (int)((double)this.yZoomPercentage * yper);
            yzoom = Math.max(25, yzoom);
            yzoom = Math.min(200, yzoom);
            this.mouseBeginPoint = me.getPoint();
            this.setScale(xzoom, yzoom);
            this.rebuildNodes();
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.tempME.setSource(me.getSource());
        this.tipText = null;
        this.tooltipTimer.restart();
        this.tipLocation = me.getPoint();
        if (me.getSource() instanceof DTreeNode) {
            DTreeNode node = (DTreeNode)me.getSource();
            this.tipLocation.translate(node.getX(), node.getY());
        }
        this.repaint();
    }

    @Override
    public void treeDataChanged(TreeModelEvent te) {
        this.buildTree();
        this.maintainFocusContext();
        this.repaint();
    }

    @Override
    public void interactionChange(TreeModelEvent te) {
        if (StringCompare.equals((String)te.variableRole, (String)"Selected")) {
            DTreeNode node = this.searchForNode(this.root, te.nodeID);
            if (node != null) {
                this.setFocusNode(node);
                if (this.tree.isSelected(te.nodeID)) {
                    this.selectedNodes.addElement(node.getID());
                }
            }
        } else if (StringCompare.equals((String)te.variableRole, (String)"Collapsed")) {
            DTreeNode t = this.searchForNode(this.root, te.nodeID);
            t.getCollapse().setColapsed(this.tree.isCollapsed(te.nodeID));
            t.setChild(null);
            this.buildSubtree(t, 0);
            this.rebuildNodes();
        } else {
            this.updateTree();
        }
        this.repaint();
    }

    @Override
    public void graphDataChanged(TreeModelEvent te) {
        this.hasNodeGraphs = this.tree.hasGraphData();
        this.buildTree();
        this.repaint();
    }

    private void bbSelect(Rectangle bb, DTreeNode t) {
        if (t == null) {
            return;
        }
        if (bb.intersects(t.getBounds())) {
            this.tree.setSelected(t.getID(), 1);
            this.selectedNodes.addElement(t.getID());
        }
        for (DTreeNode c = t.getChild(); c != null; c = c.getSibling()) {
            this.bbSelect(bb, c);
        }
    }

    public TreeModelInterface getTreeModel() {
        return this.tree;
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        super.addMouseListener(ml);
        if (ml != this) {
            this.mouseListeners.addElement(ml);
        }
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        super.removeMouseListener(ml);
        if (this.mouseListeners != null) {
            this.mouseListeners.remove(ml);
        }
    }

    public ColorSchemeInterface getColorScheme() {
        return new ColorScheme(this.style);
    }

    public String getColorSchemeName() {
        if (this.style == null) {
            return null;
        }
        return this.style.getSchemeName();
    }

    public boolean setColorScheme(Object newScheme) {
        return this.setStyle(newScheme);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setStyle(Object o) {
        if (o == null) {
            this.style = null;
        } else {
            if (o.equals(this.style)) {
                return true;
            }
            if (o instanceof Style) {
                this.style = (Style)o;
            } else if (o instanceof String) {
                StyleCollection sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48);
                if (sc.getStyle((String)o) == null) return false;
                this.style = sc.getStyle((String)o);
            } else {
                if (!(o instanceof ColorScheme)) return false;
                this.style = ((ColorScheme)o).getStyle();
            }
        }
        if (this.style == null) {
            return false;
        }
        Color bc = this.style.getFillStyleElement("Backfill").getFillColor();
        this.background.setSolidBackground((Object)bc);
        this.background.setCurrentValueAsDefault(21);
        this.nodeColorRamp.setColors((Object)this.style.getRampStyleElement("TwoColorAltRamp").getColors(), this.minNodeSize, this.maxNodeSize);
        this.nodeContentsChanged = true;
        this.linkColorRamp.setColors((Object)this.style.getRampStyleElement("TwoColorRamp").getColors(), (double)this.minLinkWidth, (double)this.maxLinkWidth);
        if (this.graphNodeRenderer instanceof GraphNodeRenderer) {
            ((GraphNodeRenderer)this.graphNodeRenderer).setupColors();
        }
        this.toolTip.applyStyle(this.style);
        if (this.titles != null) {
            this.titles.applyStyle(this.style);
        }
        if (this.footnote != null) {
            this.footnote.applyStyle(this.style);
        }
        this.repaint();
        return true;
    }

    public void setScale(int xPer, int yPer) {
        this.xScale = (double)xPer / 100.0;
        this.yScale = (double)yPer / 100.0;
        this.xZoomPercentage = xPer;
        this.yZoomPercentage = yPer;
        this.xScale = (double)this.xZoomPercentage / 100.0;
        this.yScale = (double)this.yZoomPercentage / 100.0;
        this.nodeSize.width = (int)((double)this.originalNodeSize.width * this.xScale);
        this.nodeSize.height = (int)((double)this.originalNodeSize.height * this.yScale);
        this.nodeSize.width = Math.max(this.nodeSize.width, 50);
        this.nodeSize.height = Math.max(this.nodeSize.height, 50);
        this.parentOffset.x = (int)((double)this.unscaledParentOffset.x * this.xScale);
        this.parentOffset.y = (int)((double)this.unscaledParentOffset.y * this.yScale);
        this.repaint();
    }

    public String getTipText(int screenX, int screenY) {
        this.tempME.translatePoint(-this.tempME.getX(), -this.tempME.getY());
        this.tempME.translatePoint(screenX, screenY);
        return this.getToolTipText(this.tempME);
    }

    @Override
    public String getToolTipText(MouseEvent me) {
        Point p = me.getPoint();
        if (me.getSource() instanceof DTreeNode) {
            return ((DTreeNode)me.getSource()).getTipText();
        }
        if (this.links != null) {
            for (int i = 0; i < this.links.size(); ++i) {
                TreeLink t = (TreeLink)this.links.elementAt(i);
                if (t.aboveRect != null && t.aboveRect.contains(p)) {
                    return t.from.getBelowText();
                }
                if (t.belowRect == null || !t.belowRect.contains(p)) continue;
                return t.to.getAboveText();
            }
        }
        return null;
    }

    public void removeMenuItem(String item) {
    }

    public Object getPropertyValue(int idx) {
        Object rc = null;
        if (this.pending != null && this.pending.isPending(idx)) {
            return this.pending.getValueById(idx);
        }
        switch (idx) {
            case 29: {
                rc = this.style;
                break;
            }
            case 30: {
                rc = this.imageList;
                break;
            }
            case 28: {
                rc = new Boolean(this.imageList != null);
                break;
            }
            case 2: {
                rc = new Boolean(this.areChartTipsOn);
                break;
            }
            case 5000: {
                rc = new Integer(this.orientation);
                break;
            }
            case 5004: {
                rc = new Integer(this.linkWidth);
                break;
            }
            case 5007: {
                rc = new Boolean(this.useLinkColorRamp);
                break;
            }
            case 5001: {
                rc = new Integer(this.linkStyle);
                break;
            }
            case 5008: {
                rc = new Double(this.linkTransparency);
                break;
            }
            case 5003: {
                rc = new Boolean(this.linkTextVisible);
                break;
            }
            case 5005: {
                rc = this.linkSolidColor;
                break;
            }
            case 5002: {
                rc = this.linkText;
                break;
            }
            case 5006: {
                rc = this.linkColorRamp;
                break;
            }
            case 5009: {
                rc = new Boolean(this.emptyNodes);
                break;
            }
            case 5010: {
                rc = new Boolean(this.showNodeLabels);
                break;
            }
            case 5011: {
                rc = this.primarySelectionColor;
                break;
            }
            case 5012: {
                rc = this.nodeText;
                break;
            }
            case 5013: {
                rc = new Boolean(this.showNodeGraphs);
                break;
            }
            case 5014: {
                rc = this.nodeColorRamp;
                break;
            }
            case 5015: {
                rc = new Boolean(this.useNodeColorRamp);
                break;
            }
            case 5016: {
                rc = this.nodeBackground;
                break;
            }
            case 5017: {
                rc = new Integer(this.nodeOutlineWidth);
                break;
            }
            case 5018: {
                rc = this.flaggedNodeText;
                break;
            }
            case 5020: {
                rc = new Integer(this.flaggedNodeOutlineWidth);
                break;
            }
            case 5019: {
                rc = new Boolean(this.showFlaggedNodeGraphs);
                break;
            }
            case 5021: {
                rc = this.flaggedNodeBackground;
                break;
            }
            case 5026: {
                rc = new Boolean(this.tree.hasGraphData());
                break;
            }
            case 5024: {
                rc = this.nodeGraphAxisRange;
                break;
            }
            case 5022: {
                rc = new Integer(this.numBars);
                break;
            }
            case 5023: {
                rc = new Integer(this.numStacks);
                break;
            }
            case 5025: {
                rc = new Integer(this.nodeGraphOrientation);
                break;
            }
            case 5027: {
                rc = new Boolean(this.nodesUseTipText);
                break;
            }
            case 5028: {
                rc = new Boolean(this.tree.getVariable(RoleInterface.ROLE_LINK_WIDTH) != null);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                rc = this.background.getPropertyValue(idx);
                break;
            }
            case 601: {
                rc = this.titles.getTitle(0);
                break;
            }
            case 602: {
                rc = this.titles.getTitle(1);
                break;
            }
            case 603: {
                rc = this.footnote.getFootnote(0);
                break;
            }
            case 5032: {
                rc = this.flaggedNodeSupported;
            }
        }
        return rc;
    }

    public boolean setPropertyValue(int idx, Object value) {
        switch (idx) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                this.background.setPropertyValue(idx, value);
                break;
            }
            default: {
                this.pending.store(idx, value);
            }
        }
        return true;
    }

    public int getNumberProperties() {
        return -1;
    }

    public boolean applyPropertyChanges(Object source) {
        this.background.applyPropertyChanges();
        Vector changes = this.pending.getChangesBySource(source);
        block37: for (int i = 0; i < changes.size(); ++i) {
            PropertyEvent event = (PropertyEvent)changes.elementAt(i);
            int key = event.id;
            Object value = event.value;
            switch (key) {
                case 0: {
                    this.setColorScheme(value);
                    continue block37;
                }
                case 29: {
                    this.setStyle(value);
                    continue block37;
                }
                case 30: {
                    if (!(value instanceof ImageListInterface)) continue block37;
                    this.imageList = (ImageListInterface)value;
                    continue block37;
                }
                case 2: {
                    if (value instanceof Boolean) {
                        this.areChartTipsOn = (Boolean)value;
                    }
                    MenuUtilities.setMenuItemSelected((JPopupMenu)this.menu, (String)"VIEW_CHART_TIPS", (boolean)this.areChartTipsOn);
                    continue block37;
                }
                case 5000: {
                    if (!(value instanceof Number)) continue block37;
                    this.setOrientation(((Number)value).intValue());
                    continue block37;
                }
                case 5004: {
                    if (!(value instanceof Number)) continue block37;
                    this.linkWidth = ((Number)value).intValue();
                    continue block37;
                }
                case 5007: {
                    if (!(value instanceof Boolean)) continue block37;
                    this.useLinkColorRamp = (Boolean)value;
                    continue block37;
                }
                case 5001: {
                    if (!(value instanceof Number)) continue block37;
                    this.linkStyle = ((Number)value).intValue();
                    continue block37;
                }
                case 5008: {
                    if (!(value instanceof Double)) continue block37;
                    this.linkTransparency = (Double)value;
                    continue block37;
                }
                case 5003: {
                    if (!(value instanceof Boolean)) continue block37;
                    this.linkTextVisible = (Boolean)value;
                    continue block37;
                }
                case 5005: {
                    if (!(value instanceof Color)) continue block37;
                    this.linkSolidColor = (Color)value;
                    continue block37;
                }
                case 5006: {
                    if (!(value instanceof ColorInterface)) continue block37;
                    this.linkColorRamp = (ColorInterface)value;
                    continue block37;
                }
                case 5009: {
                    if (value instanceof Boolean) {
                        this.emptyNodes = (Boolean)value;
                    }
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5010: {
                    if (value instanceof Boolean) {
                        this.showNodeLabels = (Boolean)value;
                    }
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5011: {
                    if (!(value instanceof Color)) continue block37;
                    this.primarySelectionColor = (Color)value;
                    continue block37;
                }
                case 5013: {
                    if (value instanceof Boolean) {
                        this.showNodeGraphs = (Boolean)value;
                    }
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5014: {
                    if (value instanceof ColorInterface) {
                        this.nodeColorRamp = (ColorInterface)value;
                    }
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5015: {
                    if (value instanceof Boolean) {
                        this.useNodeColorRamp = (Boolean)value;
                    }
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5016: {
                    if (value instanceof GraphBackground) {
                        this.nodeBackground = (GraphBackground)value;
                    }
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5021: {
                    if (value instanceof GraphBackground) {
                        this.flaggedNodeBackground = (GraphBackground)value;
                    }
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5017: {
                    if (!(value instanceof Number)) continue block37;
                    this.nodeOutlineWidth = ((Number)value).intValue();
                    continue block37;
                }
                case 5020: {
                    if (!(value instanceof Number)) continue block37;
                    this.flaggedNodeOutlineWidth = ((Number)value).intValue();
                    continue block37;
                }
                case 5019: {
                    if (value instanceof Boolean) {
                        this.showFlaggedNodeGraphs = (Boolean)value;
                    }
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5024: {
                    this.nodeGraphAxisRange = (double[])value;
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5022: {
                    if (value instanceof Number) {
                        this.numBars = ((Number)value).intValue();
                    }
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5023: {
                    if (value instanceof Number) {
                        this.numStacks = ((Number)value).intValue();
                    }
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5025: {
                    if (!(value instanceof Number)) continue block37;
                    int j = ((Number)value).intValue();
                    if (j == 1 || j == 0) {
                        this.nodeGraphOrientation = j;
                    }
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5027: {
                    if (!(value instanceof Boolean)) continue block37;
                    this.nodesUseTipText = (Boolean)value;
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 604: {
                    if (value instanceof String) {
                        this.titles.setTitle(0, (String)value);
                        continue block37;
                    }
                    if (!(value instanceof TextInterface)) continue block37;
                    this.titles.setTitle(0, (TextStyleInterface)((TextInterface)value));
                    continue block37;
                }
                case 605: {
                    if (value instanceof String) {
                        this.titles.setTitle(1, (String)value);
                        continue block37;
                    }
                    if (!(value instanceof TextInterface)) continue block37;
                    this.titles.setTitle(1, (TextStyleInterface)((TextInterface)value));
                    continue block37;
                }
                case 606: {
                    if (value instanceof String) {
                        this.footnote.setFootnote(0, (String)value);
                        continue block37;
                    }
                    if (!(value instanceof TextInterface)) continue block37;
                    this.footnote.setFootnote(0, (TextStyleInterface)((TextInterface)value));
                    continue block37;
                }
                case 5029: {
                    if (!(value instanceof Color)) continue block37;
                    this.nodeBackground.setSolidBackground(value);
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5030: {
                    if (!(value instanceof Color)) continue block37;
                    this.flaggedNodeBackground.setSolidBackground(value);
                    this.nodeContentsChanged = true;
                    continue block37;
                }
                case 5031: {
                    if (!(value instanceof Integer)) continue block37;
                    if ((Integer)value == -999) {
                        this.setFitToPageMode(true);
                        continue block37;
                    }
                    int j = ((Number)value).intValue();
                    this.setZoom(j);
                    continue block37;
                }
                case 5032: {
                    if (!(value instanceof Boolean)) continue block37;
                    this.flaggedNodeSupported = (Boolean)value;
                }
            }
        }
        if (this.nodeContentsChanged) {
            this.rebuildNodes();
            if (this.fitToPageMode) {
                this.fitToPage();
            }
            this.revalidate();
        }
        this.pending.removeChangesBySource(source);
        this.repaint();
        return true;
    }

    public void cancelPropertyChanges(Object source) {
        this.background.cancelPropertyChanges(source);
        this.pending.removeChangesBySource(source);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public boolean isPropertySupported(int idx) {
        return false;
    }

    public boolean isPropertyPending(int idx) {
        return this.pending.isPending(idx);
    }

    public int getNumberPendingProperties() {
        return -1;
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        return rc;
    }

    public void enablePopup(boolean enable) {
        this.showPopup = enable;
    }

    public void reset() {
        this.nodeSize = new Rectangle(0, 0, 200, 100);
        this.originalNodeSize = new Rectangle(0, 0, 200, 100);
        this.nodeContentsChanged = true;
        this.invalid = true;
    }

    public void textUpdated(DvrTextEvent evt) {
        if (this.root != null) {
            this.titles.setComponentBounds(0, this.root.getBounds().y - 50, this.getWidth(), this.getHeight());
            this.footnote.setComponentBounds(0, 0, this.getWidth(), this.yMaxNode.getBounds().x + this.yMaxNode.getBounds().height + this.footnote.getBounds().height);
        }
        this.nodeContentsChanged = true;
        this.updateTree();
        this.rebuildNodes();
        if (this.fitToPageMode) {
            this.fitToPage();
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getScrollableArea().getSize();
    }

    public Rectangle getScrollableArea() {
        if (this.root == null) {
            return new Rectangle();
        }
        return new Rectangle(this.treeBounds.x, this.treeBounds.y - this.titles.getBounds().height, this.treeBounds.width, this.treeBounds.height + this.titles.getBounds().height + this.footnote.getBounds().height);
    }

    public void addDrilldownListener(DrilldownListenerInterface dli) {
        if (dli != null) {
            this.drilldownListeners.addElement(dli);
        }
    }

    public void removeDrilldownListener(DrilldownListenerInterface dli) {
        if (dli != null && this.drilldownListeners.contains(dli)) {
            this.drilldownListeners.removeElement(dli);
        }
    }

    protected void fireDrilldownEvent(String s) {
        DrilldownEvent de = new DrilldownEvent(s);
        for (int i = 0; i < this.drilldownListeners.size(); ++i) {
            ((DrilldownListenerInterface)this.drilldownListeners.elementAt(i)).drilldown(de);
        }
    }

    public boolean isFitToPageMode() {
        return this.fitToPageMode;
    }

    public void setFitToPageMode(boolean fitToPageMode) {
        this.fitToPageMode = fitToPageMode;
    }

    private Dimension getViewportExtents() {
        Container c = this.getParent();
        if (c instanceof JViewport) {
            return ((JViewport)c).getExtentSize();
        }
        return this.getSize();
    }

    public void setNodeUseTipText(boolean use) {
        this.nodesUseTipText = use;
        this.nodeContentsChanged = true;
        this.rebuildNodes();
        if (this.fitToPageMode) {
            this.fitToPage();
        }
        this.revalidate();
        this.repaint();
    }

    public boolean isNodeUseTipText() {
        return this.nodesUseTipText;
    }

    public NodeRenderer getNodeRenderer() {
        return this.nodeRenderer;
    }

    public void setNodeRenderer(NodeRenderer r) {
        if (r == null) {
            return;
        }
        this.nodeRenderer = r;
        this.nodeContentsChanged = true;
        this.buildTree();
        this.repaint();
    }

    public NodeRenderer getTooltipRenderer() {
        return this.toolTip.getRenderer();
    }

    public void setTooltipRenderer(NodeRenderer r) {
        this.toolTip.setRenderer(r);
    }

    public TextStyleInterface getLinkText() {
        return this.linkText;
    }

    public void setLinkText(TextStyleInterface linkText) {
        if (linkText == null) {
            return;
        }
        Text txt = new Text(linkText);
        txt.setJustifySupported(false);
        txt.setFormatSupported(false);
        txt.addTextListener((TextListenerInterface)this);
        if (this.linkText != null) {
            this.linkText.removeTextListener((TextListenerInterface)this);
        }
        this.linkText = txt;
    }

    private void maintainFocusContext() {
        if (this.fitToPageMode) {
            this.fitToPage();
        } else if (this.isValidNode(this.focusNode)) {
            this.scrollRectToVisible(this.focusNode.getBounds());
        } else if (this.root != null) {
            this.scrollRectToVisible(this.root.getBounds());
        }
    }

    public AxisInterface getAxis(Object which) {
        return null;
    }

    public boolean setExternalAxis(Object which, AxisInterface axis) {
        return false;
    }

    public LegendInterface getLegend(Object which) {
        return null;
    }

    public Component getToolBar() {
        return null;
    }

    public boolean setToolBar(Component d) {
        return false;
    }

    public int getSelectionBehavior() {
        return 0;
    }

    public Object getSelectionBehaviorValue() {
        return null;
    }

    public boolean setSelectionBehavior(int behavior, Object value) {
        return false;
    }

    public Object getLegendPosition(Object which) {
        return ResourceLoader.getResourceString((Object)this.rbSilk, (String)"DecisionTree.Floating.txt", (String)"Floating");
    }

    public boolean setLegendPosition(Object which, Object positionIn) {
        return false;
    }

    public Rectangle getLegendBounds() {
        return null;
    }

    public boolean setLegendBounds(Rectangle rect) {
        return false;
    }

    public boolean isModelAttributeHonored(Object attribute) {
        return false;
    }

    public boolean setHonorModelAttribute(Object attribute, boolean honorit) {
        return false;
    }

    public void addViewportListener(Object listener) {
    }

    public void removeViewportListener(Object listener) {
    }

    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        return false;
    }

    public TipInterface getChartTip() {
        return this.toolTip;
    }

    public String getStyle() {
        if (this.style == null) {
            return null;
        }
        return this.style.getStyleName();
    }

    public void setTitle(String t) {
        this.titles.setTitle(0, t);
    }

    public boolean setTitle(int index, String textString) {
        this.setTitle(textString);
        return true;
    }

    public boolean setTitle(int index, TextStyleInterface textObject) {
        if (this.titles != null) {
            this.titles.setText(index, textObject);
            return true;
        }
        return false;
    }

    public TextStyleInterface getTitle(int index) {
        if (this.titles != null) {
            return this.titles.getTitle(index);
        }
        return null;
    }

    public void setFootnote(String s) {
        this.footnote.setFootnote(0, s);
    }

    public boolean setFootnote(int index, String textString) {
        this.setFootnote(textString);
        return true;
    }

    public boolean setFootnote(int index, TextStyleInterface textObject) {
        this.footnote.setFootnote(index, textObject);
        return true;
    }

    public TextStyleInterface getFootnote(int index) {
        return this.footnote.getFootnote(index);
    }

    public boolean isEditable() {
        return false;
    }

    public boolean setEditable(boolean editable) {
        return false;
    }

    public boolean getUsageMode(int mode) {
        return false;
    }

    public void setUsageMode(int mode, boolean on) {
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    public boolean areChartTipsOn() {
        return this.getNodeProbeVisible();
    }

    public void setChartTipsOn(boolean b) {
        this.setNodeProbeVisible(b);
    }

    public DataFilterReadInterface getFilter() {
        return this.getTreeModel().getFilter();
    }

    public DataFilterReadInterface getFilter(Object id) {
        return this.getFilter();
    }

    public boolean setDataListening(boolean b) {
        this.tree.setListening(b);
        return true;
    }

    public boolean isDataListening() {
        return this.tree.isListening();
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        if (this.tree == null) {
            return false;
        }
        DataFilterReadInterface dfri = this.tree.getFilter();
        return dfri.applyWhereClause(clause, clearPrevious);
    }

    public String getWhereClause() {
        if (this.tree == null) {
            return null;
        }
        DataFilterReadInterface dfri = this.tree.getFilter();
        return dfri.getWhereClause();
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public boolean isBackBufferDrawEnabled() {
        return false;
    }

    public void setBackBufferDrawEnabled(boolean drawback) {
    }

    public Object getChartObject(Object id) {
        return this;
    }

    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    public boolean isActionEnabled(String action) {
        return true;
    }

    public AnnotateInterface getAnnotate() {
        return null;
    }

    private String generateDefaultChartId(Object chart) {
        String id = "Chart";
        SILKChartInfo info = SILKChartInfo.getInstance((Object)chart);
        if (info != null) {
            id = info.getDisplayName();
        }
        return id;
    }

    public void createPrintTree() {
        this.printImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics g = this.printImage.getGraphics();
        this.paint(g);
        this.isPrinting = true;
        this.printableNodes.clear();
        this.buildPrintableTree();
        this.runPrintAlgorithm();
        if (this.pageOrder == 0) {
            this.assignPageNumberBFS();
        } else {
            this.assignPageNumberDFS();
        }
        this.createPageReferences();
        this.generatePrintPages();
        this.isPrinting = false;
        this.rebuildNodes();
        this.updateTree();
        this.repaint();
        this.printImage = null;
    }

    private void buildPrintableTree() {
        this.printableRoot = new PrintableNode(this.root);
        this.printableNodes.add(this.printableRoot);
        this.printableRoot.setLevel(0);
        this.buildPrintableSubtree(this.printableRoot, 1);
        if (this.maxTreeDepth == -1) {
            this.maxTreeDepth = this.getTreeDepth();
        }
        if (this.userTreeDepth == -1) {
            this.userTreeDepth = this.maxTreeDepth;
        }
        this.traverseTreeInBFS();
    }

    private int buildPrintableSubtree(PrintableNode root, int level) {
        if (this.userTreeDepth != -1 && level > this.userTreeDepth) {
            return this.userTreeDepth;
        }
        DTreeNode t = root.getDTreeNode();
        int depth = root.getLevel();
        for (DTreeNode childNode = t.getChild(); childNode != null; childNode = childNode.getSibling()) {
            PrintableNode printableChildNode = new PrintableNode(childNode);
            printableChildNode.setLevel(depth + 1);
            this.printableNodes.add(printableChildNode);
            root.setChild(printableChildNode);
            printableChildNode.setParent(root);
            if (t.getCollapse().getCollapsed()) {
                return -1;
            }
            int n = ++level;
            --level;
            this.buildPrintableSubtree(printableChildNode, n);
        }
        return level;
    }

    private int getTreeDepth() {
        int depth = 0;
        for (PrintableNode node : this.printableNodes) {
            if (node.getLevel() <= depth) continue;
            depth = node.getLevel();
        }
        return depth;
    }

    private boolean canFitNodeInPage() {
        boolean proceed = true;
        Rectangle pageBounds = new Rectangle(0, 0, PRINTABLE_PAGE_WIDTH, PRINTABLE_PAGE_HEIGHT);
        DTreeNode pNode = new DTreeNode(this.tree.getRoot(), this);
        pNode.setSize(this.root.getSize());
        DTreeLayout.treeLayout(pNode, this.orientation, this.parentOffset);
        Rectangle nodeBounds = pNode.getBounds();
        if (!pageBounds.contains(nodeBounds)) {
            proceed = false;
        }
        if (pNode.getCollapse().getCollapsed()) {
            return proceed;
        }
        Vector childrenNodes = this.tree.getChildren(pNode.getID());
        if (childrenNodes != null && childrenNodes.size() > 0) {
            TreeNode tn = (TreeNode)childrenNodes.elementAt(0);
            DTreeNode cNode = new DTreeNode(tn, this);
            cNode.setSize(pNode.getSize());
            pNode.setChild(cNode);
            DTreeLayout.treeLayout(pNode, this.orientation, this.parentOffset);
            Rectangle treeBounds = new Rectangle();
            treeBounds.x = pNode.getBounds().x;
            treeBounds.y = pNode.getBounds().y;
            if (this.orientation == 1) {
                treeBounds.width = pNode.getBounds().x + pNode.getBounds().width;
                treeBounds.height = cNode.getBounds().y + cNode.getBounds().height + this.titles.getBounds().height + 10;
            } else {
                treeBounds.width = cNode.getBounds().x + cNode.getBounds().width;
                treeBounds.height = pNode.getBounds().x + pNode.getBounds().height + this.titles.getBounds().height + 10;
            }
            if (!pageBounds.contains(treeBounds)) {
                proceed = false;
            }
        }
        return proceed;
    }

    private void traverseTreeInDFS() {
        this.printableNodes.clear();
        this.printableNodes.add(this.printableRoot);
        this.traverseTreeInDFS(this.printableRoot);
    }

    private void traverseTreeInDFS(PrintableNode node) {
        for (PrintableNode t = node.getChild(); t != null; t = t.getSibling()) {
            this.printableNodes.add(t);
            this.traverseTreeInDFS(t);
        }
    }

    private void traverseTreeInBFS() {
        this.printableNodes.clear();
        LinkedList<PrintableNode> BFSQueue = new LinkedList<PrintableNode>();
        BFSQueue.add(this.printableRoot);
        while (!BFSQueue.isEmpty()) {
            PrintableNode n = (PrintableNode)BFSQueue.removeFirst();
            this.printableNodes.add(n);
            if (n.getChild() == null) continue;
            PrintableNode childNode = n.getChild();
            BFSQueue.addLast(childNode);
            for (PrintableNode t = childNode.getSibling(); t != null; t = t.getSibling()) {
                BFSQueue.addLast(t);
            }
        }
    }

    private void setPrintableFlag(boolean flag) {
        Iterator<PrintableNode> iterator = this.printableNodes.iterator();
        while (iterator.hasNext()) {
            iterator.next().setPrintable(flag);
        }
    }

    private void setVisitedFlag(boolean flag) {
        Iterator<PrintableNode> iterator = this.printableNodes.iterator();
        while (iterator.hasNext()) {
            iterator.next().setVisited(flag);
        }
    }

    private boolean isCompleteTreeVisited() {
        boolean flag = true;
        Iterator<PrintableNode> iterator = this.printableNodes.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isVisited()) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private void runPrintAlgorithm() {
        int pageWidth = PRINTABLE_PAGE_WIDTH;
        int pageHeight = PRINTABLE_PAGE_HEIGHT;
        PrintablePage PPGObject = new PrintablePage();
        Rectangle pageBounds = new Rectangle(0, 0, pageWidth, pageHeight);
        this.yMaxPrintNode = null;
        this.yMinPrintNode = null;
        this.xMaxPrintNode = null;
        this.xMinPrintNode = null;
        this.printablePages.clear();
        this.printablePages.add(PPGObject);
        block0: while (!this.isCompleteTreeVisited()) {
            this.setPrintableFlag(false);
            for (PrintableNode node : this.printableNodes) {
                if (node.isVisited()) continue;
                node.setVisited(true);
                node.setPrintable(true);
                if (PPGObject.getNodes().size() == 0) {
                    if (!node.getID().equals(this.printableRoot.getID())) {
                        node.getParent().setPrintable(true);
                    }
                } else if (!PPGObject.hasNode(node.getParent())) {
                    node.setPrintable(false);
                    node.setVisited(false);
                    PPGObject = new PrintablePage();
                    this.printablePages.add(PPGObject);
                    this.resetBounds();
                    this.yMaxPrintNode = null;
                    this.yMinPrintNode = null;
                    this.xMaxPrintNode = null;
                    this.xMinPrintNode = null;
                    continue block0;
                }
                DTreeLayout.printTreeLayout(this.printableRoot, this.orientation, this.parentOffset);
                this.yMaxPrintNode = null;
                this.yMinPrintNode = null;
                this.xMaxPrintNode = null;
                this.xMinPrintNode = null;
                this.PositionPrintNode(this.printableRoot, new Point());
                if (this.xMinPrintNode != null && this.xMaxPrintNode != null && this.yMinPrintNode != null && this.yMaxPrintNode != null) {
                    int xOffset = this.xMinPrintNode.getBounds().x > 0 ? 0 : Math.abs(this.xMinPrintNode.getBounds().x);
                    int yOffset = this.yMinPrintNode.getBounds().y > 0 ? 0 : Math.abs(this.yMinPrintNode.getBounds().y);
                    this.repositionPrintTreeToZero(this.printableRoot, xOffset, yOffset);
                    this.printTreeBounds.x = this.xMinPrintNode.getBounds().x;
                    this.printTreeBounds.y = this.yMinPrintNode.getBounds().y;
                    this.printTreeBounds.width = this.xMaxPrintNode.getBounds().x + this.xMaxPrintNode.getBounds().width - this.xMinPrintNode.getBounds().x;
                    this.printTreeBounds.height = this.yMaxPrintNode.getBounds().y + this.yMaxPrintNode.getBounds().height - this.yMinPrintNode.getBounds().y;
                }
                ArrayList<PrintableNode> nodesInPage = PPGObject.getNodes();
                if (pageBounds.contains(this.printTreeBounds)) {
                    ArrayList<Object> pageList;
                    if (nodesInPage.size() == 0 && !node.getID().equals(this.printableRoot.getID())) {
                        PrintableNode n = node.getParent();
                        nodesInPage.add(n);
                        if (this.printableNodePageLookup.containsKey(node.getParent())) {
                            ArrayList<PrintablePage> pageList2 = this.printableNodePageLookup.get(node.getParent());
                            pageList2.add(PPGObject);
                        }
                    }
                    nodesInPage.add(node);
                    if (this.printableNodePageLookup.containsKey(node)) {
                        pageList = this.printableNodePageLookup.get(node);
                        pageList.add(PPGObject);
                    } else {
                        pageList = new ArrayList<PrintablePage>();
                        pageList.add(PPGObject);
                        this.printableNodePageLookup.put(node, pageList);
                    }
                    this.savePrintBounds(PPGObject);
                    continue;
                }
                node.setPrintable(false);
                node.setVisited(false);
                PPGObject = new PrintablePage();
                this.printablePages.add(PPGObject);
                this.resetBounds();
                this.yMaxPrintNode = null;
                this.yMinPrintNode = null;
                this.xMaxPrintNode = null;
                this.xMinPrintNode = null;
                continue block0;
            }
        }
        this.savePrintBounds(this.printablePages.get(this.printablePages.size() - 1));
    }

    private void resetBounds() {
        for (PrintableNode node : this.printableNodes) {
            Rectangle r = node.getBounds();
            r.x = 0;
            r.y = 0;
            node.setBounds(r);
        }
    }

    private void savePrintBounds(PrintablePage page) {
        ArrayList<PrintableNode> nodes = page.getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            PrintableNode n = nodes.get(i);
            Rectangle r = n.getBounds();
            Rectangle r2 = new Rectangle();
            r2.x = r.x;
            r2.y = r.y;
            r2.width = r.width;
            r2.height = r.height;
            page.nodeBounds.put(n.getID(), r2);
        }
    }

    private void repositionPrintTreeToZero(PrintableNode t, int xOffset, int yOffset) {
        if (!t.isVisited && t.isPrintable) {
            return;
        }
        Rectangle r = t.getBounds();
        r.x += xOffset;
        r.y += yOffset;
        t.setBounds(r);
        for (PrintableNode c = t.getChild(); c != null; c = c.getSibling()) {
            this.repositionPrintTreeToZero(c, xOffset, yOffset);
        }
    }

    private void PositionPrintNode(PrintableNode pParent, Point p) {
        Rectangle b = new Rectangle();
        PrintableNode printNode = pParent;
        if (printNode.isVisited && printNode.isPrintable) {
            b = printNode.getBounds();
            b.x = p.x;
            b.y = p.y;
            printNode.setBounds(new Rectangle(b));
            if (this.xMaxPrintNode == null || this.xMaxPrintNode.getBounds().x < b.x) {
                this.xMaxPrintNode = printNode;
            }
            if (this.xMinPrintNode == null || this.xMinPrintNode.getBounds().x > b.x) {
                this.xMinPrintNode = printNode;
            }
            if (this.yMaxPrintNode == null || this.yMaxPrintNode.getBounds().y < b.y) {
                this.yMaxPrintNode = printNode;
            }
            if (this.yMinPrintNode == null || this.yMinPrintNode.getBounds().y > b.y) {
                this.yMinPrintNode = printNode;
            }
        }
        Point ptChild = new Point(p.x, p.y);
        for (PrintableNode pChild = pParent.getChild(); pChild != null; pChild = pChild.getSibling()) {
            if (pChild.isVisited && pChild.isPrintable) {
                ptChild.x += pChild.getBounds().x;
                ptChild.y += pChild.getBounds().y;
            }
            this.PositionPrintNode(pChild, ptChild);
        }
    }

    private void assignPageNumberBFS() {
        this.traverseTreeInBFS();
        PrintablePage currPage = null;
        int pageCounter = 1;
        for (PrintableNode node : this.printableNodes) {
            ArrayList<PrintablePage> pages;
            if (currPage == null) {
                pages = this.printableNodePageLookup.get(node);
                currPage = pages.get(0);
                currPage.setPageNo(pageCounter++);
            }
            pages = this.printableNodePageLookup.get(node);
            for (int i = 0; i < pages.size(); ++i) {
                PrintablePage p = pages.get(i);
                if (p.getPageNo() != -1) continue;
                currPage = p;
                currPage.setPageNo(pageCounter++);
            }
        }
    }

    private void assignPageNumberDFS() {
        this.traverseTreeInDFS();
        PrintablePage currPage = null;
        int pageCounter = 1;
        block0: for (PrintableNode node : this.printableNodes) {
            ArrayList<PrintablePage> pages;
            if (currPage == null) {
                pages = this.printableNodePageLookup.get(node);
                currPage = pages.get(0);
                currPage.setPageNo(pageCounter++);
                continue;
            }
            pages = this.printableNodePageLookup.get(node);
            for (int i = 0; i < pages.size(); ++i) {
                PrintablePage p = pages.get(i);
                if (p.getPageNo() != -1) continue;
                currPage = p;
                currPage.setPageNo(pageCounter++);
                continue block0;
            }
        }
    }

    private void createPageReferences() {
        for (PrintablePage page : this.printablePages) {
            ArrayList<PrintableNode> nodes = page.getNodes();
            for (int i = 0; i < nodes.size(); ++i) {
                PrintableNode pNode = nodes.get(i);
                ArrayList<PrintablePage> pages = this.printableNodePageLookup.get(pNode);
                if (pages.size() == 1 && pages.get(0).equals(page)) continue;
                for (int j = 0; j < pages.size(); ++j) {
                    PrintablePage currPage = pages.get(j);
                    if (currPage.equals(page)) continue;
                    if (currPage.getPageNo() > page.getPageNo()) {
                        if (!currPage.hasChildNode(pNode)) continue;
                        if (page.hasChildNode(pNode)) {
                            if (page.continuedSiblingTo.containsKey(pNode)) continue;
                            page.continuedSiblingTo.put(pNode, currPage);
                            continue;
                        }
                        if (page.continuedChildTo.containsKey(pNode)) continue;
                        page.continuedChildTo.put(pNode, currPage);
                        continue;
                    }
                    if (!currPage.hasNode(pNode.getParent())) continue;
                    page.continuedChildFrom.put(pNode, currPage);
                }
            }
        }
    }

    private void generatePrintPages() {
        final Rectangle pageBounds = new Rectangle(0, 0, PRINTABLE_PAGE_WIDTH, PRINTABLE_PAGE_HEIGHT);
        pageBounds.x += this.getMargins().left;
        pageBounds.y += this.getMargins().top;
        if (this.printHeader) {
            pageBounds.y += 45;
        }
        Iterator<PrintablePage> it = this.printablePages.iterator();
        while (it.hasNext()) {
            this.setPrintableFlag(false);
            this.setVisitedFlag(false);
            final PrintablePage PPGObject = it.next();
            ArrayList<PrintableNode> nodes = PPGObject.getNodes();
            JPanel printPanel = new JPanel(){

                @Override
                public void paint(Graphics g) {
                    Font titleFont;
                    TextStyleInterface text;
                    super.paint(g);
                    Graphics2D g2 = (Graphics2D)g;
                    FontRenderContext frc = g2.getFontRenderContext();
                    Font font = g2.getFont();
                    font = font.deriveFont(1);
                    Font f2 = font.deriveFont(16.0f);
                    g2.setFont(font);
                    ArrayList<PrintableNode> nodesList = PPGObject.getNodes();
                    for (int i = 0; i < nodesList.size(); ++i) {
                        String symbol;
                        String ref;
                        Rectangle r;
                        PrintablePage page;
                        PrintableNode node = nodesList.get(i);
                        if (PPGObject.continuedChildTo.containsKey(node)) {
                            page = PPGObject.continuedChildTo.get(node);
                            r = PPGObject.nodeBounds.get(node.getID());
                            ref = " P." + page.getPageNo();
                            symbol = "\u2192";
                            if (TreeCanvas.this.orientation == 1) {
                                g2.setFont(f2);
                                g2.drawString(symbol, r.x + r.width / 2 - 15, r.y + r.height + 10);
                                g2.setFont(font);
                                g2.drawString(ref, r.x + r.width / 2, r.y + r.height + 10);
                            } else {
                                g2.setFont(f2);
                                g2.drawString(symbol, r.x + r.width / 2 - 15, r.y + 10);
                                g2.setFont(font);
                                g2.drawString(ref, r.x + r.width / 2, r.y + 10);
                            }
                        }
                        if (PPGObject.continuedChildFrom.containsKey(node)) {
                            page = PPGObject.continuedChildFrom.get(node);
                            r = PPGObject.nodeBounds.get(node.getID());
                            ref = " P." + page.getPageNo();
                            symbol = "\u2190";
                            g2.setFont(f2);
                            g2.drawString(symbol, r.x + r.width / 2 - 15, r.y + 10);
                            g2.setFont(font);
                            g2.drawString(ref, r.x + r.width / 2, r.y + 10);
                        }
                        if (!PPGObject.continuedSiblingTo.containsKey(node)) continue;
                        page = PPGObject.continuedSiblingTo.get(node);
                        r = PPGObject.nodeBounds.get(node.getID());
                        ref = " P." + page.getPageNo();
                        symbol = ">";
                        g2.setFont(f2);
                        if (r.width > 70) {
                            g2.drawString(symbol, r.x + r.width - 25, r.y + r.height);
                            g2.setFont(font);
                            g.drawString(ref, r.x + r.width - 20, r.y + r.height);
                            continue;
                        }
                        g2.drawString(symbol, r.x + r.width - 15, r.y + r.height);
                        g2.setFont(font);
                        g.drawString(ref, r.x + r.width - 10, r.y + r.height);
                    }
                    if (TreeCanvas.this.printHeader) {
                        Rectangle b = new Rectangle();
                        b.x += ((TreeCanvas)TreeCanvas.this).getMargins().left;
                        b.y += ((TreeCanvas)TreeCanvas.this).getMargins().top;
                        b.width = PRINTABLE_PAGE_WIDTH;
                        b.height = 45;
                        text = TreeCanvas.this.printTilte.getText(0);
                        titleFont = text.getFont();
                        titleFont = titleFont.deriveFont(16.0f);
                        text.setFont((Object)titleFont);
                        ((TreeCanvas)TreeCanvas.this).printTilte.MAX_TITLE_SIZE = 16;
                        ((TreeCanvas)TreeCanvas.this).printTilte.MIN_TITLE_SIZE = 16;
                        ((TreeCanvas)TreeCanvas.this).printTilte.TITLE_SUPPRESSION_SIZE = -1;
                        TextStyleInterface text1 = TreeCanvas.this.printTilte.getText(1);
                        Font subTitleFont = text.getFont();
                        subTitleFont = subTitleFont.deriveFont(12.0f);
                        text1.setFont((Object)subTitleFont);
                        ((TreeCanvas)TreeCanvas.this).printTilte.MAX_SUBTITLE_SIZE = 12;
                        ((TreeCanvas)TreeCanvas.this).printTilte.MIN_SUBTITLE_SIZE = 12;
                        ((TreeCanvas)TreeCanvas.this).printTilte.SUBTITLE_SUPPRESSION_SIZE = -1;
                        TreeCanvas.this.printTilte.setComponentBounds(b);
                        TreeCanvas.this.printTilte.draw((Object)g2, false);
                    }
                    Rectangle fBounds = new Rectangle();
                    if (TreeCanvas.this.printFooter) {
                        text = TreeCanvas.this.printFootnote.getText(0);
                        titleFont = text.getFont();
                        titleFont = titleFont.deriveFont(12.0f);
                        text.setFont((Object)titleFont);
                        ((TreeCanvas)TreeCanvas.this).printFootnote.MAX_FOOTNOTE_SIZE = 12;
                        ((TreeCanvas)TreeCanvas.this).printFootnote.MIN_FOOTNOTE_SIZE = 12;
                        ((TreeCanvas)TreeCanvas.this).printFootnote.FOOTNOTE_SUPPRESSION_SIZE = -1;
                        fBounds.x += ((TreeCanvas)TreeCanvas.this).getMargins().left;
                        fBounds.y += pageBounds.y + pageBounds.height;
                        fBounds.width = PRINTABLE_PAGE_WIDTH;
                        fBounds.height = 20;
                        TreeCanvas.this.printFootnote.setComponentBounds(fBounds);
                        TreeCanvas.this.printFootnote.draw((Object)g2, false);
                    }
                    String pageNo = String.valueOf(PPGObject.getPageNo());
                    TextLayout textString = new TextLayout(pageNo, font, frc);
                    if (TreeCanvas.this.printFooter) {
                        textString.draw(g2, (float)((double)(fBounds.width + fBounds.x) - textString.getBounds().getMaxX() - 10.0), fBounds.y + fBounds.height + 20 - 3);
                    } else {
                        textString.draw(g2, (float)((double)(pageBounds.width + pageBounds.x) - textString.getBounds().getMaxX() - 10.0), pageBounds.y + pageBounds.height + 20 - 3);
                    }
                    BasicStroke linkStroke = new BasicStroke(5.0f, 1, 1, 0.0f, null, 0.0f);
                    g2.setStroke(linkStroke);
                    if (TreeCanvas.this.orientation == 0) {
                        TreeCanvas.this.printLinkHorizontal(TreeCanvas.this.printableRoot, g);
                    } else {
                        TreeCanvas.this.printLinkVertical(TreeCanvas.this.printableRoot, g);
                    }
                }
            };
            for (int i = 0; i < nodes.size(); ++i) {
                PrintableNode pNode = nodes.get(i);
                pNode.setPrintable(true);
                pNode.setVisited(true);
                DTreeNode node = pNode.getDTreeNode();
                Rectangle r = PPGObject.nodeBounds.get(pNode.getID());
                r.x += this.getMargins().left;
                r.y += this.getMargins().top;
                if (this.titles.getText(0) != null && this.printHeader) {
                    r.y += 25;
                }
                if (this.titles.getText(1) != null && this.printHeader) {
                    r.y += 20;
                }
                node.setBounds(r);
                printPanel.setLayout(null);
                printPanel.add(node);
                node.addNotify();
                printPanel.setSize(PAGEWIDTH, PAGEHEIGHT);
                printPanel.setBackground(Color.WHITE);
            }
            BufferedImage img = new BufferedImage(PAGEWIDTH, PAGEHEIGHT, 1);
            printPanel.paint(img.getGraphics());
            this.previewImages.put(PPGObject.getPageNo(), img);
        }
    }

    protected void printLinkHorizontal(PrintableNode t, Graphics g) {
        boolean ignore = false;
        if (t.getCollapse().getCollapsed() || t.getBounds().x + t.getBounds().width > this.getBounds().width) {
            return;
        }
        if (!t.isPrintable) {
            ignore = true;
        }
        for (PrintableNode c = t.getChild(); c != null; c = c.getSibling()) {
            if (!ignore) {
                switch (this.linkStyle) {
                    case 1: {
                        if (!c.isVisited() || !c.isPrintable()) break;
                        c.getLink().drawHorizontalStraight((Graphics2D)g);
                        break;
                    }
                    case 0: {
                        if (!c.isVisited() || !c.isPrintable()) break;
                        c.getLink().drawHorizontalManhattan((Graphics2D)g);
                        break;
                    }
                    case 2: {
                        if (!c.isVisited() || !c.isPrintable()) break;
                        c.getLink().drawHorizontalTriangle((Graphics2D)g);
                    }
                }
                if (this.links != null) {
                    this.links.addElement(c.getLink());
                }
                if (c.getChild() == null || !c.getChild().isPrintable) continue;
                this.printLinkHorizontal(c, g);
                continue;
            }
            if (c.getChild() == null) continue;
            this.printLinkHorizontal(c, g);
        }
    }

    protected void printLinkVertical(PrintableNode t, Graphics g) {
        boolean ignore = false;
        if (t.getCollapse().getCollapsed() || t.getBounds().y + t.getBounds().height > this.getBounds().height) {
            return;
        }
        if (!t.isPrintable) {
            ignore = true;
        }
        for (PrintableNode c = t.getChild(); c != null; c = c.getSibling()) {
            if (!ignore) {
                switch (this.linkStyle) {
                    case 1: {
                        if (!c.isVisited() || !c.isPrintable()) break;
                        c.getLink().drawVerticalStraight((Graphics2D)g);
                        break;
                    }
                    case 0: {
                        if (!c.isVisited() || !c.isPrintable()) break;
                        c.getLink().drawVerticalManhattan((Graphics2D)g);
                        break;
                    }
                    case 2: {
                        if (!c.isVisited() || !c.isPrintable()) break;
                        c.getLink().drawVerticalTriangle((Graphics2D)g);
                    }
                }
                if (this.links != null) {
                    this.links.addElement(c.getLink());
                }
                if (c.getChild() == null || !c.getChild().isPrintable) continue;
                this.printLinkVertical(c, g);
                continue;
            }
            if (c.getChild() == null) continue;
            this.printLinkVertical(c, g);
        }
    }

    private void savePrintImage(JPanel panel, int pageNo) {
        BufferedImage image = new BufferedImage(panel.getWidth(), panel.getHeight(), 1);
        Graphics g = image.getGraphics();
        panel.paint(g);
        this.previewImages.put(pageNo, image);
    }

    public void printPreview(PageFormat pf, boolean rebuildRequired) {
        JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        Component glassPane = f.getRootPane().getGlassPane();
        if (rebuildRequired) {
            glassPane.setCursor(Cursor.getPredefinedCursor(3));
            glassPane.setVisible(true);
        }
        if (this.mPageFormat == null) {
            this.mPageFormat = new PageFormat();
            this.calculatePrintableArea(pf);
            if (this.canFitNodeInPage()) {
                this.createPrintTree();
            }
        } else if (this.isPageFormatChanged(pf) || this.rebuild || rebuildRequired) {
            if (rebuildRequired) {
                this.userTreeDepth = -1;
                this.maxTreeDepth = -1;
            }
            this.calculatePrintableArea(pf);
            if (this.canFitNodeInPage()) {
                this.createPrintTree();
            }
        }
        glassPane.setCursor(Cursor.getPredefinedCursor(0));
        glassPane.setVisible(true);
        if (this.previewDialog == null) {
            this.previewDialog = new PrintPreview((Frame)f, pf, this);
            this.previewDialog.setVisible(true);
        } else {
            this.previewDialog.refresh();
            this.previewDialog.setVisible(true);
        }
    }

    private void calculatePrintableArea(PageFormat pf) {
        this.mPageFormat.setOrientation(pf.getOrientation());
        this.mPageFormat.setPaper(pf.getPaper());
        PRINTABLE_PAGE_WIDTH = this.getBodyWidth();
        PRINTABLE_PAGE_HEIGHT = this.getBodyHeight();
        PAGEWIDTH = (int)pf.getWidth();
        PAGEHEIGHT = (int)pf.getHeight();
        boolean titleOn = this.titles.getText(0).toString().length() > 0;
        boolean subTitleOn = this.titles.getText(1).toString().length() > 0;
        boolean footnoteOn = this.footnote.getText(0).toString().length() > 0;
        this.printTilte.applyStyle(this.style);
        this.printFootnote.applyStyle(this.style);
        if (titleOn && this.printHeader) {
            this.printTilte.setText(0, this.titles.getText(0));
        }
        if (subTitleOn && this.printHeader) {
            this.printTilte.setText(1, this.titles.getText(1));
        }
        if (footnoteOn && this.printFooter) {
            this.printFootnote.setText(0, this.footnote.getText(0));
        }
        this.previewImages.clear();
        this.rebuild = false;
    }

    private int getBodyHeight() {
        PageFormat pf = this.mPageFormat;
        Insets margins = this.getMargins();
        double height = pf.getHeight();
        if (this.titles.getText(0) != null && this.printHeader) {
            height -= 25.0;
        }
        if (this.titles.getText(1) != null && this.printHeader) {
            height -= 20.0;
        }
        if (this.footnote.getText(0) != null && this.printFooter) {
            height -= 20.0;
        }
        return (int)height - (margins.top + margins.bottom + 20);
    }

    private int getBodyWidth() {
        PageFormat pf = this.mPageFormat;
        Insets margins = this.getMargins();
        return (int)pf.getWidth() - (margins.left + margins.right);
    }

    public PageFormat getPageFormat() {
        return this.mPageFormat;
    }

    public boolean isPageFormatChanged(PageFormat pf) {
        if (this.mPageFormat.getOrientation() != pf.getOrientation()) {
            return true;
        }
        if (this.mPageFormat.getWidth() != pf.getWidth() || this.mPageFormat.getHeight() != pf.getHeight()) {
            return true;
        }
        Paper paper = pf.getPaper();
        Paper mPaper = this.mPageFormat.getPaper();
        return mPaper.getImageableX() != paper.getImageableX() || mPaper.getImageableY() != paper.getImageableY() || mPaper.getImageableWidth() != paper.getImageableWidth() || mPaper.getImageableHeight() != paper.getImageableHeight();
    }

    public void setPrintHeader(boolean showHeader) {
        this.printHeader = showHeader;
    }

    public void setPrintFooter(boolean showFooter) {
        this.printFooter = showFooter;
    }

    public boolean isPrintingHeader() {
        return this.printHeader;
    }

    public boolean isPrintingFooter() {
        return this.printFooter;
    }

    public boolean isHeaderOn() {
        boolean titleOn = false;
        boolean subTitleOn = false;
        String textString1 = this.titles.getText(0).getTextString();
        String textString2 = this.titles.getText(1).getTextString();
        if (textString1 != null && textString1.trim().length() > 0 && this.titles.getBounds().width > 0 && this.titles.getBounds().height > 0) {
            titleOn = true;
        }
        if (textString2 != null && textString2.trim().length() > 0 && this.titles.getBounds().width > 0 && this.titles.getBounds().height > 0) {
            subTitleOn = true;
        }
        return titleOn || subTitleOn;
    }

    public boolean isFooterOn() {
        boolean footerOn = false;
        String textString1 = this.footnote.getText(0).getTextString();
        if (textString1 != null && textString1.trim().length() > 0 && this.footnote.getBounds().width > 0 && this.footnote.getBounds().height > 0) {
            footerOn = true;
        }
        return footerOn;
    }

    private Insets getMargins() {
        DoubleInsets ii = this.getMargins(null);
        return new Insets((int)(ii.top + 0.5), (int)(ii.left + 0.5), (int)(ii.bottom + 0.5), (int)(ii.right + 0.5));
    }

    private DoubleInsets getMargins(DoubleInsets ii) {
        PageFormat f = this.mPageFormat;
        double pw = f.getWidth();
        double ph = f.getHeight();
        double ix = f.getImageableX();
        double iy = f.getImageableY();
        double iw = f.getImageableWidth();
        double ih = f.getImageableHeight();
        double left = ix;
        double top = iy;
        double right = pw - (ix + iw);
        double bottom = ph - (iy + ih);
        if (ii != null) {
            ii.reset(top, left, bottom, right);
        } else {
            ii = new DoubleInsets(top, left, bottom, right);
        }
        return ii;
    }

    private class TooltipHandler
    implements ActionListener {
        private TooltipHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TreeCanvas.this.tipLocation == null) {
                return;
            }
            Object prevTipText = TreeCanvas.this.tipText;
            TreeCanvas.this.tipText = TreeCanvas.this.getTipText(TreeCanvas.this.tipLocation.x, TreeCanvas.this.tipLocation.y);
            TreeCanvas.this.tooltipTimer.stop();
            if (prevTipText != TreeCanvas.this.tipText) {
                TreeCanvas.this.repaint();
            }
        }
    }

    private class DoubleInsets {
        public double top;
        public double left;
        public double bottom;
        public double right;

        public DoubleInsets(double top, double left, double bottom, double right) {
            this.reset(top, left, bottom, right);
        }

        public void reset(double top, double left, double bottom, double right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }
    }
}

