/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.dtree;

import com.sas.graphics.silk.dtree.TreeCanvas;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.simple.SimpleAwtBarChart;
import com.sas.graphics.silk.simple.SimpleAxisChartStyleInterface;
import com.sas.graphics.silk.simple.SimpleDataModel;
import com.sas.graphics.silk.util.GraphBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import javax.swing.JComponent;

class TextNodeComponent
extends JComponent {
    private static final long serialVersionUID = -3336355987037981267L;
    protected String nodeText;
    protected String toolTipText = null;
    protected Color nodeColor = Color.green;
    protected Color borderColor = Color.black;
    protected Color textColor = Color.black;
    protected int minTextSize = 6;
    protected int defaultTextSize = 14;
    protected int nodeSize;
    public String[][] parsedText;
    public TreeCanvas tree;
    protected boolean isFlagged = false;
    public static int columnSpacing = 10;
    public static int rowSpacing = 5;
    protected double[][] graphData;
    BufferedImage offscreen;
    BufferedImage offscreenGraph;

    public TextNodeComponent(TreeCanvas c) {
        this.tree = c;
        this.setOpaque(false);
    }

    @Override
    public void invalidate() {
        this.parsedText = null;
        this.offscreen = null;
        this.offscreenGraph = null;
    }

    public boolean isFlagged() {
        return this.isFlagged;
    }

    public void setFlagged(boolean f) {
        this.isFlagged = f;
        this.offscreen = null;
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public void setNodeSize(int size) {
        this.nodeSize = size;
    }

    public String getText() {
        return this.nodeText;
    }

    public void setText(String text) {
        this.nodeText = text;
        this.parsedText = null;
        this.offscreen = null;
    }

    public double[][] getGraphData() {
        return this.graphData;
    }

    public void setGraphData(double[][] d) {
        this.graphData = d;
    }

    @Override
    public void paint(Graphics g) {
        this.drawNode();
        if ((this.isFlagged() ? this.tree.showFlaggedNodeGraphs : this.tree.showNodeGraphs) && this.offscreenGraph != null) {
            g.drawImage(this.offscreenGraph, 0, 0, null);
        } else {
            g.drawImage(this.offscreen, 0, 0, null);
        }
    }

    private void drawNode() {
        if ((this.isFlagged() ? this.tree.showFlaggedNodeGraphs : this.tree.showNodeGraphs) && this.offscreenGraph == null && this.graphData != null) {
            this.offscreenGraph = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            Graphics2D g_offscreen = this.offscreenGraph.createGraphics();
            this.drawBackground(g_offscreen);
            if (!this.tree.emptyNodes) {
                Color[][] c = new Color[this.tree.numBars][this.tree.numStacks];
                Color[] colors = this.tree.style.getDataFillColors();
                int count = 0;
                for (int i = 0; i < this.tree.numBars; ++i) {
                    for (int j = 0; j < this.tree.numStacks; ++j) {
                        c[i][j] = colors.length > count && colors[count] != null ? colors[count++] : Color.blue;
                    }
                }
                SimpleDataModel simpleData = new SimpleDataModel();
                simpleData.setValues(SimpleAwtBarChart.HEIGHT, this.graphData);
                simpleData.setValues(SimpleAwtBarChart.COLOR, c);
                SimpleAwtBarChart simpleBar = new SimpleAwtBarChart();
                simpleBar.setModel(simpleData);
                simpleBar.setElementOutlineColor(Color.black);
                if (this.tree.nodeGraphOrientation == 1) {
                    simpleBar.setOrientation(SimpleAxisChartStyleInterface.VERTICAL_NORTH_ORIENTATION);
                } else {
                    simpleBar.setOrientation(SimpleAxisChartStyleInterface.HORIZONTAL_EAST_ORIENTATION);
                }
                if (this.tree.useNodeGraphAxisRange) {
                    double[] a = this.tree.nodeGraphAxisRange;
                    simpleBar.setPreferredDependentAxisUpperLimit(new Double(a[1]));
                    simpleBar.setPreferredDependentAxisLowerLimit(new Double(a[0]));
                }
                simpleBar.setBounds(new Rectangle(2, 2, this.getBounds().width - 4, this.getBounds().height - 4));
                simpleBar.setElementThickness(new Double(0.8));
                simpleBar.paint(g_offscreen);
            }
        } else if (this.offscreen == null) {
            this.offscreen = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            Graphics2D g_offscreen = this.offscreen.createGraphics();
            this.drawBackground(g_offscreen);
            if (!this.tree.emptyNodes) {
                this.drawText(g_offscreen);
            }
        }
    }

    private void drawBackground(Graphics2D g) {
        if (this.isFlagged()) {
            GraphBackground b = this.tree.flaggedNodeBackground;
            b.drawBackground(g, (Component)this);
        } else if (!this.tree.useNodeColorRamp) {
            GraphBackground b = this.tree.nodeBackground;
            b.drawBackground(g, (Component)this);
        } else if (this.tree.nodeColorRamp != null) {
            ColorInterface ramp = this.tree.nodeColorRamp;
            Color c = ramp.queryDouble((double)this.nodeSize, this.tree.minNodeSize, this.tree.maxNodeSize, false, null);
            g.setColor(c);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public BufferedImage getImage() {
        this.drawNode();
        if ((this.isFlagged() ? this.tree.showFlaggedNodeGraphs : this.tree.showNodeGraphs) && this.offscreenGraph != null) {
            return this.offscreenGraph;
        }
        return this.offscreen;
    }

    public Color getColor() {
        return this.tree.style.getTextStyleElement("ValueText").getTextColor();
    }

    public void drawText(Graphics2D g) {
        int i;
        String[][] text;
        if (this.parsedText == null) {
            if (this.nodeText == null) {
                return;
            }
            this.parsedText = text = TextNodeComponent.parseText(this.nodeText);
        } else {
            text = this.parsedText;
        }
        Font f = this.getFont();
        Point p = new Point();
        Color c = this.getColor();
        g.setColor(c);
        g.setFont(f);
        FontRenderContext frc = g.getFontRenderContext();
        int textHeight = (int)this.tree.getNodeText(this.isFlagged()).getStringBounds("T", frc).getHeight();
        int xPos = p.x + columnSpacing;
        AffineTransform t = AffineTransform.getScaleInstance(this.tree.xScale, this.tree.yScale);
        g.setTransform(t);
        int n = i = this.tree.showNodeLabels ? 0 : 1;
        while (i < text.length) {
            int yPos = p.y + rowSpacing + textHeight;
            xPos += TextNodeComponent.getMaxStringWidth(text[i], f, g, frc);
            for (int j = 0; j < text[i].length; ++j) {
                if (text[i][j] != null && text[i][j].length() > 0) {
                    g.drawString(text[i][j], xPos - (int)f.getStringBounds(text[i][j], frc).getWidth(), yPos);
                }
                yPos += textHeight + rowSpacing;
            }
            xPos += columnSpacing;
            ++i;
        }
    }

    protected static int getMaxStringWidth(String[] strs, Font style, Graphics2D g, FontRenderContext frc) {
        int rc = 0;
        for (int i = 0; i < strs.length; ++i) {
            int width = (int)style.getStringBounds(strs[i], frc).getWidth();
            if (rc >= width) continue;
            rc = width;
        }
        return rc;
    }

    protected static String[][] parseText(String text) {
        StringTokenizer lineParser = new StringTokenizer(text, "\n");
        String[][] rc = new String[lineParser.countTokens()][];
        int maxCols = 0;
        int i = 0;
        while (lineParser.hasMoreTokens()) {
            StringTokenizer colParser = new StringTokenizer(lineParser.nextToken(), "\t");
            rc[i] = new String[colParser.countTokens()];
            if (colParser.countTokens() > maxCols) {
                maxCols = colParser.countTokens();
            }
            int j = 0;
            while (colParser.hasMoreTokens()) {
                rc[i][j] = colParser.nextToken();
                ++j;
            }
            ++i;
        }
        String[][] temp = rc;
        rc = new String[maxCols][];
        for (i = 0; i < maxCols; ++i) {
            rc[i] = TextNodeComponent.getCol(i, temp);
        }
        return rc;
    }

    public static String[] getCol(int i, String[][] arr) {
        String[] rc = new String[arr.length];
        for (int j = 0; j < arr.length; ++j) {
            rc[j] = arr[j].length > i ? arr[j][i] : new String("");
        }
        return rc;
    }

    public static Dimension getSize(String text, Graphics2D g, Font font, String[][] parsedText, boolean flagged, boolean empty, boolean showNodeLabels) {
        int i;
        if (empty || text == null || text.length() <= 0) {
            return new Dimension(50, 50);
        }
        Dimension d = new Dimension(4 * columnSpacing, 2 * rowSpacing);
        String[][] columns = parsedText == null ? TextNodeComponent.parseText(text) : parsedText;
        FontRenderContext frc = g.getFontRenderContext();
        int textHeight = (int)font.getStringBounds("T", frc).getHeight();
        d.height = textHeight * columns[0].length + rowSpacing * (2 + columns[0].length);
        int n = i = showNodeLabels ? 0 : 1;
        while (i < columns.length) {
            d.width += TextNodeComponent.getMaxStringWidth(columns[i], font, g, frc);
            ++i;
        }
        return d;
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    public void setToolTipText(String s) {
        this.toolTipText = s;
    }
}

