/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.dtree;

import com.sas.graphics.silk.DecisionTree;
import com.sas.graphics.silk.dtree.NodeRenderer;
import com.sas.graphics.silk.dtree.TreeCanvas;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.util.GraphBackground;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.styles.Style;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JLabel;

public class HTMLNodeRenderer
extends JLabel
implements NodeRenderer {
    private static final long serialVersionUID = -7096266285729149379L;
    TreeCanvas canvas = null;

    public HTMLNodeRenderer() {
    }

    public HTMLNodeRenderer(DecisionTree tree) {
        this.canvas = (TreeCanvas)tree.getChart(null);
    }

    private String getString(Object nodeText) {
        StringBuffer rc = new StringBuffer();
        if (nodeText instanceof String) {
            rc.append(nodeText.toString());
        } else if (nodeText instanceof Object[]) {
            Object[] arr = (Object[])nodeText;
            for (int i = 0; i < arr.length; ++i) {
                rc.append(this.getString(arr[i]));
            }
        }
        return rc.toString();
    }

    @Override
    public Dimension getSize(Object nodeText, Object node, Graphics2D graphics, boolean isEmpty, boolean isFlagged) {
        if (nodeText == null) {
            return new Dimension();
        }
        this.setText("<html>" + this.getString(nodeText) + "</html>");
        return this.getPreferredSize();
    }

    @Override
    public void drawNode(Object nodeText, Object data, Object node, Graphics2D graphics, boolean isFlagged, double nodeColor, Rectangle b) {
        this.drawBackground(graphics, isFlagged, b, nodeColor);
        if (nodeText == null || graphics == null) {
            return;
        }
        this.setText("<html>" + this.getString(nodeText) + "</html>");
        this.setOpaque(false);
        this.setBackground(Color.RED);
        this.addNotify();
        this.setSize(b.getSize());
        AffineTransform atOld = graphics.getTransform();
        AffineTransform at = (AffineTransform)atOld.clone();
        at.translate(b.x, b.y);
        if (this.canvas != null) {
            at.scale(this.canvas.xScale, this.canvas.yScale);
        }
        graphics.setTransform(at);
        this.paint(graphics);
        graphics.setTransform(atOld);
    }

    private void drawBackground(Graphics2D g, boolean flagged, Rectangle bounds, double nodeSize) {
        if (this.canvas == null) {
            Style s = (Style)SILKGlobal.getInstance().getPropertyValue(29);
            Color c = s.getFillStyleElement("WallFill").getFillColor();
            g.setColor(c);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        } else if (flagged) {
            GraphBackground b = this.canvas.flaggedNodeBackground;
            b.drawBackground(g, (Component)this.canvas, bounds);
        } else if (!this.canvas.useNodeColorRamp || Double.isNaN(nodeSize)) {
            GraphBackground b = this.canvas.nodeBackground;
            b.drawBackground(g, (Component)this.canvas, bounds);
        } else if (this.canvas.nodeColorRamp != null) {
            ColorInterface ramp = this.canvas.nodeColorRamp;
            if (this.canvas.minNodeSize == this.canvas.maxNodeSize) {
                Color[] clrs = ramp.getColors();
                g.setColor(clrs[clrs.length - 1]);
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            } else {
                Color c = ramp.queryDouble(nodeSize, this.canvas.minNodeSize, this.canvas.maxNodeSize, false, null);
                g.setColor(c);
                g.fillRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, 5, 5);
            }
        }
    }
}

