/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.dtree;

import com.sas.graphics.silk.dtree.DTreeNode;
import com.sas.graphics.silk.dtree.NodeRenderer;
import com.sas.graphics.silk.dtree.TreeCanvas;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.simple.SimpleAwtBarChart;
import com.sas.graphics.silk.simple.SimpleAxisChartStyleInterface;
import com.sas.graphics.silk.simple.SimpleDataModel;
import com.sas.graphics.silk.util.GraphBackground;
import com.sas.graphics.silk.util.Text;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;

class GraphNodeRenderer
implements NodeRenderer {
    protected Color nodeColor = Color.green;
    protected Color borderColor = Color.black;
    protected Color textColor = Color.black;
    protected int minTextSize = 6;
    protected int defaultTextSize = 14;
    public TreeCanvas tree;
    public static int columnSpacing = 10;
    public static int rowSpacing = 5;
    Color[][] colors = null;
    SimpleAwtBarChart simpleBar = null;

    public GraphNodeRenderer(TreeCanvas c) {
        this.tree = c;
        this.setupColors();
        this.simpleBar = new SimpleAwtBarChart();
    }

    public void setupColors() {
        this.colors = new Color[this.tree.numBars][this.tree.numStacks];
        Color[] clrs = this.tree.style.getDataFillColors();
        int count = 0;
        for (int i = 0; i < this.tree.numBars; ++i) {
            for (int j = 0; j < this.tree.numStacks; ++j) {
                this.colors[i][j] = clrs.length > count && clrs[count] != null ? clrs[count++] : Color.blue;
            }
        }
    }

    private void drawGraph(Graphics2D graphics, Object data, Rectangle b) {
        double[][] graphData = null;
        if (data instanceof double[][]) {
            graphData = (double[][])data;
        }
        if (graphData == null) {
            return;
        }
        SimpleDataModel simpleData = new SimpleDataModel();
        simpleData.setValues(SimpleAwtBarChart.HEIGHT, graphData);
        simpleData.setValues(SimpleAwtBarChart.COLOR, this.colors);
        this.simpleBar.setModel(simpleData);
        Stroke oldStroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, null, 0.0f));
        this.simpleBar.setElementOutlineColor(Color.black);
        if (this.tree.nodeGraphOrientation == 1) {
            this.simpleBar.setOrientation(SimpleAxisChartStyleInterface.VERTICAL_NORTH_ORIENTATION);
        } else {
            this.simpleBar.setOrientation(SimpleAxisChartStyleInterface.HORIZONTAL_EAST_ORIENTATION);
        }
        if (this.tree.useNodeGraphAxisRange) {
            double[] a = this.tree.nodeGraphAxisRange;
            this.simpleBar.setPreferredDependentAxisUpperLimit(new Double(a[1]));
            this.simpleBar.setPreferredDependentAxisLowerLimit(new Double(a[0]));
        }
        this.simpleBar.setBounds(new Rectangle(b.x + 2, b.y + 2, b.width - 4, b.height - 4));
        this.simpleBar.setElementThickness(new Double(0.8));
        this.simpleBar.paint(graphics);
        graphics.setStroke(oldStroke);
    }

    private void drawBackground(Graphics2D g, boolean flagged, Rectangle bounds, double nodeSize) {
        if (flagged) {
            GraphBackground b = this.tree.flaggedNodeBackground;
            b.drawBackground(g, (Component)this.tree, bounds);
        } else if (!this.tree.useNodeColorRamp) {
            GraphBackground b = this.tree.nodeBackground;
            b.drawBackground(g, (Component)this.tree, bounds);
        } else if (this.tree.nodeColorRamp != null) {
            ColorInterface ramp = this.tree.nodeColorRamp;
            Color c = ramp.queryDouble(nodeSize, this.tree.minNodeSize, this.tree.maxNodeSize, false, null);
            g.setColor(c);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    public Color getColor() {
        return this.tree.style.getTextStyleElement("ValueText").getTextColor();
    }

    protected static int getMaxStringWidth(String[] strs, Text style, Graphics2D g, FontRenderContext frc) {
        int rc = 0;
        for (int i = 0; i < strs.length; ++i) {
            int width = (int)style.getStringBounds(strs[i], frc).getWidth();
            if (rc >= width) continue;
            rc = width;
        }
        return rc;
    }

    public Dimension getSize(Graphics2D g, Text text, String[][] parsedText, boolean flagged, boolean empty, boolean showNodeLabels) {
        int i;
        if (empty || parsedText == null) {
            return new Dimension(50, 50);
        }
        Dimension d = new Dimension(4 * columnSpacing, 2 * rowSpacing);
        String[][] columns = parsedText;
        FontRenderContext frc = g.getFontRenderContext();
        int textHeight = (int)text.getStringBounds("T", frc).getHeight();
        d.height = textHeight * columns[0].length + rowSpacing * (2 + columns[0].length);
        int n = i = showNodeLabels ? 0 : 1;
        while (i < columns.length) {
            d.width += GraphNodeRenderer.getMaxStringWidth(columns[i], text, g, frc);
            ++i;
        }
        return d;
    }

    @Override
    public Dimension getSize(Object nodeText, Object node, Graphics2D graphics, boolean isEmpty, boolean isFlagged) {
        if (!(nodeText instanceof String[][])) {
            nodeText = DTreeNode.parseText(nodeText.toString());
        }
        return this.getSize(graphics, this.tree.getNodeText(isFlagged), nodeText, isFlagged, isEmpty, this.tree.showNodeLabels);
    }

    @Override
    public void drawNode(Object nodeText, Object data, Object node, Graphics2D graphics, boolean isFlagged, double nodeSize, Rectangle b) {
        this.drawBackground(graphics, isFlagged, b, nodeSize);
        if (!this.tree.emptyNodes) {
            this.drawGraph(graphics, data, b);
        }
    }
}

