/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.dtree;

import com.sas.graphics.silk.dtree.MyJButton;
import com.sas.graphics.silk.dtree.MyJToggleButton;
import com.sas.graphics.silk.dtree.TreeCanvas;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class DTreeToolbar
extends JDialog
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = -2490998313583637902L;
    MyJToggleButton selectButton = null;
    MyJToggleButton panButton = null;
    MyJToggleButton flagButton = null;
    MyJToggleButton zoomButton = null;
    MyJToggleButton expandTextButton = null;
    MyJButton resetButton = null;
    JSeparator sep = null;
    TreeCanvas tree;
    JPopupMenu menu = null;
    public static final int SMALL_BUTTON_SIZE = 24;
    public static final int LARGE_BUTTON_SIZE = 40;
    public static final int PADDING = 8;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.dtree.silk_dtree_NLS");
    boolean fComponentsAdjusted = false;
    String resourceLoc = "icons/";

    public DTreeToolbar(Frame parent, TreeCanvas tree) {
        super(parent);
        this.tree = tree;
        this.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"DTreeToolbar.Tree_Toolbar.txt", (String)"Tree Toolbar"));
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.setSize(255, 48);
        this.setVisible(false);
        this.selectButton = new MyJToggleButton(this.loadImageIcon("select_16.gif"));
        this.selectButton.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"DTreeToolbar.Select.txt", (String)"Select"));
        this.selectButton.addActionListener(this);
        this.selectButton.addMouseListener(this);
        this.selectButton.setPreferredSize(new Dimension(24, 24));
        this.panButton = new MyJToggleButton(this.loadImageIcon("MoveNodes16.gif"));
        this.panButton.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"DTreeToolbar.Pan.txt", (String)"Pan"));
        this.panButton.addActionListener(this);
        this.panButton.addMouseListener(this);
        this.panButton.setPreferredSize(new Dimension(24, 24));
        this.flagButton = new MyJToggleButton(this.loadImageIcon("flagred_16.gif"));
        this.flagButton.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"DTreeToolbar.Flag.txt", (String)"Flag"));
        this.flagButton.addActionListener(this);
        this.flagButton.setPreferredSize(new Dimension(24, 24));
        this.flagButton.addMouseListener(this);
        this.zoomButton = new MyJToggleButton(this.loadImageIcon("focus_16.gif"));
        this.zoomButton.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"DTreeToolbar.Zoom.txt", (String)"Zoom"));
        this.zoomButton.addActionListener(this);
        this.zoomButton.setPreferredSize(new Dimension(24, 24));
        this.zoomButton.addMouseListener(this);
        this.expandTextButton = new MyJToggleButton(this.loadImageIcon("textdetails_16.gif"));
        this.expandTextButton.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"DTreeToolbar.Expanded_Node_Text.txt", (String)"Expanded Node Text"));
        this.expandTextButton.addActionListener(this);
        this.expandTextButton.setPreferredSize(new Dimension(24, 24));
        this.expandTextButton.addMouseListener(this);
        if (tree != null) {
            this.expandTextButton.setSelected(tree.isNodeUseTipText());
        } else {
            this.expandTextButton.setSelected(false);
        }
        this.resetButton = new MyJButton(this.loadImageIcon("ResetView16.gif"));
        this.resetButton.setToolTipText(ResourceLoader.getResourceString((Object)this.rb, (String)"DTreeToolbar.Reset_Tree.txt", (String)"Reset Tree"));
        this.resetButton.addActionListener(this);
        this.resetButton.setPreferredSize(new Dimension(24, 24));
        this.resetButton.addMouseListener(this);
        this.setSize(192, 32);
        Container c = this.getContentPane();
        c.setLayout(new FlowLayout());
        c.add(this.selectButton);
        c.add(this.panButton);
        c.add(this.flagButton);
        c.add(this.zoomButton);
        c.add(this.expandTextButton);
        this.sep = new JSeparator(1);
        this.sep.setPreferredSize(new Dimension(2, (int)this.resetButton.getPreferredSize().getHeight()));
        c.add(this.sep);
        c.add(this.resetButton);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.addMouseListener(this);
        this.menu = new JPopupMenu();
        this.menu.addSeparator();
        JMenuItem temp = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"DTreeToolbar.Hide_Toolbar.txt", (String)"Hide Toolbar"));
        temp.setActionCommand("HideToolbar");
        temp.addActionListener(this);
        this.menu.add(temp);
        this.menu.addSeparator();
        JCheckBoxMenuItem temp1 = new JCheckBoxMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"DTreeToolbar.Large_Icons.txt", (String)"Large Icons"));
        temp1.setActionCommand("LargeIcons");
        temp1.addActionListener(this);
        this.menu.add(temp1);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public DTreeToolbar(String title) {
        this();
        this.setTitle(title);
    }

    public DTreeToolbar() {
        this((Frame)null, (TreeCanvas)null);
    }

    public static void main(String[] args) {
        new DTreeToolbar().setVisible(true);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void DTreeToolbar_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.selectButton) {
            this.tree.setCursor(Cursor.getPredefinedCursor(0));
            this.tree.setActionMode(6);
            this.panButton.setSelected(false);
            this.flagButton.setSelected(false);
            this.zoomButton.setSelected(false);
            this.resetButton.setSelected(false);
        } else if (o == this.panButton) {
            Image i = this.loadImage("MoveOpen.gif");
            Toolkit t = Toolkit.getDefaultToolkit();
            Cursor c = t.createCustomCursor(i, new Point(1, 1), "Pan");
            this.tree.setCursor(c);
            this.tree.setActionMode(4);
            this.selectButton.setSelected(false);
            this.flagButton.setSelected(false);
            this.zoomButton.setSelected(false);
            this.resetButton.setSelected(false);
        } else if (o == this.flagButton) {
            this.tree.setCursor(Cursor.getPredefinedCursor(0));
            this.tree.setActionMode(16);
            this.selectButton.setSelected(false);
            this.panButton.setSelected(false);
            this.zoomButton.setSelected(false);
            this.resetButton.setSelected(false);
        } else if (o == this.zoomButton) {
            this.tree.setCursor(Cursor.getPredefinedCursor(1));
            this.tree.setActionMode(3);
            this.selectButton.setSelected(false);
            this.panButton.setSelected(false);
            this.flagButton.setSelected(false);
            this.resetButton.setSelected(false);
        } else if (o == this.expandTextButton) {
            this.tree.setNodeUseTipText(this.expandTextButton.isSelected());
        } else if (ae.getActionCommand().startsWith("Hide")) {
            this.setVisible(false);
        } else if (ae.getActionCommand().startsWith("Large")) {
            JCheckBoxMenuItem z = (JCheckBoxMenuItem)ae.getSource();
            if (z.isSelected()) {
                this.setToolbarLarge();
            } else {
                this.setToolbarSmall();
            }
        }
    }

    public void setToolbarLarge() {
        this.selectButton.setIcon(this.loadImageIcon("select_32.gif"));
        this.selectButton.setPreferredSize(new Dimension(40, 40));
        this.panButton.setIcon(this.loadImageIcon("MoveNodes32.gif"));
        this.panButton.setPreferredSize(new Dimension(40, 40));
        this.flagButton.setIcon(this.loadImageIcon("flagred_32.gif"));
        this.flagButton.setPreferredSize(new Dimension(40, 40));
        this.zoomButton.setIcon(this.loadImageIcon("focus_32.gif"));
        this.zoomButton.setPreferredSize(new Dimension(40, 40));
        this.expandTextButton.setIcon(this.loadImageIcon("textdetails_32.gif"));
        this.expandTextButton.setPreferredSize(new Dimension(40, 40));
        this.resetButton.setIcon(this.loadImageIcon("ResetView32.gif"));
        this.resetButton.setPreferredSize(new Dimension(40, 40));
        this.setSize(288, 40 + this.getBounds().height - 24);
        this.sep.setPreferredSize(new Dimension(2, (int)this.resetButton.getPreferredSize().getHeight()));
        this.doLayout();
    }

    public void setToolbarSmall() {
        this.selectButton.setIcon(this.loadImageIcon("select_16.gif"));
        this.selectButton.setPreferredSize(new Dimension(24, 24));
        this.panButton.setIcon(this.loadImageIcon("MoveNodes16.gif"));
        this.panButton.setPreferredSize(new Dimension(24, 24));
        this.flagButton.setIcon(this.loadImageIcon("flagred_16.gif"));
        this.flagButton.setPreferredSize(new Dimension(24, 24));
        this.zoomButton.setIcon(this.loadImageIcon("focus_16.gif"));
        this.zoomButton.setPreferredSize(new Dimension(24, 24));
        this.expandTextButton.setIcon(this.loadImageIcon("textdetails_16.gif"));
        this.expandTextButton.setPreferredSize(new Dimension(24, 24));
        this.resetButton.setIcon(this.loadImageIcon("ResetView16.gif"));
        this.resetButton.setPreferredSize(new Dimension(24, 24));
        this.setSize(192, 24 + this.getBounds().height - 40);
        this.sep.setPreferredSize(new Dimension(2, (int)this.resetButton.getPreferredSize().getHeight()));
        this.doLayout();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int flags = me.getModifiers();
        if ((flags & 4) != 0) {
            this.menu.show(this.selectButton, me.getX(), me.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    public ImageIcon loadImageIcon(String name) {
        Image image = this.loadImage(name);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public Image loadImage(String name) {
        try {
            String resourceName = this.resourceLoc + name;
            Image image = ResourceLoader.getImage((Component)this.tree, (String)resourceName);
            if (image != null) {
                return image;
            }
            return null;
        }
        catch (AWTError ae) {
            System.out.println("AWT Error: " + ae.toString());
            return null;
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == DTreeToolbar.this) {
                DTreeToolbar.this.DTreeToolbar_WindowClosing(event);
            }
        }
    }
}

