/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.dendrogram;

import com.sas.graphics.silk.dendrogram.DendrogramModel;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.DendrogramPropertyInterface;
import com.sas.graphics.silk.interfaces.GeometryInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.interfaces.ViewportInterface;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.util.ColorParse;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;

public class DendrogramChart
implements GeometryInterface,
RenderInterface,
RoleInterface,
UpdateInterface,
ViewportInterface,
ViewportListenerInterface,
PropertyInterface,
DendrogramPropertyInterface {
    protected boolean visible = true;
    protected double opacity = 1.0;
    protected boolean rebuildRequired = true;
    protected Color selectionColor;
    protected Color nodeColor;
    protected int nodeWidth = 1;
    protected int orientation = 0;
    protected DataFilterReadInterface dataIn = null;
    protected DataFilterReadInterface dataOut = null;
    protected DendrogramModel treeModel = null;
    protected Axes heightAxis = null;
    protected Axes treeAxis = null;
    protected double xMin;
    protected double xMax;
    protected double yMin;
    protected double yMax;
    protected SASFormat respFormat;
    protected ArrayList branchList;
    protected ArrayList crossList;
    protected ArrayList redrawListener;
    protected boolean dataChanged = false;
    protected double[] scr1 = new double[3];
    protected double[] scr2 = new double[3];
    protected Rectangle clipRect;
    protected Dimension chartAreaDimension;
    protected Object[] orderedLeaves;
    protected boolean redraw = true;
    protected ArrayList propertyIndex;
    protected ArrayList propertyValue;
    protected double dataXMin;
    protected double dataXMax;
    protected double dataYMin;
    protected double dataYMax;
    protected int numSelectedNodes;
    protected AxisZoomPanHandler treeHandler;
    protected AxisZoomPanHandler heightHandler;
    protected TransformInterface transformObj;
    protected boolean reversedTree = false;
    protected boolean fisheyeView = false;
    protected double focusPointX = Double.NaN;
    protected double focusPointY = Double.NaN;
    protected double distortionFactorX = 7.0;
    protected double distortionFactorY = 7.0;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.dendrogram.dendrogram_NLS");
    protected GlobalDefaults silkDefaults = new GlobalDefaults();
    public static int[] supportedProperties = new int[]{801, 802, 803, 804};
    protected UserSetPropertyBitMask userSetProperties = new UserSetPropertyBitMask(supportedProperties);

    public DendrogramChart(Object dataObject) {
        this.selectionColor = new Color(255, 197, 0);
        this.nodeColor = Color.black;
        this.branchList = new ArrayList();
        this.crossList = new ArrayList();
        this.redrawListener = new ArrayList();
        this.xMin = Double.NaN;
        this.xMax = Double.NaN;
        this.yMin = Double.NaN;
        this.yMax = Double.NaN;
        this.propertyIndex = new ArrayList();
        this.propertyValue = new ArrayList();
        this.setDataSource(dataObject);
        this.transformObj = new Transformation(false);
        this.userSetProperties.appendProperties(supportedProperties);
    }

    public DendrogramChart() {
        this(null);
    }

    public Axes getHeightAxis() {
        return this.heightAxis;
    }

    public void setHeightAxis(Axes axis) {
        this.heightAxis = axis;
        this.heightAxis.setTransformObject((Object)this.transformObj);
        if (this.heightHandler == null) {
            this.heightHandler = new AxisZoomPanHandler(this.heightAxis);
            this.heightHandler.addViewportListener((Object)this);
        }
    }

    public AxisZoomPanHandler getHeightHandler() {
        return this.heightHandler;
    }

    public Axes getTreeAxis() {
        return this.treeAxis;
    }

    public void setTreeAxis(Axes axis) {
        this.treeAxis = axis;
        if (this.treeAxis != null) {
            this.treeAxis.setTransformObject((Object)new Transformation(true));
        }
        if (this.treeHandler == null) {
            this.treeHandler = new AxisZoomPanHandler(this.treeAxis);
            this.treeHandler.addViewportListener((Object)this);
        }
    }

    public AxisZoomPanHandler getTreeHandler() {
        return this.treeHandler;
    }

    public boolean isDataAssigned() {
        return this.getVariable("Name") != null && this.getVariable("Parent") != null;
    }

    public void updateFisheyeFocusPoint(Point startPt, Point currentPt, boolean treeAxis) {
        boolean dir_x;
        boolean bl = dir_x = this.orientation == 0 && !treeAxis || this.orientation == 1 && treeAxis;
        if (dir_x) {
            int delta = treeAxis ? startPt.x - currentPt.x : currentPt.x - startPt.x;
            double focus_diff = (double)delta / ((double)this.clipRect.width * 0.5);
            this.focusPointX += focus_diff;
            this.focusPointX = Math.max(-1.0, Math.min(1.0, this.focusPointX));
        } else {
            int delta = treeAxis ? currentPt.y - startPt.y : startPt.y - currentPt.y;
            double focus_diff = (double)delta / ((double)this.clipRect.height * 0.5);
            this.focusPointY += focus_diff;
            this.focusPointY = Math.max(-1.0, Math.min(1.0, this.focusPointY));
        }
        startPt.x = currentPt.x;
        startPt.y = currentPt.y;
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public Insets getOuterMargin(Graphics2D g) {
        double labelSize;
        Insets om = new Insets(0, 0, 0, 0);
        if (this.rebuildRequired && !this.build(null)) {
            return om;
        }
        if (this.orientation == 0) {
            om.left = Math.max(this.treeAxis.getLeftWidth(g), (int)(0.5 * (double)this.heightAxis.getValueWidth(g, 0)));
            om.bottom = Math.max(this.treeAxis.getValueHeight(g, 0), this.heightAxis.getBottomHeight(g));
            om.right = (int)(0.5 * (double)this.heightAxis.getValueWidth(g, -1));
            labelSize = this.treeAxis.getValueHeight(g, -1);
        } else {
            om.left = Math.max(this.heightAxis.getLeftWidth(g), (int)(0.5 * (double)this.treeAxis.getValueWidth(g, 0)));
            om.bottom = Math.max(this.heightAxis.getValueHeight(g, 0), this.treeAxis.getBottomHeight(g));
            om.right = (int)(0.5 * (double)this.treeAxis.getValueWidth(g, -1));
            labelSize = 0.0;
        }
        if (this.isFisheyeView()) {
            this.computeDistortionFactor(labelSize);
        }
        return om;
    }

    public void setChartAreaDimension(Dimension d) {
        this.chartAreaDimension = d;
        this.heightAxis.setChartAreaDimension(d);
        if (this.treeAxis != null) {
            this.treeAxis.setChartAreaDimension(d);
        }
    }

    public Rectangle getChartClipArea() {
        return this.clipRect;
    }

    public void setChartClipArea(Rectangle rect) {
        if (rect == null) {
            return;
        }
        this.clipRect = rect;
        this.heightAxis.setScreenArea(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height);
        if (this.treeAxis != null) {
            this.treeAxis.setScreenArea(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height);
        }
    }

    public Object[] getOrderedLeaves() {
        return this.orderedLeaves;
    }

    public Object[] getTreeAxisLabels() {
        if (this.orientation == 1) {
            return this.orderedLeaves;
        }
        int len = this.orderedLeaves.length;
        Object[] reverse = new Object[len];
        for (int i = 0; i < this.orderedLeaves.length; ++i) {
            reverse[len - 1 - i] = this.orderedLeaves[i];
        }
        return reverse;
    }

    private boolean buildDendrogram(Object buildData) {
        HashMap leaves = this.treeModel.getLeaves();
        int level = this.treeModel.getTreeLevel();
        HashMap<DendrogramModel.Node, Double> positions = new HashMap<DendrogramModel.Node, Double>();
        this.orderedLeaves = new Object[leaves.size()];
        Iterator iter = leaves.keySet().iterator();
        int size = leaves.size();
        for (int i = 0; i < size; ++i) {
            DendrogramModel.Node leaf = (DendrogramModel.Node)iter.next();
            if (this.orientation == 0) {
                positions.put(leaf, new Double(size - 1 - i));
            } else {
                positions.put(leaf, new Double(i));
            }
            this.orderedLeaves[i] = leaf.name;
        }
        this.buildBranchAndCross(leaves, positions, level);
        this.reversedTree = this.treeModel.isReversedTree();
        return true;
    }

    private void buildBranchAndCross(HashMap leaves, HashMap positions, int level) {
        Object[] leaveArray = leaves.keySet().toArray();
        for (int i = 0; i < leaveArray.length; ++i) {
            DendrogramModel.Node leaf = (DendrogramModel.Node)leaveArray[i];
            if (leaf.parent == null) {
                return;
            }
            if (!leaf.firstChild || leaf.level != level) continue;
            DendrogramModel.Node parent = leaf.parent;
            int numKids = parent.children.size();
            double v = 0.0;
            double vmin = Double.MAX_VALUE;
            double vmax = -1.7976931348623157E308;
            for (int k = 0; k < numKids; ++k) {
                DendrogramModel.Node kid = (DendrogramModel.Node)parent.children.get(k);
                v = ((Number)positions.get(kid)).doubleValue();
                if (v < vmin) {
                    vmin = v;
                }
                if (v > vmax) {
                    vmax = v;
                }
                Branch b = new Branch();
                if (this.orientation == 0) {
                    b.kidEnd = kid.collapsed ? (this.reversedTree ? new Point2D.Double(this.xMin, v) : new Point2D.Double(this.xMax, v)) : new Point2D.Double(kid.height, v);
                    b.parentEnd = new Point2D.Double(parent.height, v);
                } else {
                    b.kidEnd = kid.collapsed ? (this.reversedTree ? new Point2D.Double(v, this.yMin) : new Point2D.Double(v, this.yMax)) : new Point2D.Double(v, kid.height);
                    b.parentEnd = new Point2D.Double(v, parent.height);
                }
                b.node = kid;
                this.branchList.add(b);
                leaves.remove(kid);
                positions.remove(kid);
            }
            Cross c = new Cross();
            if (this.orientation == 0) {
                c.minEnd = new Point2D.Double(parent.height, vmin);
                c.maxEnd = new Point2D.Double(parent.height, vmax);
            } else {
                c.minEnd = new Point2D.Double(vmin, parent.height);
                c.maxEnd = new Point2D.Double(vmax, parent.height);
            }
            c.node = parent;
            this.crossList.add(c);
            leaves.put(parent, "leaf");
            positions.put(parent, new Double(0.5 * (vmin + vmax)));
        }
        this.buildBranchAndCross(leaves, positions, --level);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.selectionColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.selectionColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public Color getNodeColor() {
        return this.nodeColor;
    }

    public void setNodeColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.nodeColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.nodeColor = col;
        }
        this.userSetProperties.set(802);
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public int getNodeWidth() {
        return this.nodeWidth;
    }

    public void setNodeWidth(int w) {
        if (w <= 0) {
            return;
        }
        this.nodeWidth = w;
        this.userSetProperties.set(803);
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int o) {
        switch (o) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.orientation == o) {
            return;
        }
        this.orientation = o;
        this.userSetProperties.set(804);
        this.rebuildRequired = true;
        this.focusPointY = Double.NaN;
        this.focusPointX = Double.NaN;
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public boolean isFisheyeView() {
        return this.fisheyeView;
    }

    public void setFisheyeView(boolean b) {
        if (this.fisheyeView == b) {
            return;
        }
        this.fisheyeView = b;
        this.userSetProperties.set(801);
        this.treeAxis.setFisheyeView(this.fisheyeView);
        this.heightAxis.setFisheyeView(this.fisheyeView);
        if (this.fisheyeView) {
            this.resetViewport();
        } else {
            this.fireRedrawEvent(new RedrawEvent((Object)this));
        }
    }

    public boolean isHighlightRequired() {
        return this.numSelectedNodes > 0;
    }

    public ArrayList getSelectedValues() {
        return this.treeModel.getSelectedValues();
    }

    public boolean setSelection(int mouseX, int mouseY, boolean extend) {
        return this.setSelection(new Rectangle(mouseX - 1, mouseY - 1, 5, 5), extend, false);
    }

    public boolean setSelection(Rectangle rect, boolean extend) {
        return this.setSelection(rect, extend, true);
    }

    private boolean setSelection(Rectangle rect, boolean extend, boolean all) {
        double[] pt1 = this.unProject(rect.getX(), rect.getY(), 0.0, null);
        double[] pt2 = this.unProject(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight(), 0.0, null);
        Rectangle2D.Double rect2D = this.orientation == 0 ? (this.reversedTree ? new Rectangle2D.Double(pt1[0], pt2[1], pt2[0] - pt1[0], pt1[1] - pt2[1]) : new Rectangle2D.Double(pt2[0], pt2[1], pt1[0] - pt2[0], pt1[1] - pt2[1])) : (this.reversedTree ? new Rectangle2D.Double(pt1[0], pt2[1], pt2[0] - pt1[0], pt1[1] - pt2[1]) : new Rectangle2D.Double(pt1[0], pt1[1], pt2[0] - pt1[0], pt2[1] - pt1[1]));
        Line2D.Double line = new Line2D.Double();
        boolean fire = false;
        if (extend) {
            for (int i = 0; i < this.branchList.size(); ++i) {
                Branch b = (Branch)this.branchList.get(i);
                line.setLine(b.kidEnd, b.parentEnd);
                if (!line.intersects(rect2D)) continue;
                fire = true;
                if (b.node.selected) {
                    this.treeModel.setSelection(b.node, false);
                    --this.numSelectedNodes;
                } else {
                    this.treeModel.setSelection(b.node, true);
                    ++this.numSelectedNodes;
                }
                if (all) {
                    continue;
                }
                break;
            }
        } else {
            fire = true;
            this.treeModel.setSelectAll(false);
            this.numSelectedNodes = 0;
            for (int i = 0; i < this.branchList.size(); ++i) {
                Branch b = (Branch)this.branchList.get(i);
                line.setLine(b.kidEnd, b.parentEnd);
                if (!line.intersects(rect2D)) continue;
                this.treeModel.setSelection(b.node, true);
                ++this.numSelectedNodes;
                if (all) {
                    continue;
                }
                break;
            }
        }
        return fire;
    }

    public boolean setCollapse(int mouseX, int mouseY) {
        Rectangle rect = new Rectangle(mouseX - 1, mouseY - 1, 5, 5);
        double[] pt1 = this.unProject(rect.getX(), rect.getY(), 0.0, null);
        double[] pt2 = this.unProject(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight(), 0.0, null);
        Rectangle2D.Double rect2D = this.orientation == 0 ? (this.reversedTree ? new Rectangle2D.Double(pt1[0], pt2[1], pt2[0] - pt1[0], pt1[1] - pt2[1]) : new Rectangle2D.Double(pt2[0], pt2[1], pt1[0] - pt2[0], pt1[1] - pt2[1])) : (this.reversedTree ? new Rectangle2D.Double(pt1[0], pt2[1], pt2[0] - pt1[0], pt1[1] - pt2[1]) : new Rectangle2D.Double(pt1[0], pt1[1], pt2[0] - pt1[0], pt2[1] - pt1[1]));
        Line2D.Double line = new Line2D.Double();
        boolean fire = false;
        for (int i = 0; i < this.branchList.size(); ++i) {
            Branch b = (Branch)this.branchList.get(i);
            line.setLine(b.kidEnd, b.parentEnd);
            if (!line.intersects(rect2D)) continue;
            if (b.node.children == null || b.node.children.size() == 0) break;
            fire = true;
            boolean collapse = !b.node.collapsed;
            this.treeModel.setCollapse(b.node, collapse);
            break;
        }
        if (fire) {
            this.rebuildRequired = true;
            this.dataChanged = true;
        }
        return fire;
    }

    public String getToolTipText(int mouseX, int mouseY) {
        double[] pt1 = this.unProject(mouseX - 1, mouseY - 1, 0.0, null);
        double[] pt2 = this.unProject(mouseX + 4, mouseY + 4, 0.0, null);
        Rectangle2D.Double rect2D = this.orientation == 0 ? (this.reversedTree ? new Rectangle2D.Double(pt1[0], pt2[1], pt2[0] - pt1[0], pt1[1] - pt2[1]) : new Rectangle2D.Double(pt2[0], pt2[1], pt1[0] - pt2[0], pt1[1] - pt2[1])) : (this.reversedTree ? new Rectangle2D.Double(pt1[0], pt2[1], pt2[0] - pt1[0], pt1[1] - pt2[1]) : new Rectangle2D.Double(pt1[0], pt1[1], pt2[0] - pt1[0], pt2[1] - pt1[1]));
        Line2D.Double line = new Line2D.Double();
        DendrogramModel.Node node = null;
        for (int i = 0; i < this.branchList.size(); ++i) {
            Branch b = (Branch)this.branchList.get(i);
            line.setLine(b.kidEnd, b.parentEnd);
            if (!line.intersects(rect2D)) continue;
            node = b.node;
            break;
        }
        if (node == null) {
            return null;
        }
        Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"DendrogramChart.Probe.fmt.txt", (String)"{0} : {1}"));
        String cstr = "";
        String hstr = "";
        cstr = probeMessage.toString((Object)((String)this.treeModel.getVariableDescription(this.getVariable("Name"))), (Object)node.name.toString()) + "\n";
        if (this.getVariable("Height") != null) {
            Object format = this.dataIn.getFormat(this.getVariable("Height"), null);
            hstr = probeMessage.toString((Object)((String)this.treeModel.getVariableDescription(this.getVariable("Height"))), (Object)this.dataIn.getFormattedValue(this.getVariable("Height"), (Object)new Double(node.height), format));
        }
        return cstr + hstr;
    }

    private double[] project(double x, double y, double z, double[] out) {
        return this.transformObj.project(x, y, z, out);
    }

    private double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
        return this.transformObj.unProject(pixelX, pixelY, pixelZ, out);
    }

    public boolean isReverse(int axis) {
        return this.transformObj.isReverse(axis);
    }

    public void setReverse(int axis, boolean flag) {
        this.transformObj.setReverse(axis, flag);
    }

    private void computeDistortionFactor(double treeLabelSize) {
        if (treeLabelSize <= 0.0) {
            return;
        }
        if (this.orientation == 0) {
            int num = (int)((double)this.clipRect.height / treeLabelSize);
            if ((double)num > this.yMax - this.yMin) {
                this.distortionFactorY = 0.0;
            } else {
                num = (int)((double)this.clipRect.height / 3.0 / treeLabelSize);
                num = Math.min(num, 7);
                double x1 = Math.ceil((double)num * 0.5);
                double x2 = x1 - 1.0;
                x1 = x1 / (this.yMax - this.yMin) * 2.0;
                x2 = x2 / (this.yMax - this.yMin) * 2.0;
                double norm_size = treeLabelSize / (double)this.clipRect.height * 2.0;
                double a = norm_size * x1 * x2;
                double b = norm_size * x1 + norm_size * x2 - x1 + x2;
                double c = norm_size - x1 + x2;
                double delta = b * b - 4.0 * a * c;
                delta = Math.sqrt(Math.max(delta, 0.0));
                double d1 = (-b + delta) / (2.0 * a);
                double d2 = (-b - delta) / (2.0 * a);
                this.distortionFactorY = Math.min(d1, d2);
            }
        }
    }

    private void resetFisheyeViewParameters() {
        int level = this.treeModel.getTreeLevel();
        if (level == 0) {
            return;
        }
        double focusLevel = (double)level * 2.0 / 3.0;
        double hfp = 2.0 * focusLevel / ((double)level - 1.0) - 1.0;
        if (this.orientation == 0) {
            this.focusPointY = 0.0;
            this.focusPointX = hfp;
        } else {
            this.focusPointX = 0.0;
            this.focusPointY = hfp;
        }
        this.distortionFactorX = 7.0;
        this.distortionFactorY = 7.0;
        this.updateFisheyeFocusPoint(new Point(0, 0), new Point(0, 0), false);
    }

    public boolean create(Object createData) {
        return true;
    }

    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    public boolean build(Object buildData) {
        double max;
        double min;
        if (!this.rebuildRequired) {
            return true;
        }
        if (this.treeModel == null) {
            return false;
        }
        if (!this.isDataAssigned()) {
            return false;
        }
        if (!this.treeModel.buildUpTree()) {
            if (this.branchList != null) {
                this.branchList.clear();
            }
            if (this.crossList != null) {
                this.crossList.clear();
            }
            this.numSelectedNodes = 0;
            return false;
        }
        this.branchList.clear();
        this.crossList.clear();
        this.numSelectedNodes = 0;
        if (this.getVariable("Height") != null) {
            min = ((Number)this.getRoleValue("Height", 0)).doubleValue();
            max = ((Number)this.getRoleValue("Height", 1)).doubleValue();
            if (this.orientation == 0) {
                this.heightAxis.setRole(this.getVariable("Height"), (Object)"XAxis");
            } else {
                this.heightAxis.setRole(this.getVariable("Height"), (Object)"YAxis");
            }
            this.heightAxis.setVisible(true);
            this.heightAxis.setLabel(this.treeModel.getVariableDescription(this.getVariable("Height")));
            this.heightAxis.setGridLines((Object)Boolean.FALSE);
            this.heightAxis.setAxis((Object)new Double(min), (Object)new Double(max), -1, -1, null, Boolean.TRUE, null);
            this.heightAxis.layoutValueLabels(null);
            double[] ends = this.heightAxis.getMinMaxTickMarkValues();
            min = ends[0];
            max = ends[1];
        } else {
            this.heightAxis.setVisible(false);
            min = 0.0;
            max = this.treeModel.getTreeLevel();
        }
        if (this.orientation == 0) {
            this.dataXMin = this.xMin = min;
            this.dataXMax = this.xMax = max;
            this.heightHandler.setDataRange(this.dataXMin, this.dataXMax);
            this.heightHandler.setMinimumViewportRange(this.silkDefaults.zoomLimitParm * (this.dataXMax - this.dataXMin));
        } else {
            this.dataYMin = this.yMin = min;
            this.dataYMax = this.yMax = max;
            this.heightHandler.setDataRange(this.dataYMin, this.dataYMax);
            this.heightHandler.setMinimumViewportRange(this.silkDefaults.zoomLimitParm * (this.dataYMax - this.dataYMin));
        }
        boolean rc = this.buildDendrogram(buildData);
        if (this.treeAxis != null) {
            if (this.orientation == 0) {
                this.treeAxis.setRole(this.getVariable("Name"), (Object)"YAxis");
            } else {
                this.treeAxis.setRole(this.getVariable("Name"), (Object)"XAxis");
            }
            this.treeAxis.setGridLines((Object)Boolean.FALSE);
            this.treeAxis.setLabel((Object)Boolean.FALSE);
            this.treeAxis.setLine((Object)Boolean.FALSE);
            this.treeAxis.setMajorTicks((Object)Boolean.FALSE);
            Object[] values = this.getTreeAxisLabels();
            this.treeAxis.setAxis((Object)new Double(0.0), (Object)new Double(values.length - 1), -1, -1, values, Boolean.TRUE, null);
            this.treeAxis.layoutValueLabels(null);
            if (this.orientation == 0) {
                this.yMin = -0.5;
                this.dataYMin = -0.5;
                this.dataYMax = this.yMax = (double)(values.length - 1) + 0.5;
                this.treeHandler.setDataRange(this.dataYMin, this.dataYMax);
            } else {
                this.xMin = -0.5;
                this.dataXMin = -0.5;
                this.dataXMax = this.xMax = (double)(values.length - 1) + 0.5;
                this.treeHandler.setDataRange(this.dataXMin, this.dataXMax);
            }
            this.treeHandler.setMinimumViewportRange(1.0);
        }
        if (this.isFisheyeView() && (Double.isNaN(this.focusPointX) || Double.isNaN(this.focusPointY))) {
            this.resetFisheyeViewParameters();
        }
        this.rebuildRequired = false;
        this.dataChanged = false;
        this.redraw = true;
        return rc;
    }

    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean status = this.build(buildData);
        this.draw(drawContext, false);
        return status;
    }

    public long getMasks() {
        return 0L;
    }

    public long setMasks(long mask, long bits) {
        return 0L;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean viz) {
        this.visible = viz;
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public Object getOpacityValue() {
        return new Double(this.opacity);
    }

    public boolean setOpacityValue(Object newOpacity) {
        if (newOpacity == null || !(newOpacity instanceof Number)) {
            return false;
        }
        double newValue = ((Number)newOpacity).doubleValue();
        if (newValue < 0.0 || newValue > 1.0) {
            return false;
        }
        if (newValue != this.opacity) {
            this.opacity = newValue;
            this.fireRedrawEvent(new RedrawEvent((Object)this));
        }
        return true;
    }

    public void draw(Object p, boolean callHighlightDraw) {
        if (p == null || !(p instanceof Graphics2D) || !this.visible) {
            return;
        }
        if (this.branchList == null || this.crossList == null) {
            return;
        }
        Graphics2D g = (Graphics2D)p;
        Composite comp = g.getComposite();
        if (this.opacity < 1.0) {
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, (float)this.opacity);
            g.setComposite(alphaComp);
        }
        Stroke oldStroke = g.getStroke();
        g.setColor(this.nodeColor);
        for (int i = 0; i < this.branchList.size(); ++i) {
            Branch b = (Branch)this.branchList.get(i);
            this.project(b.kidEnd.getX(), b.kidEnd.getY(), 0.0, this.scr1);
            this.project(b.parentEnd.getX(), b.parentEnd.getY(), 0.0, this.scr2);
            float wd = b.node.collapsed ? (float)(this.nodeWidth + 2) : (float)this.nodeWidth;
            g.setStroke(new BasicStroke(wd));
            g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr2[0], (int)this.scr2[1]);
        }
        g.setStroke(new BasicStroke(this.nodeWidth));
        for (int i = 0; i < this.crossList.size(); ++i) {
            Cross c = (Cross)this.crossList.get(i);
            this.project(c.minEnd.getX(), c.minEnd.getY(), 0.0, this.scr1);
            this.project(c.maxEnd.getX(), c.maxEnd.getY(), 0.0, this.scr2);
            g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr2[0], (int)this.scr2[1]);
        }
        if (callHighlightDraw) {
            this.drawHighlight(p);
        }
        g.setStroke(oldStroke);
        g.setComposite(comp);
        this.redraw = false;
    }

    public void drawHighlight(Object p) {
        if (p == null || !(p instanceof Graphics2D) || !this.visible) {
            return;
        }
        if (this.branchList == null || this.crossList == null) {
            return;
        }
        Graphics2D g = (Graphics2D)p;
        Stroke oldStroke = g.getStroke();
        g.setColor(this.selectionColor);
        for (int i = 0; i < this.branchList.size(); ++i) {
            Branch b = (Branch)this.branchList.get(i);
            if (!b.node.selected) continue;
            this.project(b.kidEnd.getX(), b.kidEnd.getY(), 0.0, this.scr1);
            this.project(b.parentEnd.getX(), b.parentEnd.getY(), 0.0, this.scr2);
            float wd = b.node.collapsed ? (float)(this.nodeWidth + 2) : (float)this.nodeWidth;
            g.setStroke(new BasicStroke(wd));
            g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr2[0], (int)this.scr2[1]);
        }
        g.setStroke(new BasicStroke(this.nodeWidth));
        for (int i = 0; i < this.crossList.size(); ++i) {
            Cross c = (Cross)this.crossList.get(i);
            if (!c.node.selected) continue;
            this.project(c.minEnd.getX(), c.minEnd.getY(), 0.0, this.scr1);
            this.project(c.maxEnd.getX(), c.maxEnd.getY(), 0.0, this.scr2);
            g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr2[0], (int)this.scr2[1]);
        }
        g.setStroke(oldStroke);
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public Object getDataSource(Object id) {
        if (this.dataIn == null) {
            return null;
        }
        return this.dataIn.getSource();
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public boolean setDataSource(Object source, Object id) {
        if (source == null || !(source instanceof DataFilterReadInterface)) {
            return false;
        }
        this.dataIn = (DataFilterReadInterface)source;
        if (this.treeModel == null) {
            this.treeModel = new DendrogramModel();
        }
        if (this.treeModel != null) {
            this.treeModel.setDataSource(this.dataIn);
            this.dataOut = null;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        return true;
    }

    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    public Object getVariable(Object role) {
        if (this.treeModel == null) {
            return null;
        }
        return this.treeModel.getVariable(role);
    }

    public Object getRole(Object variableId) {
        if (this.treeModel == null) {
            return null;
        }
        return this.treeModel.getRole(variableId);
    }

    public boolean setRole(Object variableId, Object role) {
        if (this.treeModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        return this.treeModel.setRole(variableId, role);
    }

    public boolean addRole(Object variableId, Object role) {
        if (this.treeModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        return this.treeModel.addRole(variableId, role);
    }

    public boolean removeRole(Object variableId, Object role) {
        if (this.treeModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        return this.treeModel.removeRole(variableId, role);
    }

    public boolean isDiscrete(Object role) {
        if (this.treeModel == null) {
            return false;
        }
        return this.treeModel.isDiscrete(role);
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.treeModel == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        return this.treeModel.setDiscrete(role, discrete);
    }

    public Object getSortOrder(Object role) {
        if (this.treeModel == null) {
            return null;
        }
        return this.treeModel.getSortOrder(role);
    }

    public boolean setSortOrder(Object role, Object order) {
        if (this.treeModel == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        return this.treeModel.setSortOrder(role, order);
    }

    public Object getRoleValue(Object role, int which) {
        if (this.treeModel == null) {
            return null;
        }
        return this.treeModel.getRoleValue(role, which);
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        Object[] roles = discrete ? new Object[]{DendrogramModel.ROLES.getRoleObject("ROLE_NAME"), DendrogramModel.ROLES.getRoleObject("ROLE_PARENT"), DendrogramModel.ROLES.getRoleObject("ROLE_HEIGHT")} : new Object[]{DendrogramModel.ROLES.getRoleObject("ROLE_HEIGHT")};
        return roles;
    }

    public int getMaxAllowed(Object role) {
        return 1;
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public Object getPropertyValue(int idx) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            return this.propertyValue.get(i);
        }
        switch (idx) {
            case 801: {
                return new Boolean(this.fisheyeView);
            }
            case 802: {
                return this.nodeColor;
            }
            case 803: {
                return new Integer(this.nodeWidth);
            }
        }
        return null;
    }

    public boolean setPropertyValue(int idx, Object value) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            this.propertyValue.set(i, value);
        } else {
            this.propertyIndex.add(new Integer(idx));
            this.propertyValue.add(value);
        }
        return true;
    }

    public int getNumberProperties() {
        return 0;
    }

    public boolean applyPropertyChanges() {
        if (this.propertyIndex.size() <= 0) {
            return false;
        }
        block5: for (int i = 0; i < this.propertyIndex.size(); ++i) {
            int idx = (Integer)this.propertyIndex.get(i);
            Object value = this.propertyValue.get(i);
            switch (idx) {
                case 801: {
                    if (!(value instanceof Boolean)) continue block5;
                    this.setFisheyeView((Boolean)value);
                    continue block5;
                }
                case 802: {
                    this.setNodeColor(value);
                    continue block5;
                }
                case 803: {
                    if (!(value instanceof Integer)) continue block5;
                    this.setNodeWidth((Integer)value);
                }
            }
        }
        this.propertyIndex.clear();
        this.propertyValue.clear();
        return true;
    }

    public boolean applyPropertyChanges(Object source) {
        return true;
    }

    public void cancelPropertyChanges() {
        this.propertyIndex.clear();
        this.propertyValue.clear();
    }

    public void cancelPropertyChanges(Object source) {
    }

    public int[] getPendingChanges() {
        int[] index = new int[this.propertyIndex.size()];
        for (int i = 0; i < this.propertyIndex.size(); ++i) {
            index[i] = (Integer)this.propertyIndex.get(i);
        }
        return index;
    }

    public int[] getPendingChanges(Object source) {
        int[] index = new int[this.propertyIndex.size()];
        return index;
    }

    public boolean isPropertySupported(int idx) {
        switch (idx) {
            case 801: 
            case 802: 
            case 803: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int idx) {
        return false;
    }

    public int getNumberPendingProperties() {
        return -1;
    }

    public boolean hasUserSetValue(int id) {
        if (this.userSetProperties.hasProperty(id)) {
            return this.userSetProperties.get(id);
        }
        return true;
    }

    public Object getTransformObject() {
        return this.transformObj;
    }

    public boolean setTransformObject(Object transIn) {
        return true;
    }

    public double[] getBoundingBox() {
        return new double[]{this.dataXMin, this.dataYMin, this.dataXMax, this.dataYMax};
    }

    public boolean setBoundingBox(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        if (this.orientation == 0) {
            this.yMin = ymin;
            this.yMax = ymax;
        } else {
            this.xMin = xmin;
            this.xMax = xmax;
        }
        return true;
    }

    public Rectangle getScreenArea() {
        return null;
    }

    public boolean setScreenArea(int xmin, int ymin, int width, int height) {
        return false;
    }

    public double[] getViewport(int type, int level, int dimension) {
        double[] vport = new double[2];
        switch (dimension) {
            case 1: {
                if (this.orientation == 0) {
                    vport[0] = this.dataXMin + (this.dataXMax - this.xMax);
                    vport[1] = this.dataXMax - (this.xMin - this.dataXMin);
                    break;
                }
                vport[0] = this.xMin;
                vport[1] = this.xMax;
                break;
            }
            case 2: {
                if (this.orientation == 1) {
                    vport[0] = this.dataYMin + (this.dataYMax - this.yMax);
                    vport[1] = this.dataYMax - (this.yMin - this.dataYMin);
                    break;
                }
                vport[0] = this.yMin;
                vport[1] = this.yMax;
                break;
            }
            default: {
                return null;
            }
        }
        return vport;
    }

    public boolean setViewport(int type, int dimension, double min, double max) {
        switch (dimension) {
            case 1: {
                if (this.orientation == 0) {
                    this.xMin = this.dataXMin + (this.dataXMax - max);
                    this.xMax = this.dataXMax - (min - this.dataXMin);
                    break;
                }
                this.xMin = min;
                this.xMax = max;
                break;
            }
            case 2: {
                if (this.orientation == 1) {
                    this.yMin = this.dataYMin + (this.dataYMax - max);
                    this.yMax = this.dataYMax - (min - this.dataYMin);
                    break;
                }
                this.yMin = min;
                this.yMax = max;
                break;
            }
            default: {
                return false;
            }
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
        return true;
    }

    public boolean setViewport(int type, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        if (type == 1) {
            if (this.orientation == 0) {
                this.yMin = ymin;
                this.yMax = ymax;
                this.xMin = this.dataXMin + (this.dataXMax - xmax);
                this.xMax = this.dataXMax - (xmin - this.dataXMin);
            } else if (this.orientation == 1) {
                this.xMin = xmin;
                this.xMax = xmax;
                this.yMin = this.dataYMin + (this.dataYMax - ymax);
                this.yMax = this.dataYMax - (ymin - this.dataYMin);
            }
        } else if (type == 3) {
            double[] min = new double[3];
            double[] max = new double[3];
            this.unProject(xmin, ymax, 0.0, min);
            this.unProject(xmax, ymin, 0.0, max);
            if (this.orientation == 0) {
                this.yMin = min[1];
                this.yMax = max[1];
            } else if (this.orientation == 1) {
                this.xMin = min[0];
                this.xMax = max[0];
            }
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
        return true;
    }

    public boolean resetViewport() {
        this.xMin = this.dataXMin;
        this.xMax = this.dataXMax;
        this.yMin = this.dataYMin;
        this.yMax = this.dataYMax;
        if (this.isFisheyeView()) {
            this.resetFisheyeViewParameters();
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
        return true;
    }

    public void viewportChanged(ViewportEvent evt) {
        if (!Double.isNaN(evt.xMin)) {
            this.xMin = evt.xMin;
        }
        if (!Double.isNaN(evt.xMax)) {
            this.xMax = evt.xMax;
        }
        if (!Double.isNaN(evt.yMin)) {
            this.yMin = evt.yMin;
        }
        if (!Double.isNaN(evt.yMax)) {
            this.yMax = evt.yMax;
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    protected void fireRedrawEvent(RedrawEvent e) {
        if (this.redraw) {
            return;
        }
        block4: for (int i = 0; i < this.redrawListener.size(); ++i) {
            RedrawListener listener = (RedrawListener)this.redrawListener.get(i);
            if (listener == null) continue;
            switch (e.type) {
                default: {
                    listener.redraw(e);
                    continue block4;
                }
                case 2: {
                    listener.boundingBoxChanged(e);
                    listener.outerMarginChanged(e);
                    continue block4;
                }
                case 3: {
                    listener.outerMarginChanged(e);
                }
            }
        }
    }

    public void addRedrawListener(RedrawListener listener) {
        if (!this.redrawListener.contains(listener)) {
            this.redrawListener.add(listener);
        }
    }

    public void removeRedrawListener(RedrawListener listener) {
        if (this.redrawListener.contains(listener)) {
            this.redrawListener.remove(this.redrawListener.indexOf(listener));
        }
    }

    public void setDataChanged() {
        this.dataChanged = true;
        this.rebuildRequired = true;
        if (this.treeModel != null) {
            this.treeModel.setRebuildTreeRequired(true);
        }
    }

    public boolean isValid() {
        if (this.treeModel != null) {
            return this.treeModel.isValidTree();
        }
        return false;
    }

    class Transformation
    implements TransformInterface {
        boolean treeAxis;
        boolean inverseX;
        boolean inverseY;
        boolean fisheyeX;
        boolean fisheyeY;

        Transformation(boolean treeAxis) {
            this.treeAxis = treeAxis;
        }

        public double[] project(double x, double y, double z, double[] out) {
            double[] ret = out;
            if (ret == null && (ret = new double[3]) == null) {
                return null;
            }
            ret[1] = Double.NaN;
            ret[0] = Double.NaN;
            if (Double.isNaN(DendrogramChart.this.xMin) || Double.isNaN(DendrogramChart.this.xMax) || Double.isNaN(DendrogramChart.this.yMin) || Double.isNaN(DendrogramChart.this.yMax)) {
                return ret;
            }
            this.decideParameters();
            double w = DendrogramChart.this.clipRect.width;
            double h = DendrogramChart.this.clipRect.height;
            double xo = DendrogramChart.this.clipRect.x;
            double yo = DendrogramChart.this.clipRect.y;
            if (this.fisheyeX) {
                ret[0] = DendrogramChart.this.xMax == DendrogramChart.this.xMin ? xo : this.fisheyeProject(x, y, z, true);
            } else if (this.inverseX) {
                ret[0] = DendrogramChart.this.xMax == DendrogramChart.this.xMin ? xo : w - w * (x - DendrogramChart.this.xMin) / (DendrogramChart.this.xMax - DendrogramChart.this.xMin) + xo;
            } else {
                double d = ret[0] = DendrogramChart.this.xMax == DendrogramChart.this.xMin ? xo : w * (x - DendrogramChart.this.xMin) / (DendrogramChart.this.xMax - DendrogramChart.this.xMin) + xo;
            }
            ret[1] = this.fisheyeY ? (DendrogramChart.this.yMax == DendrogramChart.this.yMin ? yo : this.fisheyeProject(x, y, z, false)) : (this.inverseY ? (DendrogramChart.this.yMax == DendrogramChart.this.yMin ? yo : h - h * (y - DendrogramChart.this.yMin) / (DendrogramChart.this.yMax - DendrogramChart.this.yMin) + yo) : (DendrogramChart.this.yMax == DendrogramChart.this.yMin ? yo : h * (y - DendrogramChart.this.yMin) / (DendrogramChart.this.yMax - DendrogramChart.this.yMin) + yo));
            ret[2] = 0.0;
            return ret;
        }

        public double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
            double[] ret = out;
            if (ret == null && (ret = new double[3]) == null) {
                return null;
            }
            ret[1] = Double.NaN;
            ret[0] = Double.NaN;
            if (Double.isNaN(DendrogramChart.this.xMin) || Double.isNaN(DendrogramChart.this.xMax) || Double.isNaN(DendrogramChart.this.yMin) || Double.isNaN(DendrogramChart.this.yMax)) {
                return ret;
            }
            this.decideParameters();
            double w = DendrogramChart.this.clipRect.width;
            double h = DendrogramChart.this.clipRect.height;
            double xo = DendrogramChart.this.clipRect.x;
            double yo = DendrogramChart.this.clipRect.y;
            if (this.fisheyeX) {
                ret[0] = w == 0.0 ? DendrogramChart.this.xMin : this.fisheyeUnProject(pixelX, pixelY, pixelZ, true);
            } else if (this.inverseX) {
                ret[0] = w == 0.0 ? DendrogramChart.this.xMin : (DendrogramChart.this.xMax - DendrogramChart.this.xMin) * (w + xo - pixelX) / w + DendrogramChart.this.xMin;
            } else {
                double d = ret[0] = w == 0.0 ? DendrogramChart.this.xMin : (DendrogramChart.this.xMax - DendrogramChart.this.xMin) * (pixelX - xo) / w + DendrogramChart.this.xMin;
            }
            ret[1] = this.fisheyeY ? (h == 0.0 ? DendrogramChart.this.yMin : this.fisheyeUnProject(pixelX, pixelY, pixelZ, false)) : (this.inverseY ? (h == 0.0 ? DendrogramChart.this.yMin : (DendrogramChart.this.yMax - DendrogramChart.this.yMin) * (h + yo - pixelY) / h + DendrogramChart.this.yMin) : (h == 0.0 ? DendrogramChart.this.yMin : (DendrogramChart.this.yMax - DendrogramChart.this.yMin) * (pixelY - yo) / h + DendrogramChart.this.yMin));
            ret[2] = 0.0;
            return ret;
        }

        private double fisheyeProject(double x, double y, double z, boolean hori) {
            double focusPoint = hori ? DendrogramChart.this.focusPointX : DendrogramChart.this.focusPointY;
            double distortionFactor = hori ? DendrogramChart.this.distortionFactorX : DendrogramChart.this.distortionFactorY;
            double min = hori ? DendrogramChart.this.xMin : DendrogramChart.this.yMin;
            double max = hori ? DendrogramChart.this.xMax : DendrogramChart.this.yMax;
            double v = hori ? x : y;
            double norm = (v - min) / (max - min) * 2.0 - 1.0;
            double abs = Math.abs(norm -= focusPoint);
            double ret = (1.0 + distortionFactor) * abs / (distortionFactor * abs + 1.0);
            if (norm < 0.0) {
                ret = -ret;
            }
            if (focusPoint != 0.0) {
                double fisheyeMin = -(1.0 + distortionFactor) * (1.0 + focusPoint) / (distortionFactor * (1.0 + focusPoint) + 1.0);
                double fisheyeMax = (1.0 + distortionFactor) * (1.0 - focusPoint) / (distortionFactor * (1.0 - focusPoint) + 1.0);
                ret = (ret - fisheyeMin) / (fisheyeMax - fisheyeMin) * 2.0 - 1.0;
            }
            double oo = hori ? (double)DendrogramChart.this.clipRect.x : (double)DendrogramChart.this.clipRect.y;
            double len = hori ? (double)DendrogramChart.this.clipRect.width : (double)DendrogramChart.this.clipRect.height;
            boolean inverse = hori ? this.inverseX : this.inverseY;
            ret = (ret + 1.0) * len / 2.0;
            ret = inverse ? len - ret + oo : (ret += oo);
            return ret;
        }

        private double fisheyeUnProject(double pixelX, double pixelY, double pixelZ, boolean hori) {
            double focusPoint = hori ? DendrogramChart.this.focusPointX : DendrogramChart.this.focusPointY;
            double distortionFactor = hori ? DendrogramChart.this.distortionFactorX : DendrogramChart.this.distortionFactorY;
            double oo = hori ? (double)DendrogramChart.this.clipRect.x : (double)DendrogramChart.this.clipRect.y;
            double len = hori ? (double)DendrogramChart.this.clipRect.width : (double)DendrogramChart.this.clipRect.height;
            boolean inverse = hori ? this.inverseX : this.inverseY;
            double pixel = hori ? pixelX : pixelY;
            pixel = inverse ? len - pixel + oo : pixel - oo;
            pixel = pixel * 2.0 / len - 1.0;
            if (focusPoint != 0.0) {
                double fisheyeMin = -(1.0 + distortionFactor) * (1.0 + focusPoint) / (distortionFactor * (1.0 + focusPoint) + 1.0);
                double fisheyeMax = (1.0 + distortionFactor) * (1.0 - focusPoint) / (distortionFactor * (1.0 - focusPoint) + 1.0);
                pixel = (pixel + 1.0) * (fisheyeMax - fisheyeMin) / 2.0 + fisheyeMin;
            }
            double pixelabs = Math.abs(pixel);
            double ret = pixelabs / (1.0 + distortionFactor - pixelabs * distortionFactor);
            if (pixel < 0.0) {
                ret = -ret;
            }
            ret += focusPoint;
            double min = hori ? DendrogramChart.this.xMin : DendrogramChart.this.yMin;
            double max = hori ? DendrogramChart.this.xMax : DendrogramChart.this.yMax;
            ret = (ret + 1.0) * (max - min) / 2.0 + min;
            return ret;
        }

        private void decideParameters() {
            if (DendrogramChart.this.orientation == 0) {
                this.inverseX = this.treeAxis ? false : !DendrogramChart.this.reversedTree;
                this.inverseY = true;
                this.fisheyeX = DendrogramChart.this.fisheyeView;
                this.fisheyeY = DendrogramChart.this.fisheyeView;
            } else {
                this.inverseX = false;
                this.inverseY = this.treeAxis ? true : DendrogramChart.this.reversedTree;
                this.fisheyeX = DendrogramChart.this.fisheyeView;
                this.fisheyeY = DendrogramChart.this.fisheyeView;
            }
        }

        public boolean isReverse(int axis) {
            return !this.treeAxis;
        }

        public void setReverse(int axis, boolean flag) {
        }
    }

    class Branch {
        Point2D kidEnd;
        Point2D parentEnd;
        Color color;
        DendrogramModel.Node node;

        Branch() {
        }
    }

    class Cross {
        Point2D minEnd;
        Point2D maxEnd;
        Color color;
        DendrogramModel.Node node;

        Cross() {
        }
    }
}

