/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.data;

import com.sas.graphics.data.DvrData;
import com.sas.graphics.silk.data.JavaDataFilter;
import com.sas.graphics.silk.dtree.TreeRoles;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.TreeModelEvent;
import com.sas.graphics.silk.event.TreeModelListenerInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.DataFilterWriteInterface;
import com.sas.graphics.silk.interfaces.DataInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TreeModelInterface;
import com.sas.graphics.silk.util.DecisionTreeNode;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.RoleManager;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class TreeModel
extends TreeRoles
implements TreeModelInterface,
DataFilterListenerInterface {
    protected DataInterface allData;
    protected static final String input = "INPUT_DATASET";
    protected static final String interact = "INTERACTION_DATASET";
    protected static final String graph = "GRAPH_DATASET";
    protected Vector listeners = new Vector();
    private RoleManager roles = new RoleManager();
    private Hashtable nodeIdToModelIndex = new Hashtable();
    private boolean listening = false;

    public TreeModel() {
        this.roles.newRole((Object)this.COLLAPSED_ROLE, (Object)"Collapsed", 1);
        this.roles.newRole((Object)this.FLAGGED_ROLE, (Object)"Flagged", 1);
        this.roles.newRole((Object)this.SELECTED_ROLE, (Object)"Selected", 1);
        this.roles.newRole((Object)this.ID_ROLE, (Object)"ID", 1);
        this.roles.newRole((Object)this.PARENT_ROLE, (Object)"Parent", 1);
        this.roles.newRole((Object)this.NODE_TEXT_ROLE, (Object)"NodeText", 1);
        this.roles.newRole((Object)this.NODE_SIZE_ROLE, (Object)"NodeSize", 1);
        this.roles.newRole((Object)this.NODE_COLOR_ROLE, (Object)"NodeColor", 1);
        this.roles.newRole((Object)this.LINK_WIDTH_ROLE, (Object)"LinkWidth", 1);
        this.roles.newRole((Object)this.ABOVE_TEXT_ROLE, (Object)"AboveText", 1);
        this.roles.newRole((Object)this.BELOW_TEXT_ROLE, (Object)"BelowText", 1);
        this.roles.newRole((Object)this.SURROGATE_ROLE, (Object)"Surrogate", 1);
        this.roles.newRole((Object)this.TOOLTIP_TEXT_ROLE, (Object)"ToolTipText", 1);
        this.roles.newRole((Object)this.GRAPH_VAR_ROLE, (Object)"GRAPH_VAR", 10);
        this.roles.newRole((Object)this.GRAPH_ID_ROLE, (Object)"GRAPH_VAR_ID", 1);
    }

    public TreeModel(Object dataIn) {
        this();
        this.setupData(dataIn);
    }

    private void setupData(Object dataIn) {
        DataFilterReadInterface filter = this.getFilter(dataIn);
        if (filter == null) {
            return;
        }
        this.nodeIdToModelIndex.clear();
        this.allData = new DvrData();
        this.allData.setDataSource((Object)input, filter.getSource(), filter, null);
        JavaDataFilter inter = new JavaDataFilter();
        inter.defineVariable((Object)this.COLLAPSED_ROLE, (Object)"", null);
        inter.defineVariable((Object)this.FLAGGED_ROLE, (Object)"", null);
        inter.defineVariable((Object)this.SELECTED_ROLE, (Object)"", null);
        for (int i = 0; i < filter.getNumberObservations((Object)this.ID_ROLE); ++i) {
            inter.setValue((Object)this.COLLAPSED_ROLE, -1L, (Object)new Double(0.0));
            inter.setValue((Object)this.FLAGGED_ROLE, -1L, (Object)new Double(0.0));
            inter.setValue((Object)this.SELECTED_ROLE, -1L, (Object)new Double(0.0));
        }
        this.allData.setDataSource((Object)interact, inter.getSource(), (DataFilterReadInterface)inter, null);
        this.setRole(this.FLAGGED_ROLE, this.FLAGGED_ROLE);
        this.setRole(this.SELECTED_ROLE, this.SELECTED_ROLE);
        this.setRole(this.COLLAPSED_ROLE, this.COLLAPSED_ROLE);
        inter.addDataFilterListener((Object)this);
        filter.addDataFilterListener((Object)this);
    }

    public DataFilterReadInterface getTreeData() {
        if (this.allData == null) {
            return null;
        }
        DataFilterReadInterface rc = this.allData.getDataSource((Object)input);
        return rc;
    }

    @Override
    public DataFilterReadInterface getFilter() {
        return this.getTreeData();
    }

    public boolean isSelected(int nodeID) {
        int sel = (int)this.getDouble(this.getValue(this.SELECTED_ROLE, this.getModelIndexForNodeId(new Integer(nodeID))));
        return sel > 0;
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        if (this.getTreeData() == null) {
            return false;
        }
        return this.getTreeData().applyWhereClause(clause, clearPrevious);
    }

    public String getWhereClause() {
        if (this.getTreeData() == null) {
            return null;
        }
        return this.getTreeData().getWhereClause();
    }

    @Override
    public void setListening(boolean b) {
        if (b) {
            this.getTreeData().addDataFilterListener((Object)this);
            this.listening = true;
        } else {
            this.getTreeData().removeDataFilterListener((Object)this);
            this.listening = false;
        }
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    @Override
    public DataFilterReadInterface getGraphFilter() {
        if (this.allData == null) {
            return null;
        }
        return this.allData.getDataSource((Object)graph);
    }

    @Override
    public boolean hasGraphData() {
        return this.getGraphFilter() != null;
    }

    @Override
    public boolean setGraphData(Object obj) {
        return this.setGraphData(FilterFactory.getDataSourceFilter((Object)obj));
    }

    public boolean setGraphData(DataFilterReadInterface data) {
        if (data == null) {
            return false;
        }
        data.addDataFilterListener((Object)this);
        boolean rc = this.allData.setDataSource((Object)graph, data.getSource(), data, null);
        TreeModelEvent event = new TreeModelEvent();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListenerInterface)this.listeners.elementAt(i)).graphDataChanged(event);
        }
        return rc;
    }

    private DataFilterReadInterface getFilter(Object data) {
        if (data instanceof DataFilterReadInterface) {
            return (DataFilterReadInterface)data;
        }
        return FilterFactory.getDataSourceFilter((Object)data);
    }

    @Override
    public long numNodes() {
        if (this.allData == null) {
            return 0L;
        }
        DataFilterReadInterface data = this.allData.getDataSource((Object)input);
        if (data == null) {
            return 0L;
        }
        return data.getNumberObservations(this.getVariable(ROLE_ID));
    }

    @Override
    public boolean isDefined(int id) {
        Object variable = this.getVariable(new Integer(id));
        return variable != null;
    }

    @Override
    public double[] getVariableMinMax(int id) {
        Integer ID = new Integer(id);
        double[] rc = new double[2];
        Object variable = this.getVariable(new Integer(id));
        if (variable == null) {
            return null;
        }
        DataFilterReadInterface data = null;
        data = ID.equals(this.COLLAPSED_ROLE) || ID.equals(this.SELECTED_ROLE) || ID.equals(this.FLAGGED_ROLE) ? this.allData.getDataSource((Object)interact) : (ID.equals(this.GRAPH_ID_ROLE) || ID.equals(this.GRAPH_VAR_ROLE) ? this.allData.getDataSource((Object)graph) : this.allData.getDataSource((Object)input));
        if (data == null) {
            return null;
        }
        if (data instanceof DataFilterInfoInterface) {
            DataFilterInfoInterface info = (DataFilterInfoInterface)data;
            Object min = info.getMinimumValue(variable);
            Object max = info.getMaximumValue(variable);
            rc[0] = min instanceof Number ? ((Number)min).doubleValue() : 1.0;
            rc[1] = max instanceof Number ? ((Number)max).doubleValue() : 1.0;
        } else {
            double min = 0.0;
            double max = 0.0;
            for (int i = 0; i < data.getNumberObservations(-1); ++i) {
                Object value = data.getValue(variable, (long)i);
                if (!(value instanceof Number)) continue;
                double d = ((Number)value).doubleValue();
                if (d < min) {
                    min = d;
                }
                if (!(d > max)) continue;
                max = d;
            }
            rc[0] = min;
            rc[1] = max;
        }
        return rc;
    }

    protected Object getValue(Object id, int index) {
        return this.getValue(id, index, 0);
    }

    protected Object getValue(Object id, int index, int which) {
        if (id == null) {
            return null;
        }
        Object variable = this.getVariable(id, which);
        DataFilterReadInterface data = null;
        data = id.equals(this.COLLAPSED_ROLE) || id.equals(this.SELECTED_ROLE) || id.equals(this.FLAGGED_ROLE) ? this.allData.getDataSource((Object)interact) : (id.equals(this.GRAPH_ID_ROLE) || id.equals(this.GRAPH_VAR_ROLE) ? this.allData.getDataSource((Object)graph) : this.allData.getDataSource((Object)input));
        if (data == null) {
            return null;
        }
        return data.getValue(variable, (long)index);
    }

    @Override
    public TreeNode getRoot() {
        long numObs = this.numNodes();
        Object target = null;
        DataFilterReadInterface dfri = this.getTreeData();
        Object parentVar = this.getVariable(this.PARENT_ROLE, 0);
        int i = 0;
        while ((long)i < numObs) {
            Object parentValue = this.getValue(this.PARENT_ROLE, i);
            if (dfri.isNumericVariable(parentVar) && parentValue instanceof Number && ((Number)parentValue).intValue() <= 0) {
                target = this.getValue(this.ID_ROLE, i);
                i = (int)numObs++;
            } else if (!dfri.isNumericVariable(parentVar) && dfri.isMissing(parentVar, parentValue)) {
                target = this.getValue(this.ID_ROLE, i);
                i = (int)numObs++;
            }
            ++i;
        }
        TreeNode rc = this.getNode(target);
        return rc;
    }

    public Object[] getColumn(Object id) {
        int n = (int)this.numNodes();
        Object[] rc = new Object[n];
        for (int i = 0; i < n; ++i) {
            rc[i] = this.getValue(id, i);
        }
        return rc;
    }

    @Override
    public void setCollapsed(Object nodeID, boolean collapsed) {
        if (nodeID == null) {
            return;
        }
        DataFilterWriteInterface data = (DataFilterWriteInterface)this.allData.getDataSource((Object)interact);
        data.setValue((Object)this.COLLAPSED_ROLE, (long)this.getModelIndexForNodeId(nodeID), (Object)(collapsed ? new Double(1.0) : new Double(0.0)));
    }

    @Override
    public boolean isCollapsed(Object nodeID) {
        boolean rc = false;
        DataFilterWriteInterface data = (DataFilterWriteInterface)this.allData.getDataSource((Object)interact);
        Object val = data.getValue((Object)this.COLLAPSED_ROLE, (long)this.getModelIndexForNodeId(nodeID));
        if (val instanceof Number) {
            rc = ((Number)val).intValue() == 1;
        }
        return rc;
    }

    @Override
    public void recursiveSetCollapsed(Object nodeID, boolean collapsed) {
        if (nodeID == null) {
            return;
        }
        DataFilterWriteInterface data = (DataFilterWriteInterface)this.allData.getDataSource((Object)interact);
        data.setValue((Object)this.COLLAPSED_ROLE, (long)this.getModelIndexForNodeId(nodeID), (Object)(collapsed ? new Double(1.0) : new Double(0.0)));
        for (int j = 0; j < (int)this.numNodes(); ++j) {
            if (!nodeID.equals(this.getValue(this.PARENT_ROLE, j))) continue;
            this.recursiveSetCollapsed(this.getValue(this.ID_ROLE, j), collapsed);
        }
    }

    @Override
    public boolean isFlagged(Object nodeID) {
        boolean rc = false;
        DataFilterWriteInterface data = (DataFilterWriteInterface)this.allData.getDataSource((Object)interact);
        Object val = data.getValue((Object)this.FLAGGED_ROLE, (long)this.getModelIndexForNodeId(nodeID));
        if (val instanceof Number) {
            rc = ((Number)val).intValue() == 1;
        }
        return rc;
    }

    @Override
    public void setFlagged(Object nodeID, boolean flag) {
        if (nodeID == null) {
            return;
        }
        DataFilterWriteInterface data = (DataFilterWriteInterface)this.allData.getDataSource((Object)interact);
        data.setValue((Object)this.FLAGGED_ROLE, (long)this.getModelIndexForNodeId(nodeID), (Object)(flag ? new Double(1.0) : new Double(0.0)));
    }

    @Override
    public void setSelected(Object nodeID, int selection) {
        if (nodeID == null) {
            return;
        }
        DataFilterWriteInterface data = (DataFilterWriteInterface)this.allData.getDataSource((Object)interact);
        data.setValue((Object)this.SELECTED_ROLE, (long)this.getModelIndexForNodeId(nodeID), (Object)new Double(selection));
    }

    @Override
    public boolean isSelected(Object nodeID) {
        boolean rc = false;
        DataFilterWriteInterface data = (DataFilterWriteInterface)this.allData.getDataSource((Object)interact);
        Object val = data.getValue((Object)this.SELECTED_ROLE, (long)this.getModelIndexForNodeId(nodeID));
        if (val instanceof Number) {
            rc = ((Number)val).intValue() == 1;
        }
        return rc;
    }

    @Override
    public TreeNode getNode(Object IDvalue) {
        long numObs = this.numNodes();
        int targetOb = this.getModelIndexForNodeId(IDvalue);
        if (targetOb == -1) {
            return null;
        }
        DecisionTreeNode rc = new DecisionTreeNode();
        rc.aboveText = this.getString(this.getValue(this.ABOVE_TEXT_ROLE, targetOb));
        rc.belowText = this.getString(this.getValue(this.BELOW_TEXT_ROLE, targetOb));
        rc.nodeText = this.getString(this.getValue(this.NODE_TEXT_ROLE, targetOb));
        rc.tooltipText = this.getString(this.getValue(this.TOOLTIP_TEXT_ROLE, targetOb));
        if (rc.parsedToolTipText == null) {
            rc.parsedToolTipText = rc.parsedNodeText;
        }
        rc.ID = IDvalue;
        rc.parentID = this.getValue(this.PARENT_ROLE, targetOb);
        rc.linkWidth = (int)this.getDouble(this.getValue(this.LINK_WIDTH_ROLE, targetOb));
        rc.nodeSize = (int)this.getDouble(this.getValue(this.NODE_SIZE_ROLE, targetOb));
        rc.nodeColor = this.getDouble(this.getValue(this.NODE_COLOR_ROLE, targetOb));
        int gTargetOb = -1;
        DataFilterReadInterface gData = this.allData.getDataSource((Object)graph);
        if (gData == null) {
            return rc;
        }
        int i = 0;
        while ((long)i < numObs) {
            Object val = this.getValue(this.GRAPH_ID_ROLE, i);
            if (val.equals(IDvalue)) {
                gTargetOb = i;
                i = (int)numObs++;
            }
            ++i;
        }
        rc.graphData = new double[10];
        rc.graphData[0] = this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, gTargetOb, 0));
        rc.graphData[1] = this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, gTargetOb, 1));
        rc.graphData[2] = this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, gTargetOb, 2));
        rc.graphData[3] = this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, gTargetOb, 3));
        rc.graphData[4] = this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, gTargetOb, 4));
        rc.graphData[5] = this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, gTargetOb, 5));
        rc.graphData[6] = this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, gTargetOb, 6));
        rc.graphData[7] = this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, gTargetOb, 7));
        rc.graphData[8] = this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, gTargetOb, 8));
        rc.graphData[9] = this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, gTargetOb, 9));
        return rc;
    }

    @Override
    public double[] calculateGraphAxisExtents(int numBars, int numStacks) {
        long numObs = this.numNodes();
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int i = 0;
        while ((long)i < numObs) {
            double[] gData = new double[]{this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, i, 0)), this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, i, 1)), this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, i, 2)), this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, i, 3)), this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, i, 4)), this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, i, 5)), this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, i, 6)), this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, i, 7)), this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, i, 8)), this.getDouble(this.getValue(this.GRAPH_VAR_ROLE, i, 9))};
            int counter = 0;
            for (int j = 0; j < numBars; ++j) {
                double temp = 0.0;
                for (int k = 0; k < numStacks; ++k) {
                    temp += gData[counter];
                    ++counter;
                }
                if (temp < min) {
                    min = temp;
                }
                if (!(temp > max)) continue;
                max = temp;
            }
            ++i;
        }
        return new double[]{min, max};
    }

    private double getDouble(Object o) {
        if (o == null || !(o instanceof Number)) {
            return Double.NaN;
        }
        return ((Number)o).doubleValue();
    }

    private String getString(Object o) {
        if (o == null || !(o instanceof String)) {
            return null;
        }
        return (String)o;
    }

    @Override
    public Vector getChildren(Object IDvalue) {
        Vector<TreeNode> rc = new Vector<TreeNode>();
        Object value = null;
        int num = (int)this.numNodes();
        for (int i = 0; i < num; ++i) {
            Object val = this.getValue(this.ID_ROLE, i);
            value = this.getValue(this.PARENT_ROLE, i);
            if (value == null || !value.equals(IDvalue)) continue;
            rc.addElement(this.getNode(val));
        }
        return rc;
    }

    @Override
    public Vector getLeaves() {
        return null;
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource(Object id) {
        return this.getTreeData().getSource();
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public boolean setDataSource(Object source, Object id) {
        this.setupData(source);
        return true;
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    public Object getVariable(Object role) {
        return this.roles.getVariable(role, 0);
    }

    public Object getVariable(Object role, int which) {
        return this.roles.getVariable(role, which);
    }

    public Object getRole(Object variableId) {
        return this.roles.getRole(variableId);
    }

    public boolean addRole(Object varID, Object role) {
        return this.setRole(varID, role);
    }

    public boolean removeRole(Object variableId, Object role) {
        boolean rc = this.roles.removeRole(variableId, role);
        if (rc) {
            TreeModelEvent event = new TreeModelEvent();
            event.nodeID = null;
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TreeModelListenerInterface)this.listeners.elementAt(i)).treeDataChanged(event);
            }
        }
        return rc;
    }

    public boolean setRole(Object variableId, Object role) {
        boolean rc = this.roles.setRole(variableId, role);
        if (rc) {
            TreeModelEvent event = new TreeModelEvent();
            event.nodeID = null;
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TreeModelListenerInterface)this.listeners.elementAt(i)).treeDataChanged(event);
            }
        }
        return rc;
    }

    public Object getRoleValue(Object role, int which) {
        return null;
    }

    public boolean isDiscrete(Object o) {
        return false;
    }

    public boolean setDiscrete(Object o, boolean b) {
        return false;
    }

    public Object[] getSupportedRoles(Object id, boolean b) {
        if (!b) {
            return new Object[]{this.GRAPH_VAR_ROLE};
        }
        return new Object[]{this.ID_ROLE, this.PARENT_ROLE, this.NODE_TEXT_ROLE, this.NODE_SIZE_ROLE, this.NODE_COLOR_ROLE, this.LINK_WIDTH_ROLE, this.ABOVE_TEXT_ROLE, this.BELOW_TEXT_ROLE, this.SURROGATE_ROLE, this.TOOLTIP_TEXT_ROLE, this.GRAPH_VAR_ROLE};
    }

    public int getMaxAllowed(Object o) {
        return 1;
    }

    public Object getSortOrder(Object variableId) {
        return this.roles.getSortOrder(variableId);
    }

    public boolean setSortOrder(Object variableId, Object order) {
        return this.roles.setSortOrder(variableId, order);
    }

    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    public void addRoleListener(RoleListenerInterface rli) {
    }

    public void removeRoleListener(RoleListenerInterface rli) {
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        block22: {
            TreeModelEvent event;
            block21: {
                event = new TreeModelEvent();
                if (evt.source != this.allData.getDataSource((Object)interact)) break block21;
                switch (evt.type) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        DataFilterWriteInterface data = (DataFilterWriteInterface)this.allData.getDataSource((Object)interact);
                        int[] arr = (int[])evt.oldValue;
                        if (arr == null) {
                            data.unselectAll();
                            return;
                        }
                        for (int i = 0; i < arr.length; ++i) {
                            data.setValue((Object)this.SELECTED_ROLE, (long)arr[i], (Object)(evt.source.isSelected((long)arr[i]) ? new Double(1.0) : new Double(0.0)));
                        }
                        break block22;
                    }
                    case 3: {
                        DataFilterReadInterface src = evt.source;
                        Object varID = src.getVariableId(evt.varStartIndex);
                        event.variableRole = ((Object[])this.roles.getRole((Object)varID.toString()))[0].toString();
                        event.nodeID = this.getValue(this.ID_ROLE, evt.obsStartIndex);
                        this.getTreeData().removeDataFilterListener((Object)this);
                        this.getTreeData().setSelected((long)evt.obsStartIndex, ((Double)evt.source.getValue((Object)this.SELECTED_ROLE, (long)evt.obsStartIndex)).intValue() == 1);
                        this.getTreeData().addDataFilterListener((Object)this);
                        for (int i = 0; i < this.listeners.size(); ++i) {
                            ((TreeModelListenerInterface)this.listeners.elementAt(i)).interactionChange(event);
                        }
                        break block22;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
                break block22;
            }
            if (evt.source == this.allData.getDataSource((Object)input)) {
                switch (evt.type) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        DataFilterWriteInterface data = (DataFilterWriteInterface)this.allData.getDataSource((Object)interact);
                        int[] arr = (int[])evt.oldValue;
                        if (arr == null) {
                            for (int i = 0; i < data.getNumberObservations(-1); ++i) {
                                data.setValue((Object)this.SELECTED_ROLE, (long)i, (Object)new Double(0.0));
                            }
                            return;
                        }
                        for (int i = 0; i < arr.length; ++i) {
                            data.setValue((Object)this.SELECTED_ROLE, (long)arr[i], (Object)(evt.source.isSelected((long)arr[i]) ? new Double(1.0) : new Double(0.0)));
                        }
                        break;
                    }
                    case 3: {
                        DataFilterReadInterface src = evt.source;
                        Object varID = src.getVariableId(evt.varStartIndex);
                        if (this.roles.getRole(varID) == null) break;
                        event.variableRole = this.roles.getRole(varID).toString();
                        event.nodeID = this.getValue(this.ID_ROLE, evt.obsStartIndex);
                        for (int i = 0; i < this.listeners.size(); ++i) {
                            if (evt.source != this.allData.getDataSource((Object)input)) continue;
                            ((TreeModelListenerInterface)this.listeners.elementAt(i)).treeDataChanged(event);
                        }
                        break;
                    }
                }
            }
        }
    }

    public void variableAdded(DvrDataFilterEvent evt) {
    }

    public void variableRemoved(DvrDataFilterEvent evt) {
    }

    public void formatChanged(DvrDataFilterEvent evt) {
    }

    @Override
    public void addTreeModelListener(TreeModelListenerInterface obj) {
        if (this.listeners != null && obj != null && !this.listeners.contains(obj)) {
            this.listeners.addElement(obj);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListenerInterface obj) {
        this.listeners.remove(obj);
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public int getModelIndexForNodeId(Object nodeId) {
        Object obj;
        int rc = -1;
        if (nodeId == null) {
            return -1;
        }
        if (!this.nodeIdToModelIndex.containsKey(nodeId)) {
            for (int i = 0; i < (int)this.numNodes(); ++i) {
                if (!nodeId.equals(this.getValue(this.ID_ROLE, i))) continue;
                this.nodeIdToModelIndex.put(nodeId, new Integer(i));
                i = (int)this.numNodes();
            }
        }
        if ((obj = this.nodeIdToModelIndex.get(nodeId)) instanceof Number) {
            rc = ((Number)obj).intValue();
        }
        return rc;
    }
}

