/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.data;

import com.sas.graphics.silk.dtree.TreeRoles;
import com.sas.graphics.silk.event.TreeModelEvent;
import com.sas.graphics.silk.event.TreeModelListenerInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TreeModelInterface;
import com.sas.graphics.silk.interfaces.TreeNodeInterface;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class JavaTreeModel
extends TreeRoles
implements TreeModelInterface {
    private TreeModel model = null;
    private EventListenerList treeExpandListeners = new EventListenerList();
    private EventListenerList treeWillExpandListeners = new EventListenerList();
    private EventListenerList treeModelListeners = new EventListenerList();
    private Vector collapsedNodes = new Vector();
    private Vector selectedNodes = new Vector();
    private Vector flaggedNodes = new Vector();

    public JavaTreeModel() {
    }

    public JavaTreeModel(Object treeIn) {
        this.setDataSource(treeIn);
    }

    @Override
    public TreeNode getRoot() {
        if (this.model == null) {
            return null;
        }
        Object obj = this.model.getRoot();
        if (obj instanceof TreeNode) {
            return (TreeNode)obj;
        }
        return null;
    }

    private long countNodes(TreeNode node) {
        long rc = 1L;
        for (int i = 0; i < node.getChildCount(); ++i) {
            rc += this.countNodes(node.getChildAt(i));
        }
        return rc;
    }

    @Override
    public long numNodes() {
        if (this.model == null || !(this.model.getRoot() instanceof TreeNode)) {
            return 0L;
        }
        return this.countNodes((TreeNode)this.model.getRoot());
    }

    private TreeNode findNode(Object node, Object ID) {
        if (node == null) {
            return null;
        }
        if (node instanceof TreeNodeInterface) {
            TreeNodeInterface n = (TreeNodeInterface)node;
            if (n.getId().equals(ID)) {
                return n;
            }
        } else if (node instanceof TreeNode && node.toString().equals(ID)) {
            return (TreeNode)node;
        }
        int numChildren = this.model.getChildCount(node);
        for (int i = 0; i < numChildren; ++i) {
            Object child = this.model.getChild(node, i);
            TreeNode tn = this.findNode(child, ID);
            if (tn == null) continue;
            return tn;
        }
        return null;
    }

    @Override
    public TreeNode getNode(Object ID) {
        return this.findNode(this.model.getRoot(), ID);
    }

    @Override
    public Vector getChildren(Object ID) {
        TreeNode node = this.findNode(this.model.getRoot(), ID);
        if (node == null) {
            return null;
        }
        Vector<Object> v = new Vector<Object>();
        TreeNode treenode = null;
        if (node instanceof TreeNode) {
            treenode = node;
        }
        if (treenode == null) {
            return v;
        }
        for (int i = 0; i < this.model.getChildCount(treenode); ++i) {
            Object child = this.model.getChild(treenode, i);
            v.addElement(child);
        }
        return v;
    }

    private void retrieveLeaves(Object node, Vector v) {
        if (this.model.isLeaf(node)) {
            v.addElement(node);
            return;
        }
        for (int i = 0; i < this.model.getChildCount(node); ++i) {
            this.retrieveLeaves(this.model.getChild(node, i), v);
        }
    }

    @Override
    public Vector getLeaves() {
        Vector v = new Vector();
        this.retrieveLeaves(this.model.getRoot(), v);
        return v;
    }

    @Override
    public void setCollapsed(Object nodeID, boolean collapsed) {
        if (nodeID == null) {
            return;
        }
        if (collapsed && !this.collapsedNodes.contains(nodeID)) {
            this.collapsedNodes.addElement(nodeID);
        } else if (!collapsed) {
            this.collapsedNodes.remove(nodeID);
        }
        this.fireInteractionChange(new TreeModelEvent(this.COLLAPSED_ROLE.toString(), nodeID));
    }

    @Override
    public boolean isCollapsed(Object nodeID) {
        return this.collapsedNodes.contains(nodeID);
    }

    @Override
    public void recursiveSetCollapsed(Object nodeID, boolean collapsed) {
        Vector v = this.getChildren(nodeID);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof TreeNodeInterface)) continue;
            this.recursiveSetCollapsed(((TreeNodeInterface)obj).getId(), collapsed);
        }
        this.setCollapsed(nodeID, collapsed);
    }

    @Override
    public void setSelected(Object nodeID, int selected) {
        if (nodeID == null) {
            return;
        }
        if (selected > 0 && !this.selectedNodes.contains(nodeID)) {
            this.selectedNodes.addElement(nodeID);
        } else if (selected == 0) {
            this.selectedNodes.remove(nodeID);
        }
        this.fireInteractionChange(new TreeModelEvent(this.SELECTED_ROLE.toString(), nodeID));
    }

    @Override
    public boolean isSelected(Object nodeID) {
        return this.selectedNodes.contains(nodeID);
    }

    @Override
    public void setFlagged(Object nodeID, boolean flagged) {
        if (nodeID == null) {
            return;
        }
        if (flagged && !this.flaggedNodes.contains(nodeID)) {
            this.flaggedNodes.addElement(nodeID);
        } else if (!flagged) {
            this.flaggedNodes.remove(nodeID);
        }
        this.fireInteractionChange(new TreeModelEvent(this.FLAGGED_ROLE.toString(), nodeID));
    }

    @Override
    public boolean isFlagged(Object nodeID) {
        return this.flaggedNodes.contains(nodeID);
    }

    @Override
    public void addTreeModelListener(TreeModelListenerInterface l) {
        this.treeModelListeners.add(TreeModelListenerInterface.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListenerInterface l) {
        this.treeModelListeners.remove(TreeModelListenerInterface.class, l);
    }

    private void fireTreeDataChange(TreeModelEvent evt) {
        EventListener[] list = this.treeModelListeners.getListeners(TreeModelListenerInterface.class);
        for (int i = 0; i < list.length; ++i) {
            ((TreeModelListenerInterface)list[i]).treeDataChanged(evt);
        }
    }

    private void fireInteractionChange(TreeModelEvent evt) {
        EventListener[] list = this.treeModelListeners.getListeners(TreeModelListenerInterface.class);
        for (int i = 0; i < list.length; ++i) {
            ((TreeModelListenerInterface)list[i]).interactionChange(evt);
        }
    }

    @Override
    public boolean isListening() {
        return false;
    }

    @Override
    public void setListening(boolean b) {
    }

    @Override
    public double[] calculateGraphAxisExtents(int numBars, int numStacks) {
        return null;
    }

    @Override
    public boolean isDefined(int var) {
        return var == 26 || var == 27;
    }

    @Override
    public double[] getVariableMinMax(int id) {
        return null;
    }

    @Override
    public DataFilterReadInterface getFilter() {
        return null;
    }

    @Override
    public boolean setGraphData(Object obj) {
        return false;
    }

    @Override
    public DataFilterReadInterface getGraphFilter() {
        return null;
    }

    @Override
    public boolean hasGraphData() {
        return false;
    }

    public Object getAllVariables(Object role) {
        return null;
    }

    public Object getVariable(Object role) {
        return null;
    }

    public Object getRole(Object variableId) {
        return null;
    }

    public boolean setRole(Object variableId, Object role) {
        return false;
    }

    public boolean addRole(Object variableId, Object role) {
        return false;
    }

    public boolean removeRole(Object variableId, Object role) {
        return false;
    }

    public Object getRoleValue(Object role, int which) {
        return null;
    }

    public boolean isDiscrete(Object role) {
        return false;
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        return false;
    }

    public Object getSortOrder(Object role) {
        return null;
    }

    public boolean setSortOrder(Object role, Object order) {
        return false;
    }

    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return null;
    }

    public int getMaxAllowed(Object role) {
        return 0;
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource() {
        return this.model;
    }

    public Object getDataSource(Object id) {
        return this.getDataSource();
    }

    public boolean setDataSource(Object sourceIn) {
        if (sourceIn instanceof TreeModel) {
            this.model = (TreeModel)sourceIn;
        } else if (sourceIn instanceof TreeNode) {
            this.model = new DefaultTreeModel((TreeNode)sourceIn);
        } else {
            return false;
        }
        this.fireTreeDataChange(new TreeModelEvent());
        return true;
    }

    public boolean setDataSource(Object source, Object id) {
        return this.setDataSource(source);
    }

    public void addTreeExpansionListener(TreeExpansionListener listener) {
        this.treeExpandListeners.add(TreeExpansionListener.class, listener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener listener) {
        this.treeExpandListeners.remove(TreeExpansionListener.class, listener);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener listener) {
        this.treeWillExpandListeners.add(TreeWillExpandListener.class, listener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener listener) {
        this.treeWillExpandListeners.remove(TreeWillExpandListener.class, listener);
    }
}

