/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.constchart.layout;

import com.sas.graphics.silk.constchart.layout.AdjacencyInfo;
import com.sas.graphics.silk.constchart.layout.GraphComponentInterface;
import com.sas.graphics.util.nld.NLDRect;
import java.util.Vector;

public class GraphComponent
implements GraphComponentInterface {
    private int numberOfVertices = 0;
    private Vector[] adjacencyList = null;
    private int diameter = 0;
    private NLDRect bound = null;
    private int[] vertexList = null;

    public void setNumberOfVertices(int numberOfVertices) {
        this.numberOfVertices = numberOfVertices;
        this.adjacencyList = new Vector[this.numberOfVertices];
    }

    public void setAdjacencyList(int nodeIndex, Vector adjList) {
        if (nodeIndex >= 0 && nodeIndex <= this.numberOfVertices) {
            this.adjacencyList[nodeIndex] = adjList;
        }
    }

    public void setAdjacencyList(Vector[] adjList) {
        this.adjacencyList = adjList;
    }

    public Vector[] getAdjacencyList() {
        return this.adjacencyList;
    }

    @Override
    public int getNumberNodes() {
        return this.numberOfVertices;
    }

    @Override
    public int getDegree(int nodeIndex) {
        int degree = 0;
        if (this.adjacencyList != null && nodeIndex < this.adjacencyList.length && this.adjacencyList[nodeIndex] != null) {
            degree = this.adjacencyList[nodeIndex].size();
        }
        return degree;
    }

    @Override
    public int getAdjacentVertex(int nodeIndex, int i) {
        AdjacencyInfo info = this.getAdjacencyInfo(nodeIndex, i);
        if (info == null) {
            return -1;
        }
        return info.getNodeIndex();
    }

    @Override
    public double getLinkWeight(int nodeIndex, int i) {
        return 1.0;
    }

    private AdjacencyInfo getAdjacencyInfo(int nodeIndex, int i) {
        AdjacencyInfo info = null;
        if (this.adjacencyList != null && nodeIndex < this.adjacencyList.length && this.adjacencyList[nodeIndex] != null && i >= 0 && i < this.adjacencyList[nodeIndex].size()) {
            info = (AdjacencyInfo)this.adjacencyList[nodeIndex].elementAt(i);
        }
        return info;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Number of nodes = " + this.adjacencyList.length + "\n\n");
        for (int i = 0; i < this.adjacencyList.length; ++i) {
            sb.append("Node = " + i + " adjList = {");
            for (int j = 0; j < this.getDegree(i); ++j) {
                sb.append(this.getAdjacentVertex(i, j));
                if (j >= this.getDegree(i) - 1) continue;
                sb.append(", ");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    public int getDiameter() {
        return this.diameter;
    }

    public void setDiameter(int diameter) {
        this.diameter = diameter;
    }

    public void setVertexList(int[] vertexList) {
        this.vertexList = vertexList;
    }

    public int[] getVertexList() {
        return this.vertexList;
    }

    public void setBound(NLDRect bound) {
        this.bound = bound;
    }

    public NLDRect getBound() {
        return this.bound;
    }
}

