/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.DistributionElement;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.ImageListInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.ParallelAxisPropertyInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.interfaces.ViewportInterface;
import com.sas.graphics.silk.parallelaxis.AxisObject;
import com.sas.graphics.silk.ui.AxisPanel2;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.LegendPanel2;
import com.sas.graphics.silk.ui.ParallelAxisPanel;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxesHandler;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.Brush;
import com.sas.graphics.silk.util.ColorMapper;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.GraphBackground;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ParallelAxisDefaults;
import com.sas.graphics.silk.util.RangeModel;
import com.sas.graphics.silk.util.ReferenceRange;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.silk.util.ViewportWarningIcon;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.ExtendedJLabel;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.NumericFormat;
import com.sas.graphics.util.RangeSlider;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

public class ParallelAxisPlot
extends SILKComponent
implements PropertyInterface,
ParallelAxisPropertyInterface,
TextListenerInterface,
ViewportInterface,
ViewportListenerInterface,
UpdateInterface,
RedrawListener,
CellItemInterface,
DataRangeInterface {
    private static final long serialVersionUID = -476177056461044972L;
    private static final int AXIS_RANGE = 5;
    private static int UNIQUE_VALUE_LIMIT = 100;
    private static final int NONE = 0;
    private static final int MOVE = 1;
    private static final int RESIZE_L = 2;
    private static final int RESIZE_R = 3;
    private static final int RESIZE_T = 4;
    private static final int RESIZE_B = 5;
    private static final int RESIZE_TL = 6;
    private static final int RESIZE_TR = 7;
    private static final int RESIZE_BL = 8;
    private static final int RESIZE_BR = 9;
    private static final int MIN_SIZE = 4;
    private static final int HANDLE_SIZE = 6;
    public static final String ALL_AXES = "ALL_AXES";
    private ResourceBundle rb = null;
    private JPopupMenu menu = null;
    private AxisPanel2 axisPanel;
    private BufferedImage backBuffer = null;
    private Graphics currentGC;
    private AbstractAction tbarAction;
    private boolean addPanels = false;
    private SILKNumber axisRole;
    private SILKNumber colorRole;
    private Rectangle chartArea;
    private Rectangle plotArea = new Rectangle();
    private Insets innerMargin = new Insets(0, 0, 0, 0);
    private Insets outerMargin = new Insets(0, 0, 0, 0);
    private int axisSpacing = 50;
    private int currentAxisSpacing;
    private boolean fitToScreen = true;
    private int numDiscreteAxes = 0;
    private int numNumericAxes = 0;
    private GraphBackground wall = new GraphBackground();
    private LegendObjectJ2D legend;
    private ArrayList axes = new ArrayList();
    private Color lineColor = null;
    private ColorMapper colorMapper = null;
    private String rampName = "ThreeColorRamp";
    private double[] colorMinMax = null;
    private ArrayList colorUniqueValues = null;
    private boolean numericColor = true;
    private boolean[] selected = null;
    private boolean dataChanged = false;
    private boolean rebuildRequired = true;
    private boolean redrawBackBuffer = true;
    private static Cursor normalCursor = Cursor.getPredefinedCursor(0);
    private static Cursor moveCursorOpen = null;
    private static Cursor moveCursorClose = null;
    private static Cursor resizeLRCursor = Cursor.getPredefinedCursor(11);
    private static Cursor resizeUDCursor = Cursor.getPredefinedCursor(8);
    private Cursor cursor;
    private boolean mouseDown = false;
    private Point startPt;
    private Point currPt;
    private AxisObject draggingAxis = null;
    private JLabel draggingLabel = null;
    private Rectangle rubberband;
    private boolean mouseDragging;
    private Color brushColor = Color.black;
    private boolean brushMode = false;
    private int brushAction;
    private Rectangle resizeL;
    private Rectangle resizeR;
    private Rectangle resizeT;
    private Rectangle resizeB;
    private Rectangle resizeTL;
    private Rectangle resizeTR;
    private Rectangle resizeBL;
    private Rectangle resizeBR;
    private boolean mouseOnAxisLabel;
    private boolean endPointSelection = false;
    private ArrayList viewportListeners;
    private Axes zoomPanAxis = null;
    private AxisZoomPanHandler zoomPanHandler = null;
    private AxisZoomPanHandler activeHandler = null;
    private boolean panning = false;
    private boolean hScrollbarOn = true;
    private boolean vScrollbarOn = true;
    private double dataXMin = 0.0;
    private double dataXMax = 1.0;
    private double dataYMin = 0.0;
    private double dataYMax = 1.0;
    private double viewportXMin;
    private double viewportXMax;
    private double viewportYMin;
    private double viewportYMax;
    private boolean equalizeAxes = false;
    private boolean skipMissingValues = false;
    private int orientation = 1;
    private int lineWidth = 1;
    private double lineOpacity = 1.0;
    private double axisLabelPercentage = 0.25;
    private double maxAxisLabelPercentage;
    private AxesHandler axesHandler;
    private double MIN;
    private double MAX;
    public static final int LINE = 0;
    public static final int DISTRIBUTION = 1;
    private int plotType = 0;
    private int tickValueOffset;
    private int rangeSliderThumbSize = 8;
    private int rangeSliderTrackBuffer = (this.rangeSliderThumbSize + 1) / 2;
    public static int[] supportedProperties = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 0, 29, 30, 28, 2, 34, 601, 602, 603, 23, 443, 402, 801, 807, 802, 803, 806};
    protected ViewportWarningIcon warningIcon = null;
    private Vector rangeChangeListeners = null;

    public ParallelAxisPlot(Object dataIn) {
        this();
        this.setDataSource(dataIn);
    }

    public ParallelAxisPlot() {
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.parallelaxis.parallelaxis_NLS");
        this.axisRole = this.roleIndex.getRoleObject("ROLE_AXIS");
        this.roles.newRole((Object)this.axisRole, (Object)"AXIS", 99);
        this.colorRole = this.roleIndex.getRoleObject("ROLE_COLOR");
        this.roles.newRole((Object)this.colorRole, (Object)"COLOR", 1);
        this.cursor = normalCursor;
        if (moveCursorOpen == null) {
            moveCursorOpen = this.getCustomCursor(6, 2, "icons/MoveOpen.gif");
        }
        if (moveCursorClose == null) {
            moveCursorClose = this.getCustomCursor(6, 2, "icons/MoveClosed.gif");
        }
        this.viewportListeners = new ArrayList();
        this.zoomPanAxis = new Axes();
        this.zoomPanAxis.setDirection(this.orientation == 0);
        this.zoomPanHandler = new AxisZoomPanHandler(this.zoomPanAxis);
        this.zoomPanHandler.setDataRange(0.0, 1.0);
        this.zoomPanHandler.addViewportListener((Object)this);
        this.addViewportListener(this.zoomPanHandler);
        this.zoomPanAxis.setPrimary(false);
        this.zoomPanHandler.setPrimaryZoomPanArea(true);
        this.setStyle(SILKGlobal.getInstance().getPropertyValue(29));
        this.actionMode = 6;
        this.axesHandler = new AxesHandler((Component)((Object)this));
        ((Axes)this.axesHandler.getAxisInterface()).addRedrawListener((RedrawListener)this);
        ParallelAxisDefaults PAdefaults = new ParallelAxisDefaults();
        if (PAdefaults.uniqueValueLimit > 0) {
            UNIQUE_VALUE_LIMIT = PAdefaults.uniqueValueLimit;
        }
        this.userSetProperties.appendProperties(supportedProperties);
        this.warningIcon = new ViewportWarningIcon((Component)((Object)this));
    }

    public boolean createDataDialog(Object listener) {
        boolean rc = super.createDataDialog(listener);
        return rc;
    }

    public boolean createPropertyDialog(Object listener) {
        if (this.addPanels) {
            return true;
        }
        super.createPropertyDialog(listener);
        this.propertiesDialog.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ParallelAxisPlot.ParallelAxis_Properties.txt", (String)"Parallel Axis Properties"));
        this.addRootNode(this.propertiesDialog, "Graph", ResourceLoader.getResourceString((Object)this.rb, (String)"ParallelAxisPlot.Graph.txt", (String)"Graph"), (Component)new GraphPanel((PropertyInterface)this, (PropertyInterface)this.tooltip));
        this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"ParallelAxisPlot.ParallelAxis.txt", (String)"Parallel Axis"), (Component)new ParallelAxisPanel(this));
        this.axisPanel = new AxisPanel2();
        this.axisPanel.addPropertyListener((PropertyInterface)this);
        this.addRootNode(this.propertiesDialog, "Axis", ResourceLoader.getResourceString((Object)this.rb, (String)"ParallelAxisPlot.Axes.txt", (String)"Axes"), (Component)this.axisPanel);
        LegendPanel2 legPanel = new LegendPanel2();
        legPanel.addPropertyListener((PropertyInterface)this);
        this.addRootNode(this.propertiesDialog, "Legend", ResourceLoader.getResourceString((Object)this.rb, (String)"ParallelAxisPlot.Legend.txt", (String)"Legend"), (Component)legPanel);
        this.addRootNode(this.propertiesDialog, "Title", ResourceLoader.getResourceString((Object)this.rb, (String)"ParallelAxisPlot.TitleFootnote.txt", (String)"Title/Footnote"), (Component)new TitlePanel((PropertyInterface)this, (JComponent)((Object)this)));
        this.propertiesDialog.setSelectedNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"ParallelAxisPlot.ParallelAxis.txt", (String)"Parallel Axis"));
        this.addPanels = true;
        this.propertiesDialog.updateLegendPanels((PropertyInterface)this, (Object)this);
        return true;
    }

    private void addRootNode(GraphPropertiesDialog propertiesDialog, String name, String displayName, Component panel) {
        GraphPropertiesDialog.PropertiesTreeNode ptn = propertiesDialog.addRootNode((Object)name, panel);
        ptn.setDisplayName(displayName);
    }

    private void createPopupMenu() {
        this.menu = MenuUtilities.getPopupMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/ParallelAxisPlotMenu.xml"), (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                ParallelAxisPlot.this.handleMenuCommand(actionCommand);
            }
        });
        if (this.getOrientation() == 0) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.menu, (String)"CHART_TYPE_HORIZONTAL", (boolean)true);
        } else {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.menu, (String)"CHART_TYPE_VERTICAL", (boolean)true);
        }
    }

    protected void handleMenuCommand(String command) {
        if ("CHART_TYPE_HORIZONTAL".equalsIgnoreCase(command)) {
            this.setOrientation(0);
        } else if ("CHART_TYPE_VERTICAL".equalsIgnoreCase(command)) {
            this.setOrientation(1);
        } else {
            super.handleMenuCommand(command);
        }
    }

    public void paint(Graphics g) {
        if (this.axes.size() <= 1) {
            this.drawErrorMessage((Graphics2D)g);
            return;
        }
        super.paint(g);
        this.warningIcon.draw(g);
    }

    public void paintComponent(Graphics g) {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        this.currentGC = g;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.dataChanged || this.isRebuildRequired()) {
            this.build(null);
            this.redrawBackBuffer = true;
        }
        if (this.isUsingBackBuffer()) {
            if (this.redrawBackBuffer) {
                this.buildBackBuffer();
            }
            g.drawImage(this.backBuffer, 0, 0, null);
        } else {
            this.drawChart(g2);
        }
        this.drawSelections(g2);
        if (this.plotType == 1) {
            this.drawRangeSliderRanges(g);
        }
        if (this.rubberband != null && (this.brushMode || this.mouseDragging)) {
            g.setColor(this.brushColor);
            g.drawRect(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
        }
        if (this.draggingAxis != null) {
            this.drawDraggedAxis(g2);
        }
        this.drawViewportIndicator(g);
    }

    protected void drawViewportIndicator(Graphics g) {
        if (this.axes == null) {
            return;
        }
        for (int i = 0; i < this.axes.size(); ++i) {
            AxisObject ao = (AxisObject)this.axes.get(i);
            ao.getZoomPanHandler().drawViewportIndicator(g);
        }
    }

    private void buildBackBuffer() {
        if (this.compWidth <= 0 || this.compHeight <= 0 || !this.isUsingBackBuffer()) {
            return;
        }
        if (this.backBuffer == null) {
            this.backBuffer = new BufferedImage(this.compWidth, this.compHeight, 1);
        }
        Graphics2D g = (Graphics2D)this.backBuffer.getGraphics();
        this.drawChart(g);
        this.redrawBackBuffer = false;
    }

    private void drawChart(Graphics2D g) {
        Rectangle rectangle = new Rectangle(0, 0, this.compWidth, this.compHeight);
        this.background.drawBackground(g, (Component)((Object)this), rectangle);
        this.wall.drawBackground(g, (Component)((Object)this), this.chartArea);
        Rectangle oldClip = g.getClipBounds();
        double[] minMax = this.getViewportMinMax();
        g.setClip(this.chartArea.x, this.chartArea.y, this.chartArea.width, this.chartArea.height);
        boolean labelsOn = this.areAxesLabelsOn();
        for (int i = 0; i < this.axes.size(); ++i) {
            if ((double)i < Math.floor(minMax[0]) || (double)i > Math.ceil(minMax[1])) continue;
            AxisObject ao = (AxisObject)this.axes.get(i);
            if (labelsOn) {
                ao.getAxis().setLabel((Object)Boolean.FALSE);
            }
            ao.draw(g, false);
            if (!labelsOn) continue;
            ao.getAxis().setLabel((Object)Boolean.TRUE);
        }
        int halfWidth = (int)Math.ceil(0.5 * (double)this.lineWidth);
        if (this.orientation == 0) {
            g.setClip(this.chartArea.x, this.plotArea.y - halfWidth, this.chartArea.width, this.plotArea.height + halfWidth * 2);
        } else {
            g.setClip(this.plotArea.x - halfWidth, this.chartArea.y, this.plotArea.width + halfWidth * 2, this.chartArea.height);
        }
        if (this.plotType == 0) {
            this.drawLines(g);
        } else {
            this.drawDistributionPlots(g);
        }
        if (this.areAxesVisible() && labelsOn) {
            this.drawJLabels();
        }
        g.setClip(oldClip);
        this.graphLayout.draw((Graphics)g);
    }

    private void drawSelections(Graphics2D g) {
        Rectangle oldClip = g.getClipBounds();
        int halfWidth = (int)Math.ceil(0.5 * (double)this.lineWidth);
        if (this.orientation == 0) {
            g.setClip(this.chartArea.x, this.plotArea.y - halfWidth, this.chartArea.width, this.plotArea.height + halfWidth * 2);
        } else {
            g.setClip(this.plotArea.x - halfWidth, this.chartArea.y, this.plotArea.width + halfWidth * 2, this.chartArea.height);
        }
        if (this.plotType == 1) {
            this.brushDistributionPlots(g);
            g.setClip(oldClip);
            return;
        }
        double[] minMax = this.getViewportMinMax();
        int numAxes = (int)(Math.ceil(minMax[1]) - Math.floor(minMax[0]) + 1.0);
        int[] xPoints = new int[numAxes];
        int[] yPoints = new int[numAxes];
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(this.lineWidth));
        g.setColor(this.style.getLineStyleElement("Selection").getLineColor());
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i] || !this.dataFilter.isSelected((long)i)) continue;
            int idx = 0;
            Vector<Integer> missingIndices = new Vector<Integer>();
            for (int j = 0; j < this.axes.size(); ++j) {
                if ((double)j < Math.floor(minMax[0]) || (double)j > Math.ceil(minMax[1])) continue;
                AxisObject axis = (AxisObject)this.axes.get(j);
                Object value = this.dataFilter.getValue(axis.getVariable(), (long)i);
                if (axis.isDiscrete()) {
                    value = this.dataFilter.getFormattedValue(axis.getVariable(), value, null);
                }
                if (this.isMissing(axis.getVariable(), value)) {
                    if (!this.skipMissingValues) continue;
                    missingIndices.add(new Integer(idx));
                } else {
                    Point pt = axis.project(value);
                    xPoints[idx] = pt.x;
                    yPoints[idx] = pt.y;
                }
                ++idx;
            }
            if (this.skipMissingValues) {
                boolean[] pointConnectedStatus = new boolean[idx];
                int l = 0;
                while (l < idx) {
                    pointConnectedStatus[l++] = false;
                }
                for (int k = 0; k < idx; ++k) {
                    Stroke origStroke;
                    if (this.isValuePresent(k, missingIndices)) continue;
                    if (!this.isValuePresent(k + 1, missingIndices)) {
                        if (k + 1 < idx) {
                            g.drawLine(xPoints[k], yPoints[k], xPoints[k + 1], yPoints[k + 1]);
                            pointConnectedStatus[k] = true;
                            pointConnectedStatus[k + 1] = true;
                            continue;
                        }
                        if (k + 1 != idx || pointConnectedStatus[k]) continue;
                        origStroke = g.getStroke();
                        g.setStroke(new BasicStroke(1.0f));
                        g.fillRect(xPoints[k] - 2, yPoints[k] - 2, 4, 4);
                        g.setStroke(origStroke);
                        continue;
                    }
                    if (pointConnectedStatus[k]) continue;
                    origStroke = g.getStroke();
                    g.setStroke(new BasicStroke(1.0f));
                    g.fillRect(xPoints[k] - 2, yPoints[k] - 2, 4, 4);
                    g.setStroke(origStroke);
                }
                continue;
            }
            g.drawPolyline(xPoints, yPoints, idx);
        }
        g.setStroke(oldStroke);
        g.setClip(oldClip);
    }

    private void drawLines(Graphics2D g) {
        Object colorVar;
        double[] minMax = this.getViewportMinMax();
        int numAxes = (int)(Math.ceil(minMax[1]) - Math.floor(minMax[0]) + 1.0);
        int[] xPoints = new int[numAxes];
        int[] yPoints = new int[numAxes];
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(this.lineWidth));
        Composite oldComp = g.getComposite();
        if (this.lineOpacity < 1.0) {
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, (float)this.lineOpacity);
            g.setComposite(alphaComp);
        }
        if (!this.dataFilter.verifyVariable(colorVar = this.roles.getVariable((Object)this.colorRole, 0))) {
            colorVar = null;
        }
        Object[] colorValues = colorVar != null && this.dataFilter instanceof DataFilterInfoInterface ? ((DataFilterInfoInterface)this.dataFilter).getUniqueValues(colorVar, false) : null;
        for (int i = 0; i < this.dataFilter.getNumberObservations(-1); ++i) {
            if (!this.dataFilter.isGraphed((long)i)) continue;
            if (colorVar != null) {
                Object val = this.dataFilter.getValue(colorVar, (long)i);
                if (this.numericColor && this.colorMinMax != null && val != null && val instanceof Number) {
                    double d = ((Number)val).doubleValue();
                    Color c = this.colorMapper.getColor(d);
                    g.setColor(c);
                } else if (!this.numericColor && this.colorUniqueValues != null && val != null) {
                    val = this.dataFilter.getFormattedValue(colorVar, val, this.dataFilter.getFormat(colorVar, SASFormat.class));
                    int idx = colorValues != null ? this.getColorIndex(val, colorValues) : this.colorUniqueValues.indexOf(val);
                    String s = null;
                    if (val != null) {
                        s = val.toString();
                    }
                    Color c = SILKUtilities.getStyleElement((String)s, (int)idx, (int)2, (Style)this.style, (String)"GraphDataStyleDefault", null).getAsDataStyle().getLineColor();
                    g.setColor(c);
                } else {
                    g.setColor(this.lineColor);
                }
            } else {
                Color c = this.dataFilter.getObservationColor((long)i);
                if (c != null) {
                    g.setColor(c);
                } else {
                    g.setColor(this.lineColor);
                }
            }
            int idx = 0;
            Vector<Integer> missingIndices = new Vector<Integer>();
            for (int j = 0; j < this.axes.size(); ++j) {
                if ((double)j < Math.floor(minMax[0]) || (double)j > Math.ceil(minMax[1])) continue;
                AxisObject axis = (AxisObject)this.axes.get(j);
                Object value = this.dataFilter.getValue(axis.getVariable(), (long)i);
                if (axis.isDiscrete()) {
                    value = this.dataFilter.getFormattedValue(axis.getVariable(), value, null);
                }
                if (this.isMissing(axis.getVariable(), value)) {
                    if (!this.skipMissingValues) continue;
                    missingIndices.add(new Integer(idx));
                } else {
                    Point pt = axis.project(value);
                    xPoints[idx] = pt.x;
                    yPoints[idx] = pt.y;
                }
                ++idx;
            }
            if (this.skipMissingValues) {
                boolean[] pointConnectedStatus = new boolean[idx];
                int l = 0;
                while (l < idx) {
                    pointConnectedStatus[l++] = false;
                }
                for (int k = 0; k < idx; ++k) {
                    Stroke origStroke;
                    if (this.isValuePresent(k, missingIndices)) continue;
                    if (!this.isValuePresent(k + 1, missingIndices)) {
                        if (k + 1 < idx) {
                            g.drawLine(xPoints[k], yPoints[k], xPoints[k + 1], yPoints[k + 1]);
                            pointConnectedStatus[k] = true;
                            pointConnectedStatus[k + 1] = true;
                            continue;
                        }
                        if (k + 1 != idx || pointConnectedStatus[k]) continue;
                        origStroke = g.getStroke();
                        g.setStroke(new BasicStroke(1.0f));
                        g.drawRect(xPoints[k] - 2, yPoints[k] - 2, 4, 4);
                        g.setStroke(origStroke);
                        continue;
                    }
                    if (pointConnectedStatus[k]) continue;
                    origStroke = g.getStroke();
                    g.setStroke(new BasicStroke(1.0f));
                    g.drawRect(xPoints[k] - 2, yPoints[k] - 2, 4, 4);
                    g.setStroke(origStroke);
                }
                continue;
            }
            g.drawPolyline(xPoints, yPoints, idx);
        }
        g.setStroke(oldStroke);
        g.setComposite(oldComp);
    }

    private boolean isValuePresent(int value, Vector container) {
        for (int i = 0; i < container.size(); ++i) {
            int missingIdx = (Integer)container.get(i);
            if (value != missingIdx) continue;
            return true;
        }
        return false;
    }

    private void drawJLabels() {
        if (this.orientation == 0) {
            if (this.outerMargin.bottom == 0) {
                return;
            }
            for (int i = 0; i < this.axes.size(); ++i) {
                AxisObject ao = (AxisObject)this.axes.get(i);
                int xo = this.project(i);
                if (xo < this.chartArea.x || xo > this.chartArea.x + this.chartArea.width) {
                    ao.getLabel().setVisible(false);
                    continue;
                }
                ao.getLabel().setBounds((int)((double)xo - (double)ao.getLabel().getPreferredSize().width * 0.5), this.chartArea.y + this.chartArea.height + this.silkDefaults.componentXMargin, ao.getLabel().getPreferredSize().width, this.outerMargin.bottom - this.silkDefaults.componentXMargin);
            }
        } else {
            if (this.outerMargin.left == 0) {
                return;
            }
            for (int i = 0; i < this.axes.size(); ++i) {
                AxisObject ao = (AxisObject)this.axes.get(i);
                int yo = this.project(i);
                if (this.plotType == 1) {
                    yo += ao.getScreenArea().height;
                }
                if (yo < this.chartArea.y || yo > this.chartArea.y + this.chartArea.height) {
                    ao.getLabel().setVisible(false);
                    continue;
                }
                ao.getLabel().setBounds(this.chartArea.x - this.outerMargin.left, (int)((double)yo - (double)ao.getLabel().getPreferredSize().height * 0.5), this.outerMargin.left - this.silkDefaults.componentXMargin, ao.getLabel().getPreferredSize().height);
            }
        }
    }

    private void drawDraggedAxis(Graphics2D g) {
        Stroke oldStroke = g.getStroke();
        BasicStroke dashStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{8.0f, 8.0f}, 0.0f);
        g.setStroke(dashStroke);
        g.setColor(Color.gray);
        int x = this.chartArea.x;
        int y = this.chartArea.y;
        if (this.orientation == 0) {
            x = Math.min(Math.max(this.chartArea.x, this.currPt.x), this.chartArea.x + this.chartArea.width);
            g.drawLine(x, this.plotArea.y, x, this.plotArea.y + this.plotArea.height - 1);
            if (this.areAxesVisible() && this.areAxesLabelsOn() && this.outerMargin.bottom > 0) {
                Rectangle bounds = this.draggingAxis.getLabel().getBounds();
                this.draggingLabel.setBounds(x - (int)((double)bounds.width * 0.5), bounds.y, bounds.width, bounds.height);
            }
        } else {
            y = Math.min(Math.max(this.chartArea.y, this.currPt.y), this.chartArea.y + this.chartArea.height);
            g.drawLine(this.plotArea.x, y, this.plotArea.x + this.plotArea.width - 1, y);
            if (this.areAxesVisible() && this.areAxesLabelsOn() && this.outerMargin.left > 0) {
                Rectangle bounds = this.draggingAxis.getLabel().getBounds();
                this.draggingLabel.setBounds(bounds.x, y - (int)((double)bounds.height * 0.5), bounds.width, bounds.height);
            }
        }
        g.setStroke(oldStroke);
    }

    private void drawErrorMessage(Graphics2D g) {
        g.setColor(Color.red);
        String msg = ResourceLoader.getResourceString((Object)this.rb, (String)"ParallelAxisPlot.DataNotAssigned.txt", (String)"At least two axes are required.");
        g.drawString(msg, 0, 20);
    }

    private boolean areAxesLabelsOn() {
        return this.getAxis(ALL_AXES).getLabel().isVisible();
    }

    private boolean areAxesVisible() {
        return ((AxesHandler)this.getAxis(ALL_AXES)).isVisible();
    }

    private Object[] getSelectedData(MouseEvent me) {
        AxisObject ao = this.axisAtPoint(me.getX(), me.getY());
        if (ao == null) {
            return null;
        }
        Object value = ao.unProject(me.getX(), me.getY());
        if (value == null) {
            return null;
        }
        return new Object[]{ao, value};
    }

    public String getToolTipText(MouseEvent me) {
        if (!this.tipsOn) {
            return null;
        }
        if (this.warningIcon.isMouseOverIcon(me.getX(), me.getY())) {
            return this.warningIcon.getTooltipText();
        }
        Object[] data = this.getSelectedData(me);
        if (data == null) {
            return null;
        }
        AxisObject ao = (AxisObject)data[0];
        Object value = data[1];
        if (ao.getFormat() != null) {
            value = ao.getFormat().format(value);
        }
        String varDescr = this.dataFilter.getVariableDescription(ao.getVariable()).toString();
        Message message = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"ParallelAxisPlot.Probe.fmt.txt", (String)"{0} = {1}"));
        String rc = message.toString((Object)varDescr, value);
        return rc;
    }

    public void addViewportListener(Object listener) {
        if (listener == null || !(listener instanceof ViewportListenerInterface)) {
            return;
        }
        if (!this.viewportListeners.contains(listener)) {
            this.viewportListeners.add(listener);
        }
    }

    public void removeViewportListener(Object listener) {
        if (listener == null || !(listener instanceof ViewportListenerInterface)) {
            return;
        }
        if (this.viewportListeners.contains(listener)) {
            this.viewportListeners.remove(listener);
        }
    }

    public int getActionMode() {
        return 6;
    }

    public boolean setActionMode(int mode) {
        if (mode == 5) {
            this.resetViewport();
        } else {
            super.setActionMode(mode);
        }
        if (mode != 1 && this.brushMode) {
            this.brushMode = false;
            this.repaint();
        }
        return true;
    }

    public boolean setStyle(Object newStyle) {
        if (newStyle == null) {
            return false;
        }
        if (newStyle.equals(this.style)) {
            return true;
        }
        super.setStyle(newStyle);
        this.lineColor = this.style.getDataStyleElement("GraphDataStyleDefault").getLineColor();
        this.wall.setSolidBackground((Object)this.style.getFillStyleElement("WallFill").getFillColor());
        this.zoomPanHandler.setStyle(this.style);
        this.initColorRamp();
        for (int i = 0; i < this.axes.size(); ++i) {
            ((AxisObject)this.axes.get(i)).setStyle(this.style);
        }
        if (this.legend != null) {
            this.setColorsToLegend();
            this.setupLegend();
        }
        this.redrawBackBuffer = true;
        this.repaint();
        return true;
    }

    private void initColorRamp() {
        if (this.colorMapper != null) {
            this.colorMapper.unRegister((CellItemInterface)this);
        }
        this.colorMapper = ColorMapper.getInstance((String)this.rampName);
        if (this.colorMapper != null) {
            this.colorMapper.register((CellItemInterface)this);
        }
    }

    private void setColorsToLegend() {
        if (this.legend == null) {
            return;
        }
        this.legend.applyStyle(this.style);
    }

    public void dispose() {
        super.dispose();
        if (this.colorMapper != null) {
            this.colorMapper.unRegister((CellItemInterface)this);
        }
        if (this.rangeChangeListeners != null) {
            this.rangeChangeListeners.removeAllElements();
        }
        this.rangeChangeListeners = null;
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.axisPanel != null) {
            this.axisPanel.removePropertyListener((PropertyInterface)this);
            this.axisPanel = null;
        }
        this.dataDlg = null;
        this.menu = null;
        if (this.graphLayout != null && this.graphLayout.getTitle() != null) {
            this.graphLayout.getTitle().removeTextListener((TextListenerInterface)this);
        }
        if (this.graphLayout == null || this.graphLayout.getFootnote() != null) {
            // empty if block
        }
        this.graphLayout.getFootnote().removeTextListener((TextListenerInterface)this);
        if (this.toolBar != null) {
            this.toolBar.setVisible(false);
        }
        this.toolBar = null;
        this.removeMouseListener((MouseListener)((Object)this));
        this.removeMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.createPopupMenu();
        }
        return this.menu;
    }

    public Component getToolBar() {
        super.getToolBar();
        if (this.toolBar != null && this.toolBar instanceof SILKToolbar) {
            ((SILKToolbar)this.toolBar).setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ParallelAxisPlot.ParallelAxis_Toolbar.txt", (String)"Parallel Axis Toolbar"));
        }
        return this.toolBar;
    }

    public boolean setToolBar(Component toolBarIn) {
        boolean nobar = this.noToolBar;
        super.setToolBar(toolBarIn);
        if (this.menu != null) {
            if (this.toolBar != null && nobar) {
                this.menu.insert(this.tbarAction, 1);
            } else if (this.toolBar == null && !nobar) {
                this.menu.remove(1);
            }
        }
        return true;
    }

    public AxisInterface getAxis(Object which) {
        if (which != null && ALL_AXES.equalsIgnoreCase(which.toString())) {
            return this.axesHandler;
        }
        return null;
    }

    public LegendInterface getLegend(Object which) {
        return this.legend != null && (this.colorMinMax != null || this.colorUniqueValues != null) ? this.legend : null;
    }

    public Object getLegendPosition(Object which) {
        return this.legend == null ? null : this.legend.getPropertyValue(443);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setLegendPosition(Object which, Object pos) {
        if (this.legend == null) {
            return true;
        }
        int position = -1;
        if (pos instanceof String) {
            if (((String)pos).equalsIgnoreCase("South")) {
                position = 2;
            } else if (((String)pos).equalsIgnoreCase("North")) {
                position = 1;
            } else if (((String)pos).equalsIgnoreCase("East")) {
                position = 3;
            } else if (((String)pos).equalsIgnoreCase("West")) {
                position = 4;
            } else {
                if (!((String)pos).equalsIgnoreCase("Custom")) return false;
                position = 5;
            }
        } else if (pos instanceof Number) {
            position = ((Number)pos).intValue();
            switch (position) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.legend.getPosition() == position) return true;
        this.legend.setPosition(position);
        this.rebuildRequired = true;
        this.repaint();
        return true;
    }

    public boolean setDataSource(Object source) {
        super.setDataSource(source);
        this.dataChanged = true;
        if (this.dataFilter == null) {
            this.selected = null;
        } else {
            this.selected = new boolean[this.dataFilter.getNumberObservations(-1)];
            for (int i = 0; i < this.dataFilter.getNumberObservations(-1); ++i) {
                this.selected[i] = this.dataFilter.isSelected((long)i);
            }
        }
        return true;
    }

    public boolean requiresMultipleRoleAssignments() {
        return true;
    }

    public void roleChanged(RoleEvent re) {
        if (this.getDataSource() == null) {
            return;
        }
        if (re.role == 53 && (re.type == 2 || re.type == 1)) {
            Object obj = this.roles.getVariable((Object)this.axisRole);
            Enumeration e = Extract.elements((Object)obj);
            while (e.hasMoreElements()) {
                boolean discrete;
                AxisObject ao;
                Object var = e.nextElement();
                if (!this.dataFilter.verifyVariable(var) || this.dataFilter.getNumberObservations(var) < 1) {
                    this.roles.removeRole(var, (Object)this.axisRole);
                    continue;
                }
                if (this.haveAxisForVar(var) || !this.updateAxisMinMax(ao = new AxisObject(var, discrete = !this.dataFilter.isNumericVariable(var)))) continue;
                ao.setDescription((String)this.dataFilter.getVariableDescription(var));
                ao.create(null);
                ao.setStyle(this.style);
                ao.addViewportListener(this);
                this.addViewportListener(ao.getZoomPanHandler());
                this.warningIcon.addZoomPanHandler(ao.getZoomPanHandler());
                this.axes.add(ao);
                this.axesHandler.add(ao.getAxis());
                this.add(ao.getLabel());
            }
        } else if (re.role == 53 && re.type == 3) {
            ArrayList v = new ArrayList();
            this.axesHandler.removeAll();
            for (int i = 0; i < this.axes.size(); ++i) {
                this.remove(((AxisObject)this.axes.get(i)).getLabel());
            }
            Enumeration e = Extract.elements((Object)this.roles.getVariable((Object)this.axisRole));
            while (e.hasMoreElements()) {
                Object variable = e.nextElement();
                for (int i = 0; i < this.axes.size(); ++i) {
                    if (!variable.equals(((AxisObject)this.axes.get(i)).getVariable())) continue;
                    v.add(this.axes.get(i));
                    this.axesHandler.add(((AxisObject)this.axes.get(i)).getAxis(), false);
                    this.add(((AxisObject)this.axes.get(i)).getLabel());
                }
            }
            this.axes = v;
        } else if (re.role == 2) {
            if (re.type == 3) {
                this.colorMinMax = null;
                this.colorUniqueValues = null;
                if (this.legend != null) {
                    this.graphLayout.removeLegend((LegendInterface)this.legend);
                }
                if (this.colorMapper != null) {
                    this.colorMapper.unRegister((CellItemInterface)this);
                }
                this.currentLegend = null;
            } else {
                Object var = this.roles.getVariable((Object)this.colorRole, 0);
                if (!this.dataFilter.verifyVariable(var) || this.dataFilter.getNumberObservations(var) < 1) {
                    this.roles.removeRole(var, (Object)this.colorRole);
                    return;
                }
                boolean bl = this.numericColor = this.dataFilter.isNumericVariable(var) && !this.isDiscrete(this.colorRole);
                if (this.getLegend(null) != null) {
                    this.graphLayout.removeLegend((LegendInterface)this.legend);
                }
                if (this.legend == null) {
                    this.legend = new LegendObjectJ2D();
                    this.legend.setPosition(2);
                    this.setColorsToLegend();
                    this.legend.setVisible(true);
                    if (!this.numericColor) {
                        this.addMouseListener((MouseListener)this.legend);
                        this.addMouseMotionListener((MouseMotionListener)this.legend);
                    } else {
                        this.removeMouseListener((MouseListener)this.legend);
                        this.removeMouseMotionListener((MouseMotionListener)this.legend);
                    }
                }
                if (!this.updateColorVariable(var)) {
                    return;
                }
                this.graphLayout.addLegend((LegendInterface)this.legend);
                this.currentLegend = this.colorRole;
            }
            if (this.propertiesDialog != null) {
                this.propertiesDialog.updateLegendPanels((PropertyInterface)this, (Object)this);
            }
        }
        this.dataChanged = true;
        this.repaint();
    }

    private boolean haveAxisForVar(Object var) {
        if (var == null) {
            return false;
        }
        for (int i = 0; i < this.axes.size(); ++i) {
            if (!var.equals(((AxisObject)this.axes.get(i)).getVariable())) continue;
            return true;
        }
        return false;
    }

    private double[] getMinMax(Object var) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        if (this.dataFilter instanceof DataFilterInfoInterface) {
            Object obj = ((DataFilterInfoInterface)this.dataFilter).getMaximumValue(var);
            if (obj instanceof Number) {
                max = ((Number)obj).doubleValue();
                if (Double.isInfinite(max)) {
                    max = 1.0;
                }
            } else {
                max = 1.0;
            }
            if ((obj = ((DataFilterInfoInterface)this.dataFilter).getMinimumValue(var)) instanceof Number) {
                min = ((Number)obj).doubleValue();
                if (Double.isInfinite(min)) {
                    min = 0.0;
                }
            } else {
                min = 0.0;
            }
        } else {
            for (int i = 0; i < this.dataFilter.getNumberObservations(var); ++i) {
                double d;
                Object val = this.dataFilter.getValue(var, (long)i);
                if (this.isMissing(var, val) || !(val instanceof Number) || Double.isNaN(d = ((Number)val).doubleValue())) continue;
                if (d > max) {
                    max = d;
                }
                if (!(d < min)) continue;
                min = d;
            }
            if (min == Double.MAX_VALUE && max == Double.MIN_VALUE) {
                min = 0.0;
                max = 1.0;
            }
        }
        return new double[]{min, max};
    }

    private boolean updateAxisMinMax(AxisObject ao) {
        if (ao == null) {
            return false;
        }
        if (ao.isDiscrete()) {
            ArrayList list = this.getUniqueValues(ao.getVariable());
            if (list == null) {
                this.roles.removeRole(ao.getVariable(), (Object)this.axisRole);
                return false;
            }
            ao.setValues(list);
        } else {
            double[] vals = this.getMinMax(ao.getVariable());
            ao.setMin(vals[0]);
            ao.setMax(vals[1]);
        }
        return true;
    }

    private ArrayList getUniqueValues(Object var) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.dataFilter instanceof DataFilterInfoInterface) {
            Object[] uniqueVals = ((DataFilterInfoInterface)this.dataFilter).getUniqueValues(var, true, UNIQUE_VALUE_LIMIT);
            if (uniqueVals == null) {
                Message message = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"ParallelAxisPlot.TooManyUniqueValues.fmt.txt", (String)"Variable({0}) has too many unique values, rejected."));
                System.out.println(message.toString(var));
                return null;
            }
            for (int i = 0; i < uniqueVals.length; ++i) {
                list.add(uniqueVals[i]);
            }
        } else {
            for (int i = 0; i < this.dataFilter.getNumberObservations(var); ++i) {
                Object val = this.dataFilter.getValue(var, (long)i);
                if (list.contains(val)) continue;
                list.add(val);
            }
        }
        return list;
    }

    private void unionOfUniqueValues(ArrayList list1, ArrayList list2) {
        if (list1.size() < 1) {
            for (int i = 0; i < list2.size(); ++i) {
                list1.add(list2.get(i));
            }
        } else {
            for (int i = 0; i < list2.size(); ++i) {
                if (list1.contains(list2.get(i))) continue;
                list1.add(list2.get(i));
            }
        }
    }

    private boolean isMissing(Object var, Object value) {
        if (this.dataFilter.isNumericVariable(var)) {
            return this.dataFilter.isMissing(var, value);
        }
        return false;
    }

    private void setupLegend() {
        if (this.numericColor) {
            this.setupContinuousLegend();
        } else {
            this.setupDiscreteLegend();
        }
    }

    private void setupContinuousLegend() {
        if (this.legend == null || this.colorMinMax == null) {
            return;
        }
        if (this.colorMapper == null) {
            this.initColorRamp();
        } else {
            this.colorMapper.register((CellItemInterface)this);
        }
        Vector<Double> legendValues = new Vector<Double>(3);
        Vector<Color> legendColors = new Vector<Color>(3);
        ContinuousRange r = (ContinuousRange)this.getDataRange((byte)4);
        if (r == null) {
            return;
        }
        legendValues.addElement(new Double(r.getMin()));
        legendColors.addElement(this.colorMapper.getColor(r.getMin()));
        if (this.colorMapper.getNeutralColor() != null && r.contains((DataPoint)new ContinuousPoint(this.colorMapper.getNeutralValue()))) {
            legendValues.addElement(new Double(this.colorMapper.getNeutralValue()));
            legendColors.addElement(this.colorMapper.getNeutralColor());
        }
        legendValues.addElement(new Double(r.getMax()));
        legendColors.addElement(this.colorMapper.getColor(r.getMax()));
        Object[] values = new Object[legendValues.size()];
        for (int i = 0; i < legendValues.size(); ++i) {
            values[i] = legendValues.elementAt(i);
        }
        Color[] colors = new Color[legendColors.size()];
        for (int i = 0; i < legendColors.size(); ++i) {
            colors[i] = (Color)legendColors.elementAt(i);
        }
        this.legend.setValues(colors, null, values, null, true);
        SASFormat format = (SASFormat)this.dataFilter.getFormat(this.roles.getVariable((Object)this.colorRole, 0), SASFormat.class);
        if (format == null) {
            format = SASFormat.getInstance((String)NumericFormat.getFormatName((double[])this.colorMinMax, (int)12, (boolean)false));
        }
        this.legend.setLabel((Object)format);
    }

    private void setupDiscreteLegend() {
        if (this.legend == null || this.colorUniqueValues == null) {
            return;
        }
        int n = this.colorUniqueValues.size();
        Object[] values = new Object[n];
        Color[] colors = new Color[n];
        Color[] schemeColors = this.style.getDataLineColors();
        Object[] colorValues = this.dataFilter instanceof DataFilterInfoInterface ? ((DataFilterInfoInterface)this.dataFilter).getUniqueValues(this.roles.getVariable((Object)this.colorRole, 0), false) : null;
        for (int i = 0; i < n; ++i) {
            int idx = colorValues != null ? this.getColorIndex(this.colorUniqueValues.get(i), colorValues) : i;
            Color c = schemeColors[idx % schemeColors.length];
            colors[i] = new Color(c.getRed(), c.getGreen(), c.getBlue());
            values[i] = this.colorUniqueValues.get(i);
        }
        this.legend.setValues(colors, null, values, null, false);
        this.legend.setData(this.getFilter(), this.roles.getVariable((Object)this.colorRole, 0).toString());
    }

    public Object[] getSupportedRoles(Object id, boolean b) {
        if (!b) {
            return new Object[0];
        }
        return new Object[]{this.axisRole, this.colorRole};
    }

    public boolean supportsMultipleAssignments(Object role) {
        if (role == null) {
            return true;
        }
        return role.equals(this.axisRole);
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt.isAdjusting) {
            return;
        }
        switch (evt.type) {
            case 8: 
            case 9: {
                this.redrawBackBuffer = true;
                break;
            }
            case 2: {
                if (this.mouseDown) {
                    return;
                }
                if (this.dataFilter.getNumberObservations(-1) > 0) {
                    int[] arr = (int[])evt.oldValue;
                    if (arr == null) {
                        boolean sel = this.dataFilter.isSelected(0L);
                        for (int i = 0; i < this.selected.length; ++i) {
                            this.selected[i] = sel;
                        }
                    } else if (arr.length > 0) {
                        boolean sel = this.dataFilter.isSelected((long)arr[0]);
                        for (int i = 0; i < arr.length; ++i) {
                            this.selected[arr[i]] = sel;
                        }
                    }
                }
                this.brushMode = false;
                break;
            }
            case 3: {
                int i;
                Object colorVar = this.roles.getVariable((Object)this.colorRole, 0);
                boolean foundColor = false;
                this.selected = new boolean[this.dataFilter.getNumberObservations(-1)];
                for (i = 0; i < this.dataFilter.getNumberObservations(-1); ++i) {
                    this.selected[i] = this.dataFilter.isSelected((long)i);
                }
                for (i = evt.varStartIndex; i <= evt.varEndIndex; ++i) {
                    for (int j = 0; j < this.axes.size(); ++j) {
                        AxisObject ao = (AxisObject)this.axes.get(j);
                        if (!ao.getVariable().equals(this.dataFilter.getVariableId(i))) continue;
                        this.updateAxisMinMax(ao);
                        this.dataChanged = true;
                        break;
                    }
                    if (foundColor || colorVar == null || !colorVar.equals(this.dataFilter.getVariableId(i))) continue;
                    this.updateColorVariable(colorVar);
                    foundColor = true;
                }
                break;
            }
            case 1: {
                for (int j = 0; j < this.axes.size(); ++j) {
                    AxisObject ao = (AxisObject)this.axes.get(j);
                    this.updateAxisMinMax(ao);
                }
                Object colorVar = this.roles.getVariable((Object)this.colorRole, 0);
                if (colorVar != null) {
                    this.updateColorVariable(colorVar);
                }
                this.dataChanged = true;
            }
        }
        this.repaint();
    }

    private boolean updateColorVariable(Object colorVar) {
        if (this.numericColor) {
            this.colorMinMax = this.getMinMax(colorVar);
        } else {
            this.colorUniqueValues = this.getUniqueValues(colorVar);
            if (this.colorUniqueValues == null) {
                this.roles.removeRole(colorVar, (Object)this.colorRole);
                return false;
            }
        }
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
        if (this.legend != null) {
            this.setupLegend();
            this.legend.setTitle(this.dataFilter.getVariableDescription(this.roles.getVariable((Object)this.colorRole, 0)));
        }
        return true;
    }

    private int getColorIndex(Object value, Object[] colorValues) {
        for (int i = 0; i < colorValues.length; ++i) {
            if (!value.equals(colorValues[i])) continue;
            return i;
        }
        return 0;
    }

    private void deactivateZoomPanHandlers() {
        if (this.axes != null) {
            for (int i = 0; i < this.axes.size(); ++i) {
                AxisObject ao = (AxisObject)this.axes.get(i);
                ao.getZoomPanHandler().setActive(false);
            }
        }
    }

    public void mousePressed(MouseEvent me) {
        this.startPt = me.getPoint();
        this.currPt = me.getPoint();
        if (this.activeHandler != null) {
            this.activeHandler.mousePressed(me);
            return;
        }
        int flags = me.getModifiers();
        if ((flags & 4) != 0 && this.allowPopup) {
            if (this.menu == null) {
                this.createPopupMenu();
                this.add(this.menu);
            }
            this.menu.show((Component)((Object)this), this.startPt.x, this.startPt.y);
            return;
        }
        this.mouseDown = true;
        this.draggingAxis = this.checkCursor(me);
        if (this.draggingAxis != null) {
            Font lf = this.draggingAxis.getAxis().getLabel().getFont();
            Font newFont = FontManager.getFont((String)lf.getName(), (int)2, (int)(lf.getSize() - 2));
            this.draggingLabel = new ExtendedJLabel(this.draggingAxis.getDescription());
            this.draggingLabel.setFont(newFont);
            this.draggingLabel.setForeground(Color.white);
            this.draggingLabel.setHorizontalAlignment(this.draggingAxis.getLabel().getHorizontalAlignment());
            this.draggingLabel.setVerticalAlignment(this.draggingAxis.getLabel().getVerticalAlignment());
            ((ExtendedJLabel)this.draggingLabel).setOrientation(((ExtendedJLabel)this.draggingAxis.getLabel()).getOrientation());
            this.add(this.draggingLabel);
        }
        super.mousePressed(me);
    }

    public void mouseReleased(MouseEvent me) {
        if (this.activeHandler != null) {
            this.activeHandler.mouseReleased(me);
            return;
        }
        if (this.warningIcon.isMouseOverIcon(me.getX(), me.getY())) {
            this.resetViewport();
            return;
        }
        if (this.menu != null && this.menu.isShowing()) {
            return;
        }
        super.mouseReleased(me);
        if (this.isChartReady() && this.plotType == 0) {
            switch (this.actionMode) {
                case 2: {
                    this.applyViewport();
                    break;
                }
                case 1: {
                    if (this.brushMode) break;
                    this.applyBrush(me.getPoint());
                    break;
                }
                case 6: {
                    if (this.draggingAxis != null) {
                        this.insertAxis(this.draggingAxis, this.getAxisIndex(me.getPoint()));
                        break;
                    }
                    if (this.mouseDragging) {
                        this.applySelection(me.isControlDown(), this.getSelectionBehavior());
                        break;
                    }
                    this.applySelection(me.getPoint(), me.isControlDown(), this.getSelectionBehavior());
                }
            }
        }
        this.mouseDown = false;
        this.mouseDragging = false;
        this.draggingAxis = null;
        this.mouseOnAxisLabel = false;
        if (this.draggingLabel != null) {
            this.remove(this.draggingLabel);
        }
        this.draggingLabel = null;
        this.checkCursor(me);
    }

    public void mouseExited(MouseEvent e) {
        if (this.tipsOn && this.tipText != null) {
            this.tipText = null;
            this.repaint();
        }
    }

    private boolean isChartReady() {
        return !this.dataChanged && !this.isRebuildRequired();
    }

    private void applyViewport() {
        double y2;
        double y1;
        double x2;
        double x1;
        if (!this.mouseDragging) {
            return;
        }
        double xVRange = this.viewportXMax - this.viewportXMin;
        double yVRange = this.viewportYMax - this.viewportYMin;
        if (this.orientation == 0) {
            x1 = (double)(this.rubberband.x - this.chartArea.x) / (double)this.chartArea.width;
            x2 = (double)(this.rubberband.x + this.rubberband.width - this.chartArea.x) / (double)this.chartArea.width;
        } else {
            x1 = (double)(this.rubberband.x - this.plotArea.x) / (double)this.plotArea.width;
            x2 = (double)(this.rubberband.x + this.rubberband.width - this.plotArea.x) / (double)this.plotArea.width;
        }
        x1 = this.viewportXMin + x1 * xVRange;
        x2 = this.viewportXMin + x2 * xVRange;
        if (this.orientation == 1) {
            y1 = (double)(this.chartArea.height + this.chartArea.y - (this.rubberband.y + this.rubberband.height)) / (double)this.chartArea.height;
            y2 = (double)(this.chartArea.height + this.chartArea.y - this.rubberband.y) / (double)this.chartArea.height;
        } else {
            y1 = (double)(this.plotArea.height + this.plotArea.y - (this.rubberband.y + this.rubberband.height)) / (double)this.plotArea.height;
            y2 = (double)(this.plotArea.height + this.plotArea.y - this.rubberband.y) / (double)this.plotArea.height;
        }
        y1 = this.viewportYMin + y1 * yVRange;
        y2 = this.viewportYMin + y2 * yVRange;
        if (x2 - x1 < 0.001 || y2 - y1 < 0.001) {
            return;
        }
        this.panning = false;
        this.setViewport(x1, x2, y1, y2, 0.0, 1.0);
    }

    private void setViewport(double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        this.setViewport(1, xmin, xmax, ymin, ymax, zmin, zmax);
    }

    private void applyBrush(Point pt) {
        if (!this.mouseDragging) {
            this.applySelection(pt, false, 0);
            this.brushMode = false;
        } else {
            this.applySelection(false, 0);
            this.brushMode = true;
        }
        this.createBrushHandleRects();
    }

    private void applySelection(boolean extend, int behaviour) {
        int[] axisNo = this.getClosetAxisIndices();
        Rectangle2D.Double rect2D = new Rectangle2D.Double(this.rubberband.x, this.rubberband.y, this.rubberband.width, this.rubberband.height);
        int nobs = 0;
        block4: for (int i = 0; i < this.dataFilter.getNumberObservations(-1); ++i) {
            AxisObject ao1;
            int j;
            if (extend) {
                if (this.selected[i]) {
                    ++nobs;
                }
            } else {
                this.selected[i] = false;
            }
            if (!this.dataFilter.isGraphed((long)i) || axisNo == null) continue;
            if (this.endPointSelection) {
                for (j = axisNo[0]; j <= axisNo[1]; ++j) {
                    Point pt;
                    ao1 = (AxisObject)this.axes.get(j);
                    Object value = this.dataFilter.getValue(ao1.getVariable(), (long)i);
                    if (this.isMissing(ao1.getVariable(), value) || !this.rubberband.contains(pt = ao1.project(value))) continue;
                    this.selected[i] = true;
                    ++nobs;
                    continue block4;
                }
                continue;
            }
            for (j = axisNo[0]; j < axisNo[1]; ++j) {
                Point pt2;
                ao1 = (AxisObject)this.axes.get(j);
                AxisObject ao2 = (AxisObject)this.axes.get(j + 1);
                Object v1 = this.dataFilter.getValue(ao1.getVariable(), (long)i);
                Object v2 = this.dataFilter.getValue(ao2.getVariable(), (long)i);
                Point pt1 = this.isMissing(ao1.getVariable(), v1) ? this.getClosetNonMissingPoint(i, j, false) : ao1.project(v1);
                Point point = pt2 = this.isMissing(ao2.getVariable(), v2) ? this.getClosetNonMissingPoint(i, j + 1, true) : ao2.project(v2);
                if (pt1 == null || pt2 == null || !rect2D.intersectsLine(pt1.x, pt1.y, pt2.x, pt2.y)) continue;
                if (this.selected[i]) {
                    this.selected[i] = false;
                    --nobs;
                    continue block4;
                }
                this.selected[i] = true;
                ++nobs;
                continue block4;
            }
        }
        if (nobs > 0) {
            int i;
            int[] OBS = new int[nobs];
            int idx = 0;
            for (i = 0; i < this.selected.length; ++i) {
                if (!this.selected[i]) continue;
                OBS[idx] = i;
                ++idx;
            }
            switch (behaviour) {
                case 0: {
                    this.dataFilter.unselectAll();
                    this.dataFilter.setSelected((Object)OBS, true);
                    break;
                }
                case 1: 
                case 2: {
                    for (i = 0; i < nobs; ++i) {
                        this.selected[OBS[i]] = false;
                    }
                    Object value = this.getSelectionBehaviorValue();
                    if (value == null) break;
                    if (behaviour == 1) {
                        this.dataFilter.setObservationColor((Object)OBS, (Color)value);
                        break;
                    }
                    if (behaviour != 2) break;
                    this.dataFilter.setGraphed((Object)OBS, (Boolean)value == false);
                }
            }
        } else if (behaviour == 0 && !extend) {
            this.dataFilter.unselectAll();
        }
        this.repaint();
    }

    private void applySelection(Point pt, boolean extend, int behaviour) {
        if (this.rubberband == null) {
            this.rubberband = new Rectangle();
        }
        this.rubberband.x = pt.x - 1;
        this.rubberband.y = pt.y - 1;
        this.rubberband.width = 3;
        this.rubberband.height = 3;
        this.applySelection(extend, behaviour);
    }

    private Point getClosetNonMissingPoint(int obs, int idx, boolean forward) {
        Point pt = null;
        if (forward) {
            for (int i = idx + 1; i < this.axes.size(); ++i) {
                AxisObject ao = (AxisObject)this.axes.get(i);
                Object value = this.dataFilter.getValue(ao.getVariable(), (long)obs);
                if (this.isMissing(ao.getVariable(), value)) continue;
                pt = ao.project(value);
                break;
            }
        } else {
            for (int i = idx - 1; i >= 0; --i) {
                AxisObject ao = (AxisObject)this.axes.get(i);
                Object value = this.dataFilter.getValue(ao.getVariable(), (long)obs);
                if (this.isMissing(ao.getVariable(), value)) continue;
                pt = ao.project(value);
                break;
            }
        }
        return pt;
    }

    private int getAxisIndex(Point pt) {
        int index = -1;
        if (this.orientation == 0) {
            pt.y = (int)((double)this.plotArea.y + 0.5 * (double)this.plotArea.height);
            if (pt.x <= this.plotArea.x) {
                index = 0;
            } else {
                for (int i = 0; i < this.axes.size(); ++i) {
                    AxisObject ao = (AxisObject)this.axes.get(i);
                    if (!ao.getScreenArea().contains(pt)) continue;
                    index = i + 1;
                    break;
                }
            }
        } else {
            pt.x = (int)((double)this.plotArea.x + 0.5 * (double)this.plotArea.width);
            if (pt.y >= this.plotArea.y + this.plotArea.height) {
                index = this.axes.size();
            } else {
                for (int i = 0; i < this.axes.size(); ++i) {
                    AxisObject ao = (AxisObject)this.axes.get(i);
                    if (!ao.getScreenArea().contains(pt)) continue;
                    index = i;
                    break;
                }
            }
        }
        return index;
    }

    private int[] getClosetAxisIndices() {
        if (this.endPointSelection) {
            return this.getClosetAxisInside();
        }
        return this.getClosetAxisOutside();
    }

    private int[] getClosetAxisInside() {
        int val;
        AxisObject ao;
        int i;
        int prev = -1;
        int next = -1;
        for (i = 0; i < this.axes.size(); ++i) {
            ao = (AxisObject)this.axes.get(i);
            val = ao.getPixelLoc();
            if (this.orientation == 0) {
                if (val < this.rubberband.x || val > this.rubberband.x + this.rubberband.width) continue;
                prev = i;
                break;
            }
            if (val < this.rubberband.y || val > this.rubberband.y + this.rubberband.height) continue;
            prev = i;
            break;
        }
        for (i = this.axes.size() - 1; i >= 0; --i) {
            ao = (AxisObject)this.axes.get(i);
            val = ao.getPixelLoc();
            if (this.orientation == 0) {
                if (val < this.rubberband.x || val > this.rubberband.x + this.rubberband.width + 1) continue;
                next = i;
                break;
            }
            if (val < this.rubberband.y || val > this.rubberband.y + this.rubberband.height + 1) continue;
            next = i;
            break;
        }
        if (prev == -1 || next == -1) {
            return null;
        }
        return new int[]{prev, next};
    }

    private int[] getClosetAxisOutside() {
        int prev = -1;
        int next = -1;
        if (this.orientation == 0) {
            if (this.rubberband.x + this.rubberband.width < ((AxisObject)this.axes.get(0)).getPixelLoc()) {
                prev = -1;
                next = -1;
            } else if (this.rubberband.x > ((AxisObject)this.axes.get(this.axes.size() - 1)).getPixelLoc()) {
                prev = -1;
                next = -1;
            } else {
                AxisObject ao;
                int i;
                int y = (int)((double)this.plotArea.y + 0.5 * (double)this.plotArea.height);
                prev = 0;
                for (i = 0; i < this.axes.size(); ++i) {
                    ao = (AxisObject)this.axes.get(i);
                    if (!ao.getScreenArea().contains(this.rubberband.x, y)) continue;
                    prev = i;
                    break;
                }
                for (i = 0; i < this.axes.size(); ++i) {
                    ao = (AxisObject)this.axes.get(i);
                    if (!ao.getScreenArea().contains(this.rubberband.x + this.rubberband.width, y)) continue;
                    next = i + 1;
                    break;
                }
                next = Math.min(next, this.axes.size() - 1);
            }
        } else {
            if (this.rubberband.y + this.rubberband.height < ((AxisObject)this.axes.get(0)).getPixelLoc()) {
                prev = -1;
                next = -1;
            }
            if (this.rubberband.y > ((AxisObject)this.axes.get(this.axes.size() - 1)).getPixelLoc()) {
                prev = -1;
                next = -1;
            } else {
                AxisObject ao;
                int i;
                int x = (int)((double)this.plotArea.x + 0.5 * (double)this.plotArea.width);
                for (i = 0; i < this.axes.size(); ++i) {
                    ao = (AxisObject)this.axes.get(i);
                    if (!ao.getScreenArea().contains(x, this.rubberband.y)) continue;
                    prev = i - 1;
                    break;
                }
                prev = Math.max(prev, 0);
                next = this.axes.size() - 1;
                for (i = 0; i < this.axes.size(); ++i) {
                    ao = (AxisObject)this.axes.get(i);
                    if (!ao.getScreenArea().contains(x, this.rubberband.y + this.rubberband.height)) continue;
                    next = i;
                    break;
                }
            }
        }
        if (prev == -1 || next == -1) {
            return null;
        }
        return new int[]{prev, next};
    }

    public void mouseMoved(MouseEvent me) {
        this.deactivateZoomPanHandlers();
        this.activeHandler = null;
        if (this.warningIcon == null || !this.warningIcon.isMouseOverIcon(me.getX(), me.getY())) {
            if (this.zoomPanHandler.isMouseInZoomPanArea(me)) {
                this.activeHandler = this.zoomPanHandler;
                this.zoomPanHandler.mouseMoved(me);
                this.tipText = null;
                return;
            }
            for (int i = 0; i < this.axes.size(); ++i) {
                if (!((AxisObject)this.axes.get(i)).getZoomPanHandler().isMouseInZoomPanArea(me)) continue;
                this.activeHandler = ((AxisObject)this.axes.get(i)).getZoomPanHandler();
                this.activeHandler.mouseMoved(me);
                this.tipText = null;
                return;
            }
        }
        this.checkCursor(me);
        super.mouseMoved(me);
    }

    public void mouseDragged(MouseEvent me) {
        if (!this.isChartReady()) {
            return;
        }
        this.currPt = me.getPoint();
        if (this.tipsOn && this.tipText != null) {
            this.tipText = null;
            this.repaint();
        }
        if (this.activeHandler != null) {
            this.activeHandler.mouseDragged(me);
            return;
        }
        if (this.mouseOnAxisLabel) {
            this.dragAxisLabel(me.getPoint());
            return;
        }
        if (this.plotType == 1) {
            return;
        }
        switch (this.actionMode) {
            case 2: {
                this.dragRubberband(me.getPoint());
                break;
            }
            case 1: {
                if (this.brushMode) {
                    this.brushing(me.getPoint());
                    break;
                }
                this.dragRubberband(me.getPoint());
                break;
            }
            case 6: {
                if (this.draggingAxis != null) {
                    this.repaint();
                    break;
                }
                this.dragRubberband(me.getPoint());
            }
        }
    }

    private AxisObject checkCursor(MouseEvent me) {
        this.cursor = this.getCursor();
        this.mouseOnAxisLabel = this.isMouseOnAxisLabel(me.getPoint());
        if (this.mouseOnAxisLabel) {
            if (this.orientation == 0 && this.cursor != resizeUDCursor) {
                this.cursor = resizeUDCursor;
                this.setCursor(this.cursor);
            } else if (this.orientation == 1 && this.cursor != resizeLRCursor) {
                this.cursor = resizeLRCursor;
                this.setCursor(this.cursor);
            }
            return null;
        }
        if (this.actionMode == 2) {
            if (this.cursor != normalCursor) {
                this.cursor = normalCursor;
                this.setCursor(this.cursor);
            }
            return null;
        }
        if (this.actionMode == 1) {
            if (this.brushMode) {
                this.brushAction = this.getMouseSpot(me.getPoint());
                this.setBrushCursorShape(this.brushAction, this.mouseDown);
            } else if (this.cursor != normalCursor) {
                this.cursor = normalCursor;
                this.setCursor(this.cursor);
            }
            return null;
        }
        AxisObject ao = this.axisAtPoint(me.getX(), me.getY());
        if (ao != null && this.chartArea.contains(me.getPoint())) {
            ao = null;
        }
        if (ao != null) {
            if (!this.mouseDown && this.cursor != moveCursorOpen) {
                this.cursor = moveCursorOpen;
                this.setCursor(this.cursor);
            } else if (this.mouseDown && this.cursor != moveCursorClose) {
                this.cursor = moveCursorClose;
                this.setCursor(this.cursor);
            }
        } else if (ao == null && this.cursor != normalCursor) {
            this.cursor = normalCursor;
            this.setCursor(this.cursor);
        }
        return ao;
    }

    private AxisObject axisAtPoint(int x, int y) {
        if (!this.isChartReady()) {
            return null;
        }
        AxisObject rc = null;
        for (int i = 0; i < this.axes.size(); ++i) {
            AxisObject ao = (AxisObject)this.axes.get(i);
            int val = ao.getPixelLoc();
            if (this.orientation == 0) {
                if (val >= x + 5 || val <= x - 5) continue;
                rc = ao;
                continue;
            }
            if (val >= y + 5 || val <= y - 5) continue;
            rc = ao;
        }
        return rc;
    }

    private boolean isMouseOnAxisLabel(Point pt) {
        int x;
        int y;
        if (!this.isChartReady()) {
            return false;
        }
        return this.orientation == 0 ? pt.y > (y = this.chartArea.y + this.chartArea.height) - 1 && pt.y < y + 6 : pt.x > (x = this.chartArea.x) - 6 && pt.x < x + 1;
    }

    private void dragRubberband(Point pt) {
        if (Math.abs(pt.x - this.startPt.x) < 5 || Math.abs(pt.y - this.startPt.y) < 5) {
            return;
        }
        this.mouseDragging = true;
        if (this.rubberband == null) {
            this.rubberband = new Rectangle();
        }
        if (this.rubberband != null) {
            int x1 = Math.min(this.startPt.x, pt.x);
            int x2 = Math.max(this.startPt.x, pt.x);
            x1 = Math.max(x1, this.chartArea.x);
            x2 = Math.min(x2, this.chartArea.x + this.chartArea.width);
            int y1 = Math.min(this.startPt.y, pt.y);
            int y2 = Math.max(this.startPt.y, pt.y);
            y1 = Math.max(y1, this.chartArea.y);
            y2 = Math.min(y2, this.chartArea.y + this.chartArea.height);
            this.rubberband.x = x1;
            this.rubberband.y = y1;
            this.rubberband.width = x2 - x1;
            this.rubberband.height = y2 - y1;
        }
        this.repaint();
    }

    private void dragAxisLabel(Point pt) {
        if (!this.isUsingBackBuffer()) {
            return;
        }
        if (this.orientation == 0) {
            int dy = pt.y - this.startPt.y;
            if (this.chartArea.height + dy < 1) {
                return;
            }
            this.axisLabelPercentage -= (double)dy / (double)this.compHeight;
        } else {
            int dx = pt.x - this.startPt.x;
            if (this.chartArea.width - dx < 1) {
                return;
            }
            this.axisLabelPercentage += (double)dx / (double)this.compWidth;
        }
        this.axisLabelPercentage = Math.min(Math.max(0.0, this.axisLabelPercentage), this.maxAxisLabelPercentage);
        this.startPt.x = pt.x;
        this.startPt.y = pt.y;
        this.rebuildRequired = true;
        this.repaint();
    }

    private void brushing(Point pt) {
        int chartClipX = this.chartArea.x;
        int chartClipY = this.chartArea.y;
        int chartClipWidth = this.chartArea.width;
        int chartClipHeight = this.chartArea.height;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        switch (this.brushAction) {
            case 1: {
                x = this.rubberband.x + (pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, chartClipX + chartClipWidth - this.rubberband.width);
                y = this.rubberband.y + (pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, chartClipY + chartClipHeight - this.rubberband.height);
                width = this.rubberband.width;
                height = this.rubberband.height;
                break;
            }
            case 2: {
                x = this.rubberband.x + (pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4);
                y = this.rubberband.y;
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height;
                break;
            }
            case 3: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width + (pt.x - this.startPt.x);
                width = Math.max(width, 4);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height;
                break;
            }
            case 4: {
                x = this.rubberband.x;
                y = this.rubberband.y + (pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4);
                width = this.rubberband.width;
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 5: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width;
                height = this.rubberband.height + (pt.y - this.startPt.y);
                height = Math.max(height, 4);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            case 6: {
                x = this.rubberband.x + (pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4);
                y = this.rubberband.y + (pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4);
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 7: {
                x = this.rubberband.x;
                y = this.rubberband.y + (pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4);
                width = this.rubberband.width + (pt.x - this.startPt.x);
                width = Math.max(width, 4);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 8: {
                x = this.rubberband.x + (pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4);
                y = this.rubberband.y;
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height + (pt.y - this.startPt.y);
                height = Math.max(height, 4);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            case 9: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width + (pt.x - this.startPt.x);
                width = Math.max(width, 4);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height + (pt.y - this.startPt.y);
                height = Math.max(height, 4);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            default: {
                return;
            }
        }
        this.rubberband.x = x;
        this.rubberband.y = y;
        this.rubberband.width = width;
        this.rubberband.height = height;
        this.startPt = pt;
        this.mouseDragging = true;
        this.applyBrush(pt);
    }

    protected void setBrushCursorShape(int action, boolean down) {
        switch (action) {
            case 2: {
                this.setCursor(new Cursor(10));
                break;
            }
            case 3: {
                this.setCursor(new Cursor(11));
                break;
            }
            case 4: {
                this.setCursor(new Cursor(8));
                break;
            }
            case 5: {
                this.setCursor(new Cursor(9));
                break;
            }
            case 6: {
                this.setCursor(new Cursor(6));
                break;
            }
            case 7: {
                this.setCursor(new Cursor(7));
                break;
            }
            case 8: {
                this.setCursor(new Cursor(4));
                break;
            }
            case 9: {
                this.setCursor(new Cursor(5));
                break;
            }
            case 1: {
                if (down) {
                    this.setCursor(moveCursorClose);
                    break;
                }
                this.setCursor(moveCursorOpen);
                break;
            }
            default: {
                this.setCursor(new Cursor(0));
                if (!down) break;
                this.brushMode = false;
            }
        }
    }

    protected int getMouseSpot(Point pt) {
        int spot = 0;
        if (this.resizeL.contains(pt)) {
            spot = 2;
        } else if (this.resizeR.contains(pt)) {
            spot = 3;
        }
        if (spot == 0) {
            if (this.resizeT.contains(pt)) {
                spot = 4;
            } else if (this.resizeB.contains(pt)) {
                spot = 5;
            } else if (this.resizeTL.contains(pt)) {
                spot = 6;
            } else if (this.resizeTR.contains(pt)) {
                spot = 7;
            } else if (this.resizeBL.contains(pt)) {
                spot = 8;
            } else if (this.resizeBR.contains(pt)) {
                spot = 9;
            }
        }
        if (spot == 0 && this.rubberband.contains(pt)) {
            spot = 1;
        }
        return spot;
    }

    protected void createBrushHandleRects() {
        if (!this.brushMode) {
            return;
        }
        if ((double)this.rubberband.width > 24.0 && (double)this.rubberband.height > 24.0) {
            this.resizeL = new Rectangle((int)((double)this.rubberband.x - 3.0), (int)((double)this.rubberband.y + 0.5 * (double)this.rubberband.height - 3.0), 6, 6);
            this.resizeR = new Rectangle((int)((double)(this.rubberband.x + this.rubberband.width) - 3.0), (int)((double)this.rubberband.y + 0.5 * (double)this.rubberband.height - 3.0), 6, 6);
            this.resizeT = new Rectangle((int)((double)this.rubberband.x + (double)this.rubberband.width * 0.5 - 3.0), (int)((double)this.rubberband.y - 3.0), 6, 6);
            this.resizeB = new Rectangle((int)((double)this.rubberband.x + (double)this.rubberband.width * 0.5 - 3.0), (int)((double)(this.rubberband.y + this.rubberband.height) - 3.0), 6, 6);
            this.resizeTL = new Rectangle((int)((double)this.rubberband.x - 3.0), (int)((double)this.rubberband.y - 3.0), 6, 6);
            this.resizeTR = new Rectangle((int)((double)(this.rubberband.x + this.rubberband.width) - 3.0), (int)((double)this.rubberband.y - 3.0), 6, 6);
            this.resizeBL = new Rectangle((int)((double)this.rubberband.x - 3.0), (int)((double)(this.rubberband.y + this.rubberband.height) - 3.0), 6, 6);
            this.resizeBR = new Rectangle((int)((double)(this.rubberband.x + this.rubberband.width) - 3.0), (int)((double)(this.rubberband.y + this.rubberband.height) - 3.0), 6, 6);
        } else {
            this.resizeL = new Rectangle(this.rubberband.x - 6, (int)((double)this.rubberband.y + 0.5 * (double)this.rubberband.height - 3.0), 6, 6);
            this.resizeR = new Rectangle(this.rubberband.x + this.rubberband.width, (int)((double)this.rubberband.y + 0.5 * (double)this.rubberband.height - 3.0), 6, 6);
            this.resizeT = new Rectangle((int)((double)this.rubberband.x + (double)this.rubberband.width * 0.5 - 3.0), this.rubberband.y - 6, 6, 6);
            this.resizeB = new Rectangle((int)((double)this.rubberband.x + (double)this.rubberband.width * 0.5 - 3.0), this.rubberband.y + this.rubberband.height, 6, 6);
            this.resizeTL = new Rectangle(this.rubberband.x - 6, this.rubberband.y - 6, 6, 6);
            this.resizeTR = new Rectangle(this.rubberband.x + this.rubberband.width, this.rubberband.y - 6, 6, 6);
            this.resizeBL = new Rectangle(this.rubberband.x - 6, this.rubberband.y + this.rubberband.height, 6, 6);
            this.resizeBR = new Rectangle(this.rubberband.x + this.rubberband.width, this.rubberband.y + this.rubberband.height, 6, 6);
        }
    }

    public boolean isPropertySupported(int id) {
        switch (id) {
            case 0: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 53: 
            case 59: 
            case 402: 
            case 443: 
            case 601: 
            case 602: 
            case 603: 
            case 801: 
            case 802: 
            case 803: 
            case 807: {
                return true;
            }
        }
        return false;
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            case 45: {
                if (this.orientation == 1) {
                    rc = ResourceLoader.getResourceString((Object)this.rb, (String)"ParallelAxisPlot.Horizontal.txt", (String)"Horizontal");
                    break;
                }
                rc = ResourceLoader.getResourceString((Object)this.rb, (String)"ParallelAxisPlot.Vertical.txt", (String)"Vertical");
                break;
            }
            case 44: {
                rc = new String[]{"Axis"};
                break;
            }
            case 46: {
                rc = new Object[]{this.getAxis(ALL_AXES)};
                break;
            }
            case 34: {
                rc = new Boolean(this.hScrollbarOn);
                break;
            }
            case 25: {
                rc = this.colorRole.toString();
                break;
            }
            case 24: {
                rc = this.currentLegend;
                break;
            }
            case 23: {
                rc = this.currentLegend;
                break;
            }
            case 59: {
                rc = this.getLegend(null);
                break;
            }
            case 443: {
                rc = this.getLegendPosition(null);
                break;
            }
            case 402: {
                if (this.getLegend(null) == null) {
                    rc = new Boolean(false);
                    break;
                }
                rc = new Boolean(true);
                break;
            }
            case 441: {
                rc = this.numericColor ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 801: {
                rc = new Boolean(this.equalizeAxes);
                break;
            }
            case 807: {
                rc = new Boolean(this.skipMissingValues);
                break;
            }
            case 802: {
                rc = new Double(this.lineOpacity);
                break;
            }
            case 803: {
                rc = new Integer(this.lineWidth);
                break;
            }
            case 261: {
                rc = Boolean.TRUE;
                break;
            }
            case 248: {
                rc = Boolean.FALSE;
                break;
            }
            case 262: 
            case 263: 
            case 264: {
                rc = this.areAxesEqualized() ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case 53: {
                if (this.dataFilter.isNumericVariable(this.roles.getVariable((Object)this.colorRole, 0)) && !this.isDiscrete(this.colorRole)) {
                    rc = this.rampName;
                    break;
                }
                rc = null;
                break;
            }
            default: {
                rc = this.getPropertyValueFromInternalObjects(id);
            }
        }
        return rc;
    }

    protected Object getPropertyValueFromInternalObjects(int id) {
        Object rc = null;
        rc = this.legend != null && this.legend.isPropertySupported(id) ? this.legend.getPropertyValue(id) : (this.getAxis(ALL_AXES) != null && ((PropertyInterface)this.getAxis(ALL_AXES)).isPropertySupported(id) ? ((PropertyInterface)this.getAxis(ALL_AXES)).getPropertyValue(id) : super.getPropertyValue(id));
        return rc;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (id == 23 && value instanceof SILKNumber) {
            this.currentLegend = (SILKNumber)value;
        }
        if (this.legend != null && this.legend.isPropertySupported(id)) {
            this.legend.setPropertyValue(id, value);
        }
        if (this.getAxis(ALL_AXES) != null && ((PropertyInterface)this.getAxis(ALL_AXES)).isPropertySupported(id)) {
            ((PropertyInterface)this.getAxis(ALL_AXES)).setPropertyValue(id, value);
        }
        return super.setPropertyValue(id, value);
    }

    public boolean applyPropertyChanges(Object source) {
        if (this.legend != null) {
            this.legend.applyPropertyChanges(source);
        }
        if (this.getAxis(ALL_AXES) != null) {
            ((PropertyInterface)this.getAxis(ALL_AXES)).applyPropertyChanges(source);
        }
        boolean rc = super.applyPropertyChanges(source);
        this.rebuildRequired = true;
        this.repaint();
        return rc;
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 0: {
                this.setColorScheme(value);
                break;
            }
            case 29: {
                this.setStyle(value);
                break;
            }
            case 53: {
                if (value == null) break;
                this.rampName = value.toString();
                this.initColorRamp();
                this.setupLegend();
                break;
            }
            case 30: {
                if (!(value instanceof ImageListInterface)) break;
                this.setImageList((ImageListInterface)value);
                break;
            }
            case 2: {
                if (!(value instanceof Boolean)) break;
                this.tipsOn = (Boolean)value;
                break;
            }
            case 34: {
                if (!(value instanceof Boolean)) break;
                boolean vis = (Boolean)value;
                this.setEnableZoomPan(vis);
                break;
            }
            case 443: {
                if (!(value instanceof String) && !(value instanceof Number)) break;
                this.setLegendPosition(null, value);
                break;
            }
            case 801: {
                if (!(value instanceof Boolean)) break;
                this.setEqualizeAxes((Boolean)value);
                break;
            }
            case 807: {
                if (!(value instanceof Boolean)) break;
                this.setSkipMissingValues((Boolean)value);
                break;
            }
            case 802: {
                if (!(value instanceof Double)) break;
                this.setLineOpacity((Double)value);
                break;
            }
            case 803: {
                if (!(value instanceof Integer)) break;
                this.setLineWidth((Integer)value);
            }
        }
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
        if (this.legend != null) {
            this.legend.cancelPropertyChanges();
        }
        if (this.getAxis(ALL_AXES) != null) {
            ((PropertyInterface)this.getAxis(ALL_AXES)).cancelPropertyChanges();
        }
    }

    public boolean hasUserSetValue(int id) {
        if (this.legend != null && this.legend.isPropertySupported(id)) {
            return this.legend.hasUserSetValue(id);
        }
        if (this.getAxis(ALL_AXES) != null && ((PropertyInterface)this.getAxis(ALL_AXES)).isPropertySupported(id)) {
            return ((PropertyInterface)this.getAxis(ALL_AXES)).hasUserSetValue(id);
        }
        return super.hasUserSetValue(id);
    }

    public double[] getViewport(int type, int level, int dimension) {
        double[] vport = new double[2];
        switch (dimension) {
            case 1: {
                vport[0] = this.viewportXMin;
                vport[1] = this.viewportXMax;
                break;
            }
            case 2: {
                vport[0] = this.viewportYMin;
                vport[1] = this.viewportYMax;
                break;
            }
            default: {
                return null;
            }
        }
        return vport;
    }

    public boolean setViewport(int type, int dimension, double min, double max) {
        switch (dimension) {
            case 1: {
                this.viewportXMin = Math.max(this.dataXMin, min);
                this.viewportXMax = Math.min(this.dataXMax, max);
                break;
            }
            case 2: {
                this.viewportYMin = Math.max(this.dataYMin, min);
                this.viewportYMax = Math.min(this.dataYMax, max);
                break;
            }
            default: {
                return false;
            }
        }
        this.setViewportToAxes();
        this.rebuildRequired = true;
        this.repaint();
        return true;
    }

    public boolean setViewport(int type, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        this.viewportXMin = Math.max(this.dataXMin, xmin);
        this.viewportXMax = Math.min(this.dataXMax, xmax);
        this.viewportYMin = Math.max(this.dataYMin, ymin);
        this.viewportYMax = Math.min(this.dataYMax, ymax);
        this.setViewportToAxes();
        this.rebuildRequired = true;
        this.repaint();
        return true;
    }

    public double getZoomFactor(int dimension) {
        return 1.0;
    }

    public boolean setZoomFactor(int dimension, double fac) {
        if (fac <= 0.0 || fac > 1.0) {
            return false;
        }
        switch (dimension) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        if (this.orientation == 0) {
            this.viewportXMin = 0.0;
            this.viewportXMax = 0.5;
        } else {
            this.viewportYMin = 0.5;
            this.viewportYMax = 1.0;
        }
        this.setViewportToAxes();
        this.rebuildRequired = true;
        this.repaint();
        return true;
    }

    public boolean resetViewport() {
        this.viewportYMin = 0.0;
        this.viewportXMin = 0.0;
        this.viewportYMax = 1.0;
        this.viewportXMax = 1.0;
        this.panning = false;
        this.setViewportToAxes();
        this.rebuildRequired = true;
        this.repaint();
        return true;
    }

    private void setViewportToAxes() {
        for (int i = 0; i < this.axes.size(); ++i) {
            AxisObject ao = (AxisObject)this.axes.get(i);
            ao.setPanTickValues(this.panning);
            if (this.orientation == 0) {
                ao.setViewport(this.viewportYMin, this.viewportYMax);
                continue;
            }
            ao.setViewport(this.viewportXMin, this.viewportXMax);
        }
        this.brushMode = false;
        this.fireViewportChangeEvent();
    }

    public void textUpdated(DvrTextEvent evt) {
        if (evt.isBoundsChanged) {
            this.rebuildRequired = true;
        }
        this.redrawBackBuffer = true;
        this.repaint();
    }

    public boolean build(Object obj) {
        if (!this.isRebuildRequired() && !this.dataChanged) {
            return true;
        }
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return false;
        }
        if (this.equalizeAxes) {
            this.arrangeAxes();
        }
        this.adjustAxisOptions();
        this.setupData();
        this.computeChartArea();
        this.layoutAxes();
        if (this.plotType == 1) {
            this.loadDistributionPlots();
        }
        this.rebuildRequired = false;
        return true;
    }

    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        this.build(buildData);
        this.repaint();
        return true;
    }

    public boolean isRebuildRequired() {
        return this.rebuildRequired || this.legend != null && this.legend.isUpdateRequired() || ((AxesHandler)this.getAxis(ALL_AXES)).isRebuildRequired();
    }

    private void arrangeAxes() {
        int i;
        int size = this.axes.size();
        AxisObject[] axesD = new AxisObject[size];
        AxisObject[] axesN = new AxisObject[size];
        int numD = 0;
        int numN = 0;
        for (i = 0; i < size; ++i) {
            AxisObject ao = (AxisObject)this.axes.get(i);
            if (ao.isDiscrete()) {
                axesD[numD] = ao;
                ++numD;
                continue;
            }
            axesN[numN] = ao;
            ++numN;
        }
        this.axes.clear();
        for (i = 0; i < numD; ++i) {
            this.axes.add(axesD[i]);
        }
        for (i = 0; i < numN; ++i) {
            this.axes.add(axesN[i]);
        }
        Vector<Object> v = new Vector<Object>();
        for (int i2 = 0; i2 < this.axes.size(); ++i2) {
            AxisObject aobj = (AxisObject)this.axes.get(i2);
            v.add(aobj.getVariable());
        }
        this.roles.setVariableOrder((Object)RoleInterface.ROLE_AXIS, v);
        this.numDiscreteAxes = numD;
        this.numNumericAxes = numN;
    }

    private void adjustAxisOptions() {
        Axes ao;
        int i;
        int size = this.axes.size();
        if (size == 0) {
            return;
        }
        boolean tickVisible = false;
        boolean valueVisible = false;
        for (i = 0; i < size; ++i) {
            ao = ((AxisObject)this.axes.get(i)).getAxis();
            if (ao.getMajorTicks().isVisible()) {
                tickVisible = true;
            }
            if (!ao.getValues().isVisible()) continue;
            valueVisible = true;
        }
        for (i = 0; i < size; ++i) {
            ao = ((AxisObject)this.axes.get(i)).getAxis();
            if (!this.equalizeAxes || i == 0 || i == this.axes.size() - 1) {
                ao.getMajorTicks().setVisible(tickVisible);
                ao.getValues().setVisible(valueVisible);
            } else if (this.equalizeAxes) {
                ao.getMajorTicks().setVisible(false);
                ((LineAttrib)ao.getMajorTicks()).setCurrentValueAsDefault(9501);
                ao.getValues().setVisible(false);
                ((TextAttrib)ao.getValues()).setCurrentValueAsDefault(9000);
            }
            if (this.equalizeAxes) {
                if (this.orientation == 0 && i == this.axes.size() - 1 || this.orientation == 1 && i == 0) {
                    ao.setPrimary(false);
                    continue;
                }
                ao.setPrimary(true);
                continue;
            }
            ao.setPrimary(true);
        }
    }

    private void setupData() {
        if (!this.dataChanged) {
            return;
        }
        if (this.equalizeAxes) {
            AxisObject ao;
            int i;
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            ArrayList list1 = null;
            for (i = 0; i < this.axes.size(); ++i) {
                ao = (AxisObject)this.axes.get(i);
                if (ao.isDiscrete()) {
                    if (list1 == null) {
                        list1 = new ArrayList();
                    }
                    this.unionOfUniqueValues(list1, this.getUniqueValues(ao.getVariable()));
                    continue;
                }
                if (ao.getMax() > max) {
                    max = ao.getMax();
                }
                if (!(ao.getMin() < min)) continue;
                min = ao.getMin();
            }
            for (i = 0; i < this.axes.size(); ++i) {
                ao = (AxisObject)this.axes.get(i);
                if (ao.isDiscrete()) {
                    ao.setValues(list1);
                } else {
                    ao.setAxisMax(max);
                    ao.setAxisMin(min);
                }
                ao.setViewport(0.0, 1.0);
                if (ao.isDiscrete() && this.numDiscreteAxes == 1 || !ao.isDiscrete() && this.numNumericAxes == 1) {
                    ao.setFormat((SASFormat)this.dataFilter.getFormat(ao.getVariable(), SASFormat.class));
                    continue;
                }
                ao.setFormat(null);
            }
        } else {
            for (int i = 0; i < this.axes.size(); ++i) {
                AxisObject ao = (AxisObject)this.axes.get(i);
                if (ao.isDiscrete()) {
                    ao.setValues(this.getUniqueValues(ao.getVariable()));
                } else {
                    ao.setAxisMin(ao.getMin());
                    ao.setAxisMax(ao.getMax());
                }
                ao.setViewport(0.0, 1.0);
                ao.setFormat((SASFormat)this.dataFilter.getFormat(ao.getVariable(), SASFormat.class));
            }
        }
        this.viewportXMin = this.dataXMin;
        this.viewportXMax = this.dataXMax;
        this.viewportYMin = this.dataYMin;
        this.viewportYMax = this.dataYMax;
        this.fireViewportChangeEvent();
        this.dataChanged = false;
        this.brushMode = false;
    }

    private void computeDataMinMax() {
        if (this.plotArea.width < 0 || this.plotArea.height < 0) {
            this.MIN = 0.0;
            this.MAX = this.axes.size() - 1;
        } else {
            double maxValue;
            double d = maxValue = this.plotType == 0 ? (double)(this.axes.size() - 1) : (double)this.axes.size();
            if (this.orientation == 0) {
                this.MIN = (double)(this.chartArea.x - this.plotArea.x) / (double)this.plotArea.width * maxValue;
                this.MAX = (double)(this.chartArea.x + this.chartArea.width - this.plotArea.x - this.plotArea.width) / (double)this.plotArea.width * maxValue + maxValue;
            } else {
                this.MIN = (double)(this.chartArea.y - this.plotArea.y) / (double)this.plotArea.height * maxValue;
                this.MAX = (double)(this.chartArea.y + this.chartArea.height - this.plotArea.y - this.plotArea.height) / (double)this.plotArea.height * maxValue + maxValue;
            }
        }
        this.zoomPanHandler.setMinimumViewportRange(2.0 / (this.MAX - this.MIN));
    }

    private void layoutAxes() {
        if (this.axes.size() == 1) {
            return;
        }
        if (this.chartArea.width <= 0 || this.chartArea.height <= 0) {
            return;
        }
        this.plotArea.x = this.chartArea.x + this.innerMargin.left;
        this.plotArea.y = this.chartArea.y + this.innerMargin.top;
        this.plotArea.width = this.chartArea.width - (this.innerMargin.left + this.innerMargin.right);
        this.plotArea.height = this.chartArea.height - (this.innerMargin.top + this.innerMargin.bottom);
        this.computeDataMinMax();
        double[] minMax = this.getViewportMinMax();
        this.currentAxisSpacing = this.axisSpacing;
        if (this.fitToScreen) {
            this.currentAxisSpacing = this.orientation == 0 ? (int)((double)this.chartArea.width / (minMax[1] - minMax[0])) : (int)((double)this.chartArea.height / (minMax[1] - minMax[0]));
        }
        for (int i = 0; i < this.axes.size(); ++i) {
            int currentVal = this.project(i);
            AxisObject ao = (AxisObject)this.axes.get(i);
            if (this.orientation == 0) {
                ao.setScreenArea(new Rectangle(currentVal, this.plotArea.y, this.currentAxisSpacing, this.plotArea.height));
                continue;
            }
            if (this.plotType == 0) {
                ao.setScreenArea(new Rectangle(this.plotArea.x, currentVal - this.currentAxisSpacing, this.plotArea.width, this.currentAxisSpacing));
                continue;
            }
            ao.setScreenArea(new Rectangle(this.plotArea.x, currentVal, this.plotArea.width, this.currentAxisSpacing));
        }
    }

    private void computeChartArea() {
        Rectangle oldArea = this.chartArea;
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        this.chartArea = this.graphLayout.getChartArea();
        if (this.chartArea.width <= 0 || this.chartArea.height <= 0) {
            return;
        }
        int minH = Math.min(150, this.compHeight);
        Dimension dim = new Dimension(this.compWidth, (int)Math.max((double)minH, (double)this.compHeight / (double)this.axes.size()));
        int halfWidth = (int)Math.ceil(0.5 * (double)this.lineWidth);
        int top = this.orientation == 0 ? halfWidth : 0;
        int bottom = this.orientation == 0 ? halfWidth : 0;
        int left = this.orientation == 0 ? 0 : halfWidth;
        int right = this.orientation == 0 ? 0 : halfWidth;
        int left_o = 0;
        int bottom_o = 0;
        this.tickValueOffset = 0;
        for (int i = 0; i < this.axes.size(); ++i) {
            AxisObject ao = (AxisObject)this.axes.get(i);
            ao.setDimension(dim);
            ao.setOrientation(this.orientation);
            ao.setScreenArea(this.chartArea);
            Insets m = ao.getMargin((Graphics2D)this.currentGC);
            if (this.orientation == 0) {
                if (i == 0) {
                    left = m.left;
                } else if (i == this.axes.size() - 1) {
                    right = this.equalizeAxes ? m.left : m.right;
                }
                top = Math.max(top, m.top);
                bottom = Math.max(bottom, m.bottom);
                bottom_o = Math.max(bottom_o, ao.getLabelHeight());
            } else {
                if (i == 0) {
                    top = this.equalizeAxes ? m.bottom : m.top;
                } else if (i == this.axes.size() - 1) {
                    bottom = m.bottom;
                }
                left = Math.max(left, m.left);
                right = Math.max(right, m.right);
                left_o = Math.max(left_o, ao.getLabelWidth());
            }
            this.tickValueOffset = Math.max(this.tickValueOffset, ao.getTickValueOffset((Graphics2D)this.currentGC));
        }
        if (this.plotType == 1) {
            if (this.orientation == 0) {
                top = Math.max(top, this.rangeSliderTrackBuffer);
                bottom = Math.max(bottom, this.rangeSliderTrackBuffer);
                left_o = Math.max(left_o, this.rangeSliderThumbSize);
            } else {
                left = Math.max(left, this.rangeSliderTrackBuffer);
                right = Math.max(right, this.rangeSliderTrackBuffer);
                bottom_o = Math.max(bottom_o, this.rangeSliderThumbSize);
            }
        }
        this.innerMargin.top = top;
        this.innerMargin.left = left;
        this.innerMargin.bottom = bottom;
        this.innerMargin.right = right;
        this.outerMargin.left = left_o;
        this.outerMargin.bottom = bottom_o;
        if (this.orientation == 0) {
            if (this.vScrollbarOn) {
                this.innerMargin.right = Math.max(this.silkDefaults.componentXMargin, right);
            }
            if (this.outerMargin.bottom > 0) {
                this.maxAxisLabelPercentage = (double)this.outerMargin.bottom / (double)this.compHeight;
                this.outerMargin.bottom = Math.min((int)Math.ceil((double)this.compHeight * this.axisLabelPercentage), this.outerMargin.bottom);
                this.outerMargin.bottom += this.silkDefaults.componentXMargin;
            }
        } else {
            if (this.hScrollbarOn) {
                this.innerMargin.top = Math.max(this.silkDefaults.componentXMargin, top);
            }
            if (this.outerMargin.left > 0) {
                this.maxAxisLabelPercentage = (double)this.outerMargin.left / (double)this.compWidth;
                this.outerMargin.left = Math.min((int)Math.ceil((double)this.compWidth * this.axisLabelPercentage), this.outerMargin.left);
                this.outerMargin.left += this.silkDefaults.componentXMargin;
            }
        }
        this.chartArea.x += this.outerMargin.left;
        this.chartArea.y += this.outerMargin.top;
        this.chartArea.width -= this.outerMargin.left + this.outerMargin.right;
        this.chartArea.height -= this.outerMargin.bottom + this.outerMargin.top;
        if (this.brushMode && this.rubberband != null) {
            double wRatio = (double)this.chartArea.width / (double)oldArea.width;
            double hRatio = (double)this.chartArea.height / (double)oldArea.height;
            this.rubberband.x = (int)((double)this.chartArea.x + (double)(this.rubberband.x - oldArea.x) * wRatio);
            this.rubberband.y = (int)((double)this.chartArea.y + (double)(this.rubberband.y - oldArea.y) * hRatio);
            this.rubberband.width = (int)((double)this.rubberband.width * wRatio);
            this.rubberband.height = (int)((double)this.rubberband.height * hRatio);
            this.createBrushHandleRects();
        }
        this.zoomPanAxis.setScreenArea(this.chartArea.x, this.chartArea.y, this.chartArea.width, this.chartArea.height);
    }

    private void loadDistributionPlots() {
        for (int i = 0; i < this.axes.size(); ++i) {
            double d2;
            double d1;
            int right;
            int left;
            AxisObject ao = (AxisObject)this.axes.get(i);
            if (ao.getDistribution() == null) {
                DistributionElement e = new DistributionElement();
                ao.setDistribution(e);
                Brush b = new Brush((Component)((Object)this));
                ao.setBrush(b);
            }
            Rectangle r = ao.getScreenArea();
            DistributionElement e = ao.getDistribution();
            e.setDataSource((Object)this.dataFilter);
            if (this.orientation == 0) {
                e.setRole(ao.getVariable(), (Object)RoleInterface.ROLE_Y);
                e.setBounds(r.x, r.y, r.width - this.tickValueOffset, r.height);
            } else {
                e.setRole(ao.getVariable(), (Object)RoleInterface.ROLE_X);
                e.setBounds(r.x, r.y + this.tickValueOffset, r.width, r.height - this.tickValueOffset);
            }
            ao.getBrush().connectToElement((BaseElement)e);
            ao.getBrush().setChartArea(r);
            ao.getAxis().addRedrawListener((RedrawListener)this);
            RangeModel rm = (RangeModel)ao.getAxis().getRangeModel(true);
            rm.setMinimum((Object)new Double(ao.getAxisMin()));
            rm.setMaximum((Object)new Double(ao.getAxisMax()));
            rm.setVisibleMinimum((Object)new Double(ao.getAxisMin()));
            rm.setVisibleMaximum((Object)new Double(ao.getAxisMax()));
            RangeSlider rangeSlider = ao.getAxis().getRangeSlider();
            ao.getAxis().setRangeSliderThumbSize(this.rangeSliderThumbSize);
            if (this.orientation == 0) {
                rangeSlider.setOrientation(1);
                rangeSlider.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                left = rangeSlider.getInsets().left + rangeSlider.getFocusInsets().left;
                right = rangeSlider.getInsets().right + rangeSlider.getFocusInsets().right;
                rangeSlider.setBounds(r.x - rangeSlider.getThumbSize().width, r.y - this.rangeSliderTrackBuffer - left, rangeSlider.getThumbSize().width, r.height + this.rangeSliderTrackBuffer * 2 + left + right);
                double max = (Double)rm.getMinimum();
                double min = (Double)rm.getMaximum();
                d1 = min * rm.getMultiplier();
                d2 = (double)r.height / ((max - min) * rm.getMultiplier());
                rangeSlider.setCalculation(this.rangeSliderTrackBuffer + 1, d1, d2);
                continue;
            }
            rangeSlider.setOrientation(0);
            rangeSlider.setComponentOrientation(ComponentOrientation.UNKNOWN);
            left = rangeSlider.getInsets().left + rangeSlider.getFocusInsets().left;
            right = rangeSlider.getInsets().right + rangeSlider.getFocusInsets().right;
            rangeSlider.setBounds(r.x - this.rangeSliderTrackBuffer - left, r.y + r.height, r.width + this.rangeSliderTrackBuffer * 2 + left + right, rangeSlider.getThumbSize().height);
            double min = (Double)rm.getMinimum();
            double max = (Double)rm.getMaximum();
            d1 = min * rm.getMultiplier();
            d2 = (double)r.width / ((max - min) * rm.getMultiplier());
            rangeSlider.setCalculation(this.rangeSliderTrackBuffer, d1, d2);
        }
        this.setEnableZoomPan(false);
    }

    private void drawDistributionPlots(Graphics g) {
        for (int i = 0; i < this.axes.size(); ++i) {
            AxisObject ao = (AxisObject)this.axes.get(i);
            ao.getDistribution().draw((Object)g, false);
        }
    }

    private void brushDistributionPlots(Graphics g) {
        for (int i = 0; i < this.axes.size(); ++i) {
            AxisObject ao = (AxisObject)this.axes.get(i);
            ao.getDistribution().draw((Object)g, true);
            ao.getBrush().draw(g);
        }
    }

    private void drawRangeSliderRanges(Graphics g) {
        for (int a = 0; a < this.axes.size(); ++a) {
            AxisObject ao = (AxisObject)this.axes.get(a);
            RangeModel rm = (RangeModel)ao.getAxis().getRangeModel(false);
            if (rm == null) {
                return;
            }
            Color defaultColor = new Color(255, 255, 0, 128);
            FillStyleElement fse = this.style.getFillStyleElement("RangeFill");
            if (fse != null) {
                defaultColor = fse.getFillColor();
            }
            double[] pvals = new double[3];
            double[] pvals1 = new double[3];
            Rectangle r = ao.getScreenArea();
            for (int i = 0; i < rm.ranges(); ++i) {
                LineStyleInterface lsi;
                ReferenceRange range = rm.getRangeAt(i);
                Object low = range.getLowValue();
                Object high = range.getHighValue();
                if (!(low instanceof Number) || !(high instanceof Number)) continue;
                Color c = range.getFillColor();
                if (c == null) {
                    c = defaultColor;
                }
                g.setColor(c);
                if (this.orientation == 0) {
                    ao.project(0.0, ((Number)low).doubleValue(), 0.0, pvals);
                    ao.project(0.0, ((Number)high).doubleValue(), 0.0, pvals1);
                    g.fillRect(r.x, (int)pvals1[1], r.width - this.tickValueOffset, (int)(pvals[1] - pvals1[1] + 1.0));
                    if (range.getLowInclusive()) {
                        lsi = range.getLowLine();
                        if (g instanceof Graphics2D) {
                            ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)lsi.getWidth(), (int)lsi.getPattern()));
                        }
                        g.setColor(lsi.getColor());
                        g.drawLine(r.x, (int)pvals[1], r.x + r.width - this.tickValueOffset, (int)pvals[1]);
                    }
                    if (!range.getHighInclusive()) continue;
                    lsi = range.getHighLine();
                    if (g instanceof Graphics2D) {
                        ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)lsi.getWidth(), (int)lsi.getPattern()));
                    }
                    g.setColor(lsi.getColor());
                    g.drawLine(r.x, (int)pvals1[1], r.x + r.width - this.tickValueOffset, (int)pvals1[1]);
                    continue;
                }
                ao.project(((Number)low).doubleValue(), 0.0, 0.0, pvals);
                ao.project(((Number)high).doubleValue(), 0.0, 0.0, pvals1);
                g.fillRect((int)pvals[0], r.y + this.tickValueOffset, (int)(pvals1[0] - pvals[0] + 1.0), r.height - this.tickValueOffset);
                if (range.getLowInclusive()) {
                    lsi = range.getLowLine();
                    if (g instanceof Graphics2D) {
                        ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)lsi.getWidth(), (int)lsi.getPattern()));
                    }
                    g.setColor(lsi.getColor());
                    g.drawLine((int)pvals[0], r.y + this.tickValueOffset, (int)pvals[0], r.y + r.height);
                }
                if (!range.getHighInclusive()) continue;
                lsi = range.getHighLine();
                if (g instanceof Graphics2D) {
                    ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)lsi.getWidth(), (int)lsi.getPattern()));
                }
                g.setColor(lsi.getColor());
                g.drawLine((int)pvals1[0], r.y + this.tickValueOffset, (int)pvals1[0], r.y + r.height);
            }
            ArrayList al = this.getSelectedDataRanges(ao.getVariable());
            if (al == null) continue;
            double[] rg = (double[])al.get(0);
            System.out.println("min = " + rg[0] + "  max = " + rg[1]);
        }
    }

    public ArrayList getSelectedDataRanges(Object variable) {
        ArrayList<double[]> al = null;
        AxisObject ao = null;
        for (int i = 0; i < this.axes.size() && !variable.equals((ao = (AxisObject)this.axes.get(i)).getVariable()); ++i) {
        }
        if (ao == null) {
            return null;
        }
        RangeModel rm = (RangeModel)ao.getAxis().getRangeModel(false);
        if (rm == null) {
            return null;
        }
        for (int i = 0; i < rm.ranges(); ++i) {
            ReferenceRange range = rm.getRangeAt(i);
            Object low = range.getLowValue();
            Object high = range.getHighValue();
            if (!(low instanceof Number) || !(high instanceof Number)) continue;
            double[] r = new double[]{((Number)low).doubleValue(), ((Number)high).doubleValue()};
            if (al == null) {
                al = new ArrayList<double[]>();
            }
            al.add(r);
        }
        return al;
    }

    public void redraw(RedrawEvent e) {
        this.axesHandler.syncAllAxes();
        this.rebuildRequired = true;
        this.repaint();
    }

    public void boundingBoxChanged(RedrawEvent e) {
    }

    public void outerMarginChanged(RedrawEvent e) {
    }

    private int project(double value) {
        double[] minMax = this.getViewportMinMax();
        if (this.orientation == 0) {
            return (int)(minMax[1] == minMax[0] ? (double)this.plotArea.x : (double)this.chartArea.width * (value - minMax[0]) / (minMax[1] - minMax[0]) + (double)this.chartArea.x);
        }
        return (int)(minMax[1] == minMax[0] ? (double)this.plotArea.y : (double)this.chartArea.height * (value - minMax[0]) / (minMax[1] - minMax[0]) + (double)this.chartArea.y);
    }

    private double[] getViewportMinMax() {
        double[] minMax = new double[2];
        if (this.orientation == 0) {
            minMax[0] = this.MIN + this.viewportXMin * (this.MAX - this.MIN);
            minMax[1] = this.MIN + this.viewportXMax * (this.MAX - this.MIN);
        } else {
            minMax[0] = this.MIN + (1.0 - this.viewportYMax) * (this.MAX - this.MIN);
            minMax[1] = this.MIN + (1.0 - this.viewportYMin) * (this.MAX - this.MIN);
        }
        return minMax;
    }

    protected void doResize(int compWidthIn, int compHeightIn) {
        if (compWidthIn <= 0 || compHeightIn <= 0) {
            return;
        }
        if (compWidthIn == this.compWidth && compHeightIn == this.compHeight) {
            return;
        }
        super.doResize(compWidthIn, compHeightIn);
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        this.rebuildRequired = true;
        this.repaint();
    }

    private boolean insertAxis(AxisObject axis, int index) {
        int i;
        int oldIndex;
        if (axis == null || index < 0 || index > this.axes.size()) {
            return false;
        }
        if (this.equalizeAxes) {
            index = axis.isDiscrete() ? Math.max(Math.min(this.numDiscreteAxes, index), 0) : Math.max(Math.min(this.axes.size(), index), this.numDiscreteAxes);
        }
        if ((oldIndex = this.axes.indexOf(axis)) < index) {
            if (oldIndex == index - 1) {
                this.repaint();
                return true;
            }
            for (i = oldIndex + 1; i <= index - 1; ++i) {
                this.axes.set(i - 1, this.axes.get(i));
            }
            this.axes.set(index - 1, axis);
        } else {
            if (oldIndex == index) {
                this.repaint();
                return true;
            }
            for (i = oldIndex - 1; i >= index; --i) {
                this.axes.set(i + 1, this.axes.get(i));
            }
            this.axes.set(index, axis);
        }
        Vector<Object> v = new Vector<Object>();
        for (int i2 = 0; i2 < this.axes.size(); ++i2) {
            AxisObject ao = (AxisObject)this.axes.get(i2);
            v.add(ao.getVariable());
        }
        this.roles.setVariableOrder((Object)RoleInterface.ROLE_AXIS, v);
        this.rebuildRequired = true;
        this.repaint();
        return true;
    }

    public boolean areAxesEqualized() {
        return this.equalizeAxes;
    }

    public void setEqualizeAxes(boolean b) {
        if (this.equalizeAxes == b) {
            return;
        }
        this.equalizeAxes = b;
        this.userSetProperties.set(801);
        this.dataChanged = true;
        this.repaint();
    }

    public boolean areMissingValuesSkipped() {
        return this.skipMissingValues;
    }

    public void setSkipMissingValues(boolean b) {
        if (this.skipMissingValues == b) {
            return;
        }
        this.skipMissingValues = b;
        this.userSetProperties.set(807);
        this.dataChanged = true;
        this.repaint();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean setOrientation(int i) {
        if (i != 0 && i != 1) {
            return false;
        }
        if (this.orientation == i) {
            return true;
        }
        this.orientation = i;
        this.userSetProperties.set(806);
        if (this.menu != null) {
            if (this.getOrientation() == 0) {
                MenuUtilities.setMenuItemSelected((JPopupMenu)this.menu, (String)"CHART_TYPE_HORIZONTAL", (boolean)true);
            } else {
                MenuUtilities.setMenuItemSelected((JPopupMenu)this.menu, (String)"CHART_TYPE_VERTICAL", (boolean)true);
            }
        }
        this.zoomPanAxis.setDirection(this.orientation == 0);
        this.resetViewport();
        return false;
    }

    public boolean isFitToScreen() {
        return this.fitToScreen;
    }

    public void setFitToScreen(boolean fit) {
        this.fitToScreen = fit;
    }

    public int getAxisSpacing() {
        return this.axisSpacing;
    }

    public boolean setAxisSpacing(int space) {
        if (space < 0) {
            return false;
        }
        this.axisSpacing = space;
        return true;
    }

    public double getLineOpacity() {
        return this.lineOpacity;
    }

    public boolean setLineOpacity(double o) {
        if (o < 0.0 || o > 1.0) {
            return false;
        }
        this.lineOpacity = o;
        this.userSetProperties.set(802);
        if (this.legend != null) {
            this.setupLegend();
        }
        this.redrawBackBuffer = true;
        this.repaint();
        return true;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public boolean setLineWidth(int w) {
        if (w < 1) {
            return false;
        }
        this.lineWidth = w;
        this.userSetProperties.set(803);
        this.redrawBackBuffer = true;
        this.repaint();
        return true;
    }

    public double getAxisLabelPercentage() {
        return this.axisLabelPercentage;
    }

    public boolean setAxisLabelPercentage(double percentage) {
        if (percentage < 0.0) {
            return false;
        }
        this.axisLabelPercentage = percentage;
        return true;
    }

    public boolean isEndPointSelection() {
        return this.endPointSelection;
    }

    public void setEndpointSelection(boolean b) {
        this.endPointSelection = b;
    }

    private void setEnableZoomPan(boolean enabled) {
        if (this.zoomPanHandler != null) {
            this.zoomPanHandler.setZoomPanEnabled(enabled);
        }
        for (int i = 0; i < this.axes.size(); ++i) {
            AxisZoomPanHandler hd = ((AxisObject)this.axes.get(i)).getZoomPanHandler();
            if (hd == null) continue;
            hd.setZoomPanEnabled(enabled);
        }
    }

    protected void fireViewportChangeEvent() {
        ViewportEvent evt = new ViewportEvent((Object)this, 1, this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax, 0.0, 0.0);
        for (int i = 0; i < this.viewportListeners.size(); ++i) {
            ((ViewportListenerInterface)this.viewportListeners.get(i)).viewportChanged(evt);
        }
    }

    public void viewportChanged(ViewportEvent evt) {
        if (evt.source == this.zoomPanHandler) {
            if (this.orientation == 0) {
                this.setViewport(1, 1, evt.xMin, evt.xMax);
            } else {
                this.setViewport(1, 2, evt.yMin, evt.yMax);
            }
        } else if (evt.source instanceof AxisObject && this.equalizeAxes) {
            boolean bl = this.panning = this.activeHandler != null && this.activeHandler.getCurrentZoomPanStatus() == 0;
            if (this.orientation == 0) {
                this.setViewport(1, 2, evt.yMin, evt.yMax);
            } else {
                this.setViewport(1, 1, evt.xMin, evt.xMax);
            }
        }
        this.rebuildRequired = true;
        this.repaint();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        int oldWidth = this.compWidth;
        int oldHeight = this.compHeight;
        boolean backOn = this.useBackBuffer;
        this.useBackBuffer = false;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Rectangle bounds = this.getBounds();
        double width = pageFormat.getImageableWidth();
        double height = pageFormat.getImageableHeight();
        double s_aspect = (double)bounds.width / (double)bounds.height;
        double p_aspect = width / height;
        double p_width = width;
        double p_height = height;
        if (p_aspect <= 1.0) {
            if (s_aspect < 1.0 && s_aspect < p_aspect) {
                p_width = height * s_aspect;
            } else {
                p_height = width / s_aspect;
            }
        } else if (s_aspect > 1.0 && s_aspect > p_aspect) {
            p_height = width / s_aspect;
        } else {
            p_width = height * s_aspect;
        }
        this.doResize((int)p_width, (int)p_height);
        float tx = (float)((width - p_width) * 0.5);
        float ty = (float)((height - p_height) * 0.5);
        g2.translate(tx, ty);
        g2.setClip(0, 0, (int)p_width, (int)p_height);
        this.paint(graphics);
        this.useBackBuffer = backOn;
        this.doResize(oldWidth, oldHeight);
        return 0;
    }

    public void setPlotType(int type) {
        this.plotType = type;
    }

    public boolean getAxesVisible() {
        return false;
    }

    public boolean getMarginsAligned() {
        return false;
    }

    public int getNumRanges(byte dim) {
        return 0;
    }

    public DataRangeInterface getRangeSource(byte dim, int index) {
        return this;
    }

    public void setAxesVisible(boolean axesVisible) {
    }

    public void setRange(byte dim, int index, DataRange range) {
        if (dim == 4) {
            this.setupLegend();
            this.redrawBackBuffer = true;
            this.repaint();
        }
    }

    public void addMarginListener(MarginListener listener) {
    }

    public void removeMarginListener(MarginListener listener) {
    }

    public void disableMarginPrefCalc() {
    }

    public void enableMarginPrefCalc() {
    }

    public Insets getInnerMargin() {
        return null;
    }

    public Insets getOuterMargin() {
        return null;
    }

    public Insets getPreferredInnerMargin() {
        return null;
    }

    public Insets getPreferredOuterMargin() {
        return null;
    }

    public void setInnerMargin(Insets margin) {
    }

    public void setOuterMargin(Insets margin) {
    }

    public DataRange getDataRange(byte dimension) {
        if (dimension == 4) {
            if (this.colorMinMax == null || this.colorMinMax.length != 2) {
                return null;
            }
            return new ContinuousRange(this.colorMinMax[0], this.colorMinMax[1]);
        }
        return null;
    }

    public void addRangeChangeListener(RangeChangeListener l) {
        if (this.rangeChangeListeners == null) {
            this.rangeChangeListeners = new Vector();
        }
        if (l != null) {
            this.rangeChangeListeners.addElement(l);
        }
    }

    public void removeRangeChangeListener(RangeChangeListener l) {
        if (this.rangeChangeListeners != null) {
            this.rangeChangeListeners.removeElement(l);
        }
    }

    protected void fireRangeChangeEvent(RangeChangedEvent evt) {
        if (this.rangeChangeListeners == null) {
            return;
        }
        Enumeration e = this.rangeChangeListeners.elements();
        while (e.hasMoreElements()) {
            ((RangeChangeListener)e.nextElement()).rangeChanged(evt);
        }
    }
}

