/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.silk.SILKXYComponent;
import com.sas.graphics.silk.event.LayerChangedEvent;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.LayerInterface;
import com.sas.graphics.silk.interfaces.LayerListenerInterface;
import com.sas.graphics.silk.interfaces.LegendEntryInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.interfaces.ViewportInterface;
import com.sas.graphics.silk.ui.ClassicOverlayPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.LegendPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.AxisComponent;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKChartFlavor;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.tools.wizard.WizardEntry;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class OverlayComponent
extends SILKXYComponent
implements ActionListener,
DropTargetListener,
LayerListenerInterface {
    private static final long serialVersionUID = 1L;
    private Vector marginInterfaces = new Vector();
    protected JPopupMenu menu = null;
    protected boolean doAccurateSelection = false;
    private Rectangle previousRect = new Rectangle();
    private Image backBuffer = null;
    private boolean invalid = true;
    private Vector pendingDeletedCharts = new Vector();
    private LegendObjectJ2D legend = null;
    private Vector layers = new Vector();

    public OverlayComponent() {
        this.setLayout(null);
        this.setColorScheme(SILKGlobal.getInstance().getPropertyValue(0));
        this.marginInterfaces.addElement(this);
        this.menu = MenuUtilities.getPopupMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/StandardMenu.xml"), (ActionListener)this);
        new DropTarget((Component)((Object)this), this);
        this.legend = new LegendObjectJ2D();
        this.legend.setPosition(2);
        this.legend.setVisible(true);
        this.graphLayout.addLegend((LegendInterface)this.legend);
    }

    private void buildLegend() {
        if (this.getCharts() == null || this.getCharts().length == 0) {
            if (this.legend != null) {
                this.graphLayout.removeLegend((LegendInterface)this.legend);
            }
            return;
        }
        if (!this.graphLayout.containsLegend((Object)this.legend)) {
            this.graphLayout.addLegend((LegendInterface)this.legend);
        }
        LayerInterface[] l = this.getCharts();
        Vector entries = new Vector();
        for (int i = 0; i < l.length; ++i) {
            if (!(l[i] instanceof PropertyInterface)) continue;
            PropertyInterface chart = (PropertyInterface)l[i];
            Object le = chart.getPropertyValue(433);
            Enumeration e = Extract.elements((Object)le);
            while (e.hasMoreElements()) {
                entries.addElement(e.nextElement());
            }
        }
        Object[] arr = new LegendEntry[entries.size()];
        entries.copyInto(arr);
        this.legend.setValues((LegendEntryInterface[])arr, false);
        if (this.graphLayout != null) {
            this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        }
    }

    public String getToolTipText(MouseEvent me) {
        LayerInterface listener;
        if (!this.tipsOn) {
            return null;
        }
        String rc = null;
        Enumeration listeners = this.layers.elements();
        while (listeners.hasMoreElements() && ((rc = (listener = (LayerInterface)listeners.nextElement()).getTipText(me.getX(), me.getY())) == null || rc.trim().length() <= 0)) {
        }
        return rc;
    }

    public Object getChart(Object id) {
        return this.getLayerById(id);
    }

    public void roleChanged(RoleEvent arg0) {
        super.roleChanged(arg0);
        this.setRange((byte)1, 0, null);
        this.setRange((byte)2, 0, null);
        this.setRange((byte)1, 1, null);
        this.setRange((byte)2, 1, null);
        this.buildAndDraw(null, null, null);
    }

    public boolean addLayer(LayerInterface listener) {
        if (listener == null || listener == this) {
            return false;
        }
        if (listener instanceof ComponentInterface) {
            ComponentInterface comp = (ComponentInterface)listener;
            comp.setStyle((Object)this.style);
        }
        if (listener instanceof GraphInterface) {
            ((GraphInterface)listener).setActionMode(this.actionMode);
        }
        if (listener instanceof ComponentInterface && ((ComponentInterface)listener).getId() == null) {
            ((ComponentInterface)listener).setId((Object)("Chart_" + this.layers.size()));
        }
        if (listener instanceof CellItemInterface) {
            this.mergeAxes((CellItemInterface)listener);
        }
        if (listener instanceof RoleInterface) {
            ((RoleInterface)listener).addRoleListener((RoleListenerInterface)this);
        }
        if (listener instanceof PropertyInterface) {
            ((PropertyInterface)listener).setPropertyValue(34, (Object)new Boolean(false));
            ((PropertyInterface)listener).applyPropertyChanges();
        }
        if (listener instanceof JComponent && listener != this) {
            this.add((JComponent)listener);
            MouseListener[] ml = ((JComponent)listener).getMouseListeners();
            for (int i = 0; i < ml.length; ++i) {
                ((JComponent)listener).removeMouseListener(ml[i]);
            }
        }
        this.layers.addElement(listener);
        listener.addLayerListener((LayerListenerInterface)this);
        this.invalid = true;
        return true;
    }

    public boolean removeLayer(LayerInterface listener) {
        listener.removeLayerListener((LayerListenerInterface)this);
        return this.layers.remove(listener);
    }

    public LayerInterface[] getCharts() {
        Enumeration e = this.layers.elements();
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        Object[] rc = new LayerInterface[v.size()];
        v.copyInto(rc);
        return rc;
    }

    protected void paintChildren(Graphics g) {
    }

    protected void buildBackBuffer() {
        if (this.compWidth <= 0 || this.compHeight <= 0 || !this.isUsingBackBuffer()) {
            return;
        }
        if (this.backBuffer == null) {
            this.backBuffer = this.createImage(this.compWidth, this.compHeight);
        }
        Graphics2D g = (Graphics2D)this.backBuffer.getGraphics();
        this.drawChart(g);
        this.invalid = false;
    }

    protected void paintComponent(Graphics g) {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.legend != null && this.legend.isUpdateRequired()) {
            this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
            this.invalid = true;
        }
        if (this.isUsingBackBuffer()) {
            if (this.invalid || this.backBuffer == null) {
                this.buildBackBuffer();
            }
            g.drawImage(this.backBuffer, 0, 0, null);
        } else {
            this.drawChart(g2);
        }
        this.drawAxisZoomPanIndicators(g);
        if (this.doAccurateSelection) {
            this.drawChartLayers(g2);
        } else {
            this.drawSelections(g2);
        }
        this.drawBrush(g2);
        this.warningIcon.draw(g);
    }

    public void drawChartLayers(Graphics g) {
        Enumeration listeners = this.layers.elements();
        while (listeners.hasMoreElements()) {
            LayerInterface listener = (LayerInterface)listeners.nextElement();
            Shape oldClipRegion = g.getClip();
            g.setClip(this.dataRegion);
            listener.drawLayer(g);
            g.setClip(oldClipRegion);
            if (!this.doAccurateSelection || !listener.isSelectable()) continue;
            listener.drawLayerSelections(g);
        }
    }

    public void drawSelections(Graphics g) {
        Enumeration listeners = this.layers.elements();
        while (listeners.hasMoreElements()) {
            LayerInterface listener = (LayerInterface)listeners.nextElement();
            if (!listener.isSelectable()) {
                return;
            }
            Shape oldClipRegion = null;
            oldClipRegion = g.getClip();
            g.setClip(this.dataRegion);
            listener.drawLayerSelections(g);
            g.setClip(oldClipRegion);
        }
    }

    public void drawChart(Graphics g) {
        if (this.background != null && g instanceof Graphics2D) {
            this.background.drawBackground((Graphics2D)g, (Component)((Object)this));
        }
        if (g instanceof Graphics2D) {
            this.drawWall((Graphics2D)g);
        }
        this.drawAxes(g);
        this.drawReferenceLines(g);
        this.graphLayout.draw(g);
        if (!this.doAccurateSelection) {
            this.drawChartLayers(g);
        }
    }

    private void mergeMargins(MarginInterface margin) {
        MarginInterface m;
        if (!this.marginInterfaces.contains(margin)) {
            this.marginInterfaces.addElement(margin);
        }
        this.computeInnerOuterMargin();
        Enumeration e = this.marginInterfaces.elements();
        while (e.hasMoreElements()) {
            m = (MarginInterface)e.nextElement();
            Insets inner = m.getInnerMargin();
            if (inner == null) continue;
            if (this.innerMargin.top < inner.top) {
                this.innerMargin.top = inner.top;
            }
            if (this.innerMargin.left < inner.left) {
                this.innerMargin.left = inner.left;
            }
            if (this.innerMargin.bottom < inner.bottom) {
                this.innerMargin.bottom = inner.bottom;
            }
            if (this.innerMargin.right >= inner.right) continue;
            this.innerMargin.right = inner.right;
        }
        e = this.marginInterfaces.elements();
        while (e.hasMoreElements()) {
            m = (MarginInterface)e.nextElement();
            if (m == this) continue;
            m.setInnerMargin(new Insets(this.innerMargin.top, this.innerMargin.left, this.innerMargin.bottom, this.innerMargin.right));
            m.setOuterMargin(new Insets(this.outerMargin.top, this.outerMargin.left, this.outerMargin.bottom, this.outerMargin.right));
        }
    }

    public void setInnerMargin(Insets margin) {
        this.innerMargin = margin;
        this.buildAndDraw(null, null, null);
    }

    public void setOuterMargin(Insets margin) {
        this.outerMargin = margin;
        this.buildAndDraw(null, null, null);
    }

    private void mergeAxes(CellItemInterface chart) {
        OverlayComponent baseAxis = this;
        boolean useY2Axis = false;
        boolean useX2Axis = false;
        if (baseAxis instanceof GraphInterface && chart instanceof GraphInterface) {
            AxisInterface yAxis1;
            AxisInterface xAxis1;
            int xMapping = ((LayerInterface)chart).getXAxisMapping();
            int yMapping = ((LayerInterface)chart).getYAxisMapping();
            if (xMapping == 3) {
                useX2Axis = true;
            }
            if (yMapping == 4) {
                useY2Axis = true;
            }
            AxisInterface baseXAxis = useX2Axis ? ((GraphInterface)baseAxis).getAxis((Object)"X2") : ((GraphInterface)baseAxis).getAxis((Object)"X");
            AxisInterface baseYAxis = useY2Axis ? ((GraphInterface)baseAxis).getAxis((Object)"Y2") : ((GraphInterface)baseAxis).getAxis((Object)"Y");
            AxisInterface chartXAxis = ((GraphInterface)chart).getAxis((Object)"X");
            AxisInterface chartYAxis = ((GraphInterface)chart).getAxis((Object)"Y");
            AxisInterface axisInterface = xAxis1 = baseXAxis instanceof AxisComponent ? ((AxisComponent)baseXAxis).getInternalAxis() : baseXAxis;
            if (xAxis1 instanceof RoleInterface && chartXAxis instanceof RoleInterface) {
                if (((SourceInterface)xAxis1).getDataSource() == null) {
                    ((SourceInterface)xAxis1).setDataSource(((SourceInterface)chartXAxis).getDataSource());
                }
                if (((RoleInterface)xAxis1).getVariable(null) == null) {
                    ((RoleInterface)xAxis1).setRole(((RoleInterface)chartXAxis).getVariable(null), (Object)RoleInterface.ROLE_X);
                }
            }
            AxisInterface axisInterface2 = yAxis1 = baseYAxis instanceof AxisComponent ? ((AxisComponent)baseYAxis).getInternalAxis() : baseYAxis;
            if (yAxis1 instanceof RoleInterface && chartYAxis instanceof RoleInterface) {
                if (((SourceInterface)yAxis1).getDataSource() == null) {
                    ((SourceInterface)yAxis1).setDataSource(((SourceInterface)chartYAxis).getDataSource());
                }
                if (((RoleInterface)yAxis1).getVariable(null) == null) {
                    ((RoleInterface)yAxis1).setRole(((RoleInterface)chartYAxis).getVariable(null), (Object)RoleInterface.ROLE_Y);
                }
            }
        } else if (baseAxis instanceof GraphInterface) {
            AxisInterface xAxis = ((GraphInterface)baseAxis).getAxis((Object)"X");
            xAxis.setLabel(null);
            AxisInterface yAxis = ((GraphInterface)baseAxis).getAxis((Object)"Y");
            yAxis.setLabel(null);
        }
        int xDataRangeType = 1;
        int yDataRangeType = 1;
        if (chart instanceof LayerInterface) {
            xDataRangeType = ((LayerInterface)chart).getDataRangeType((byte)1);
            yDataRangeType = ((LayerInterface)chart).getDataRangeType((byte)2);
        }
        DataRangeInterface rangeSource1 = this.getRangeSource((byte)1, useX2Axis ? 1 : 0);
        DataRangeInterface rangeSource2 = chart.getRangeSource((byte)1, 0);
        DataRange dr = null;
        boolean clearX = true;
        for (int i = 0; i < this.layers.size(); ++i) {
            clearX = false;
            LayerInterface layer = (LayerInterface)this.layers.elementAt(i);
            if (!(layer instanceof CellItemInterface)) continue;
            if (!useX2Axis) {
                if (layer == chart && layer.getXAxisMapping() == 0) {
                    clearX = true;
                    continue;
                }
                if (layer.getXAxisMapping() != 0) continue;
                break;
            }
            if (layer == chart && layer.getXAxisMapping() == 3) {
                clearX = true;
                continue;
            }
            if (layer.getXAxisMapping() == 3) break;
        }
        dr = this.hasViewport ? rangeSource1.getDataRange((byte)1) : (xDataRangeType != 1 ? rangeSource1.getDataRange((byte)1) : (clearX ? rangeSource2.getDataRange((byte)1) : OverlayComponent.mergeRange((DataRange)rangeSource1.getDataRange((byte)1), (DataRange)rangeSource2.getDataRange((byte)1))));
        this.setRange((byte)1, useX2Axis ? 1 : 0, dr);
        DataRange outputRange = rangeSource1.getDataRange((byte)1);
        chart.setRange((byte)1, 0, outputRange);
        this.setRangeOnCharts((byte)1, useX2Axis ? 1 : 0, outputRange);
        rangeSource1 = this.getRangeSource((byte)2, useY2Axis ? 1 : 0);
        rangeSource2 = chart.getRangeSource((byte)2, 0);
        dr = null;
        boolean clearY = false;
        for (int i = 0; i < this.layers.size(); ++i) {
            LayerInterface layer = (LayerInterface)this.layers.elementAt(i);
            if (!(layer instanceof CellItemInterface)) continue;
            if (!useY2Axis) {
                if (layer == chart && layer.getYAxisMapping() == 1) {
                    clearX = true;
                    continue;
                }
                if (layer.getYAxisMapping() != 1) continue;
                break;
            }
            if (layer == chart && layer.getYAxisMapping() == 4) {
                clearX = true;
                continue;
            }
            if (layer.getYAxisMapping() == 4) break;
        }
        dr = this.hasViewport ? rangeSource1.getDataRange((byte)2) : (yDataRangeType != 1 ? rangeSource1.getDataRange((byte)2) : (clearY ? rangeSource2.getDataRange((byte)2) : OverlayComponent.mergeRange((DataRange)rangeSource1.getDataRange((byte)2), (DataRange)rangeSource2.getDataRange((byte)2))));
        this.setRange((byte)2, useY2Axis ? 1 : 0, dr);
        outputRange = rangeSource1.getDataRange((byte)2);
        chart.setRange((byte)2, 0, outputRange);
        this.setRangeOnCharts((byte)2, useY2Axis ? 1 : 0, outputRange);
        if (this.hasXAxis) {
            this.getAxis("X").setLabel(this.getAxisLabel("X", 0));
        }
        if (this.hasYAxis) {
            this.getAxis("Y").setLabel(this.getAxisLabel("Y", 1));
        }
        if (this.hasX2Axis) {
            this.getAxis("X2").setLabel(this.getAxisLabel("X", 3));
        }
        if (this.hasY2Axis) {
            this.getAxis("Y2").setLabel(this.getAxisLabel("Y", 4));
        }
        this.marginChanged(new MarginChangeEvent((Object)this));
    }

    private Object getAxisLabel(Object which, int mapping) {
        Object label = null;
        Enumeration e = this.layers.elements();
        while (e.hasMoreElements()) {
            LayerInterface l = (LayerInterface)e.nextElement();
            if (which.equals("X") && l.getXAxisMapping() != mapping || which.equals("Y") && l.getYAxisMapping() != mapping) continue;
            Object lbl = null;
            if (l instanceof GraphInterface && ((GraphInterface)l).getAxis(which) != null) {
                lbl = ((GraphInterface)l).getAxis(which).getLabelString();
            }
            if (label == null) {
                label = lbl;
                continue;
            }
            if (label.equals(lbl)) continue;
            label = null;
            break;
        }
        return label;
    }

    private void setRangeOnCharts(byte dim, int index, DataRange range) {
        Enumeration listeners = this.layers.elements();
        while (listeners.hasMoreElements()) {
            int mapping;
            Object id;
            Object obj = listeners.nextElement();
            if (obj == null || !(obj instanceof CellItemInterface)) continue;
            if (index == 1) {
                id = null;
                if (obj instanceof ComponentInterface) {
                    id = ((ComponentInterface)obj).getId();
                }
                if (id == null || (dim == 1 ? (mapping = ((LayerInterface)obj).getXAxisMapping()) != 3 : dim == 2 && (mapping = ((LayerInterface)obj).getYAxisMapping()) != 4)) {
                    continue;
                }
            } else if (index == 0) {
                id = null;
                if (obj instanceof ComponentInterface) {
                    id = ((ComponentInterface)obj).getId();
                }
                if (id == null || (dim != 1 ? dim == 2 && (mapping = ((LayerInterface)obj).getYAxisMapping()) != 1 : (mapping = ((LayerInterface)obj).getXAxisMapping()) != 0)) continue;
            }
            if (this.hasViewport && obj instanceof ViewportInterface && range instanceof ContinuousRange) {
                ContinuousRange cr = (ContinuousRange)range;
                ((ViewportInterface)obj).setViewport(1, (int)dim, cr.getMin(), cr.getMax());
                continue;
            }
            ((CellItemInterface)obj).setRange(dim, 0, range);
        }
    }

    public void marginChanged(MarginChangeEvent e) {
        if (!this.inMarginChanged || e.getSource() != this) {
            super.marginChanged(e);
        }
        Enumeration listeners = this.layers.elements();
        while (listeners.hasMoreElements()) {
            LayerInterface listener = (LayerInterface)listeners.nextElement();
            if (!(listener instanceof MarginListener)) continue;
            ((MarginListener)listener).marginChanged(e);
        }
    }

    protected void doResize(int compWidthIn, int compHeightIn) {
        if (compHeightIn == this.compHeight && compWidthIn == this.compWidth) {
            return;
        }
        super.doResize(compWidthIn, compHeightIn);
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        this.buildAndDraw(new Boolean(true), null, null);
    }

    protected void doPicking(Rectangle region, MouseEvent event) {
        Object listener;
        Enumeration e = null;
        if (this.actionMode != 9) {
            e = this.layers.elements();
            while (e.hasMoreElements()) {
                listener = e.nextElement();
                if (!((LayerInterface)listener).isSelectable()) continue;
                ((LayerInterface)listener).selectInLayer(false, (Object)this.previousRect, event);
            }
        }
        e = this.layers.elements();
        while (e.hasMoreElements()) {
            if (this.actionMode == 9) {
                listener = e.nextElement();
                if (!(listener instanceof ComponentInterface) || !((ComponentInterface)listener).isEditable()) continue;
                ((LayerInterface)listener).selectInLayer(true, (Object)this.previousRect, event);
                continue;
            }
            listener = e.nextElement();
            if (!((LayerInterface)listener).isSelectable()) continue;
            ((LayerInterface)listener).selectInLayer(true, (Object)region, event);
        }
        if (region != null) {
            this.previousRect.setBounds(region);
        } else {
            this.previousRect.setBounds(0, 0, 0, 0);
        }
        this.repaint();
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        if (id == null || dialogIn == null) {
            return false;
        }
        if (id.equals("Properties")) {
            if (dialogIn instanceof TabbedPropertiesDialog) {
                boolean graph = false;
                boolean chart = false;
                boolean legend = false;
                boolean titles = false;
                boolean axes = false;
                switch (category) {
                    case 0: {
                        graph = true;
                        break;
                    }
                    case 1: {
                        chart = true;
                        break;
                    }
                    case 3: {
                        legend = true;
                        break;
                    }
                    case 2: {
                        axes = true;
                        break;
                    }
                    case 4: {
                        titles = true;
                        break;
                    }
                    case 999: {
                        titles = true;
                        legend = true;
                        axes = true;
                        chart = true;
                        graph = true;
                    }
                }
                TabbedPropertiesDialog tpd = (TabbedPropertiesDialog)dialogIn;
                TabPanelInterface tpi = null;
                if (graph) {
                    super.addTabs(id, dialogIn, 0, listener);
                }
                if (chart) {
                    ClassicOverlayPanel pan = new ClassicOverlayPanel();
                    pan.addPropertyListener((PropertyInterface)this);
                    tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"OverlayComponent.Charts.txt", (String)"Charts"), (TabPanelInterface)pan);
                }
                if (axes) {
                    super.addTabs(id, dialogIn, 2, listener);
                }
                if (legend) {
                    tpi = tpd.getTab(LegendPanel.class);
                    if (tpi != null) {
                        tpi.addPropertyListener((PropertyInterface)this);
                    } else {
                        tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"OverlayComponent.Legend.txt", (String)"Legend"), (TabPanelInterface)new LegendPanel((PropertyInterface)this));
                    }
                }
                if (titles) {
                    super.addTabs(id, dialogIn, 4, listener);
                }
            } else if (dialogIn instanceof GraphPropertiesDialog) {
                boolean graph = false;
                boolean chart = false;
                boolean legend = false;
                boolean titles = false;
                boolean axes = false;
                switch (category) {
                    case 0: {
                        graph = true;
                        break;
                    }
                    case 1: {
                        chart = true;
                        break;
                    }
                    case 3: {
                        legend = true;
                        break;
                    }
                    case 2: {
                        axes = true;
                        break;
                    }
                    case 4: {
                        titles = true;
                        break;
                    }
                    case 999: {
                        titles = true;
                        legend = true;
                        axes = true;
                        chart = true;
                        graph = true;
                    }
                }
                GraphPropertiesDialog gpd = (GraphPropertiesDialog)dialogIn;
                if (graph) {
                    super.addTabs(id, dialogIn, 0, listener);
                }
                if (chart) {
                    ClassicOverlayPanel pan = new ClassicOverlayPanel();
                    pan.addPropertyListener((PropertyInterface)this);
                    gpd.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"OverlayComponent.Charts.txt", (String)"Charts"), (Component)pan);
                }
                if (axes) {
                    super.addTabs(id, dialogIn, 2, listener);
                }
                if (legend) {
                    gpd.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"OverlayComponent.Legend.txt", (String)"Legend"), (Component)new LegendPanel((PropertyInterface)this));
                }
                if (titles) {
                    super.addTabs(id, dialogIn, 4, listener);
                }
            }
        }
        return false;
    }

    protected void buildPropertiesDialog(Object listner) {
        if (this.propertiesDialog != null) {
            return;
        }
        this.createPropertyDialog(listner);
        this.propertiesDialog.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"Overlay.Overlay_Properties.txt", (String)"Overlay Properties"));
        this.addTabs("Properties", (Dialog)this.propertiesDialog, 999, listner);
        this.propertiesDialog.setSelectedNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"OverlayComponent.Charts.txt", (String)"Charts"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        this.handleMenuCommand(actionCommand);
    }

    public void mousePressed(MouseEvent me) {
        int flags = me.getModifiers();
        AxisComponent ac = this.getAxisForPoint(me.getPoint());
        if (ac == null && this.menu != null && (flags & 4) != 0 && this.allowPopup) {
            int x = me.getX();
            int y = me.getY();
            this.menu.show((Component)((Object)this), x, y);
        } else {
            super.mousePressed(me);
        }
    }

    public void mouseReleased(MouseEvent me) {
        super.mouseReleased(me);
        if (this.actionMode == 9) {
            this.buildAndDraw(null, null, null);
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.menu;
    }

    private void handleJComponents() {
        Enumeration listeners = this.layers.elements();
        this.hasY2Axis = false;
        this.hasX2Axis = false;
        this.hasYAxis = false;
        this.hasXAxis = false;
        while (listeners.hasMoreElements()) {
            LayerInterface listener = (LayerInterface)listeners.nextElement();
            if (listener instanceof JComponent) {
                this.add((JComponent)listener);
                MouseListener[] ml = ((JComponent)listener).getMouseListeners();
                for (int i = 0; i < ml.length; ++i) {
                    ((JComponent)listener).removeMouseListener(ml[i]);
                }
                MouseMotionListener[] mml = ((JComponent)listener).getMouseMotionListeners();
                for (int i = 0; i < mml.length; ++i) {
                    ((JComponent)listener).removeMouseMotionListener(mml[i]);
                }
            }
            if (!(listener instanceof JComponent)) continue;
            ((JComponent)listener).setSize(this.compWidth, this.compHeight);
        }
    }

    public boolean build(Object buildData) {
        Object listener;
        boolean rc = super.build(buildData);
        this.buildLegend();
        Enumeration listeners = this.layers.elements();
        this.hasY2Axis = false;
        this.hasX2Axis = false;
        this.hasYAxis = false;
        this.hasXAxis = false;
        if (!this.mouseDown) {
            while (listeners.hasMoreElements()) {
                LayerInterface listener2 = (LayerInterface)listeners.nextElement();
                if (listener2 instanceof MarginInterface) {
                    this.mergeMargins((MarginInterface)listener2);
                }
                if (listener2.getXAxisMapping() == 0) {
                    this.hasXAxis = true;
                } else if (listener2.getXAxisMapping() == 3) {
                    this.hasX2Axis = true;
                }
                if (listener2.getYAxisMapping() == 1) {
                    this.hasYAxis = true;
                    continue;
                }
                if (listener2.getYAxisMapping() != 4) continue;
                this.hasY2Axis = true;
            }
        }
        this.invalid = true;
        if (!this.mouseDown) {
            this.handleJComponents();
        }
        Enumeration e = this.layers.elements();
        while (e.hasMoreElements()) {
            listener = e.nextElement();
            if (!(listener instanceof CellItemInterface)) continue;
            this.mergeAxes((CellItemInterface)listener);
        }
        this.mergeMargins((MarginInterface)this);
        e = this.layers.elements();
        while (e.hasMoreElements()) {
            listener = e.nextElement();
            if (!(listener instanceof UpdateInterface)) continue;
            rc |= ((UpdateInterface)listener).build(buildData);
        }
        this.layoutChart();
        this.repaint();
        return rc;
    }

    public void addNotify() {
        super.addNotify();
        this.buildAndDraw(null, null, null);
    }

    public boolean setStyle(Object newStyle) {
        boolean rc = super.setStyle(newStyle);
        Enumeration listeners = this.layers.elements();
        while (listeners.hasMoreElements()) {
            LayerInterface listener = (LayerInterface)listeners.nextElement();
            if (!(listener instanceof ComponentInterface) || listener == this) continue;
            rc |= ((ComponentInterface)listener).setStyle((Object)this.style);
        }
        if (this.legend != null) {
            this.legend.applyStyle(this.style);
        }
        return rc;
    }

    public boolean setActionMode(int mode) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Object layer = this.layers.elementAt(i);
            if (!(layer instanceof BaseComponentInterface)) continue;
            ((BaseComponentInterface)layer).setActionMode(mode);
        }
        return super.setActionMode(mode);
    }

    public LegendInterface getLegend(Object which) {
        return this.legend;
    }

    public Object getLegendPosition(Object which) {
        return this.legend.getLegendNumber(this.legend.getPosition());
    }

    public boolean setLegendPosition(Object which, Object positionIn) {
        if (positionIn instanceof Number) {
            this.legend.setPosition(((Number)positionIn).intValue());
            return true;
        }
        return false;
    }

    public Object[] getDataIds() {
        LayerInterface[] l = this.getCharts();
        if (l == null) {
            return null;
        }
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < l.length; ++i) {
            if (!(l[i] instanceof ComponentInterface)) continue;
            v.addElement(((ComponentInterface)l[i]).getId());
        }
        Object[] rc = new Object[v.size()];
        v.copyInto(rc);
        return rc;
    }

    public Object getDataSource(Object id) {
        if (id == null) {
            return null;
        }
        LayerInterface[] l = this.getCharts();
        if (l == null) {
            return null;
        }
        for (int i = 0; i < l.length; ++i) {
            if (!(l[i] instanceof ComponentInterface) || !id.equals(((ComponentInterface)l[i]).getId()) || !(l[i] instanceof SourceInterface)) continue;
            return ((SourceInterface)l[i]).getDataSource();
        }
        return null;
    }

    public LayerInterface getLayerById(Object id) {
        if (id == null) {
            return null;
        }
        LayerInterface[] l = this.getCharts();
        if (l == null) {
            return null;
        }
        for (int i = 0; i < l.length; ++i) {
            if (!(l[i] instanceof ComponentInterface) || !id.equals(((ComponentInterface)l[i]).getId())) continue;
            return l[i];
        }
        return null;
    }

    private boolean isTwoLevelName(String varname) {
        return varname.indexOf(46) > 0;
    }

    private String getDataIdFromTwoLevelName(String twoLevelName) {
        if (!this.isTwoLevelName(twoLevelName)) {
            return twoLevelName;
        }
        return twoLevelName.substring(0, twoLevelName.indexOf(46));
    }

    private String getVariableIdFromTwoLevelName(String twoLevelName) {
        if (!this.isTwoLevelName(twoLevelName)) {
            return twoLevelName;
        }
        return twoLevelName.substring(twoLevelName.indexOf(46) + 1, twoLevelName.length());
    }

    public Object getAllVariables(Object role) {
        if (role == null) {
            return null;
        }
        Object rc = null;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(role.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).getAllVariables((Object)this.getVariableIdFromTwoLevelName(role.toString()));
        }
        return rc;
    }

    public Object getVariable(Object role) {
        if (role == null) {
            return null;
        }
        Object rc = null;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(role.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).getVariable((Object)this.getVariableIdFromTwoLevelName(role.toString()));
        }
        return rc;
    }

    public Object getRole(Object variableId) {
        if (variableId == null) {
            return null;
        }
        Object rc = null;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(variableId.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).getRole((Object)this.getVariableIdFromTwoLevelName(variableId.toString()));
        }
        return rc;
    }

    public boolean setRole(Object variableId, Object role) {
        if (variableId == null || role == null) {
            return false;
        }
        boolean rc = false;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(variableId.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).setRole((Object)this.getVariableIdFromTwoLevelName(variableId.toString()), role);
        }
        return rc;
    }

    public boolean addRole(Object variableId, Object role) {
        if (variableId == null || role == null) {
            return false;
        }
        boolean rc = false;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(variableId.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).addRole((Object)this.getVariableIdFromTwoLevelName(variableId.toString()), role);
        }
        return rc;
    }

    public boolean removeRole(Object variableId, Object role) {
        if (variableId == null || role == null) {
            return false;
        }
        boolean rc = false;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(variableId.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).removeRole((Object)this.getVariableIdFromTwoLevelName(variableId.toString()), role);
        }
        return rc;
    }

    public Object getRoleValue(Object role, int which) {
        if (role == null) {
            return null;
        }
        Object rc = null;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(role.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).getRoleValue((Object)this.getVariableIdFromTwoLevelName(role.toString()), which);
        }
        return rc;
    }

    public boolean isDiscrete(Object role) {
        if (role == null) {
            return false;
        }
        boolean rc = false;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(role.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).isDiscrete((Object)this.getVariableIdFromTwoLevelName(role.toString()));
        }
        return rc;
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        if (role == null) {
            return false;
        }
        boolean rc = false;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(role.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).setDiscrete((Object)this.getVariableIdFromTwoLevelName(role.toString()), discrete);
        }
        return rc;
    }

    public Object getSortOrder(Object role) {
        if (role == null) {
            return null;
        }
        Object rc = null;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(role.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).getSortOrder((Object)this.getVariableIdFromTwoLevelName(role.toString()));
        }
        return rc;
    }

    public boolean setSortOrder(Object role, Object order) {
        if (role == null || order == null) {
            return false;
        }
        boolean rc = false;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(role.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).setSortOrder((Object)this.getVariableIdFromTwoLevelName(role.toString()), order);
        }
        return rc;
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        if (id == null) {
            return null;
        }
        Object[] rc = null;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(id.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).getSupportedRoles((Object)this.getVariableIdFromTwoLevelName(id.toString()), discrete);
        }
        return rc;
    }

    public int getMaxAllowed(Object role) {
        if (role == null) {
            return -1;
        }
        int rc = -1;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(role.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).getMaxAllowed((Object)this.getVariableIdFromTwoLevelName(role.toString()));
        }
        return rc;
    }

    public boolean supportsMultipleAssignments(Object role) {
        if (role == null) {
            return false;
        }
        boolean rc = false;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(role.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).supportsMultipleAssignments((Object)this.getVariableIdFromTwoLevelName(role.toString()));
        }
        return rc;
    }

    public Object getLimit(Object role) {
        if (role == null) {
            return null;
        }
        Object rc = null;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(role.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).getLimit((Object)this.getVariableIdFromTwoLevelName(role.toString()));
        }
        return rc;
    }

    public boolean setLimit(Object role, Object value) {
        if (role == null) {
            return false;
        }
        boolean rc = false;
        LayerInterface l = this.getLayerById(this.getDataIdFromTwoLevelName(role.toString()));
        if (l != null && l instanceof RoleInterface) {
            rc = ((RoleInterface)l).setLimit((Object)this.getVariableIdFromTwoLevelName(role.toString()), value);
        }
        return rc;
    }

    public Object getPropertyValue(int id) {
        Vector<Object> rc = null;
        if (this.legend.isPropertySupported(id)) {
            return this.legend.getPropertyValue(id);
        }
        switch (id) {
            case 15000: {
                LayerInterface[] l = this.getCharts();
                if (l == null) {
                    rc = null;
                    break;
                }
                Vector<Object> v = new Vector<Object>();
                for (int i = 0; i < l.length; ++i) {
                    if (!(l[i] instanceof ComponentInterface) || ((ComponentInterface)l[i]).getId() == null || this.pendingDeletedCharts.contains(((ComponentInterface)l[i]).getId())) continue;
                    v.addElement(((ComponentInterface)l[i]).getId());
                }
                rc = v;
                break;
            }
            case 23: {
                rc = this.legend;
                break;
            }
            case 15001: {
                rc = this;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    public void cancelPropertyChanges(Object source) {
        this.pendingDeletedCharts.removeAllElements();
        super.cancelPropertyChanges(source);
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.legend != null && this.legend.isPropertySupported(id)) {
            return this.legend.setPropertyValue(id, value);
        }
        if (id == 15002) {
            this.pendingDeletedCharts.addElement(value);
            return true;
        }
        return super.setPropertyValue(id, value);
    }

    public boolean applyPropertyChanges(Object source) {
        if (this.legend != null) {
            this.legend.applyPropertyChanges();
        }
        if (!this.pendingDeletedCharts.isEmpty()) {
            for (int i = 0; i < this.pendingDeletedCharts.size(); ++i) {
                Object chart = this.getChart(this.pendingDeletedCharts.elementAt(i));
                if (!(chart instanceof LayerInterface)) continue;
                this.removeLayer((LayerInterface)chart);
            }
            this.pendingDeletedCharts.removeAllElements();
        }
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        this.buildLegend();
        return super.applyPropertyChanges(source);
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 15000: {
                int type = Extract.getSourceType((Object)value);
                Object[] arr = new Object[Extract.getNumberItems((Object)value, (int)type)];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = Extract.getObject((Object)value, (int)i, (int)type);
                }
                this.setLayerOrder(arr);
                this.buildAndDraw(null, null, null);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable tr = dropTargetDropEvent.getTransferable();
            if (tr.isDataFlavorSupported(SILKChartFlavor.silkChartFlavor)) {
                dropTargetDropEvent.acceptDrop(3);
                WizardEntry entry = (WizardEntry)tr.getTransferData(SILKChartFlavor.silkChartFlavor);
                JComponent obj = entry.getGraph();
                if (obj instanceof LayerInterface) {
                    this.addLayer((LayerInterface)obj);
                    this.layoutChart();
                    this.buildAndDraw(new Boolean(true), null, null);
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException io) {
            io.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public boolean setLayerOrder(Object[] order) {
        int j;
        int i;
        for (i = 0; i < this.layers.size(); ++i) {
            if (this.layers.elementAt(i) instanceof ComponentInterface) continue;
            return false;
        }
        if (order.length != this.layers.size()) {
            return false;
        }
        for (i = 0; i < this.layers.size(); ++i) {
            Object id = ((ComponentInterface)this.layers.elementAt(i)).getId();
            boolean found = false;
            for (j = 0; j < order.length; ++j) {
                if (!id.equals(order[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        Vector<LayerInterface> newListeners = new Vector<LayerInterface>();
        for (int i2 = 0; i2 < order.length; ++i2) {
            LayerInterface lli = null;
            for (j = 0; j < this.layers.size(); ++j) {
                if (!((ComponentInterface)this.layers.elementAt(j)).getId().equals(order[i2])) continue;
                lli = (LayerInterface)this.layers.elementAt(j);
                break;
            }
            newListeners.addElement(lli);
        }
        this.layers = newListeners;
        return true;
    }

    public void layerChanged(LayerChangedEvent lce) {
        if (lce == null) {
            return;
        }
        switch (lce.getAction()) {
            case 3: {
                this.buildAndDraw(Boolean.TRUE, null, null);
                break;
            }
            case 1: {
                this.repaint();
            }
        }
    }

    protected Hashtable getDrilldownInfo(int screenX, int screenY) {
        return null;
    }
}

