/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.JVerticalLabel;
import com.sas.graphics.applets.statgraph.sgchart.grid.StripLabel;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.silk.BaseHeatmapComponent;
import com.sas.graphics.silk.BaseHistComponent;
import com.sas.graphics.silk.BaseScatterComponent;
import com.sas.graphics.silk.BoxPlotComponent;
import com.sas.graphics.silk.ConstComponent;
import com.sas.graphics.silk.DecisionTree;
import com.sas.graphics.silk.DensityPlotComponent;
import com.sas.graphics.silk.HeatmapComponent;
import com.sas.graphics.silk.HistogramParmComponent;
import com.sas.graphics.silk.HorizontalBarComponent;
import com.sas.graphics.silk.Icicle;
import com.sas.graphics.silk.JTableComponent;
import com.sas.graphics.silk.LinePlotComponent;
import com.sas.graphics.silk.PieComponent;
import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.SpectrumPlotComponent;
import com.sas.graphics.silk.VerticalBarComponent;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.BaseElementComponent;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.ConstChartInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.GraphToolbarInterface;
import com.sas.graphics.silk.interfaces.LatticePropertyInterface;
import com.sas.graphics.silk.interfaces.LayerInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.ui.DataOptionsDialog;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.LatticePanel;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.AxisComponent;
import com.sas.graphics.silk.util.ColorMapper;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.LatticeDefaults;
import com.sas.graphics.silk.util.LegendBuilder;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.RangeMerger;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.UniqueValueMapper;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.AxisParser;
import com.sas.graphics.silk.xml.parsers.LegendParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyMulticaster;
import com.sas.graphics.util.StringCompare;
import com.sas.graphics.xml.GraphParserFactory;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LatticeComponent
extends SILKComponent
implements GraphInterface,
DataFilterListenerInterface,
PropertyInterface,
LatticePropertyInterface,
RoleInterface,
MouseListener,
ActionListener {
    private static final long serialVersionUID = -6248565930494514593L;
    public static final int NONE = 0;
    public static final int LINE = 1;
    public static final int SCATTER = 2;
    public static final int BAR = 3;
    public static final int HISTOGRAM = 4;
    public static final int PIE = 5;
    public static final int BOX = 6;
    public static final int SPECTRUM = 7;
    public static final int TABLE = 8;
    public static final int SCATTER3D = 9;
    public static final int BAR3D = 10;
    public static final int SURFACE = 11;
    public static final int DENSITY = 12;
    public static final int SEQUENCE = 13;
    public static final int HISTOGRAM_PARM = 14;
    public static final int ICICLE = 17;
    public static final int DECISON_TREE = 18;
    public static final int CONSTELLATION = 19;
    public static final int HEATMAP = 20;
    public static final int ROW_MAJOR = 1;
    public static final int COL_MAJOR = 2;
    public static final int DATA = 1;
    public static final int ROW_EQUALIZATION = 2;
    public static final int COLUMN_EQUALIZATION = 3;
    public static final int UNION = 4;
    private static final int NUMBER_LATTICE_ROLES = 2;
    private static int BY_VARIABLE_VALUE_LIMIT = 100;
    private static int DEFAULT_ACTION_MODE = 1;
    private int componentType = 0;
    private JComponent[] components = null;
    private String[] whereClauses = null;
    private Object id = null;
    private Object dataSource;
    private DataFilterReadInterface filter = null;
    private String row = null;
    private String col = null;
    private String category = null;
    private String[] response = null;
    private String group = null;
    private String subgroup = null;
    private String yVariable = null;
    private String statisticType = null;
    private int columns = 1;
    private int rows = 1;
    private int type = 1;
    private int numDivisions = -1;
    private int userSetNumDivisions = -1;
    private int maxDivisions = -1;
    private boolean wrapEnabled = true;
    private Object[] primaryByVariableValues = null;
    private Object[] secondaryByVariableValues = null;
    private String primaryByVariable = null;
    private String secondaryByVariable = null;
    private Object[] myRoles = null;
    private Object[] engRoles = null;
    private String[] variables = null;
    private Roles roles = null;
    private int hGap = 0;
    private int vGap = 0;
    private Dimension minCellSize = null;
    private Dimension cellSize = new Dimension(0, 0);
    private boolean cellSizeSet = false;
    private TrellisPlot lattice = null;
    private TrellisLayout layout = null;
    private Color cellHeaderColor1 = null;
    private Color cellHeaderColor2 = null;
    private Color cellHeaderColor3 = null;
    private boolean internalCellHeaders = true;
    private boolean showCellHeaderHilite = true;
    private boolean showNumObs = false;
    private boolean showComponentBorder = true;
    private boolean showLabelBorder = true;
    private boolean showCellHeaderPrefix = true;
    private final int BORDER_WIDTH = 1;
    private Color borderColor = null;
    private Color labelColor = null;
    private boolean printToOnePage = true;
    private boolean[][] componentInCell = null;
    private Color backgroundColor = null;
    private boolean equalizeCategoricalAxes = false;
    private boolean equalizeNumericalAxes = true;
    private int xEqualizationType;
    private int yEqualizationType;
    private int zEqualizationType;
    private JPopupMenu popup = null;
    private Dialog graphDialog = null;
    private Dialog dataDialog = null;
    private Component toolbar = null;
    private int actionMode = DEFAULT_ACTION_MODE;
    private boolean invalidVariableAssignment = false;
    private boolean secondCall = false;
    private Frame parentFrame = null;
    private ResourceBundle rb = null;
    private boolean externalAxes = false;
    private boolean showExternalAxes = false;
    private boolean xAxesVisible = true;
    private boolean yAxesVisible = true;
    private boolean rangeChanged = false;
    private Vector dimensions = null;
    private String msg1 = null;
    private String msg2 = null;
    private ArrayList externalXAxes = null;
    private ArrayList externalYAxes = null;
    private int currentAxis = 0;
    private Border border = null;
    private Hashtable properties = null;
    private int sortOrderX = 0;
    private int sortOrderY = 0;
    private boolean popupEnabled = true;
    private LatticeDefaults latticeDefaults = null;
    private GlobalDefaults globalDefaults = null;
    private int xValueCount = -1;
    private int yValueCount = -1;
    private boolean equalizeValueCount = true;
    private boolean useVariableDescription = true;
    private Hashtable propertyMulticasters = null;
    protected LegendBuilder legendBuilder = null;
    private boolean rebuilding = false;
    private static final String LATTICE_CHART_ID = "__LATTICE_CHART_ID__";
    private Vector roleListeners = null;
    private boolean legendUpdatePending = false;
    private SILKNumber xRole = null;
    private SILKNumber yRole = null;
    private SILKNumber categoryRole = null;
    private SILKNumber responseRole = null;
    private SILKNumber statTypeRole = null;
    private SILKNumber freqRole = null;
    private ColorMapper colorMapper = null;
    private boolean ignoreColorMapperEvents = false;
    private boolean canViewport = false;
    private boolean chartSupportsZoom = false;
    private boolean isViewportScrollEnabled = false;
    private Object dataId = null;
    private JLabel invalidVarLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.Error.InvalidVariableValues.txt", (String)"Invalid variable values!"), 0);
    boolean printDebugging = false;
    private boolean blockDataEvents = false;
    private GraphInterface selectedChart = null;
    private JMenuItem toolbarMI = null;
    private JMenuItem viewPortActionModeMI = null;
    private JMenuItem defaultActionModeMI = null;
    private JMenu viewMenu = null;
    private JMenuItem viewFitToPageMI = null;
    private int focusChartItemIndex = 7;
    private int resetFocusIndex = 8;
    private boolean chartFocussed = false;
    private ComponentInterface tempCI = null;
    private Hashtable multicasters = new Hashtable();
    private boolean applyingPropertyChanges = false;
    private int layoutDepth = 0;
    private boolean toolbarSet = false;
    private boolean aggressiveMonitoring = true;
    private boolean byVarWhereClauseSet = false;
    private String currentWhereClause = null;
    private String latticeWhereClause = null;

    public LatticeComponent() {
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
        this.legendBuilder = new LegendBuilder();
        this.legendBuilder.setEnableSelections(false);
        this.msg1 = ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.Message.ByVarMsg.fmt.txt", (String)"{0} = {1}");
        this.msg2 = ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.Message.NObs.fmt.txt", (String)"nobs = {0,number,integer} out of {1,number,integer}");
        this.latticeDefaults = new LatticeDefaults();
        if (this.latticeDefaults.byVariableValueLimit > 0) {
            BY_VARIABLE_VALUE_LIMIT = this.latticeDefaults.byVariableValueLimit;
        }
        this.globalDefaults = new GlobalDefaults();
        this.componentType = 2;
        this.properties = new Hashtable();
        this.vGap = 4;
        this.hGap = 4;
        this.createTrellis();
        this.setLayout(null);
        this.add((Component)this.lattice);
        this.setColorScheme(SILKGlobal.getInstance().getPropertyValue(0));
        this.xEqualizationType = 4;
        this.yEqualizationType = 4;
        this.zEqualizationType = 4;
        this.variables = new String[2];
        this.roles = Roles.getInstance(null);
        this.myRoles = new Object[2];
        this.myRoles[0] = this.roles.getRoleObject("ROLE_LATTICE_X");
        this.myRoles[1] = this.roles.getRoleObject("ROLE_LATTICE_Y");
        this.engRoles = new Object[2];
        this.engRoles[0] = "Lattice-X";
        this.engRoles[1] = "Lattice-Y";
        this.dimensions = new Vector();
        this.dimensions.addElement(new Integer(1));
        this.dimensions.addElement(new Integer(2));
        this.dimensions.addElement(new Integer(3));
        this.externalXAxes = new ArrayList();
        this.externalYAxes = new ArrayList();
        this.xRole = this.roles.getRoleObject("ROLE_X");
        this.categoryRole = this.roles.getRoleObject("ROLE_CATEGORY");
        this.yRole = this.roles.getRoleObject("ROLE_Y");
        this.responseRole = this.roles.getRoleObject("ROLE_RESPONSE");
        this.statTypeRole = this.roles.getRoleObject("ROLE_STATISTIC_TYPE");
        this.freqRole = this.roles.getRoleObject("ROLE_FREQUENCY");
        this.propertyMulticasters = new Hashtable();
    }

    public LatticeComponent(int compType, Object source, String categry, String resp, String primaryByVar, String secondaryByVar, String grp, int numDiv) {
        this();
        this.category = categry;
        this.response = new String[1];
        if (compType == 4) {
            this.yVariable = resp;
        } else {
            this.response[0] = resp;
        }
        if (secondaryByVar != null) {
            this.primaryByVariable = this.row = primaryByVar;
            this.secondaryByVariable = this.col = secondaryByVar;
            this.type = 2;
        } else if (this.type == 1) {
            this.primaryByVariable = this.col = primaryByVar;
            this.row = null;
            this.secondaryByVariable = null;
        } else if (this.type == 2) {
            this.primaryByVariable = this.row = primaryByVar;
            this.col = null;
            this.secondaryByVariable = null;
        }
        this.group = grp;
        if (this.col == null || this.row == null) {
            this.numDivisions = numDiv;
        }
        this.initialize(compType, source);
    }

    public LatticeComponent(int compType, Object source, String category, String response, String primaryByVar, String secondaryByVar, String grp) {
        this(compType, source, category, response, primaryByVar, secondaryByVar, grp, -1);
    }

    public LatticeComponent(int compType, Object source, String category, String response, String primaryByVar, String secondaryByVar) {
        this(compType, source, category, response, primaryByVar, secondaryByVar, null, -1);
    }

    public LatticeComponent(int compType, Object source, String categry, String[] resp, String primaryByVar, String secondaryByVar, String grp, int numDiv) {
        this();
        this.category = categry;
        if (compType != 4) {
            if (resp != null) {
                this.response = new String[resp.length];
                for (int i = 0; i < resp.length; ++i) {
                    this.response[i] = resp[i];
                }
            } else {
                this.response = new String[1];
                this.response[0] = null;
            }
        } else {
            this.response = new String[1];
            if (resp != null) {
                this.yVariable = resp[0];
            }
        }
        if (secondaryByVar != null) {
            this.primaryByVariable = this.row = primaryByVar;
            this.secondaryByVariable = this.col = secondaryByVar;
            this.type = 2;
        } else if (this.type == 1) {
            this.primaryByVariable = this.col = primaryByVar;
            this.row = null;
            this.secondaryByVariable = null;
        } else if (this.type == 2) {
            this.primaryByVariable = this.row = primaryByVar;
            this.col = null;
            this.secondaryByVariable = null;
        }
        this.group = grp;
        if (this.col == null || this.row == null) {
            this.numDivisions = numDiv;
        }
        this.initialize(compType, source);
    }

    public LatticeComponent(int compType, Object source, String category, String[] response, String primaryByVar, String secondaryByVar, String grp) {
        this(compType, source, category, response, primaryByVar, secondaryByVar, grp, -1);
    }

    public LatticeComponent(int compType, Object source, String category, String[] response, String primaryByVar, String secondaryByVar) {
        this(compType, source, category, response, primaryByVar, secondaryByVar, null, -1);
    }

    public LatticeComponent(int compType, Object source, String categry, String resp, String byVar, String grp, int dir, int numDiv) {
        this();
        this.category = categry;
        this.response = new String[1];
        if (compType == 4) {
            this.yVariable = resp;
        } else {
            this.response[0] = resp;
        }
        this.group = grp;
        this.type = dir;
        this.primaryByVariable = this.type == 1 ? (this.col = byVar) : (this.row = byVar);
        this.numDivisions = numDiv;
        this.initialize(compType, source);
    }

    public LatticeComponent(int compType, Object source, String categry, String resp, String byVar, int dir, int numDiv) {
        this(compType, source, categry, resp, byVar, null, dir, numDiv);
    }

    public LatticeComponent(int compType, Object source, String category, String response, String byVar, int dir) {
        this(compType, source, category, response, byVar, null, dir, -1);
    }

    public LatticeComponent(int compType, Object source, String category, String response, String byVar) {
        this(compType, source, category, response, byVar, null, 1, -1);
    }

    public LatticeComponent(int compType, Object source, String categry, String[] resp, String byVar, String grp, int dir, int numDiv) {
        this();
        this.category = categry;
        if (compType != 4) {
            if (resp != null) {
                this.response = new String[resp.length];
                for (int i = 0; i < resp.length; ++i) {
                    this.response[i] = resp[i];
                }
            } else {
                this.response = new String[1];
                this.response[0] = null;
            }
        } else {
            this.response = new String[1];
            if (resp != null) {
                this.yVariable = resp[0];
            }
        }
        this.group = grp;
        this.type = dir;
        this.primaryByVariable = this.type == 1 ? (this.col = byVar) : (this.row = byVar);
        this.numDivisions = numDiv;
        this.initialize(compType, source);
    }

    public LatticeComponent(int compType, Object source, String categry, String[] resp, String byVar, int dir, int numDiv) {
        this(compType, source, categry, resp, byVar, null, dir, numDiv);
    }

    public LatticeComponent(int compType, Object source, String category, String[] response, String byVar, int dir) {
        this(compType, source, category, response, byVar, null, dir, -1);
    }

    public LatticeComponent(int compType, Object source, String category, String[] response, String byVar) {
        this(compType, source, category, response, byVar, null, 1, -1);
    }

    public void initialize(int compType, Object source) {
        this.setComponentType(compType);
        this.dataSource = source;
        this.filter = FilterFactory.getDataSourceFilter((Object)this.dataSource);
        this.filter.addDataFilterListener((Object)this);
        this.computeNumberOfCharts();
        if (this.secondaryByVariable != null) {
            this.variables[0] = this.secondaryByVariable;
            this.variables[1] = this.primaryByVariable;
        } else if (this.type == 1) {
            this.variables[0] = this.primaryByVariable;
            this.variables[1] = null;
        } else if (this.type == 2) {
            this.variables[0] = null;
            this.variables[1] = this.primaryByVariable;
        }
    }

    public void addNotify() {
        Container con;
        super.addNotify();
        for (con = this.getParent(); con != null && !(con instanceof Frame); con = con.getParent()) {
        }
        this.parentFrame = (Frame)con;
        if (this.lattice != null) {
            this.lattice.setBounds(this.graphLayout.getChartArea());
        }
        this.doEqualization();
        this.updateLegends(true);
        if (this.lattice != null) {
            this.enableLayout();
        }
    }

    protected void doResize(int compWidthIn, int compHeightIn) {
        if (compWidthIn == this.compWidth && compHeightIn == this.compHeight) {
            return;
        }
        super.doResize(compWidthIn, compHeightIn);
        this.setLatticeSize();
        if (this.lattice != null) {
            this.lattice.setBounds(this.graphLayout.getChartArea());
        }
        if (this.cellSize == null) {
            this.cellSize = new Dimension(0, 0);
        }
        this.verifySize();
        this.updateCellHeaderFontSize();
        this.setAxesFontHeights(compWidthIn, compHeightIn);
        this.layoutExternalAxes();
    }

    private void layoutExternalAxes() {
        AxisComponent axis;
        int i;
        if (!this.showExternalAxes || !this.xAxesVisible && !this.yAxesVisible) {
            return;
        }
        this.lattice.doLayout();
        if (this.xAxesVisible) {
            for (i = 0; i < this.columns; ++i) {
                axis = (AxisComponent)this.lattice.getColumnAxis(i, true);
                if (axis == null) continue;
                axis.layoutValueLabels(null);
                axis.recompute();
            }
        }
        if (this.yAxesVisible) {
            for (i = 0; i < this.rows; ++i) {
                axis = (AxisComponent)this.lattice.getRowAxis(i, true);
                if (axis == null) continue;
                axis.layoutValueLabels(null);
                axis.recompute();
            }
        }
        this.revalidate();
    }

    public void removeNotify() {
        if (this.lattice != null) {
            this.disableLayout();
        }
        super.removeNotify();
        if (this.toolbar != null) {
            this.toolbar.setVisible(false);
        }
    }

    public void paintComponent(Graphics g) {
        if (this.legendUpdateRequired()) {
            this.graphLayout.doLayout((JComponent)((Object)this));
            if (this.lattice != null) {
                this.lattice.setBounds(this.graphLayout.getChartArea());
            }
            this.enableLayout();
        }
        Color c = this.getBackground();
        if (this.style != null) {
            c = this.style.getFillStyleElement("Backfill").getFillColor();
        }
        g.setColor(c);
        g.fillRect(this.getBounds().x, this.getBounds().y, this.compWidth, this.compHeight);
        super.paintComponent(g);
        if (this.ui == null && this.lattice != null) {
            this.lattice.paintComponent(g);
        }
        this.graphLayout.draw(g);
        this.graphLayout.drawHighlight(g);
    }

    public void createTrellis() {
        this.lattice = new TrellisPlot();
        this.layout = new TrellisLayout();
        this.layout.setGridHGap(this.hGap);
        this.layout.setGridVGap(this.vGap);
        this.lattice.setLayout((LayoutManager)this.layout);
        this.lattice.addMouseListener((MouseListener)this);
        this.lattice.addCellItem(0, 0, (Component)new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.Error.NoChartData.txt", (String)"No chart data"), 0));
        this.lattice.setRowScrollBarPolicy(0);
        this.lattice.setColumnScrollBarPolicy(0);
    }

    public boolean createByVariableLattice() {
        if (this.filter == null) {
            return false;
        }
        this.legendBuilder.removeAllCharts();
        this.removeLegends();
        if (this.primaryByVariable == null) {
            this.invalidVariableAssignment = true;
        }
        if (this.invalidVariableAssignment) {
            this.lattice.addCellItem(0, 0, (Component)this.invalidVarLabel);
            return false;
        }
        if (this.rows == 0 || this.columns == 0) {
            this.lattice.addCellItem(0, 0, (Component)new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.Error.NoChartData.txt", (String)"No chart data"), 0));
            return false;
        }
        int cntr = this.columns;
        while (--cntr > 0) {
            this.lattice.addColumn();
        }
        cntr = this.rows;
        while (--cntr > 0) {
            this.lattice.addRow();
        }
        this.setLatticeSize();
        this.verifySize();
        if (!this.rebuilding) {
            this.disableLayout();
        }
        int r = -1;
        int c = -1;
        int nobs = 0;
        this.filter.removeDataFilterListener((Object)this);
        Vector<JComponent> charts = new Vector<JComponent>();
        if (this.col != null && this.row != null) {
            this.components = new JComponent[this.primaryByVariableValues.length * this.secondaryByVariableValues.length];
            this.whereClauses = new String[this.primaryByVariableValues.length * this.secondaryByVariableValues.length];
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    JComponent comp;
                    String whereClause = this.buildWhereClause(this.primaryByVariableValues[r], this.secondaryByVariableValues[c]);
                    this.blockDataEvents = true;
                    if (this.secondCall && this.currentWhereClause != null) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("(");
                        sb.append(this.currentWhereClause);
                        sb.append(")");
                        sb.append(" & ");
                        sb.append(whereClause);
                        this.filter.applyWhereClause(sb.toString(), true);
                        nobs = this.filter.getNumberObservations(null);
                        this.filter.applyWhereClause(this.currentWhereClause, true);
                    } else {
                        this.filter.applyWhereClause(whereClause, true);
                        nobs = this.filter.getNumberObservations(null);
                        this.filter.applyWhereClause(null, true);
                    }
                    this.blockDataEvents = false;
                    if (nobs > 0) {
                        int index = r * this.columns + c;
                        this.components[index] = this.createComponent(this.componentType, this.primaryByVariableValues[r], this.secondaryByVariableValues[c]);
                        this.whereClauses[index] = whereClause;
                        comp = this.components[index];
                        this.componentInCell[r][c] = true;
                        if (this.showComponentBorder) {
                            comp.setBorder(this.border);
                        }
                        this.components[index].addMouseListener(this);
                        this.components[index].addMouseMotionListener((MouseMotionListener)((Object)this));
                        if (this.components[index] instanceof GraphInterface) {
                            GraphInterface gi = (GraphInterface)this.components[index];
                            gi.enablePopup(false);
                            if (this.toolbar != null && this.toolbar.isVisible()) {
                                gi.setActionMode(this.getActionMode());
                            }
                        }
                        if (this.components[index] instanceof PropertyInterface) {
                            PropertyInterface pi = (PropertyInterface)this.components[index];
                            pi.setPropertyValue(64, (Object)Boolean.FALSE);
                            pi.setPropertyValue(34, (Object)new Boolean(this.isViewportScrollEnabled));
                            pi.applyPropertyChanges();
                            charts.add(this.components[index]);
                        }
                    } else {
                        comp = new JLabel();
                        this.componentInCell[r][c] = false;
                        comp.addMouseListener(this);
                    }
                    this.lattice.addCellItem(r, c, (Component)comp);
                    Object val1 = this.replaceWithMissingNotation(this.getFormattedValue(this.primaryByVariable, this.primaryByVariableValues[r]));
                    Object val2 = this.replaceWithMissingNotation(this.getFormattedValue(this.secondaryByVariable, this.secondaryByVariableValues[c]));
                    if (!this.internalCellHeaders) continue;
                    String result = this.getByVarText(this.primaryByVariable, val1, this.msg1);
                    StripLabel label1 = this.createStripLabel(result, r, this.primaryByVariableValues.length, this.cellHeaderColor1);
                    result = this.getByVarText(this.secondaryByVariable, val2, this.msg1);
                    StripLabel label2 = this.createStripLabel(result, c, this.secondaryByVariableValues.length, this.cellHeaderColor2);
                    this.lattice.addCellHeader(r, c, 0, (JComponent)label1);
                    this.lattice.addCellHeader(r, c, 1, (JComponent)label2);
                    Object[] args = new Object[]{new Integer(nobs), new Integer(this.filter.getNumberObservations(null))};
                    result = MessageFormat.format(this.msg2, args);
                    if (!this.showNumObs) continue;
                    StripLabel label3 = this.createStripLabel(result, -1, -1, this.cellHeaderColor3);
                    this.lattice.addCellHeader(r, c, 2, (JComponent)label3);
                }
            }
        } else {
            this.internalCellHeaders = true;
            this.components = new JComponent[this.primaryByVariableValues.length];
            this.whereClauses = new String[this.primaryByVariableValues.length];
            for (cntr = 0; cntr < this.primaryByVariableValues.length; ++cntr) {
                this.components[cntr] = this.createComponent(this.componentType, this.primaryByVariableValues[cntr], null);
                this.whereClauses[cntr] = this.buildWhereClause(this.primaryByVariableValues[cntr], null);
                if (this.showComponentBorder) {
                    this.components[cntr].setBorder(this.border);
                }
                this.components[cntr].addMouseListener(this);
                this.components[cntr].addMouseMotionListener((MouseMotionListener)((Object)this));
                if (this.components[cntr] instanceof GraphInterface) {
                    GraphInterface gi = (GraphInterface)this.components[cntr];
                    gi.enablePopup(false);
                    if (this.toolbar != null && this.toolbar.isVisible()) {
                        gi.setActionMode(this.getActionMode());
                    }
                }
                if (this.components[cntr] instanceof PropertyInterface) {
                    PropertyInterface pi = (PropertyInterface)this.components[cntr];
                    pi.setPropertyValue(64, (Object)Boolean.FALSE);
                    pi.setPropertyValue(34, (Object)new Boolean(this.isViewportScrollEnabled));
                    pi.applyPropertyChanges();
                    charts.add(this.components[cntr]);
                }
                nobs = this.componentType == 8 ? ((JTableComponent)this.components[cntr]).getFilter().getNumberObservations(null) : ((GraphInterface)this.components[cntr]).getFilter().getNumberObservations(null);
                if (this.type == 2) {
                    r = cntr % this.rows;
                    c = cntr / this.rows;
                } else {
                    r = cntr / this.columns;
                    c = cntr % this.columns;
                }
                this.lattice.addCellItem(r, c, (Component)this.components[cntr]);
                Object val1 = this.replaceWithMissingNotation(this.getFormattedValue(this.primaryByVariable, this.primaryByVariableValues[cntr]));
                if (this.internalCellHeaders) {
                    String result = this.getByVarText(this.primaryByVariable, val1, this.msg1);
                    StripLabel label1 = this.createStripLabel(result, cntr, this.primaryByVariableValues.length, this.cellHeaderColor1);
                    this.lattice.addCellHeader(r, c, 0, (JComponent)label1);
                    Object[] args = new Object[]{new Integer(nobs), new Integer(this.filter.getNumberObservations(null))};
                    result = MessageFormat.format(this.msg2, args);
                    if (this.showNumObs) {
                        StripLabel label2 = this.createStripLabel(result, -1, -1, this.cellHeaderColor3);
                        this.lattice.addCellHeader(r, c, 1, (JComponent)label2);
                    }
                }
                this.componentInCell[r][c] = true;
            }
            while (cntr < this.rows * this.columns) {
                JLabel comp = new JLabel();
                comp.addMouseListener(this);
                if (this.type == 2) {
                    this.lattice.addCellItem(cntr % this.rows, cntr / this.rows, (Component)comp);
                    this.componentInCell[cntr % this.rows][cntr / this.rows] = false;
                } else {
                    this.lattice.addCellItem(cntr / this.columns, cntr % this.columns, (Component)comp);
                    this.componentInCell[cntr / this.columns][cntr % this.columns] = false;
                }
                ++cntr;
            }
        }
        if (!this.internalCellHeaders) {
            this.addExternalHeaders();
        }
        this.legendBuilder.addCharts(charts);
        if (!this.rebuilding) {
            this.setComponentLegendsVisible(false);
            this.updateLegends(true);
        }
        this.setValueCounts();
        if (this.externalAxes) {
            this.setupExternalAxes(false);
        }
        this.doEqualization();
        this.filter.addDataFilterListener((Object)this);
        this.applyColorScheme();
        if (!this.rebuilding) {
            this.enableLayout();
        }
        if (this.compWidth > 0 && this.compHeight > 0) {
            this.setAxesFontHeights(this.compWidth, this.compHeight);
        }
        this.setupResponseSort();
        return true;
    }

    private void addExternalHeaders() {
        block6: {
            Font font;
            block5: {
                Object l;
                String txt;
                int i;
                if (this.lattice == null || this.primaryByVariableValues == null) {
                    return;
                }
                if (this.internalCellHeaders) {
                    return;
                }
                boolean latticeYRoleSet = this.getVariable(this.myRoles[1]) != null;
                font = this.style.getTextStyleElement("LabelText").getFont();
                if (!latticeYRoleSet) break block5;
                for (i = 0; i < this.rows; ++i) {
                    txt = this.getByVarText(this.primaryByVariable, this.primaryByVariableValues[i].toString(), this.msg1);
                    l = new JVerticalLabel(txt, false);
                    ((JComponent)l).setFont(font.deriveFont(this.computeStripLabelFontSize((JLabel)l)));
                    ((JComponent)l).setForeground(this.labelColor);
                    this.lattice.addRowHeader(i, (Component)l);
                }
                if (this.secondaryByVariableValues == null) break block6;
                for (i = 0; i < this.columns; ++i) {
                    txt = this.getByVarText(this.secondaryByVariable, this.secondaryByVariableValues[i].toString(), this.msg1);
                    l = new JLabel(txt, 0);
                    ((JComponent)l).setFont(font.deriveFont(this.computeStripLabelFontSize((JLabel)l)));
                    ((JComponent)l).setForeground(this.labelColor);
                    this.lattice.addColumnHeader(i, (Component)l);
                }
                break block6;
            }
            for (int i = 0; i < this.columns; ++i) {
                String txt = this.getByVarText(this.primaryByVariable, this.primaryByVariableValues[i].toString(), this.msg1);
                JLabel l = new JLabel(txt, 0);
                l.setFont(font.deriveFont(this.computeStripLabelFontSize(l)));
                l.setForeground(this.labelColor);
                this.lattice.addColumnHeader(i, (Component)l);
            }
        }
    }

    private void removeExternalHeaders() {
        int i;
        if (this.lattice == null) {
            return;
        }
        if (!this.internalCellHeaders) {
            return;
        }
        for (i = 0; i < this.rows; ++i) {
            this.lattice.removeRowHeader(i);
        }
        for (i = 0; i < this.columns; ++i) {
            this.lattice.removeColumnHeader(i);
        }
    }

    private void addInternalHeaders() {
        if (this.lattice == null || this.primaryByVariableValues == null) {
            return;
        }
        if (!this.internalCellHeaders) {
            return;
        }
        Font font = this.style.getTextStyleElement("LabelText").getFont();
        String result = null;
        if (this.primaryByVariable != null && this.secondaryByVariable != null) {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    result = this.getByVarText(this.primaryByVariable, this.primaryByVariableValues[i], this.msg1);
                    StripLabel label1 = this.createStripLabel(result, i, this.primaryByVariableValues.length, this.cellHeaderColor1);
                    label1.setFont(font.deriveFont(this.computeStripLabelFontSize((JLabel)label1)));
                    label1.setForeground(this.labelColor);
                    this.lattice.addCellHeader(i, j, 0, (JComponent)label1);
                    result = this.getByVarText(this.secondaryByVariable, this.secondaryByVariableValues[j], this.msg1);
                    StripLabel label2 = this.createStripLabel(result, j, this.secondaryByVariableValues.length, this.cellHeaderColor2);
                    label2.setFont(font.deriveFont(this.computeStripLabelFontSize((JLabel)label2)));
                    label2.setForeground(this.labelColor);
                    this.lattice.addCellHeader(i, j, 1, (JComponent)label2);
                    int index = i * this.columns + j;
                    int nobs = 0;
                    if (this.components[index] instanceof ComponentInterface) {
                        DataFilterReadInterface dfri = ((ComponentInterface)this.components[index]).getFilter();
                        nobs = dfri.getNumberObservations(-1);
                    }
                    Object[] args = new Object[]{new Integer(nobs), new Integer(this.filter.getNumberObservations(null))};
                    result = MessageFormat.format(this.msg2, args);
                    if (!this.showNumObs) continue;
                    StripLabel label3 = this.createStripLabel(result, -1, -1, this.cellHeaderColor3);
                    label3.setFont(font.deriveFont(this.computeStripLabelFontSize((JLabel)label3)));
                    label3.setForeground(this.labelColor);
                    this.lattice.addCellHeader(i, j, 2, (JComponent)label3);
                }
            }
        } else {
            for (int i = 0; i < this.primaryByVariableValues.length; ++i) {
                int r = -1;
                int c = -1;
                int nobs = 0;
                if (this.type == 2) {
                    r = i % this.rows;
                    c = i / this.rows;
                } else {
                    r = i / this.columns;
                    c = i % this.columns;
                }
                result = this.getByVarText(this.primaryByVariable, this.primaryByVariableValues[i], this.msg1);
                StripLabel label1 = this.createStripLabel(result, i, this.primaryByVariableValues.length, this.cellHeaderColor1);
                this.lattice.addCellHeader(r, c, 0, (JComponent)label1);
                if (this.components[i] instanceof ComponentInterface) {
                    DataFilterReadInterface dfri = ((ComponentInterface)this.components[i]).getFilter();
                    nobs = dfri.getNumberObservations(-1);
                }
                Object[] args = new Object[]{new Integer(nobs), new Integer(this.filter.getNumberObservations(null))};
                result = MessageFormat.format(this.msg2, args);
                if (!this.showNumObs) continue;
                StripLabel label3 = this.createStripLabel(result, -1, -1, this.cellHeaderColor3);
                this.lattice.addCellHeader(r, c, 1, (JComponent)label3);
            }
        }
    }

    private void removeInternalHeaders() {
        if (this.lattice == null) {
            return;
        }
        if (this.internalCellHeaders) {
            return;
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                int numHdrs = this.layout.getCell(i, j).getNumHeaders();
                for (int k = numHdrs - 1; k >= 0; --k) {
                    this.lattice.removeCellHeader(i, j, k);
                }
            }
        }
    }

    private String getByVarText(Object byVariable, Object value, String msg) {
        if (this.showCellHeaderPrefix) {
            Object varInfo = this.useVariableDescription ? this.filter.getVariableDescription(byVariable) : byVariable;
            Object[] args = new Object[]{varInfo, value};
            return MessageFormat.format(msg, args);
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private void setValueCounts() {
        PropertyInterface p;
        int i;
        int xCount = 0;
        int yCount = 0;
        int clusterBarCount = -1;
        boolean showRespStatOnAxis = false;
        switch (this.componentType) {
            default: {
                return;
            }
            case 3: 
            case 4: 
        }
        if (this.equalizeValueCount && this.components != null) {
            for (i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof PropertyInterface)) continue;
                p = (PropertyInterface)this.components[i];
                Object v1 = p.getPropertyValue(42);
                Object v2 = p.getPropertyValue(43);
                Object tempClusterCount = p.getPropertyValue(826);
                Object tempRespStat = p.getPropertyValue(829);
                if (v1 instanceof Number) {
                    xCount = Math.max(xCount, ((Number)v1).intValue());
                }
                if (v2 instanceof Number) {
                    yCount = Math.max(yCount, ((Number)v2).intValue());
                }
                if (tempClusterCount instanceof Number) {
                    clusterBarCount = Math.max(clusterBarCount, ((Number)tempClusterCount).intValue());
                }
                if (!(tempRespStat instanceof Boolean) || showRespStatOnAxis) continue;
                showRespStatOnAxis = (Boolean)tempRespStat;
            }
        }
        xCount = Math.max(xCount, this.xValueCount);
        yCount = Math.max(yCount, this.yValueCount);
        if (this.components != null) {
            for (i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof PropertyInterface)) continue;
                p = (PropertyInterface)this.components[i];
                p.setPropertyValue(828, (Object)showRespStatOnAxis);
                if (xCount > 0) {
                    p.setPropertyValue(40, (Object)new Integer(xCount));
                }
                if (yCount > 0) {
                    p.setPropertyValue(41, (Object)new Integer(yCount));
                }
                if (clusterBarCount > 0) {
                    p.setPropertyValue(827, (Object)clusterBarCount);
                }
                p.applyPropertyChanges();
            }
        }
    }

    private void setupExternalAxes(boolean validateLayout) {
        GraphInterface g;
        AxisComponent axis;
        Component obj;
        int j;
        if (this.componentType == 5 || this.componentType == 8) {
            return;
        }
        if (this.components == null) {
            return;
        }
        if (!this.externalAxes) {
            this.showExternalAxes = false;
            this.displayInternalAxes(true);
            return;
        }
        if (this.components.length == 1) {
            this.showExternalAxes = false;
            this.displayInternalAxes(true);
            return;
        }
        this.showExternalAxes = true;
        RoleInterface r = null;
        Hashtable context = new Hashtable();
        Element xAxesXML = this.getInternalAxisStatgraphXML(0, context);
        Element yAxesXML = this.getInternalAxisStatgraphXML(1, context);
        this.displayInternalAxes(false);
        this.layout.setExternalAxesAlignment(1);
        for (int cntr = 0; cntr < this.components.length; ++cntr) {
            if (this.components[cntr] == null || r != null || !(this.components[cntr] instanceof RoleInterface)) continue;
            r = (RoleInterface)this.components[cntr];
            break;
        }
        boolean numericYAxis = this.response != null ? (this.response[0] != null ? this.filter.isNumericVariable((Object)this.response[0]) && !r.isDiscrete((Object)RoleInterface.ROLE_RESPONSE) : true) : true;
        boolean numericXAxis = this.category == null ? true : this.filter.isNumericVariable((Object)this.category) && !r.isDiscrete((Object)RoleInterface.ROLE_CATEGORY);
        boolean equalSpaceX = true;
        boolean equalSpaceY = true;
        if (this.componentType == 2 || this.componentType == 1) {
            if (this.response != null && this.response[0] != null && r.isDiscrete((Object)RoleInterface.ROLE_RESPONSE)) {
                equalSpaceY = false;
            }
            if (this.category != null && r.isDiscrete((Object)RoleInterface.ROLE_CATEGORY)) {
                equalSpaceX = false;
            }
        }
        for (j = 0; j < this.rows; ++j) {
            obj = this.lattice.getRowAxis(j, true);
            if (obj != null && obj instanceof AxisComponent) {
                axis = (AxisComponent)obj;
                axis.setEqualSpace(equalSpaceY);
                PropertyInterface p = null;
                for (int i = 0; i < this.components.length; ++i) {
                    if (this.components[i] == null || !(this.components[i] instanceof PropertyInterface)) continue;
                    p = (PropertyInterface)this.components[i];
                    break;
                }
                this.initExternalYAxes(axis, numericYAxis);
                continue;
            }
            if (obj != null) {
                this.externalYAxes.remove(obj);
            }
            this.lattice.removeRowAxis(j, true);
            axis = new AxisComponent();
            axis.setDimension((byte)2);
            axis.addMouseListener((MouseListener)this);
            axis.setPropertyValue(200, (Object)new Boolean(false));
            axis.setStyle(this.style);
            axis.applyPropertyChanges();
            axis.setEqualSpace(equalSpaceY);
            this.initExternalYAxes(axis, numericYAxis);
            this.lattice.addRowAxis(j, (Component)axis, true);
            for (int i = 0; i < this.columns; ++i) {
                Component o = this.lattice.getCellItem(j, i);
                if (!(o instanceof GraphInterface)) continue;
                g = (GraphInterface)o;
                g.setExternalAxis((Object)"Y", (AxisInterface)axis);
            }
            this.externalYAxes.add(axis);
        }
        for (j = 0; j < this.columns; ++j) {
            obj = this.lattice.getColumnAxis(j, true);
            if (obj != null && obj instanceof AxisComponent) {
                axis = (AxisComponent)obj;
                axis.setInnerMarginAdjust(true);
                axis.setEqualSpace(equalSpaceX);
                this.initExternalXAxes(axis, numericXAxis);
                axis.setLabel(this.filter.getVariableDescription((Object)this.category));
                continue;
            }
            if (obj != null) {
                this.externalXAxes.remove(obj);
            }
            this.lattice.removeColumnAxis(j, true);
            axis = new AxisComponent(1, this.category);
            axis.setInnerMarginAdjust(true);
            axis.addMouseListener((MouseListener)this);
            axis.setPropertyValue(200, (Object)new Boolean(false));
            axis.setStyle(this.style);
            axis.applyPropertyChanges();
            axis.setEqualSpace(equalSpaceX);
            this.initExternalXAxes(axis, numericXAxis);
            this.lattice.addColumnAxis(j, (Component)axis, true);
            for (int i = 0; i < this.rows; ++i) {
                Component o = this.lattice.getCellItem(i, j);
                if (!(o instanceof GraphInterface)) continue;
                g = (GraphInterface)o;
                g.setExternalAxis((Object)"X", (AxisInterface)axis);
            }
            this.externalXAxes.add(axis);
        }
        context = new Hashtable();
        this.initAxesFromXML(0, context, xAxesXML);
        this.initAxesFromXML(1, context, yAxesXML);
        this.lattice.installColumnRangeListeners();
        this.lattice.installRowRangeListeners();
        this.lattice.installMarginListeners();
        if (validateLayout) {
            this.invalidate();
            this.validate();
        }
    }

    private void initExternalXAxes(AxisComponent axis, boolean numericXAxis) {
        Object o;
        if (axis == null) {
            return;
        }
        PropertyInterface p = null;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null || !(this.components[i] instanceof PropertyInterface)) continue;
            p = (PropertyInterface)this.components[i];
            break;
        }
        if (numericXAxis) {
            int numBins = -1;
            if (p != null && this.category != null) {
                o = p.getPropertyValue(805);
                if (o != null && o instanceof Number) {
                    numBins = ((Number)o).intValue();
                } else {
                    o = p.getPropertyValue(333664);
                    if (o instanceof Number) {
                        numBins = ((Number)o).intValue();
                    }
                }
            }
            if (numBins > 0) {
                axis.setAutoCalculate(false);
                axis.setNumMajorTickMarks(numBins + 1);
            }
        }
        if (p instanceof PropertyInterface) {
            Object axisFormat = p.getPropertyValue(19055);
            axis.setValues(axisFormat);
            p.setPropertyValue(238, (Object)"X");
            o = p.getPropertyValue(229);
            if (o instanceof Boolean) {
                axis.setGridLines(o);
            }
            if ((o = p.getPropertyValue(204)) instanceof String) {
                axis.setLabel(o);
            }
            o = p.getPropertyValue(267);
            axis.setPropertyValue(267, o);
            o = p.getPropertyValue(19067);
            if (o instanceof Number) {
                axis.setMinDiscreteTickCount(((Integer)o).intValue());
            }
            axis.applyPropertyChanges();
            p.applyPropertyChanges();
        }
    }

    private void initExternalYAxes(AxisComponent axis, boolean numericYAxis) {
        Object o;
        if (axis == null) {
            return;
        }
        PropertyInterface p = null;
        if (this.yVariable != null) {
            axis.setLabel(this.filter.getVariableDescription((Object)this.yVariable));
        } else if (this.response == null) {
            axis.setLabel((Object)"");
        } else if (this.response.length > 1) {
            axis.setLabel((Object)"");
        } else {
            axis.setLabel(this.filter.getVariableDescription((Object)this.response[0]));
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null || !(this.components[i] instanceof PropertyInterface)) continue;
            p = (PropertyInterface)this.components[i];
            break;
        }
        if (numericYAxis) {
            int numBins = -1;
            if (p != null && this.yVariable != null) {
                o = p.getPropertyValue(806);
                if (o != null && o instanceof Number) {
                    numBins = ((Number)o).intValue();
                } else {
                    o = p.getPropertyValue(333665);
                    if (o instanceof Number) {
                        numBins = ((Number)o).intValue();
                    }
                }
            }
            if (numBins > 0) {
                axis.setAutoCalculate(false);
                axis.setNumMajorTickMarks(numBins + 1);
                axis.setInnerMarginAdjust(true);
            } else if (this.componentType == 4 && this.yVariable != null) {
                axis.setInnerMarginAdjust(false);
            } else {
                axis.setInnerMarginAdjust(true);
            }
        } else {
            axis.setInnerMarginAdjust(true);
        }
        if (p instanceof PropertyInterface) {
            Object axisFormat = p.getPropertyValue(19054);
            axis.setValues(axisFormat);
            p.setPropertyValue(238, (Object)"Y");
            o = p.getPropertyValue(229);
            if (o instanceof Boolean) {
                axis.setGridLines(o);
            }
            if ((o = p.getPropertyValue(204)) instanceof String) {
                axis.setLabel(o);
            }
            o = p.getPropertyValue(237);
        }
    }

    private void updateExternalAxes() {
        Component obj;
        AxisComponent axis;
        int j;
        if (this.yAxesVisible && this.externalYAxes != null) {
            for (j = 0; j < this.externalYAxes.size(); ++j) {
                if (!(this.externalYAxes.get(j) instanceof AxisComponent)) continue;
                axis = (AxisComponent)this.externalYAxes.get(j);
                this.lattice.addRowAxis(j, (Component)axis, true);
            }
        } else {
            for (j = 0; j < this.rows; ++j) {
                obj = this.lattice.getRowAxis(j, true);
                this.lattice.removeRowAxis(j, true);
            }
        }
        if (this.xAxesVisible && this.externalXAxes != null) {
            for (j = 0; j < this.externalXAxes.size(); ++j) {
                if (!(this.externalXAxes.get(j) instanceof AxisComponent)) continue;
                axis = (AxisComponent)this.externalXAxes.get(j);
                this.lattice.addColumnAxis(j, (Component)axis, true);
            }
        } else {
            for (j = 0; j < this.columns; ++j) {
                obj = this.lattice.getColumnAxis(j, true);
                this.lattice.removeColumnAxis(j, true);
            }
        }
    }

    private void removeExternalAxes(int axis) {
        switch (axis) {
            case 0: {
                for (int j = 0; j < this.rows; ++j) {
                    Component obj = this.lattice.getRowAxis(j, true);
                    this.lattice.removeRowAxis(j, true);
                }
                this.externalXAxes.clear();
                break;
            }
            case 1: {
                for (int j = 0; j < this.columns; ++j) {
                    Component obj = this.lattice.getColumnAxis(j, true);
                    this.lattice.removeColumnAxis(j, true);
                }
                this.externalYAxes.clear();
                break;
            }
        }
    }

    private void displayInternalAxes(boolean show) {
        if (this.componentType == 5 || this.componentType == 8) {
            return;
        }
        Hashtable context = null;
        Element xAxesXML = null;
        Element yAxesXML = null;
        if (show) {
            xAxesXML = this.getAxisStatgraphXML(0, context);
            yAxesXML = this.getAxisStatgraphXML(1, context);
            this.layout.setExternalAxesAlignment(0);
            this.removeExternalAxes(0);
            this.removeExternalAxes(1);
        }
        for (int cntr = 0; cntr < this.components.length; ++cntr) {
            if (this.components[cntr] == null || !(this.components[cntr] instanceof GraphInterface) || !(this.components[cntr] instanceof PropertyInterface)) continue;
            PropertyInterface p = (PropertyInterface)this.components[cntr];
            p.setPropertyValue(238, (Object)new Integer(0));
            p.setPropertyValue(237, (Object)(Boolean.valueOf(show) != false && this.xAxesVisible ? 1 : 0));
            p.setPropertyValue(238, (Object)new Integer(1));
            p.setPropertyValue(237, (Object)(Boolean.valueOf(show) != false && this.yAxesVisible ? 1 : 0));
            if (show) {
                p.setPropertyValue(32, (Object)new Integer(5));
                p.setPropertyValue(33, (Object)new Integer(5));
            } else {
                p.setPropertyValue(32, (Object)new Integer(0));
                p.setPropertyValue(33, (Object)new Integer(0));
            }
            p.applyPropertyChanges();
        }
        if (show) {
            this.initInternalAxesFromXML(0, context, xAxesXML);
            this.initInternalAxesFromXML(1, context, yAxesXML);
        }
    }

    private Object[] getUniqueValues(Object var, int sortOrder) {
        if (this.filter == null || var == null) {
            return null;
        }
        UniqueValueMapper uvm = new UniqueValueMapper();
        int varIndex = this.filter.getVariableIndex(var);
        if (varIndex < 0) {
            this.invalidVariableAssignment = true;
            return null;
        }
        int numObs = this.filter.getNumberObservations(varIndex);
        for (int i = 0; i < numObs; ++i) {
            uvm.addValue(this.filter.getValue(varIndex, (long)i));
        }
        int sort = 0;
        switch (sortOrder) {
            case -1: {
                sort = -1;
                break;
            }
            case 1: {
                sort = 1;
                break;
            }
            default: {
                sort = 0;
            }
        }
        return uvm.getValues(sort);
    }

    private void computeNumberOfCharts() {
        int size1 = 0;
        int size2 = 0;
        int varIndex = -1;
        int remainder = 0;
        if (this.dataSource == null || this.filter == null) {
            return;
        }
        this.invalidVariableAssignment = false;
        if (this.col == null || this.row == null) {
            int sortOrder;
            String var = this.row != null ? this.row : this.col;
            Object[] uniqueValues = this.getUniqueValues(var, sortOrder = this.row != null ? this.sortOrderY : this.sortOrderX);
            if (uniqueValues == null) {
                this.columns = 0;
                this.rows = 0;
                return;
            }
            this.primaryByVariableValues = uniqueValues;
            size1 = uniqueValues.length;
            varIndex = this.filter.getVariableIndex((Object)var);
            if (varIndex < 0) {
                this.invalidVariableAssignment = true;
                return;
            }
            this.numDivisions = this.wrapEnabled ? (this.userSetNumDivisions > 0 && this.userSetNumDivisions <= size1 ? this.userSetNumDivisions : (this.userSetNumDivisions >= size1 ? size1 : -1)) : size1;
            if (this.numDivisions != -1 && this.numDivisions <= size1) {
                if (this.row != null) {
                    this.rows = this.numDivisions;
                    this.columns = size1 / this.rows;
                    remainder = size1 % this.rows;
                    if (remainder > 0) {
                        ++this.columns;
                    }
                } else {
                    this.columns = this.numDivisions;
                    this.rows = size1 / this.columns;
                    remainder = size1 % this.columns;
                    if (remainder > 0) {
                        ++this.rows;
                    }
                }
            } else {
                int[] gridSize = this.computeGridSize(size1);
                if (gridSize == null || gridSize.length != 2) {
                    if (this.row != null) {
                        this.rows = size1;
                        this.columns = 1;
                    } else {
                        this.rows = 1;
                        this.columns = size1;
                    }
                } else {
                    if (this.row != null) {
                        this.rows = gridSize[0];
                        this.columns = gridSize[1];
                    } else {
                        this.rows = gridSize[1];
                        this.columns = gridSize[0];
                    }
                    this.numDivisions = gridSize[0];
                }
            }
            this.maxDivisions = size1;
        } else {
            varIndex = this.filter.getVariableIndex((Object)this.row);
            if (varIndex < 0) {
                this.invalidVariableAssignment = true;
                return;
            }
            this.primaryByVariableValues = this.getUniqueValues(this.row, this.sortOrderY);
            if (this.primaryByVariableValues != null) {
                size1 = this.primaryByVariableValues.length;
            }
            if ((varIndex = this.filter.getVariableIndex((Object)this.col)) < 0) {
                this.invalidVariableAssignment = true;
                return;
            }
            this.secondaryByVariableValues = this.getUniqueValues(this.col, this.sortOrderX);
            if (this.secondaryByVariableValues != null) {
                size2 = this.secondaryByVariableValues.length;
            }
            this.rows = size1;
            this.columns = size2;
        }
        this.componentInCell = new boolean[this.rows][this.columns];
    }

    private int[] computeGridSize(int size) {
        if (size <= 3) {
            return null;
        }
        double sqrt = Math.sqrt(size);
        long round = Math.round(sqrt);
        double ceil = Math.ceil(sqrt);
        int[] gridSize = new int[2];
        if (Math.abs(sqrt - (double)round) < 1.0E-4) {
            gridSize[0] = gridSize[1] = (int)sqrt;
        } else if (sqrt - (double)round > 0.0) {
            gridSize[0] = (int)ceil;
            gridSize[1] = (int)Math.ceil((double)size / ceil);
        } else {
            gridSize[0] = (int)(ceil + 1.0);
            gridSize[1] = (int)Math.ceil((double)size / (ceil + 1.0));
        }
        return gridSize;
    }

    private JComponent createComponent(int compType, Object byVar1, Object byVar2) {
        Object rc = null;
        switch (compType) {
            case 1: {
                rc = this.createLineComponent(byVar1, byVar2);
                break;
            }
            case 2: {
                rc = this.createScatterComponent(byVar1, byVar2);
                break;
            }
            case 3: {
                rc = this.createBarComponent(byVar1, byVar2);
                break;
            }
            case 4: {
                rc = this.createHistogramComponent(byVar1, byVar2);
                break;
            }
            case 14: {
                rc = this.createHistogramParmComponent(byVar1, byVar2);
                break;
            }
            case 5: {
                rc = this.createPieComponent(byVar1, byVar2);
                break;
            }
            case 6: {
                rc = this.createBoxComponent(byVar1, byVar2);
                break;
            }
            case 8: {
                rc = this.createTableComponent(byVar1, byVar2);
                break;
            }
            case 7: {
                rc = this.createSpectrumComponent(byVar1, byVar2);
                break;
            }
            case 10: {
                rc = this.create3DComponent("com.sas.graphics.silk.Bar3DComponent", byVar1, byVar2);
                break;
            }
            case 11: {
                rc = this.create3DComponent("com.sas.graphics.silk.SurfaceComponent", byVar1, byVar2);
                break;
            }
            case 9: {
                rc = this.create3DComponent("com.sas.graphics.silk.Scatter3DComponent", byVar1, byVar2);
                break;
            }
            case 12: {
                rc = this.createDensityPlotComponent(byVar1, byVar2);
                break;
            }
            case 13: {
                rc = this.createSequencePlotComponent(byVar1, byVar2);
                break;
            }
            case 17: {
                rc = this.createIcicleComponent(byVar1, byVar2);
                break;
            }
            case 18: {
                rc = this.createDTreeComponent(byVar1, byVar2);
                break;
            }
            case 19: {
                rc = this.createConstellationComponent(byVar1, byVar2);
                break;
            }
            case 20: {
                rc = this.createHeatmapComponent(byVar1, byVar2);
                break;
            }
            default: {
                rc = new JLabel();
            }
        }
        if (rc instanceof BaseComponentInterface) {
            ((BaseComponentInterface)rc).setChartTipsOn(false);
        }
        if (this.cellSizeSet) {
            ((JComponent)rc).setPreferredSize(this.minCellSize);
            ((JComponent)rc).setMinimumSize(this.minCellSize);
        }
        return rc;
    }

    private JComponent create3DComponent(String className, Object primaryByVariableValue, Object secondaryByVariableValue) {
        try {
            Class<?> cls = Class.forName(className);
            Object o = cls.newInstance();
            if (!(o instanceof JComponent)) {
                return null;
            }
            if (o instanceof SourceInterface) {
                ((SourceInterface)o).setDataSource(this.dataSource);
            }
            String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
            if (o instanceof GraphInterface) {
                ((GraphInterface)o).applyWhereClause(whereClause, true);
            }
            return (JComponent)o;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private JComponent createSequencePlotComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        HeatmapComponent heat = new HeatmapComponent();
        heat.setDataSource(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        heat.applyWhereClause(whereClause, true);
        return heat;
    }

    private JComponent createDensityPlotComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        DensityPlotComponent dp = new DensityPlotComponent();
        dp.setDataSource(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        dp.applyWhereClause(whereClause, true);
        return dp;
    }

    private LinePlotComponent createLineComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        LinePlotComponent line = new LinePlotComponent();
        line.setDataSource(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        line.applyWhereClause(whereClause, true);
        return line;
    }

    private BaseScatterComponent createScatterComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        BaseScatterComponent scatter = new BaseScatterComponent();
        scatter.setDataSource(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        scatter.applyWhereClause(whereClause, true);
        return scatter;
    }

    private VerticalBarComponent createBarComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        VerticalBarComponent bar = new VerticalBarComponent();
        bar.setDataSource(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        bar.applyWhereClause(whereClause, true);
        return bar;
    }

    private BaseHistComponent createHistogramComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        BaseHistComponent hist = new BaseHistComponent();
        hist.setDataSource(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        hist.applyWhereClause(whereClause, true);
        return hist;
    }

    private HistogramParmComponent createHistogramParmComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        HistogramParmComponent hist = new HistogramParmComponent();
        hist.setDataSource(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        hist.applyWhereClause(whereClause, true);
        return hist;
    }

    private PieComponent createPieComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        PieComponent pie = new PieComponent();
        pie.setDataSource(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        pie.applyWhereClause(whereClause, true);
        return pie;
    }

    private BoxPlotComponent createBoxComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        BoxPlotComponent box = new BoxPlotComponent();
        box.setDataSource(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        box.applyWhereClause(whereClause, true);
        return box;
    }

    private JTableComponent createTableComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        JTableComponent table = new JTableComponent(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        table.applyWhereClause(whereClause, true);
        table.setPreferredSize(table.getSize());
        return table;
    }

    private SpectrumPlotComponent createSpectrumComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        SpectrumPlotComponent spect = new SpectrumPlotComponent();
        spect.setDataSource(this.dataSource);
        DataFilterReadInterface fltr = spect.getFilter();
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        fltr.applyWhereClause(whereClause, true);
        spect.setRole(this.category, RoleInterface.ROLE_X);
        if (this.yVariable != null) {
            spect.setRole(this.yVariable, RoleInterface.ROLE_Y);
        }
        if (this.response != null) {
            spect.setRole(this.response[0], RoleInterface.ROLE_RESPONSE);
        }
        spect.setRole(this.statisticType, RoleInterface.ROLE_STATISTIC_TYPE);
        return spect;
    }

    private Icicle createIcicleComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        Icicle icicle = new Icicle();
        icicle.setDataSource(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        icicle.applyWhereClause(whereClause, true);
        return icicle;
    }

    private DecisionTree createDTreeComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        DecisionTree dTree = new DecisionTree();
        dTree.setDataSource(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        dTree.applyWhereClause(whereClause, true);
        dTree.setFitToPageMode(true);
        dTree.setPropertyValue(5032, false);
        dTree.applyPropertyChanges();
        return dTree;
    }

    private ConstComponent createConstellationComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        ConstComponent cosntComp = new ConstComponent();
        cosntComp.setModelMode(1);
        cosntComp.setDataSource(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        cosntComp.applyWhereClause(whereClause, true);
        cosntComp.setPropertyValue(872, 1);
        cosntComp.setPropertyValue(873, Boolean.FALSE);
        cosntComp.applyPropertyChanges();
        return cosntComp;
    }

    private BaseHeatmapComponent createHeatmapComponent(Object primaryByVariableValue, Object secondaryByVariableValue) {
        BaseHeatmapComponent bec = new BaseHeatmapComponent();
        bec.setDataSource(this.dataSource);
        String whereClause = this.buildWhereClause(primaryByVariableValue, secondaryByVariableValue);
        bec.applyWhereClause(whereClause, true);
        return bec;
    }

    private StripLabel createStripLabel(String labl, int obsNo, int total, Color hdrClr) {
        StripLabel label = null;
        label = new StripLabel(labl);
        label.setForeground(this.labelColor);
        if (this.showLabelBorder) {
            label.setBorder(this.border);
        }
        label.setHorizontalAlignment(0);
        if (this.showCellHeaderHilite && obsNo != -1 && total != -1) {
            double lowPercentage = (double)obsNo / (double)total;
            double highPercentage = (double)(obsNo + 1) / (double)total;
            label.setLow(lowPercentage);
            label.setHigh(highPercentage);
            label.setHilite(hdrClr);
        }
        label.setFont(label.getFont().deriveFont(this.computeStripLabelFontSize((JLabel)label)));
        return label;
    }

    private float computeStripLabelFontSize(JLabel label) {
        float font_size = label.getFont().getSize();
        if (this.cellSize != null) {
            double cellHeight = this.cellSize.height - 50;
            font_size = (float)(cellHeight * 0.021 * 1.38889);
            if (font_size < 9.0f) {
                font_size = 9.0f;
            } else if (font_size > 16.0f) {
                font_size = 16.0f;
            }
        }
        return font_size;
    }

    private Object replaceWithMissingNotation(Object value) {
        if (value instanceof Number && Double.isNaN(((Number)value).doubleValue())) {
            value = ".";
        }
        return value;
    }

    private String buildWhereClause(Object primaryByVariableValue, Object secondaryByVariableValue) {
        if (primaryByVariableValue == null && secondaryByVariableValue == null) {
            return null;
        }
        String quote1 = primaryByVariableValue instanceof Number ? "" : "\"";
        String quote2 = secondaryByVariableValue instanceof Number ? "" : "\"";
        primaryByVariableValue = this.replaceWithMissingNotation(primaryByVariableValue);
        secondaryByVariableValue = this.replaceWithMissingNotation(secondaryByVariableValue);
        StringBuffer sb = new StringBuffer();
        if (secondaryByVariableValue == null) {
            sb.append("(");
            sb.append(this.primaryByVariable);
            sb.append(" = ");
            sb.append(quote1);
            sb.append(primaryByVariableValue);
            sb.append(quote1);
            sb.append(")");
        } else {
            sb.append("(");
            sb.append(this.row);
            sb.append(" = ");
            sb.append(quote1);
            sb.append(primaryByVariableValue);
            sb.append(quote1);
            sb.append(" & ");
            sb.append(this.col);
            sb.append(" = ");
            sb.append(quote2);
            sb.append(secondaryByVariableValue);
            sb.append(quote2);
            sb.append(")");
        }
        if (this.currentWhereClause != null && this.currentWhereClause.trim().length() > 0) {
            sb.append(" & ");
            sb.append("(");
            sb.append(this.currentWhereClause);
            sb.append(")");
        }
        return sb.toString();
    }

    private void setLatticeSize() {
        if (this.lattice == null) {
            return;
        }
        Rectangle r = this.graphLayout.getChartArea();
        if (r != null) {
            this.lattice.setBounds(r);
        }
    }

    public int getNumberOfDivisions() {
        return this.numDivisions;
    }

    public int getUserSetNumberOfDivisions() {
        return this.userSetNumDivisions;
    }

    public void setNumberOfDivisions(int num) {
        this.userSetNumDivisions = num;
        this.rebuildLattice();
    }

    public boolean setCellSize(Dimension d) {
        if (d == null) {
            return false;
        }
        this.cellSize = new Dimension(d);
        this.minCellSize = new Dimension(d);
        this.cellSizeSet = true;
        this.setLatticeSize();
        return true;
    }

    public boolean setCellSize(int w, int ht) {
        if (w <= 0 || ht <= 0) {
            return false;
        }
        this.cellSize = new Dimension(w, ht);
        this.minCellSize = new Dimension(w, ht);
        this.cellSizeSet = true;
        this.setLatticeSize();
        return true;
    }

    public Dimension getCellSize() {
        return this.minCellSize;
    }

    public void updateCellHeaderFontSize() {
        if (this.components != null) {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    int index = r * this.columns + c;
                    if (index >= this.components.length || !(this.components[index] instanceof GraphInterface)) continue;
                    int numHdrs = this.layout.getCell(r, c).getNumHeaders();
                    for (int i = 0; i < numHdrs; ++i) {
                        StripLabel label = (StripLabel)this.lattice.getCellHeader(r, c, i);
                        label.setFont(label.getFont().deriveFont(this.computeStripLabelFontSize((JLabel)label)));
                    }
                }
            }
        }
    }

    public void setShowCellHeaderHilite(boolean flag) {
        boolean cellHeaderChanged = flag != this.showCellHeaderHilite;
        this.showCellHeaderHilite = flag;
        if (cellHeaderChanged && this.components != null) {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    if (r * this.columns + c >= this.components.length || !(this.components[r * this.columns + c] instanceof GraphInterface)) continue;
                    int numHdrs = this.layout.getCell(r, c).getNumHeaders();
                    for (int i = 0; i < numHdrs; ++i) {
                        StripLabel label = (StripLabel)this.lattice.getCellHeader(r, c, i);
                        if (this.showCellHeaderHilite) {
                            Color clr = i == 0 ? this.cellHeaderColor1 : (i == 1 && this.secondaryByVariable != null ? this.cellHeaderColor2 : this.cellHeaderColor3);
                            label.setHilite(clr);
                            continue;
                        }
                        label.setHilite(this.backgroundColor);
                    }
                }
            }
            this.repaint();
        }
    }

    public void setShowNumberObs(boolean flag) {
        if (!this.internalCellHeaders) {
            return;
        }
        boolean showNumObsChanged = flag != this.showNumObs;
        this.showNumObs = flag;
        if (showNumObsChanged && this.components != null) {
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    if (r * this.columns + c >= this.components.length || !(this.components[r * this.columns + c] instanceof GraphInterface)) continue;
                    int index = this.secondaryByVariable != null ? 2 : 1;
                    if (!this.showNumObs) {
                        this.lattice.removeCellHeader(r, c, index);
                        continue;
                    }
                    int nobs = ((GraphInterface)this.components[r * this.columns + c]).getFilter().getNumberObservations(null);
                    Object[] args = new Object[]{new Integer(nobs), new Integer(this.filter.getNumberObservations(null))};
                    String result = MessageFormat.format(this.msg2, args);
                    StripLabel label = this.createStripLabel(result, -1, -1, this.cellHeaderColor3);
                    this.lattice.addCellHeader(r, c, index, (JComponent)label);
                }
            }
            this.validate();
            this.repaint();
        }
    }

    public void setShowLabelBorder(boolean flag) {
        this.showLabelBorder = flag;
    }

    public void setShowComponentBorder(boolean flag) {
        this.showComponentBorder = flag;
    }

    public void setShowAxisLabels(boolean flag) {
    }

    public String getResponseVariable() {
        return this.response[0];
    }

    public String getResponseVariable(int index) {
        if (index > this.response.length) {
            return null;
        }
        return this.response[index];
    }

    public String getCategoryVariable() {
        return this.category;
    }

    public String getGroupVariable() {
        return this.group;
    }

    public String getRowVariable() {
        return this.row;
    }

    public String getColVariable() {
        return this.col;
    }

    public boolean setResponseVariable(String resp) {
        if (resp == null) {
            return false;
        }
        this.response[0] = resp;
        return true;
    }

    public boolean setCategoryVariable(String cat) {
        if (cat == null) {
            return false;
        }
        this.category = cat;
        return true;
    }

    public boolean setGroupVariable(String grp) {
        if (grp == null) {
            return false;
        }
        this.group = grp;
        return true;
    }

    public boolean setSubgroupVariable(String sub_group) {
        if (sub_group == null) {
            return false;
        }
        this.subgroup = sub_group;
        return true;
    }

    public boolean setRowVariable(String rowVar) {
        if (rowVar == null) {
            return false;
        }
        this.row = rowVar;
        return true;
    }

    public boolean setColVariable(String colVar) {
        if (colVar == null) {
            return false;
        }
        this.col = colVar;
        return true;
    }

    public void setAggressiveMonitoring(boolean flag) {
        this.aggressiveMonitoring = flag;
    }

    public boolean isMonitoringAggressive() {
        return this.aggressiveMonitoring;
    }

    private boolean areByVariableValuesConsistent() {
        int sortOrder = this.row == this.primaryByVariable ? this.sortOrderY : this.sortOrderX;
        Object[] newByVarValuesList = this.getUniqueValues(this.primaryByVariable, sortOrder);
        if (newByVarValuesList == null || newByVarValuesList.length != this.primaryByVariableValues.length) {
            return false;
        }
        if (this.secondaryByVariable != null) {
            newByVarValuesList = this.getUniqueValues(this.secondaryByVariable, sortOrder = sortOrder == this.sortOrderY ? this.sortOrderX : this.sortOrderY);
            if (newByVarValuesList.length != this.secondaryByVariableValues.length) {
                return false;
            }
            String prevWhereClause = this.filter.getWhereClause();
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    String whereClause = this.buildWhereClause(this.primaryByVariableValues[r], this.secondaryByVariableValues[c]);
                    String clause = prevWhereClause + " & " + whereClause;
                    this.filter.applyWhereClause(clause, true);
                    int nobs = this.filter.getNumberObservations(null);
                    if (this.componentInCell[r][c] && nobs <= 0) {
                        return false;
                    }
                    if (this.componentInCell[r][c] || nobs <= 0) continue;
                    return false;
                }
            }
            this.filter.applyWhereClause(prevWhereClause, true);
        }
        return true;
    }

    public void setInnerMargin(int t, int l, int b, int r) {
    }

    public void setOuterMargin(int t, int l, int b, int r) {
    }

    public int getNumberOfPages() {
        if (this.printToOnePage) {
            return 1;
        }
        int numCharts = this.secondaryByVariable == null ? this.primaryByVariableValues.length : this.primaryByVariableValues.length * this.secondaryByVariableValues.length;
        return numCharts;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        int numLabels;
        int c;
        int r;
        if (this.components == null) {
            return 1;
        }
        int numCharts = this.secondaryByVariable == null ? this.primaryByVariableValues.length : this.primaryByVariableValues.length * this.secondaryByVariableValues.length;
        this.verifySize();
        if (this.printDebugging) {
            System.out.println("lattice size : " + this.getSize());
            System.out.println("hGap = " + this.hGap + " vGap = " + this.vGap);
            System.out.println("cell size : " + this.cellSize);
            System.out.println("min cell size : " + this.minCellSize);
            return 1;
        }
        if (this.printToOnePage) {
            if (pageIndex == 0) {
                Dimension d;
                Graphics2D g2 = (Graphics2D)graphics;
                if (!this.cellSizeSet) {
                    d = this.getSize();
                } else {
                    int c2 = 0;
                    for (c2 = 0; c2 < this.components.length && this.components[c2] == null; ++c2) {
                    }
                    if (c2 >= this.components.length) {
                        return 1;
                    }
                    Dimension compD = this.getComponentSize();
                    Dimension stripLabelD1 = new Dimension(0, 0);
                    Dimension stripLabelD2 = new Dimension(0, 0);
                    Dimension stripLabelD3 = new Dimension(0, 0);
                    if (this.layout.getCell(0, 0).getNumHeaders() > 0) {
                        Component stripLabel = this.lattice.getCellHeader(0, 0, 0);
                        if (stripLabel != null) {
                            stripLabelD1 = stripLabel.getSize();
                        }
                        if ((stripLabel = this.secondaryByVariable != null ? this.lattice.getCellHeader(0, 0, 1) : null) != null) {
                            stripLabelD2 = stripLabel.getSize();
                        }
                        if ((stripLabel = this.showNumObs ? this.lattice.getCellHeader(0, 0, 2) : null) != null) {
                            stripLabelD3 = stripLabel.getSize();
                        }
                    }
                    int wd = compD.width * this.columns + this.vGap * (this.columns - 1);
                    int ht = (compD.height + stripLabelD1.height + stripLabelD2.height + stripLabelD3.height) * this.rows + this.hGap * (this.rows - 1);
                    int w = 0;
                    int h = 0;
                    Rectangle r2 = this.graphLayout.getChartArea();
                    if (r2 != null) {
                        w = this.compWidth - r2.width;
                        h = this.compHeight - r2.height;
                    }
                    d = new Dimension(wd += w, ht += h);
                }
                double scaleX = pageFormat.getImageableWidth() / (double)d.width;
                double scaleY = pageFormat.getImageableHeight() / (double)d.height;
                double scale = Math.min(scaleX, scaleY);
                double w = scale * (double)d.width;
                double ht = scale * (double)d.height;
                int xTrans = (int)Math.max((pageFormat.getImageableWidth() - w) / 2.0, 0.0);
                int yTrans = (int)Math.max((pageFormat.getImageableHeight() - ht) / 2.0, 0.0);
                g2.translate(pageFormat.getImageableX() + (double)xTrans, pageFormat.getImageableY() + (double)yTrans);
                AffineTransform defaultXfm = g2.getTransform();
                AffineTransform xfm = new AffineTransform(defaultXfm);
                xfm.scale(scale, scale);
                g2.setTransform(xfm);
                Rectangle bounds = this.getBounds();
                this.setBounds(bounds.x, bounds.y, d.width, d.height);
                this.validate();
                this.paint(g2);
                this.setBounds(bounds);
                this.validate();
                return 0;
            }
            return 1;
        }
        if (this.type == 1) {
            r = pageIndex / this.columns;
            c = pageIndex % this.columns;
        } else {
            r = pageIndex % this.rows;
            c = pageIndex / this.rows;
        }
        if (pageIndex >= numCharts || !this.componentInCell[r][c]) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Dimension[] labelSizes = this.getLabelSizes();
        Dimension cSize = this.getComponentSize();
        int cWidth = cSize.width;
        int cHeight = cSize.height;
        if (labelSizes != null) {
            for (int i = 0; i < labelSizes.length; ++i) {
                cHeight += labelSizes[i].height;
            }
        }
        double scaleX = pageFormat.getImageableWidth() / (double)cWidth;
        double scaleY = pageFormat.getImageableHeight() / (double)cHeight;
        double scale = Math.min(scaleX, scaleY);
        AffineTransform defaultXfm = g2.getTransform();
        AffineTransform xfm = new AffineTransform(defaultXfm);
        xfm.scale(scale, scale);
        g2.setTransform(xfm);
        int n = numLabels = this.secondaryByVariable == null ? 1 : 2;
        if (this.showNumObs) {
            ++numLabels;
        }
        BufferedImage buffImg = new BufferedImage(cWidth, cHeight, 1);
        this.initBuffer(buffImg, cWidth, cHeight, this.getBackground());
        Graphics2D g3 = (Graphics2D)buffImg.getGraphics();
        for (int i = 0; i < numLabels; ++i) {
            StripLabel label = (StripLabel)this.lattice.getCellHeader(r, c, i);
            int labelHeight = label.getSize().height;
            int labelWidth = label.getSize().width;
            int ht = labelHeight;
            int wd = labelWidth;
            if (labelSizes != null) {
                ht = labelSizes[i].height;
                wd = labelSizes[i].width;
            }
            label.setSize(wd, ht);
            label.paint((Graphics)g3);
            label.setSize(labelWidth, labelHeight);
            g3.translate(0, ht);
        }
        Dimension s = this.components[pageIndex].getSize();
        this.components[pageIndex].setSize(cWidth, cSize.height);
        this.components[pageIndex].paint(g3);
        g2.drawImage(buffImg, 0, 0, this.getBackground(), (ImageObserver)((Object)this));
        this.components[pageIndex].setSize(s);
        return 0;
    }

    protected Dimension[] getLabelSizes() {
        int numLabels;
        if (this.components == null || this.lattice == null) {
            return null;
        }
        int n = numLabels = this.secondaryByVariable == null ? 1 : 2;
        if (this.showNumObs) {
            ++numLabels;
        }
        if (!this.internalCellHeaders) {
            numLabels = 0;
        }
        Dimension[] labelSizes = new Dimension[numLabels];
        for (int i = 0; i < this.components.length; ++i) {
            int c;
            int r;
            if (this.type == 1) {
                r = i / this.columns;
                c = i % this.columns;
            } else {
                r = i % this.rows;
                c = i / this.rows;
            }
            for (int j = 0; j < numLabels; ++j) {
                StripLabel label = (StripLabel)this.lattice.getCellHeader(r, c, j);
                if (label == null) continue;
                if (labelSizes[j] == null) {
                    labelSizes[j] = new Dimension();
                }
                Dimension size = label.getSize();
                labelSizes[j].width = Math.max(size.width, labelSizes[j].width);
                labelSizes[j].height = Math.max(size.height, labelSizes[j].height);
            }
        }
        return labelSizes;
    }

    protected Dimension getComponentSize() {
        if (this.components == null) {
            return null;
        }
        int maxW = this.minCellSize.width;
        int maxH = this.minCellSize.height;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null) continue;
            Dimension s = this.components[i].getSize();
            maxW = Math.max(s.width, maxW);
            maxH = Math.max(s.height, maxH);
        }
        return new Dimension(maxW, maxH);
    }

    public void verifySize() {
        Dimension lSize = new Dimension(this.compWidth, this.compHeight);
        if (this.columns == 0 || this.rows == 0) {
            return;
        }
        int calcCellWidth = (lSize.width - (this.columns - 1) * this.hGap) / this.columns;
        int calcCellHeight = (lSize.height - (this.rows - 1) * this.vGap) / this.rows;
        if (calcCellWidth != this.cellSize.width || lSize.height / this.rows != this.cellSize.height) {
            this.cellSize.width = calcCellWidth;
            this.cellSize.height = calcCellHeight;
        }
    }

    public void initBuffer(BufferedImage buffImg, int w, int ht, Color clr) {
        int clrVal = clr.getRGB();
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < ht; ++j) {
                buffImg.setRGB(i, j, clrVal);
            }
        }
    }

    public void setPrintToOnePage(boolean flag) {
        this.printToOnePage = flag;
    }

    public void setEqualizeCategoricalAxes(boolean flag) {
        this.equalizeCategoricalAxes = flag;
    }

    public boolean isEqualizeCategoricalAxes() {
        return this.equalizeCategoricalAxes;
    }

    public void setEqualizeNumericalAxes(boolean flag) {
        this.equalizeNumericalAxes = flag;
    }

    public boolean isEqualizeNumericalAxes() {
        return this.equalizeNumericalAxes;
    }

    public void setEqualizationType(int type) {
    }

    public void setXEqualizationType(int type) {
        if (this.externalAxes) {
            switch (type) {
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    type = 4;
                }
            }
        }
        this.xEqualizationType = type;
        this.setupResponseSort();
        this.setupOtherbarOption();
    }

    public int getXEqualizationType() {
        return this.xEqualizationType;
    }

    public void setYEqualizationType(int type) {
        if (this.externalAxes) {
            switch (type) {
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    type = 4;
                }
            }
        }
        this.yEqualizationType = type;
        if (this.componentType == 3) {
            this.setupResponseSort();
        }
    }

    public int getYEqualizationType() {
        return this.yEqualizationType;
    }

    public void setZEqualizationType(int type) {
        this.zEqualizationType = type;
    }

    public int getZEqualizationType() {
        return this.zEqualizationType;
    }

    public boolean setLegendVisible(boolean flag) {
        return false;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (this.blockDataEvents) {
            return;
        }
        switch (evt.type) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                this.dataChanged(evt);
                return;
            }
            case 6: {
                this.formatChanged(evt);
                return;
            }
            case 2: {
                return;
            }
        }
    }

    public void dataChanged(DvrDataFilterEvent evt) {
        this.doEqualization();
    }

    public void formatChanged(DvrDataFilterEvent evt) {
    }

    private void doEqualization() {
        this.equalizeAxes();
    }

    private void equalizeAxes() {
        if (this.componentType == 5 || this.componentType == 8) {
            return;
        }
        if (this.components == null) {
            return;
        }
        if (this.components.length == 1) {
            return;
        }
        CellItemInterface item = null;
        DataRangeInterface dri = null;
        DataRange itemRange = null;
        DataRange range = null;
        DataRange[] rowRanges = new DataRange[this.rows];
        DataRange[] colRanges = new DataRange[this.columns];
        Component latticeAxis = null;
        Object gri = null;
        Enumeration enumeration = this.dimensions.elements();
        int axisType = -1;
        boolean buildSuccess = true;
        block14: while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof Integer)) continue;
            byte dim = ((Integer)obj).byteValue();
            int eqType = this.xEqualizationType;
            switch (dim) {
                default: {
                    eqType = this.xEqualizationType;
                    axisType = 0;
                    break;
                }
                case 2: {
                    eqType = this.yEqualizationType;
                    axisType = 1;
                    break;
                }
                case 3: {
                    eqType = this.zEqualizationType;
                    axisType = 2;
                }
            }
            switch (eqType) {
                case 4: {
                    int i;
                    range = null;
                    for (i = 0; i < this.components.length; ++i) {
                        UpdateInterface u;
                        if (this.components[i] == null) continue;
                        if (this.components[i] instanceof UpdateInterface && (u = (UpdateInterface)this.components[i]).isRebuildRequired()) {
                            boolean bl = buildSuccess = u.build(null) && buildSuccess;
                        }
                        if (!(this.components[i] instanceof CellItemInterface) || (dri = (item = (CellItemInterface)this.components[i]).getRangeSource(dim, 0)) == null || !buildSuccess) continue;
                        itemRange = dri.getDataRange(dim);
                        range = RangeMerger.mergeRange(range, (DataRange)itemRange);
                    }
                    if (range == null || !buildSuccess) break;
                    for (i = 0; i < this.components.length; ++i) {
                        if (this.components[i] == null || !(this.components[i] instanceof CellItemInterface)) continue;
                        item = (CellItemInterface)this.components[i];
                        item.setRange(dim, 0, range);
                    }
                    if (!this.showExternalAxes) break;
                    switch (dim) {
                        case 1: {
                            for (i = 0; i < this.columns; ++i) {
                                latticeAxis = this.lattice.getColumnAxis(i, true);
                                this.mergeAndSetExternalRange(range, latticeAxis);
                            }
                            continue block14;
                        }
                        case 2: {
                            for (i = 0; i < this.rows; ++i) {
                                latticeAxis = this.lattice.getRowAxis(i, true);
                                this.mergeAndSetExternalRange(range, latticeAxis);
                            }
                        }
                    }
                    continue block14;
                }
                case 2: {
                    UpdateInterface u;
                    int index;
                    int i;
                    for (i = 0; i < this.rows; ++i) {
                        rowRanges[i] = null;
                        for (int j = 0; j < this.columns; ++j) {
                            index = i * this.columns + j;
                            if (index >= this.components.length || this.components[index] == null) continue;
                            if (this.components[index] instanceof UpdateInterface && (u = (UpdateInterface)this.components[index]).isRebuildRequired()) {
                                boolean bl = buildSuccess = u.build(null) && buildSuccess;
                            }
                            if (!(this.components[index] instanceof CellItemInterface) || (dri = (item = (CellItemInterface)this.components[index]).getRangeSource(dim, 0)) == null || !buildSuccess) continue;
                            itemRange = dri.getDataRange(dim);
                            rowRanges[i] = RangeMerger.mergeRange((DataRange)rowRanges[i], (DataRange)itemRange);
                        }
                    }
                    if (!buildSuccess) break;
                    for (i = 0; i < this.rows; ++i) {
                        if (rowRanges[i] == null) continue;
                        for (int j = 0; j < this.columns; ++j) {
                            index = i * this.columns + j;
                            if (index >= this.components.length || this.components[index] == null || !(this.components[index] instanceof CellItemInterface)) continue;
                            item = (CellItemInterface)this.components[index];
                            item.setRange(dim, 0, rowRanges[i]);
                        }
                        if (!this.showExternalAxes || dim != 2) continue;
                        latticeAxis = this.lattice.getRowAxis(i, true);
                        this.mergeAndSetExternalRange(rowRanges[i], latticeAxis);
                    }
                    continue block14;
                }
                case 3: {
                    int j;
                    UpdateInterface u;
                    int index;
                    for (j = 0; j < this.columns; ++j) {
                        colRanges[j] = null;
                        for (int i = 0; i < this.rows; ++i) {
                            index = i * this.columns + j;
                            if (index >= this.components.length || this.components[index] == null) continue;
                            if (this.components[index] instanceof UpdateInterface && (u = (UpdateInterface)this.components[index]).isRebuildRequired()) {
                                boolean bl = buildSuccess = u.build(null) && buildSuccess;
                            }
                            if (!(this.components[index] instanceof CellItemInterface) || (dri = (item = (CellItemInterface)this.components[index]).getRangeSource(dim, 0)) == null || !buildSuccess) continue;
                            itemRange = dri.getDataRange(dim);
                            colRanges[j] = RangeMerger.mergeRange((DataRange)colRanges[j], (DataRange)itemRange);
                        }
                    }
                    if (!buildSuccess) break;
                    for (j = 0; j < this.columns; ++j) {
                        if (colRanges[j] == null) continue;
                        for (int i = 0; i < this.rows; ++i) {
                            index = i * this.columns + j;
                            if (index >= this.components.length || this.components[index] == null || !(this.components[index] instanceof CellItemInterface)) continue;
                            item = (CellItemInterface)this.components[index];
                            item.setRange(dim, 0, colRanges[j]);
                        }
                        if (!this.showExternalAxes || dim != 1) continue;
                        latticeAxis = this.lattice.getColumnAxis(j, true);
                        this.mergeAndSetExternalRange(colRanges[j], latticeAxis);
                    }
                    continue block14;
                }
                case 1: {
                    int i;
                    range = null;
                    for (i = 0; i < this.components.length; ++i) {
                        UpdateInterface u;
                        if (this.components[i] == null) continue;
                        if (this.components[i] instanceof UpdateInterface && (u = (UpdateInterface)this.components[i]).isRebuildRequired()) {
                            boolean bl = buildSuccess = u.build(null) && buildSuccess;
                        }
                        if (!(this.components[i] instanceof CellItemInterface) || (dri = (item = (CellItemInterface)this.components[i]).getRangeSource(dim, 0)) == null || !buildSuccess) continue;
                        itemRange = dri.getDataRange(dim);
                        item.setRange(dim, 0, itemRange);
                    }
                    break;
                }
            }
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (!(this.components[i] instanceof UpdateInterface) || !(this.components[i] instanceof CellItemInterface)) continue;
            ((UpdateInterface)this.components[i]).buildAndDraw((Object)Boolean.TRUE, null, null);
        }
    }

    private void mergeAndSetExternalRange(DataRange range, Component latticeAxis) {
        if (latticeAxis instanceof AxisComponent) {
            AxisComponent axis = (AxisComponent)latticeAxis;
            if ((axis.hasUserSetMin() || axis.hasUserSetMax()) && range instanceof ContinuousRange) {
                range = this.computeUserRange(axis, (ContinuousRange)range);
            }
            axis.setRange(range);
        }
    }

    private ContinuousRange computeUserRange(AxisComponent axis, ContinuousRange range) {
        if (range == null || axis == null) {
            return null;
        }
        double min = range.getMin();
        double max = range.getMax();
        if (axis.hasUserSetMin()) {
            min = axis.getUserSetMin();
        }
        if (axis.hasUserSetMax()) {
            max = axis.getUserSetMax();
        }
        return new ContinuousRange(min, max);
    }

    private void equalizeColumn(byte dim) {
        int index;
        int i;
        int j;
        CellItemInterface item = null;
        DataRangeInterface dri = null;
        DataRange itemRange = null;
        DataRange[] colRanges = new DataRange[this.columns];
        Object latticeAxis = null;
        boolean buildSuccess = true;
        for (j = 0; j < this.columns; ++j) {
            colRanges[j] = null;
            for (i = 0; i < this.rows; ++i) {
                UpdateInterface u;
                index = i * this.columns + j;
                if (index >= this.components.length || this.components[index] == null) continue;
                if (this.components[index] instanceof UpdateInterface && (u = (UpdateInterface)this.components[index]).isRebuildRequired()) {
                    boolean bl = buildSuccess = u.build(null) && buildSuccess;
                }
                if (!(this.components[index] instanceof CellItemInterface) || (dri = (item = (CellItemInterface)this.components[index]).getRangeSource(dim, 0)) == null || !buildSuccess) continue;
                itemRange = dri.getDataRange(dim);
                colRanges[j] = RangeMerger.mergeRange((DataRange)colRanges[j], (DataRange)itemRange);
            }
        }
        if (buildSuccess) {
            for (j = 0; j < this.columns; ++j) {
                if (colRanges[j] == null) continue;
                for (i = 0; i < this.rows; ++i) {
                    index = i * this.columns + j;
                    if (index >= this.components.length || this.components[index] == null || !(this.components[index] instanceof CellItemInterface)) continue;
                    item = (CellItemInterface)this.components[index];
                    item.setRange(dim, 0, colRanges[j]);
                }
            }
        }
    }

    private void equalizeRow(byte dim) {
        int index;
        int j;
        int i;
        CellItemInterface item = null;
        DataRangeInterface dri = null;
        DataRange itemRange = null;
        DataRange[] rowRanges = new DataRange[this.rows];
        Object latticeAxis = null;
        boolean buildSuccess = true;
        for (i = 0; i < this.rows; ++i) {
            rowRanges[i] = null;
            for (j = 0; j < this.columns; ++j) {
                UpdateInterface u;
                index = i * this.columns + j;
                if (index >= this.components.length || this.components[index] == null) continue;
                if (this.components[index] instanceof UpdateInterface && (u = (UpdateInterface)this.components[index]).isRebuildRequired()) {
                    boolean bl = buildSuccess = u.build(null) && buildSuccess;
                }
                if (!(this.components[index] instanceof CellItemInterface) || (dri = (item = (CellItemInterface)this.components[index]).getRangeSource(dim, 0)) == null || !buildSuccess) continue;
                itemRange = dri.getDataRange(dim);
                rowRanges[i] = RangeMerger.mergeRange((DataRange)rowRanges[i], (DataRange)itemRange);
            }
        }
        if (buildSuccess) {
            for (i = 0; i < this.rows; ++i) {
                if (rowRanges[i] == null) continue;
                for (j = 0; j < this.columns; ++j) {
                    index = i * this.columns + j;
                    if (index >= this.components.length || this.components[index] == null || !(this.components[index] instanceof CellItemInterface)) continue;
                    item = (CellItemInterface)this.components[index];
                    item.setRange(dim, 0, rowRanges[i]);
                }
            }
        }
    }

    public void categoryEqualization() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object source;
        if (!e.isPopupTrigger() && (e.getModifiers() & 4) == 0 && e.getClickCount() > 1 && !this.chartFocussed && (source = e.getSource()) instanceof GraphInterface) {
            this.selectedChart = (GraphInterface)source;
            if (this.selectedChart != null && this.selectedChart != this) {
                this.mouseEventSource = null;
                this.focusOnChart();
            }
        }
        super.mouseClicked(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            Object source = e.getSource();
            if (source instanceof GraphInterface) {
                this.selectedChart = (GraphInterface)source;
            }
            if (this.popup == null) {
                this.popup = this.createPopupMenu();
            }
            if (this.popupEnabled) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
        super.mouseReleased(e);
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem graphOptions = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.Popup.GraphProperties.txt", (String)"Graph Properties..."));
        graphOptions.setActionCommand("graph");
        graphOptions.addActionListener(this);
        popup.add(graphOptions);
        if (this.componentType != 17 && this.componentType != 18) {
            JMenu actionMenu = MenuUtilities.getMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/LatticeComponentActionMenu.xml"), (ActionListener)this);
            popup.add(actionMenu);
            this.viewPortActionModeMI = MenuUtilities.getMenuItem((JMenu)actionMenu, (String)"ACTION_MODE_VIEWPORT");
            switch (this.componentType) {
                case 9: 
                case 10: {
                    this.defaultActionModeMI = MenuUtilities.getMenuItem((JMenu)actionMenu, (String)"ACTION_MODE_SELECT");
                    JMenuItem brushMI = MenuUtilities.getMenuItem((JMenu)actionMenu, (String)"ACTION_MODE_BRUSH");
                    brushMI.setVisible(false);
                    this.defaultActionModeMI.setSelected(true);
                    break;
                }
                default: {
                    this.defaultActionModeMI = MenuUtilities.getMenuItem((JMenu)actionMenu, (String)"ACTION_MODE_BRUSH");
                }
            }
            this.viewPortActionModeMI.setEnabled(this.chartFocussed);
            this.viewPortActionModeMI.setVisible(this.canViewport);
        }
        popup.addSeparator();
        JMenuItem dataOptions = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.Popup.DataOptions.txt", (String)"Data Options..."));
        dataOptions.setActionCommand("data");
        dataOptions.addActionListener(this);
        popup.add(dataOptions);
        popup.addSeparator();
        JMenuItem copyToClipboard = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.Popup.Copy.txt", (String)"Copy"));
        copyToClipboard.setActionCommand("copyToClipboard");
        copyToClipboard.addActionListener(this);
        popup.add(copyToClipboard);
        popup.addSeparator();
        if (this.componentType == 18) {
            this.viewMenu = MenuUtilities.getMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/LatticeComponentViewMenu.xml"), (ActionListener)this);
            this.viewFitToPageMI = MenuUtilities.getMenuItem((JMenu)this.viewMenu, (String)"VIEW_FIT_TO_PAGE");
            popup.add(this.viewMenu);
            this.viewMenu.setEnabled(this.chartFocussed);
            popup.addSeparator();
        }
        JMenuItem focusOnChart = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.Popup.FocusOnChart.txt", (String)"Focus on Chart"));
        focusOnChart.setActionCommand("focusOnChart");
        focusOnChart.addActionListener(this);
        if (this.chartFocussed) {
            focusOnChart.setEnabled(false);
        }
        popup.add(focusOnChart);
        this.focusChartItemIndex = popup.getComponentIndex(focusOnChart);
        JMenuItem resetLattice = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.Popup.ResetFocus.txt", (String)"Reset Focus"));
        resetLattice.setActionCommand("resetLattice");
        resetLattice.addActionListener(this);
        resetLattice.setEnabled(this.chartFocussed);
        popup.add(resetLattice);
        this.resetFocusIndex = popup.getComponentIndex(resetLattice);
        if (SILKGlobal.isTestMode()) {
            ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.menus.silk_menus_NLS");
            JMenuItem saveAsXML = new JMenuItem(ResourceLoader.getResourceString((Object)rb, (String)"Popup.Save_As_XML.txt", (String)"Save As XML..."));
            saveAsXML.setActionCommand("DEBUG__SAVE_AS_XML");
            saveAsXML.addActionListener(this);
            popup.addSeparator();
            popup.add(saveAsXML);
        }
        return popup;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JMenuItem) {
            String command = ((JMenuItem)source).getActionCommand();
            if (command.equalsIgnoreCase("graph")) {
                if (this.graphDialog == null) {
                    this.graphDialog = this.createGraphDialog();
                }
                if (this.graphDialog != null) {
                    this.graphDialog.setVisible(true);
                } else {
                    System.out.println(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.Error.NoGraphDialog.txt", (String)"No graph dialog to show!"));
                }
            } else if (command.equalsIgnoreCase("data")) {
                if (this.dataDialog == null) {
                    this.dataDialog = new DataOptionsDialog((RoleInterface)this, (JComponent)((Object)this), this.parentFrame);
                }
                if (this.dataDialog != null) {
                    this.dataDialog.setVisible(true);
                } else {
                    System.out.println(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.Error.NoDataDialog.txt", (String)"No data dialog to show!"));
                }
            } else if (command.equalsIgnoreCase("toolbar")) {
                if (this.toolbar == null) {
                    this.toolbar = this.createToolbar();
                }
                this.toolbar.setVisible(true);
            } else if (command.equalsIgnoreCase("resetView")) {
                this.resetView();
            } else if (command.equalsIgnoreCase("focusOnChart")) {
                this.mouseEventSource = null;
                this.focusOnChart();
            } else if (command.equalsIgnoreCase("resetLattice")) {
                this.mouseEventSource = null;
                if (this.selectedChart != null) {
                    this.applyWhereClause(this.latticeWhereClause, true);
                    this.selectedChart = null;
                    this.setFocusChartEnabled(true);
                    this.doEqualization();
                }
            } else if (command.equalsIgnoreCase("equalizeAxes")) {
                this.doEqualization();
                this.repaint();
            } else if (command.equalsIgnoreCase("copyToClipboard")) {
                CopyToClipboard.toClipboard((JComponent)((Object)this));
            } else if (command.equalsIgnoreCase("ACTION_MODE_BRUSH")) {
                this.setActionMode(1);
            } else if (command.equalsIgnoreCase("ACTION_MODE_SELECT")) {
                this.setActionMode(6);
            } else if (command.equalsIgnoreCase("ACTION_MODE_VIEWPORT")) {
                this.setActionMode(2);
            } else if (command.equalsIgnoreCase("VIEW_100_PERCENT")) {
                this.setPropertyValue(5031, 100);
                this.applyPropertyChanges();
            } else if (command.equalsIgnoreCase("VIEW_75_PERCENT")) {
                this.setPropertyValue(5031, 75);
                this.applyPropertyChanges();
            } else if (command.equalsIgnoreCase("VIEW_50_PERCENT")) {
                this.setPropertyValue(5031, 50);
                this.applyPropertyChanges();
            } else if (command.equalsIgnoreCase("VIEW_25_PERCENT")) {
                this.setPropertyValue(5031, 25);
                this.applyPropertyChanges();
            } else if (command.equalsIgnoreCase("VIEW_FIT_TO_PAGE")) {
                this.setPropertyValue(5031, -999);
                this.applyPropertyChanges();
            } else if (command.equalsIgnoreCase("DEBUG__SAVE_AS_XML")) {
                SILKParser.saveAsXML((Object)this, null, (boolean)true);
            }
        }
    }

    private void focusOnChart() {
        if (this.selectedChart != null && this.selectedChart != this) {
            Hashtable context = new Hashtable();
            Element xAxesXML = this.getAxisStatgraphXML(0, context);
            Element yAxesXML = this.getAxisStatgraphXML(1, context);
            String wc = this.getWhereClause();
            this.applyWhereClause(this.selectedChart.getWhereClause(), true);
            this.latticeWhereClause = wc;
            if (this.latticeWhereClause != null && this.latticeWhereClause.trim().length() == 0) {
                this.latticeWhereClause = null;
            }
            this.setFocusChartEnabled(false);
            this.initInternalAxesFromXML(0, context, xAxesXML);
            this.initInternalAxesFromXML(1, context, yAxesXML);
            this.setupExternalAxes(false);
            this.setupOtherbarOption(false);
        }
    }

    private void setFocusChartEnabled(boolean enable) {
        if (this.popup != null) {
            this.popup.getComponent(this.focusChartItemIndex).setEnabled(enable);
            this.popup.getComponent(this.resetFocusIndex).setEnabled(!enable);
        }
        boolean bl = this.chartFocussed = !enable;
        if (this.chartSupportsZoom) {
            this.updateZoomOptions(!enable);
            return;
        }
        this.updateViewport();
    }

    private void updateZoomOptions(boolean enable) {
        if (this.viewMenu != null) {
            this.viewMenu.setEnabled(enable);
        }
        if (!enable) {
            Object o = this.getPropertyValue(5031);
            if (!(o instanceof Integer) || (Integer)o != -999) {
                this.setPropertyValue(5031, -999);
                this.applyPropertyChanges();
            }
            if (this.viewFitToPageMI != null) {
                this.viewFitToPageMI.setSelected(true);
            }
        }
    }

    private void updateViewport() {
        boolean singleChart;
        if (!this.canViewport) {
            return;
        }
        boolean bl = singleChart = this.components != null && this.components.length == 1;
        if (singleChart && !this.isViewportScrollEnabled) {
            this.isViewportScrollEnabled = true;
            this.applyViewportProperty(this.isViewportScrollEnabled);
        } else if (!singleChart && this.isViewportScrollEnabled) {
            this.isViewportScrollEnabled = false;
            this.resetView();
            this.applyViewportProperty(this.isViewportScrollEnabled);
            if (this.actionMode == 2) {
                this.setActionMode(DEFAULT_ACTION_MODE);
                this.defaultActionModeMI.setSelected(true);
            }
        }
        if (this.viewPortActionModeMI != null) {
            this.viewPortActionModeMI.setEnabled(singleChart);
        }
    }

    private boolean applyViewportProperty(boolean isVisible) {
        if (this.components == null) {
            return false;
        }
        boolean retVal = true;
        for (int i = 0; i < this.components.length; ++i) {
            if (!(this.components[i] instanceof PropertyInterface)) continue;
            PropertyInterface p = (PropertyInterface)this.components[i];
            p.setPropertyValue(34, (Object)new Boolean(isVisible));
            retVal = p.applyPropertyChanges() && retVal;
        }
        return retVal;
    }

    private void resetView() {
        if (this.components == null) {
            return;
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (!(this.components[i] instanceof GraphInterface) || this.components[i] == null) continue;
            ((GraphInterface)this.components[i]).setActionMode(5);
        }
        this.doEqualization();
    }

    private Dialog createGraphDialog() {
        switch (this.componentType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return this.getGraphDialog();
            }
        }
        return null;
    }

    private Dialog getGraphDialog() {
        JComponent ci;
        Dialog graphDlg = null;
        if (this.tempCI == null && (ci = this.createComponent(this.componentType, null, null)) instanceof ComponentInterface) {
            this.tempCI = (ComponentInterface)ci;
        }
        if (this.tempCI != null) {
            Dialog d;
            graphDlg = d = this.tempCI.getDialog((Object)"Properties", (Object)this);
            if (d != null && d instanceof TabbedPropertiesDialog) {
                TabbedPropertiesDialog tpd = (TabbedPropertiesDialog)d;
                JTabbedPane tabPanel = tpd.getTabbedPane();
                if (tabPanel != null) {
                    tpd.insertTab(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.GraphDialog.Lattice.txt", (String)"Lattice"), (TabPanelInterface)new LatticePanel(this), 1);
                }
            } else if (d instanceof GraphPropertiesDialog) {
                GraphPropertiesDialog gpd = (GraphPropertiesDialog)d;
                gpd.addPropertyListener((PropertyInterface)this);
                GraphPropertiesDialog.PropertiesTreeNode node = gpd.getRootNode((Object)"Chart", true);
                String displayName = node.getDisplayName();
                Component panel = node.getPanel();
                node.setDisplayName(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.GraphDialog.Lattice.txt", (String)"Lattice"));
                node.setPanel((Component)new LatticePanel(this));
                if (displayName != null && panel != null) {
                    GraphPropertiesDialog.PropertiesTreeNode child = node.createChild((Object)displayName);
                    child.setPanel(panel);
                }
                gpd.updateAxesPanels((PropertyInterface)this, (Object)this);
                gpd.updateLegendPanels((PropertyInterface)this, (Object)this);
                GraphPropertiesDialog.PropertiesTreeNode ptn = gpd.getRootNode((Object)"Axis", false);
                if (ptn != null) {
                    ptn.setPanel(null);
                }
            }
        }
        return graphDlg;
    }

    private boolean canViewport() {
        if (this.components == null) {
            return false;
        }
        for (int i = 0; i < this.components.length; ++i) {
            BaseElement[] arr;
            if (!(this.components[i] instanceof BaseElementComponent) || (arr = ((BaseElementComponent)this.components[i]).getCharts()) == null) continue;
            for (int j = 0; j < arr.length; ++j) {
                if (!(arr[j] instanceof PropertyInterface)) continue;
                BaseElement pi = arr[j];
                Object obj = pi.getPropertyValue(19058);
                if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                    return (Boolean)obj;
                }
                obj = pi.getPropertyValue(19059);
                if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                    return (Boolean)obj;
                }
                obj = pi.getPropertyValue(19062);
                if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                    return (Boolean)obj;
                }
                obj = pi.getPropertyValue(19060);
                if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                    return (Boolean)obj;
                }
                obj = pi.getPropertyValue(19063);
                if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                    return (Boolean)obj;
                }
                obj = pi.getPropertyValue(19061);
                if (!(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
                return (Boolean)obj;
            }
        }
        return false;
    }

    private ArrayList getCurrentAxes() {
        switch (this.currentAxis) {
            case 0: {
                return this.externalXAxes;
            }
            case 1: {
                return this.externalYAxes;
            }
        }
        return null;
    }

    private boolean isAxisPropertyPending(int id) {
        ArrayList axes = this.getCurrentAxes();
        if (axes == null || axes.size() == 0) {
            return false;
        }
        Object o = axes.get(0);
        if (o != null && o instanceof PropertyInterface) {
            PropertyInterface p = (PropertyInterface)o;
            return p.isPropertyPending(id);
        }
        return false;
    }

    private boolean isAxisPropertySupported(int id) {
        ArrayList axes = this.getCurrentAxes();
        if (axes == null || axes.size() == 0) {
            return false;
        }
        Object o = axes.get(0);
        if (o != null && o instanceof PropertyInterface) {
            PropertyInterface p = (PropertyInterface)o;
            return p.isPropertySupported(id);
        }
        return false;
    }

    private Object getAxisPropertyValue(int id) {
        ArrayList axes = this.getCurrentAxes();
        if (axes == null || axes.size() == 0) {
            if (id == 237) {
                return new Boolean(false);
            }
            return null;
        }
        Object o = null;
        switch (id) {
            case 249: 
            case 250: {
                Vector<Object> v = new Vector<Object>();
                for (int i = 0; i < axes.size(); ++i) {
                    Object o2;
                    o = axes.get(i);
                    if (!(o instanceof PropertyInterface) || (o2 = ((PropertyInterface)o).getPropertyValue(id)) == null) continue;
                    v.add(o2);
                }
                return new PropertyMulticaster(v);
            }
        }
        o = axes.get(0);
        if (o != null && o instanceof PropertyInterface) {
            PropertyInterface p = o;
            return p.getPropertyValue(id);
        }
        return null;
    }

    private boolean setAxisPropertyValue(int id, Object value) {
        ArrayList axes = this.getCurrentAxes();
        if (axes == null || axes.size() == 0) {
            return false;
        }
        boolean return_flag = true;
        int numAxes = axes.size();
        for (int i = 0; i < numAxes; ++i) {
            Object o = axes.get(i);
            if (o == null || !(o instanceof PropertyInterface)) continue;
            PropertyInterface p = (PropertyInterface)o;
            return_flag = p.setPropertyValue(id, value) && return_flag;
        }
        return return_flag;
    }

    private boolean applyAxisPropertyChanges(int key, Object value) {
        Object o;
        int i;
        int size;
        boolean returnValue = true;
        if (this.externalXAxes != null && this.externalXAxes.size() > 0) {
            size = this.externalXAxes.size();
            block8: for (i = 0; i < size; ++i) {
                o = this.externalXAxes.get(i);
                switch (key) {
                    case 271: {
                        if (!(o instanceof PropertyInterface)) continue block8;
                        PropertyInterface p = (PropertyInterface)o;
                        p.setPropertyValue(271, value);
                        returnValue = p.applyPropertyChanges() && returnValue;
                        continue block8;
                    }
                    case 805: 
                    case 333664: {
                        int numBins;
                        if (!(o instanceof AxisComponent) || !(value instanceof Number) || (numBins = ((Number)value).intValue()) <= 0) continue block8;
                        ((AxisComponent)o).setAutoCalculate(false);
                        ((AxisComponent)o).setNumMajorTickMarks(numBins + 1);
                    }
                }
            }
        }
        if (this.externalYAxes != null && this.externalYAxes.size() > 0) {
            size = this.externalYAxes.size();
            block9: for (i = 0; i < size; ++i) {
                o = this.externalYAxes.get(i);
                switch (key) {
                    case 271: {
                        if (!(o instanceof PropertyInterface)) continue block9;
                        PropertyInterface p = (PropertyInterface)o;
                        p.setPropertyValue(271, value);
                        returnValue = p.applyPropertyChanges() && returnValue;
                        continue block9;
                    }
                    case 806: 
                    case 333665: {
                        int numBins;
                        if (!(o instanceof AxisComponent) || !(value instanceof Number) || (numBins = ((Number)value).intValue()) <= 0) continue block9;
                        ((AxisComponent)o).setAutoCalculate(false);
                        ((AxisComponent)o).setNumMajorTickMarks(numBins + 1);
                    }
                }
            }
        }
        return returnValue;
    }

    private void cancelAxisPropertyChanges() {
        PropertyInterface p;
        Object o;
        int i;
        int size;
        if (this.externalXAxes != null && this.externalXAxes.size() > 0) {
            size = this.externalXAxes.size();
            for (i = 0; i < size; ++i) {
                o = this.externalXAxes.get(i);
                if (o == null || !(o instanceof PropertyInterface)) continue;
                p = (PropertyInterface)o;
                p.cancelPropertyChanges();
            }
        }
        if (this.externalYAxes != null && this.externalYAxes.size() > 0) {
            size = this.externalYAxes.size();
            for (i = 0; i < size; ++i) {
                o = this.externalYAxes.get(i);
                if (o == null || !(o instanceof PropertyInterface)) continue;
                p = (PropertyInterface)o;
                p.cancelPropertyChanges();
            }
        }
    }

    private int getDivisionType() {
        int type = this.getVariable(RoleInterface.ROLE_LATTICE_X) != null && this.getVariable(RoleInterface.ROLE_LATTICE_Y) != null ? 0 : (this.getVariable(RoleInterface.ROLE_LATTICE_X) != null ? 2 : 1);
        return type;
    }

    private PropertyMulticaster getAxisPropertyMulticaster() {
        if (this.components == null) {
            return null;
        }
        Integer ca = new Integer(this.currentAxis);
        if (this.multicasters.get(ca) == null) {
            PropertyMulticaster pm = new PropertyMulticaster();
            for (int i = 0; i < this.components.length; ++i) {
                AxisInterface ai;
                if (!(this.components[i] instanceof GraphInterface) || !((ai = ((GraphInterface)this.components[i]).getAxis((Object)ca)) instanceof PropertyInterface)) continue;
                pm.addListener((PropertyInterface)ai);
            }
            this.multicasters.put(ca, pm);
        }
        return (PropertyMulticaster)this.multicasters.get(ca);
    }

    private PropertyMulticaster getPropertyMulticaster(int id) {
        return new PropertyMulticaster((Object)this.components);
    }

    public boolean isPropertySupported(int id) {
        if (this.components == null) {
            return false;
        }
        if (this.showExternalAxes) {
            switch (id) {
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 213: 
                case 214: 
                case 216: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 237: 
                case 238: 
                case 239: 
                case 240: 
                case 242: 
                case 250: 
                case 9001: 
                case 9002: 
                case 9014: {
                    return true;
                }
            }
        }
        switch (id) {
            case 34: {
                return false;
            }
            case 0: 
            case 40: 
            case 41: 
            case 71: 
            case 11001: 
            case 11004: 
            case 11005: 
            case 11006: 
            case 11009: {
                return true;
            }
            case 11007: {
                return this.areAxesSupported();
            }
            case 11008: {
                return this.areExternalAxesSupported();
            }
        }
        int i = 0;
        while (this.components[i] == null || !(this.components[i] instanceof GraphInterface)) {
            ++i;
        }
        if (i < this.components.length) {
            return ((PropertyInterface)this.components[i]).isPropertySupported(id);
        }
        return false;
    }

    public boolean isPropertyPending(int id) {
        if (this.components == null) {
            return false;
        }
        if (this.showExternalAxes && this.isAxisPropertySupported(id)) {
            return this.isAxisPropertyPending(id);
        }
        switch (id) {
            case 0: 
            case 40: 
            case 41: 
            case 11001: 
            case 11004: 
            case 11005: 
            case 11006: 
            case 11009: {
                if (this.properties.isEmpty() || !this.properties.containsKey(new Integer(id))) break;
                return true;
            }
        }
        int i = 0;
        while (this.components[i] == null || !(this.components[i] instanceof GraphInterface)) {
            ++i;
        }
        if (i < this.components.length) {
            return ((PropertyInterface)this.components[i]).isPropertyPending(id);
        }
        return false;
    }

    public Object getPropertyValue(int id) {
        int i;
        LegendObjectJ2D legend;
        if (this.components == null) {
            return null;
        }
        if (this.showExternalAxes) {
            switch (id) {
                case 238: {
                    return new Integer(this.currentAxis);
                }
                case 237: {
                    switch (this.currentAxis) {
                        case 0: {
                            return this.xAxesVisible;
                        }
                        case 1: {
                            return this.yAxesVisible;
                        }
                    }
                }
                case 258: 
                case 259: {
                    return this.getAxisPropertyValue(id);
                }
            }
            if (this.isAxisPropertySupported(id)) {
                return this.getAxisPropertyValue(id);
            }
        }
        PropertyMulticaster pm = null;
        Integer key = new Integer(id);
        switch (id) {
            default: {
                break;
            }
            case 23: {
                if (this.legendBuilder.getLegendNames() != null) {
                    return this.currentLegend;
                }
                return null;
            }
            case 59: {
                return this.getCurrentLegendObject();
            }
            case 39: {
                return Boolean.FALSE;
            }
            case 2: {
                return new Boolean(this.tipsOn);
            }
            case 24: 
            case 25: {
                return this.legendBuilder.getLegendNames();
            }
            case 34: {
                return null;
            }
            case 0: {
                if (this.properties.isEmpty() || !this.properties.containsKey(new Integer(id))) break;
                Object value = this.properties.get(new Integer(id));
                if (value != null) {
                    return value;
                }
                return new ColorScheme(this.style);
            }
            case 40: {
                if (this.properties.isEmpty() || !this.properties.containsKey(new Integer(id))) break;
                Object value = this.properties.get(new Integer(id));
                if (value != null) {
                    return value;
                }
                if (this.xValueCount > 0) {
                    return new Integer(this.xValueCount);
                }
                return null;
            }
            case 41: {
                if (this.properties.isEmpty() || !this.properties.containsKey(new Integer(id))) break;
                Object value = this.properties.get(new Integer(id));
                if (value != null) {
                    return value;
                }
                if (this.yValueCount > 0) {
                    return new Integer(this.yValueCount);
                }
                return null;
            }
            case 71: {
                return Boolean.FALSE;
            }
            case 11001: {
                if (!this.properties.isEmpty() && this.properties.containsKey(new Integer(id))) {
                    Object value = this.properties.get(new Integer(id));
                    if (value != null) {
                        return value;
                    }
                } else {
                    if (this.numDivisions > 0) {
                        return new Integer(Math.min(this.numDivisions, this.maxDivisions));
                    }
                    return new Integer(this.maxDivisions);
                }
            }
            case 11009: {
                return this.wrapEnabled;
            }
            case 11004: {
                Object value;
                if (!this.properties.isEmpty() && this.properties.containsKey(new Integer(id))) {
                    value = this.properties.get(new Integer(id));
                    if (value != null) {
                        return value;
                    }
                } else {
                    return new Integer(this.xEqualizationType);
                }
            }
            case 11005: {
                Object value;
                if (!this.properties.isEmpty() && this.properties.containsKey(new Integer(id))) {
                    value = this.properties.get(new Integer(id));
                    if (value != null) {
                        return value;
                    }
                } else {
                    return new Integer(this.yEqualizationType);
                }
            }
            case 11006: {
                Object value;
                if (!this.properties.isEmpty() && this.properties.containsKey(new Integer(id))) {
                    value = this.properties.get(new Integer(id));
                    if (value != null) {
                        return value;
                    }
                } else {
                    return this.externalAxes;
                }
            }
            case 11003: {
                return new Integer(this.getDivisionType());
            }
            case 11002: {
                return new Integer(this.maxDivisions);
            }
            case 46: {
                if (this.multicasters.get(key) == null) {
                    pm = this.getPropertyMulticaster(id);
                    this.multicasters.put(key, pm);
                } else {
                    pm = (PropertyMulticaster)this.multicasters.get(key);
                }
                return new Object[]{pm, pm};
            }
            case 601: 
            case 602: 
            case 603: {
                if (!super.isPropertySupported(id)) break;
                return super.getPropertyValue(id);
            }
            case 260: {
                return Boolean.FALSE;
            }
            case 11007: {
                return this.areAxesSupported();
            }
            case 11008: {
                return this.areExternalAxesSupported();
            }
            case 205: 
            case 206: 
            case 215: 
            case 216: 
            case 249: 
            case 250: {
                pm = this.getAxisPropertyMulticaster();
                return pm.getPropertyValue(id);
            }
        }
        if (this.currentLegend != null && (legend = this.legendBuilder.getLegend(this.currentLegend)) != null && legend.isPropertySupported(id)) {
            return legend.getPropertyValue(id);
        }
        for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof GraphInterface); ++i) {
        }
        if (i < this.components.length) {
            Object o = ((PropertyInterface)this.components[i]).getPropertyValue(id);
            if (o instanceof PropertyInterface) {
                if (this.multicasters.get(key) == null) {
                    pm = this.getPropertyMulticaster(id);
                    this.multicasters.put(key, pm);
                } else {
                    pm = (PropertyMulticaster)this.multicasters.get(key);
                }
                return pm.getPropertyValue(id);
            }
            return o;
        }
        return null;
    }

    public boolean setPropertyValue(int id, Object value) {
        LegendObjectJ2D legend;
        if (this.components == null) {
            return false;
        }
        if (this.showExternalAxes) {
            switch (id) {
                case 237: {
                    if (value instanceof Boolean) {
                        switch (this.currentAxis) {
                            case 0: {
                                this.xAxesVisible = (Boolean)value;
                                break;
                            }
                            case 1: {
                                this.yAxesVisible = (Boolean)value;
                            }
                        }
                    }
                    return this.setAxisPropertyValue(id, value);
                }
                case 204: 
                case 244: 
                case 245: 
                case 246: {
                    this.setAxisPropertyValue(id, value);
                    break;
                }
                case 258: 
                case 259: {
                    this.rangeChanged = true;
                    this.setAxisPropertyValue(id, value);
                    break;
                }
                case 805: 
                case 806: 
                case 333664: 
                case 333665: {
                    this.properties.put(new Integer(id), value);
                    break;
                }
                default: {
                    if (!this.isAxisPropertySupported(id)) break;
                    return this.setAxisPropertyValue(id, value);
                }
            }
        }
        block10 : switch (id) {
            case 237: {
                if (!(value instanceof Boolean)) break;
                switch (this.currentAxis) {
                    case 0: {
                        this.xAxesVisible = (Boolean)value;
                        break;
                    }
                    case 1: {
                        this.yAxesVisible = (Boolean)value;
                    }
                }
                break;
            }
            case 238: {
                Object v = value;
                if (value != null && value instanceof PropertyEvent) {
                    v = ((PropertyEvent)value).value;
                }
                if (v != null && v instanceof Number) {
                    int curAxis = ((Number)v).intValue();
                    switch (curAxis) {
                        case 0: 
                        case 1: 
                        case 2: {
                            this.currentAxis = curAxis;
                            break block10;
                        }
                    }
                    return false;
                }
                if (v != null) {
                    String ca = v.toString();
                    if ("X".equalsIgnoreCase(ca)) {
                        this.currentAxis = 0;
                        break;
                    }
                    if ("Y".equalsIgnoreCase(ca)) {
                        this.currentAxis = 1;
                        break;
                    }
                    if ("Z".equalsIgnoreCase(ca)) {
                        this.currentAxis = 2;
                        break;
                    }
                    return false;
                }
                return false;
            }
            case 40: 
            case 41: 
            case 11001: 
            case 11004: 
            case 11005: 
            case 11006: 
            case 11009: {
                this.properties.put(new Integer(id), value);
                return true;
            }
            case 23: {
                if (value instanceof SILKNumber) {
                    this.currentLegend = (SILKNumber)value;
                    return true;
                }
                return false;
            }
            case 0: 
            case 2: 
            case 601: 
            case 602: 
            case 603: {
                if (!super.isPropertySupported(id)) break;
                return super.setPropertyValue(id, value);
            }
            case 604: 
            case 605: 
            case 606: {
                return false;
            }
        }
        if (this.currentLegend != null && (legend = this.legendBuilder.getLegend(this.currentLegend)) != null && legend.isPropertySupported(id)) {
            return legend.setPropertyValue(id, value);
        }
        boolean first = true;
        boolean returnVal = false;
        if (id == 60) {
            this.disableLayout();
            this.ignoreColorMapperEvents = true;
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null || !(this.components[i] instanceof GraphInterface)) continue;
            if (first) {
                returnVal = true;
                first = false;
            }
            returnVal = ((PropertyInterface)this.components[i]).setPropertyValue(id, value) && returnVal;
        }
        switch (id) {
            case 807: 
            case 815: 
            case 10101: {
                this.legendUpdatePending = true;
                break;
            }
        }
        if (id == 60) {
            if (this.showExternalAxes) {
                this.setupExternalAxes(false);
            }
            this.doEqualization();
            this.updateLegends(true);
        }
        this.ignoreColorMapperEvents = false;
        if (id == 60) {
            this.enableLayout();
        }
        return returnVal;
    }

    public int getNumberPendingProperties() {
        return 0;
    }

    private boolean areChangesPending(Object source) {
        SILKNumber[] names;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                int[] list;
                if (this.components[i] == null || !(this.components[i] instanceof PropertyInterface) || (list = ((PropertyInterface)this.components[i]).getPendingChanges(source)) == null || list.length <= 0) continue;
                return true;
            }
        }
        if ((names = this.legendBuilder.getLegendNames()) != null) {
            for (int i = 0; i < names.length; ++i) {
                LegendObjectJ2D legend = this.legendBuilder.getLegend(names[i]);
                int[] list = legend.getPendingChanges(source);
                if (list == null || list.length <= 0) continue;
                return true;
            }
        }
        if (!this.properties.isEmpty()) {
            return true;
        }
        int[] list = super.getPendingChanges(source);
        return list != null && list.length > 0;
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        SILKNumber[] names;
        if (this.components == null) {
            return false;
        }
        boolean propertyPending = this.areChangesPending(source);
        if (!propertyPending) {
            return false;
        }
        this.applyingPropertyChanges = true;
        this.disableLayout();
        boolean first = true;
        boolean returnVal = false;
        boolean rebuild = false;
        if (this.showExternalAxes) {
            returnVal = this.applyAxisPropertyChanges(271, Boolean.TRUE);
            first = false;
        }
        if (!this.properties.isEmpty()) {
            Enumeration keys = this.properties.keys();
            Enumeration values = this.properties.elements();
            while (keys.hasMoreElements()) {
                Object value;
                Integer i = (Integer)keys.nextElement();
                int key = -1;
                if (i != null) {
                    key = i;
                }
                if ((value = values.nextElement()) instanceof PropertyEvent) {
                    value = ((PropertyEvent)value).value;
                }
                switch (key) {
                    case 0: {
                        this.setColorScheme(value);
                        break;
                    }
                    case 40: {
                        if (!(value instanceof Number)) break;
                        this.xValueCount = ((Number)value).intValue();
                        break;
                    }
                    case 41: {
                        if (!(value instanceof Number)) break;
                        this.yValueCount = ((Number)value).intValue();
                        break;
                    }
                    case 11001: {
                        if (!(value instanceof Number)) break;
                        this.userSetNumDivisions = ((Number)value).intValue();
                        rebuild = true;
                        break;
                    }
                    case 11009: {
                        if (!(value instanceof Boolean)) break;
                        this.wrapEnabled = (Boolean)value;
                        rebuild = true;
                        break;
                    }
                    case 11004: {
                        if (!(value instanceof Number)) break;
                        this.setXEqualizationType(((Number)value).intValue());
                        break;
                    }
                    case 11005: {
                        if (!(value instanceof Number)) break;
                        this.setYEqualizationType(((Number)value).intValue());
                        break;
                    }
                    case 11006: {
                        if (!(value instanceof Boolean)) break;
                        boolean externalAxes = (Boolean)value;
                        this.setExternalAxesVisible(externalAxes);
                        break;
                    }
                    case 333664: {
                        this.applyAxisPropertyChanges(333664, value);
                        break;
                    }
                    case 333665: {
                        this.applyAxisPropertyChanges(333665, value);
                        break;
                    }
                    case 805: {
                        this.applyAxisPropertyChanges(805, value);
                        break;
                    }
                    case 806: {
                        this.applyAxisPropertyChanges(806, value);
                    }
                }
            }
            this.properties.clear();
        }
        if (this.legendUpdatePending) {
            this.ignoreColorMapperEvents = true;
        }
        if ((names = this.legendBuilder.getLegendNames()) != null) {
            for (int i = 0; i < names.length; ++i) {
                LegendObjectJ2D legend = this.legendBuilder.getLegend(names[i]);
                legend.applyPropertyChanges(source);
            }
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null || !(this.components[i] instanceof GraphInterface)) continue;
            if (first) {
                returnVal = true;
                first = false;
            }
            returnVal = ((PropertyInterface)this.components[i]).applyPropertyChanges(source) && returnVal;
        }
        if (this.showExternalAxes) {
            if (this.rangeChanged) {
                this.lattice.installColumnRangeListeners();
                this.lattice.installRowRangeListeners();
                this.lattice.installMarginListeners();
                this.rangeChanged = false;
            }
            this.updateExternalAxes();
        }
        this.graphLayout.getTitle().applyPropertyChanges(source);
        this.graphLayout.getFootnote().applyPropertyChanges(source);
        this.applyingPropertyChanges = false;
        this.ignoreColorMapperEvents = false;
        this.updateExternalAxes();
        super.applyPropertyChanges(source);
        if (rebuild) {
            this.rebuildLattice();
        } else {
            this.setValueCounts();
            this.doEqualization();
        }
        this.updateLegends(this.legendUpdatePending);
        if (this.compWidth > 0 && this.compHeight > 0) {
            this.setAxesFontHeights(this.compWidth, this.compHeight);
        }
        this.legendUpdatePending = false;
        this.enableLayout();
        this.revalidate();
        return returnVal;
    }

    public void cancelPropertyChanges() {
        if (this.components == null) {
            return;
        }
        if (this.showExternalAxes) {
            this.cancelAxisPropertyChanges();
        }
        this.properties.clear();
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null || !(this.components[i] instanceof GraphInterface)) continue;
            ((PropertyInterface)this.components[i]).cancelPropertyChanges();
        }
        this.legendUpdatePending = false;
        super.cancelPropertyChanges();
    }

    public void cancelPropertyChanges(Object source) {
        if (this.components == null) {
            return;
        }
        if (this.showExternalAxes) {
            this.cancelAxisPropertyChanges();
        }
        this.properties.clear();
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null || !(this.components[i] instanceof GraphInterface)) continue;
            ((PropertyInterface)this.components[i]).cancelPropertyChanges(source);
        }
        this.legendUpdatePending = false;
        super.cancelPropertyChanges(source);
    }

    public int[] getPendingChanges() {
        return null;
    }

    public int[] getPendingChanges(Object source) {
        return null;
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        return rc;
    }

    private void enableLayout() {
        if (this.layoutDepth == 0) {
            return;
        }
        if (this.layoutDepth > 0) {
            --this.layoutDepth;
        }
        if (this.layoutDepth == 0) {
            this.lattice.enableLayout();
        }
    }

    private void disableLayout() {
        if (this.layoutDepth == 0) {
            this.lattice.disableLayout();
        }
        ++this.layoutDepth;
    }

    private int getRoleIntValue(Object role) {
        if (role instanceof Number) {
            return ((Number)role).intValue();
        }
        if (role instanceof String) {
            String s = role.toString();
            for (int i = 0; i < this.myRoles.length; ++i) {
                if (!StringCompare.equals((String)s, (String)this.myRoles[i].toString()) && !StringCompare.equals((String)s, (String)this.engRoles[i].toString())) continue;
                return ((Number)this.myRoles[i]).intValue();
            }
        }
        return -1;
    }

    private int getSortOrderIntValue(Object sort) {
        if (sort instanceof Number) {
            return ((Number)sort).intValue();
        }
        if (sort instanceof String) {
            String s = sort.toString();
            if (StringCompare.equals((String)s, (String)"Ascending")) {
                return 1;
            }
            if (StringCompare.equals((String)s, (String)"Descending")) {
                return -1;
            }
        }
        return 0;
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public Object getDataSource(Object id) {
        return this.getDataSource();
    }

    public boolean setDataSource(Object source) {
        if (source == null) {
            return false;
        }
        DataFilterReadInterface dfri = FilterFactory.getDataSourceFilter((Object)source);
        if (dfri == null) {
            return false;
        }
        if (dfri == source) {
            this.dataSource = dfri.getSource();
            this.filter = FilterFactory.getDataSourceFilter((Object)this.dataSource);
        } else {
            this.dataSource = source;
            this.filter = dfri;
        }
        return true;
    }

    public boolean setDataSource(Object source, Object id) {
        return this.setDataSource(source);
    }

    public Object getAllVariables(Object role) {
        if (role == null || this.variables == null) {
            return null;
        }
        int iRole = this.getRoleIntValue(role);
        switch (iRole) {
            case 36: {
                return this.variables[0];
            }
            case 37: {
                return this.variables[1];
            }
        }
        if (this.components == null) {
            return null;
        }
        int i = 0;
        for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof RoleInterface); ++i) {
        }
        if (i < this.components.length) {
            return ((RoleInterface)this.components[i]).getAllVariables(role);
        }
        return null;
    }

    public Object getVariable(Object role) {
        int i = 0;
        if (role == null || this.variables == null) {
            return null;
        }
        int iRole = this.getRoleIntValue(role);
        switch (iRole) {
            case 36: {
                return this.variables[0];
            }
            case 37: {
                return this.variables[1];
            }
        }
        if (this.components == null) {
            return null;
        }
        for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof RoleInterface); ++i) {
        }
        if (i < this.components.length) {
            return ((RoleInterface)this.components[i]).getVariable(role);
        }
        return null;
    }

    public Object getRole(Object variableId) {
        Object o;
        int i = 0;
        Vector<Object> v = new Vector<Object>();
        for (i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] == null || !StringCompare.equals((String)this.variables[i], (String)variableId.toString())) continue;
            v.addElement(this.myRoles[i]);
        }
        if (this.components == null) {
            return null;
        }
        for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof RoleInterface); ++i) {
        }
        if (i < this.components.length && (o = ((RoleInterface)this.components[i]).getRole(variableId)) instanceof Object[]) {
            Object[] roles = (Object[])o;
            for (int r = 0; r < roles.length; ++r) {
                v.addElement(roles[r]);
            }
        }
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            return v.elementAt(0);
        }
        return v.toArray();
    }

    public boolean setRole(Object variableId, Object role) {
        if (role == null || variableId == null) {
            return false;
        }
        boolean latticeRole = false;
        int roleIndex = -1;
        int iRole = this.getRoleIntValue(role);
        switch (iRole) {
            case 36: {
                latticeRole = true;
                roleIndex = 0;
                break;
            }
            case 37: {
                latticeRole = true;
                roleIndex = 1;
                break;
            }
        }
        if (latticeRole) {
            return this.setByVariable(variableId, role, roleIndex);
        }
        if (this.isAxisRole(role)) {
            this.disableLayout();
        }
        this.ignoreColorMapperEvents = true;
        boolean return_flag = false;
        boolean first = true;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i] == null || !(this.components[i] instanceof RoleInterface)) continue;
                if (first) {
                    return_flag = true;
                    first = false;
                }
                return_flag = ((RoleInterface)this.components[i]).setRole(variableId, role) && return_flag;
            }
        }
        boolean seriesRole = false;
        boolean categoryRole = false;
        boolean yRole = false;
        boolean zRole = false;
        int roleInt = Integer.MIN_VALUE;
        if (return_flag) {
            if (role instanceof Number) {
                roleInt = ((Number)role).intValue();
            } else {
                Object comp_role = null;
                Object roles = this.getRole(variableId);
                Enumeration e = Extract.elements((Object)roles);
                while (e.hasMoreElements()) {
                    Object r = e.nextElement();
                    if (r == null) continue;
                    comp_role = r;
                    break;
                }
                if (comp_role instanceof Number) {
                    roleInt = ((Number)comp_role).intValue();
                }
            }
        }
        if (roleInt > 0) {
            switch (roleInt) {
                case 6: {
                    this.group = variableId.toString();
                    categoryRole = true;
                    break;
                }
                case 21: {
                    this.subgroup = variableId.toString();
                    categoryRole = true;
                    break;
                }
                case 3: {
                    yRole = true;
                    break;
                }
                case 1: 
                case 24: {
                    categoryRole = true;
                    this.category = variableId.toString();
                    break;
                }
                case 58: {
                    seriesRole = true;
                    break;
                }
                case 51: {
                    zRole = true;
                    break;
                }
                case 17: 
                case 25: {
                    yRole = true;
                    if (this.componentType == 4 || this.componentType == 7 || this.componentType == 20) {
                        if (roleInt == 25) {
                            this.yVariable = variableId.toString();
                            break;
                        }
                        if (roleInt != 17) break;
                        if (this.response == null) {
                            this.response = new String[1];
                        }
                        this.response[0] = variableId.toString();
                        break;
                    }
                    if (this.response == null) {
                        this.response = new String[1];
                    }
                    this.response[0] = variableId.toString();
                    break;
                }
                case 38: {
                    yRole = true;
                    this.statisticType = variableId.toString();
                    break;
                }
                case 35: {
                    yRole = true;
                    if (this.componentType != 4 && this.componentType != 7) break;
                    if (this.response == null) {
                        this.response = new String[1];
                    }
                    this.response[0] = variableId.toString();
                    break;
                }
                case 70: {
                    yRole = true;
                    break;
                }
                case 4: 
                case 5: {
                    yRole = true;
                    break;
                }
                default: {
                    yRole = true;
                }
            }
        }
        if (this.components != null && (categoryRole || yRole || seriesRole || zRole)) {
            if (this.showExternalAxes) {
                this.setupExternalAxes(true);
            }
            this.doEqualization();
            this.setValueCounts();
            this.layoutExternalAxes();
        }
        this.ignoreColorMapperEvents = false;
        if (!this.rebuilding) {
            this.updateLegends(true);
        }
        if (this.isAxisRole(role)) {
            this.enableLayout();
        }
        return return_flag;
    }

    protected boolean isAxisRole(Object role) {
        boolean axisRole = false;
        if (this.xRole != null && this.xRole.equals(role) || this.categoryRole != null && this.categoryRole.equals(role) || this.yRole != null && this.yRole.equals(role) || this.responseRole != null && this.responseRole.equals(role) || this.statTypeRole != null && this.statTypeRole.equals(role) || this.freqRole != null && this.freqRole.equals(role)) {
            axisRole = true;
        }
        return axisRole;
    }

    public Object getRoleValue(Object role, int which) {
        return null;
    }

    public boolean isDiscrete(Object role) {
        int i = 0;
        int iRole = this.getRoleIntValue(role);
        switch (iRole) {
            case 36: 
            case 37: {
                return true;
            }
        }
        if (this.components == null) {
            return false;
        }
        for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof RoleInterface); ++i) {
        }
        if (i < this.components.length) {
            return ((RoleInterface)this.components[i]).isDiscrete(role);
        }
        return false;
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        int roleInt;
        boolean return_flag = false;
        boolean first = true;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i] == null || !(this.components[i] instanceof RoleInterface)) continue;
                if (first) {
                    return_flag = true;
                    first = false;
                }
                return_flag = ((RoleInterface)this.components[i]).setDiscrete(role, discrete) && return_flag;
            }
        }
        boolean roleOfInterest = false;
        if (role instanceof Number && ((roleInt = ((Number)role).intValue()) == 1 || roleInt == 24 || roleInt == 17 || roleInt == 25)) {
            roleOfInterest = true;
        }
        if (roleOfInterest) {
            this.setupExternalAxes(true);
        }
        this.doEqualization();
        return return_flag;
    }

    public Object[] getSupportedRoles(Object type, boolean discrete) {
        int i;
        Object[] roleList = null;
        if (this.components != null && this.componentType != 17 && this.componentType != 18) {
            for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof RoleInterface); ++i) {
            }
            roleList = ((RoleInterface)this.components[i]).getSupportedRoles(this.dataId, discrete);
        }
        if (discrete) {
            int numRoles = roleList != null ? roleList.length + this.myRoles.length : this.myRoles.length;
            Object[] supportedRoles = new Object[numRoles];
            int j = 0;
            for (j = 0; j < this.myRoles.length; ++j) {
                supportedRoles[j] = this.myRoles[j];
            }
            for (i = 0; roleList != null && i < roleList.length; ++i) {
                supportedRoles[i + j] = roleList[i];
            }
            return supportedRoles;
        }
        if (roleList != null) {
            return roleList;
        }
        return new Object[0];
    }

    public int getMaxAllowed(Object role) {
        int i = 0;
        int iRole = this.getRoleIntValue(role);
        switch (iRole) {
            case 36: 
            case 37: {
                return 1;
            }
        }
        if (this.components == null) {
            return 0;
        }
        for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof RoleInterface); ++i) {
        }
        if (i < this.components.length) {
            return ((RoleInterface)this.components[i]).getMaxAllowed(role);
        }
        return 0;
    }

    public boolean addRole(Object variableId, Object role) {
        if (role == null || variableId == null) {
            return false;
        }
        boolean latticeRole = false;
        int roleIndex = -1;
        int iRole = this.getRoleIntValue(role);
        switch (iRole) {
            case 36: {
                latticeRole = true;
                roleIndex = 0;
                break;
            }
            case 37: {
                latticeRole = true;
                roleIndex = 1;
                break;
            }
        }
        if (latticeRole) {
            return this.setByVariable(variableId, role, roleIndex);
        }
        if (this.isAxisRole(role)) {
            this.disableLayout();
        }
        this.ignoreColorMapperEvents = true;
        boolean return_flag = false;
        boolean first = true;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i] == null || !(this.components[i] instanceof RoleInterface)) continue;
                if (first) {
                    return_flag = true;
                    first = false;
                }
                return_flag = ((RoleInterface)this.components[i]).addRole(variableId, role) && return_flag;
            }
        }
        boolean categoryRole = false;
        boolean yRole = false;
        int roleInt = Integer.MIN_VALUE;
        if (return_flag) {
            if (role instanceof Number) {
                roleInt = ((Number)role).intValue();
            } else {
                Object comp_role = null;
                Object roles = this.getRole(variableId);
                Enumeration e = Extract.elements((Object)roles);
                while (e.hasMoreElements()) {
                    Object r = e.nextElement();
                    if (r == null) continue;
                    comp_role = r;
                    break;
                }
                if (comp_role instanceof Number) {
                    roleInt = ((Number)comp_role).intValue();
                }
            }
        }
        if (roleInt > 0) {
            switch (roleInt) {
                case 6: {
                    this.group = variableId.toString();
                    categoryRole = true;
                    break;
                }
                case 21: {
                    categoryRole = true;
                    this.subgroup = variableId.toString();
                    break;
                }
                case 3: {
                    yRole = true;
                    break;
                }
                case 1: 
                case 24: {
                    categoryRole = true;
                    this.category = variableId.toString();
                    break;
                }
                case 17: 
                case 25: {
                    int i;
                    yRole = true;
                    if (this.componentType == 4 || this.componentType == 7 || this.componentType == 20) {
                        if (roleInt == 25) {
                            this.yVariable = variableId.toString();
                            break;
                        }
                        if (roleInt != 17) break;
                        if (this.response == null) {
                            this.response = new String[1];
                        }
                        this.response[0] = variableId.toString();
                        break;
                    }
                    if (this.response == null) {
                        this.response = new String[1];
                        this.response[0] = variableId.toString();
                    }
                    if (this.components == null) break;
                    for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof RoleInterface); ++i) {
                    }
                    if (i >= this.components.length) break;
                    boolean supportsMultipleResponses = ((RoleInterface)this.components[i]).supportsMultipleAssignments((Object)RoleInterface.ROLE_RESPONSE) || ((RoleInterface)this.components[i]).supportsMultipleAssignments((Object)RoleInterface.ROLE_Y);
                    boolean multipleRoleAssigned = false;
                    Object o1 = ((RoleInterface)this.components[i]).getAllVariables((Object)RoleInterface.ROLE_RESPONSE);
                    Object o2 = ((RoleInterface)this.components[i]).getAllVariables((Object)RoleInterface.ROLE_Y);
                    if (o1 instanceof Object[] && ((Object[])o1).length > 1) {
                        multipleRoleAssigned = true;
                    }
                    if (o2 instanceof Object[] && ((Object[])o2).length > 1) {
                        multipleRoleAssigned = true;
                    }
                    if (supportsMultipleResponses && multipleRoleAssigned) {
                        boolean newVar = true;
                        for (i = 0; i < this.response.length; ++i) {
                            if (this.response == null || !StringCompare.equals((String)this.response[i], (String)variableId.toString())) continue;
                            newVar = false;
                            break;
                        }
                        if (!newVar) break;
                        String[] oldResponseVars = this.response;
                        this.response = new String[this.response.length + 1];
                        for (i = 0; i < oldResponseVars.length; ++i) {
                            this.response[i] = oldResponseVars[i];
                        }
                        this.response[this.response.length - 1] = variableId.toString();
                        break;
                    }
                    this.response = new String[1];
                    this.response[0] = variableId.toString();
                    break;
                }
                case 38: {
                    yRole = true;
                    this.statisticType = variableId.toString();
                    break;
                }
                case 35: {
                    yRole = true;
                    if (this.componentType != 4 && this.componentType != 7) break;
                    if (this.response == null) {
                        this.response = new String[1];
                    }
                    this.response[0] = variableId.toString();
                    break;
                }
                case 70: {
                    yRole = true;
                    break;
                }
                case 4: 
                case 5: {
                    yRole = true;
                    break;
                }
                default: {
                    yRole = true;
                }
            }
        }
        if (this.components != null && (categoryRole || yRole)) {
            if (this.externalAxes) {
                this.setupExternalAxes(false);
            }
            this.setValueCounts();
            this.doEqualization();
            this.layoutExternalAxes();
        }
        this.ignoreColorMapperEvents = false;
        if (!this.rebuilding) {
            this.updateLegends(true);
        }
        this.enableLayout();
        return return_flag;
    }

    public boolean removeRole(Object variableId, Object role) {
        boolean latticeRole = false;
        int roleIndex = -1;
        int iRole = this.getRoleIntValue(role);
        switch (iRole) {
            case 36: {
                latticeRole = true;
                roleIndex = 0;
                break;
            }
            case 37: {
                latticeRole = true;
                roleIndex = 1;
                break;
            }
        }
        if (latticeRole) {
            return this.removeByVariable(variableId, role, roleIndex);
        }
        this.ignoreColorMapperEvents = true;
        if (this.isAxisRole(role)) {
            this.disableLayout();
        }
        boolean return_flag = false;
        boolean first = true;
        Object comp_role = this.getRole(variableId);
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i] == null || !(this.components[i] instanceof RoleInterface)) continue;
                if (first) {
                    return_flag = true;
                    first = false;
                }
                return_flag = ((RoleInterface)this.components[i]).removeRole(variableId, role) && return_flag;
            }
        }
        boolean categoryRole = false;
        boolean yRole = false;
        int roleInt = Integer.MIN_VALUE;
        if (return_flag) {
            if (role instanceof Number) {
                roleInt = ((Number)role).intValue();
            } else if (comp_role instanceof Number) {
                roleInt = ((Number)comp_role).intValue();
            }
        }
        if (roleInt > 0) {
            switch (roleInt) {
                case 6: {
                    this.group = null;
                    categoryRole = true;
                    break;
                }
                case 21: {
                    categoryRole = true;
                    this.subgroup = null;
                    break;
                }
                case 3: {
                    yRole = true;
                    break;
                }
                case 1: 
                case 24: {
                    categoryRole = true;
                    this.category = null;
                    break;
                }
                case 17: 
                case 25: {
                    int index;
                    yRole = true;
                    if (this.componentType == 4 || this.componentType == 7 || this.componentType == 20) {
                        if (roleInt == 25) {
                            this.yVariable = null;
                            break;
                        }
                        if (roleInt != 17) break;
                        this.response[0] = null;
                        break;
                    }
                    if (this.response.length == 1) {
                        this.response[0] = null;
                        break;
                    }
                    for (index = 0; index < this.response.length && !StringCompare.equals((String)this.response[index], (String)variableId.toString()); ++index) {
                    }
                    if (index >= this.response.length) break;
                    String[] oldResponseVars = this.response;
                    this.response = new String[this.response.length - 1];
                    int cntr = 0;
                    for (int i = 0; i < oldResponseVars.length && cntr < this.response.length; ++i) {
                        if (i == index) continue;
                        this.response[cntr++] = oldResponseVars[i];
                    }
                    break;
                }
                case 4: 
                case 5: 
                case 35: 
                case 38: 
                case 70: {
                    yRole = true;
                    break;
                }
                default: {
                    yRole = true;
                }
            }
        }
        if (this.components != null && (categoryRole || yRole)) {
            if (this.showExternalAxes) {
                this.setupExternalAxes(false);
            }
            this.setValueCounts();
            this.doEqualization();
        }
        this.ignoreColorMapperEvents = false;
        if (!this.rebuilding) {
            this.updateLegends(true);
        }
        if (this.isAxisRole(role)) {
            this.enableLayout();
        }
        return return_flag;
    }

    public boolean supportsMultipleAssignments(Object role) {
        int i;
        if (role != null) {
            int iRole = this.getRoleIntValue(role);
            switch (iRole) {
                case 36: 
                case 37: {
                    return false;
                }
            }
        }
        if (this.components == null) {
            return false;
        }
        for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof RoleInterface); ++i) {
        }
        if (i < this.components.length) {
            return ((RoleInterface)this.components[i]).supportsMultipleAssignments(role);
        }
        return false;
    }

    public Object getSortOrder(Object variableId) {
        if (variableId == null) {
            return null;
        }
        int iRole = this.getRoleIntValue(variableId);
        switch (iRole) {
            case 36: {
                return new Integer(this.sortOrderX);
            }
            case 37: {
                return new Integer(this.sortOrderY);
            }
        }
        int i = 0;
        for (i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] == null || !StringCompare.equals((String)this.variables[i], (String)variableId.toString())) continue;
            return new SILKNumber(0, this.roles.getRoleNLSName("ROLE_SORT_DATA"), "Data");
        }
        if (this.components == null) {
            return null;
        }
        for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof RoleInterface); ++i) {
        }
        if (i < this.components.length) {
            return ((RoleInterface)this.components[i]).getSortOrder(variableId);
        }
        return null;
    }

    public boolean setSortOrder(Object role, Object order) {
        if (role == null || order == null) {
            return false;
        }
        int iRole = this.getRoleIntValue(role);
        int iOrder = this.getSortOrderIntValue(order);
        switch (iRole) {
            case 36: {
                if (this.sortOrderX == iOrder) {
                    return false;
                }
                this.sortOrderX = iOrder;
                this.rebuildLattice();
                return true;
            }
            case 37: {
                if (this.sortOrderY == iOrder) {
                    return false;
                }
                this.sortOrderY = iOrder;
                this.rebuildLattice();
                return true;
            }
        }
        boolean return_flag = false;
        boolean first = true;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i] == null || !(this.components[i] instanceof RoleInterface)) continue;
                if (first) {
                    return_flag = true;
                    first = false;
                }
                return_flag = ((RoleInterface)this.components[i]).setSortOrder(role, order) && return_flag;
            }
        }
        this.doEqualization();
        return return_flag;
    }

    public void addRoleListener(RoleListenerInterface listener) {
        if (listener == null) {
            return;
        }
        if (this.roleListeners == null) {
            this.roleListeners = new Vector();
        }
        if (!this.roleListeners.contains(listener)) {
            this.roleListeners.addElement(listener);
        }
    }

    public void removeRoleListener(RoleListenerInterface listener) {
        if (listener == null || this.roleListeners == null) {
            return;
        }
        this.roleListeners.remove(listener);
    }

    private void fireRoleChangedEvent(RoleEvent re) {
        if (this.roleListeners == null || this.roleListeners.size() == 0) {
            return;
        }
        for (int i = 0; i < this.roleListeners.size(); ++i) {
            ((RoleListenerInterface)this.roleListeners.elementAt(i)).roleChanged(re);
        }
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public Object[][] getSupportedSortableRoles() {
        int i;
        Object[][] roleList = null;
        if (this.components != null) {
            for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof RoleInterface); ++i) {
            }
            roleList = ((RoleInterface)this.components[i]).getSupportedSortableRoles();
        }
        int numRoles = this.myRoles.length;
        if (roleList != null) {
            numRoles += roleList.length;
        }
        Object[][] supportedSortableRoles = new Object[numRoles][];
        int j = 0;
        for (j = 0; j < this.myRoles.length; ++j) {
            supportedSortableRoles[j] = new Object[]{this.myRoles[j]};
        }
        for (i = 0; roleList != null && i < roleList.length; ++i) {
            supportedSortableRoles[i + j] = roleList[i];
        }
        return supportedSortableRoles;
    }

    public int[] getSupportedSortDirections(Object role) {
        int iRole = this.getRoleIntValue(role);
        if (this.getDivisionType() == 2 && iRole == 37) {
            return null;
        }
        if (this.getDivisionType() == 1 && iRole == 36) {
            return null;
        }
        if (iRole == 36 || iRole == 37) {
            return new int[]{1, -1, 0};
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (!(this.components[i] instanceof RoleInterface)) continue;
            return ((RoleInterface)this.components[i]).getSupportedSortDirections(role);
        }
        return null;
    }

    private boolean setByVariable(Object variableId, Object role, int roleIndex) {
        if (roleIndex < 0) {
            return false;
        }
        if (variableId == null && this.variables[(roleIndex + 1) % 2] == null) {
            return false;
        }
        if (variableId != null && this.variables[(roleIndex + 1) % 2] != null && StringCompare.equals((String)this.variables[(roleIndex + 1) % 2], (String)variableId.toString())) {
            this.variables[(roleIndex + 1) % 2] = null;
        }
        String temp = this.variables[roleIndex];
        this.variables[roleIndex] = (String)variableId;
        if (this.tooManyByVariableValues(this.variables)) {
            this.variables[roleIndex] = temp;
            System.out.println(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.Error.TooManyByVariableValues.txt", (String)"Role Rejected - Too Many Unique By Variable Values"));
            return false;
        }
        if (this.variables[1] == null) {
            this.primaryByVariable = this.col = this.variables[0];
            this.secondaryByVariable = null;
            this.row = null;
            this.type = 1;
        } else if (this.variables[0] == null) {
            this.primaryByVariable = this.row = this.variables[1];
            this.secondaryByVariable = null;
            this.col = null;
            this.type = 2;
        } else {
            this.primaryByVariable = this.row = this.variables[1];
            this.secondaryByVariable = this.col = this.variables[0];
        }
        this.rebuildLattice();
        RoleEvent re = new RoleEvent();
        re.source = this;
        re.dataSource = this.dataSource;
        re.isAdjusting = false;
        re.newValue = variableId;
        re.oldValue = null;
        re.type = 1;
        re.role = this.getRoleIntValue(role);
        this.fireRoleChangedEvent(re);
        return true;
    }

    private boolean removeByVariable(Object variableId, Object role, int roleIndex) {
        if (roleIndex < 0) {
            return false;
        }
        if (this.variables[(roleIndex + 1) % 2] == null) {
            return false;
        }
        this.variables[roleIndex] = null;
        if (this.variables[1] == null) {
            this.primaryByVariable = this.col = this.variables[0];
            this.row = null;
            this.type = 1;
        } else if (this.variables[0] == null) {
            this.primaryByVariable = this.row = this.variables[1];
            this.col = null;
            this.type = 2;
        }
        this.secondaryByVariable = null;
        this.rebuildLattice();
        RoleEvent re = new RoleEvent();
        re.source = this;
        re.dataSource = this.dataSource;
        re.isAdjusting = false;
        re.newValue = null;
        re.oldValue = variableId;
        re.type = 3;
        re.role = this.getRoleIntValue(role);
        this.fireRoleChangedEvent(re);
        return true;
    }

    public void rebuildLattice() {
        this.mouseEventSource = null;
        Hashtable context = new Hashtable();
        Element compXML = this.getComponentStatgraphXML(context);
        Element xAxesXML = this.getAxisStatgraphXML(0, context);
        Element yAxesXML = this.getAxisStatgraphXML(1, context);
        ArrayList<Element> legXML = new ArrayList<Element>();
        SILKNumber[] names = this.legendBuilder.getLegendNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                LegendObjectJ2D legend = this.legendBuilder.getLegend(names[i]);
                Element legendXML = this.getLegendStatgraphXML(legend, context);
                if (legendXML == null) continue;
                legendXML.setAttribute("name", names[i].getEnglishName());
                legXML.add(legendXML);
            }
        }
        this.removeAll();
        this.disposeComponents();
        this.createTrellis();
        this.add((Component)this.lattice);
        this.disableLayout();
        this.computeNumberOfCharts();
        this.secondCall = true;
        this.rebuilding = true;
        this.createByVariableLattice();
        this.initComponentsFromXML(compXML, context);
        this.initAxesFromXML(0, context, xAxesXML);
        this.initAxesFromXML(1, context, yAxesXML);
        this.updateLegends(true);
        this.setComponentLegendsVisible(false);
        this.setValueCounts();
        this.setupOtherbarOption();
        if (this.componentType == 18) {
            this.chartSupportsZoom = true;
        } else {
            this.canViewport = this.canViewport();
        }
        if (this.viewPortActionModeMI != null) {
            this.viewPortActionModeMI.setVisible(this.canViewport);
        }
        this.updateViewport();
        if (this.externalAxes) {
            this.setupExternalAxes(false);
        }
        this.doEqualization();
        if (this.components != null && this.components.length == 1 && this.popup != null) {
            this.popup.getComponent(this.focusChartItemIndex).setEnabled(false);
            this.popup.getComponent(this.resetFocusIndex).setEnabled(false);
        } else {
            this.setFocusChartEnabled(true);
        }
        for (int j = 0; j < legXML.size(); ++j) {
            Element legendXML = (Element)legXML.get(j);
            String name = legendXML.getAttribute("name");
            if (name == null || name.length() <= 0) continue;
            LegendObjectJ2D legend = null;
            SILKNumber[] legNames = this.legendBuilder.getLegendNames();
            if (legNames != null) {
                for (int i = 0; i < legNames.length; ++i) {
                    if (!legNames[i].getEnglishName().equalsIgnoreCase(name)) continue;
                    legend = this.legendBuilder.getLegend(legNames[i]);
                    break;
                }
            }
            LegendParser.parseLegend((Element)legendXML, legend);
        }
        this.rebuilding = false;
        this.graphLayout.doLayout((JComponent)((Object)this));
        Rectangle r = this.graphLayout.getChartArea();
        if (this.lattice != null && r != null) {
            this.lattice.setBounds(r);
        }
        this.enableLayout();
        this.invalidate();
        this.validate();
        this.repaint();
        System.runFinalization();
        System.gc();
    }

    public void disposeComponents() {
        if (this.externalXAxes != null && this.externalXAxes.size() > 0) {
            this.removeExternalAxes(0);
        }
        if (this.externalYAxes != null && this.externalYAxes.size() > 0) {
            this.removeExternalAxes(1);
        }
        if (this.lattice != null) {
            this.lattice.uninstallMarginListeners();
            this.lattice.uninstallRangeListeners();
        }
        if (this.multicasters != null) {
            Enumeration e = this.multicasters.elements();
            while (e != null && e.hasMoreElements()) {
                PropertyMulticaster pm = (PropertyMulticaster)e.nextElement();
                pm.removeAllListeners();
            }
            this.multicasters.clear();
        }
        this.lattice = null;
        this.layout = null;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                DataFilterReadInterface dfri;
                if (this.components[i] instanceof BaseElementComponent) {
                    BaseElement[] arr = ((BaseElementComponent)this.components[i]).getCharts();
                    if (arr != null) {
                        for (int i1 = 0; i1 < arr.length; ++i1) {
                            DataFilterReadInterface dfri2 = arr[i1].getFilter();
                            FilterFactory.detachFilter((DataFilterReadInterface)dfri2);
                            if (dfri2 == null) continue;
                            dfri2.removeSource();
                        }
                    }
                } else if (this.components[i] instanceof ConstChartInterface) {
                    dfri = ((ConstChartInterface)((Object)this.components[i])).getFilter();
                    ((ConstChartInterface)((Object)this.components[i])).dispose();
                    FilterFactory.detachFilter((DataFilterReadInterface)dfri);
                    if (dfri != null) {
                        dfri.removeSource();
                    }
                    dfri = null;
                } else if (this.components[i] != null) {
                    dfri = ((BaseComponentInterface)this.components[i]).getFilter();
                    FilterFactory.detachFilter((DataFilterReadInterface)dfri);
                    if (dfri != null) {
                        dfri.removeSource();
                    }
                }
                if (this.components[i] != null && this.components[i] instanceof GraphInterface) {
                    ((GraphInterface)this.components[i]).setToolBar(null);
                    ((GraphInterface)this.components[i]).dispose();
                }
                this.components[i] = null;
            }
        }
        this.components = null;
        if (this.toolbar != null && this.toolbar instanceof GraphToolbarInterface) {
            ((GraphToolbarInterface)this.toolbar).removeAllListeners();
            ((GraphToolbarInterface)this.toolbar).addListener((GraphInterface)this);
        }
        this.propertyMulticasters.clear();
    }

    public Component createToolbar() {
        SILKToolbar toolBar = new SILKToolbar(this.parentFrame);
        toolBar.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"LatticeComponent.GraphToolbar.txt", (String)"Graph Toolbar"));
        toolBar.setButtonEnabled(3, false);
        toolBar.setButtonEnabled(4, false);
        toolBar.setButtonEnabled(2, false);
        toolBar.setButtonEnabled(5, false);
        toolBar.addListener((GraphInterface)this);
        return toolBar;
    }

    private boolean tooManyByVariableValues(Object[] vars) {
        if (vars != null) {
            int numByVars = 1;
            for (int i = 0; i < vars.length; ++i) {
                if (vars[i] == null) continue;
                numByVars *= i + 2;
            }
            switch (numByVars) {
                case 1: {
                    return false;
                }
                case 2: {
                    return this.getNumberUniqueValues(vars[0]) > BY_VARIABLE_VALUE_LIMIT;
                }
                case 3: {
                    return this.getNumberUniqueValues(vars[1]) > BY_VARIABLE_VALUE_LIMIT;
                }
                case 6: {
                    return this.getNumberUniqueValues(vars[0]) * this.getNumberUniqueValues(vars[1]) > BY_VARIABLE_VALUE_LIMIT;
                }
            }
        }
        return false;
    }

    private int getNumberUniqueValues(Object var) {
        int varIdx;
        if (var == null) {
            return 0;
        }
        if (this.filter == null || (varIdx = this.filter.getVariableIndex(var)) < 0) {
            return 0;
        }
        UniqueValueMapper uvm = new UniqueValueMapper();
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            uvm.addValue(this.filter.getValue(varIdx, (long)i));
        }
        return uvm.getNumberValues();
    }

    public void addDrilldownListener(DrilldownListenerInterface dli) {
    }

    public void removeDrilldownListener(DrilldownListenerInterface dli) {
    }

    public AxisInterface getAxis(Object which) {
        return null;
    }

    public boolean setExternalAxis(Object which, AxisInterface axis) {
        return false;
    }

    public LegendInterface getLegend(Object which) {
        return null;
    }

    public Component getToolBar() {
        if (!this.toolbarSet && this.toolbar == null) {
            this.toolbar = this.createToolbar();
        }
        return this.toolbar;
    }

    public boolean setToolBar(Component toolBarIn) {
        this.toolbarSet = true;
        this.toolbar = toolBarIn;
        if (toolBarIn != null && this.toolbar instanceof GraphToolbarInterface) {
            ((GraphToolbarInterface)this.toolbar).addListener((GraphInterface)this);
        }
        if (this.toolbar == null && this.popup != null) {
            this.popup.remove(this.toolbarMI);
        }
        return true;
    }

    public int getActionMode() {
        return this.actionMode;
    }

    public boolean setActionMode(int mode) {
        switch (mode) {
            case 1: 
            case 6: {
                this.actionMode = mode;
                if (this.components == null) {
                    return true;
                }
                for (int i = 0; i < this.components.length; ++i) {
                    if (this.components[i] == null || !(this.components[i] instanceof GraphInterface)) continue;
                    ((GraphInterface)this.components[i]).setActionMode(this.actionMode);
                }
                return true;
            }
            case 2: {
                this.actionMode = mode;
                this.updateViewport();
                if (this.components == null) {
                    return true;
                }
                for (int i = 0; i < this.components.length; ++i) {
                    if (this.components[i] == null || !(this.components[i] instanceof GraphInterface)) continue;
                    ((GraphInterface)this.components[i]).setActionMode(this.actionMode);
                }
                return true;
            }
        }
        return false;
    }

    public boolean setStyle(Object newStyle) {
        super.setStyle(newStyle);
        return this.applyColorScheme();
    }

    public boolean applyColorScheme() {
        int i;
        if (this.style == null) {
            return false;
        }
        this.backgroundColor = this.style.getFillStyleElement("Backfill").getFillColor();
        this.borderColor = this.backgroundColor.darker();
        this.labelColor = this.style.getTextStyleElement("LabelText").getTextColor();
        Font font = this.style.getTextStyleElement("LabelText").getFont();
        this.lattice.setBackground(this.backgroundColor);
        this.border = new LineBorder(this.borderColor, 1);
        this.cellHeaderColor1 = ColorUtilities.darker((Color)this.backgroundColor, (double)0.1);
        this.cellHeaderColor2 = ColorUtilities.darker((Color)this.backgroundColor, (double)0.3);
        this.cellHeaderColor3 = this.backgroundColor;
        if (this.components == null) {
            return true;
        }
        for (i = 0; i < this.layout.getGridRows(); ++i) {
            for (int j = 0; j < this.layout.getGridColumns(); ++j) {
                Component c = this.lattice.getCellItem(i, j);
                if (c != null && c instanceof JComponent) {
                    if (!(c instanceof JLabel) || this.secondaryByVariable != null) {
                        ((JComponent)c).setBorder(this.border);
                    }
                    if (c instanceof GraphInterface) {
                        ((GraphInterface)c).setStyle((Object)this.style);
                    } else if (c instanceof JLabel) {
                        JLabel label = (JLabel)c;
                        label.setBackground(this.backgroundColor);
                        label.setForeground(this.labelColor);
                    }
                }
                if (!this.internalCellHeaders || this.layout.getCell(i, j).getNumHeaders() <= 0) continue;
                Component comp = this.lattice.getCellHeader(i, j, 0);
                StripLabel stripLabel = null;
                if (comp != null && comp instanceof StripLabel) {
                    stripLabel = (StripLabel)comp;
                    stripLabel.setFont(font.deriveFont(this.computeStripLabelFontSize((JLabel)stripLabel)));
                    stripLabel.setHilite(this.cellHeaderColor1);
                    stripLabel.setBorder(this.border);
                    stripLabel.setForeground(this.labelColor);
                }
                if ((comp = this.secondaryByVariable != null ? this.lattice.getCellHeader(i, j, 1) : null) != null && comp instanceof StripLabel) {
                    stripLabel = (StripLabel)comp;
                    stripLabel.setFont(font.deriveFont(this.computeStripLabelFontSize((JLabel)stripLabel)));
                    stripLabel.setHilite(this.cellHeaderColor1);
                    stripLabel.setBorder(this.border);
                    stripLabel.setForeground(this.labelColor);
                }
                if ((comp = this.showNumObs ? this.lattice.getCellHeader(i, j, 2) : null) == null || !(comp instanceof StripLabel)) continue;
                stripLabel = (StripLabel)comp;
                stripLabel.setFont(font.deriveFont(this.computeStripLabelFontSize((JLabel)stripLabel)));
                stripLabel.setHilite(this.cellHeaderColor1);
                stripLabel.setBorder(this.border);
                stripLabel.setForeground(this.labelColor);
            }
        }
        if (!this.internalCellHeaders) {
            JLabel jl;
            for (i = 0; i < this.layout.getGridRows(); ++i) {
                Component c = this.lattice.getRowHeader(i);
                if (!(c instanceof JLabel)) continue;
                jl = (JLabel)c;
                jl.setFont(font.deriveFont(this.computeStripLabelFontSize(jl)));
                jl.setForeground(this.labelColor);
            }
            for (int j = 0; j < this.layout.getGridColumns(); ++j) {
                Component c = this.lattice.getColumnHeader(j);
                if (!(c instanceof JLabel)) continue;
                jl = (JLabel)c;
                jl.setFont(font.deriveFont(this.computeStripLabelFontSize(jl)));
                c.setForeground(this.labelColor);
            }
        }
        if (this.showExternalAxes) {
            Object o;
            int size;
            if (this.externalXAxes != null && this.externalXAxes.size() > 0) {
                size = this.externalXAxes.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    o = this.externalXAxes.get(i2);
                    if (!(o instanceof AxisComponent)) continue;
                    ((AxisComponent)o).setStyle(this.style);
                }
            }
            if (this.externalYAxes != null && this.externalYAxes.size() > 0) {
                size = this.externalYAxes.size();
                for (int i3 = 0; i3 < size; ++i3) {
                    o = this.externalYAxes.get(i3);
                    if (!(o instanceof AxisComponent)) continue;
                    ((AxisComponent)o).setStyle(this.style);
                }
            }
        }
        if (this.legendBuilder != null) {
            this.legendBuilder.setStyle((Object)this.style);
            this.updateLegends(false);
        }
        return true;
    }

    public DataFilterReadInterface getFilter() {
        return this.filter;
    }

    public boolean setDataListening(boolean listen) {
        return false;
    }

    public boolean isDataListening() {
        return true;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean setEditable(boolean editable) {
        return false;
    }

    public boolean applyWhereClause(String whereClause, boolean clear) {
        boolean rebuildLatticeNecessary;
        if (whereClause == null && this.chartFocussed) {
            this.setFocusChartEnabled(true);
        }
        if (whereClause != null && whereClause.trim().length() == 0) {
            return false;
        }
        String safeWhereClause = null;
        if (this.components == null) {
            if (whereClause != null) {
                safeWhereClause = "(" + whereClause + ")";
            }
            this.filter.applyWhereClause(safeWhereClause, clear);
            String clause = this.filter.getWhereClause();
            this.currentWhereClause = clause != null && clause.trim().length() > 0 ? clause : null;
            this.latticeWhereClause = this.currentWhereClause;
            if (this.latticeWhereClause != null && this.latticeWhereClause.trim().length() == 0) {
                this.latticeWhereClause = null;
            }
            this.setFocusChartEnabled(true);
            this.rebuildLattice();
            return true;
        }
        boolean clauseContainsPrimaryByVar = false;
        boolean clauseContainsSecondaryByVar = false;
        boolean latticeAffected = false;
        safeWhereClause = null;
        if (whereClause != null) {
            boolean bl = clauseContainsPrimaryByVar = whereClause.toLowerCase().indexOf(this.primaryByVariable.toLowerCase()) >= 0;
            clauseContainsSecondaryByVar = this.secondaryByVariable != null ? whereClause.toLowerCase().indexOf(this.secondaryByVariable.toLowerCase()) >= 0 : false;
            safeWhereClause = "(" + whereClause + ")";
            if (!clauseContainsPrimaryByVar && !clauseContainsSecondaryByVar) {
                if (this.aggressiveMonitoring) {
                    String clause = this.filter.getWhereClause();
                    this.filter.removeDataFilterListener((Object)this);
                    this.filter.applyWhereClause(safeWhereClause, clear);
                    latticeAffected = !this.areByVariableValuesConsistent();
                    this.filter.applyWhereClause(clause, true);
                    this.filter.addDataFilterListener((Object)this);
                } else {
                    latticeAffected = false;
                }
            } else {
                latticeAffected = true;
            }
        }
        int numCharts = this.components.length;
        boolean flag = false;
        if (!latticeAffected) {
            this.ignoreColorMapperEvents = true;
            for (int i = 0; i < numCharts; ++i) {
                String clause;
                if (this.components[i] == null || !(this.components[i] instanceof GraphInterface)) continue;
                if (clear) {
                    this.currentWhereClause = safeWhereClause;
                    if (whereClause != null) {
                        clause = safeWhereClause + " & " + this.whereClauses[i];
                        flag = ((GraphInterface)this.components[i]).applyWhereClause(clause, true);
                        continue;
                    }
                    flag = ((GraphInterface)this.components[i]).applyWhereClause(safeWhereClause, true);
                    flag = ((GraphInterface)this.components[i]).applyWhereClause(this.whereClauses[i], false);
                    continue;
                }
                if (whereClause != null) {
                    this.currentWhereClause = this.filter.getWhereClause() != null && this.filter.getWhereClause().trim().length() > 0 ? this.filter.getWhereClause() + " & " + safeWhereClause : safeWhereClause;
                    clause = this.currentWhereClause + " & " + this.whereClauses[i];
                    flag = ((GraphInterface)this.components[i]).applyWhereClause(clause, true);
                    continue;
                }
                this.currentWhereClause = whereClause;
                ((GraphInterface)this.components[i]).applyWhereClause(whereClause, false);
            }
        } else {
            this.currentWhereClause = whereClause;
        }
        this.latticeWhereClause = this.currentWhereClause;
        if (this.latticeWhereClause != null && this.latticeWhereClause.trim().length() == 0) {
            this.latticeWhereClause = null;
        }
        this.setFocusChartEnabled(true);
        boolean bl = rebuildLatticeNecessary = whereClause == null && this.byVarWhereClauseSet || latticeAffected;
        if (rebuildLatticeNecessary) {
            this.filter.removeDataFilterListener((Object)this);
        }
        flag = this.filter.applyWhereClause(whereClause, clear);
        if (rebuildLatticeNecessary) {
            this.filter.addDataFilterListener((Object)this);
        }
        if (rebuildLatticeNecessary) {
            this.byVarWhereClauseSet = whereClause != null;
            this.rebuildLattice();
            return true;
        }
        if (flag && !this.showExternalAxes) {
            this.setValueCounts();
        }
        this.doEqualization();
        this.ignoreColorMapperEvents = false;
        this.updateLegends(true);
        return true;
    }

    public String getWhereClause() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getWhereClause();
    }

    public boolean isBackBufferDrawEnabled() {
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof GraphInterface)) continue;
                return ((GraphInterface)this.components[i]).isBackBufferDrawEnabled();
            }
        }
        return false;
    }

    public boolean isModelAttributeHonored(Object attribute) {
        return false;
    }

    public void setBackBufferDrawEnabled(boolean drawback) {
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof GraphInterface)) continue;
                ((GraphInterface)this.components[i]).setBackBufferDrawEnabled(drawback);
            }
        }
    }

    public boolean setHonorModelAttribute(Object attribute, boolean honorit) {
        return false;
    }

    public void enablePopup(boolean on) {
        this.popupEnabled = on;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = this.createPopupMenu();
        }
        return this.popup;
    }

    public void dispose() {
        this.removeAll();
        if (this.legendBuilder != null) {
            this.legendBuilder.removeAllCharts();
        }
        if (this.tempCI != null) {
            this.tempCI.dispose();
        }
        this.tempCI = null;
        this.disposeComponents();
        this.legendBuilder = null;
        if (this.toolbar != null) {
            this.toolbar.setVisible(false);
            if (this.toolbar instanceof GraphToolbarInterface) {
                ((GraphToolbarInterface)this.toolbar).removeAllListeners();
            }
        }
        this.toolbar = null;
        if (this.graphDialog != null) {
            this.graphDialog.setVisible(false);
            this.graphDialog.dispose();
        }
        this.graphDialog = null;
        if (this.dataDialog != null) {
            this.dataDialog.setVisible(false);
            this.dataDialog.dispose();
        }
        this.dataDialog = null;
        this.components = null;
        this.whereClauses = null;
        this.dataSource = null;
        this.filter = null;
        this.row = null;
        this.col = null;
        this.category = null;
        this.response = null;
        this.group = null;
        this.subgroup = null;
        this.yVariable = null;
        this.primaryByVariableValues = null;
        this.secondaryByVariableValues = null;
        this.primaryByVariable = null;
        this.secondaryByVariable = null;
        this.roles = null;
        this.variables = null;
        this.cellSize = null;
        this.lattice = null;
        this.layout = null;
        this.backgroundColor = null;
        this.labelColor = null;
        this.cellHeaderColor1 = null;
        this.cellHeaderColor2 = null;
        this.cellHeaderColor3 = null;
        this.border = null;
        this.componentInCell = null;
        this.style = null;
        this.popup = null;
        this.selectedChart = null;
        this.parentFrame = null;
        this.rb = null;
        this.dimensions = null;
        this.externalXAxes = null;
        this.externalYAxes = null;
        this.latticeDefaults = null;
        this.globalDefaults = null;
        super.dispose();
    }

    public Dialog getDialog(Object id, Object listener) {
        if (id instanceof String) {
            String ID = (String)id;
            if (StringCompare.equals((String)ID, (String)"Properties")) {
                return this.graphDialog;
            }
            if (StringCompare.equals((String)ID, (String)"Data")) {
                return this.dataDialog;
            }
        }
        return null;
    }

    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        if (dialogIn == null) {
            return false;
        }
        if (id instanceof String) {
            String ID = (String)id;
            if (StringCompare.equals((String)ID, (String)"Properties")) {
                this.graphDialog = dialogIn;
                return true;
            }
            if (StringCompare.equals((String)ID, (String)"Data")) {
                this.dataDialog = dialogIn;
                return true;
            }
        }
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    public int getSelectionBehavior() {
        return -1;
    }

    public Object getSelectionBehaviorValue() {
        return null;
    }

    public boolean setSelectionBehavior(int behavior, Object value) {
        return false;
    }

    public boolean getUsageMode(int mode) {
        return false;
    }

    public void setUsageMode(int mode, boolean on) {
    }

    public void addViewportListener(Object listener) {
    }

    public void removeViewportListener(Object listener) {
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object idIn) {
        this.id = idIn;
    }

    public Object getChartObject(Object id) {
        return this.getChart(id);
    }

    public Object getChart(Object id) {
        int irow;
        int icol;
        int n = 0;
        JComponent[] out = null;
        if (this.components == null || this.components.length <= 0) {
            return null;
        }
        if (id == null) {
            out = new JComponent[this.components.length];
            if (out == null) {
                return null;
            }
            for (int i = 0; i < this.components.length; ++i) {
                out[i] = this.components[i];
            }
            return out;
        }
        int type = Extract.getSourceType((Object)id);
        n = Extract.getNumberItems((Object)id, (int)type);
        if (n <= 0) {
            return null;
        }
        switch (n) {
            case 1: {
                icol = Extract.getInteger((Object)id, (int)0, (int)type);
                irow = 0;
                break;
            }
            default: {
                irow = Extract.getInteger((Object)id, (int)0, (int)type);
                icol = Extract.getInteger((Object)id, (int)1, (int)type);
            }
        }
        int i = irow * this.columns + icol;
        if (i < 0 || i >= this.components.length) {
            return null;
        }
        return this.components[i];
    }

    public boolean isVariableDescriptionUsed() {
        return this.useVariableDescription;
    }

    public void setUseVariableDescription(boolean useVarDescription) {
        boolean flag = this.useVariableDescription;
        this.useVariableDescription = useVarDescription;
        if (flag != this.useVariableDescription) {
            this.rebuildLattice();
        }
    }

    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    public boolean isActionEnabled(String action) {
        return true;
    }

    public void setAxesFontHeights(int width, int height) {
        AxisComponent axis;
        double rowHeight = (float)height / (float)this.rows;
        double scaleFactor = 1.0 + (double)(this.rows - 1) / (double)this.columns;
        double rh = rowHeight * scaleFactor;
        for (int i = 0; i < this.rows; ++i) {
            axis = (AxisComponent)this.lattice.getRowAxis(i, true);
            if (axis == null) continue;
            axis.enableMarginPrefCalc();
            axis.setDefaultFont(rh);
        }
        for (int j = 0; j < this.columns; ++j) {
            axis = (AxisComponent)this.lattice.getColumnAxis(j, true);
            if (axis == null) continue;
            axis.enableMarginPrefCalc();
            axis.setDefaultFont(rh);
        }
    }

    public void setAxesFontHeights(Rectangle r) {
        this.setAxesFontHeights(r.width, r.height);
    }

    public void setExternalAxesVisible(boolean flag) {
        if (!this.areExternalAxesSupported()) {
            return;
        }
        this.externalAxes = flag;
        if (this.externalAxes) {
            this.setXEqualizationType(this.getXEqualizationType());
            this.setYEqualizationType(this.getYEqualizationType());
        }
        this.setupExternalAxes(true);
        this.doEqualization();
        this.setupResponseSort();
        if (this.compWidth > 0 && this.compHeight > 0) {
            this.setAxesFontHeights(this.compWidth, this.compHeight);
        }
    }

    public boolean areExternalAxesVisible() {
        return this.externalAxes;
    }

    public boolean setComponentType(int type) {
        boolean rc = false;
        boolean newCType = this.componentType != type;
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                this.componentType = type;
                rc = true;
                this.dataId = null;
                DEFAULT_ACTION_MODE = 1;
                break;
            }
            case 19: {
                this.componentType = type;
                rc = true;
                this.dataId = "Links";
                DEFAULT_ACTION_MODE = 1;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                try {
                    Class<?> cls = Class.forName("com.sas.graphics.silk.Scatter3DComponent");
                    if (cls != null) {
                        this.componentType = type;
                    }
                    rc = true;
                    DEFAULT_ACTION_MODE = 6;
                }
                catch (ClassNotFoundException e) {
                    this.componentType = 2;
                    rc = false;
                }
                break;
            }
            default: {
                rc = false;
            }
        }
        if (rc && newCType && this.components != null && this.components.length > 0) {
            this.setActionMode(DEFAULT_ACTION_MODE);
            this.rebuildLattice();
        }
        if (newCType) {
            this.isViewportScrollEnabled = false;
            if (this.popup != null) {
                this.defaultActionModeMI.setSelected(true);
            }
        }
        return rc;
    }

    public int getComponentType() {
        return this.componentType;
    }

    private boolean initComponentsFromXML(Element chart, Hashtable context) {
        if (chart == null || this.components == null) {
            return false;
        }
        for (int i = 0; i < this.components.length; ++i) {
            Object o;
            if (!(this.components[i] instanceof GraphInterface)) continue;
            Object oldId = null;
            BaseElement be = null;
            if (this.components[i] instanceof BaseElementComponent && (o = ((BaseElementComponent)this.components[i]).getChart(null)) instanceof BaseElement) {
                be = (BaseElement)o;
                oldId = be.getId();
                be.setId((Object)LATTICE_CHART_ID);
            }
            SILKParser.initComponentFromXML((Object)this.components[i], (Element)chart, (Hashtable)context);
            if (be == null) continue;
            be.setId(oldId);
        }
        if (!this.rebuilding) {
            this.setComponentLegendsVisible(false);
        }
        return true;
    }

    private Element getComponentStatgraphXML(Hashtable context) {
        Object o;
        if (this.components == null) {
            return null;
        }
        int i = -1;
        while (++i < this.components.length && !(this.components[i] instanceof GraphInterface)) {
        }
        if (i >= this.components.length) {
            return null;
        }
        ElementParserInterface parser = GraphParserFactory.loadParser((Object)this.components[i]);
        if (context == null) {
            context = new Hashtable<String, Boolean>();
        }
        Object val = context.get("SCRIPT_ROLES");
        context.put("SCRIPT_ROLES", Boolean.TRUE);
        Object oldId = null;
        BaseElement be = null;
        if (this.components[i] instanceof BaseElementComponent && (o = ((BaseElementComponent)this.components[i]).getChart(null)) instanceof BaseElement) {
            be = (BaseElement)o;
            oldId = be.getId();
            be.setId((Object)LATTICE_CHART_ID);
        }
        Element chart = parser.putToXML(context, (Object)this.components[i]);
        if (be != null) {
            be.setId(oldId);
        }
        if ("LayoutOverlay".equalsIgnoreCase(chart.getTagName())) {
            NodeList children = chart.getChildNodes();
            int numChildren = children.getLength();
            for (int j = 0; j < numChildren; ++j) {
                Node child = children.item(j);
                if (!(child instanceof Element)) continue;
                Element ce = (Element)child;
                ce.removeAttribute("data");
                ce.removeAttribute("where");
            }
        } else if ("ConstChart".equalsIgnoreCase(chart.getTagName())) {
            chart.removeAttribute("nodeData");
            chart.removeAttribute("nwhere");
            chart.removeAttribute("linkData");
            chart.removeAttribute("lwhere");
        }
        chart.removeAttribute("where");
        if (val != null) {
            context.put("SCRIPT_ROLES", (Boolean)val);
        }
        return chart;
    }

    public void initChildrenFromXML(Element element, Hashtable context) {
        Element legendXML;
        if (element == null || this.components == null) {
            return;
        }
        int i = -1;
        while (++i < this.components.length && !(this.components[i] instanceof GraphInterface)) {
        }
        if (i >= this.components.length) {
            return;
        }
        String compTagName = GraphParserFactory.getElementTagName((Object)this.components[i]);
        Element compXML = ParserUtils.getChildWithTagName((String)compTagName, (Element)element);
        this.initComponentsFromXML(compXML, context);
        this.updateLegends(true);
        int j = 0;
        while ((legendXML = ParserUtils.getChildWithTagName((String)"Legend", (Element)element, (int)(j + 1))) != null) {
            String name = legendXML.getAttribute("name");
            if (name != null && name.length() > 0) {
                LegendObjectJ2D legend = null;
                SILKNumber[] legNames = this.legendBuilder.getLegendNames();
                if (legNames != null) {
                    for (int k = 0; k < legNames.length; ++k) {
                        if (!legNames[k].getEnglishName().equalsIgnoreCase(name)) continue;
                        legend = this.legendBuilder.getLegend(legNames[k]);
                        break;
                    }
                }
                LegendParser.parseLegend((Element)legendXML, legend);
            }
            ++j;
        }
        this.setValueCounts();
        Element xAxisXML = ParserUtils.getChildWithTagName((String)"XAxis", (Element)element);
        Element yAxisXML = ParserUtils.getChildWithTagName((String)"YAxis", (Element)element);
        if (this.showExternalAxes) {
            String visible;
            if (xAxisXML != null && (visible = xAxisXML.getAttribute("visible")) != null && visible.length() > 0) {
                this.xAxesVisible = new Boolean(ParserUtils.getBooleanValue((String)visible));
            }
            if (yAxisXML != null && (visible = yAxisXML.getAttribute("visible")) != null && visible.length() > 0) {
                this.yAxesVisible = new Boolean(ParserUtils.getBooleanValue((String)visible));
            }
        } else if (this.components[i] instanceof PropertyInterface) {
            PropertyInterface p = (PropertyInterface)this.components[i];
            p.setPropertyValue(238, (Object)new Integer(0));
            Object o = p.getPropertyValue(237);
            if (o instanceof Boolean) {
                this.xAxesVisible = (Boolean)o;
            }
            p.setPropertyValue(238, (Object)new Integer(1));
            o = p.getPropertyValue(237);
            if (o instanceof Boolean) {
                this.yAxesVisible = (Boolean)o;
            }
        }
        this.setupExternalAxes(false);
        this.initAxesFromXML(0, context, xAxisXML);
        this.initAxesFromXML(1, context, yAxisXML);
        this.updateExternalAxes();
        this.doEqualization();
    }

    public Element putChildXML(Hashtable context, Element element) {
        SILKNumber[] names;
        if (element == null) {
            return null;
        }
        Element compXML = this.getComponentStatgraphXML(context);
        if (compXML == null) {
            return element;
        }
        element.appendChild(compXML);
        if (this.showExternalAxes) {
            Element xAxisXML = this.getAxisStatgraphXML(0, context);
            Element yAxisXML = this.getAxisStatgraphXML(1, context);
            if (xAxisXML != null) {
                element.appendChild(xAxisXML);
            }
            if (yAxisXML != null) {
                element.appendChild(yAxisXML);
            }
        }
        if ((names = this.legendBuilder.getLegendNames()) != null) {
            for (int i = 0; i < names.length; ++i) {
                LegendObjectJ2D legend = this.legendBuilder.getLegend(names[i]);
                Element legendXML = this.getLegendStatgraphXML(legend, context);
                if (legendXML == null) continue;
                legendXML.setAttribute("name", names[i].getEnglishName());
                element.appendChild(legendXML);
            }
        }
        return element;
    }

    private Element getLegendStatgraphXML(LegendObjectJ2D legend, Hashtable context) {
        if (legend != null) {
            LegendParser lp = new LegendParser();
            return lp.putToXML(context, (Object)legend);
        }
        return null;
    }

    private Object getFormattedValue(Object var, Object value) {
        if (this.filter != null) {
            Object o = this.filter.getFormat(var, SASFormat.class);
            if (o == null && this.filter.isNumericVariable(var)) {
                o = this.globalDefaults.defaultNumericFormat;
            }
            if (o instanceof SASFormat) {
                SASFormat format = (SASFormat)o;
                return this.filter.getFormattedValue(var, value, (Object)format);
            }
        }
        if (value != null) {
            return value.toString();
        }
        return value;
    }

    public boolean isEqualizedValueCount() {
        return this.equalizeValueCount;
    }

    public void setEqualizedValueCount(boolean equalizeValueCounts) {
        boolean checkCounts = equalizeValueCounts != this.equalizeValueCount;
        this.equalizeValueCount = equalizeValueCounts;
        if (checkCounts) {
            this.setValueCounts();
        }
    }

    public String getToolTipText(MouseEvent me) {
        if (this.mouseEventSource != this && this.mouseEventSource instanceof LayerInterface) {
            if (this.mouseEventSource instanceof Component) {
                this.tipLocation = new Point(this.lattice.getX() + ((Component)this.mouseEventSource).getX() + me.getX(), this.lattice.getY() + ((Component)this.mouseEventSource).getY() + me.getY());
            }
            return ((LayerInterface)this.mouseEventSource).getTipText(me.getX(), me.getY());
        }
        return null;
    }

    private void removeLegends() {
        SILKNumber[] names;
        LegendInterface[] li = this.graphLayout.getLegends();
        if (li != null) {
            for (int i = 0; i < li.length; ++i) {
                this.graphLayout.removeLegend(li[i]);
            }
        }
        if ((names = this.legendBuilder.getLegendNames()) != null) {
            for (int i = 0; i < names.length; ++i) {
                LegendObjectJ2D legend = this.legendBuilder.getLegend(names[i]);
                this.graphLayout.removeLegend((LegendInterface)legend);
                this.removeMouseListener((MouseListener)legend);
                this.removeMouseMotionListener((MouseMotionListener)legend);
            }
        }
    }

    protected LegendInterface getCurrentLegendObject() {
        if (this.legendBuilder == null || this.currentLegend == null) {
            return null;
        }
        return this.legendBuilder.getLegend(this.currentLegend);
    }

    protected boolean legendUpdateRequired() {
        if (this.legendBuilder == null) {
            return false;
        }
        SILKNumber[] names = this.legendBuilder.getLegendNames();
        if (names == null) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            if (!this.legendBuilder.getLegend(names[i]).isUpdateRequired()) continue;
            return true;
        }
        return false;
    }

    private void updateLegends(boolean rebuildLegends) {
        if (this.lattice == null) {
            return;
        }
        if (rebuildLegends || this.legendUpdateRequired()) {
            int i;
            if (!this.rebuilding) {
                this.disableLayout();
            }
            Hashtable context = new Hashtable();
            Vector<Element> legendXML = new Vector<Element>();
            SILKNumber[] names = this.legendBuilder.getLegendNames();
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    legendXML.addElement(this.getLegendStatgraphXML(this.legendBuilder.getLegend(names[i]), context));
                }
            }
            this.removeLegends();
            this.legendBuilder.buildLegends();
            names = this.legendBuilder.getLegendNames();
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    int j;
                    LegendObjectJ2D legend = this.legendBuilder.getLegend(names[i]);
                    this.graphLayout.addLegend((LegendInterface)legend);
                    Object o = null;
                    if (i < legendXML.size()) {
                        o = legendXML.elementAt(i);
                    }
                    if (o instanceof Element) {
                        LegendParser.parseLegend((Element)o, (LegendInterface)legend);
                    }
                    if (this.getParent() != null) {
                        this.addMouseListener((MouseListener)legend);
                        this.addMouseMotionListener((MouseMotionListener)legend);
                    }
                    for (j = 0; this.components != null && j < this.components.length && !(this.components[j] instanceof PropertyInterface); ++j) {
                    }
                    if (this.components == null || j >= this.components.length) continue;
                    PropertyInterface pi = (PropertyInterface)this.components[j];
                    Object variable = pi.getPropertyValue(434);
                    Object oldCurrentLegend = pi.getPropertyValue(23);
                    pi.setPropertyValue(23, (Object)names[i]);
                    if (variable != null) {
                        legend.setData(FilterFactory.getDataSourceFilter((Object)this.dataSource), variable.toString());
                    } else {
                        legend.setData(null, null);
                    }
                    pi.setPropertyValue(23, oldCurrentLegend);
                }
                if (names.length > 0) {
                    this.currentLegend = names[0];
                }
            } else {
                this.currentLegend = null;
            }
        } else {
            this.legendBuilder.updateLegends();
        }
        if (!this.rebuilding) {
            this.setComponentLegendsVisible(false);
            this.graphLayout.doLayout((JComponent)((Object)this));
            if (this.lattice != null) {
                this.lattice.setBounds(this.graphLayout.getChartArea());
            }
            this.enableLayout();
            this.invalidate();
            this.validate();
            this.repaint();
        }
        this.synchColorRamp();
        if (this.graphDialog instanceof GraphPropertiesDialog) {
            ((GraphPropertiesDialog)this.graphDialog).updateLegendPanels((PropertyInterface)this, (Object)this);
        }
    }

    private void synchColorRamp() {
        PropertyInterface pi = null;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof PropertyInterface)) continue;
                pi = (PropertyInterface)this.components[i];
                break;
            }
        }
        if (pi == null) {
            return;
        }
        Object colorRampName = pi.getPropertyValue(53);
        if (colorRampName != null) {
            ColorMapper cm = ColorMapper.getInstance((String)colorRampName.toString());
            if (this.colorMapper == cm) {
                return;
            }
            if (this.colorMapper != null) {
                this.colorMapper.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            this.colorMapper = cm;
            if (this.colorMapper != null) {
                this.colorMapper.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }
        }
    }

    private void setComponentLegendsVisible(boolean visible) {
        if (this.applyingPropertyChanges) {
            return;
        }
        this.ignoreColorMapperEvents = true;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof PropertyInterface)) continue;
                PropertyInterface p = (PropertyInterface)this.components[i];
                SILKNumber[] legNames = this.legendBuilder.getLegendNames();
                if (legNames == null) continue;
                for (int j = 0; j < legNames.length; ++j) {
                    p.setPropertyValue(23, (Object)legNames[j]);
                    p.setPropertyValue(420, (Object)new Boolean(false));
                    p.applyPropertyChanges();
                }
            }
        }
        this.ignoreColorMapperEvents = false;
    }

    public boolean areCellHeadersInternal() {
        return this.internalCellHeaders;
    }

    public void setInternalCellHeaders(boolean internalCellHeaders) {
        if (this.internalCellHeaders == internalCellHeaders) {
            return;
        }
        if (!(internalCellHeaders || this.col != null && this.row != null)) {
            return;
        }
        if (!(internalCellHeaders || this.col != null && this.row != null)) {
            return;
        }
        this.internalCellHeaders = internalCellHeaders;
        if (this.lattice != null && this.components != null) {
            this.disableLayout();
            if (this.internalCellHeaders) {
                this.removeExternalHeaders();
                this.addInternalHeaders();
            } else {
                this.removeInternalHeaders();
                this.addExternalHeaders();
            }
            this.enableLayout();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (this.ignoreColorMapperEvents) {
            return;
        }
        if ("RangeMerged".equalsIgnoreCase(evt.getPropertyName())) {
            this.updateLegends(true);
        }
    }

    public boolean isCellHeaderPrefixShown() {
        return this.showCellHeaderPrefix;
    }

    public void setShowCellHeaderPrefix(boolean showCellHeaderPrefix) {
        block7: {
            boolean stateChanged = this.showCellHeaderPrefix != showCellHeaderPrefix;
            this.showCellHeaderPrefix = showCellHeaderPrefix;
            if (!stateChanged || !this.internalCellHeaders || this.layout == null) break block7;
            if (this.col != null && this.row != null) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; ++c) {
                        int numHdrs = this.layout.getCell(r, c).getNumHeaders();
                        if (numHdrs < 2) continue;
                        Object val1 = this.replaceWithMissingNotation(this.getFormattedValue(this.primaryByVariable, this.primaryByVariableValues[r]));
                        StripLabel l = (StripLabel)this.lattice.getCellHeader(r, c, 0);
                        l.setText(this.getByVarText(this.primaryByVariable, val1, this.msg1));
                        Object val2 = this.replaceWithMissingNotation(this.getFormattedValue(this.secondaryByVariable, this.secondaryByVariableValues[c]));
                        StripLabel l2 = (StripLabel)this.lattice.getCellHeader(r, c, 1);
                        l2.setText(this.getByVarText(this.secondaryByVariable, val2, this.msg2));
                    }
                }
            } else {
                for (int i = 0; i < this.primaryByVariableValues.length; ++i) {
                    int r = -1;
                    int c = -1;
                    if (this.type == 2) {
                        r = i % this.rows;
                        c = i / this.rows;
                    } else {
                        r = i / this.columns;
                        c = i % this.columns;
                    }
                    Object val1 = this.replaceWithMissingNotation(this.getFormattedValue(this.primaryByVariable, this.primaryByVariableValues[i]));
                    StripLabel l = (StripLabel)this.lattice.getCellHeader(r, c, 0);
                    l.setText(this.getByVarText(this.primaryByVariable, val1, this.msg1));
                }
            }
        }
    }

    private void initAxesFromXML(int axisType, Hashtable context, Element axisXML) {
        if (axisXML == null) {
            return;
        }
        ArrayList axes = null;
        switch (axisType) {
            case 0: {
                axes = this.externalXAxes;
                break;
            }
            case 1: {
                axes = this.externalYAxes;
                break;
            }
            default: {
                axes = null;
            }
        }
        if (axes == null) {
            return;
        }
        AxisParser ap = new AxisParser();
        for (int i = 0; i < axes.size(); ++i) {
            Object o = axes.get(i);
            if (!(o instanceof AxisComponent)) continue;
            ap.getFromXML(context, axisXML, (Object)((AxisComponent)o).getInternalAxis());
        }
    }

    private Element getAxisStatgraphXML(int axisType, Hashtable context) {
        Element rc;
        ArrayList axes = null;
        String axisName = null;
        switch (axisType) {
            case 0: {
                axes = this.externalXAxes;
                axisName = "XAxis";
                break;
            }
            case 1: {
                axisName = "YAxis";
                axes = this.externalYAxes;
                break;
            }
            default: {
                axes = null;
            }
        }
        if (axes == null || axes.size() <= 0) {
            return null;
        }
        Object o = axes.get(0);
        if (!(o instanceof AxisComponent)) {
            return null;
        }
        AxisParser ap = new AxisParser();
        if (context == null) {
            context = new Hashtable();
        }
        if ((rc = ap.putToXML(context, (Object)((AxisComponent)o).getInternalAxis(), axisName)) == null) {
            return rc;
        }
        NodeList nodeList = rc.getElementsByTagName("Label");
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                nodeList.item(i).setTextContent("");
            }
        }
        rc.setAttribute("parseAxisRange", Boolean.FALSE.toString());
        return rc;
    }

    private void initInternalAxesFromXML(int axisType, Hashtable context, Element axisXML) {
        if (axisXML == null) {
            return;
        }
        if (this.components == null) {
            return;
        }
        AxisParser ap = new AxisParser();
        for (int i = 0; i < this.components.length; ++i) {
            if (!(this.components[i] instanceof GraphInterface)) continue;
            AxisInterface o = ((GraphInterface)this.components[i]).getAxis((Object)axisType);
            ap.getFromXML(context, axisXML, (Object)o);
        }
    }

    private Element getInternalAxisStatgraphXML(int axisType, Hashtable context) {
        AxisInterface axis = null;
        String axisName = null;
        if (this.components == null) {
            return null;
        }
        switch (axisType) {
            case 0: {
                axisName = "XAxis";
                break;
            }
            case 1: {
                axisName = "YAxis";
                break;
            }
            default: {
                return null;
            }
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null || !(this.components[i] instanceof GraphInterface)) continue;
            axis = ((GraphInterface)this.components[i]).getAxis((Object)axisType);
            break;
        }
        if (axis == null) {
            return null;
        }
        AxisParser ap = new AxisParser();
        if (context == null) {
            context = new Hashtable();
        }
        return ap.putToXML(context, axis, axisName);
    }

    private void setupResponseSort() {
        if (this.components == null) {
            return;
        }
        Boolean disableSort = this.canDisableResponseSort();
        for (int i = 0; i < this.components.length; ++i) {
            if (!(this.components[i] instanceof PropertyInterface)) continue;
            PropertyInterface p = (PropertyInterface)this.components[i];
            p.setPropertyValue(19081, (Object)disableSort);
            p.applyPropertyChanges();
        }
        this.dataDialog = null;
    }

    private boolean canDisableResponseSort() {
        boolean validEqualization;
        if (this.componentType == 8) {
            return Boolean.TRUE;
        }
        boolean bl = validEqualization = this.getXEqualizationType() == 1;
        if (this.componentType == 3) {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof HorizontalBarComponent)) continue;
                validEqualization = this.getYEqualizationType() == 1;
                break;
            }
        }
        if (!this.areAxesSupported()) {
            return Boolean.FALSE;
        }
        if (!this.areExternalAxesVisible() && validEqualization) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean areAxesSupported() {
        switch (this.componentType) {
            case 5: 
            case 8: 
            case 17: 
            case 18: 
            case 19: {
                return false;
            }
        }
        return true;
    }

    private boolean areExternalAxesSupported() {
        switch (this.componentType) {
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: {
                return false;
            }
        }
        return true;
    }

    private void setupOtherbarOption() {
        this.setupOtherbarOption(this.xEqualizationType != 1);
    }

    private void setupOtherbarOption(boolean disableOther) {
        if (this.components == null || this.componentType != 3) {
            return;
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (!(this.components[i] instanceof PropertyInterface)) continue;
            PropertyInterface p = (PropertyInterface)this.components[i];
            p.setPropertyValue(835, (Object)disableOther);
            p.setPropertyValue(830, (Object)(!disableOther ? 1 : 0));
            p.applyPropertyChanges();
        }
    }

    public void setWrapEnabled(boolean wrapEnabled) {
        this.wrapEnabled = wrapEnabled;
    }

    public boolean isWrapEnabled() {
        return this.wrapEnabled;
    }
}

