/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.data.TreeModel;
import com.sas.graphics.silk.dtree.NodeRenderer;
import com.sas.graphics.silk.dtree.NodeTooltip;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.event.TreeModelEvent;
import com.sas.graphics.silk.event.TreeModelListenerInterface;
import com.sas.graphics.silk.icicle.IcicleNode;
import com.sas.graphics.silk.icicle.IcicleNodeTree;
import com.sas.graphics.silk.icicle.IcicleRenderer;
import com.sas.graphics.silk.info.SILKChartInfo;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.ImageListInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.interfaces.TreeModelInterface;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.print.Printable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Icicle
extends SILKComponent
implements TreeModelListenerInterface,
PropertyInterface,
Printable,
SourceInterface,
ActionListener,
TextListenerInterface {
    private static final long serialVersionUID = 1180641942824226646L;
    public IcicleRenderer icicleRenderer;
    IcicleNode root;
    int maxLevel;
    int height;
    int minNodeSize;
    int maxNodeSize;
    TreeModelInterface treeData;
    private boolean addNotifyCalled = false;
    private BufferedImage backBuffer = null;
    double[] colorValueRange = new double[2];
    MouseEventHandler meHandler;
    IcicleNodeTree icicleNodeTree;
    public JPopupMenu menu = null;
    private Object toolTipText = null;
    private GraphPanel graphPanel = null;
    private TitlePanel titlePanel = null;
    private PropertyList pending = new PropertyList();

    public Icicle() {
        this.setColorScheme(SILKGlobal.getInstance().getPropertyValue(0));
        this.tooltip = new NodeTooltip();
    }

    public Icicle(TreeModel treeData) {
        this((TreeModelInterface)treeData);
    }

    public Icicle(TreeModelInterface treeData) {
        this();
        this.init(treeData);
    }

    public void addNotify() {
        super.addNotify();
        if (this.addNotifyCalled) {
            return;
        }
        this.addNotifyCalled = true;
        this.createPropertyDialog(this);
        this.build(new Boolean(true));
        if (this.menu == null) {
            this.setupMenu();
        }
        this.repaint();
    }

    public boolean createPropertyDialog(Object listener) {
        boolean rc = super.createPropertyDialog(listener);
        if (this.propertiesDialog != null) {
            Icicle pi = listener instanceof PropertyInterface ? (PropertyInterface)listener : this;
            Object jc = listener instanceof JComponent ? (JComponent)listener : this;
            this.propertiesDialog.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"Icicle.Icicle_Properties.txt", (String)"Icicle Properties"));
            this.graphPanel = new GraphPanel((PropertyInterface)pi, (PropertyInterface)this.tooltip);
            this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"Icicle.Graph.txt", (String)"Graph"), (Component)this.graphPanel);
            GraphPropertiesDialog.PropertiesTreeNode node = this.propertiesDialog.getRootNode((Object)"Chart", true);
            if (this.getId() == null) {
                this.setId(this.generateDefaultChartId(this));
            }
            node.setDisplayName(this.getId().toString());
            this.titlePanel = new TitlePanel((PropertyInterface)pi, (JComponent)jc);
            this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"Icicle.Title_Footnote.txt", (String)"Title/Footnote"), (Component)this.titlePanel);
        }
        return rc;
    }

    public void dispose() {
        super.dispose();
        if (this.graphPanel != null) {
            this.graphPanel.removePropertyListener((PropertyInterface)this);
        }
        this.graphPanel = null;
        if (this.titlePanel != null) {
            this.titlePanel.removePropertyListener((PropertyInterface)this);
        }
        this.titlePanel = null;
        this.removeMouseListener(this.meHandler);
        if (this.treeData != null) {
            this.treeData.removeTreeModelListener(this);
        }
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource(Object id) {
        if (this.treeData == null) {
            return null;
        }
        return this.treeData.getDataSource(id);
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public boolean setDataSource(Object data) {
        return this.setDataSource(data, null);
    }

    public boolean setDataSource(Object data, Object id) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof TreeModelInterface)) {
            data = new TreeModel(data);
        }
        this.init((TreeModelInterface)data);
        return true;
    }

    public void setUseHTMLTooltips(boolean use) {
        if (this.tooltip != null) {
            this.tooltip.setUseHTMLRenderer(true);
        }
    }

    public void setTooltipRenderer(NodeRenderer renderer) {
        if (this.tooltip != null && this.tooltip instanceof NodeTooltip) {
            ((NodeTooltip)this.tooltip).setRenderer(renderer);
        }
    }

    private void init(TreeModelInterface treeData) {
        this.root = null;
        this.treeData = treeData;
        this.treeData.addTreeModelListener(this);
        this.maxLevel = 0;
        if (this.meHandler != null) {
            this.removeMouseListener(this.meHandler);
        }
        this.meHandler = new MouseEventHandler();
        this.addMouseListener(this.meHandler);
        this.setLayout(new BorderLayout());
        this.initRenderer();
    }

    private void initRenderer() {
        this.icicleNodeTree = new IcicleNodeTree(this.treeData);
        this.root = (IcicleNode)this.icicleNodeTree.getRoot();
        if (this.root != null) {
            this.icicleNodeTree.buildIcicleNodeTree(this.root.getId());
        }
        this.icicleRenderer = new IcicleRenderer(this.treeData);
        this.icicleRenderer.setRoot(this.root);
        this.icicleRenderer.setMaxLevel(this.icicleNodeTree.getMaxLevel());
        this.icicleRenderer.setNodeSizeRange(this.icicleNodeTree.getMinNodeSize(), this.icicleNodeTree.getMaxNodeSize());
        this.icicleRenderer.setNodeColorRange(this.icicleNodeTree.getMinNodeColor(), this.icicleNodeTree.getMaxNodeColor());
        this.icicleRenderer.setGraph((GraphInterface)this);
    }

    public String getToolTipText(MouseEvent me) {
        if (this.icicleRenderer != null) {
            this.toolTipText = this.icicleRenderer.getTipText(me);
            if (this.toolTipText != null) {
                return this.toolTipText.toString();
            }
        }
        return null;
    }

    public boolean isFocusable() {
        return true;
    }

    public void mouseEntered(MouseEvent me) {
        super.mouseEntered(me);
        this.requestFocus();
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        this.getToolTipText(e);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.isUsingBackBuffer()) {
            if (this.backBuffer == null) {
                this.buildBackBuffer();
            }
            g.drawImage(this.backBuffer, 0, 0, null);
        } else {
            this.drawChart(g2);
        }
        if (this.icicleRenderer != null) {
            this.icicleRenderer.drawHighlight(g);
        }
    }

    public Color getNodeSolidColor() {
        return this.icicleRenderer.getNodeSolidColor();
    }

    public void setNodeSolidColor(Color colorIn) {
        this.icicleRenderer.setNodeSolidColor(colorIn);
    }

    public void setBorderColor(Color color) {
        this.icicleRenderer.setBorderColor(color);
    }

    public Color getBorderColor() {
        return this.icicleRenderer.getBorderColor();
    }

    @Override
    public void treeDataChanged(TreeModelEvent te) {
        if (this.icicleRenderer != null) {
            this.icicleRenderer.dispose();
        }
        if (this.icicleNodeTree != null) {
            this.icicleNodeTree.dispose();
        }
        this.initRenderer();
        this.buildAndDraw(new Boolean(true), null, null);
    }

    @Override
    public void interactionChange(TreeModelEvent te) {
        this.buildAndDraw(null, null, null);
    }

    @Override
    public void graphDataChanged(TreeModelEvent te) {
    }

    public boolean isPropertySupported(int id) {
        return false;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public Object getPropertyValue(int id) {
        if (this.pending != null && this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                rc = this.background.getPropertyValue(id);
                break;
            }
            case 0: {
                rc = this.getColorScheme();
                break;
            }
            case 30: {
                rc = this.imageList;
                break;
            }
            case 28: {
                rc = new Boolean(this.imageList != null);
                break;
            }
            case 2: {
                rc = new Boolean(this.tipsOn);
                break;
            }
            case 601: {
                rc = this.graphLayout.getTitle().getTitle(0);
                break;
            }
            case 602: {
                rc = this.graphLayout.getTitle().getTitle(1);
                break;
            }
            case 603: {
                rc = this.graphLayout.getFootnote().getFootnote(0);
            }
        }
        return rc;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.background != null && this.background.isPropertySupported(id)) {
            this.background.setPropertyValue(id, value);
        }
        if (this.pending == null) {
            this.pending = new PropertyList();
        }
        this.pending.store(id, value);
        return true;
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public boolean applyPropertyChanges(Object source) {
        if (this.background != null) {
            this.background.applyPropertyChanges(source);
        }
        Vector changes = this.pending.getChangesBySource(source);
        block6: for (int i = 0; i < changes.size(); ++i) {
            PropertyEvent event = (PropertyEvent)changes.elementAt(i);
            int key = event.id;
            Object value = event.value;
            switch (key) {
                case 0: {
                    this.setColorScheme(value);
                    continue block6;
                }
                case 29: {
                    this.setStyle(value);
                    continue block6;
                }
                case 30: {
                    if (!(value instanceof ImageListInterface)) continue block6;
                    this.setImageList((ImageListInterface)value);
                    continue block6;
                }
                case 2: {
                    if (!(value instanceof Boolean)) continue block6;
                    this.tipsOn = (Boolean)value;
                }
            }
        }
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        this.buildAndDraw(new Boolean(true), null, null);
        this.pending.removeChangesBySource(source);
        return true;
    }

    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return this.treeData.getSupportedRoles(id, discrete);
    }

    public boolean isDiscrete(Object variableId) {
        return this.treeData.isDiscrete(variableId);
    }

    public boolean setDiscrete(Object variableId, boolean discrete) {
        return this.treeData.setDiscrete(variableId, discrete);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.setupMenu();
        }
        return this.menu;
    }

    private void setupMenu() {
        this.menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"Icicle.Graph_Properties.txt", (String)"Graph Properties"));
        item.addActionListener(this);
        this.menu.add(item);
        this.menu.addSeparator();
        item = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"Icicle.Copy.txt", (String)"Copy"));
        item.addActionListener(this);
        this.menu.add(item);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String s = ae.getActionCommand();
        if (s.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"Icicle.Graph_Properties.txt", (String)"Graph Properties"))) {
            this.createPropertyDialog(this);
            this.propertiesDialog.setVisible(true);
        } else if (s.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"Icicle.Copy.txt", (String)"Copy"))) {
            CopyToClipboard.toClipboard((JComponent)((Object)this));
        }
    }

    public void mousePressed(MouseEvent me) {
        int flags = me.getModifiers();
        if (this.menu != null && (flags & 4) != 0) {
            int x = me.getX();
            int y = me.getY();
            this.menu.show((Component)((Object)this), x, y);
        }
    }

    private void buildBackBuffer() {
        if (this.compWidth <= 0 || this.compHeight <= 0 || !this.isUsingBackBuffer()) {
            return;
        }
        if (this.backBuffer == null) {
            this.backBuffer = SILKUtilities.createCompatibleImage((int)this.compWidth, (int)this.compHeight, (int)3);
        }
        Graphics2D g = (Graphics2D)this.backBuffer.getGraphics();
        this.drawChart(g);
    }

    private void drawChart(Graphics2D g) {
        Rectangle rectangle = new Rectangle(0, 0, this.compWidth, this.compHeight);
        this.background.drawBackground(g, (Component)((Object)this), rectangle);
        if (this.icicleRenderer != null) {
            this.icicleRenderer.draw(g, false);
        }
        this.graphLayout.draw((Graphics)g);
    }

    public boolean build(Object obj) {
        this.background.rebuildBackground();
        if (this.root == null) {
            return false;
        }
        if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            this.icicleNodeTree = new IcicleNodeTree(this.treeData);
            this.root = (IcicleNode)this.icicleNodeTree.getRoot();
            this.icicleNodeTree.buildIcicleNodeTree(this.root.getId());
            this.icicleRenderer.setRoot(this.root);
            this.icicleRenderer.setMaxLevel(this.icicleNodeTree.getMaxLevel());
        }
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        Rectangle r = this.graphLayout.getChartArea();
        if (this.icicleRenderer != null) {
            this.icicleRenderer.setScreenArea(r.x, r.y, r.width, r.height);
        }
        if (this.isUsingBackBuffer()) {
            this.buildBackBuffer();
        }
        return true;
    }

    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        this.build(buildData);
        this.repaint();
        return true;
    }

    public void doResize(int w, int h) {
        super.doResize(w, h);
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        this.buildAndDraw(null, null, null);
    }

    public void textUpdated(DvrTextEvent evt) {
        super.textUpdated(evt);
        this.buildAndDraw(null, null, null);
    }

    public void mouseExited(MouseEvent me) {
        super.mouseExited(me);
        this.toolTipText = null;
    }

    public TreeModelInterface getTreeModel() {
        return this.treeData;
    }

    public DataFilterReadInterface getFilter() {
        if (this.treeData == null) {
            return null;
        }
        return this.treeData.getFilter();
    }

    public boolean setRole(Object variableId, Object role) {
        if (this.treeData == null) {
            return false;
        }
        return this.treeData.setRole(variableId, role);
    }

    public Object getRole(Object variableId) {
        if (this.treeData == null) {
            return null;
        }
        return this.treeData.getRole(variableId);
    }

    public Object getAllVariables(Object role) {
        if (this.treeData == null) {
            return null;
        }
        return this.treeData.getAllVariables(role);
    }

    public boolean addRole(Object varID, Object role) {
        if (this.treeData == null) {
            return false;
        }
        return this.treeData.addRole(varID, role);
    }

    public boolean removeRole(Object variableId, Object role) {
        if (this.treeData == null) {
            return false;
        }
        return this.treeData.removeRole(variableId, role);
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        if (this.treeData == null) {
            return false;
        }
        return this.treeData.getFilter().applyWhereClause(clause, clearPrevious);
    }

    public String getWhereClause() {
        if (this.treeData == null) {
            return null;
        }
        return this.treeData.getFilter().getWhereClause();
    }

    private String generateDefaultChartId(Object chart) {
        String id = "Chart";
        SILKChartInfo info = SILKChartInfo.getInstance((Object)chart);
        if (info != null) {
            id = info.getDisplayName();
        }
        return id;
    }

    private class MouseEventHandler
    implements MouseListener {
        IcicleNode currentNode = null;
        IcicleNode selectedNode = null;

        private MouseEventHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.currentNode = Icicle.this.icicleRenderer.retrieveFocusedNode(Icicle.this.root, e.getX(), e.getY());
            if (this.currentNode == null) {
                return;
            }
            if (e.isAltDown()) {
                boolean isSet = false;
                if (!e.isControlDown()) {
                    Vector collapsedNodes = new Vector();
                    Icicle.this.icicleRenderer.getCollapsedNode(collapsedNodes, Icicle.this.root);
                    for (int i = 0; i < collapsedNodes.size(); ++i) {
                        if (!isSet && this.currentNode == (IcicleNode)collapsedNodes.elementAt(i)) {
                            isSet = true;
                        }
                        IcicleNode iNode = (IcicleNode)collapsedNodes.elementAt(i);
                        Icicle.this.treeData.setCollapsed(((IcicleNode)collapsedNodes.elementAt(i)).getId(), Icicle.this.treeData.isCollapsed(iNode.getId()));
                    }
                }
                if (!isSet) {
                    Icicle.this.treeData.setCollapsed(this.currentNode.getId(), !Icicle.this.treeData.isCollapsed(this.currentNode.getId()));
                }
            } else {
                boolean isSet = false;
                if (!e.isControlDown()) {
                    Vector selectedNodes = new Vector();
                    Icicle.this.icicleRenderer.getSelectedNode(selectedNodes, Icicle.this.root);
                    for (int i = 0; i < selectedNodes.size(); ++i) {
                        if (!isSet && this.currentNode == (IcicleNode)selectedNodes.elementAt(i)) {
                            isSet = true;
                        }
                        IcicleNode inode = (IcicleNode)selectedNodes.elementAt(i);
                        Icicle.this.treeData.setSelected(((IcicleNode)selectedNodes.elementAt(i)).getId(), Icicle.this.treeData.isSelected(inode.getId()) ? 0 : 1);
                    }
                }
                if (!isSet) {
                    Icicle.this.treeData.setSelected(this.currentNode.getId(), Icicle.this.treeData.isSelected(this.currentNode.getId()) ? 0 : 1);
                }
            }
            Icicle.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

