/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.data.Filter2TableModel;
import com.sas.graphics.silk.data.TableSelectionModelAdapter;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DrilldownEvent;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.graphtable.GTablePanel;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.table.GTableModel;
import com.sas.graphics.silk.util.table.TableConstants;
import com.sas.graphics.silk.util.table.TableSorter;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.PropertyEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class GTableComponent
extends GTablePanel
implements DataFilterListenerInterface,
ComponentInterface,
SourceInterface,
PropertyInterface,
ListSelectionListener,
TableColumnModelListener,
TableModelListener,
PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = -2563233637485922924L;
    private DataFilterReadInterface filter = null;
    protected Filter2TableModel f2tModel = null;
    private TableSelectionModelAdapter tableSelectionAdapter = null;
    private TableSelectionModelAdapter headerSelectionAdapter = null;
    private boolean listenToEvents = true;
    private boolean scroll = false;
    Style graphStyle = null;
    ColorSchemeInterface colorScheme = null;
    ColorSchemeInterface newColorScheme = null;
    private Object dataSource = null;
    public static final int RENDERMODE_GRAPHICS = TableConstants.RENDERMODE_GRAPHICS;
    public static final int RENDERMODE_FUNNEL = TableConstants.RENDERMODE_FUNNEL;
    public static final int RENDERMODE_TEXT = TableConstants.RENDERMODE_TEXT;
    public static final int RENDERMODE_IMAGE = TableConstants.RENDERMODE_IMAGE;
    protected Object id = null;
    protected Vector drilldownListeners = new Vector();
    private boolean scrollToSelected = false;
    protected boolean editable = false;
    private JMenu tableMenu = null;

    public GTableComponent() {
        this.setDoubleBuffered(false);
        this.setColorScheme(SILKGlobal.getInstance().getPropertyValue(0));
        this.tableSelectionAdapter = new TableSelectionModelAdapter();
        SILKGlobal.register((PropertyInterface)this);
    }

    public GTableComponent(Object source) {
        this(source, false, false, 0, 0);
    }

    public GTableComponent(Object source, boolean showFilter, boolean rowHeader) {
        this(source, showFilter, rowHeader, 0, 0);
    }

    public GTableComponent(Object source, boolean showFilter, boolean rowHeader, int w, int ht) {
        this();
        GTableModel gtableModel = null;
        if (source instanceof GTableModel) {
            gtableModel = (GTableModel)source;
        } else {
            this.f2tModel = new Filter2TableModel(FilterFactory.getDataSourceFilter((Object)source));
            this.f2tModel.setTableEditable(this.editable);
            gtableModel = new GTableModel((TableModel)this.f2tModel, false, false);
        }
        this.init(gtableModel, showFilter, rowHeader, w, ht);
        this.drilldownListeners = new Vector();
        this.tableSelectionAdapter.setModel(this.table.getSelectionModel());
        this.tableSelectionAdapter.setSorter(this.table.getGTableModel());
        if (this.header != null) {
            this.headerSelectionAdapter = new TableSelectionModelAdapter();
            this.headerSelectionAdapter.setModel(this.header.getSelectionModel());
            this.headerSelectionAdapter.setSorter(this.header.getGTableModel());
        }
        this.filter = FilterFactory.getDataSourceFilter((Object)source);
        if (this.filter != null) {
            this.tableSelectionAdapter.setFilter(this.filter);
            if (this.headerSelectionAdapter != null) {
                this.headerSelectionAdapter.setFilter(this.filter);
            }
            this.filter.addDataFilterListener((Object)this);
            int numCols = this.table.getColumnCount();
            this.setColumnNames(numCols);
            this.setColumnFormats(numCols);
            for (int i = 0; i < numCols; ++i) {
                this.table.setRenderMode(i, TableConstants.RENDERMODE_TEXT);
            }
        }
        this.tableSelectionAdapter.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public boolean setTableHeader(JTableHeader header) {
        if (header == null) {
            return false;
        }
        this.table.setTableHeader(header);
        return true;
    }

    public boolean setDisplayMode(Object variable, int displayMode) {
        if (this.table == null) {
            return false;
        }
        TableSorter ts = this.table.getGTableModel();
        int i = ts.getColumnIndexInVisibleModel(this.gtModel.getColumnIndex(variable.toString()));
        this.table.setRenderMode(i, displayMode);
        this.table.repaint();
        return true;
    }

    public int getDisplayMode(Object col) {
        if (this.table == null) {
            return TableConstants.RENDERMODE_TEXT;
        }
        TableSorter ts = this.table.getGTableModel();
        if (ts == null) {
            return TableConstants.RENDERMODE_TEXT;
        }
        int i = ts.getColumnIndexInVisibleModel(this.gtModel.getColumnIndex(col.toString()));
        return this.table.getRenderMode(i);
    }

    public boolean sortColumn(Object col, boolean ascending) {
        if (this.table == null || col == null) {
            return false;
        }
        TableSorter ts = this.table.getGTableModel();
        if (ts == null) {
            return false;
        }
        if (TableSorter.OBS_HEADER_KEY.equals(col) && ts.isObsNumberColumnVisible()) {
            this.sortColumn(0, ascending);
            return true;
        }
        int i = ts.getColumnIndexInVisibleModel(this.gtModel.getColumnIndex(col.toString()));
        this.sortColumn(i, ascending);
        return true;
    }

    public int getSortState(Object col) {
        if (this.table == null || col == null) {
            return 0;
        }
        TableSorter ts = this.table.getGTableModel();
        if (ts == null) {
            return 0;
        }
        if (ts.isObsNumberColumnVisible() && TableSorter.OBS_HEADER_KEY.equals(col)) {
            return this.table.getSortState(0);
        }
        int i = this.gtModel.getColumnIndex(col.toString());
        if (ts.isObsNumberColumnVisible()) {
            ++i;
        }
        return this.table.getSortState(i);
    }

    public boolean linkColumn(Object dataCol, Object linkCol) {
        int data = this.gtModel.getColumnIndex(dataCol.toString());
        int link = this.gtModel.getColumnIndex(linkCol.toString());
        if (data < 0 || link < 0) {
            return false;
        }
        this.gtModel.linkColumn(data, link);
        this.table.getGTableModel().setHiddenColumn(this.table.getGTableModel().getColumnIndexInVisibleModel(link));
        this.repaint();
        return true;
    }

    public Object getLinkColumn(Object dataCol) {
        if (this.gtModel != null) {
            return this.gtModel.getLinkColumn(dataCol);
        }
        return null;
    }

    public boolean setColumnLink(Object dataCol, String link) {
        int col = this.gtModel.getColumnIndex(dataCol.toString());
        this.gtModel.setColumnLink(link, col);
        return true;
    }

    public boolean setImageColumn(Object col) {
        this.gtModel.setImageColumn(this.gtModel.getColumnIndex(col.toString()));
        this.repaint();
        return true;
    }

    public boolean setDataSource(Object source) {
        if (source == null) {
            return false;
        }
        this.dataSource = source;
        this.filter = FilterFactory.getDataSourceFilter((Object)source);
        if (this.filter == null) {
            return false;
        }
        this.f2tModel = new Filter2TableModel(this.filter);
        this.f2tModel.setTableEditable(this.editable);
        this.buildPanel(new GTableModel((TableModel)this.f2tModel, false, false), false, false, 0, 0);
        this.tableSelectionAdapter.setModel(this.table.getSelectionModel());
        this.tableSelectionAdapter.setSorter(this.table.getGTableModel());
        if (this.header != null) {
            if (this.headerSelectionAdapter != null) {
                this.headerSelectionAdapter = new TableSelectionModelAdapter();
            }
            this.headerSelectionAdapter.setModel(this.header.getSelectionModel());
            this.headerSelectionAdapter.setSorter(this.header.getGTableModel());
        } else if (this.headerSelectionAdapter != null) {
            this.headerSelectionAdapter.removeListeners();
            this.headerSelectionAdapter = null;
        }
        int numCols = this.table.getColumnCount();
        this.setColumnNames(numCols);
        this.setColumnFormats(numCols);
        for (int i = 0; i < numCols; ++i) {
            this.table.setRenderMode(i, TableConstants.RENDERMODE_TEXT);
        }
        this.tableSelectionAdapter.setFilter(this.filter);
        if (this.headerSelectionAdapter != null) {
            this.headerSelectionAdapter.setFilter(this.filter);
        }
        this.filter.addDataFilterListener((Object)this);
        this.tableSelectionAdapter.addPropertyChangeListener((PropertyChangeListener)this);
        this.revalidate();
        return true;
    }

    public boolean setDataSource(Object source, Object type) {
        return this.setDataSource(source);
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public Object getDataSource(Object type) {
        return this.getDataSource();
    }

    public Object[] getDataIds() {
        return null;
    }

    private void setColumnNames(int numCols) {
        String[] columnNames = new String[numCols];
        for (int i = 0; i < numCols; ++i) {
            columnNames[i] = (String)this.filter.getVariableId(i);
        }
        this.gtModel.setColumnNames(columnNames);
    }

    private void setColumnFormats(int numCols) {
        String[] columnFormats = new String[numCols];
        for (int i = 0; i < numCols; ++i) {
            Object o;
            Object varId = this.filter.getVariableId(i);
            if (varId != null && (o = this.filter.getFormat(varId, String.class)) instanceof String) {
                columnFormats[i] = (String)o;
                if (columnFormats[i].trim().length() == 0) {
                    columnFormats[i] = null;
                }
            }
            if (columnFormats[i] != null) continue;
            columnFormats[i] = this.gtModel.isNumericVariable(i) ? "best8." : "NONE";
        }
        this.table.setColumnFormats(columnFormats);
        this.gtModel.setColumnFormats(columnFormats);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
    }

    private void scrollTableToSelectedRow() {
        if (this.table == null) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        Rectangle visibleRect = this.table.getVisibleRect();
        Rectangle selectedCellRect = this.table.getCellRect(selectedRow, 0, true);
        if (visibleRect.contains(visibleRect.x, selectedCellRect.y)) {
            return;
        }
        Rectangle newVisibleRect = new Rectangle(visibleRect.x, selectedCellRect.y, visibleRect.width, visibleRect.height);
        this.table.scrollRectToVisible(newVisibleRect);
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        int r;
        switch (evt.type) {
            case 1: {
                this.dataSourceChanged(evt);
                break;
            }
            case 3: {
                this.valueChanged(evt);
                break;
            }
            case 4: {
                this.variableAdded(evt);
                break;
            }
            case 5: {
                this.variableRemoved(evt);
                break;
            }
            case 6: {
                this.formatChanged(evt);
            }
        }
        if (!evt.isAdjusting && this.scroll && (r = this.table.getSelectedRow()) >= 0) {
            this.table.scrollRectToVisible(this.table.getCellRect(r, 0, true));
        }
    }

    public void dataSourceChanged(DvrDataFilterEvent evt) {
    }

    public void valueChanged(DvrDataFilterEvent evt) {
        this.revalidate();
    }

    public void variableAdded(DvrDataFilterEvent evt) {
    }

    public void variableRemoved(DvrDataFilterEvent evt) {
    }

    public void formatChanged(DvrDataFilterEvent evt) {
    }

    public void addRowSelectionInterval(int index1, int index2) {
        this.table.addRowSelectionInterval(index1, index2);
        if (this.header != null) {
            this.header.addRowSelectionInterval(index1, index2);
        }
    }

    public void removeRowSelectionInterval(int index1, int index2) {
        this.table.removeRowSelectionInterval(index1, index2);
        if (this.header != null) {
            this.header.removeRowSelectionInterval(index1, index2);
        }
    }

    public void clearSelection() {
        this.table.clearSelection();
        if (this.header != null) {
            this.header.clearSelection();
        }
    }

    public Dialog getDialog(Object id, Object listener) {
        return null;
    }

    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    public boolean areChartTipsOn() {
        return false;
    }

    public void setChartTipsOn(boolean on) {
    }

    public TipInterface getChartTip() {
        return null;
    }

    public String getStyle() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setStyle(Object newStyle) {
        if (newStyle == null) {
            return false;
        }
        if (newStyle instanceof Style) {
            this.graphStyle = (Style)newStyle;
        } else if (newStyle instanceof ColorScheme) {
            this.graphStyle = ((ColorScheme)newStyle).getStyle();
        } else {
            if (!(newStyle instanceof String)) return false;
            StyleCollection sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48);
            if (sc.getStyle((String)newStyle) == null) return false;
            this.graphStyle = sc.getStyle((String)newStyle);
        }
        if (this.graphStyle == null) {
            return false;
        }
        this.setBackground(this.graphStyle.getFillStyleElement("Backfill").getFillColor());
        if (this.table != null) {
            this.table.setGridColor(this.graphStyle.getLineStyleElement("TableGridLines").getLineColor());
        }
        if (this.header != null) {
            this.header.setGridColor(this.graphStyle.getLineStyleElement("TableGridLines").getLineColor());
        }
        TextStyleElement tableDataStyle = this.graphStyle.getTextStyleElement("TableDataText");
        TextStyleElement tableHeaderStyle = this.graphStyle.getTextStyleElement("TableHeaderText");
        this.style.setItemColor(1, tableDataStyle.getTextColor());
        this.style.setItemColor(3, tableHeaderStyle.getTextColor());
        this.style.setItemColor(0, this.graphStyle.getFillStyleElement("TableDataFill").getFillColor());
        this.style.setItemColor(2, this.graphStyle.getFillStyleElement("TableHeaderFill").getFillColor());
        Color[] dataColors = this.graphStyle.getDataFillColors();
        if (dataColors != null && dataColors.length >= 2) {
            this.style.positiveBarColor = dataColors[0];
            this.style.negativeBarColor = dataColors[1];
        }
        this.style.linkColor = Color.blue;
        this.style.visitedLinkColor = Color.MAGENTA;
        Color backSelection = this.graphStyle.getFillStyleElement("Selection").getFillColor();
        Color backSelectionSoft = ColorUtilities.setSB((Color)backSelection, (double)0.1, (double)0.9);
        this.style.setItemColor(4, backSelectionSoft);
        this.updateUIColors(false);
        if (this.table == null) return true;
        this.table.setFont(tableDataStyle.getAdjustedFont());
        this.table.setHeaderFont(tableHeaderStyle.getAdjustedFont());
        return true;
    }

    public ColorSchemeInterface getColorScheme() {
        return this.colorScheme;
    }

    public String getColorSchemeName() {
        if (this.colorScheme == null) {
            return null;
        }
        return this.colorScheme.getSchemeName();
    }

    public boolean setColorScheme(Object newScheme) {
        return this.setStyle(newScheme);
    }

    public DataFilterReadInterface getFilter() {
        return this.filter;
    }

    public DataFilterReadInterface getFilter(Object id) {
        return this.getFilter();
    }

    public boolean setDataListening(boolean listen) {
        this.listenToEvents = listen;
        if (this.listenToEvents) {
            this.enableEvents();
        } else {
            this.disableEvents();
        }
        return true;
    }

    public boolean isDataListening() {
        return false;
    }

    public boolean setTitle(int index, String textString) {
        return false;
    }

    public boolean setTitle(int index, TextStyleInterface textObject) {
        return false;
    }

    public TextStyleInterface getTitle(int index) {
        return null;
    }

    public boolean setFootnote(int index, String textString) {
        return false;
    }

    public boolean setFootnote(int index, TextStyleInterface textObject) {
        return false;
    }

    public TextStyleInterface getFootnote(int index) {
        return null;
    }

    public void enablePopup(boolean on) {
        if (this.table != null) {
            this.showPopMenu = this.table.showPopMenu = on;
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.table.getPopupMenu();
    }

    public void dispose() {
        SILKGlobal.unregister((PropertyInterface)this);
        if (this.tableSelectionAdapter != null) {
            this.tableSelectionAdapter.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (this.table != null) {
            this.table.dispose();
        }
    }

    public boolean applyWhereClause(String whereClause, boolean clear) {
        TableSorter ts;
        if (this.filter == null) {
            return false;
        }
        boolean rc = this.filter.applyWhereClause(whereClause, clear);
        if (rc && this.table != null && (ts = this.table.getGTableModel()) != null) {
            ts.tableChanged(new TableModelEvent((TableModel)this.gtModel, 0));
        }
        return rc;
    }

    public String getWhereClause() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getWhereClause();
    }

    public boolean getUsageMode(int mode) {
        return false;
    }

    public void setUsageMode(int mode, boolean on) {
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object idIn) {
        this.id = idIn;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean setEditable(boolean editable) {
        this.editable = editable;
        if (this.f2tModel != null) {
            this.f2tModel.setTableEditable(this.editable);
        }
        return true;
    }

    public boolean setActionMode(int mode) {
        return false;
    }

    public int getActionMode() {
        return 0;
    }

    public AnnotateInterface getAnnotate() {
        return null;
    }

    public Object getChart(Object id) {
        return null;
    }

    public Object getChartObject(Object id) {
        return this.getChart(id);
    }

    public boolean isBackBufferDrawEnabled() {
        return false;
    }

    public void setBackBufferDrawEnabled(boolean drawback) {
    }

    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    public boolean isActionEnabled(String action) {
        return true;
    }

    public boolean isPropertySupported(int id) {
        return id == 0;
    }

    public boolean isPropertyPending(int id) {
        if (id == 0) {
            return this.newColorScheme != null;
        }
        return false;
    }

    public Object getPropertyValue(int id) {
        if (id == 0) {
            if (this.newColorScheme == null) {
                return this.colorScheme;
            }
            return this.newColorScheme;
        }
        return null;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (id == 0) {
            if (value instanceof PropertyEvent) {
                value = ((PropertyEvent)value).value;
            }
            if (value == null) {
                this.newColorScheme = null;
            } else if (value instanceof ColorSchemeInterface) {
                this.newColorScheme = (ColorSchemeInterface)value;
            } else if (value instanceof String) {
                this.newColorScheme = new ColorScheme((String)value);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public int getNumberPendingProperties() {
        return 0;
    }

    public boolean applyPropertyChanges() {
        if (this.newColorScheme != null) {
            this.setColorScheme(this.newColorScheme);
            this.newColorScheme = null;
            return true;
        }
        return false;
    }

    public boolean applyPropertyChanges(Object source) {
        return this.applyPropertyChanges();
    }

    public void cancelPropertyChanges() {
        this.newColorScheme = null;
    }

    public void cancelPropertyChanges(Object source) {
        this.cancelPropertyChanges();
    }

    public int[] getPendingChanges() {
        return null;
    }

    public int[] getPendingChanges(Object source) {
        return null;
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        return rc;
    }

    public void setScrolling(boolean flag) {
        this.scroll = flag;
    }

    public boolean isScrolling() {
        return this.scroll;
    }

    public void enableEvents() {
        if (this.filter != null) {
            this.filter.addDataFilterListener((Object)this);
        }
    }

    public void disableEvents() {
        if (this.filter != null) {
            this.filter.removeDataFilterListener((Object)this);
        }
    }

    public JMenu getGTablePopMenu(String title, ActionListener listener) {
        if (this.tableMenu == null) {
            this.tableMenu = new JMenu("GTable");
            JPopupMenu popMenu = this.table.getPopupMenu();
            Component[] components = popMenu.getComponents();
            for (int i = 0; i < components.length; ++i) {
                this.tableMenu.add(components[i]);
            }
        }
        return this.tableMenu;
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        super.addMouseListener(listener);
        if (this.table != null) {
            this.table.addMouseListener(listener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        super.removeMouseListener(listener);
        this.table.removeMouseListener(listener);
    }

    public boolean setMaxComputedCellWidth(int width) {
        if (width <= 0) {
            return false;
        }
        this.table.maxComputedCellWidth = width;
        return true;
    }

    public void addDrilldownListener(DrilldownListenerInterface dli) {
        if (dli != null) {
            this.drilldownListeners.addElement(dli);
        }
    }

    public void removeDrilldownListener(DrilldownListenerInterface dli) {
        if (dli != null && this.drilldownListeners.contains(dli)) {
            this.drilldownListeners.removeElement(dli);
        }
    }

    protected void fireDrilldownEvent(String s) {
        DrilldownEvent de = new DrilldownEvent(s);
        for (int i = 0; i < this.drilldownListeners.size(); ++i) {
            ((DrilldownListenerInterface)this.drilldownListeners.elementAt(i)).drilldown(de);
        }
    }

    public void setColumnVisible(String name, boolean visible) {
        this.setColumnVisible(this.gtModel.getColumnIndex(name), visible);
    }

    public void setColumnVisible(int index, boolean visible) {
        if (index < 0 || index > this.gtModel.getColumnCount()) {
            return;
        }
        int idx = this.table.getGTableModel().getColumnIndexInVisibleModel(index);
        if (idx < 0 || idx > this.table.getGTableModel().getColumnCount()) {
            return;
        }
        if (!visible) {
            this.table.hideColumn(idx);
        }
    }

    public boolean isColumnVisible(String colName) {
        if (this.table == null) {
            return false;
        }
        TableSorter ts = this.table.getGTableModel();
        if (ts == null) {
            return false;
        }
        return ts.isColumnVisible(colName);
    }

    public void setHeaderWrap(boolean headerWrap) {
        this.gtModel.setHeaderWrap(headerWrap);
    }

    public boolean isHeaderWrapped() {
        return this.gtModel.isHeaderWrapped();
    }

    public void setColumnWrap(String name, boolean cellWrap) {
        this.gtModel.setColumnWrap(name, cellWrap);
    }

    public boolean getColumnWrap(String colName) {
        return this.gtModel.getColumnWrap(colName);
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        this.resetRowHeights();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    @Override
    public void buildPanel(GTableModel gtModel, boolean showFilter, boolean rowHeader, int appWidth, int appHeight) {
        JMenuItem mi;
        JPopupMenu popup;
        super.buildPanel(gtModel, showFilter, rowHeader, appWidth, appHeight);
        this.setStyle(this.graphStyle);
        this.table.getColumnModel().addColumnModelListener(this);
        this.table.getModel().addTableModelListener(this);
        if (this.header != null) {
            this.header.getModel().addTableModelListener(this);
        }
        if ((popup = this.table.getPopupMenu()) != null && (mi = MenuUtilities.getMenuItem((JPopupMenu)popup, (String)"DEBUG__SAVE_AS_XML")) != null) {
            EventListener[] listeners = mi.getListeners(ActionListener.class);
            if (listeners != null) {
                for (int i = 0; i < listeners.length && listeners[i] != this; ++i) {
                }
            }
            mi.addActionListener(this);
        }
        MenuUtilities.removeMenuItem((JPopupMenu)this.getPopupMenu(), (String)this.table.getHelpMenuActionCommand());
        MenuUtilities.trim((JPopupMenu)this.getPopupMenu());
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        this.resetRowHeights();
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.doResize(width, height);
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.doResize(width, height);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        Dimension d = this.getSize();
        this.doResize(d.width, d.height);
    }

    private void doResize(int width, int height) {
        this.resetRowHeights();
        this.paneWidth = width;
        this.resizeColumns();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("DEBUG__SAVE_AS_XML".equalsIgnoreCase(command)) {
            SILKParser.saveAsXML((Object)this, null, (boolean)true);
        }
    }

    @Override
    public Color getCellColor(int row, int column, Object value, TableCellRenderer cellRenderer) {
        value = this.getFormattedValue(row, column);
        if (value == null) {
            return null;
        }
        if (this.isMissing(row, column)) {
            return SILKUtilities.getStyleElement((String)value.toString(), (int)-1, (int)2, (Style)this.graphStyle, (String)"Missing", null).getAsDataStyle().getFillColor();
        }
        Object[] allUniques = this.getUniqueValues(column, false);
        if (allUniques == null) {
            return null;
        }
        int index = -1;
        for (int i = 0; i < allUniques.length; ++i) {
            if (allUniques[i] == null || !value.toString().equalsIgnoreCase(allUniques[i].toString())) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            return SILKUtilities.getStyleElement((String)value.toString(), (int)index, (int)2, (Style)this.graphStyle, (String)"GraphDataStyleDefault", null).getAsDataStyle().getFillColor();
        }
        return null;
    }

    protected int getColumnIndexInModel(int column) {
        if (this.table == null) {
            return -1;
        }
        TableSorter ts = this.table.getGTableModel();
        if (ts == null) {
            return -1;
        }
        if (this.filter == null) {
            return -1;
        }
        return ts.getColumnIndexInModel(column);
    }

    protected int getRowIndexInModel(int row) {
        if (this.table == null) {
            return -1;
        }
        TableSorter ts = this.table.getGTableModel();
        if (ts == null) {
            return -1;
        }
        if (this.filter == null) {
            return -1;
        }
        return ts.getModelRowFromView(row);
    }

    protected Object[] getUniqueValues(int column, boolean subset) {
        int id = this.getColumnIndexInModel(column);
        if (id == -1) {
            return null;
        }
        if (!(this.filter instanceof DataFilterInfoInterface)) {
            return null;
        }
        DataFilterInfoInterface info = (DataFilterInfoInterface)this.filter;
        return info.getUniqueValues(this.filter.getVariableId(id), subset);
    }

    protected Object getFormattedValue(int row, int column) {
        int id = this.getColumnIndexInModel(column);
        int obs = this.getRowIndexInModel(row);
        if (id == -1 || obs == -1) {
            return null;
        }
        return this.filter.getFormattedValue(this.filter.getVariableId(id), (long)obs, null);
    }

    @Override
    public boolean isMissing(int row, int column) {
        int id = this.getColumnIndexInModel(column);
        int obs = this.getRowIndexInModel(row);
        if (id == -1 || obs == -1) {
            return false;
        }
        return this.filter.isMissing(id, this.filter.getValue(id, (long)obs));
    }

    @Override
    protected int getIndex(Object value, int column) {
        if (value == null) {
            return -1;
        }
        Object[] uniqueValues = this.getUniqueValues(column, true);
        if (uniqueValues != null) {
            for (int i = 0; i < uniqueValues.length; ++i) {
                if (!value.equals(uniqueValues[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    protected int getNumberOfUniqueValues(int column) {
        Object[] uniqueValues = this.getUniqueValues(column, true);
        if (uniqueValues == null) {
            return 0;
        }
        return uniqueValues.length;
    }

    public boolean isTableScrollingToSelectedCell() {
        return this.scrollToSelected;
    }

    public void setScrollTableToSelectedCell(boolean scrollToSelected) {
        this.scrollToSelected = scrollToSelected;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("DATA_MODEL_SELECTION".equalsIgnoreCase(evt.getPropertyName()) && this.scrollToSelected) {
            this.scrollTableToSelectedRow();
        }
    }
}

