/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.fstree.FSTreeViewer;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.nld.DataFilterModel;
import com.sas.graphics.util.nld.NLDScrollPane;
import com.sas.graphics.util.nld.NLDScrollPaneInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FSTreeComponent
extends SILKComponent {
    private static final long serialVersionUID = 5068407453105481501L;
    protected SILKNumber nodeIDRole = this.roleIndex.getRoleObject("ROLE_NODE_ID");
    protected SILKNumber nodeLabelRole;
    protected SILKNumber nodeColorRole;
    protected SILKNumber nodeTipRole;
    protected SILKNumber linkIDRole;
    protected SILKNumber linkFromRole;
    protected SILKNumber linkToRole;
    protected SILKNumber linkColorRole;
    protected SILKNumber linkWidthRole;
    protected SILKNumber linkTipRole;
    protected FSTreeViewer chart;
    protected DataFilterModel model;
    protected NLDScrollPane nldScrollPane;
    private boolean rebuildRequired;
    protected Vector levelLabels = null;
    protected LabelStack labelStack = null;
    private boolean setLabelWeightsRequired = false;

    public FSTreeComponent() {
        this.roles.newRole((Object)this.nodeIDRole, (Object)"Node ID", 1);
        this.nodeLabelRole = this.roleIndex.getRoleObject("ROLE_NODE_LABEL");
        this.roles.newRole((Object)this.nodeLabelRole, (Object)"Node Label", 1);
        this.nodeColorRole = this.roleIndex.getRoleObject("ROLE_NODE_COLOR");
        this.roles.newRole((Object)this.nodeColorRole, (Object)"Node Color", 1);
        this.nodeTipRole = this.roleIndex.getRoleObject("ROLE_NODE_TIP");
        this.roles.newRole((Object)this.nodeTipRole, (Object)"Node Tip", 1);
        this.linkIDRole = this.roleIndex.getRoleObject("ROLE_LINK_ID");
        this.linkFromRole = this.roleIndex.getRoleObject("ROLE_LINK_FROM");
        this.roles.newRole((Object)this.linkFromRole, (Object)"Link From", 1);
        this.linkToRole = this.roleIndex.getRoleObject("ROLE_LINK_TO");
        this.roles.newRole((Object)this.linkToRole, (Object)"Link To", 1);
        this.linkTipRole = this.roleIndex.getRoleObject("ROLE_LINK_TIP");
        this.roles.newRole((Object)this.linkTipRole, (Object)"Link Tip", 1);
        this.rebuildRequired = false;
        this.model = new DataFilterModel();
        this.chart = new FSTreeViewer(this.model);
        this.chart.setInApplet(false);
        this.setLayout(new BorderLayout());
        this.nldScrollPane = new NLDScrollPane((NLDScrollPaneInterface)this.chart);
        this.add((Component)this.nldScrollPane);
        this.noToolBar = true;
    }

    protected void handleSetRole(RoleEvent roleEvent) {
        Object var = this.getFirstObject(this.roles.getVariable((Object)new Integer(roleEvent.role)));
        if (var == null) {
            return;
        }
        switch (roleEvent.role) {
            case 26: {
                this.model.setRole(0, var.toString(), "ID");
                break;
            }
            case 28: {
                this.model.setRole(0, var.toString(), "Label");
                break;
            }
            case 2: {
                this.model.setRole(0, var.toString(), "Color");
                break;
            }
            case 22: {
                this.model.setRole(0, var.toString(), "Info");
                break;
            }
            case 44: {
                this.model.setRole(1, var.toString(), "ID");
                break;
            }
            case 45: {
                this.model.setRole(1, var.toString(), "From");
                break;
            }
            case 46: {
                this.model.setRole(1, var.toString(), "To");
                break;
            }
            case 49: {
                this.model.setRole(1, var.toString(), "Label");
                break;
            }
            case 50: {
                this.model.setRole(1, var.toString(), "Info");
                break;
            }
            default: {
                return;
            }
        }
        this.rebuildRequired = true;
    }

    protected void handleRemoveRole(RoleEvent roleEvent) {
        Object var = this.getFirstObject(roleEvent.oldValue);
        if (var == null) {
            return;
        }
        switch (roleEvent.role) {
            case 26: {
                this.model.setRole(0, null, "ID");
                break;
            }
            case 28: {
                this.model.setRole(0, null, "Label");
                break;
            }
            case 2: {
                this.model.setRole(0, null, "Color");
                break;
            }
            case 22: {
                this.model.setRole(0, null, "Info");
                break;
            }
            case 44: {
                this.model.setRole(1, null, "ID");
                break;
            }
            case 45: {
                this.model.setRole(1, null, "From");
                break;
            }
            case 46: {
                this.model.setRole(1, null, "To");
                break;
            }
            case 49: {
                this.model.setRole(1, null, "Label");
                break;
            }
            case 50: {
                this.model.setRole(1, null, "Info");
                break;
            }
            default: {
                return;
            }
        }
        this.rebuildRequired = true;
    }

    protected Object getFirstObject(Object value) {
        if (value == null) {
            return null;
        }
        return Extract.getObject((Object)value, (int)0, (int)Extract.getSourceType((Object)value));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.rebuildRequired) {
            this.chart.load();
            this.rebuildRequired = false;
        }
        if (this.setLabelWeightsRequired) {
            this.setLabelWeights();
            this.setLabelWeightsRequired = false;
        }
    }

    public boolean setDataSource(Object source, Object id) {
        if (source == null || id == null) {
            return false;
        }
        if (id instanceof Number) {
            int idx = ((Number)id).intValue();
            switch (idx) {
                case 0: 
                case 1: {
                    return this.model.setDataSource(idx, source);
                }
            }
        }
        return false;
    }

    public Object getDataSource(Object id) {
        if (id == null) {
            return null;
        }
        if (id instanceof Number) {
            int modelType = ((Number)id).intValue();
            switch (modelType) {
                case 0: 
                case 1: {
                    return this.model.getDataSource(modelType);
                }
            }
        }
        return null;
    }

    public Object[] getDataIds() {
        return new Object[]{new Integer(0), new Integer(1)};
    }

    public boolean setStyle(Object newStyle) {
        boolean set = super.setStyle(newStyle);
        if (this.style != null) {
            this.chart.setBackground(this.style.getFillStyleElement("WallFill").getFillColor());
            Color[] colors = this.style.getDataLineColors();
            if (colors != null) {
                this.chart.setLinkColor(colors[0]);
            }
        }
        return set;
    }

    public boolean setSolidBackground(Object c) {
        boolean success = super.setSolidBackground(c);
        if (success) {
            this.chart.setBackColor(this.getSolidBackground());
        }
        return success;
    }

    public void roleChanged(RoleEvent roleEvent) {
        super.roleChanged(roleEvent);
        switch (roleEvent.type) {
            case 1: 
            case 2: {
                this.handleSetRole(roleEvent);
                break;
            }
            case 3: {
                this.handleRemoveRole(roleEvent);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.nodeIDRole = null;
        this.nodeLabelRole = null;
        this.nodeColorRole = null;
        this.nodeTipRole = null;
        this.linkIDRole = null;
        this.linkFromRole = null;
        this.linkToRole = null;
        this.linkColorRole = null;
        this.linkWidthRole = null;
        this.linkTipRole = null;
        this.chart = null;
        this.model = null;
        this.nldScrollPane = null;
    }

    public String getToolTipText(MouseEvent me) {
        return null;
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return null;
    }

    public boolean setLevelLabels(Collection levelLabels) {
        if (levelLabels == null) {
            return false;
        }
        if (this.levelLabels == null) {
            this.levelLabels = new Vector(levelLabels);
            this.labelStack = new LabelStack(this.levelLabels);
        } else {
            this.levelLabels.removeAllElements();
            this.levelLabels.addAll(levelLabels);
            this.labelStack.setLabels(this.levelLabels);
        }
        int[] layerLocations = this.chart.getLayerLocations();
        if (layerLocations == null) {
            this.setLabelWeightsRequired = true;
        } else {
            this.setLabelWeights();
        }
        this.nldScrollPane.setRowHeader((JComponent)this.labelStack);
        return true;
    }

    private void setLabelWeights() {
        int[] layerLocations = this.chart.getLayerLocations();
        if (layerLocations == null) {
            return;
        }
        int chartHeight = this.chart.getPreferredHeight();
        if (chartHeight <= 0) {
            return;
        }
        double[] weights = new double[layerLocations.length - 1];
        double sumWeights = 0.0;
        for (int i = 0; i < weights.length - 1; ++i) {
            weights[i] = (double)(layerLocations[i + 1] - layerLocations[i]) / (double)chartHeight;
            sumWeights += weights[i];
        }
        weights[weights.length - 1] = 1.0 - sumWeights;
        this.labelStack.setWeights(weights);
        this.labelStack.sizeButtons();
    }

    public boolean setReconciliationLine(Collection nodeList) {
        if (this.chart.setReconciliationLine(nodeList) && !this.rebuildRequired) {
            this.rebuildRequired = true;
            this.repaint();
            return true;
        }
        return false;
    }

    public boolean setReconciliationLine(int level) {
        if (this.chart.setReconciliationLine(level) && !this.rebuildRequired) {
            this.rebuildRequired = true;
            this.repaint();
            return true;
        }
        return false;
    }

    public Collection getReconciliationLine() {
        return this.chart.getReconciliationLine(0);
    }

    public void setReconciliationLineColor(Color color) {
    }

    public void setNodeFont(Font fnt) {
    }

    private class LabelStack
    extends JPanel {
        private static final long serialVersionUID = 4707758998851291542L;
        protected Collection labels = null;
        protected JButton[] labelButtons = null;
        protected int preferredHeight = 0;
        double[] labelWeights = null;

        public LabelStack() {
            this(null);
        }

        public LabelStack(Collection labels) {
            this.setLabels(labels);
        }

        public boolean setLabels(Collection labels) {
            if (labels != null) {
                this.labels = labels;
                this.initLabelButtons();
                this.initStack();
                return true;
            }
            return false;
        }

        @Override
        public Dimension getPreferredSize() {
            Graphics g;
            int maxLabelWidth = 0;
            if (this.labelButtons != null && (g = this.getGraphics()) != null) {
                FontMetrics fm = g.getFontMetrics();
                for (int i = 0; i < this.labelButtons.length; ++i) {
                    Rectangle2D r = fm.getStringBounds(this.labelButtons[i].getText(), g);
                    maxLabelWidth = Math.max(maxLabelWidth, (int)r.getWidth());
                }
                maxLabelWidth += 60;
            }
            return new Dimension(maxLabelWidth, this.preferredHeight);
        }

        @Override
        public void setPreferredSize(Dimension size) {
            if (size != null) {
                this.preferredHeight = size.height;
                if (this.labelButtons != null) {
                    this.sizeButtons();
                }
            }
        }

        public void sizeButtons() {
            Dimension d = this.getPreferredSize();
            if (d == null) {
                return;
            }
            int x = 0;
            int y = 0;
            int w = d.width;
            for (int i = 0; i < this.labelButtons.length; ++i) {
                int h = (int)((double)this.preferredHeight * this.labelWeights[i]);
                this.labelButtons[i].setBounds(x, y, w, h);
                y += h;
            }
        }

        private void initLabelButtons() {
            if (this.labels == null) {
                return;
            }
            Iterator i = this.labels.iterator();
            if (i == null) {
                return;
            }
            this.labelWeights = new double[this.labels.size()];
            this.labelButtons = new JButton[this.labels.size()];
            int cnt = 0;
            while (i.hasNext()) {
                String text = "";
                Object o = i.next();
                if (o != null) {
                    text = o.toString();
                }
                this.labelWeights[cnt] = 1.0 / (double)this.labelWeights.length;
                this.labelButtons[cnt] = new JButton(text);
                ++cnt;
            }
        }

        private void initStack() {
            if (this.labelButtons == null) {
                return;
            }
            this.setLayout(null);
            for (int i = 0; i < this.labelButtons.length; ++i) {
                this.add(this.labelButtons[i]);
            }
        }

        public void setWeights(double[] weights) {
            if (weights == null) {
                return;
            }
            if (this.labelWeights == null) {
                return;
            }
            if (weights.length == this.labelWeights.length) {
                for (int i = 0; i < this.labelWeights.length; ++i) {
                    this.labelWeights[i] = weights[i];
                }
            }
        }
    }
}

