/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.silk.data.TreeModel;
import com.sas.graphics.silk.dtree.DTreeNode;
import com.sas.graphics.silk.dtree.NodeRenderer;
import com.sas.graphics.silk.dtree.TreeCanvas;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.CompositeChartPrintInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.DecisionTreeInterface;
import com.sas.graphics.silk.interfaces.GraphBackgroundInterface;
import com.sas.graphics.silk.interfaces.ImageListInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.StyleInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.interfaces.TreeModelInterface;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.GraphBackground;
import com.sas.graphics.silk.util.Print;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class DecisionTree
extends JComponent
implements Printable,
DecisionTreeInterface,
GraphBackgroundInterface,
RoleInterface,
Pageable,
CompositeChartPrintInterface,
PropertyInterface,
ComponentListener {
    private static final long serialVersionUID = 8258480771888188790L;
    private TreeCanvas chart = null;
    private JScrollPane scrollPane = null;
    private ImageListInterface imageList = null;

    public DecisionTree(TreeModelInterface tm) {
        this.chart = new TreeCanvas(tm);
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.chart);
        this.add((Component)this.scrollPane, "Center");
        this.addComponentListener(this);
        this.chart.buildTree();
    }

    public DecisionTree() {
        this.addComponentListener(this);
        this.setLayout(new BorderLayout());
    }

    @Override
    public int getOrientation() {
        return this.chart.getOrientation();
    }

    @Override
    public void setOrientation(int orientation) {
        this.chart.setOrientation(orientation);
        this.chart.updateTree();
    }

    @Override
    public boolean isNodesEmpty() {
        return this.chart.emptyNodes;
    }

    @Override
    public void setNodesEmpty(boolean empty) {
        this.chart.emptyNodes = empty;
        this.chart.buildTree();
    }

    @Override
    public void setLegendVisible(boolean vis) {
        this.chart.setLegendVisible(vis);
    }

    @Override
    public boolean getLegendVisible() {
        return this.chart.getLegendVisible();
    }

    public void setZoom(int percentage) {
        int per = this.chart.xZoomPercentage;
        if (percentage == -999) {
            int fitToPage;
            Rectangle rect = this.chart.getBounds();
            double a = (double)rect.width / (double)this.chart.defaultTreeBounds.width;
            double b = (double)rect.height / (double)this.chart.defaultTreeBounds.height;
            per = fitToPage = (int)(100.0 * Math.min(a, b));
        } else {
            per = percentage;
        }
        this.chart.setScale(per, per);
        this.chart.buildTree();
    }

    public int getZoom() {
        if (this.isFitToPageMode()) {
            return -999;
        }
        return this.chart.xZoomPercentage;
    }

    @Override
    public Object getFocusNodeId() {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getFocusNodeId();
    }

    public Color getLinkSolidColor() {
        return this.chart.linkSolidColor;
    }

    public void setLinkSolidColor(Color colorIn) {
        if (colorIn != null) {
            this.chart.linkSolidColor = colorIn;
        }
    }

    @Override
    public ColorInterface getLinkColorRamp() {
        return this.chart.linkColorRamp;
    }

    @Override
    public void setLinkColorRamp(ColorInterface rampIn) {
        if (rampIn != null) {
            this.chart.linkColorRamp = rampIn;
        }
    }

    @Override
    public int getLinkWidth() {
        return this.chart.linkWidth;
    }

    @Override
    public void setLinkWidth(int i) {
        this.chart.linkWidth = i;
    }

    public double getLinkTransparency() {
        return this.chart.linkTransparency;
    }

    public void setLinkTransparency(double d) {
        this.chart.linkTransparency = d;
    }

    @Override
    public int getLinkStyle() {
        return this.chart.linkStyle;
    }

    @Override
    public void setLinkStyle(int i) {
        this.chart.linkStyle = i;
    }

    @Override
    public boolean isLinkTextVisible() {
        return this.chart.linkTextVisible;
    }

    @Override
    public void setLinkTextVisible(boolean b) {
        this.chart.linkTextVisible = b;
        this.chart.updateTree();
    }

    @Override
    public double[] getLinkWidthRange() {
        return new double[]{this.chart.minLinkWidth, this.chart.maxLinkWidth};
    }

    @Override
    public void setLinkWidthRange(int minWidth, int maxWidth) {
        this.chart.minLinkWidth = minWidth;
        this.chart.maxLinkWidth = maxWidth;
        this.chart.buildTree();
    }

    @Override
    public ColorInterface getNodeColorRamp() {
        return this.chart.nodeColorRamp;
    }

    @Override
    public void setNodeColorRamp(ColorInterface rampIn) {
        if (rampIn != null) {
            this.chart.nodeColorRamp = rampIn;
            this.chart.userSetRampColors = rampIn.getColors();
            this.chart.nodeColorRamp.setRange(this.chart.minNodeSize, this.chart.maxNodeSize);
        }
    }

    public void setNodeBackground(Color c) {
        GraphBackground gbkg = new GraphBackground();
        gbkg.setSolidBackground((Object)c);
        this.chart.nodeBackground = gbkg;
    }

    @Override
    public int getNodeOutlineWidth() {
        return this.chart.nodeOutlineWidth;
    }

    @Override
    public void setNodeOutlineWidth(int i) {
        this.chart.nodeOutlineWidth = i;
    }

    @Override
    public double[] getNodeSizeRange() {
        double[] rc = new double[]{this.chart.minNodeSize, this.chart.maxNodeSize};
        return rc;
    }

    @Override
    public void setNodeSizeRange(double minSize, double maxSize) {
        this.chart.minNodeSize = minSize;
        this.chart.maxNodeSize = maxSize;
        this.chart.userSetNodeSize = true;
        this.chart.buildTree();
    }

    @Override
    public Color getFlaggedNodeColor() {
        return this.chart.flaggedNodeBackground.getSolidBackground();
    }

    @Override
    public void setFlaggedNodeColor(Color c) {
        this.chart.flaggedNodeBackground.setSolidBackground((Object)c);
    }

    @Override
    public int getFlaggedNodeOutlineWidth() {
        return this.chart.flaggedNodeOutlineWidth;
    }

    @Override
    public void setFlaggedNodeOutlineWidth(int i) {
        this.chart.flaggedNodeOutlineWidth = i;
    }

    @Override
    public void clearAllFlaggedNodes() {
        this.chart.clearAllFlaggedNodes();
    }

    public TextStyleInterface getTitle() {
        return this.chart.titles.getTitle(0);
    }

    public void setTitle(String t) {
        ((TreeCanvas)this.getChartObject(null)).setTitle(0, t);
    }

    public TextStyleInterface getFootnote() {
        if (this.chart == null) {
            this.chart = new TreeCanvas(null);
        }
        return this.chart.footnote.getFootnote(0);
    }

    public void setFootnote(String s) {
        ((TreeCanvas)this.getChartObject(null)).setFootnote(0, s);
    }

    public boolean areNodeLabelsVisible() {
        return ((TreeCanvas)this.getChartObject(null)).showNodeLabels;
    }

    public void setNodeLabelsVisible(boolean vis) {
        ((TreeCanvas)this.getChartObject(null)).showNodeLabels = vis;
    }

    public boolean areNodeGraphsVisible() {
        return ((TreeCanvas)this.getChartObject(null)).showNodeGraphs;
    }

    public void setNodeGraphsVisible(boolean vis) {
        ((TreeCanvas)this.getChartObject(null)).showNodeGraphs = vis;
    }

    public void setFlaggedNodeGraphsVisible(boolean vis) {
        ((TreeCanvas)this.getChartObject(null)).showFlaggedNodeGraphs = vis;
    }

    public boolean areFlaggedNodeGraphsVisible() {
        return ((TreeCanvas)this.getChartObject(null)).showFlaggedNodeGraphs;
    }

    @Override
    public void scrollToNode(Object ID) {
        DTreeNode t = this.chart.getNodeForID(ID);
        Rectangle r = t.getBounds();
        this.scrollPane.scrollRectToVisible(r);
        this.repaint();
    }

    @Override
    public Image getImage(int w, int h) {
        BufferedImage i = new BufferedImage(w, h, 1);
        Graphics2D g2 = i.createGraphics();
        PageFormat pf = new PageFormat();
        Paper paper = new Paper();
        paper.setImageableArea(0.0, 0.0, w, h);
        pf.setPaper(paper);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, w, h);
        int printMode = this.chart.getPrintMode();
        this.chart.setPrintMode(3);
        this.chart.print(g2, pf, 0);
        this.chart.setPrintMode(printMode);
        return i;
    }

    @Override
    public Object getBackgroundObject() {
        return this.chart.background.getGraphBackground();
    }

    @Override
    public void setBackgroundObject(Object b) {
        if (b instanceof Color) {
            this.chart.background.setSolidBackground((Object)((Color)b));
        }
    }

    @Override
    public TreeModelInterface getTreeModel() {
        return this.chart.getTreeModel();
    }

    @Override
    public boolean setTreeModel(TreeModelInterface tm) {
        if (this.chart != null) {
            this.removeAll();
        }
        if (this.chart == null) {
            this.chart = new TreeCanvas(tm);
        } else {
            this.chart.tree = tm;
        }
        this.chart.imageList = this.imageList;
        this.scrollPane = new JScrollPane(this.chart);
        this.add((Component)this.scrollPane, "Center");
        this.chart.buildTree();
        return true;
    }

    @Override
    public void printTree(boolean fitToPage) {
        Print.print((Object)this.chart);
    }

    public void enablePopup(boolean enable) {
        this.chart.enablePopup(enable);
    }

    @Override
    public int getNumberOfPages() {
        return this.chart.getNumberOfPages();
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.chart.getPageFormat(pageIndex);
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this.chart;
    }

    public int getPrintMode() {
        return this.chart.getPrintMode();
    }

    public boolean setPrintMode(int printMode) {
        return this.chart.setPrintMode(printMode);
    }

    public int[] getSupportedPrintModes() {
        return this.chart.getSupportedPrintModes();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        return this.chart.print(graphics, pageFormat, pageIndex);
    }

    public boolean setActionMode(int mode) {
        ((TreeCanvas)this.getChart(null)).setActionMode(mode);
        return true;
    }

    public int getActionMode() {
        return this.chart.getActionMode();
    }

    public Component getToolBar() {
        return null;
    }

    public boolean setToolBar(Component d) {
        return false;
    }

    public JPopupMenu getPopupMenu() {
        if (this.chart != null) {
            return this.chart.getPopupMenu();
        }
        return null;
    }

    public Dialog getDialog(Object id, Object listener) {
        return ((TreeCanvas)this.getChartObject(null)).getDialog(id, listener);
    }

    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    public boolean areChartTipsOn() {
        return ((TreeCanvas)this.getChartObject(null)).areChartTipsOn();
    }

    public void setChartTipsOn(boolean b) {
        ((TreeCanvas)this.getChartObject(null)).setChartTipsOn(b);
    }

    public String getStyle() {
        if (this.chart == null || this.chart.style == null) {
            return null;
        }
        return this.chart.style.getStyleName();
    }

    public StyleInterface getStyleObject() {
        return null;
    }

    public boolean setStyle(Object o) {
        if (this.chart != null) {
            return this.chart.setStyle(o);
        }
        return false;
    }

    public ImageListInterface getImageList() {
        return this.chart.imageList;
    }

    public boolean setImageList(ImageListInterface ili) {
        this.imageList = ili;
        if (this.chart != null) {
            this.chart.imageList = ili;
        }
        return true;
    }

    public ColorSchemeInterface getColorScheme() {
        return this.chart.getColorScheme();
    }

    public String getColorSchemeName() {
        return this.chart.getColorSchemeName();
    }

    public boolean setColorScheme(Object scheme) {
        return ((TreeCanvas)this.getChart(null)).setColorScheme(scheme);
    }

    public DataFilterReadInterface getFilter() {
        return ((TreeCanvas)this.getChartObject(null)).getFilter();
    }

    public DataFilterReadInterface getFilter(Object id) {
        return this.getFilter();
    }

    public boolean isDataListening() {
        return ((TreeCanvas)this.getChartObject(null)).isDataListening();
    }

    public boolean setDataListening(boolean b) {
        ((TreeCanvas)this.getChartObject(null)).setDataListening(b);
        return true;
    }

    public AxisInterface getAxis(Object which) {
        return null;
    }

    public boolean setExternalAxis(Object which, AxisInterface axis) {
        return false;
    }

    public LegendInterface getLegend(Object which) {
        return null;
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        if (this.chart == null || this.chart.tree == null) {
            return false;
        }
        return this.chart.applyWhereClause(clause, clearPrevious);
    }

    public String getWhereClause() {
        if (this.chart == null || this.chart.tree == null) {
            return null;
        }
        return this.chart.getWhereClause();
    }

    public boolean setTitle(int index, String textString) {
        this.setTitle(textString);
        return true;
    }

    public boolean setTitle(int index, TextStyleInterface textObject) {
        if (this.chart != null && this.chart.titles != null) {
            this.chart.titles.setText(index, textObject);
            return true;
        }
        return false;
    }

    public TextStyleInterface getTitle(int index) {
        if (this.chart == null) {
            this.chart = new TreeCanvas(null);
        }
        return this.chart.getTitle(index);
    }

    public boolean setFootnote(int index, String textString) {
        this.setFootnote(textString);
        return true;
    }

    public boolean setFootnote(int index, TextStyleInterface textObject) {
        ((TreeCanvas)this.getChartObject(null)).setFootnote(index, textObject);
        return true;
    }

    public TextStyleInterface getFootnote(int index) {
        if (this.chart == null) {
            this.chart = new TreeCanvas(null);
        }
        return this.chart.getFootnote(index);
    }

    public Object getLegendPosition(Object which) {
        if (this.chart == null) {
            this.chart = new TreeCanvas(null);
        }
        return this.chart.getLegendPosition(which);
    }

    public boolean setLegendPosition(Object which, Object positionIn) {
        return false;
    }

    public Rectangle getLegendBounds() {
        return null;
    }

    public boolean setLegendBounds(Rectangle rect) {
        return false;
    }

    public TipInterface getChartTip() {
        return ((TreeCanvas)this.getChart(null)).getChartTip();
    }

    public void dispose() {
        this.removeAll();
        if (this.chart != null) {
            this.chart.dispose();
        }
        this.chart = null;
        if (this.scrollPane != null) {
            this.scrollPane.removeAll();
        }
        this.scrollPane = null;
        this.imageList = null;
    }

    public boolean isBackBufferDrawEnabled() {
        return false;
    }

    public boolean isModelAttributeHonored(Object attribute) {
        return false;
    }

    public void setBackBufferDrawEnabled(boolean drawback) {
    }

    public boolean setHonorModelAttribute(Object attribute, boolean honorit) {
        return false;
    }

    public int getSelectionBehavior() {
        return 0;
    }

    public Object getSelectionBehaviorValue() {
        return null;
    }

    public boolean setSelectionBehavior(int behavior, Object value) {
        return false;
    }

    public boolean getUsageMode(int mode) {
        return false;
    }

    public void setUsageMode(int mode, boolean on) {
    }

    public void addViewportListener(Object listener) {
    }

    public void removeViewportListener(Object listener) {
    }

    public Object getId() {
        return ((TreeCanvas)this.getChart(null)).getId();
    }

    public void setId(Object id) {
        ((TreeCanvas)this.getChart(null)).setId(id);
    }

    public Object getChart(Object id) {
        if (this.chart == null) {
            this.chart = new TreeCanvas(null);
        }
        return this.chart;
    }

    public Object getChartObject(Object id) {
        return this.getChart(id);
    }

    public boolean isEditable() {
        return false;
    }

    public boolean setEditable(boolean editable) {
        return false;
    }

    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    public boolean isActionEnabled(String action) {
        return true;
    }

    public AnnotateInterface getAnnotate() {
        return null;
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource(Object id) {
        if (this.chart == null || this.chart.tree == null) {
            return null;
        }
        TreeModelInterface ri = this.chart.tree;
        return ri.getDataSource();
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public boolean setDataSource(Object source, Object id) {
        if (this.chart == null || this.chart.tree == null) {
            TreeModelInterface model = source instanceof TreeModelInterface ? (TreeModelInterface)source : new TreeModel(source);
            this.setTreeModel(model);
            return true;
        }
        if (!(this.chart.tree instanceof RoleInterface)) {
            return false;
        }
        TreeModelInterface ri = this.chart.tree;
        boolean rc = ri.setDataSource(source);
        this.chart.reset();
        this.revalidate();
        this.repaint();
        return rc;
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    public Object getVariable(Object role) {
        if (this.chart == null || this.chart.tree == null) {
            return null;
        }
        if (!(this.chart.tree instanceof RoleInterface)) {
            return null;
        }
        TreeModelInterface ri = this.chart.tree;
        return ri.getVariable(role);
    }

    public Object getRole(Object variableId) {
        if (this.chart == null || this.chart.tree == null) {
            return null;
        }
        if (!(this.chart.tree instanceof RoleInterface)) {
            return null;
        }
        TreeModelInterface ri = this.chart.tree;
        return ri.getRole(variableId);
    }

    public boolean addRole(Object varID, Object role) {
        return this.setRole(varID, role);
    }

    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public boolean setRole(Object variableId, Object role) {
        if (this.chart == null || this.chart.tree == null) {
            return false;
        }
        if (!(this.chart.tree instanceof RoleInterface)) {
            return false;
        }
        TreeModelInterface ri = this.chart.tree;
        return ri.setRole(variableId, role);
    }

    public boolean removeRole(Object variableId, Object role) {
        if (this.chart == null || this.chart.tree == null) {
            return false;
        }
        if (!(this.chart.tree instanceof RoleInterface)) {
            return false;
        }
        TreeModelInterface ri = this.chart.tree;
        return ri.removeRole(variableId, role);
    }

    public boolean isDiscrete(Object variableId) {
        if (this.chart == null || this.chart.tree == null) {
            return false;
        }
        if (!(this.chart.tree instanceof RoleInterface)) {
            return false;
        }
        TreeModelInterface ri = this.chart.tree;
        return ri.isDiscrete(variableId);
    }

    public boolean setDiscrete(Object variableId, boolean discrete) {
        if (this.chart == null || this.chart.tree == null) {
            return false;
        }
        if (!(this.chart.tree instanceof RoleInterface)) {
            return false;
        }
        TreeModelInterface ri = this.chart.tree;
        return ri.setDiscrete(variableId, discrete);
    }

    public Object getRoleValue(Object role, int which) {
        return null;
    }

    public Object[] getSupportedRoles(Object id, boolean b) {
        if (this.chart == null || this.chart.tree == null) {
            return null;
        }
        if (!(this.chart.tree instanceof RoleInterface)) {
            return null;
        }
        TreeModelInterface ri = this.chart.tree;
        return ri.getSupportedRoles(null, b);
    }

    public int getMaxAllowed(Object o) {
        return 1;
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public Object getSortOrder(Object variableId) {
        if (this.chart == null || this.chart.tree == null) {
            return null;
        }
        if (!(this.chart.tree instanceof RoleInterface)) {
            return null;
        }
        TreeModelInterface ri = this.chart.tree;
        return ri.getSortOrder(variableId);
    }

    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    public boolean setSortOrder(Object variableId, Object order) {
        if (this.chart == null || this.chart.tree == null) {
            return false;
        }
        if (!(this.chart.tree instanceof RoleInterface)) {
            return false;
        }
        TreeModelInterface ri = this.chart.tree;
        return ri.setSortOrder(variableId, order);
    }

    public void addRoleListener(RoleListenerInterface rli) {
        if (this.chart == null || this.chart.tree == null) {
            return;
        }
        if (!(this.chart.tree instanceof RoleInterface)) {
            return;
        }
        TreeModelInterface ri = this.chart.tree;
        ri.addRoleListener(rli);
    }

    public void removeRoleListener(RoleListenerInterface rli) {
        if (this.chart == null || this.chart.tree == null) {
            return;
        }
        if (!(this.chart.tree instanceof RoleInterface)) {
            return;
        }
        TreeModelInterface ri = this.chart.tree;
        ri.removeRoleListener(rli);
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        if (this.chart == null) {
            return;
        }
        this.chart.addMouseListener(ml);
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        if (this.chart == null) {
            return;
        }
        this.chart.removeMouseListener(ml);
    }

    public Object[] getGraphBackground() {
        return ((TreeCanvas)this.getChart(null)).background.getGraphBackground();
    }

    public boolean setGradientBackground(Object startColor, Object endColor, Object orientation) {
        return ((TreeCanvas)this.getChart(null)).background.setGradientBackground(startColor, endColor, orientation);
    }

    public boolean setImageBackground(Image img, Object fitStyle, int x, int y, double blend) {
        return ((TreeCanvas)this.getChart(null)).background.setImageBackground(img, fitStyle, x, y, blend);
    }

    public Color getSolidBackground() {
        return ((TreeCanvas)this.getChart(null)).background.getSolidBackground();
    }

    public boolean setSolidBackground(Object c) {
        return ((TreeCanvas)this.getChart(null)).background.setSolidBackground(c);
    }

    public void redrawGraphBackground(Component c) {
        ((TreeCanvas)this.getChart(null)).background.redrawGraphBackground(c);
    }

    public boolean supportsGradientBackground() {
        return ((TreeCanvas)this.getChart(null)).background.supportsGradientBackground();
    }

    public boolean supportsImageBackground() {
        return ((TreeCanvas)this.getChart(null)).background.supportsImageBackground();
    }

    public GraphBackgroundInterface getNodeBackground() {
        return this.chart.nodeBackground;
    }

    public GraphBackgroundInterface getFlaggedNodeBackground() {
        return this.chart.flaggedNodeBackground;
    }

    public int getInitialDisplayDepth() {
        return this.chart.initialDisplayLevel;
    }

    public void setInitialDisplayDepth(int i) {
        if (i > 0) {
            this.chart.initialDisplayLevel = i;
        }
        this.repaint();
    }

    public void setBarData(Object data) {
        this.chart.tree.setGraphData(FilterFactory.getDataSourceFilter((Object)data));
    }

    public NodeRenderer getCustomNodeRenderer() {
        if (this.chart != null) {
            return this.chart.getNodeRenderer();
        }
        return null;
    }

    public void setCustomNodeRenderer(NodeRenderer r) {
        if (r != null) {
            this.chart.setNodeRenderer(r);
        }
    }

    public NodeRenderer getCustomTooltipRenderer() {
        if (this.chart != null) {
            return this.chart.getTooltipRenderer();
        }
        return null;
    }

    public void setCustomTooltipRenderer(NodeRenderer r) {
        if (this.chart != null) {
            this.chart.setTooltipRenderer(r);
        }
    }

    public void reset() {
        this.chart.reset();
    }

    public void removeMenuItem(String item) {
        this.chart.removeMenuItem(item);
    }

    public boolean setNodeText(TextStyleInterface textIn) {
        return this.chart.setNodeText(textIn, false);
    }

    public TextStyleInterface getNodeText() {
        return this.chart.getNodeText(false);
    }

    public boolean setFlaggedNodeText(TextStyleInterface textIn) {
        return this.chart.setNodeText(textIn, true);
    }

    public void addDrilldownListener(DrilldownListenerInterface d) {
    }

    public void removeDrilldownListener(DrilldownListenerInterface d) {
    }

    protected void doResize(int compWidthIn, int compHeightIn) {
        if (this.chart.isFitToPageMode()) {
            this.chart.fitToPage();
        }
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
    }

    public void setNodeUseTipText(boolean use) {
        this.chart.setNodeUseTipText(use);
    }

    public boolean isNodeUseTipText() {
        return this.chart.nodesUseTipText;
    }

    public boolean isFitToPageMode() {
        return this.chart.isFitToPageMode();
    }

    public void setFitToPageMode(boolean on) {
        this.chart.setFitToPageMode(on);
    }

    public void setLinkText(TextStyleInterface text) {
        this.chart.setLinkText(text);
    }

    public TextStyleInterface getLinkText() {
        return this.chart.getLinkText();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.chart != null) {
            this.chart.rebuildNodes();
        }
    }

    public boolean applyPropertyChanges() {
        if (this.chart != null) {
            return this.chart.applyPropertyChanges();
        }
        return false;
    }

    public boolean applyPropertyChanges(Object source) {
        if (this.chart != null) {
            return this.chart.applyPropertyChanges(source);
        }
        return false;
    }

    public void cancelPropertyChanges() {
        if (this.chart != null) {
            this.chart.cancelPropertyChanges();
        }
    }

    public void cancelPropertyChanges(Object source) {
        if (this.chart != null) {
            this.chart.cancelPropertyChanges(source);
        }
    }

    public int getNumberPendingProperties() {
        if (this.chart != null) {
            return this.chart.getNumberPendingProperties();
        }
        return 0;
    }

    public int[] getPendingChanges() {
        if (this.chart != null) {
            return this.chart.getPendingChanges();
        }
        return null;
    }

    public int[] getPendingChanges(Object source) {
        if (this.chart != null) {
            return this.chart.getPendingChanges(source);
        }
        return null;
    }

    public Object getPropertyValue(int id) {
        if (this.chart != null) {
            return this.chart.getPropertyValue(id);
        }
        return null;
    }

    public boolean hasUserSetValue(int id) {
        if (this.chart != null) {
            return this.chart.hasUserSetValue(id);
        }
        return false;
    }

    public boolean isPropertyPending(int id) {
        if (this.chart != null) {
            return this.chart.isPropertyPending(id);
        }
        return false;
    }

    public boolean isPropertySupported(int id) {
        if (this.chart != null) {
            return this.chart.isPropertySupported(id);
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.chart != null) {
            return this.chart.setPropertyValue(id, value);
        }
        return false;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.chart.isFitToPageMode()) {
            this.chart.emptyNodes = this.chart.xScale < 0.05 || this.chart.yScale < 0.05;
        }
        this.doResize(this.getWidth(), this.getHeight());
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

