/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.silk.constchart.DataFilterConstViewer;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.info.SILKChartInfo;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.ConstChartInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.GraphToolbarInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.ui.BaseLinksPanel;
import com.sas.graphics.silk.ui.BaseNodesPanel;
import com.sas.graphics.silk.ui.DataOptionsDialog;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.LinksPanel;
import com.sas.graphics.silk.ui.NodesPanel;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.Footnote;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.GraphBackground;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.RoleManager;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.Title;
import com.sas.graphics.silk.util.nld.DataFilterLinkModel;
import com.sas.graphics.silk.util.nld.DataFilterModel;
import com.sas.graphics.silk.util.nld.DataFilterNodeModel;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.StringCompare;
import com.sas.graphics.util.nld.NLD;
import com.sas.graphics.util.nld.NLDModel;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JToolTip;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class ConstComponent
extends JComponent
implements Printable,
ActionListener,
ItemListener,
MouseListener,
PropertyInterface,
RoleInterface,
ConstChartInterface,
RoleListenerInterface,
TextListenerInterface {
    private static final long serialVersionUID = 2786803479637706018L;
    protected GradientPaint gp;
    protected Image backImage;
    protected Image gpBackImage;
    protected Image scaledBackImage;
    protected double imageBlend;
    protected int imageFitStyle;
    protected boolean bufferUpdateRequired;
    protected int gradientOrientation;
    private DataFilterConstViewer chart;
    private DataFilterModel model;
    private DataFilterReadInterface nodeFilter;
    private DataFilterReadInterface linkFilter;
    private Object nodeSource;
    private Object linkSource;
    private int noBreakPoints = 3;
    private Double[] breakpoints = new Double[this.noBreakPoints];
    private Color[] colors = new Color[this.noBreakPoints];
    private long flags;
    private ColorRamp clrRamp;
    private JPopupMenu popup;
    Cursor moveOpen;
    Cursor moveClosed;
    Cursor zoomCursor;
    Cursor viewportCursor;
    private boolean listening = true;
    private Component toolbar = null;
    private ColorSchemeInterface clrScheme = null;
    private Dialog ccdlg;
    private ResourceBundle resourceBundle;
    private Hashtable properties;
    public static final int NUMBER_PROPERTIES = 35;
    public static final int INITIAL_SIZE = 50;
    private boolean showPopup = true;
    private int lwidth = 0;
    private double nsize = 0.0;
    private Frame parentFrame = null;
    private boolean showThresholdScrollbar = false;
    private ThresholdScrollbarPanel thresholdScrollbarPanel = null;
    private boolean toolbarMenuItemVisible = true;
    private RoleManager roleManager = null;
    private Roles roleIndex = Roles.getInstance(null);
    BaseLinksPanel linksPanel = null;
    private Title titles = null;
    private Footnote footnotes = null;
    private GraphBackground background;
    private int activeModelMode = 0;
    private boolean supportsThresholdSlider = true;
    private boolean firstShowDialog = true;
    DataOptionsDialog dataDlg = null;
    JMenuItem grphOptions = null;
    JMenuItem dataOptions = null;
    JMenuItem actionToolbar = null;
    private boolean chartLoaded = false;
    Style style = null;
    private GlobalDefaults silkDefaults = new GlobalDefaults();
    private boolean colorMappingLinks = true;
    private boolean colorMappingNodes = true;
    private boolean fixColorNodes = false;
    private boolean fixColorLinks = false;
    private boolean fixedShapeNoneSelected = false;
    private int lastLayoutType = -1;
    private boolean isLastLayoutUser = false;
    private boolean showAllLinksCBSelected = true;
    private boolean showIntoLinksCBSelected = true;
    private boolean showOutofLinksCBSelected = true;
    private boolean showAmongLinksCBSelected = true;
    private boolean xLocRolePresent = false;
    private boolean yLocRolePresent = false;

    public ConstComponent() {
        this.resourceBundle = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
        this.model = new DataFilterModel();
        this.chart = new DataFilterConstViewer(this.model, this);
        this.chart.setInApplet(false);
        this.chart.setActionMode(1);
        this.chart.setHandlePopup(false);
        this.chart.setTextColor(Color.black);
        this.chart.setDefaultNodeSize(0.02);
        this.chart.setFontSize(10);
        this.chart.setActionModeValid(true);
        this.chart.setDebug(false);
        this.chart.setRBSizing(true);
        this.moveOpen = this.chart.getMoveOpenCursor();
        if (this.moveOpen == null) {
            this.chart.setMoveOpenCursor(this.getCustomCursor(6, 2, "icons/MoveOpen.gif"));
        }
        if ((this.zoomCursor = this.chart.getZoomCursor()) == null) {
            this.chart.setZoomCursor(this.getCustomCursor(6, 2, "icons/Zoom.gif"));
        }
        if ((this.viewportCursor = this.chart.getViewPortCursor()) == null) {
            this.chart.setViewPortCursor(this.getCustomCursor(6, 2, "icons/Viewport.gif"));
        }
        if ((this.moveClosed = this.chart.getMoveClosedCursor()) == null) {
            this.chart.setMoveClosedCursor(this.getCustomCursor(6, 2, "icons/MoveClosed.gif"));
        }
        String[] actionCmd = new String[]{"NLD_SEL_CON_NODES", "NLD_SEL_ALL_CON_NODES", "NLD_SUBSET", "NLD_RESET"};
        this.chart.setNodeOptionActionArray(actionCmd);
        super.setLayout(null);
        this.add((Component)((Object)this.chart));
        this.roleManager = new RoleManager();
        this.roleManager.addRoleListener((RoleListenerInterface)this);
        this.gradientOrientation = 0;
        this.imageBlend = 1.0;
        this.imageFitStyle = 1;
        this.chart.addMouseListener(this);
        this.addMouseListener(this);
        this.titles = new Title();
        this.titles.addTextListener((TextListenerInterface)this);
        this.footnotes = new Footnote();
        this.footnotes.addTextListener((TextListenerInterface)this);
        this.background = new GraphBackground((JComponent)this);
        this.setStyle("SILKDefault");
        this.properties = new Hashtable();
        this.doAnimate(true);
        this.setLayoutStrategy(3);
        this.initRoleManager();
        this.setDatasetType("assoc");
        SILKGlobal.register((PropertyInterface)this);
    }

    private void initRoleManager() {
        SILKNumber roleObj = null;
        roleObj = this.roleIndex.getRoleObject("ROLE_NODE_ID");
        this.roleManager.newRole((Object)roleObj, (Object)"Node ID", 1, (Object)"Nodes", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_NODE_VALUE");
        this.roleManager.newRole((Object)roleObj, (Object)"Node Value", 1, (Object)"Nodes", -1);
        this.roleManager.setRoleType((Object)roleObj, 1);
        roleObj = this.roleIndex.getRoleObject("ROLE_NODE_SIZE");
        this.roleManager.newRole((Object)roleObj, (Object)"Node Size", 1, (Object)"Nodes", -1);
        this.roleManager.setRoleType((Object)roleObj, 1);
        roleObj = this.roleIndex.getRoleObject("ROLE_NODE_COLOR");
        this.roleManager.newRole((Object)roleObj, (Object)"Node Color", 1, (Object)"Nodes", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_NODE_SHAPE");
        this.roleManager.newRole((Object)roleObj, (Object)"Node Shape", 1, (Object)"Nodes", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_NODE_LABEL");
        this.roleManager.newRole((Object)roleObj, (Object)"Node Label", 1, (Object)"Nodes", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_NODE_TIP");
        this.roleManager.newRole((Object)roleObj, (Object)"Node Tip", 1, (Object)"Nodes", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_NODE_X");
        this.roleManager.newRole((Object)roleObj, (Object)"Node X", 1, (Object)"Nodes", -1);
        this.roleManager.setRoleType((Object)roleObj, 1);
        roleObj = this.roleIndex.getRoleObject("ROLE_NODE_Y");
        this.roleManager.newRole((Object)roleObj, (Object)"Node Y", 1, (Object)"Nodes", -1);
        this.roleManager.setRoleType((Object)roleObj, 1);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_ID");
        this.roleManager.newRole((Object)roleObj, (Object)"Link ID", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_FROM");
        this.roleManager.newRole((Object)roleObj, (Object)"Link From", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_TO");
        this.roleManager.newRole((Object)roleObj, (Object)"Link To", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_VALUE");
        this.roleManager.newRole((Object)roleObj, (Object)"Link Value", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 1);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_WIDTH");
        this.roleManager.newRole((Object)roleObj, (Object)"Link Width", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 1);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_COLOR");
        this.roleManager.newRole((Object)roleObj, (Object)"Link Color", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_TIP");
        this.roleManager.newRole((Object)roleObj, (Object)"Link Tip", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.chartLoaded) {
            this.load();
        }
        if (this.thresholdScrollbarPanel != null) {
            this.thresholdScrollbarPanel.updateScrollBar();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.toolbar != null) {
            this.toolbar.setVisible(false);
        }
    }

    public void ShowGraphOptionsDialog() {
        if (this.ccdlg == null) {
            return;
        }
        if (this.firstShowDialog) {
            if (this.ccdlg instanceof GraphPropertiesDialog) {
                ((GraphPropertiesDialog)this.ccdlg).setSelectedNode((Object)ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"ConstComponent.GraphDialog.Nodes.txt", (String)"Nodes"));
            }
            this.firstShowDialog = false;
        }
        this.ccdlg.setVisible(true);
    }

    public void createGraphDialog() {
        this.createGraphDialog(null);
    }

    private void createGraphDialog(Object listener) {
        ConstComponent pi = listener instanceof PropertyInterface ? (PropertyInterface)listener : this;
        JComponent jc = listener instanceof JComponent ? (JComponent)listener : this;
        GraphPropertiesDialog propertiesDialog = new GraphPropertiesDialog(this.parentFrame, ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"ConstComponent.ConstellationProps.txt", (String)"Constellation Properties"));
        this.ccdlg = propertiesDialog;
        GraphPanel grphPanel = new GraphPanel((PropertyInterface)pi, null);
        String title = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"ConstComponent.GraphDialog.Graph.txt", (String)"Graph");
        ((GraphPropertiesDialog)this.ccdlg).addRootNode((Object)title, (Component)grphPanel);
        GraphPropertiesDialog.PropertiesTreeNode node = propertiesDialog.getRootNode((Object)"Chart", true);
        if (this.getId() == null) {
            this.setId(this.generateDefaultChartId(this));
        }
        node.setDisplayName(this.getId().toString());
        NodesPanel nodesPanel = new NodesPanel(pi, jc);
        ((BaseNodesPanel)nodesPanel).refreshComponents();
        title = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"ConstComponent.GraphDialog.Nodes.txt", (String)"Nodes");
        node.createChild((Object)title).setPanel((Component)nodesPanel);
        this.linksPanel = new LinksPanel(pi, jc);
        this.linksPanel.refreshComponents();
        title = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"ConstComponent.GraphDialog.Links.txt", (String)"Links");
        node.createChild((Object)title).setPanel((Component)this.linksPanel);
        title = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"ConstComponent.GraphDialog.Title_Footnote.txt", (String)"Title/Footnote");
        TitlePanel titlePanel = new TitlePanel((PropertyInterface)pi, jc);
        ((GraphPropertiesDialog)this.ccdlg).addRootNode((Object)title, (Component)titlePanel);
    }

    public void createDataDialog() {
        if (this.dataDlg != null) {
            return;
        }
        this.dataDlg = new DataOptionsDialog(this.parentFrame);
        this.dataDlg.addChart((RoleInterface)this);
    }

    public void ShowDataOptionsDialog() {
        if (this.dataDlg == null) {
            return;
        }
        this.dataDlg.setVisible(true);
    }

    public boolean setDefaultNodeSize(double size) {
        if (size <= 1.0) {
            this.chart.setDefaultNodeSize(size);
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (this.parentFrame == null) {
            Container con;
            for (con = this.getParent(); con != null && !(con instanceof Frame); con = con.getParent()) {
            }
            if (con != null && con instanceof Frame) {
                this.parentFrame = (Frame)con;
            }
        }
        if (command.equals("grphOptions")) {
            if (this.ccdlg == null) {
                this.createGraphDialog();
            }
            this.ShowGraphOptionsDialog();
        } else if (command.equals("dataOptions")) {
            if (null == this.dataDlg) {
                this.createDataDialog();
            }
            this.ShowDataOptionsDialog();
        } else if (command.equals("toolbar")) {
            if (this.toolbar == null) {
                this.toolbar = new SILKToolbar(this.parentFrame);
                ((SILKToolbar)this.toolbar).setTitle(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"ConstComponent.ConstellationChartToolbar.txt", (String)"Constellation Chart Toolbar"));
                ((SILKToolbar)this.toolbar).addListener((GraphInterface)this);
            }
            if (this.toolbar != null) {
                this.toolbar.setVisible(true);
            }
        } else if (command.equalsIgnoreCase("copyToClipboard")) {
            CopyToClipboard.toClipboard((JComponent)this);
        } else if (command.equalsIgnoreCase("ACTION_MODE_BRUSH")) {
            this.setActionMode(1);
        } else if (command.equalsIgnoreCase("ACTION_MODE_SELECT")) {
            this.setActionMode(6);
        } else if (command.equalsIgnoreCase("ACTION_MODE_ZOOM")) {
            this.setActionMode(3);
        } else if (command.equalsIgnoreCase("ACTION_MODE_PAN")) {
            this.setActionMode(4);
        } else if (command.equalsIgnoreCase("ACTION_MODE_VIEWPORT")) {
            this.setActionMode(2);
        } else if (command.equalsIgnoreCase("ACTION_MODE_RESET")) {
            this.setActionMode(5);
        } else if (command.equalsIgnoreCase("ACTION_MODE_MOVE")) {
            this.setActionMode(7);
        } else if (command.equalsIgnoreCase("saveAsXML")) {
            Hashtable<String, Boolean> context = new Hashtable<String, Boolean>();
            context.put("SAVE_VIEW_STATE", new Boolean(true));
            SILKParser.saveAsXML((Object)this, context, (boolean)true);
        }
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent evt) {
        this.chart.itemStateChanged(evt);
    }

    private void initViewerMenuItems(JMenu p) {
        if (p == null) {
            return;
        }
        this.chart.setNodeOptMenu(p);
        for (int i = 0; i < p.getMenuComponentCount(); ++i) {
            Component c = p.getMenuComponent(i);
            JMenuItem mi = null;
            if (c instanceof JMenuItem) {
                mi = (JMenuItem)c;
            }
            if (mi == null) continue;
            this.chart.setMenuItems(mi);
        }
    }

    private void setActionMenuItemStatus(JMenu actionMenu) {
        if (actionMenu == null || !actionMenu.isEnabled()) {
            return;
        }
        switch (this.chart.getActionMode()) {
            case 5: {
                break;
            }
            case 7: {
                MenuUtilities.setMenuItemSelected((JMenu)actionMenu, (String)"ACTION_MODE_MOVE", (boolean)true);
                break;
            }
            case 4: {
                MenuUtilities.setMenuItemSelected((JMenu)actionMenu, (String)"ACTION_MODE_PAN", (boolean)true);
                break;
            }
            case 2: {
                MenuUtilities.setMenuItemSelected((JMenu)actionMenu, (String)"ACTION_MODE_VIEWPORT", (boolean)true);
                break;
            }
            case 3: {
                MenuUtilities.setMenuItemSelected((JMenu)actionMenu, (String)"ACTION_MODE_ZOOM", (boolean)true);
                break;
            }
            default: {
                MenuUtilities.setMenuItemSelected((JMenu)actionMenu, (String)"ACTION_MODE_BRUSH", (boolean)true);
            }
        }
    }

    @Override
    public JPopupMenu getDefaultPopupMenu() {
        JMenuItem superSet;
        JMenuItem subSet;
        JMenuItem selAllConNode;
        JPopupMenu p = this.chart.getDefaultPopupMenu(this);
        this.popup = new JPopupMenu();
        if (this.grphOptions == null) {
            this.grphOptions = new JMenuItem(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"ConstComponent.Popup.GraphProperties.txt", (String)"Graph Properties..."));
            this.grphOptions.setActionCommand("grphOptions");
            this.grphOptions.addActionListener(this);
        }
        this.popup.add(this.grphOptions);
        JMenu actionMenu = MenuUtilities.getMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/ConstComponentActionMenu.xml"), (ActionListener)this);
        actionMenu.setEnabled(!this.chart.isAnimating());
        this.setActionMenuItemStatus(actionMenu);
        this.popup.add(actionMenu);
        this.chart.setActionMenu(actionMenu);
        this.popup.addSeparator();
        if (this.dataOptions == null) {
            this.dataOptions = new JMenuItem(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"ConstComponent.Popup.DataOptions.txt", (String)"Data Options..."));
            this.dataOptions.setActionCommand("dataOptions");
            this.dataOptions.addActionListener(this);
        }
        this.popup.add(this.dataOptions);
        this.popup.addSeparator();
        JMenuItem copyToClipboard = new JMenuItem(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"ConstComponent.Popup.Copy.txt", (String)"Copy"));
        copyToClipboard.setActionCommand("copyToClipboard");
        copyToClipboard.addActionListener(this);
        this.popup.add(copyToClipboard);
        this.popup.addSeparator();
        if (SILKGlobal.isTestMode()) {
            ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.menus.silk_menus_NLS");
            JMenuItem saveAsXML = new JMenuItem(ResourceLoader.getResourceString((Object)rb, (String)"Popup.Save_As_XML.txt", (String)"Save As XML..."));
            saveAsXML.setActionCommand("saveAsXML");
            saveAsXML.addActionListener(this);
            this.popup.add(saveAsXML);
            this.popup.addSeparator();
        }
        String helpString = this.chart.GRS("PopupMenu.Help.txt", "Help");
        String resetViewString = this.chart.GRS("PopupMenu.DWG.ResetView.txt", "Reset View");
        String resetModelString = this.chart.GRS("PopupMenu.DWG.ResetModel.txt", "Reset Model");
        String selectString = this.chart.GRS("PopupMenu.DWG.Select.txt", "Select...");
        String selectAllString = this.chart.GRS("PopupMenu.DWG.SelectAll.txt", "Select All");
        String animateLayoutString = this.chart.GRS("PopupMenu.CS.Animate.txt", "Animate Layout");
        String showAllLinksString = this.chart.GRS("PopupMenu.CS.all.txt", "Show all links");
        String showIntoLinksString = this.chart.GRS("PopupMenu.CS.into.txt", "Show links into selection");
        String showOutofLinksString = this.chart.GRS("PopupMenu.CS.outof.txt", "Show links out of selection");
        String showAmongLinksString = this.chart.GRS("PopupMenu.CS.among.txt", "Show links among selection");
        String selectLinksString = this.chart.GRS("PopupMenu.SelectLinks.txt", "Select Links");
        boolean removeSep = false;
        for (int i = 0; i < p.getComponents().length; ++i) {
            Component c = p.getComponent(i);
            JMenuItem mi = null;
            JMenu m = null;
            if (c instanceof JMenu) {
                m = (JMenu)c;
            } else if (c instanceof JMenuItem) {
                mi = (JMenuItem)c;
            } else if (c instanceof JSeparator && removeSep) continue;
            if (m != null && m.getText().equalsIgnoreCase(helpString) || mi != null && mi.getText().equalsIgnoreCase(resetViewString)) continue;
            if (mi != null && mi.getText().equalsIgnoreCase(animateLayoutString)) {
                removeSep = true;
            }
            if (mi != null && mi.getText().equalsIgnoreCase(resetModelString) || mi != null && mi.getText().equalsIgnoreCase(selectAllString) || mi != null && mi.getText().equalsIgnoreCase(selectString) || mi != null && mi.getText().equalsIgnoreCase(showAllLinksString) || mi != null && mi.getText().equalsIgnoreCase(showIntoLinksString) || mi != null && mi.getText().equalsIgnoreCase(showOutofLinksString) || mi != null && mi.getText().equalsIgnoreCase(showAmongLinksString) || mi != null && mi.getText().equalsIgnoreCase(selectLinksString)) continue;
            this.popup.add(c);
            --i;
        }
        JMenu subNodeOptMenu = MenuUtilities.getMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/ConstComponentNodeOptMenu.xml"), (ActionListener)this);
        JMenuItem selConNode = MenuUtilities.getMenuItem((JMenu)subNodeOptMenu, (String)"NLD_SEL_CON_NODES");
        if (selConNode != null) {
            selConNode.addActionListener((ActionListener)((Object)this.chart));
        }
        if ((selAllConNode = MenuUtilities.getMenuItem((JMenu)subNodeOptMenu, (String)"NLD_SEL_ALL_CON_NODES")) != null) {
            selAllConNode.addActionListener((ActionListener)((Object)this.chart));
        }
        if ((subSet = MenuUtilities.getMenuItem((JMenu)subNodeOptMenu, (String)"NLD_SUBSET")) != null) {
            subSet.addActionListener((ActionListener)((Object)this.chart));
        }
        if ((superSet = MenuUtilities.getMenuItem((JMenu)subNodeOptMenu, (String)"NLD_RESET")) != null) {
            superSet.addActionListener((ActionListener)((Object)this.chart));
        }
        this.initViewerMenuItems(subNodeOptMenu);
        this.popup.add(subNodeOptMenu);
        return this.popup;
    }

    @Override
    public void reset() {
        this.chart.reset();
    }

    @Override
    public void setSelected(Object o, boolean state, boolean update) {
        this.chart.setSelected(o, state);
    }

    @Override
    public Object pick(int x, int y) {
        return this.chart.pick(x, y);
    }

    @Override
    public void load() {
        if (this.getVariable(1, "ID") != null && this.getVariable(1, "From") != null && this.getVariable(1, "To") != null) {
            this.chart.load();
            this.chartLoaded = true;
        } else {
            this.chartLoaded = false;
        }
    }

    public void setDatasetType(String type) {
        this.chart.setDatasetType(type);
    }

    public String getDatasetType() {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getDatasetType();
    }

    public void stop() {
        this.chart.stop();
    }

    public boolean setDataModel(NLDModel newModel) {
        return false;
    }

    @Override
    public void resetView(boolean build) {
        this.chart.resetView(build);
    }

    public void resetView() {
        this.chart.resetView();
    }

    @Override
    public void setUserLayout(boolean flag) {
        boolean userLayout;
        this.isLastLayoutUser = userLayout = flag && this.isUserLayoutAllowed();
        this.chart.setUserLayout(userLayout);
    }

    @Override
    public void setLabels(boolean val) {
        this.chart.setLabels(val);
    }

    public void setLabels(int mode) {
        this.chart.setLabels(mode);
    }

    public boolean areLabelsShown() {
        return this.chart.areLabelsShown();
    }

    @Override
    public void setTooltipsMode(String mode) {
        this.chart.setTooltipsMode(mode);
    }

    public boolean getUsageMode(int mode) {
        return false;
    }

    public Object getId() {
        return this.chart.getId();
    }

    public void setId(Object id) {
        this.chart.setId(id);
    }

    public void setUsageMode(int mode, boolean on) {
    }

    public void addDrilldownListener(DrilldownListenerInterface dli) {
    }

    public void removeDrilldownListener(DrilldownListenerInterface dli) {
    }

    public void enablePopup(boolean flag) {
        this.showPopup = flag;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = this.getDefaultPopupMenu();
        }
        return this.popup;
    }

    public Object getLegendPosition(Object which) {
        return null;
    }

    public boolean setLegendPosition(Object which, Object positionIn) {
        return false;
    }

    public Rectangle getLegendBounds() {
        return null;
    }

    public boolean setLegendBounds(Rectangle bounds) {
        return false;
    }

    public boolean setTitle(String text) {
        return this.setTitle(0, text);
    }

    public boolean setTitle(int index, String text) {
        return this.titles.setTitle(index, text);
    }

    public boolean setTitle(int index, TextStyleInterface textObj) {
        return this.titles.setTitle(index, textObj);
    }

    public boolean setFootnote(String text) {
        return this.footnotes.setFootnote(0, text);
    }

    public boolean setFootnote(int index, String text) {
        return this.setFootnote(text);
    }

    public boolean setFootnote(int index, TextStyleInterface textObj) {
        return this.footnotes.setFootnote(index, textObj);
    }

    public TextStyleInterface getTitle(int index) {
        return this.titles.getTitle(index);
    }

    public TextStyleInterface getFootnote(int index) {
        return this.footnotes.getFootnote(index);
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        Object filter = null;
        if (this.linkFilter != null) {
            this.linkFilter.removeDataFilterListener(this.linkSource);
            this.linkFilter.applyWhereClause(clause, clearPrevious);
            this.linkFilter.addDataFilterListener(this.linkSource);
        }
        if (this.nodeFilter != null) {
            this.nodeFilter.removeDataFilterListener(this.nodeSource);
            this.nodeFilter.applyWhereClause(clause, clearPrevious);
            this.nodeFilter.addDataFilterListener(this.nodeSource);
        }
        return true;
    }

    public String getWhereClause() {
        switch (this.activeModelMode) {
            case 1: {
                return this.getWhereClause(1);
            }
        }
        return this.getWhereClause(0);
    }

    public String getWhereClause(int modelType) {
        DataFilterReadInterface filter = null;
        switch (modelType) {
            case 0: {
                filter = this.nodeFilter;
                break;
            }
            case 1: {
                filter = this.linkFilter;
            }
        }
        return filter == null ? null : filter.getWhereClause();
    }

    public Component getToolBar() {
        if (this.toolbar == null) {
            this.toolbar = new SILKToolbar(this.parentFrame);
            ((SILKToolbar)this.toolbar).setTitle(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"ConstComponent.ConstellationChartToolbar.txt", (String)"Constellation Chart Toolbar"));
            ((SILKToolbar)this.toolbar).addListener((GraphInterface)this);
        }
        return this.toolbar;
    }

    public boolean setToolBar(Component d) {
        this.toolbar = d;
        if (this.toolbar != null) {
            if (this.toolbar instanceof GraphToolbarInterface) {
                ((GraphToolbarInterface)this.toolbar).addListener((GraphInterface)this);
                this.toolbarMenuItemVisible = true;
            }
        } else {
            this.toolbarMenuItemVisible = false;
            if (this.actionToolbar != null && this.popup != null) {
                this.popup.remove(this.actionToolbar);
            }
        }
        return true;
    }

    public int getActionMode() {
        if (this.chart != null) {
            return this.chart.getActionMode();
        }
        return -1;
    }

    public boolean setActionMode(int mode) {
        return this.chart.setActionMode(mode);
    }

    public String getStyle() {
        return this.style.getSchemeName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setStyle(Object newStyle) {
        if (newStyle == null) {
            this.style = null;
        } else if (newStyle instanceof ColorScheme) {
            this.style = ((ColorScheme)newStyle).getStyle();
        } else if (newStyle instanceof Style) {
            this.style = (Style)newStyle;
        } else {
            if (!(newStyle instanceof String)) return false;
            StyleCollection sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48);
            if (sc.getStyle((String)newStyle) == null) return false;
            this.style = sc.getStyle((String)newStyle);
        }
        if (this.style == null) {
            return false;
        }
        this.setColors();
        this.background.setSolidBackground((Object)this.style.getFillStyleElement("WallFill").getFillColor());
        return true;
    }

    public void setChartTipsOn(boolean flag) {
        this.chart.setChartTipsOn(flag);
    }

    public boolean areChartTipsOn() {
        return this.chart.areChartTipsOn();
    }

    public TipInterface getChartTip() {
        return null;
    }

    public ColorSchemeInterface getColorScheme() {
        return this.clrScheme;
    }

    public String getColorSchemeName() {
        if (this.clrScheme == null) {
            return null;
        }
        return this.clrScheme.getSchemeName();
    }

    public boolean setColorScheme(Object newScheme) {
        return this.setStyle(newScheme);
    }

    public void setColors() {
        Color[] linkColors = this.style.getDataLineColors();
        Color lc = this.style.getLineStyleElement("GraphDataStyleDefault").getLineColor();
        Color[] nodeColors = linkColors;
        Color nc = this.style.getDataStyleElement("GraphDataStyleDefault").getFillColor();
        this.chart.setTextColor(this.style.getTextStyleElement("LabelText").getTextColor());
        this.chart.setBackColor(this.style.getFillStyleElement("WallFill").getFillColor());
        this.background.setSolidBackground((Object)this.style.getFillStyleElement("WallFill").getFillColor());
        this.chart.setSelectColor(this.style.getLineStyleElement("Selection").getLineColor());
        this.chart.setLinkErrorColor(this.style.getLineStyleElement("Missing").getLineColor());
        this.chart.setNodeErrorColor(this.style.getFillStyleElement("Missing").getFillColor());
        if (!this.isColorMappingLinks()) {
            this.chart.setLinkColor(lc, true);
        } else {
            this.chart.setLinkColor(lc);
        }
        if (!this.isColorMappingNodes()) {
            this.chart.setNodeColor(nc, true);
        } else {
            this.chart.setNodeColor(nc);
        }
        this.breakpoints[0] = new Double(0.0);
        this.breakpoints[1] = new Double(0.5);
        this.breakpoints[2] = new Double(1.0);
        this.colors[0] = nodeColors[0];
        this.colors[1] = nodeColors[1];
        this.colors[2] = nodeColors[2];
        Color[] rampStyleClr = this.style.getRampStyleElement("ThreeColorAltRamp").getColors();
        for (int i = 0; i < rampStyleClr.length; ++i) {
            this.colors[i] = rampStyleClr[i];
        }
        this.flags = 0L;
        this.clrRamp = new ColorRamp((Object)this.colors, (Object)this.breakpoints, this.flags);
        this.chart.setColorRamp(this.clrRamp);
    }

    public DataFilterReadInterface getFilter() {
        if (this.model instanceof DataFilterModel) {
            return this.getFilter(this.model.getModelMode());
        }
        return null;
    }

    public DataFilterReadInterface getFilter(Object id) {
        if (this.model instanceof DataFilterModel) {
            if ("Nodes".equals(id)) {
                return this.getFilter(0);
            }
            if ("Links".equals(id)) {
                return this.getFilter(1);
            }
            return null;
        }
        return null;
    }

    public DataFilterReadInterface getFilter(int modelType) {
        if (modelType == 1) {
            return this.linkFilter;
        }
        if (modelType == 0) {
            return this.nodeFilter;
        }
        return null;
    }

    public AxisInterface getAxis(Object whichAxis) {
        return null;
    }

    public boolean setExternalAxis(Object which, AxisInterface axis) {
        return false;
    }

    public LegendInterface getLegend(Object which) {
        return null;
    }

    public void dispose() {
        JMenuItem superSet;
        JMenuItem subSet;
        JMenuItem selAllConNode;
        JMenu subNodeOptMenu;
        JMenuItem selConNode;
        this.removeAll();
        if (this.roleManager != null) {
            this.roleManager.removeRoleListener((RoleListenerInterface)this);
        }
        this.roleManager = null;
        this.gp = null;
        this.backImage = null;
        this.gpBackImage = null;
        this.scaledBackImage = null;
        if (this.chart != null) {
            this.chart.removeMouseListener(this);
            this.chart.dispose();
        }
        if ((selConNode = MenuUtilities.getMenuItem((JMenu)(subNodeOptMenu = MenuUtilities.getMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/ConstComponentNodeOptMenu.xml"), (ActionListener)this)), (String)"NLD_SEL_CON_NODES")) != null) {
            selConNode.removeActionListener((ActionListener)((Object)this.chart));
        }
        if ((selAllConNode = MenuUtilities.getMenuItem((JMenu)subNodeOptMenu, (String)"NLD_SEL_ALL_CON_NODES")) != null) {
            selAllConNode.removeActionListener((ActionListener)((Object)this.chart));
        }
        if ((subSet = MenuUtilities.getMenuItem((JMenu)subNodeOptMenu, (String)"NLD_SUBSET")) != null) {
            subSet.removeActionListener((ActionListener)((Object)this.chart));
        }
        if ((superSet = MenuUtilities.getMenuItem((JMenu)subNodeOptMenu, (String)"NLD_RESET")) != null) {
            superSet.removeActionListener((ActionListener)((Object)this.chart));
        }
        this.chart = null;
        if (this.model != null) {
            this.model.dispose();
        }
        this.model = null;
        if (this.linkFilter != null) {
            this.linkFilter.removeDataFilterListener(this.linkSource);
            FilterFactory.detachFilter((DataFilterReadInterface)this.linkFilter);
            this.linkFilter = null;
            this.linkSource = null;
        }
        if (this.nodeFilter != null) {
            this.nodeFilter.removeDataFilterListener(this.nodeSource);
            FilterFactory.detachFilter((DataFilterReadInterface)this.nodeFilter);
            this.nodeFilter = null;
            this.nodeSource = null;
        }
        this.breakpoints = null;
        this.colors = null;
        this.clrRamp = null;
        this.popup = null;
        this.moveOpen = null;
        this.moveClosed = null;
        this.zoomCursor = null;
        this.viewportCursor = null;
        if (this.ccdlg != null) {
            this.ccdlg.setVisible(false);
            this.ccdlg.dispose();
        }
        this.ccdlg = null;
        if (this.dataDlg != null) {
            this.dataDlg.setVisible(false);
            this.dataDlg.dispose();
        }
        this.dataDlg = null;
        if (this.toolbar != null) {
            this.toolbar.setVisible(false);
            if (this.toolbar instanceof GraphToolbarInterface) {
                ((GraphToolbarInterface)this.toolbar).removeAllListeners();
            }
        }
        this.toolbar = null;
        this.clrScheme = null;
        this.resourceBundle = null;
        this.properties = null;
        this.background = null;
        if (this.titles != null) {
            this.titles.removeTextListener((TextListenerInterface)this);
        }
        if (this.footnotes != null) {
            this.footnotes.removeTextListener((TextListenerInterface)this);
        }
        this.titles = null;
        this.footnotes = null;
        SILKGlobal.unregister((PropertyInterface)this);
    }

    public Dialog getDialog(Object id, Object listener) {
        if (id instanceof String) {
            String ID = (String)id;
            if (ID.equalsIgnoreCase("Properties")) {
                if (this.ccdlg == null) {
                    this.createGraphDialog(listener);
                }
                return this.ccdlg;
            }
            if (ID.equalsIgnoreCase("Data")) {
                if (null == this.dataDlg) {
                    this.createDataDialog();
                }
                return this.dataDlg;
            }
        }
        return null;
    }

    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        if (dialogIn == null) {
            return false;
        }
        if (id instanceof String) {
            String ID = (String)id;
            if (ID.equalsIgnoreCase("Properties")) {
                this.ccdlg = dialogIn;
                return true;
            }
            if (ID.equalsIgnoreCase("Data") && dialogIn instanceof DataOptionsDialog) {
                this.dataDlg = (DataOptionsDialog)dialogIn;
                return true;
            }
        }
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    public int getSelectionBehavior() {
        return -1;
    }

    public Object getSelectionBehaviorValue() {
        return null;
    }

    public boolean setSelectionBehavior(int behavior, Object value) {
        return false;
    }

    public void addViewportListener(Object listener) {
    }

    public void removeViewportListener(Object listener) {
    }

    public AnnotateInterface getAnnotate() {
        return null;
    }

    @Override
    public void setHelpLocation(String param) {
        this.chart.setHelpLocation(param);
    }

    @Override
    public void setURLTarget(String param) {
        this.chart.setURLTarget(param);
    }

    @Override
    public void setTextColor(Object c) {
        this.chart.setTextColor(c);
    }

    @Override
    public void setSelectColor(Object col) {
        this.chart.setSelectColor(col);
    }

    @Override
    public void setBackColor(Object col) {
        this.chart.setBackColor(col);
        this.background.setSolidBackground((Object)this.chart.getBackColor());
    }

    public Color getBackColor() {
        return this.chart.getBackColor();
    }

    @Override
    public void setBackImage(Object im) {
        this.chart.setBackImage(im);
    }

    @Override
    public void setImageURL(String param) {
        this.chart.setImageURL(param);
    }

    @Override
    public void setDrawImage(String param) {
        this.setDrawImage(param);
    }

    @Override
    public String getDrawImage() {
        return this.chart.getDrawImage();
    }

    @Override
    public void setImagePosition(Point loc) {
        this.chart.setImagePosition(loc);
    }

    @Override
    public void setHeight(int val) {
        this.chart.setComponentSize(this.chart.getWidth(), val);
    }

    @Override
    public void setWidth(int val) {
        this.chart.setComponentSize(val, this.chart.getHeight());
    }

    @Override
    public void setNodeColor(Object param) {
        this.chart.setNodeColor(param);
    }

    @Override
    public Color getNodeColor() {
        return this.chart.getNodeColor();
    }

    @Override
    public void setLinkColor(Object param) {
        this.chart.setLinkColor(param);
    }

    public Color getLinkColor() {
        return this.chart.getLinkColor();
    }

    @Override
    public String getTextBorderType() {
        return this.chart.getTextBorderType();
    }

    @Override
    public String getNodeBorderType() {
        return this.chart.getNodeBorderType();
    }

    @Override
    public void setNodeBorderType(String param) {
        this.chart.setNodeBorderType(param);
    }

    @Override
    public void setTextBorderType(String param) {
        this.chart.setTextBorderType(param);
    }

    @Override
    public void setFontName(String param) {
        this.chart.setFontName(param);
    }

    @Override
    public void setFontSize(int val) {
        this.chart.setFontSize(val);
    }

    @Override
    public void setFontStyle(int val) {
        this.chart.setFontStyle(val);
    }

    @Override
    public Font getFont() {
        if (this.chart != null) {
            return this.chart.getFont();
        }
        return super.getFont();
    }

    @Override
    public void setTooltips(boolean flag) {
        this.chart.setTooltips(flag);
    }

    public void setNodeSize(double size) {
        this.chart.setNodeSize(size);
    }

    public double getNodeSize() {
        return this.chart.getNodeSize();
    }

    public void setLinkWidth(Object width) {
        this.chart.setLinkWidth(width);
    }

    public int getLinkWidth() {
        return this.chart.getLinkWidth();
    }

    @Override
    public void setColorMapping(boolean flag) {
        this.chart.setColorMapping(flag);
    }

    public void setColorMappingLinks(boolean flag) {
        this.chart.setColorMappingLinks(flag);
    }

    public void setColorMappingNodes(boolean flag) {
        this.chart.setColorMappingNodes(flag);
    }

    public boolean isColorMappingLinks() {
        return this.chart.isColorMappingLinks();
    }

    public boolean isColorMappingNodes() {
        return this.chart.isColorMappingNodes();
    }

    public boolean isSizeMappingNodes() {
        return this.chart.isSizeMappingNodes();
    }

    public void setSizeMappingNodes(boolean flag) {
        this.chart.setSizeMappingNodes(flag);
    }

    public boolean isWidthMappingLinks() {
        return this.chart.isWidthMappingLinks();
    }

    public void setWidthMappingLinks(boolean flag) {
        this.chart.setWidthMappingLinks(flag);
    }

    public boolean isShapeMappingNodesAllowed() {
        return this.getVariable(0, "Shape") != null;
    }

    public boolean isColorMappingNodesAllowed() {
        return this.getVariable(0, "Color") != null;
    }

    public boolean isColorMappingLinksAllowed() {
        return this.getVariable(1, "Color") != null;
    }

    public boolean isValueMappingLinks() {
        Object variable = this.getVariable(1, "Value");
        if (variable == null) {
            return false;
        }
        return !this.chart.getDatasetType().equalsIgnoreCase("arcs");
    }

    @Override
    public void setRBSizing(boolean flag) {
        this.chart.setRBSizing(flag);
    }

    @Override
    public void setDuplicateCheck(boolean flag) {
        this.model.setDuplicateCheck(flag);
    }

    @Override
    public void setAppletStub(AppletStub appletStub) {
        this.chart.setAppletStub(appletStub);
    }

    @Override
    public void setLens(boolean flag) {
        this.chart.setLens(flag);
    }

    @Override
    public void setFan(boolean flag) {
        this.chart.setFan(flag);
    }

    @Override
    public void setSpreadFactor(double fac) {
        this.chart.setSpreadFactor(fac);
    }

    @Override
    public void setCutoffFactor(double fac) {
        this.chart.setCutoffFactor(fac);
    }

    @Override
    public void setLensFactor(double fac) {
        this.chart.setLensFactor(fac);
    }

    @Override
    public void setHandleColor(Object c) {
        this.chart.setHandleColor(c);
    }

    @Override
    public void setSelected(Object id, boolean state) {
        this.chart.setSelected(id, state);
    }

    public boolean isSelected(Object id) {
        return this.chart.isSelected(id);
    }

    public double[] project(double x, double y, double[] out) {
        return this.chart.project(x, y, out);
    }

    public double[] project(double x, double y, double z, double[] out) {
        return this.chart.project(x, y, z, out);
    }

    public double[] unProject(double pixelX, double pixelY, double[] out) {
        return this.chart.unProject(pixelX, pixelY, out);
    }

    public double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
        return this.chart.unProject(pixelX, pixelY, pixelZ, out);
    }

    public boolean isReverse(int axis) {
        return false;
    }

    public void setReverse(int axis, boolean flag) {
    }

    @Override
    public void setXMLFile(String param) {
        this.model.setXMLFile(param);
    }

    @Override
    public void setXMLData(String param) {
        this.model.setXMLData(param);
    }

    @Override
    public boolean setDataSource(DataFilterReadInterface n, DataFilterReadInterface l) {
        if (this.model instanceof DataFilterModel) {
            boolean retVal = this.setSource(0, n);
            retVal = this.setSource(1, l) && retVal;
            return retVal;
        }
        return false;
    }

    public boolean setDataSource(int modelType, Object source) {
        Object filter = null;
        if (source == null) {
            return false;
        }
        return this.setSource(modelType, source);
    }

    @Override
    public boolean setDataSource(int modelType, DataFilterReadInterface source) {
        if (this.model instanceof DataFilterModel) {
            return this.setSource(modelType, source);
        }
        return false;
    }

    @Override
    public boolean setRole(int modelType, String variable, String role) {
        if (variable == null || role == null) {
            return false;
        }
        if (modelType == 0) {
            return this.setRole(variable, new Integer(this.model.getRoleInt(0, role)));
        }
        if (modelType == 1) {
            return this.setRole(variable, new Integer(this.model.getRoleInt(1, role)));
        }
        return false;
    }

    private boolean isUserLayoutAllowed() {
        Object variableX = this.getVariable(0, "X");
        Object variableY = this.getVariable(0, "Y");
        return variableX != null && variableY != null;
    }

    private boolean isMappingAllowed(int modelType, String role) {
        Object variable = this.getVariable(modelType, role);
        if (variable == null) {
            variable = this.getVariable(modelType, "Value");
        }
        if (variable == null) {
            return false;
        }
        if (modelType == 0 && !this.chart.getDatasetType().equalsIgnoreCase("assoc")) {
            return false;
        }
        return modelType != 1 || this.chart.getDatasetType().equalsIgnoreCase("assoc") || !role.equalsIgnoreCase("Width");
    }

    public boolean assignRole(int modelType, String variable, String role) {
        if (modelType == 0) {
            return this.assignNodeModelRole(variable, role);
        }
        if (modelType == 1) {
            return this.assignLinkModelRole(variable, role);
        }
        return false;
    }

    public boolean assignNodeModelRole(String variable, String role) {
        DataFilterNodeModel nodes = null;
        if (this.model instanceof DataFilterModel) {
            nodes = (DataFilterNodeModel)this.model.nodes;
        }
        if (nodes != null) {
            int roleIndex = nodes.getPropertyIndex(role);
            if (roleIndex < 0 || roleIndex > nodes.getNumberInputRoles()) {
                return false;
            }
            nodes.setRole(variable, role);
            nodes.setNodeValues(nodes.getVariable(roleIndex), roleIndex);
            this.chart.rebuild();
            return true;
        }
        return false;
    }

    public boolean assignLinkModelRole(String variable, String role) {
        DataFilterLinkModel links = null;
        if (this.model instanceof DataFilterModel) {
            links = (DataFilterLinkModel)this.model.links;
        }
        if (links != null) {
            int roleIndex = links.getPropertyIndex(role);
            if (roleIndex < 0 || roleIndex > links.getNumberInputRoles()) {
                return false;
            }
            links.setRole(variable, role);
            links.setLinkValues(links.getVariable(roleIndex), roleIndex);
            this.chart.rebuild();
            return true;
        }
        return false;
    }

    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    @Override
    public Object getDataSource(int modelType) {
        if (this.model instanceof DataFilterModel) {
            return this.model.getDataSource(modelType);
        }
        return null;
    }

    public Object getAllVariables(Object role) {
        return this.roleManager.getAllVariables(role);
    }

    @Override
    public Object getVariable(int modelType, String role) {
        if (this.model instanceof DataFilterModel) {
            return this.model.getVariable(modelType, role);
        }
        return null;
    }

    @Override
    public Object getRole(int modelType, String variableId) {
        if (this.model instanceof DataFilterModel) {
            return this.model.getRole(modelType, variableId);
        }
        return null;
    }

    @Override
    public boolean isDiscrete(Object variableId) {
        return false;
    }

    @Override
    public boolean setDiscrete(Object variableId, boolean discrete) {
        return false;
    }

    @Override
    public Object getDataSource() {
        if (this.model instanceof DataFilterModel) {
            return this.model.getDataSource(1);
        }
        return null;
    }

    public Object getDataSource(Object id) {
        if (id == null || this.model == null) {
            return null;
        }
        if (id instanceof Number) {
            int modelType = ((Number)id).intValue();
            switch (modelType) {
                case 0: 
                case 1: {
                    return this.model.getDataSource(modelType);
                }
            }
        } else if (id instanceof String) {
            if (0 == id.toString().compareTo("Nodes")) {
                return this.model.getDataSource(0);
            }
            if (0 == id.toString().compareTo("Links")) {
                return this.model.getDataSource(1);
            }
        }
        return null;
    }

    @Override
    public boolean setDataSource(Object source) {
        return this.setSource(this.getModelMode(), source);
    }

    public boolean setDataSource(Object source, Object id) {
        if (source == null || id == null) {
            return false;
        }
        if (id instanceof Number) {
            int idx = ((Number)id).intValue();
            switch (idx) {
                case 0: 
                case 1: {
                    return this.setSource(idx, source);
                }
            }
        } else if ("Nodes".equalsIgnoreCase(id.toString())) {
            this.setSource(0, source);
        } else if ("Links".equalsIgnoreCase(id.toString())) {
            this.setSource(1, source);
        }
        return false;
    }

    @Override
    public Object getVariable(Object role) {
        if (role == null) {
            return null;
        }
        if (this.model instanceof DataFilterModel) {
            if (role instanceof SILKNumber) {
                return this.model.getVariable(role);
            }
            String rs = role.toString();
            if (rs.indexOf(46) >= 0) {
                String dsid = rs.substring(0, rs.indexOf(46));
                String r = rs.substring(rs.indexOf(46) + 1);
                if ("Nodes".equalsIgnoreCase(dsid)) {
                    return this.model.getVariable(0, r);
                }
                return this.model.getVariable(1, r);
            }
            return this.model.getVariable(1, rs);
        }
        return null;
    }

    @Override
    public Object getRole(Object variableId) {
        return this.roleManager.getRole(variableId);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        return this.roleManager.setRole(variableId, role);
    }

    public Object getRoleValue(Object role, int which) {
        return this.roleManager.getRoleValue(role, which);
    }

    public boolean addRole(Object variableId, Object role) {
        return this.setRole(variableId, role);
    }

    public boolean removeRole(Object variableId, Object role) {
        return this.roleManager.removeRole(variableId, role);
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        Object[] retObj = this.roleManager.getSupportedRoles(id, discrete);
        if (!this.fixedShapeNoneSelected) {
            return retObj;
        }
        int nObj = retObj.length;
        Vector<Object> supportedObj = new Vector<Object>();
        for (int i = 0; i < nObj; ++i) {
            Object oneObj = retObj[i];
            if (oneObj instanceof Number && oneObj.equals(RoleInterface.ROLE_NODE_SIZE)) continue;
            supportedObj.add(oneObj);
        }
        Object[] retObjsArr = new Object[supportedObj.size()];
        supportedObj.copyInto(retObjsArr);
        return retObjsArr;
    }

    public int getMaxAllowed(Object role) {
        return 1;
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public Object getSortOrder(Object variableId) {
        return null;
    }

    public boolean setSortOrder(Object variableId, Object order) {
        return false;
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public Object[] getDataIds() {
        return new String[]{"Nodes", "Links"};
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public Object[][] getSupportedSortableRoles() {
        if (this.roleManager == null) {
            return null;
        }
        return this.roleManager.getSupportedSortableRoles();
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    @Override
    public boolean setModelMode(int newMode) {
        if (this.model instanceof DataFilterModel) {
            return this.model.setModelMode(newMode);
        }
        return false;
    }

    @Override
    public int getModelMode() {
        if (this.model instanceof DataFilterModel) {
            return this.model.getModelMode();
        }
        return -1;
    }

    @Override
    public Object pickID(int x, int y) {
        return this.chart.pickID(x, y);
    }

    public void printComponent() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf = job.pageDialog(job.defaultPage());
        job.setPrintable(this, pf);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip toolTip = new JToolTip();
        toolTip.setBackground(new Color(242, 242, 223));
        Color fcolor = Color.black;
        toolTip.setForeground(fcolor);
        toolTip.setBorder(new LineBorder(fcolor, 1));
        return toolTip;
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        this.chart.pick(x, y);
        String toolTipText = this.chart.getTooltipText(evt);
        return toolTipText;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        double width = Math.min(pageFormat.getImageableWidth(), (double)this.silkDefaults.maxPrintableResolutionX);
        double height = Math.min(pageFormat.getImageableHeight(), (double)this.silkDefaults.maxPrintableResolutionY);
        int cW = this.chart.getComponentWidth();
        int cH = this.chart.getComponentHeight();
        double s_aspect = (double)cW / (double)cH;
        double p_aspect = width / height;
        if (p_aspect <= 1.0) {
            if (s_aspect < 1.0 && s_aspect < p_aspect) {
                width = height * s_aspect;
            } else {
                height = width / s_aspect;
            }
        } else if (s_aspect > 1.0 && s_aspect > p_aspect) {
            height = width / s_aspect;
        } else {
            width = height * s_aspect;
        }
        int xTrans = (int)Math.max((pageFormat.getImageableWidth() - width) / 2.0, 0.0);
        int yTrans = (int)Math.max((pageFormat.getImageableHeight() - height) / 2.0, 0.0);
        g2.translate(pageFormat.getImageableX() + (double)xTrans, pageFormat.getImageableY() + (double)yTrans);
        if (!this.chart.isUserLayout()) {
            this.chart.setComponentSize((int)width, (int)height);
        }
        this.chart.setRebuildRequired(true);
        this.chart.build();
        boolean drawBrush = this.chart.isBrushDrawn();
        this.chart.setDrawBrush(false);
        this.chart.paint(graphics);
        this.chart.setDrawBrush(drawBrush);
        g2.translate(-(pageFormat.getImageableX() + (double)xTrans), -(pageFormat.getImageableY() + (double)yTrans));
        this.chart.setComponentSize(cW, cH);
        this.chart.setRebuildRequired(true);
        this.chart.build();
        return 0;
    }

    public int numPages(PageFormat pf) {
        return 1;
    }

    public int numPagesX(PageFormat pf) {
        return 1;
    }

    public int numPagesY(PageFormat pf) {
        return 1;
    }

    @Override
    public void showDirectionArrow(boolean flag) {
        this.chart.showArrows(flag);
    }

    public boolean areDirectionArrowsShown() {
        return this.chart.areArrowsShown();
    }

    @Override
    public void setNodeShape(String shape) {
        this.fixedShapeNoneSelected = shape.equalsIgnoreCase("None");
        this.chart.setFixedShapeNoneSelected(this.fixedShapeNoneSelected);
        this.chart.setNodeShape(shape);
    }

    public String getNodeShape() {
        return this.chart.getNodeShape();
    }

    @Override
    public void setSupport(int val) {
        this.setSupport((double)val);
    }

    @Override
    public void setSupport(int val, boolean update) {
        this.setSupport((double)val, update);
    }

    public void setSupport(double val) {
        if (this.isMappingAllowed(1, "Value")) {
            this.chart.setSupport(val);
        } else {
            this.chart.setSupport(20.0);
        }
    }

    public void setSupport(double val, boolean update) {
        if (this.isMappingAllowed(1, "Value")) {
            this.chart.setSupport(val, update);
        } else {
            this.chart.setSupport(20.0);
        }
    }

    @Override
    public double getSupport() {
        return this.chart.getSupport();
    }

    @Override
    public void setLayout(String type) {
        this.chart.setLayout(type);
        if (this.chart.isUserLayout() && !this.isUserLayoutAllowed()) {
            this.chart.setUserLayout(false);
        }
        this.isLastLayoutUser = this.chart.isUserLayout();
    }

    public String getChartLayout() {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getChartLayout();
    }

    @Override
    public Object getSelectedNodesIds() {
        return this.chart.getSelectedNodesIds();
    }

    @Override
    public Object getSelectedNodesLabels() {
        return this.chart.getSelectedNodesLabels();
    }

    @Override
    public Object getSelectedNodesURLs() {
        return this.chart.getSelectedNodesURLs();
    }

    @Override
    public String getNodeSeparator() {
        return this.chart.getNodeSeparator();
    }

    @Override
    public void setNodeSeparator(String param) {
        this.chart.setNodeSeparator(param);
    }

    @Override
    public void setSelectIdFunction(String param) {
        this.chart.setSelectIdFunction(param);
    }

    @Override
    public void setSelectLabelFunction(String param) {
        this.chart.setSelectLabelFunction(param);
    }

    @Override
    public void setSelectURLFunction(String param) {
        this.chart.setSelectURLFunction(param);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.chart.setSize(width, height);
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        this.chart.setSize(d);
    }

    public Object[] getGraphBackground() {
        Object[] array = new Object[]{this.chart.getBackColor()};
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setImageBackground(Image img, Object fitStyle, int x, int y, double blend) {
        ConstComponent constComponent;
        int fit = this.imageFitStyle;
        int flags = 0;
        Image tmp = null;
        int compWidth = this.chart.getComponentWidth();
        int compHeight = this.chart.getComponentHeight();
        if (img == null) {
            this.backImage = null;
            this.scaledBackImage = null;
            ConstComponent constComponent2 = this;
            synchronized (constComponent2) {
                this.bufferUpdateRequired = true;
                return true;
            }
        }
        if (fitStyle != null) {
            if (fitStyle instanceof String) {
                if (((String)fitStyle).equalsIgnoreCase("Stretch") || ((String)fitStyle).equalsIgnoreCase("Stretch to fit")) {
                    fit = 0;
                } else if (((String)fitStyle).equalsIgnoreCase("Tile")) {
                    fit = 1;
                } else if (((String)fitStyle).equalsIgnoreCase("Center")) {
                    fit = 2;
                } else {
                    if (!((String)fitStyle).equalsIgnoreCase("Locate")) return false;
                    fit = 3;
                }
            } else if (fitStyle instanceof Number) {
                fit = ((Number)fitStyle).intValue();
            }
        }
        if (!Double.isNaN(blend) && !Double.isInfinite(blend)) {
            this.imageBlend = blend;
        }
        if (this.imageBlend < 0.0) {
            this.imageBlend = 0.0;
        } else if (this.imageBlend > 1.0) {
            this.imageBlend = 1.0;
        }
        switch (fit) {
            case 1: 
            case 2: 
            case 3: {
                this.backImage = img;
                this.scaledBackImage = null;
                this.imageFitStyle = fit;
                break;
            }
            case 0: {
                constComponent = this;
                synchronized (constComponent) {
                    this.imageFitStyle = fit;
                    this.backImage = img;
                    this.scaledBackImage = null;
                }
                tmp = img.getScaledInstance(compWidth, compHeight, 1);
                if (tmp == null || ((flags = super.checkImage(img, -1, -1, this)) & 0x20) == 0) break;
                this.scaledBackImage = tmp;
            }
        }
        this.chart.setBackImage(this.backImage);
        this.chart.setBackground(this.chart.getBackColor());
        this.background.setSolidBackground((Object)this.chart.getBackColor());
        constComponent = this;
        synchronized (constComponent) {
            this.bufferUpdateRequired = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setGradientBackground(Object startColor, Object endColor, Object orientation) {
        int y2;
        int y1;
        int x1;
        int x2;
        Color c2;
        Color c1;
        int orient = this.gradientOrientation;
        GradientPaint gpNew = null;
        Image img = null;
        Graphics2D g = null;
        int compWidth = this.chart.getComponentWidth();
        int compHeight = this.chart.getComponentHeight();
        if ((startColor == null || endColor == null) && this.gp == null) {
            return false;
        }
        if (startColor == null) {
            c1 = this.gp.getColor1();
        } else if (startColor instanceof Color) {
            c1 = (Color)startColor;
        } else {
            if (!(startColor instanceof String)) return false;
            c1 = NLD.decodeColor((String)((String)startColor));
            if (c1 == null) {
                return false;
            }
        }
        if (endColor == null) {
            c2 = this.gp.getColor2();
        } else if (endColor instanceof Color) {
            c2 = (Color)endColor;
        } else {
            if (!(endColor instanceof String)) return false;
            c2 = NLD.decodeColor((String)((String)endColor));
            if (c2 == null) {
                return false;
            }
        }
        if (orientation != null) {
            if (orientation instanceof String) {
                if (((String)orientation).equalsIgnoreCase("Left to right")) {
                    orient = 0;
                } else if (((String)orientation).equalsIgnoreCase("Right to left")) {
                    orient = 1;
                } else if (((String)orientation).equalsIgnoreCase("Top to bottom")) {
                    orient = 2;
                } else if (((String)orientation).equalsIgnoreCase("Bottom to top")) {
                    orient = 3;
                } else {
                    if (!((String)orientation).equalsIgnoreCase("Diagonal")) return false;
                    orient = 4;
                }
            } else {
                if (!(orientation instanceof Number)) return false;
                orient = ((Number)orientation).intValue();
            }
        }
        switch (orient) {
            default: {
                return false;
            }
            case 2: {
                x1 = x2 = compWidth / 2;
                y1 = 0;
                y2 = compHeight;
                break;
            }
            case 3: {
                x1 = x2 = compWidth / 2;
                y1 = compHeight;
                y2 = 0;
                break;
            }
            case 0: {
                x1 = 0;
                x2 = compWidth;
                y1 = y2 = compHeight / 2;
                break;
            }
            case 1: {
                x1 = compWidth;
                x2 = 0;
                y1 = y2 = compHeight / 2;
                break;
            }
            case 4: {
                y1 = 0;
                x1 = 0;
                x2 = compWidth;
                y2 = compHeight;
            }
        }
        gpNew = new GradientPaint(x1, y1, c1, x2, y2, c2);
        if (gpNew == null) {
            return false;
        }
        img = this.createImage();
        if (img == null) {
            return false;
        }
        g = this.getGraphics2D(img);
        if (g == null) {
            return false;
        }
        g.setPaint(gpNew);
        g.fillRect(0, 0, compWidth, compHeight);
        g.dispose();
        this.gp = gpNew;
        this.gpBackImage = img;
        Color backColor = c1;
        this.gradientOrientation = orient;
        this.chart.setBackImage(img);
        this.chart.setBackColor(backColor);
        this.background.setSolidBackground((Object)backColor);
        ConstComponent constComponent = this;
        synchronized (constComponent) {
            this.bufferUpdateRequired = true;
            return true;
        }
    }

    public Color getSolidBackground() {
        if (this.gp != null) {
            return this.gp.getColor1();
        }
        return this.getBackground();
    }

    public boolean setSolidBackground(Object c) {
        Color color;
        if (c == null) {
            return false;
        }
        if (c instanceof Color) {
            color = (Color)c;
        } else if (c instanceof String) {
            color = NLD.decodeColor((String)((String)c));
            if (color == null) {
                return false;
            }
        } else {
            return false;
        }
        this.chart.setBackImage(null);
        this.chart.setBackColor(color);
        this.background.setSolidBackground((Object)color);
        return true;
    }

    public void redrawGraphBackground(Component c) {
        this.repaint();
    }

    public boolean supportsImageBackground() {
        return false;
    }

    public boolean supportsGradientBackground() {
        return false;
    }

    protected String getFitStyleAsString() {
        String s = null;
        switch (this.imageFitStyle) {
            case 1: {
                s = "Tile";
                break;
            }
            case 2: {
                s = "Center";
                break;
            }
            case 3: {
                s = "Locate";
                break;
            }
            case 0: {
                s = "Stretch";
            }
        }
        return s;
    }

    protected Image createImage() {
        int compWidth = this.chart.getComponentWidth();
        int compHeight = this.chart.getComponentHeight();
        if (compWidth <= 0 || compHeight <= 0) {
            return null;
        }
        return this.createImage(compWidth, compHeight);
    }

    protected Graphics2D getGraphics2D(Image source) {
        Graphics g = null;
        g = source == null ? this.getGraphics() : source.getGraphics();
        if (g instanceof Graphics2D) {
            return (Graphics2D)g;
        }
        if (g != null) {
            g.dispose();
        }
        return null;
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if ((e.getModifiers() & 4) != 0) {
            if (this.popup == null) {
                this.popup = this.getDefaultPopupMenu();
            }
            this.chart.pick(x, y);
            this.chart.setPopupLabels();
            if (this.showPopup) {
                this.popup.show(e.getComponent(), x, y);
            }
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent e) {
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
    }

    @Override
    public synchronized void mouseClicked(MouseEvent e) {
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
    }

    public void addChartMouseListener(MouseListener ml) {
        this.chart.addMouseListener(ml);
    }

    protected Cursor getCustomCursor(int x, int y, String imgName) {
        Image img = null;
        Toolkit tk = this.getToolkit();
        if (imgName == null || tk == null) {
            return null;
        }
        img = ResourceLoader.getImage((Component)this, (String)imgName);
        if (img == null) {
            return null;
        }
        Cursor c = null;
        if (!GraphicsEnvironment.isHeadless()) {
            c = tk.createCustomCursor(img, new Point(x, y), imgName);
        }
        return c;
    }

    private boolean disableEvents() {
        DataFilterReadInterface filter;
        if (this.model.nodes != null) {
            filter = ((DataFilterNodeModel)this.model.nodes).getFilter();
            if (filter == null) {
                return false;
            }
            filter.removeDataFilterListener((Object)this.model.nodes);
        }
        if (this.model.links != null) {
            filter = ((DataFilterLinkModel)this.model.links).getFilter();
            if (filter == null) {
                return false;
            }
            filter.removeDataFilterListener((Object)this.model.links);
        }
        this.chart.setHandleEvents(true);
        return true;
    }

    private boolean enableEvents() {
        DataFilterReadInterface filter;
        if (this.model.nodes != null) {
            filter = ((DataFilterNodeModel)this.model.nodes).getFilter();
            if (filter == null) {
                return false;
            }
            filter.addDataFilterListener((Object)this.model.nodes);
        }
        if (this.model.links != null) {
            filter = ((DataFilterLinkModel)this.model.links).getFilter();
            if (filter == null) {
                return false;
            }
            filter.addDataFilterListener((Object)this.model.links);
        }
        this.chart.setHandleEvents(false);
        return true;
    }

    public boolean setDataListening(boolean flag) {
        this.listening = flag;
        if (this.listening) {
            return this.enableEvents();
        }
        return this.disableEvents();
    }

    public boolean isDataListening() {
        return this.listening;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean setEditable(boolean editable) {
        return false;
    }

    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    public boolean isActionEnabled(String action) {
        return true;
    }

    public DataFilterConstViewer getChart() {
        return this.chart;
    }

    public Object getChart(Object id) {
        return this.getChart();
    }

    public Object getChartObject(Object id) {
        return this.getChart(id);
    }

    public boolean setLayoutTolerance(double error) {
        return this.model.setLayoutTolerance(error);
    }

    public boolean setLayoutTime(int time) {
        return this.model.setLayoutTime(time);
    }

    protected String GRS(ResourceBundle rb, String name, String defStrg) {
        String s = null;
        if (name == null) {
            return defStrg;
        }
        try {
            if (rb != null) {
                s = rb.getString(name);
            }
        }
        catch (MissingResourceException e) {
            s = null;
        }
        if (s == null) {
            s = defStrg;
        }
        return s;
    }

    public Object getPropertyValue(int idx) {
        if (idx < 0) {
            return null;
        }
        Object value = null;
        if (this.properties != null && (value = this.properties.get(new Integer(idx))) != null) {
            return value;
        }
        return this.getActualValue(idx);
    }

    public boolean setPropertyValue(int idx, Object value) {
        if (this.properties == null) {
            return false;
        }
        if (idx < 0) {
            return false;
        }
        if (value != null && idx != 34) {
            this.properties.put(new Integer(idx), value);
        }
        return true;
    }

    public int getNumberProperties() {
        return 35;
    }

    private void updateLinkHeads() {
        if (null == this.chart) {
            return;
        }
        this.chart.updateLinkHeads();
    }

    public boolean applyPropertyChanges() {
        if (!this.chartLoaded) {
            this.load();
        }
        if (this.properties == null) {
            return false;
        }
        if (this.properties.isEmpty()) {
            return false;
        }
        boolean nColorSet = false;
        boolean lColorSet = false;
        Color ncolor = this.chart.getNodeColor();
        Color lcolor = this.chart.getLinkColor();
        String nshape = this.chart.getNodeShape();
        boolean nlabels = this.chart.areLabelsShown();
        boolean lArrows = this.chart.areArrowsShown();
        boolean lThresholdSlider = this.isThresholdScrollbarShown();
        boolean sizeMappingNodes = this.chart.isSizeMappingNodes();
        boolean shapeMappingNodes = this.chart.isShapeMappingNodes();
        boolean widthMappingLinks = this.chart.isWidthMappingLinks();
        this.colorMappingLinks = this.chart.isColorMappingLinks();
        this.colorMappingNodes = this.chart.isColorMappingNodes();
        boolean showLinksIsSelected = this.chart.getPickLinks();
        boolean isUserLayout = this.chart.isUserLayout();
        int layoutType = this.lastLayoutType;
        Enumeration keys = this.properties.keys();
        Enumeration values = this.properties.elements();
        boolean readAutoLayoutStrategy = true;
        boolean bl = readAutoLayoutStrategy = !isUserLayout;
        while (keys.hasMoreElements()) {
            Object value;
            Integer i = (Integer)keys.nextElement();
            int key = -1;
            if (i != null) {
                key = i;
            }
            if ((value = values.nextElement()) instanceof PropertyEvent) {
                value = ((PropertyEvent)value).value;
            }
            int mask = 0;
            switch (key) {
                case 21: {
                    this.setSolidBackground(value);
                    break;
                }
                case 0: {
                    this.setColorScheme(value);
                    ncolor = this.chart.getNodeColor();
                    lcolor = this.chart.getLinkColor();
                    nColorSet = true;
                    lColorSet = true;
                    break;
                }
                case 2: {
                    this.chart.setChartTipsOn((Boolean)value);
                    break;
                }
                case 62: {
                    this.setId(value);
                    break;
                }
                case 800: {
                    ncolor = (Color)value;
                    nColorSet = true;
                    break;
                }
                case 801: {
                    this.nsize = (Double)value;
                    break;
                }
                case 802: {
                    nshape = (String)value;
                    break;
                }
                case 803: {
                    nlabels = (Boolean)value;
                    break;
                }
                case 804: {
                    this.colorMappingNodes = (Boolean)value;
                    break;
                }
                case 812: {
                    this.fixColorNodes = (Boolean)value;
                    break;
                }
                case 805: {
                    sizeMappingNodes = (Boolean)value;
                    break;
                }
                case 806: {
                    shapeMappingNodes = (Boolean)value;
                    break;
                }
                case 850: {
                    lcolor = (Color)value;
                    lColorSet = true;
                    break;
                }
                case 851: {
                    if (value instanceof Number) {
                        this.lwidth = ((Number)value).intValue();
                        break;
                    }
                    if (!(value instanceof String)) break;
                    this.lwidth = Integer.parseInt((String)value);
                    break;
                }
                case 852: {
                    this.colorMappingLinks = (Boolean)value;
                    break;
                }
                case 863: {
                    this.fixColorLinks = (Boolean)value;
                    break;
                }
                case 853: {
                    widthMappingLinks = (Boolean)value;
                    break;
                }
                case 858: {
                    this.setSupportValue(value);
                    if (this.thresholdScrollbarPanel == null) break;
                    this.thresholdScrollbarPanel.updateScrollBar();
                    break;
                }
                case 857: {
                    this.chart.setScaleSupport((Boolean)value);
                    break;
                }
                case 861: {
                    lThresholdSlider = (Boolean)value;
                    break;
                }
                case 862: {
                    lArrows = (Boolean)value;
                    break;
                }
                case 864: {
                    this.showAllLinksCBSelected = (Boolean)value;
                    this.model.setHideLinks(!this.showAllLinksCBSelected);
                    break;
                }
                case 865: {
                    this.showIntoLinksCBSelected = (Boolean)value;
                    mask = this.model.getLinksMask();
                    mask = this.showIntoLinksCBSelected ? (mask |= 1) : (mask &= 0xFFFFFFFE);
                    this.model.setLinksMask(mask);
                    break;
                }
                case 866: {
                    this.showOutofLinksCBSelected = (Boolean)value;
                    mask = this.model.getLinksMask();
                    mask = this.showOutofLinksCBSelected ? (mask |= 2) : (mask &= 0xFFFFFFFD);
                    this.model.setLinksMask(mask);
                    break;
                }
                case 867: {
                    this.showAmongLinksCBSelected = (Boolean)value;
                    mask = this.model.getLinksMask();
                    mask = this.showAmongLinksCBSelected ? (mask |= 4) : (mask &= 0xFFFFFFFB);
                    this.model.setLinksMask(mask);
                    break;
                }
                case 868: {
                    showLinksIsSelected = (Boolean)value;
                    this.chart.setPickLinks(showLinksIsSelected);
                    break;
                }
                case 869: {
                    layoutType = (Integer)value;
                    this.chart.setLayoutStrategy(layoutType);
                    break;
                }
                case 870: {
                    isUserLayout = (Boolean)value;
                    String layout = isUserLayout ? "user" : "auto";
                    this.chart.setLayout(layout);
                    readAutoLayoutStrategy = !isUserLayout;
                    break;
                }
                case 872: {
                    if (!(value instanceof Number)) break;
                    this.activeModelMode = ((Number)value).intValue();
                    break;
                }
                case 873: {
                    if (!(value instanceof Boolean)) break;
                    this.supportsThresholdSlider = (Boolean)value;
                }
            }
        }
        if (readAutoLayoutStrategy) {
            if (this.lastLayoutType != layoutType) {
                boolean readDataAgain = true;
                if (this.lastLayoutType == 3 || this.lastLayoutType == 0 || this.lastLayoutType == 1 || this.lastLayoutType == 2) {
                    readDataAgain = false;
                }
                if (this.isLastLayoutUser) {
                    readDataAgain = true;
                }
                this.chart.preProcessAutoLayout(readDataAgain);
                this.makeChangesDueToNodePanelChanges(nColorSet, ncolor, shapeMappingNodes, nshape, sizeMappingNodes, nlabels);
                this.makeChangesDueToLinkPanelChanges(lColorSet, lcolor, widthMappingLinks, lThresholdSlider, lArrows);
                this.model.setArrangeFirstTime(true);
                this.model.arrange();
                this.lastLayoutType = layoutType;
                this.isLastLayoutUser = false;
            } else {
                boolean readDataAgain = false;
                if (this.isLastLayoutUser) {
                    readDataAgain = true;
                }
                this.chart.preProcessAutoLayout(readDataAgain);
                this.makeChangesDueToNodePanelChanges(nColorSet, ncolor, shapeMappingNodes, nshape, sizeMappingNodes, nlabels);
                this.makeChangesDueToLinkPanelChanges(lColorSet, lcolor, widthMappingLinks, lThresholdSlider, lArrows);
                if (readDataAgain) {
                    this.model.setArrangeFirstTime(true);
                    this.model.arrange();
                }
                this.isLastLayoutUser = false;
            }
        } else if (this.isUserLayoutAllowed()) {
            this.chart.preProcessUserLayout();
            this.makeChangesDueToNodePanelChanges(nColorSet, ncolor, shapeMappingNodes, nshape, sizeMappingNodes, nlabels);
            this.makeChangesDueToLinkPanelChanges(lColorSet, lcolor, widthMappingLinks, lThresholdSlider, lArrows);
            this.isLastLayoutUser = true;
            this.lastLayoutType = -1;
        } else {
            System.out.println("Error condition: Should not come here. ConstComp:ApplyPropChanges");
        }
        this.chart.rebuild();
        this.repaint();
        this.properties.clear();
        return true;
    }

    private void makeChangesDueToLinkPanelChanges(boolean lColorSet, Color lcolor, boolean widthMappingLinks, boolean lThresholdSlider, boolean lArrows) {
        if (this.colorMappingLinks) {
            if (this.fixColorLinks) {
                this.chart.setLinkColor(lcolor, true);
                this.chart.setColorMappingLinks(false);
            } else {
                this.chart.setLinkColor(lcolor);
                this.chart.setColorMappingLinks(true);
                this.chart.colormapLinks();
            }
        } else if (lColorSet) {
            this.chart.setLinkColor(lcolor, true);
            this.chart.setColorMappingLinks(false);
        } else if (this.fixColorLinks) {
            this.chart.setLinkColor(lcolor, true);
            this.chart.setColorMappingLinks(false);
        }
        if (widthMappingLinks) {
            this.chart.setLinkWidths();
            this.chart.setWidthMappingLinks(true);
        } else {
            if (this.lwidth > 0) {
                this.chart.setLinkWidth(new Integer(this.lwidth), true);
            }
            this.chart.setWidthMappingLinks(false);
        }
        this.showThresholdScrollbar(lThresholdSlider);
        this.showDirectionArrow(lArrows);
        this.updateLinkHeads();
        if (this.showAllLinksCBSelected) {
            this.model.updateLinks();
        }
    }

    private void makeChangesDueToNodePanelChanges(boolean nColorSet, Color ncolor, boolean shapeMappingNodes, String nshape, boolean sizeMappingNodes, boolean nlabels) {
        if (this.colorMappingNodes) {
            if (this.fixColorNodes) {
                this.chart.setNodeColor(ncolor, true);
                this.chart.setColorMappingNodes(false);
            } else {
                this.chart.setNodeColor(ncolor);
                this.chart.setColorMappingNodes(true);
                this.chart.colormapNodes();
            }
            this.chart.setNodeLabelTextColor();
        } else if (nColorSet) {
            this.chart.setNodeColor(ncolor, true);
            this.chart.setColorMappingNodes(false);
            this.chart.setNodeLabelTextColor();
        } else if (this.fixColorNodes) {
            this.chart.setNodeColor(ncolor, true);
            this.chart.setColorMappingNodes(false);
        }
        if (shapeMappingNodes) {
            this.fixedShapeNoneSelected = false;
        } else {
            this.fixedShapeNoneSelected = nshape.equalsIgnoreCase("None");
            this.chart.setFixedShapeNoneSelected(this.fixedShapeNoneSelected);
            this.chart.setNodeLabelTextColor();
        }
        if (sizeMappingNodes) {
            this.chart.setSizeMappingNodes(true);
            this.chart.setNodeSizes();
        } else {
            this.chart.setSizeMappingNodes(false);
            if (this.nsize <= 0.0) {
                this.nsize = 1.0;
            }
            this.chart.setNodeSize(this.nsize, true);
        }
        if (shapeMappingNodes) {
            this.chart.setShapeMappingNodes(true);
            this.chart.setNodeShapes();
        } else {
            this.chart.setShapeMappingNodes(false);
            this.chart.setNodeShape(nshape, true);
        }
        this.chart.setLabels(nlabels, true);
    }

    public boolean applyPropertyChanges(Object source) {
        return this.applyPropertyChanges();
    }

    public void cancelPropertyChanges() {
        this.properties.clear();
    }

    public void cancelPropertyChanges(Object source) {
        this.cancelPropertyChanges();
    }

    public int[] getPendingChanges() {
        int[] pending = new int[this.properties.size()];
        Enumeration keys = this.properties.keys();
        int cntr = 0;
        while (keys.hasMoreElements()) {
            Integer i = (Integer)keys.nextElement();
            int key = i;
            if (cntr >= pending.length) continue;
            pending[cntr++] = key;
        }
        return pending;
    }

    public boolean isPropertySupported(int idx) {
        switch (idx) {
            case 0: 
            case 2: 
            case 9: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 601: 
            case 602: 
            case 603: 
            case 800: 
            case 801: 
            case 802: 
            case 803: 
            case 804: 
            case 805: 
            case 806: 
            case 807: 
            case 808: 
            case 809: 
            case 850: 
            case 851: 
            case 852: 
            case 853: 
            case 854: 
            case 855: 
            case 856: 
            case 857: 
            case 858: 
            case 859: 
            case 860: 
            case 861: 
            case 862: 
            case 864: 
            case 865: 
            case 866: 
            case 867: 
            case 868: 
            case 869: 
            case 870: 
            case 871: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int idx) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(new Integer(idx));
    }

    public int getNumberPendingProperties() {
        if (this.properties == null) {
            return 0;
        }
        return this.properties.size();
    }

    public int[] getPendingChanges(Object source) {
        return this.getPendingChanges();
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        return rc;
    }

    public Object getActualValue(int index) {
        switch (index) {
            case 9: 
            case 10: {
                return this.getGraphBackground();
            }
            case 11: {
                return new Boolean(this.supportsGradientBackground());
            }
            case 12: {
                return new Boolean(this.supportsImageBackground());
            }
            case 21: {
                return this.chart.getBackColor();
            }
            case 0: {
                return this.clrScheme;
            }
            case 2: {
                return new Boolean(this.areChartTipsOn());
            }
            case 800: {
                return this.chart.getNodeColor();
            }
            case 801: {
                return new Double(this.chart.getNodeSize());
            }
            case 802: {
                return this.chart.getNodeShape();
            }
            case 803: {
                return new Boolean(this.chart.areLabelsShown());
            }
            case 804: {
                this.colorMappingNodes = this.isMappingAllowed(0, "Color");
                return new Boolean(this.colorMappingNodes);
            }
            case 812: {
                this.fixColorNodes = !this.chart.isColorMappingNodes();
                return new Boolean(this.fixColorNodes);
            }
            case 805: {
                boolean sizeMappingNodes = this.chart.isSizeMappingNodes();
                return new Boolean(sizeMappingNodes);
            }
            case 806: {
                boolean shapeMappingNodes = this.chart.isShapeMappingNodes();
                return new Boolean(shapeMappingNodes);
            }
            case 807: {
                return new Boolean(this.isMappingAllowed(0, "Value"));
            }
            case 808: {
                return new Boolean(this.isMappingAllowed(0, "Size"));
            }
            case 809: {
                return new Boolean(this.isShapeMappingNodesAllowed());
            }
            case 850: {
                return this.chart.getLinkColor();
            }
            case 851: {
                return new Integer(this.chart.getLinkWidth());
            }
            case 852: {
                this.colorMappingLinks = this.isMappingAllowed(1, "Color");
                return new Boolean(this.colorMappingLinks);
            }
            case 863: {
                this.fixColorLinks = !this.chart.isColorMappingLinks();
                return new Boolean(this.fixColorLinks);
            }
            case 853: {
                boolean widthMappingLinks = this.chart.isWidthMappingLinks();
                return new Boolean(widthMappingLinks);
            }
            case 854: {
                return new Boolean(this.isValueMappingLinks());
            }
            case 858: {
                return new Double(this.getSupport());
            }
            case 855: {
                return new Double(this.model.links.getMinimumValue());
            }
            case 856: {
                return new Double(this.model.links.getMaximumValue());
            }
            case 857: {
                return new Boolean(this.chart.isScaleSupport());
            }
            case 859: {
                return new Boolean(this.isMappingAllowed(1, "Value"));
            }
            case 860: {
                return new Boolean(this.isMappingAllowed(1, "Width"));
            }
            case 862: {
                return new Boolean(this.areDirectionArrowsShown());
            }
            case 861: {
                return new Boolean(this.isThresholdScrollbarShown());
            }
            case 864: {
                return new Boolean(this.showAllLinksCBSelected);
            }
            case 865: {
                return new Boolean(this.showIntoLinksCBSelected);
            }
            case 866: {
                return new Boolean(this.showOutofLinksCBSelected);
            }
            case 867: {
                return new Boolean(this.showAmongLinksCBSelected);
            }
            case 868: {
                boolean isSelec = this.chart.getModel().isHideLinks() ? false : this.chart.getPickLinks();
                return new Boolean(isSelec);
            }
            case 869: {
                return new Integer(this.chart.getLayoutStrategy());
            }
            case 870: {
                String layout = this.chart.getChartLayout();
                boolean isUser = false;
                if (StringCompare.equals((String)layout, (String)"user")) {
                    isUser = true;
                }
                return new Boolean(isUser);
            }
            case 871: {
                return new Boolean(this.isUserLayoutAllowed());
            }
            case 601: {
                return this.titles.getTitle(0);
            }
            case 602: {
                return this.titles.getTitle(1);
            }
            case 603: {
                return this.footnotes.getFootnote(0);
            }
            case 873: {
                return this.supportsThresholdSlider;
            }
        }
        return null;
    }

    private void setSupportValue(Object val) {
        double support = 0.0;
        if (val instanceof Number) {
            support = ((Number)val).doubleValue();
            if (this.isMappingAllowed(1, "Value")) {
                this.setSupport(support, true);
            }
        }
    }

    public void setScaleSupport(boolean flag) {
        this.chart.setScaleSupport(flag);
    }

    public boolean isScaleSupport() {
        return this.chart.isScaleSupport();
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        super.addMouseListener(listener);
        this.chart.addMouseListener(listener);
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        super.removeMouseListener(listener);
        this.chart.removeMouseListener(listener);
    }

    public boolean isBackBufferDrawEnabled() {
        return true;
    }

    public boolean isModelAttributeHonored(Object attribute) {
        return false;
    }

    public void setBackBufferDrawEnabled(boolean drawback) {
    }

    public boolean setHonorModelAttribute(Object attribute, boolean honorit) {
        return false;
    }

    public void doAnimate(boolean flag) {
        this.chart.setAnimationFlag(flag);
    }

    public boolean isAnimationOn() {
        return this.chart.getAnimationFlag();
    }

    public void setLayoutStrategy(int type) {
        if (type == 3 || type == 0 || type == 1 || type == 2) {
            this.chart.setLayoutStrategy(type);
        } else {
            this.chart.setLayoutStrategy(3);
        }
        this.isLastLayoutUser = false;
    }

    public int getLayoutStrategy() {
        return this.chart.getLayoutStrategy();
    }

    public void showThresholdScrollbar(boolean flag) {
        if (!(!flag || this.isMappingAllowed(1, "Value") && this.supportsThresholdSlider)) {
            return;
        }
        boolean changed = this.showThresholdScrollbar != flag;
        this.showThresholdScrollbar = flag;
        if (changed) {
            if (this.showThresholdScrollbar) {
                if (this.thresholdScrollbarPanel == null) {
                    this.thresholdScrollbarPanel = new ThresholdScrollbarPanel();
                    this.thresholdScrollbarPanel.updateScrollBar();
                }
                this.add(this.thresholdScrollbarPanel);
                this.revalidate();
            } else {
                this.remove(this.thresholdScrollbarPanel);
                this.revalidate();
            }
        }
    }

    public boolean isThresholdScrollbarShown() {
        return this.showThresholdScrollbar;
    }

    public boolean isToolbarMenuItemVisible() {
        return this.toolbarMenuItemVisible;
    }

    public void setToolbarMenuItemVisible(boolean visible) {
        this.toolbarMenuItemVisible = visible;
    }

    public void roleChanged(RoleEvent roleEvent) {
        if (null == roleEvent) {
            return;
        }
        switch (roleEvent.type) {
            case 1: 
            case 2: {
                this.handleSetRole(roleEvent);
                break;
            }
            case 3: {
                this.handleRemoveRole(roleEvent);
            }
        }
        if (this.chartLoaded) {
            this.model.dataChanged();
        } else if ((roleEvent.role == 44 || roleEvent.role == 45 || roleEvent.role == 46 || roleEvent.role == 24 || roleEvent.role == 25) && (!this.xLocRolePresent && !this.yLocRolePresent || this.xLocRolePresent && this.yLocRolePresent)) {
            this.load();
        }
    }

    private boolean handleRemoveRole(RoleEvent e) {
        Integer roleObj = new Integer(e.role);
        Object var = e.oldValue;
        if (null == roleObj || null == var) {
            return false;
        }
        if (this.model == null) {
            return false;
        }
        if (this.model.nodes == null || this.model.links == null) {
            return false;
        }
        if (this.model instanceof DataFilterModel) {
            boolean isRoleRemoved = this.model.removeRole(var.toString(), roleObj);
            if (!((Object)roleObj).equals(RoleInterface.ROLE_LINK_VALUE)) {
                boolean modifyLayout;
                if (((Object)roleObj).equals(RoleInterface.ROLE_NODE_SHAPE)) {
                    this.chart.setShapeMappingNodes(false);
                } else if (((Object)roleObj).equals(RoleInterface.ROLE_NODE_X)) {
                    this.xLocRolePresent = false;
                    this.chart.setLayout("auto");
                } else if (((Object)roleObj).equals(RoleInterface.ROLE_NODE_Y)) {
                    this.yLocRolePresent = false;
                    this.chart.setLayout("auto");
                } else if (((Object)roleObj).equals(RoleInterface.ROLE_NODE_VALUE)) {
                    this.chart.setSizeMappingNodes(this.isMappingAllowed(0, "Size"));
                    this.chart.setColorMappingNodes(this.isMappingAllowed(0, "Color"));
                } else if (((Object)roleObj).equals(RoleInterface.ROLE_NODE_COLOR)) {
                    this.chart.setColorMappingNodes(this.isMappingAllowed(0, "Value"));
                } else if (((Object)roleObj).equals(RoleInterface.ROLE_NODE_SIZE)) {
                    this.chart.setSizeMappingNodes(this.isMappingAllowed(0, "Value"));
                } else if (((Object)roleObj).equals(RoleInterface.ROLE_LINK_VALUE)) {
                    this.chart.setWidthMappingLinks(this.isMappingAllowed(1, "Width"));
                    this.chart.setColorMappingLinks(this.isMappingAllowed(1, "Color"));
                } else if (((Object)roleObj).equals(RoleInterface.ROLE_LINK_WIDTH)) {
                    this.chart.setWidthMappingLinks(this.isMappingAllowed(1, "Value"));
                }
                boolean bl = modifyLayout = ((Object)roleObj).equals(RoleInterface.ROLE_NODE_X) || ((Object)roleObj).equals(RoleInterface.ROLE_NODE_Y);
                if (modifyLayout) {
                    this.chartLoaded = !this.xLocRolePresent && !this.yLocRolePresent || this.xLocRolePresent && this.yLocRolePresent;
                    if (this.xLocRolePresent && this.yLocRolePresent) {
                        this.setUserLayout(true);
                    } else {
                        this.setUserLayout(false);
                    }
                }
                return isRoleRemoved;
            }
            this.showThresholdScrollbar(false);
            return isRoleRemoved;
        }
        return false;
    }

    private boolean handleSetRole(RoleEvent e) {
        Integer roleObj = new Integer(e.role);
        Object var = this.getFirstObject(this.roleManager.getVariable((Object)roleObj));
        if (null == roleObj || null == var) {
            return false;
        }
        if (this.model == null) {
            return false;
        }
        if (this.model.nodes == null || this.model.links == null) {
            return true;
        }
        if (this.model instanceof DataFilterModel) {
            boolean isRoleSet = this.model.setRole(var.toString(), roleObj);
            if (!((Object)roleObj).equals(RoleInterface.ROLE_LINK_VALUE)) {
                boolean modifyLayout;
                if (((Object)roleObj).equals(RoleInterface.ROLE_NODE_SHAPE)) {
                    this.chart.setShapeMappingNodes(true);
                } else if (((Object)roleObj).equals(RoleInterface.ROLE_NODE_VALUE) || ((Object)roleObj).equals(RoleInterface.ROLE_NODE_SIZE)) {
                    this.chart.setSizeMappingNodes(true);
                } else if (((Object)roleObj).equals(RoleInterface.ROLE_NODE_VALUE) || ((Object)roleObj).equals(RoleInterface.ROLE_NODE_COLOR)) {
                    this.chart.setColorMappingNodes(true);
                } else if (((Object)roleObj).equals(RoleInterface.ROLE_LINK_VALUE) || ((Object)roleObj).equals(RoleInterface.ROLE_LINK_WIDTH)) {
                    this.chart.setWidthMappingLinks(true);
                } else if (((Object)roleObj).equals(RoleInterface.ROLE_NODE_X)) {
                    this.xLocRolePresent = true;
                } else if (((Object)roleObj).equals(RoleInterface.ROLE_NODE_Y)) {
                    this.yLocRolePresent = true;
                }
                boolean bl = modifyLayout = ((Object)roleObj).equals(RoleInterface.ROLE_NODE_X) || ((Object)roleObj).equals(RoleInterface.ROLE_NODE_Y);
                if (modifyLayout) {
                    if (this.xLocRolePresent && this.yLocRolePresent) {
                        if (this.chart.isAnimating()) {
                            this.chart.setPauseLayout(true);
                            while (this.chart.getModel().isLayoutThreadAlive()) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (Exception exception) {}
                            }
                        }
                        this.setUserLayout(true);
                    } else {
                        this.setUserLayout(false);
                    }
                }
                return isRoleSet;
            }
            Object value = this.getPropertyValue(861);
            boolean showThreshold = false;
            if (value != null && value instanceof Boolean) {
                showThreshold = (Boolean)value;
            }
            if (!showThreshold) {
                return isRoleSet;
            }
            this.showThresholdScrollbar(showThreshold);
            return isRoleSet;
        }
        return false;
    }

    protected Object getFirstObject(Object value) {
        if (value == null) {
            return null;
        }
        return Extract.getObject((Object)value, (int)0, (int)Extract.getSourceType((Object)value));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.background.drawBackground((Graphics2D)g, (Component)this);
        this.titles.draw((Object)g, false);
        this.footnotes.draw((Object)g, false);
    }

    public void textUpdated(DvrTextEvent evt) {
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.layoutChart();
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    private void layoutChart() {
        boolean displaySlider;
        Rectangle componentBounds = this.getBounds();
        int sliderHeight = 0;
        boolean bl = displaySlider = this.isThresholdScrollbarShown() && this.thresholdScrollbarPanel != null;
        if (displaySlider) {
            sliderHeight = this.thresholdScrollbarPanel.getPreferredSize().height;
        }
        int compXMargin = 0;
        int compYMargin = SILKGlobal.isFlagSet((int)4) ? this.silkDefaults.statgraphComponentYMargin : this.silkDefaults.componentYMargin;
        this.titles.setComponentBounds(new Rectangle(compXMargin, compYMargin, componentBounds.width - 2 * compXMargin, componentBounds.height - compYMargin - sliderHeight));
        this.footnotes.setComponentBounds(new Rectangle(compXMargin, compYMargin, componentBounds.width - 2 * compXMargin, componentBounds.height - compYMargin - sliderHeight));
        Rectangle titlesArea = this.titles.getBounds();
        Rectangle footnotesArea = this.footnotes.getBounds();
        Rectangle r = new Rectangle();
        r.x = compXMargin;
        r.y = titlesArea.height > 0 ? compYMargin + titlesArea.height : 0;
        r.width = componentBounds.width - 2 * compXMargin;
        r.height = componentBounds.height - titlesArea.height - footnotesArea.height - sliderHeight;
        if (titlesArea.height > 0) {
            r.height -= compYMargin;
        }
        if (footnotesArea.height > 0) {
            r.height -= compYMargin;
        }
        this.chart.setBounds(r.x, r.y, r.width, r.height);
        if (displaySlider) {
            this.thresholdScrollbarPanel.setBounds(0, componentBounds.height - sliderHeight, componentBounds.width, sliderHeight);
        }
    }

    private boolean setSource(int modelType, Object source) {
        DataFilterReadInterface filter = null;
        if (source == null) {
            return false;
        }
        switch (modelType) {
            case 1: {
                this.linkSource = source;
                filter = this.linkFilter = FilterFactory.getDataSourceFilter((Object)source);
                if (this.model == null) break;
                return this.model.setDataSource(modelType, filter);
            }
            case 0: {
                this.nodeSource = source;
                filter = this.nodeFilter = FilterFactory.getDataSourceFilter((Object)source);
                if (this.model == null) break;
                return this.model.setDataSource(modelType, filter);
            }
        }
        return false;
    }

    private DataFilterReadInterface getLocalFilter(int modelType) {
        switch (modelType) {
            case 1: {
                return this.linkFilter;
            }
            case 0: {
                return this.nodeFilter;
            }
        }
        return null;
    }

    private String generateDefaultChartId(Object chart) {
        String id = "Chart";
        SILKChartInfo info = SILKChartInfo.getInstance((Object)chart);
        if (info != null) {
            id = info.getDisplayName();
        }
        return id;
    }

    @Override
    public void setBorder(Border border) {
        this.chart.setBorder(border);
    }

    private class ThresholdScrollbarPanel
    extends JPanel
    implements AdjustmentListener {
        private static final long serialVersionUID = 1L;
        private JLabel thresholdLabel = new JLabel("      ", 4);
        private JScrollBar thresholdScrollbar = new JScrollBar(0, (int)(100.0 - this.support), 5, 0, 105);
        private double support = 0.0;
        private double minLinkVal = 0.0;
        private double maxLinkVal = 100.0;
        private double scrollBlkIncr = 5.0;
        private double scrollUnitIncr;
        private double divisions = 20.0;
        private boolean ignoreEvent = false;
        private boolean ignoreUpdate = false;

        ThresholdScrollbarPanel() {
            this.thresholdScrollbar.setBlockIncrement(5);
            this.thresholdScrollbar.addAdjustmentListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.thresholdScrollbar, "Center");
            this.add((Component)this.thresholdLabel, "West");
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent ae) {
            if (this.ignoreEvent) {
                return;
            }
            boolean scaleSupport = (Boolean)ConstComponent.this.getPropertyValue(857);
            if (scaleSupport) {
                this.support = 100 - this.thresholdScrollbar.getValue();
                String s = new Integer((int)this.support).toString() + " %";
                while (s.length() < 5) {
                    s = " " + s;
                }
                this.thresholdLabel.setText(s);
            } else {
                double val = this.maxLinkVal - (double)this.thresholdScrollbar.getVisibleAmount() - (double)this.thresholdScrollbar.getValue();
                this.support = (int)(val + this.minLinkVal);
                this.thresholdLabel.setText(new Integer((int)(val + this.minLinkVal)).toString());
            }
            this.ignoreUpdate = true;
            ConstComponent.this.setPropertyValue(858, new Double(this.support));
            ConstComponent.this.applyPropertyChanges();
            this.ignoreUpdate = false;
        }

        public void updateScrollBar() {
            double visible;
            double val;
            if (this.ignoreUpdate) {
                return;
            }
            NLDModel dataModel = ConstComponent.this.chart.getModel();
            this.minLinkVal = dataModel.links.getMinimumValue();
            this.maxLinkVal = dataModel.links.getMaximumValue();
            boolean boundSupport = false;
            boolean scaleSupport = (Boolean)ConstComponent.this.getPropertyValue(857);
            this.support = ((Number)ConstComponent.this.getPropertyValue(858)).doubleValue();
            if (scaleSupport) {
                if (this.support < 0.0) {
                    val = 0.0;
                    boundSupport = true;
                } else if (this.support > 100.0) {
                    val = 100.0;
                    boundSupport = true;
                } else {
                    val = this.support;
                }
                if (boundSupport) {
                    this.support = (int)val;
                    ConstComponent.this.setPropertyValue(858, new Double(this.support));
                    ConstComponent.this.applyPropertyChanges();
                }
                this.minLinkVal = 0.0;
                this.maxLinkVal = 100.0;
                this.scrollBlkIncr = (this.maxLinkVal - this.minLinkVal) / this.divisions;
                this.scrollUnitIncr = (this.maxLinkVal - this.minLinkVal) / 100.0;
                this.scrollBlkIncr = Math.max(1.0, this.scrollBlkIncr);
                this.scrollUnitIncr = Math.max(1.0, this.scrollUnitIncr);
                visible = this.scrollBlkIncr;
                this.maxLinkVal += visible;
                this.ignoreEvent = true;
                this.thresholdScrollbar.setValues((int)(this.maxLinkVal - visible - (val - this.minLinkVal)), (int)visible, (int)this.minLinkVal, (int)this.maxLinkVal);
                this.ignoreEvent = false;
                this.thresholdScrollbar.setBlockIncrement((int)this.scrollBlkIncr);
                this.thresholdScrollbar.setUnitIncrement((int)this.scrollUnitIncr);
            } else {
                if (this.support < this.minLinkVal) {
                    val = this.minLinkVal;
                    boundSupport = true;
                } else if (this.support > this.maxLinkVal) {
                    val = this.maxLinkVal;
                    boundSupport = true;
                } else {
                    val = this.support;
                }
                if (boundSupport) {
                    this.support = (int)val;
                    this.ignoreUpdate = true;
                    ConstComponent.this.setPropertyValue(858, new Double(this.support));
                    ConstComponent.this.applyPropertyChanges();
                    this.ignoreUpdate = false;
                }
                this.scrollBlkIncr = (this.maxLinkVal - this.minLinkVal) / this.divisions;
                this.scrollUnitIncr = (this.maxLinkVal - this.minLinkVal) / 100.0;
                this.scrollBlkIncr = Math.max(1.0, this.scrollBlkIncr);
                this.scrollUnitIncr = Math.max(1.0, this.scrollUnitIncr);
                visible = this.scrollBlkIncr;
                this.maxLinkVal += visible;
                this.ignoreEvent = true;
                this.thresholdScrollbar.setValues((int)(this.maxLinkVal - visible - (val - this.minLinkVal)), (int)visible, (int)this.minLinkVal, (int)this.maxLinkVal);
                this.ignoreEvent = false;
                this.thresholdScrollbar.setBlockIncrement((int)this.scrollBlkIncr);
                this.thresholdScrollbar.setUnitIncrement((int)this.scrollUnitIncr);
                if (this.maxLinkVal - this.minLinkVal < 2.0) {
                    System.err.println("Scrollbar may not function correctly since the range of link weights is\nless than 2 and you have chosen NOT to scale link weights.\nFor proper functioning please scale link weights for this range.\n");
                }
            }
            String msg = new Integer((int)val).toString();
            if (scaleSupport) {
                msg = msg + " %";
            }
            while (msg.length() < 5) {
                msg = " " + msg;
            }
            this.thresholdLabel.setText(msg);
        }
    }
}

