/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.overlays;

import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCVaryLineConnector;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBlockOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCVaryLine;
import com.sas.analytics.qc.statgraph.sgchart.util.BBox;
import com.sas.analytics.qc.statgraph.sgchart.util.QCMargins;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.text.Format;
import java.util.Vector;

public class QCVaryLineOverlay
extends QCOverlay {
    public static final String RB_KEY = "QCVaryLineOverlay.";
    private ColorProperty lineColor = new ColorProperty();
    private NumericProperty lineWidth = new NumericProperty();
    private IntegerProperty linePattern = new IntegerProperty();
    private LineAttrs joinStyle = new LineAttrs();
    private NumericVectorVariable numericXVar;
    private double transparency = 0.0;
    protected Point origin;
    private LineAttrs lineStyle = new LineAttrs();
    private TextStyle labelStyle = new TextStyle();
    private SASFormat labelFormat = null;
    private int phaseIndex = -1;
    private boolean labelAbove = true;
    private QCVaryLine.LabelPos labelPosition = QCVaryLine.LabelPos.INNER_LEFT;
    protected String labelString = null;
    protected Rectangle clipRect = null;
    protected FontMetrics fm;
    protected boolean fixed = false;
    protected double value = Double.NaN;
    protected double[] values = null;
    protected double[][] data = null;
    protected int dataN = 0;
    public boolean phaseLimits = false;
    public double[][][] phaseData = null;
    public int[] phaseDataN = null;
    public boolean[] phaseFixed = null;
    public double[] phaseValue = null;
    public double phaseTest = Double.NaN;
    protected DataRange range;
    protected int lastNonMissingIndex = -1;
    protected double lastNonMissingValue = Double.NaN;
    protected NumericVariable var;
    protected String varID;
    protected DataRange xRange = null;
    protected DataRange lineColorRange = null;
    protected DataRange lineRange = null;
    protected DataRange phaseRange = null;
    private boolean debug = false;
    private boolean debugFill = false;
    protected int clipAreaX;
    protected int clipAreaY;
    protected int clipAreaWidth;
    protected int clipAreaHeight;
    private Variable lineColorVar;
    private Variable lineVar;
    private NumericVector nv;
    private QCVaryLineConnector lineConnector;
    private RasterLabel label;
    public boolean selectable = true;

    @Override
    public boolean overrideGTLRenderingOrder(boolean highlight) {
        return highlight;
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    public void drawLines(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        boolean lineOn = this.lineConnector.lineOn;
        boolean labelOn = this.lineConnector.labelOn;
        this.lineConnector.lineOn = true;
        this.lineConnector.labelOn = false;
        this.networkRoot.draw(channel, false);
        this.lineConnector.lineOn = lineOn;
        this.lineConnector.labelOn = labelOn;
    }

    public void drawLabels(Graphics g) {
        if (this.labelPosition == QCVaryLine.LabelPos.OUTER_RIGHT) {
            return;
        }
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        boolean lineOn = this.lineConnector.lineOn;
        boolean labelOn = this.lineConnector.labelOn;
        this.lineConnector.lineOn = false;
        this.lineConnector.labelOn = true;
        this.networkRoot.draw(channel, false);
        this.lineConnector.lineOn = lineOn;
        this.lineConnector.labelOn = labelOn;
    }

    public void drawNoneClipped(Graphics g) {
        if (this.labelPosition != QCVaryLine.LabelPos.OUTER_RIGHT) {
            return;
        }
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        boolean lineOn = this.lineConnector.lineOn;
        boolean labelOn = this.lineConnector.labelOn;
        this.lineConnector.lineOn = false;
        this.lineConnector.labelOn = true;
        this.networkRoot.draw(channel, false);
        this.lineConnector.lineOn = lineOn;
        this.lineConnector.labelOn = labelOn;
    }

    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.updateXRange();
        this.updateLineRange();
        this.updateLineRange();
        this.updateLineColorRange();
        this.updateFillColorRange();
    }

    public void setClipRect(Rectangle r) {
        this.clipRect = r;
    }

    protected void connectVars() {
        if (this.model.isAvailable(10)) {
            this.numericX = this.model.getColumnClass(10) == Double.class;
            Variable variable = this.xvalueVar = this.discreteX ? this.connectCategory((short)10, this.missingCategoryOn) : this.connectRaw((short)10);
            if (this.numericX && this.discreteX) {
                this.numericXVar = new NumericVectorVariable();
                this.numericXVar.connectFrom(this.model.getDoubleColumn(10));
                SASFormat fmt = ((ColumnMetadata)this.model.getColumnLabel(10)).getFormat();
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                }
                this.numericXVar.setFormat(new GTKFormat((Format)fmt));
            }
            if (this.discreteX) {
                this.numericDiscreteX = this.numericX;
                this.numericX = false;
            }
        } else {
            this.xvalueVar = null;
        }
        if (this.model.isAvailable(11)) {
            this.var = (NumericVariable)this.connectRaw((short)11);
        }
        if (this.model.isAvailable(787)) {
            NumericVariable str = (NumericVariable)this.connectRaw((short)787);
            int nx = this.model.getRowCount();
            Object value = nx > 0 ? Variable.getValue((Variable)str, (int)0, (boolean)false) : null;
            Object object = nx > 1 ? Variable.getValue((Variable)str, (int)1, (boolean)false) : null;
        }
        this.lineColorVar = null;
        this.lineVar = null;
    }

    protected void updateXRange() {
        Object newRange = null;
        DataRange oldRange = this.xRange;
        if (this.xvalueVar != null) {
            int num;
            int n = num = this.numericX ? this.xvalueVar.getValueCount() : this.xvalueVar.getUniqueValueCount();
            if (num > 0) {
                newRange = this.numericX ? this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, !this.xUnionAllPages) : (this.numericDiscreteX ? this.makeOrdinalRange((StringVariable)this.xvalueVar, num, (NumericVariable)this.numericXVar, (short)10, !this.xUnionAllPages) : this.makeDiscreteRange((StringVariable)this.xvalueVar, num, (short)10, !this.xUnionAllPages));
                if (newRange != null) {
                    newRange.setLabel(this.xvalueVar.getLabel());
                }
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 10);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateLineRange(int iVary) {
        DataRange newRange = null;
        DataRange oldRange = this.getLineRange();
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        if (this.var != null) {
            int num = this.var.getValueCount();
            if (num > 0) {
                newRange = this.makeContinuousRange(this.var, (short)11, !this.yUnionAllPages);
                newRange.setLabel(this.var.getLabel());
            }
        } else {
            double d = this.getLineValue();
            if (!Double.isNaN(d)) {
                newRange = new ContinuousRange(d, d);
            }
        }
        this.setFormat(newRange, 11);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.setRange(newRange);
        this.fireRangeEvent((byte)2, oldRange, newRange);
    }

    protected void updatePhaseRange(QCBlockOverlay phase) {
        DataRange newRange = null;
        DataRange oldRange = this.phaseRange;
        if (this.phaseVar == null || !phase.getLegend()) {
            return;
        }
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        short role = this.hasPhaseIndexVar() ? (short)44 : 3;
        int num = this.phaseVar.getValueCount();
        if (num > 0) {
            newRange = this.makeContinuousRange(this.phaseVar, role, false);
            newRange.setLabel(this.phaseVar.getLabel());
        }
        this.setFormat(newRange, role);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
    }

    protected void updateFillColorRange() {
    }

    protected void updateLineRange() {
    }

    protected void updateLineColorRange() {
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        ContinuousRange cr = null;
        boolean iLine = false;
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                DataRange range = this.getLineRange();
                if (range == null) {
                    return null;
                }
                double min = ((ContinuousRange)range).getMin();
                double max = ((ContinuousRange)range).getMax();
                cr = new ContinuousRange(min, max);
                cr.union(range);
                String label = range.getLabel();
                cr.setLabel(label);
                SASFormat format = range.getFormat();
                cr.setFormat(format);
                return cr;
            }
            case 17: {
                return this.lineColorRange;
            }
            case 15: {
                return this.lineRange;
            }
        }
        return null;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4 || dimension == 17 || dimension == 15) {
            // empty if block
        }
        this.needConnect = true;
    }

    public boolean connectNetwork() {
        SASFormat format;
        if (!this.needConnect) {
            return true;
        }
        if (this.xRange == null) {
            return false;
        }
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        ValueMap xMap = this.xEncoder.getValueMap();
        if (this.numericX) {
            if (!(xMap instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            if (this.xvalueMapper == null || !(this.xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                this.xvalueMapper = new ContinuousRangeToNumericMapper();
            }
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)xMap);
        } else {
            if (!(xMap instanceof StringToNumericMap)) {
                return false;
            }
            if (this.xvalueMapper == null || !(this.xvalueMapper instanceof StringToNumericMapper)) {
                this.xvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)xMap);
        }
        ValueMap yMap = this.yEncoder.getValueMap();
        if (!(yMap instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        if (this.yvalueMapper == null || !(this.yvalueMapper instanceof ContinuousRangeToNumericMapper)) {
            this.yvalueMapper = new ContinuousRangeToNumericMapper();
        }
        ((ContinuousRangeToNumericMapper)this.yvalueMapper).setMap((ContinuousRangeToNumericMap)yMap);
        ContinuousRangeToNumericMapper mapper = null;
        if (this.var != null) {
            mapper = new ContinuousRangeToNumericMapper();
            mapper.setMap((ContinuousRangeToNumericMap)yMap);
        }
        if ((format = this.xEncoder.getInput().getFormat()) != null && this.xvalueVar != null) {
            this.xvalueVar.setFormat(new GTKFormat((Format)format));
        }
        if (this.numericX) {
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).input.connectFrom(((NumericVariable)this.xvalueVar).value);
        } else {
            ((StringToNumericMapper)this.xvalueMapper).input.connectFrom(((StringVariable)this.xvalueVar).value);
        }
        double value = Double.NaN;
        if (mapper == null) {
            value = this.getLineValue();
        } else {
            mapper.input.connectFrom(this.var.value);
        }
        this.networkRoot.removeAllElements();
        this.lineConnector = new QCVaryLineConnector();
        this.networkRoot.addElement((Element)this.lineConnector);
        Color color = this.applyDataTransparency((ColorAttr)this.lineStyle);
        int width = this.lineStyle.getWidth();
        int pattern = this.lineStyle.getLinePattern();
        this.lineColor.setValue(color);
        this.lineWidth.setValue((double)width);
        this.linePattern.setValue(pattern);
        this.lineConnector.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
        this.lineConnector.setConnectionOrder(0);
        this.lineConnector.setMultipleGroup(true);
        this.lineConnector.setSkipMissingOn(true);
        this.lineConnector.setLineBreak(false);
        this.lineConnector.color.connectFrom((ColorPipe)this.lineColor);
        this.lineConnector.linePattern.connectFrom((IntegerPipe)this.linePattern);
        this.lineConnector.lineWidth.connectFrom((NumericPipe)this.lineWidth);
        this.lineConnector.selectEnabled.setValue(this.selectable);
        this.lineConnector.setUserData(this.probe);
        this.lineConnector.setSVGRender(StatGraph.VGF);
        this.lineConnector.setSVGRender(true);
        if (this.xvalueMapper != null) {
            this.lineConnector.pointX.connectFrom((NumericPipe)this.xvalueMapper);
        } else {
            ContinuousRangeToNumericMapper xCMapper = null;
            xCMapper = new ContinuousRangeToNumericMapper();
            this.nv = new NumericVector();
            double min = ((ContinuousRange)this.xRange).getMin();
            double max = ((ContinuousRange)this.xRange).getMax();
            if (this.numericX) {
                double xmin = this.xEncoder.getLowerLimit();
                double xmax = this.xEncoder.getUpperLimit();
                min = xCMapper.getInverseValue(xmin);
                max = xCMapper.getInverseValue(xmax);
            }
            this.nv.addValue(min);
            this.nv.addValue(max);
            xCMapper.input.connectFrom((NumericPipe)this.nv);
            xCMapper.shareMap((ContinuousRangeToNumericMapper)this.xvalueMapper);
            this.lineConnector.pointX.connectFrom((NumericPipe)xCMapper);
        }
        if (mapper != null) {
            this.lineConnector.pointY.connectFrom((NumericPipe)mapper);
        } else {
            ContinuousRangeToNumericMapper yCMapper = new ContinuousRangeToNumericMapper();
            yCMapper.input.setValue(value);
            yCMapper.setMap((ContinuousRangeToNumericMap)this.yEncoder.getValueMap());
            this.lineConnector.pointY.connectFrom((NumericPipe)yCMapper);
        }
        BBox frame = this.translateAxisBounds();
        this.lineConnector.setFrame(frame);
        if (this.hasPhaseIndexVar()) {
            QCBlockOverlay blockRef;
            QCBlockOverlay phaseRef = this.chart.getRefOverlay(QCBlockOverlay.BlockType.PHASEREF);
            QCBlockOverlay refOverlay = blockRef = this.chart.getRefOverlay(QCBlockOverlay.BlockType.BLOCKREF);
            refOverlay = phaseRef;
            this.lineConnector.numericGroup.connectFrom(this.phaseVar.value);
            this.lineConnector.setPhaseFrames(refOverlay.getRefFillFrames(frame));
            this.lineConnector.setPhaseRefList(refOverlay.getRefList());
            QCBlockOverlay.Block block = refOverlay.blocks.get(0);
            this.lineConnector.setPhaseEntries(block.entries);
            this.lineConnector.setPhaseIndex(this.phaseIndex);
        }
        this.initLineData();
        this.label = new RasterLabel();
        Color labelColor = this.labelStyle.getColor();
        this.label.color.setValue(labelColor);
        this.label.fontName.setValue(this.labelStyle.getFont().getName());
        this.label.fontSize.setValue(this.labelStyle.getFont().getSize());
        this.label.fontStyle.setValue(this.labelStyle.getFont().getStyle());
        this.fm = StatGraph.getFontMetrics((Font)this.labelStyle.getFont());
        if (this.curveLabelSplit) {
            this.label.string.setValue(QCVaryLineOverlay.makeMultiLineLabel((String[])QCVaryLineOverlay.splitLabel((String)this.labelString, (boolean)true, (double)-1.0, (boolean)this.curveLabelSplitCharDrop, (char[])this.curveLabelSplitChar, (FontMetrics)this.fm), (boolean)false));
        } else if (this.labelFormat != null) {
            if (this.labelFormat.isCharacterFormat()) {
                this.label.string.setValue(this.labelFormat.format((Object)this.labelString));
            } else {
                this.label.string.setValue(this.labelFormat.format((Object)new Double(this.labelString)));
            }
        } else {
            this.label.string.setValue(this.labelString);
        }
        this.lineConnector.label = this.label;
        this.lineConnector.labelPosition = this.labelPosition;
        this.lineConnector.labelAbove = this.labelAbove;
        this.lineConnector.lineOn = width != 0;
        this.lineConnector.labelOn = this.labelString != null;
        this.needConnect = false;
        return true;
    }

    private BBox translateAxisBounds() {
        double xAxisLower = this.xEncoder.getLowerLimit();
        double xAxisUpper = this.xEncoder.getUpperLimit();
        double yAxisUpper = this.yEncoder.getUpperLimit();
        double yAxisLower = this.yEncoder.getLowerLimit();
        return new BBox((int)xAxisLower, (int)yAxisLower, (int)xAxisUpper, (int)yAxisUpper);
    }

    private boolean isDataInsideViewport(int j, Variable x, Variable y, double xMin, double xMax, double yMin, double yMax) {
        double delta = 1.0E-6;
        boolean xIn = true;
        boolean yIn = true;
        try {
            if (x != null && x instanceof NumericVariable && (((NumericVariable)x).value.getValue(j) > xMax + delta || ((NumericVariable)x).value.getValue(j) < xMin - delta)) {
                xIn = false;
            }
            if (y != null && y instanceof NumericVariable && (((NumericVariable)y).value.getValue(j) > yMax + delta || ((NumericVariable)y).value.getValue(j) < yMin - delta)) {
                yIn = false;
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return xIn && yIn;
    }

    public void setDebug(boolean on) {
        this.debug = on;
    }

    public void setLabelAbove(boolean above) {
        this.labelAbove = above;
    }

    public void setPhaseIndex(int index) {
        this.phaseIndex = index;
    }

    public void setJoinStyle(LineAttrs style) {
        this.joinStyle = style;
    }

    public LineAttrs getJoinStyle() {
        return this.joinStyle;
    }

    public LineAttrs getLineAttrs() {
        return this.lineStyle;
    }

    public void setLineStyle(LineAttrs style) {
        this.lineStyle = style;
    }

    public String getLabelString() {
        return this.labelString;
    }

    public void setLabelString(String s) {
        this.labelString = s;
    }

    public TextStyle getLabelAttrs() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextStyle aLabelStyle) {
        this.labelStyle = aLabelStyle;
    }

    public boolean isHorizontal() {
        return false;
    }

    public void setLineValue(double d) {
        this.fixed = true;
        this.value = d;
    }

    public double getLineValue() {
        return this.value;
    }

    public void setRange(DataRange r) {
        this.range = r;
    }

    public DataRange getLineRange() {
        return this.range;
    }

    public boolean isConstant() {
        return this.fixed;
    }

    public Area getMissingAreas() {
        boolean phaseLimits;
        QCBlockOverlay blockRef;
        Area area = null;
        double[] temp = new double[3];
        boolean useAxisOffsets = false;
        double xLeft = this.innerAxisBounds.x;
        double xRight = xLeft + (double)this.innerAxisBounds.width;
        double yTop = useAxisOffsets ? (double)this.outerAxisBounds.y : (double)this.innerAxisBounds.y;
        double yBottom = yTop + (double)(useAxisOffsets ? this.outerAxisBounds.height : this.innerAxisBounds.height);
        int blockOffset = QCShewhart.getBlockOffset((byte)1);
        int glyphOffset = QCShewhart.getGlyphOffset((byte)1);
        boolean offset = false;
        QCBlockOverlay phaseRef = this.chart.getRefOverlay(QCBlockOverlay.BlockType.PHASEREF);
        QCBlockOverlay refOverlay = blockRef = this.chart.getRefOverlay(QCBlockOverlay.BlockType.BLOCKREF);
        boolean bl = phaseLimits = refOverlay != null && refOverlay.usePhaseLimits();
        if (!phaseLimits) {
            Rectangle r = new Rectangle(this.innerAxisBounds);
            int height = r.height;
            int nPts = this.dataN;
            double[][] pLine = this.data;
            int i = 0;
            double x = pLine[i][0];
            double y = pLine[i][1];
            boolean blank = false;
            for (i = 0; i < nPts; ++i) {
                x = pLine[i][0];
                y = pLine[i][1];
                this.project(x, y, 0.0, temp);
                if (blank ? Double.isNaN(temp[1]) : !Double.isNaN(temp[1])) continue;
                double dx = (double)offset;
                float fx = (float)(temp[0] - dx);
                float fy = (float)temp[1];
                if (blank) {
                    r.width = (int)(fx - (float)r.x);
                    if (area == null) {
                        area = new Area();
                    }
                    area.add(new Area(r));
                    blank = false;
                    continue;
                }
                r = new Rectangle();
                r.x = (int)fx;
                r.y = (int)yTop;
                r.height = height;
                blank = true;
            }
        }
        return area;
    }

    public Area getNonMissingAreas() {
        boolean phaseLimits;
        QCBlockOverlay blockRef;
        Area area = null;
        double[] temp = new double[3];
        boolean useAxisOffsets = false;
        double xLeft = this.innerAxisBounds.x;
        double xRight = xLeft + (double)this.innerAxisBounds.width;
        double yTop = useAxisOffsets ? (double)this.outerAxisBounds.y : (double)this.innerAxisBounds.y;
        double yBottom = yTop + (double)(useAxisOffsets ? this.outerAxisBounds.height : this.innerAxisBounds.height);
        int height = this.innerAxisBounds.height;
        int blockOffset = QCShewhart.getBlockOffset((byte)1);
        int glyphOffset = QCShewhart.getGlyphOffset((byte)1);
        boolean offset = false;
        double[][] pLine = this.data;
        QCBlockOverlay phaseRef = this.chart.getRefOverlay(QCBlockOverlay.BlockType.PHASEREF);
        QCBlockOverlay refOverlay = blockRef = this.chart.getRefOverlay(QCBlockOverlay.BlockType.BLOCKREF);
        boolean bl = phaseLimits = refOverlay != null && refOverlay.usePhaseLimits();
        if (!phaseLimits && pLine != null) {
            Rectangle r;
            int nPts = this.dataN;
            int i = 0;
            double x = pLine[i][0];
            double y = pLine[i][1];
            boolean blank = Double.isNaN(y);
            for (i = 0; i < nPts; ++i) {
                x = pLine[i][0];
                y = pLine[i][1];
                this.project(x, y, 0.0, temp);
                double dx = (double)offset;
                float fx = (float)(temp[0] - dx);
                float fy = (float)temp[1];
                if (Double.isNaN(temp[1])) {
                    if (blank) continue;
                    if (area == null) {
                        area = new Area();
                    }
                    r = new Rectangle();
                    r.x = (int)xLeft + 1;
                    r.y = (int)yTop;
                    r.width = (int)(fx - (float)r.x);
                    r.height = height;
                    area.add(new Area(r));
                    blank = true;
                    continue;
                }
                if (blank) {
                    xLeft = fx;
                }
                blank = false;
            }
            if (area != null && !blank) {
                r = new Rectangle();
                r.x = (int)xLeft + 1;
                r.y = (int)yTop;
                r.width = (int)(xRight - (double)r.x);
                r.height = height;
                area.add(new Area(r));
            }
        }
        return area;
    }

    @Override
    public boolean project(double x, double y, double z, double[] r) {
        double xValue;
        ContinuousRangeToNumericMapper xMap;
        if (this.xvalueMapper instanceof ContinuousRangeToNumericMapper) {
            xMap = (ContinuousRangeToNumericMapper)this.xvalueMapper;
            xValue = xMap.getValue(x);
        } else if (this.xvalueMapper instanceof StringToNumericMapper) {
            xMap = (StringToNumericMapper)this.xvalueMapper;
            try {
                int i = (int)x;
                if (x == (double)i) {
                    xValue = xMap.getValue(i);
                }
                double dataMin = QCShewhart.getLowerSubgrpIndex(this.model);
                double dataMax = QCShewhart.getUpperSubgrpIndex(this.model);
                double dataRange = dataMax - dataMin;
                double xMin = this.innerAxisBounds.getX();
                double axisWidth = this.innerAxisBounds.getWidth();
                xValue = dataRange == 0.0 ? xMin : (x - dataMin) / dataRange * axisWidth;
            }
            catch (MissingValueException mve) {
                return false;
            }
        } else {
            r[0] = Double.NaN;
            r[1] = Double.NaN;
            r[2] = Double.NaN;
            return false;
        }
        ContinuousRangeToNumericMapper yMap = (ContinuousRangeToNumericMapper)this.yvalueMapper;
        double xorigin = this.innerAxisBounds.getX();
        double yorigin = this.outerAxisBounds.getY();
        double yAxisUpper = this.yEncoder.getUpperLimit();
        r[0] = xorigin + xValue;
        r[1] = yorigin + yAxisUpper - yMap.getValue(y);
        r[2] = 0.0;
        return true;
    }

    @Override
    public boolean uproject(double x, double y, double z, double[] r) {
        double xValue;
        ContinuousRangeToNumericMapper xMap;
        if (this.xvalueMapper instanceof ContinuousRangeToNumericMapper) {
            xMap = (ContinuousRangeToNumericMapper)this.xvalueMapper;
            xValue = xMap.getValue(x);
        } else if (this.xvalueMapper instanceof StringToNumericMapper) {
            xMap = (StringToNumericMapper)this.xvalueMapper;
            try {
                int i = (int)x;
                if (x != (double)i) {
                    System.out.println("QCLimitsOverlay/uproject():  int to double error.");
                }
                xValue = xMap.getValue(i);
            }
            catch (MissingValueException mve) {
                return false;
            }
        } else {
            r[0] = Double.NaN;
            r[1] = Double.NaN;
            r[2] = Double.NaN;
            return false;
        }
        ContinuousRangeToNumericMapper yMap = (ContinuousRangeToNumericMapper)this.yvalueMapper;
        double xorigin = 0.0;
        double yorigin = 0.0;
        double yAxisUpper = this.yEncoder.getUpperLimit();
        r[0] = xorigin + xValue;
        r[1] = yorigin + yAxisUpper - yMap.getValue(y);
        r[2] = 0.0;
        return true;
    }

    private double getSubgrp(double igrp) {
        return this.getSubgrp((int)igrp);
    }

    private double getSubgrp(long igrp) {
        return this.getSubgrp((int)igrp);
    }

    private double getSubgrp(int igrp) {
        int n = this.model.getRowCount();
        if (igrp < 0 || igrp >= n) {
            return Double.NaN;
        }
        double subgrp = this.model.isAvailable(10) ? (this.numericX ? this.model.getDoubleColumn(10)[igrp] : (double)igrp) : (double)igrp;
        return subgrp;
    }

    public static double clipResponse(double y) {
        double d = y;
        return d;
    }

    public void initLineData() {
        boolean phaseLimits;
        QCBlockOverlay phaseRef = this.chart.getRefOverlay(QCBlockOverlay.BlockType.PHASEREF);
        QCBlockOverlay blockRef = this.chart.getRefOverlay(QCBlockOverlay.BlockType.BLOCKREF);
        QCBlockOverlay refOverlay = blockRef;
        boolean bl = phaseLimits = refOverlay != null && refOverlay.usePhaseLimits();
        if (phaseLimits) {
            this.initLine(refOverlay);
        } else {
            this.initLine();
        }
    }

    private double getYValue(int pos) {
        double y;
        boolean phaseLimits;
        QCBlockOverlay phaseRef = this.chart.getRefOverlay(QCBlockOverlay.BlockType.PHASEREF);
        QCBlockOverlay blockRef = this.chart.getRefOverlay(QCBlockOverlay.BlockType.BLOCKREF);
        QCBlockOverlay refOverlay = blockRef;
        boolean bl = phaseLimits = refOverlay != null && refOverlay.usePhaseLimits();
        if (phaseLimits) {
            int igrp;
            int iphase;
            if (pos == 0) {
                iphase = 0;
                igrp = 0;
            } else {
                iphase = refOverlay.getPhaseIndicesN() - 1;
                igrp = this.phaseDataN[iphase] - 1;
            }
            double x = this.phaseData[iphase][igrp][0];
            y = this.phaseData[iphase][igrp][1];
        } else {
            int igrp = pos == 0 ? 0 : this.dataN - 1;
            double x = this.data[igrp][0];
            y = this.data[igrp][1];
        }
        return y;
    }

    private void initLine(QCBlockOverlay phase) {
        Vector<QCBlockOverlay.BlockEntry> indices = phase.getPhaseIndices();
        int nIndices = phase.getPhaseIndicesN();
        this.phaseData = new double[nIndices][][];
        this.phaseDataN = new int[nIndices];
        this.phaseFixed = new boolean[nIndices];
        this.phaseValue = new double[nIndices];
        boolean consolidate = true;
        boolean fixedPhaseLimit = false;
        for (int iIndex = 0; iIndex < nIndices; ++iIndex) {
            QCBlockOverlay.BlockEntry entry = indices.get(iIndex);
            if (entry.limits) {
                int last = entry.last - 1;
                int nData = this.initLine(entry.first, last, consolidate);
                boolean bl = fixedPhaseLimit = !Double.isNaN(this.phaseTest);
                if (fixedPhaseLimit) {
                    this.phaseFixed[iIndex] = true;
                    this.phaseValue[iIndex] = this.phaseTest;
                } else {
                    this.phaseFixed[iIndex] = false;
                    this.phaseValue[iIndex] = Double.NaN;
                }
                this.phaseData[iIndex] = new double[nData][2];
                this.phaseDataN[iIndex] = nData;
                for (int i = 0; i < nData; ++i) {
                    this.phaseData[iIndex][i][0] = this.data[i][0];
                    this.phaseData[iIndex][i][1] = this.data[i][1];
                }
                this.data = null;
                this.dataN = 0;
                continue;
            }
            this.phaseData[iIndex] = null;
            this.phaseDataN[iIndex] = 0;
        }
    }

    private int initLine() {
        int igrpLower = QCShewhart.getLowerSubgrpIndex(this.model);
        int igrpUpper = QCShewhart.getUpperSubgrpIndex(this.model);
        boolean consolidate = false;
        int n = this.initLine(igrpLower, igrpUpper, consolidate);
        return n;
    }

    private int initLine(int first, int last, boolean consolidate) {
        int j;
        boolean step;
        this.data = null;
        this.dataN = 0;
        this.values = this.fixed ? null : this.model.getDoubleColumn(11);
        this.phaseTest = Double.NaN;
        int nObs = this.model.getRowCount();
        if (first == -1) {
            first = 0;
        } else {
            first = Math.min(nObs - 1, first);
            first = Math.max(0, first);
        }
        if (last == -1) {
            last = nObs - 1;
        } else {
            last = Math.min(nObs - 1, last);
            last = Math.max(0, last);
        }
        int nSubgrp = last - first + 1;
        int nPts = this.fixed ? 2 : 2 * nSubgrp;
        boolean bl = step = !this.fixed;
        if (nPts == 0) {
            return 0;
        }
        double[][] pLine = new double[nPts][2];
        if (this.fixed) {
            this.phaseTest = this.value;
            j = 0;
            pLine[j][0] = this.getSubgrp(first);
            pLine[j][1] = this.value;
            pLine[++j][0] = this.getSubgrp(last);
            pLine[j][1] = this.value;
            ++j;
        } else {
            double[] d = this.model.getDoubleColumn(11);
            if (nSubgrp == 1) {
                this.phaseTest = this.value;
                j = 0;
                pLine[j][0] = this.getSubgrp(first);
                pLine[j][1] = d[first];
                pLine[++j][0] = this.getSubgrp(last);
                pLine[j][1] = d[last];
                ++j;
            } else {
                QCStepType stepType = QCStepType.ALIGN_CENTER;
                double[] prev = new double[2];
                int i = first;
                double x = this.getSubgrp(i);
                double y = d[i];
                if (Double.isNaN(y)) {
                    this.phaseBreak = true;
                }
                j = 0;
                pLine[j][0] = x;
                pLine[j][1] = y;
                this.phaseTest = y;
                ++i;
                ++j;
                while (i <= last) {
                    prev[0] = x;
                    prev[1] = y;
                    x = this.getSubgrp(i);
                    y = d[i];
                    if (Double.isNaN(y)) {
                        this.phaseBreak = true;
                    }
                    if (Double.isNaN(y) || Double.isNaN(prev[1])) {
                        pLine[j][0] = x;
                        pLine[j][1] = y;
                        ++j;
                    } else if (step) {
                        if (y == prev[1]) {
                            if (!consolidate || i == last) {
                                pLine[j][0] = x;
                                pLine[j][1] = y;
                                ++j;
                            }
                        } else {
                            this.phaseTest = Double.NaN;
                            switch (stepType.ordinal()) {
                                case 1: {
                                    double half;
                                    pLine[j][0] = half = (prev[0] + x) / 2.0;
                                    pLine[j][1] = prev[1];
                                    pLine[++j][0] = half;
                                    pLine[j][1] = y;
                                    ++j;
                                    break;
                                }
                                case 2: {
                                    pLine[j][0] = x;
                                    pLine[j][1] = prev[1];
                                    pLine[++j][0] = x;
                                    pLine[j][1] = y;
                                    ++j;
                                    break;
                                }
                                case 0: {
                                    pLine[j][0] = prev[0];
                                    pLine[j][1] = prev[1];
                                    pLine[++j][0] = prev[0];
                                    pLine[j][1] = y;
                                    ++j;
                                }
                            }
                        }
                    } else {
                        pLine[j][0] = x;
                        pLine[j][1] = y;
                        ++j;
                    }
                    ++i;
                }
            }
        }
        this.data = pLine;
        this.dataN = j;
        return j;
    }

    public void initLastNonMissingIndex() {
        this.getLastNonMissingIndex();
    }

    private int getLastNonMissingIndex() {
        int igrpLower = QCShewhart.getLowerSubgrpIndex(this.model);
        int igrpUpper = QCShewhart.getUpperSubgrpIndex(this.model);
        int lastIndex = -1;
        double lastValue = Double.NaN;
        if (this.fixed) {
            lastIndex = igrpUpper;
            lastValue = this.value;
        } else {
            double[] values = this.model.getDoubleColumn(11);
            if (igrpLower == igrpUpper) {
                lastIndex = igrpUpper;
                lastValue = values[igrpUpper];
            } else {
                for (int i = igrpUpper; i >= igrpLower; --i) {
                    double x = this.getSubgrp(i);
                    double y = values[i];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    lastIndex = i;
                    lastValue = y;
                    break;
                }
            }
        }
        this.lastNonMissingIndex = lastIndex;
        this.lastNonMissingValue = lastValue;
        return lastIndex;
    }

    public void setLabelPosition(QCVaryLine.LabelPos position) {
        this.labelPosition = position;
    }

    public Insets getPreferredOuterMargin() {
        if (this.labelString != null && this.labelPosition == QCVaryLine.LabelPos.OUTER_RIGHT) {
            return this.getLabelMargin();
        }
        return zeroInsets;
    }

    private Insets getLabelMargin() {
        Insets labelMargin = new Insets(0, 0, 0, 0);
        int yoffset = QCMargins.getBlockX();
        int xoffset = QCMargins.getDefaultX();
        FontMetrics fm = StatGraph.getFontMetrics((Font)this.labelStyle.getFont());
        int tw = fm.stringWidth(" " + this.labelString + " ");
        labelMargin.right = Math.max(labelMargin.right, tw + xoffset);
        return labelMargin;
    }

    private static enum QCStepType {
        ALIGN_LEFT,
        ALIGN_CENTER,
        ALIGN_RIGHT;

    }
}

