/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.overlays;

import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCVMaskConnector;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCLimitsOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCVMask;
import com.sas.analytics.qc.statgraph.sgchart.util.BBox;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.text.Format;

public class QCVMaskOverlay
extends QCLimitsOverlay {
    private QCVMask vmask = null;
    private QCVMaskConnector vmaskConnector = null;

    @Override
    public boolean displayLimits() {
        boolean display = this.vmask.display;
        return display;
    }

    @Override
    public void drawInFill(Graphics p, boolean highlightDraw) {
        if (!this.getInFill()) {
            return;
        }
        if (this.networkRoot == null) {
            return;
        }
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        Graphics2D g = (Graphics2D)p;
        Composite old = g.getComposite();
        float op = highlightDraw ? this.overlapOpacity : 1.0f;
        AlphaComposite ac = AlphaComposite.getInstance(3, op);
        g.setComposite(ac);
        BooleanProperty fillOn = this.vmaskConnector.fillOn;
        BooleanProperty lineOn = this.vmaskConnector.lineOn;
        boolean limits = lineOn.getValue();
        boolean infill = fillOn.getValue();
        lineOn.setValue(false);
        fillOn.setValue(true);
        this.networkRoot.draw(this.channel, false);
        lineOn.setValue(limits);
        fillOn.setValue(infill);
        g.setComposite(old);
    }

    @Override
    public void drawLimits(Graphics p, boolean highlightDraw) {
        if (this.networkRoot == null) {
            return;
        }
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        Graphics2D g = (Graphics2D)p;
        Composite old = g.getComposite();
        float op = highlightDraw ? this.overlapOpacity : 1.0f;
        AlphaComposite ac = AlphaComposite.getInstance(3, op);
        g.setComposite(ac);
        BooleanProperty fo = this.vmaskConnector.fillOn;
        BooleanProperty lo = this.vmaskConnector.lineOn;
        boolean limits = lo.getValue();
        boolean infill = fo.getValue();
        lo.setValue(true);
        fo.setValue(false);
        this.networkRoot.draw(this.channel, false);
        lo.setValue(limits);
        fo.setValue(infill);
        g.setComposite(old);
    }

    @Override
    public boolean connectNetwork() {
        if (!this.needConnect) {
            return true;
        }
        if (this.xRange == null) {
            return false;
        }
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        this.networkRoot.removeAllElements();
        SASFormat format = this.xEncoder.getInput().getFormat();
        if (format != null && this.xvalueVar != null) {
            this.xvalueVar.setFormat(new GTKFormat((Format)format));
        }
        ValueMap xMap = this.xEncoder.getValueMap();
        if (this.numericX) {
            if (!(xMap instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            if (this.xvalueMapper == null || !(this.xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                this.xvalueMapper = new ContinuousRangeToNumericMapper();
            }
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)xMap);
        } else {
            if (!(xMap instanceof StringToNumericMap)) {
                return false;
            }
            if (this.xvalueMapper == null || !(this.xvalueMapper instanceof StringToNumericMapper)) {
                this.xvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)xMap);
        }
        ValueMap yMap = this.yEncoder.getValueMap();
        if (!(yMap instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        if (this.yvalueMapper == null || !(this.yvalueMapper instanceof ContinuousRangeToNumericMapper)) {
            this.yvalueMapper = new ContinuousRangeToNumericMapper();
        }
        ((ContinuousRangeToNumericMapper)this.yvalueMapper).setMap((ContinuousRangeToNumericMap)yMap);
        Object linePatternMapper = null;
        Object fillColorMapper = null;
        Object lineColorMapper = null;
        Object lineWidthMapper = null;
        this.buildVMaskConnector();
        this.vmask.computeDataMask(this.xvalueMapper);
        this.needConnect = false;
        return true;
    }

    private void buildVMaskConnector() {
        ContinuousRangeToNumericMapper xmaskMapper = new ContinuousRangeToNumericMapper();
        ContinuousRangeToNumericMapper ymaskMapper = new ContinuousRangeToNumericMapper();
        xmaskMapper.shareMap((ContinuousRangeToNumericMapper)this.xvalueMapper);
        ymaskMapper.shareMap((ContinuousRangeToNumericMapper)this.yvalueMapper);
        NumericVector nx = null;
        NumericVector ny = null;
        this.vmaskConnector = new QCVMaskConnector();
        double xLeft = this.xEncoder.getLowerLimit();
        double xLower = this.numericX ? ((ContinuousRangeToNumericMapper)this.xvalueMapper).getInverseValue(xLeft) : ((ContinuousRange)this.xRange).getMin();
        double xUpper = this.vmask.originX;
        double dx = Math.abs(xUpper - xLower);
        if (dx < 1.0E-4) {
            this.vmaskConnector.setDegenerate(xUpper, xmaskMapper);
        }
        nx = new NumericVector();
        ny = new NumericVector();
        double yValue = this.vmask.getUCL(xLower);
        nx.addValue(xLower);
        ny.addValue(yValue);
        yValue = this.vmask.getUCL(xUpper);
        nx.addValue(xUpper);
        ny.addValue(yValue);
        yValue = this.vmask.getLCL(xUpper);
        nx.addValue(xUpper);
        ny.addValue(yValue);
        yValue = this.vmask.getLCL(xLower);
        nx.addValue(xLower);
        ny.addValue(yValue);
        if (this.numericX) {
            xmaskMapper.input.connectFrom((NumericPipe)nx);
        }
        ymaskMapper.input.connectFrom((NumericPipe)ny);
        this.vmaskConnector.pointX.connectFrom((NumericPipe)xmaskMapper);
        this.vmaskConnector.pointY.connectFrom((NumericPipe)ymaskMapper);
        LineAttrs la = this.getLimitLineAttrs(0);
        this.uclLineColor.setValue(this.applyDataTransparency((ColorAttr)la));
        this.uclLineWidth.setValue((double)la.getWidth());
        this.uclLinePattern.setValue(la.getLinePattern());
        this.infillColor.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
        this.vmaskConnector.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
        this.vmaskConnector.setConnectionOrder(0);
        this.vmaskConnector.setSkipMissingOn(true);
        this.vmaskConnector.fillOn.setValue(this.fillOn);
        this.vmaskConnector.fillColor.connectFrom((ColorPipe)this.infillColor);
        this.vmaskConnector.color.connectFrom((ColorPipe)this.uclLineColor);
        this.vmaskConnector.linePattern.connectFrom((IntegerPipe)this.uclLinePattern);
        this.vmaskConnector.lineWidth.connectFrom((NumericPipe)this.uclLineWidth);
        boolean b = this.getLimitLineOn(0);
        this.vmaskConnector.lineOn.setValue(b);
        this.vmaskConnector.selectEnabled.setValue(this.selectable);
        this.vmaskConnector.setUserData(this.probe);
        this.vmaskConnector.setSVGRender(StatGraph.VGF);
        this.vmaskConnector.setSVGRender(true);
        BBox frame = this.translateAxisBounds(true);
        this.vmaskConnector.setFrame(frame);
        this.networkRoot.addElement((Element)this.vmaskConnector);
    }

    private Area getInfillArea(Rectangle r, boolean maskMissingPhases, boolean useAxisOffsets, boolean useExtendedRange) {
        Area area = null;
        GeneralPath polygon = null;
        boolean screenCoordinates = true;
        if (!this.vmask.getScreenCoordinates(this)) {
            return null;
        }
        polygon = new GeneralPath(0, 4);
        Point2D.Double pt = this.vmask.getVMaskUL(screenCoordinates);
        polygon.moveTo(((Point2D)pt).getX(), ((Point2D)pt).getY());
        if (this.debugFill) {
            System.out.println("Fill 0: " + (int)((Point2D)pt).getX() + ", " + (int)((Point2D)pt).getY());
        }
        pt = this.vmask.getVMaskUR(screenCoordinates);
        polygon.lineTo(((Point2D)pt).getX(), ((Point2D)pt).getY());
        if (this.debugFill) {
            System.out.println("Fill 1: " + (int)((Point2D)pt).getX() + ", " + (int)((Point2D)pt).getY());
        }
        pt = this.vmask.getVMaskLR(screenCoordinates);
        polygon.lineTo(((Point2D)pt).getX(), ((Point2D)pt).getY());
        if (this.debugFill) {
            System.out.println("Fill 2: " + (int)((Point2D)pt).getX() + ", " + (int)((Point2D)pt).getY());
        }
        pt = this.vmask.getVMaskLL(screenCoordinates);
        polygon.lineTo(((Point2D)pt).getX(), ((Point2D)pt).getY());
        if (this.debugFill) {
            System.out.println("Fill 3: " + (int)((Point2D)pt).getX() + ", " + (int)((Point2D)pt).getY());
        }
        polygon.closePath();
        area = new Area(polygon);
        return area;
    }

    private Area getOutfillArea(boolean maskMissingPhases, boolean useAxisOffsets) {
        if (this.outfillArea != null) {
            return this.outfillArea;
        }
        Area area = null;
        GeneralPath polygon = null;
        if (!this.vmask.getScreenCoordinates(this)) {
            return null;
        }
        double xLeft = this.innerAxisBounds.x;
        double xRight = xLeft + (double)this.innerAxisBounds.width;
        double yTop = useAxisOffsets ? (double)this.outerAxisBounds.y : (double)this.innerAxisBounds.y;
        double yBottom = yTop + (double)(useAxisOffsets ? this.outerAxisBounds.height : this.innerAxisBounds.height);
        double[] temp = new double[3];
        boolean screenCoordinates = true;
        this.project(this.vmask.originX, this.vmask.originY, 0.0, temp);
        double xOrigin = temp[0];
        double vUpper = this.vmask.getVMaskUL(screenCoordinates).getY();
        double vOriginUpper = this.vmask.getVMaskUR(screenCoordinates).getY();
        double vLower = this.vmask.getVMaskLL(screenCoordinates).getY();
        double vOriginLower = this.vmask.getVMaskLR(screenCoordinates).getY();
        polygon = new GeneralPath(0, 8);
        if (vOriginUpper < yTop) {
            polygon.moveTo(xRight, yTop);
            polygon.lineTo(xOrigin, yTop);
        } else if (vUpper < yTop) {
            polygon.moveTo(xRight, vUpper);
            polygon.lineTo(xLeft, vUpper);
            polygon.lineTo(xOrigin, vOriginUpper);
        } else {
            polygon.moveTo(xRight, yTop);
            polygon.lineTo(xLeft, yTop);
            polygon.lineTo(xLeft, vUpper);
            polygon.lineTo(xOrigin, vOriginUpper);
        }
        if (vOriginLower > yBottom) {
            polygon.lineTo(xOrigin, yBottom);
            polygon.lineTo(xRight, yBottom);
        } else if (vLower > yBottom) {
            polygon.lineTo(xOrigin, vOriginLower);
            polygon.lineTo(xLeft, vLower);
            polygon.lineTo(xRight, vLower);
        } else {
            polygon.lineTo(xOrigin, vOriginLower);
            polygon.lineTo(xLeft, vLower);
            polygon.lineTo(xLeft, yBottom);
            polygon.lineTo(xRight, yBottom);
        }
        polygon.closePath();
        this.outfillArea = area = new Area(polygon);
        return area;
    }

    @Override
    public Area getMaskingArea(Graphics p, int iBand) {
        Point2D pt;
        Graphics2D g = (Graphics2D)p;
        if (this.needConnect && !this.connectNetwork()) {
            return null;
        }
        Area area = null;
        Area poly = null;
        GeneralPath polygon = null;
        boolean useAxisOffsets = true;
        boolean useExtendedRange = true;
        double[] temp = new double[3];
        int xLeft = this.outerAxisBounds.x;
        int xRight = xLeft + this.outerAxisBounds.width;
        int yTop = useAxisOffsets ? this.outerAxisBounds.y : this.innerAxisBounds.y;
        int yBottom = yTop + (useAxisOffsets ? this.outerAxisBounds.height : this.innerAxisBounds.height);
        int yFrame = iBand == 0 ? yTop : yBottom;
        int blockOffset = QCShewhart.getBlockOffset((byte)1);
        int glyphOffset = QCShewhart.getGlyphOffset((byte)1);
        boolean offset = false;
        boolean screenCoordinates = true;
        if (!this.vmask.getScreenCoordinates(this)) {
            return null;
        }
        area = new Area();
        polygon = new GeneralPath(0, 4);
        polygon.moveTo(xLeft, yFrame);
        if (this.debugFill) {
            pt = polygon.getCurrentPoint();
            System.out.println("Mask 0: " + (int)pt.getX() + ", " + (int)pt.getY());
        }
        if (iBand == 0) {
            pt = this.vmask.getVMaskUL(screenCoordinates);
            polygon.lineTo(pt.getX(), pt.getY());
            if (this.debugFill) {
                System.out.println("Mask 1: " + (int)pt.getX() + ", " + (int)pt.getY());
            }
            pt = this.vmask.getVMaskUR(screenCoordinates);
            polygon.lineTo(pt.getX(), pt.getY());
            if (this.debugFill) {
                System.out.println("Mask 2: " + (int)pt.getX() + ", " + (int)pt.getY());
            }
        } else {
            pt = this.vmask.getVMaskLL(screenCoordinates);
            polygon.lineTo(pt.getX(), pt.getY());
            if (this.debugFill) {
                System.out.println("Mask 1: " + (int)pt.getX() + ", " + (int)pt.getY());
            }
            pt = this.vmask.getVMaskLR(screenCoordinates);
            polygon.lineTo(pt.getX(), pt.getY());
            if (this.debugFill) {
                System.out.println("Mask 2: " + (int)pt.getX() + ", " + (int)pt.getY());
            }
        }
        pt = polygon.getCurrentPoint();
        polygon.lineTo(pt.getX(), (double)yFrame);
        if (this.debugFill) {
            pt = polygon.getCurrentPoint();
            System.out.println("Mask 3: " + (int)pt.getX() + ", " + (int)pt.getY());
        }
        polygon.closePath();
        poly = new Area(polygon);
        area.add(poly);
        if (this.debugFill) {
            System.out.println("\n");
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(Color.PINK);
            g.setClip(null);
            g.fill(area);
        }
        return area;
    }

    @Override
    public boolean isOutOfControl(QCOverlay response) {
        boolean ooc = false;
        CRD rm = response.getModel();
        int nObs = rm.getRowCount();
        int nPts = QCShewhart.getNPts();
        double[] x = response.getDoubleColumn(10);
        double[] y = response.getDoubleColumn(11);
        int first = 0;
        int last = nObs;
        for (int i = first; i < last; ++i) {
            double d = y[i];
            if (Double.isNaN(d)) continue;
            double l = this.vmask.getLCL(x[i]);
            if (!Double.isNaN(l) && d < l) {
                ooc = true;
                break;
            }
            double u = this.vmask.getUCL(x[i]);
            if (Double.isNaN(u) || !(d > u)) continue;
            ooc = true;
            break;
        }
        QCShewhart.resetNPts();
        return ooc;
    }

    @Override
    public QCVMask getVMask() {
        return this.vmask;
    }

    @Override
    public void setVMask(QCVMask vm, QCLimitsOverlay.QCLimitScheme type) {
        this.vmask = vm;
        this.vmask.schemeType = type;
        this.schemeType = type;
    }

    @Override
    public QCOverlay.QCClipType getClipType() {
        return QCOverlay.QCClipType.OUTER_X;
    }

    @Override
    public void setDrawingArea(Rectangle inner, Rectangle inner2, Rectangle outer) {
        super.setDrawingArea(inner, inner2, outer);
        int x = this.outerAxisBounds.x;
        int width = this.outerAxisBounds.width;
        int y = this.outerAxisBounds.y + this.innerAxisBounds.y;
        int height = this.innerAxisBounds.height;
        Rectangle r = new Rectangle(x, y, width, height);
        this.vmask.setDrawingArea(r);
    }
}

