/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.overlays;

import com.sas.analytics.qc.statgraph.QCStylizedTextElement;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.gtk.TextStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Vector;

public class QCStylizedText {
    protected static final char[] DELIM_LINE = System.getProperty("line.separator").toCharArray();
    public String label;
    public Vector<QCStylizedTextElement> labelAttributes;
    public AttributedString labelAS;
    public String glyph;
    public Vector<QCStylizedTextElement> glyphAttributes;
    public AttributedString glyphAS;
    protected TextStyle textStyle = new TextStyle();
    protected TextStyle unicodeStyle;
    protected TextStyle xsymStyle;
    protected TextStyle bar2Style;
    protected Font xsymFont = null;
    protected int ibar2 = -1;
    protected Font bar2Font = null;
    private boolean updateTextLayout = true;
    protected Rectangle bounds = new Rectangle();
    protected float ascentReal;
    protected float ascent;
    protected float descent;
    protected float leading;
    protected int x;
    protected int y;

    public QCStylizedText() {
    }

    public QCStylizedText(String s) {
        this.label = s;
        this.labelAttributes = null;
        this.glyph = null;
        this.glyphAttributes = null;
        this.build();
    }

    public QCStylizedText(String s, Vector sAttr) {
        this.label = s;
        this.labelAttributes = sAttr == null ? null : new Vector(sAttr);
        this.glyph = null;
        this.glyphAttributes = null;
        this.build();
    }

    public QCStylizedText(String s, Vector sAttr, String g, Vector gAttr) {
        this.label = s;
        this.labelAttributes = sAttr == null ? null : new Vector(sAttr);
        this.glyph = g;
        this.glyphAttributes = gAttr == null ? null : new Vector(gAttr);
        this.build();
    }

    public void dispose() {
    }

    public void setText(String s, Vector sAttr) {
        this.label = s;
        this.labelAttributes = sAttr == null ? null : new Vector(sAttr);
    }

    public void setText(String s, Vector sAttr, String g, Vector gAttr) {
        this.label = s;
        this.labelAttributes = sAttr == null ? null : new Vector(sAttr);
        this.glyph = g;
        this.glyphAttributes = gAttr == null ? null : new Vector(gAttr);
    }

    public void setUnicodeStyle(TextStyle style) {
        this.unicodeStyle = style;
    }

    public void setXsymStyle(TextStyle style) {
        this.xsymStyle = style;
    }

    public void setBar2Style(TextStyle style) {
        this.bar2Style = style;
    }

    public boolean buildJ2D() {
        return true;
    }

    public boolean build() {
        Font font;
        QCStylizedTextElement ue;
        int j;
        int nAttr;
        AttributedString as;
        Color transparentColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        Font uniCodeFont = this.unicodeStyle.getFont();
        Font labelFont = this.textStyle.getFont();
        Color labelColor = this.textStyle.getColor();
        double adjustSize = 1.0;
        Font qcFontSans = QCStylizedText.getQCFont(this.textStyle, adjustSize, false);
        Font qcFontSerif = QCStylizedText.getQCFont(this.textStyle, adjustSize, true);
        boolean testunicodefont = false;
        if (testunicodefont) {
            this.xsymFont = QCStylizedText.getBar2Font(this.xsymStyle);
            this.bar2Font = QCStylizedText.getBar2Font(this.bar2Style);
        } else {
            this.xsymFont = QCStylizedText.getBar2Font(this.textStyle);
            this.bar2Font = QCStylizedText.getBar2Font(this.textStyle);
        }
        if (this.labelAttributes != null) {
            as = new AttributedString(this.label);
            as.addAttribute(TextAttribute.FONT, labelFont);
            as.addAttribute(TextAttribute.FOREGROUND, labelColor);
            nAttr = this.labelAttributes.size();
            for (j = 0; j < nAttr; ++j) {
                ue = this.labelAttributes.get(j);
                if (ue.attr == TextAttribute.FONT) {
                    font = ue.value.equalsIgnoreCase("QCFONT") ? qcFontSans : uniCodeFont;
                    as.addAttribute(TextAttribute.FONT, font, ue.index[0], ue.index[1]);
                    continue;
                }
                if (ue.attr == TextAttribute.CHAR_REPLACEMENT) {
                    as.addAttribute(TextAttribute.FOREGROUND, transparentColor, ue.index[0], ue.index[1]);
                    continue;
                }
                if (ue.attr != TextAttribute.SIZE) continue;
            }
            this.labelAS = as;
        }
        if (this.glyph != null) {
            this.glyphAS = as = new AttributedString(this.glyph);
            this.glyphAS.addAttribute(TextAttribute.FONT, labelFont);
            this.glyphAS.addAttribute(TextAttribute.FOREGROUND, transparentColor);
            if (this.glyphAttributes != null) {
                nAttr = this.glyphAttributes.size();
                for (j = 0; j < nAttr; ++j) {
                    ue = this.glyphAttributes.get(j);
                    if (ue.attr == TextAttribute.FONT) {
                        font = ue.value.equalsIgnoreCase("QCFONT") ? qcFontSans : uniCodeFont;
                        as.addAttribute(TextAttribute.FONT, font, ue.index[0], ue.index[1]);
                        continue;
                    }
                    if (ue.attr == TextAttribute.CHAR_REPLACEMENT) {
                        as.addAttribute(TextAttribute.FOREGROUND, labelColor, ue.index[0], ue.index[1]);
                        continue;
                    }
                    if (ue.attr != TextAttribute.SIZE) continue;
                }
            }
        }
        return true;
    }

    public void draw(Graphics2D g) {
        this.draw(g, this.x, this.y);
    }

    public void draw(Graphics2D g, int x, int y) {
        if (g == null) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        TextStyle ts = this.textStyle;
        Font labelFont = ts.getFont();
        Color labelColor = ts.getColor();
        Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(1.0f));
        g.setFont(labelFont);
        g.setColor(labelColor);
        this.buildJ2D();
        FontRenderContext frc = g.getFontRenderContext();
        if (this.labelAS == null) {
            if (this.label != null && this.label.length() > 0) {
                if (this.ibar2 > 0) {
                    int dx;
                    Rectangle2D r2;
                    TextLayout tl;
                    String s2;
                    String s1;
                    boolean testunicodefont = false;
                    if (testunicodefont) {
                        String s0 = this.label.substring(0, this.ibar2);
                        s1 = this.label.substring(this.ibar2, this.ibar2 + 1);
                        s2 = this.label.substring(this.ibar2 + 1);
                        tl = new TextLayout(s0, this.xsymFont, frc);
                        r2 = tl.getBounds();
                        dx = (int)((double)tl.getAdvance() + 0.5);
                        g.setFont(this.xsymFont);
                        g.drawString(s0, x, y);
                        x += dx;
                    } else {
                        s1 = this.label.substring(this.ibar2 - 1, this.ibar2 + 1);
                        s2 = this.label.substring(this.ibar2 + 1);
                    }
                    tl = new TextLayout(s1, this.bar2Font, frc);
                    r2 = tl.getBounds();
                    dx = (int)((double)tl.getAdvance() + 0.5);
                    g.setFont(this.bar2Font);
                    g.drawString(s1, x, y);
                    g.setFont(labelFont);
                    g.drawString(s2, x += dx, y);
                } else {
                    g.drawString(this.label, x, y);
                }
            }
        } else {
            AttributedCharacterIterator iter;
            AttributedCharacterIterator attributedCharacterIterator = iter = this.glyphAS == null ? null : this.glyphAS.getIterator();
            if (iter != null) {
                TextLayout tl = new TextLayout("\u033f", labelFont, frc);
                Rectangle2D r2 = tl.getBounds();
                double hbar2 = r2.getHeight();
                int glyphOffset = (int)((hbar2 + 0.5) / 2.0);
                g.drawString(iter, x, y - glyphOffset);
            }
            iter = this.labelAS.getIterator();
            g.drawString(iter, x, y);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
        g.setStroke(oldStroke);
    }

    public Rectangle getBounds() {
        this.getTextLayout();
        return this.bounds;
    }

    public TextLayout getTextLayout() {
        TextLayout tl;
        this.bounds.x = 0;
        this.bounds.y = 0;
        this.bounds.width = 0;
        this.bounds.height = 0;
        if (this.label == null) {
            return null;
        }
        Graphics p = StatGraph.getGraphics();
        if (p == null) {
            return null;
        }
        Graphics2D g = (Graphics2D)p;
        Font labelFont = this.textStyle.getFont();
        g.setFont(labelFont);
        FontRenderContext fr = g.getFontRenderContext();
        FontRenderContext frc = new FontRenderContext(null, false, false);
        if (this.ibar2 > 0) {
            int height;
            int width;
            boolean testunicodefont = false;
            if (testunicodefont) {
                String s0 = this.label.substring(0, this.ibar2);
                String s1 = this.label.substring(this.ibar2, this.ibar2 + 1);
                String s2 = this.label.substring(this.ibar2 + 1);
                tl = new TextLayout(s0, this.xsymFont, frc);
                Rectangle2D r = tl.getBounds();
                width = (int)((double)tl.getAdvance() + 0.5);
                tl = new TextLayout(s1, this.bar2Font, frc);
                r = tl.getBounds();
                this.ascentReal = (float)r.getHeight();
                this.ascent = tl.getAscent();
                this.descent = tl.getDescent();
                this.leading = tl.getLeading();
                height = (int)(this.ascent + this.descent + this.leading);
                width += (int)((double)tl.getAdvance() + 0.5);
                tl = new TextLayout(s2, labelFont, frc);
                r = tl.getBounds();
                width += (int)((double)tl.getAdvance() + 0.5);
            } else {
                String s1 = this.label.substring(this.ibar2 - 1, this.ibar2 + 1);
                String s2 = this.label.substring(this.ibar2 + 1);
                tl = new TextLayout(s1, this.bar2Font, frc);
                Rectangle2D r = tl.getBounds();
                this.ascentReal = (float)r.getHeight();
                this.ascent = tl.getAscent();
                this.descent = tl.getDescent();
                this.leading = tl.getLeading();
                height = (int)(this.ascent + this.descent + this.leading);
                width = (int)((double)tl.getAdvance() + 0.5);
                tl = new TextLayout(s2, labelFont, frc);
                r = tl.getBounds();
                width += (int)((double)tl.getAdvance() + 0.5);
            }
            this.bounds.x = 0;
            this.bounds.y = 0;
            this.bounds.width = width;
            this.bounds.height = height;
        } else {
            tl = this.labelAS == null ? (this.label == null || this.label.length() == 0 ? null : new TextLayout(this.label, labelFont, frc)) : QCStylizedText.getStringLayout(frc, this.labelAS);
            tl = new TextLayout(this.label, labelFont, frc);
            Rectangle2D r = tl.getBounds();
            this.ascentReal = (float)r.getHeight();
            this.ascent = tl.getAscent();
            this.descent = tl.getDescent();
            this.leading = tl.getLeading();
            int height = (int)(this.ascent + this.descent + this.leading);
            int width = (int)((double)tl.getAdvance() + 0.5);
            this.bounds.x = 0;
            this.bounds.y = 0;
            this.bounds.width = width;
            this.bounds.height = height;
        }
        this.updateTextLayout = false;
        return tl;
    }

    public static final Rectangle2D getStringBounds(FontRenderContext frc, AttributedString as) {
        AttributedCharacterIterator iter = as.getIterator();
        TextLayout t = new TextLayout(iter, frc);
        Rectangle2D r = t.getBounds();
        return r;
    }

    public static final Rectangle2D sizeString(FontRenderContext frc, AttributedString as) {
        return QCStylizedText.getStringBounds(frc, as);
    }

    public static final TextLayout getStringLayout(FontRenderContext frc, AttributedString as) {
        AttributedCharacterIterator iter = as.getIterator();
        TextLayout t = new TextLayout(iter, frc);
        return t;
    }

    public static final Font getFont(TextStyleElement s, double adjust) {
        String family = s.getFontFamily();
        int size = s.getFontSize().getSizeValue();
        int style = s.getFontStyle();
        int weight = s.getFontWeight();
        if (adjust != -1.0) {
            size = (int)((double)size * adjust + 0.5);
        }
        return new Font(family, style + weight, size);
    }

    public static final Font getFont(TextStyleElement s) {
        return QCStylizedText.getFont(s, 1.0);
    }

    public static final Font getFont(TextStyleElement uni, TextStyleElement s, double adjust) {
        String family = uni.getFontFamily();
        int size = s.getFontSize().getSizeValue();
        int style = s.getFontStyle();
        int weight = s.getFontWeight();
        if (adjust != -1.0) {
            size = (int)((double)size * adjust + 0.5);
        }
        return new Font(family, style + weight, size);
    }

    public static final Font getFont(TextStyleElement uni, TextStyleElement s) {
        return QCStylizedText.getFont(uni, s, 1.0);
    }

    public static final Font getXFont(TextStyle s) {
        Font font = s.getFont();
        String family = font.getFamily();
        int size = font.getSize();
        int style = font.getStyle();
        double fuzz = 0.5 * (double)size;
        size += (int)fuzz;
        size = Math.max(size, 15);
        return new Font(family, style, size);
    }

    public static final Font getBar2Font(TextStyle s) {
        if (s == null) {
            return null;
        }
        Font font = s.getFont();
        String family = font.getFamily();
        int size = font.getSize();
        int style = font.getStyle();
        double fuzz = Math.ceil(0.4 * (double)size);
        return new Font(family, style, size += (int)fuzz);
    }

    public static final Font getQCFont(TextStyle s, double adjust, boolean serif) {
        int style;
        int size = s.getFont().getSize();
        int weight = style = s.getFont().getStyle();
        if (adjust != -1.0) {
            size = (int)((double)size * adjust + 0.5);
        }
        String family = s.getFont().getFamily();
        String qcFamily = serif ? "Times New Roman Symbol" : "Arial Symbol";
        Font qcFont = FontManager.getFont((String)qcFamily, (int)(style + weight), (int)size);
        if (!qcFont.getName().equalsIgnoreCase(qcFamily)) {
            System.out.println("Unable to load " + qcFamily + " font.");
            System.out.println(qcFont.getName() + "loaded instead.");
        }
        return qcFont.getName().equalsIgnoreCase(qcFamily) ? qcFont : null;
    }

    public static final Font getQCFont(TextStyle s) {
        return QCStylizedText.getQCFont(s, 1.0, false);
    }

    public static final Font getQCFont(TextStyle s, double adjust) {
        return QCStylizedText.getQCFont(s, adjust, false);
    }

    public static final Font getQCFont(TextStyle s, boolean serif) {
        return QCStylizedText.getQCFont(s, 1.0, serif);
    }

    public void setOrigin(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getHeight() {
        if (this.updateTextLayout) {
            this.getTextLayout();
        }
        return this.bounds.height;
    }

    public int getWidth() {
        if (this.updateTextLayout) {
            this.getTextLayout();
        }
        return this.bounds.width;
    }

    public float getBoundsAscent() {
        if (this.updateTextLayout) {
            this.getTextLayout();
        }
        return this.ascentReal;
    }

    public float getFontAscent() {
        if (this.updateTextLayout) {
            this.getTextLayout();
        }
        return this.ascent;
    }

    public float getFontDescent() {
        if (this.updateTextLayout) {
            this.getTextLayout();
        }
        return this.descent;
    }

    public float getLeading() {
        if (this.updateTextLayout) {
            this.getTextLayout();
        }
        return this.leading;
    }

    protected int[] getLineDelimiterLocations(AttributedCharacterIterator aci) {
        ArrayList<Integer> lineDelimiterList = new ArrayList<Integer>();
        char c = aci.first();
        while (c != '\uffff') {
            if (c == DELIM_LINE[0]) {
                lineDelimiterList.add(aci.getIndex());
            }
            c = aci.next();
        }
        lineDelimiterList.add(aci.getEndIndex() - 1);
        int[] lineDelimiterLocations = new int[lineDelimiterList.size()];
        for (int i = 0; i < lineDelimiterList.size(); ++i) {
            lineDelimiterLocations[i] = (Integer)lineDelimiterList.get(i);
        }
        return lineDelimiterLocations;
    }
}

