/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.overlays;

import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBlockOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCLimitsOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCScatterOverlay;
import com.sas.graphics.applets.statgraph.StatGraph;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.w3c.dom.Element;

public class QCSeriesOverlay
extends QCScatterOverlay {
    public static final String RB_KEY = "QCSeriesOverlay.";

    public QCSeriesOverlay() {
        super(1);
        this.selectable = false;
        this.oocFillType = QCOverlay.QCOutfillType.TRUE;
        this.oocLineType = QCOverlay.QCOutlineType.TRUE;
    }

    @Override
    public boolean isGlyph() {
        return false;
    }

    @Override
    public boolean isTransparent() {
        return false;
    }

    public void loadInternal(StatGraph graph, Element e) {
        if (e == null) {
            return;
        }
    }

    public boolean isOutOfControl(QCLimitsOverlay limits) {
        return limits.isOutOfControl(this);
    }

    @Override
    public void drawOutLine(Graphics p, QCLimitsOverlay limits, boolean callHighlightDraw) {
        if (!limits.isOutOfControl(this)) {
            return;
        }
        super.drawOutLine(p);
    }

    @Override
    public void drawOutFill(Graphics p, QCLimitsOverlay limits, boolean callHighlightDraw) {
        if (this.oocFillType == QCOverlay.QCOutfillType.FALSE) {
            return;
        }
        if (this.oocFillType != QCOverlay.QCOutfillType.FALSE) {
            this.drawOutFill(p, limits, callHighlightDraw, true);
        }
    }

    private void drawOutFill(Object p, QCLimitsOverlay limits, boolean callHighlightDraw, boolean fill) {
        boolean outFillLower;
        int i;
        Area mask;
        if (p == null || limits == null) {
            return;
        }
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.setDrawingArea(this.innerAxisBounds, this.innerAxisBounds2, this.outerAxisBounds);
        Graphics2D g = (Graphics2D)p;
        Shape oldClip = g.getClip();
        Composite oldComp = g.getComposite();
        boolean useOpacity = callHighlightDraw;
        if (fill) {
            AlphaComposite ac;
            if (useOpacity) {
                QCBlockOverlay block = this.chart.getBlockOverlay(QCBlockOverlay.BlockType.BLOCK);
                QCBlockOverlay phase = this.chart.getBlockOverlay(QCBlockOverlay.BlockType.PHASE);
                boolean blocksOn = block == null ? false : block.getRefFill();
                boolean phasesOn = phase == null ? false : phase.getRefFill();
                float alpha = blocksOn || phasesOn ? limits.overlapOpacity : limits.outfillOpacity;
                ac = AlphaComposite.getInstance(3, alpha);
                g.setComposite(ac);
            } else {
                ac = AlphaComposite.getInstance(3, limits.outfillOpacity);
                g.setComposite(ac);
            }
        }
        if (QCShewhart.isClipChartAreaOn()) {
            g.setClip(this.innerAxisBounds.x, this.innerAxisBounds.y, this.innerAxisBounds.width + 1, this.innerAxisBounds.height + 1);
        } else {
            g.setClip(null);
        }
        Stroke oldStroke = g.getStroke();
        BasicStroke stroke = new BasicStroke(fill ? 1.0f : 5.0f, 2, 0, 1.0f);
        g.setStroke(stroke);
        g.setColor(fill ? this.oocFillColor.getValue() : this.oocLineColor.getValue());
        boolean displayUpper = limits.getLimitLineOn(0);
        boolean outFillUpper = this.oocFillType == QCOverlay.QCOutfillType.TRUE || this.oocFillType == QCOverlay.QCOutfillType.UPPER;
        boolean debugFill = false;
        if (displayUpper && outFillUpper) {
            mask = limits.getMaskingArea(g, 0);
            GeneralPath[] areas = limits.getPolygonAreas(this, 0, fill);
            g.setStroke(stroke);
            g.setColor(debugFill ? Color.RED : (fill ? this.oocFillColor.getValue() : this.oocLineColor.getValue()));
            g.setClip(mask);
            if (debugFill) {
                StatGraph.printNote((String)"The RED area defines the area in the chart that is below the data", (boolean)false);
                StatGraph.printNote((String)"The upper COUTFILL areas are any RED areas that are above the UCL", (boolean)false);
                StatGraph.printNote((String)" ", (boolean)false);
            }
            for (i = 0; i < areas.length; ++i) {
                GeneralPath area = areas[i];
                if (debugFill) {
                    g.setClip(null);
                }
                if (area == null) continue;
                if (fill) {
                    g.fill(area);
                    continue;
                }
                g.draw(area);
            }
            g.setClip(null);
        }
        boolean displayLower = limits.getLimitLineOn(1);
        boolean bl = outFillLower = this.oocFillType == QCOverlay.QCOutfillType.TRUE || this.oocFillType == QCOverlay.QCOutfillType.LOWER;
        if (displayLower && outFillLower) {
            mask = limits.getMaskingArea(g, 1);
            GeneralPath[] areas = limits.getPolygonAreas(this, 1, fill);
            g.setStroke(stroke);
            g.setColor(debugFill ? Color.GREEN : (fill ? this.oocFillColor.getValue() : this.oocLineColor.getValue()));
            g.setClip(mask);
            if (debugFill) {
                StatGraph.printNote((String)"The GREEN area defines the area in the chart that is above the data", (boolean)false);
                StatGraph.printNote((String)"The lower COUTFILL areas are any GREEN areas that are below the LCL", (boolean)false);
                StatGraph.printNote((String)" ", (boolean)false);
            }
            for (i = 0; i < areas.length; ++i) {
                GeneralPath area = areas[i];
                if (debugFill) {
                    g.setClip(null);
                }
                if (area == null) continue;
                if (fill) {
                    g.fill(area);
                    continue;
                }
                g.draw(area);
            }
            g.setClip(null);
        }
        if (QCShewhart.isClipChartAreaOn()) {
            g.setClip(null);
        }
        g.setStroke(oldStroke);
        g.setComposite(oldComp);
        g.setClip(oldClip);
    }

    @Override
    public QCOverlay.QCClipType getClipType() {
        return QCOverlay.QCClipType.INNER;
    }
}

