/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.overlays;

import com.sas.analytics.qc.statgraph.QCStylizedTextElement;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBlockOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.util.BBox;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.CurveLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.labeling.CurveGraph;
import com.sas.graphics.applets.statgraph.sgchart.labeling.LabelPlacementInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.FitLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.text.Format;
import java.util.ArrayList;

public class QCReferenceLineOverlay
extends QCOverlay {
    public static final String RB_KEY = "QCReferenceLineOverlay.";
    public static final double LABEL_ADJUST = 3.0;
    protected Object xvalue = null;
    protected Object yvalue = null;
    private Variable xvalueVar = null;
    private Variable yvalueVar = null;
    private Variable yvaluePhaseVar = null;
    private Variable yvalueIndexVar = null;
    private Variable phaseBeginVar = null;
    private Variable phaseEndVar = null;
    private Variable curveLabelVar = null;
    private boolean numericLabel = false;
    private NumericVectorVariable numericXVar;
    private NumericVectorVariable numericYVar;
    protected String curveLabelString = null;
    protected Rectangle clipRect = null;
    protected FontMetrics fm;
    private DataRange xRange = null;
    private DataRange yRange = null;
    private Encoder xEncoder;
    private Encoder yEncoder;
    private LineAttrs lineStyle = new LineAttrs();
    private TextStyle labelStyle = new TextStyle();
    private SASFormat labelFormat = null;
    private int labelPosition = 1;
    public LineSegment line;
    private RasterLabel label;
    private boolean makeLine = true;
    private int curveLabelLocation = 1;
    private RasterLabel boundaryLabel;
    protected boolean clipping = false;
    public QCBlockOverlay phase = null;
    private CurveLabelLayout clLayout;
    private NetworkRoot networkRoot2;
    private NetworkRoot networkRoot3;
    private boolean labelProtected = true;
    protected double discreteOffset = 0.0;
    boolean needConnect2 = true;
    private boolean rotateXCurveLabels = false;
    private boolean rotateX2CurveLabels = false;

    @Override
    public boolean overrideGTLRenderingOrder(boolean highlight) {
        return highlight;
    }

    public CurveLabelLayout getCurveLabelLayout() {
        return this.clLayout;
    }

    public boolean isProtectedLine() {
        return this.labelProtected;
    }

    public void setProtectedLine(boolean b) {
        this.labelProtected = b;
    }

    public void setCurveLabelLayout(CurveLabelLayout l) {
        this.clLayout = l;
    }

    public boolean isCurveLabeled() {
        if (this.curveLabelLocation != 1) {
            return false;
        }
        return this.curveLabelVar != null || this.curveLabelString != null;
    }

    public boolean isClipping() {
        return this.clipping;
    }

    public void setClipping(boolean b) {
        this.clipping = b;
    }

    public void setClipRect(Rectangle r) {
        this.clipRect = r;
    }

    public Object getXValue() {
        return this.xvalue;
    }

    public void setXValue(Object obj) {
        this.xvalue = obj;
        if (obj == null) {
            this.xRange = null;
        } else {
            this.updateXRange();
        }
    }

    public Object getYValue() {
        return this.yvalue;
    }

    public void setYValue(Object obj) {
        this.yvalue = obj;
        if (obj == null) {
            this.yRange = null;
        } else {
            this.updateYRange();
        }
    }

    public NetworkRoot getNetworkRoot() {
        return this.networkRoot;
    }

    public int getCurveLabelLocation() {
        return this.curveLabelLocation;
    }

    public void setCurveLabelLocation(int curveLabelLocation) {
        this.curveLabelLocation = curveLabelLocation;
    }

    public QCReferenceLineOverlay() {
        this.labelStyle.setHorizontalJustification(0);
        this.labelStyle.setVerticalJustification(0);
    }

    public SASFormat getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(SASFormat lf) {
        this.labelFormat = lf;
    }

    public int getCurveLabelPosition() {
        return this.labelPosition;
    }

    public void setCurveLabelPosition(int position) {
        this.labelPosition = position;
    }

    public LineAttrs getLineStyle() {
        return this.lineStyle;
    }

    public Color getLineColor() {
        return this.lineStyle.getColor();
    }

    public int getLinePattern() {
        return this.lineStyle.getLinePattern();
    }

    public void setLineStyle(LineAttrs style) {
        this.lineStyle = style;
    }

    public String getCurveLabelString() {
        return this.curveLabelString;
    }

    public void setCurveLabelString(String aCurveLabelString) {
        this.curveLabelString = aCurveLabelString;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextStyle aLabelStyle) {
        this.labelStyle = aLabelStyle;
    }

    public boolean isHorizontal() {
        return this.xvalue == null && this.xvalueVar == null;
    }

    protected void updateXRange() {
        if (this.isHorizontal() || this.clipping) {
            return;
        }
        DataRange oldRange = this.xRange;
        this.xRange = this.xvalueVar == null ? (this.xvalue instanceof String ? (StatGraph.isNumber((String)((String)this.xvalue)) ? new OrdinalRange(new Object[]{DataModel.defaultFormat.format((Object)new Double((String)this.xvalue)).trim()}, new Object[]{new Double((String)this.xvalue)}, null) : new DiscreteRange((Object[])new String[]{(String)this.xvalue})) : (this.discreteX ? new OrdinalRange(new Object[]{DataModel.defaultFormat.format(this.xvalue).trim()}, new Object[]{this.xvalue}) : new ContinuousRange(((Double)this.xvalue).doubleValue(), ((Double)this.xvalue).doubleValue()))) : (this.xvalueVar instanceof StringVariable ? (this.numericDiscreteX ? this.makeOrdinalRange((StringVariable)this.xvalueVar, this.xvalueVar.getUniqueValueCount(), (NumericVariable)this.numericXVar, (short)10, !this.xUnionAllPages) : this.makeDiscreteRange((StringVariable)this.xvalueVar, this.xvalueVar.getUniqueValueCount(), (short)10, !this.xUnionAllPages)) : this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, !this.xUnionAllPages));
        byte dim = 1;
        RangeChangedEvent rce = null;
        if (oldRange == null && this.xRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, this.xRange, dim);
        } else if (oldRange != null && this.xRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != this.xRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, this.xRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    protected void updateYRange() {
        if (!this.isHorizontal() || this.clipping) {
            return;
        }
        DataRange oldRange = this.yRange;
        this.yRange = this.yvalueVar == null ? (this.yvalue instanceof String ? (StatGraph.isNumber((String)((String)this.yvalue)) ? new OrdinalRange(new Object[]{DataModel.defaultFormat.format((Object)new Double((String)this.yvalue)).trim()}, new Object[]{new Double((String)this.yvalue)}, null) : new DiscreteRange((Object[])new String[]{(String)this.yvalue})) : (this.discreteY ? new OrdinalRange(new Object[]{DataModel.defaultFormat.format(this.yvalue).trim()}, new Object[]{this.yvalue}) : new ContinuousRange(((Double)this.yvalue).doubleValue(), ((Double)this.yvalue).doubleValue()))) : (this.yvalueVar instanceof StringVariable ? (this.numericDiscreteY ? this.makeOrdinalRange((StringVariable)this.yvalueVar, this.yvalueVar.getUniqueValueCount(), (NumericVariable)this.numericYVar, (short)11, !this.yUnionAllPages) : this.makeDiscreteRange((StringVariable)this.yvalueVar, this.yvalueVar.getUniqueValueCount(), (short)11, !this.yUnionAllPages)) : this.makeContinuousRange((NumericVariable)this.yvalueVar, (short)11, !this.yUnionAllPages));
        byte dim = 2;
        RangeChangedEvent rce = null;
        if (oldRange == null && this.yRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, this.yRange, dim);
        } else if (oldRange != null && this.yRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != this.yRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, this.yRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (this.clipping) {
            return null;
        }
        if (dimension == 1) {
            return this.xRange;
        }
        if (dimension == 2) {
            return this.yRange;
        }
        return null;
    }

    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
        }
        return null;
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    public void drawLabels(Graphics g) {
        if (this.networkRoot3 == null) {
            return;
        }
        Channel channel = this.networkRoot3.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot3.draw(channel, false);
    }

    public void drawNoneClipped(Graphics g) {
        if (!this.isCurveLabeled()) {
            return;
        }
        boolean later = false;
        if (later) {
            return;
        }
        if (this.needConnect2) {
            this.connectOutsideLabel();
            this.needConnect2 = false;
        }
        Channel channel = this.networkRoot2.getChannel();
        this.networkRoot2.draw(channel, false);
    }

    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.makeLine();
    }

    private void makeLine() {
        if (!this.makeLine) {
            return;
        }
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
        this.makeLine = false;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        boolean init = false;
        if (dimension == 1) {
            if (this.xEncoder == null) {
                init = true;
            }
            this.xEncoder = encoder;
        }
        if (dimension == 2) {
            if (this.yEncoder == null) {
                init = true;
            }
            this.yEncoder = encoder;
        }
        this.makeLine();
        this.needConnect = true;
        this.needConnect2 = true;
        if (init && dimension == 1 && ((PositionEncoder)this.xEncoder).isReversed() && this.isHorizontal() || init && dimension == 2 && ((PositionEncoder)this.yEncoder).isReversed() && !this.isHorizontal()) {
            if (this.labelPosition == 1) {
                this.labelPosition = 0;
            } else if (this.labelPosition == 0) {
                this.labelPosition = 1;
            }
        }
    }

    private double getDiscreteOffsetValue(PositionEncoder pe) {
        if (this.discreteOffset == 0.0) {
            return 0.0;
        }
        if (pe.getValueMap() instanceof StringToNumericMap) {
            StringToNumericMap stnm = (StringToNumericMap)pe.getValueMap();
            double stride = stnm.getStrideValue();
            double val = this.discreteOffset * stride;
            return pe.isReversed() ? -val : val;
        }
        return 0.0;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected boolean connectNetwork() {
        if (this.xEncoder == null) {
            return false;
        }
        xmap = this.xEncoder.getValueMap();
        if (this.yEncoder == null) {
            return false;
        }
        ymap = this.yEncoder.getValueMap();
        this.networkRoot.removeAllElements();
        this.fm = StatGraph.getFontMetrics((Font)this.labelStyle.getFont());
        this.line = new LineSegment();
        this.networkRoot.addElement((Element)this.line);
        this.line.setUserData((Object)this.probe);
        if (!this.isExtrudedOverlay()) {
            this.line.setSkinType(this.skinType);
            this.line.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
        }
        channel = this.networkRoot.getChannel();
        iPhase = 0;
        nPhase = 0;
        phaseIndex = null;
        index = null;
        beginx = null;
        endx = null;
        if (this.isHorizontal()) {
            discreteOffsetValue = this.getDiscreteOffsetValue((PositionEncoder)this.yEncoder);
            if (this.model == null) {
                val = 0.0;
                if (ymap instanceof StringToNumericMap) {
                    try {
                        val = ((StringToNumericMap)ymap).getValue(this.yvalue instanceof Double != false ? DataModel.defaultFormat.format(this.yvalue).trim() : this.yvalue);
                    }
                    catch (MissingValueException mve) {
                        if (!this.clipping) ** GOTO lbl34
                        return false;
                    }
                } else {
                    val = ((ContinuousRangeToNumericMap)ymap).getValue(((Double)this.yvalue).doubleValue());
                }
lbl34:
                // 3 sources

                this.line.beginY.setValue(val + discreteOffsetValue);
                this.line.endY.setValue(val + discreteOffsetValue);
                xd = ((PositionEncoder)this.xEncoder).getLowerLimit();
                this.line.beginX.setValue(xd);
                xd = ((PositionEncoder)this.xEncoder).getUpperLimit();
                this.line.endX.setValue(xd);
                if (this.isExtrudedOverlay() && this.getOverlayPosition() == 0) {
                    line2 = new LineSegment();
                    this.networkRoot.addElement((Element)line2);
                    line2.setUserData((Object)this.probe);
                    xd = ((PositionEncoder)this.xEncoder).getUpperLimit();
                    line2.beginX.setValue(xd);
                    line2.beginY.setValue(val + discreteOffsetValue);
                    line2.beginZ.setValue(0.0);
                    xd = ((PositionEncoder)this.xEncoder).getUpperLimit();
                    line2.endX.setValue(xd);
                    line2.endY.setValue(val + discreteOffsetValue);
                    line2.endZ.setValue(-this.extrusionDepth);
                    line2.color.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
                    line2.lineWidth.setValue((double)this.lineStyle.getWidth());
                    line2.setStipple(this.lineStyle.getStipplePattern(), this.lineStyle.getStippleFactor());
                    line2.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
                }
            } else {
                yvalueMapper = null;
                if (this.yvalueVar instanceof NumericVectorVariable) {
                    yvalueMapper = new ContinuousRangeToNumericMapper();
                    if (!(ymap instanceof ContinuousRangeToNumericMap)) {
                        return false;
                    }
                    yvalueMapper.setMap((ContinuousRangeToNumericMap)ymap);
                    yvalueMapper.input.connectFrom(((NumericVariable)this.yvalueVar).value);
                } else {
                    yvalueMapper = new StringToNumericMapper();
                    ((StringToNumericMapper)yvalueMapper).setMap((StringToNumericMap)ymap);
                    ((StringToNumericMapper)yvalueMapper).input.connectFrom(((StringVariable)this.yvalueVar).value);
                }
                yOffsetPos = this.makeOffsetCalculator(discreteOffsetValue, (NumericPipe)yvalueMapper);
                this.line.beginY.connectFrom(yOffsetPos);
                this.line.endY.connectFrom(yOffsetPos);
                if (this.phase != null) {
                    phaseBeginMapper = new ContinuousRangeToNumericMapper();
                    phaseEndMapper = new ContinuousRangeToNumericMapper();
                    this.phaseBeginVar = new NumericVectorVariable();
                    this.phaseEndVar = new NumericVectorVariable();
                    x = false;
                    y = false;
                    width = this.innerAxisBounds.width;
                    height = this.outerAxisBounds.height;
                    frame = new BBox((double)x, (double)y, width, height);
                    phaseFrames = this.phase.getRefFillFrames(frame);
                    phaseIndex = this.phase.getPhaseIndexArray();
                    nPhase = phaseFrames.length;
                    StatGraph.printError((String)("yvalueIndexVar = " + this.yvalueIndexVar), (boolean)true);
                    v0 /* !! */  = this.model.isAvailable(784) != false ? this.model.getDoubleColumn(784) : (index = (double[])(this.model.isAvailable(786) != false ? this.model.getDoubleColumn(786) : null));
                    if (index != null) {
                        nRef = index.length;
                        beginx = new double[nRef];
                        endx = new double[nRef];
                        for (iRef = 0; iRef < nRef; ++iRef) {
                            xd = index[iRef];
                            if (Double.isNaN(xd)) {
                                beginx[iRef] = ((PositionEncoder)this.xEncoder).getLowerLimit();
                                endx[iRef] = ((PositionEncoder)this.xEncoder).getUpperLimit();
                            } else {
                                ix = (int)xd;
                                for (iPhase = 0; iPhase < nPhase && phaseIndex[iPhase] != ix; ++iPhase) {
                                }
                                if (iPhase < nPhase) {
                                    beginx[iRef] = phaseFrames[iPhase].getULX();
                                    endx[iRef] = phaseFrames[iPhase].getLRX();
                                }
                            }
                            StatGraph.printError((String)("iRef = " + iRef), (boolean)true);
                            StatGraph.printError((String)("beginx[iRef] = " + beginx[iRef]), (boolean)true);
                            StatGraph.printError((String)("endx[iRef] = " + endx[iRef]), (boolean)true);
                        }
                    }
                    StatGraph.printError((String)("phaseBeginVar = " + this.phaseBeginVar), (boolean)true);
                    StatGraph.printError((String)("phaseEndVar = " + this.phaseEndVar), (boolean)true);
                    ((NumericVectorVariable)this.phaseBeginVar).connectFrom(beginx);
                    ((NumericVectorVariable)this.phaseEndVar).connectFrom(endx);
                    phaseBeginMapper.input.connectFrom(((NumericVariable)this.phaseBeginVar).value);
                    phaseEndMapper.input.connectFrom(((NumericVariable)this.phaseEndVar).value);
                    this.line.beginX.connectFrom((NumericPipe)phaseBeginMapper);
                    this.line.endX.connectFrom((NumericPipe)phaseEndMapper);
                } else {
                    xd = ((PositionEncoder)this.xEncoder).getLowerLimit();
                    this.line.beginX.setValue(xd);
                    xd = ((PositionEncoder)this.xEncoder).getUpperLimit();
                    this.line.endX.setValue(xd);
                }
                if (this.isExtrudedOverlay() && this.getOverlayPosition() == 0) {
                    line2 = new LineSegment();
                    this.networkRoot.addElement((Element)line2);
                    line2.setUserData((Object)this.probe);
                    xd = ((PositionEncoder)this.xEncoder).getUpperLimit();
                    line2.beginX.setValue(xd);
                    line2.beginY.connectFrom(yOffsetPos);
                    line2.beginZ.setValue(0.0);
                    xd = ((PositionEncoder)this.xEncoder).getUpperLimit();
                    line2.endX.setValue(xd);
                    line2.endY.connectFrom(yOffsetPos);
                    line2.endZ.setValue(-this.extrusionDepth);
                    line2.color.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
                    line2.lineWidth.setValue((double)this.lineStyle.getWidth());
                    line2.setStipple(this.lineStyle.getStipplePattern(), this.lineStyle.getStippleFactor());
                    line2.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
                }
            }
        } else {
            discreteOffsetValue = this.getDiscreteOffsetValue((PositionEncoder)this.xEncoder);
            if (this.model == null) {
                val = 0.0;
                if (xmap instanceof StringToNumericMap) {
                    try {
                        val = ((StringToNumericMap)xmap).getValue(this.xvalue instanceof Double != false ? DataModel.defaultFormat.format(this.xvalue).trim() : this.xvalue);
                    }
                    catch (MissingValueException mve) {
                        if (!this.clipping) ** GOTO lbl147
                        return false;
                    }
                } else {
                    val = ((ContinuousRangeToNumericMap)xmap).getValue(((Double)this.xvalue).doubleValue());
                }
lbl147:
                // 3 sources

                yd = ((PositionEncoder)this.yEncoder).getLowerLimit();
                this.line.beginX.setValue(val + discreteOffsetValue);
                this.line.beginY.setValue(yd);
                yd = ((PositionEncoder)this.yEncoder).getUpperLimit();
                this.line.endX.setValue(val + discreteOffsetValue);
                this.line.endY.setValue(yd);
                if (this.isExtrudedOverlay() && this.getOverlayPosition() == 0) {
                    line2 = new LineSegment();
                    this.networkRoot.addElement((Element)line2);
                    line2.setUserData((Object)this.probe);
                    yd = ((PositionEncoder)this.yEncoder).getUpperLimit();
                    line2.beginX.setValue(val + discreteOffsetValue);
                    line2.beginY.setValue(yd);
                    line2.beginZ.setValue(0.0);
                    yd = ((PositionEncoder)this.yEncoder).getUpperLimit();
                    line2.endX.setValue(val + discreteOffsetValue);
                    line2.endY.setValue(yd);
                    line2.endZ.setValue(-this.extrusionDepth);
                    line2.color.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
                    line2.lineWidth.setValue((double)this.lineStyle.getWidth());
                    line2.setStipple(this.lineStyle.getStipplePattern(), this.lineStyle.getStippleFactor());
                    line2.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
                }
            } else {
                xvalueMapper = null;
                if (this.xvalueVar instanceof NumericVectorVariable) {
                    xvalueMapper = new ContinuousRangeToNumericMapper();
                    if (!(xmap instanceof ContinuousRangeToNumericMap)) {
                        return false;
                    }
                    xvalueMapper.setMap((ContinuousRangeToNumericMap)xmap);
                    xvalueMapper.input.connectFrom(((NumericVariable)this.xvalueVar).value);
                } else {
                    xvalueMapper = new StringToNumericMapper();
                    ((StringToNumericMapper)xvalueMapper).setMap((StringToNumericMap)xmap);
                    ((StringToNumericMapper)xvalueMapper).input.connectFrom(((StringVariable)this.xvalueVar).value);
                }
                xOffsetPos = this.makeOffsetCalculator(discreteOffsetValue, (NumericPipe)xvalueMapper);
                yd = ((PositionEncoder)this.yEncoder).getLowerLimit();
                this.line.beginX.connectFrom(xOffsetPos);
                this.line.beginY.setValue(yd);
                yd = ((PositionEncoder)this.yEncoder).getUpperLimit();
                this.line.endX.connectFrom(xOffsetPos);
                this.line.endY.setValue(yd);
                if (this.isExtrudedOverlay() && this.getOverlayPosition() == 0) {
                    line2 = new LineSegment();
                    this.networkRoot.addElement((Element)line2);
                    line2.setUserData((Object)this.probe);
                    yd = ((PositionEncoder)this.yEncoder).getUpperLimit();
                    line2.beginX.connectFrom(xOffsetPos);
                    line2.beginY.setValue(yd);
                    line2.beginZ.setValue(0.0);
                    yd = ((PositionEncoder)this.yEncoder).getUpperLimit();
                    line2.endX.connectFrom(xOffsetPos);
                    line2.endY.setValue(yd);
                    line2.endZ.setValue(-this.extrusionDepth);
                    line2.color.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
                    line2.lineWidth.setValue((double)this.lineStyle.getWidth());
                    line2.setStipple(this.lineStyle.getStipplePattern(), this.lineStyle.getStippleFactor());
                    line2.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
                }
            }
        }
        this.line.color.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
        this.line.lineWidth.setValue((double)this.lineStyle.getWidth());
        this.line.setStipple(this.lineStyle.getStipplePattern(), this.lineStyle.getStippleFactor());
        this.line.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
        if (this.curveLabelLocation == 1 || this.curveLabelString == null && this.curveLabelVar == null) {
            this.needConnect = false;
            return true;
        }
        this.label = new RasterLabel();
        this.networkRoot3 = new NetworkRoot(channel);
        this.networkRoot3.addElement((Element)this.label);
        labelColor = this.labelStyle.getColor();
        this.label.color.setValue(labelColor);
        this.label.fontName.setValue(this.labelStyle.getFont().getName());
        this.label.fontSize.setValue(this.labelStyle.getFont().getSize());
        this.label.fontStyle.setValue(this.labelStyle.getFont().getStyle());
        if (this.model == null) {
            if (this.curveLabelSplit) {
                this.label.string.setValue(QCReferenceLineOverlay.makeMultiLineLabel((String[])QCReferenceLineOverlay.splitLabel((String)this.curveLabelString, (boolean)true, (double)-1.0, (boolean)this.curveLabelSplitCharDrop, (char[])this.curveLabelSplitChar, (FontMetrics)this.fm), (boolean)false));
            } else if (this.labelFormat != null) {
                if (this.labelFormat.isCharacterFormat()) {
                    this.label.string.setValue(this.labelFormat.format((Object)this.curveLabelString));
                } else {
                    this.label.string.setValue(this.labelFormat.format((Object)new Double(this.curveLabelString)));
                }
            } else {
                this.label.string.setValue(this.curveLabelString);
            }
            xMin = this.line.beginX.getValue();
            yMin = this.line.beginY.getValue();
            xMax = this.line.endX.getValue();
            yMax = this.line.endY.getValue();
            if (this.isHorizontal()) {
                xMin += (double)this.leftReservedSpace;
                xMax -= (double)this.rightReservedSpace;
            } else {
                yMin += (double)this.bottomReservedSpace;
                yMax -= (double)this.topReservedSpace;
            }
            d = new double[]{xMin + (double)this.labelPosition * (xMax - xMin), yMin + (double)this.labelPosition * (yMax - yMin), 0.0};
            d1 = new double[3];
            if (this.getOverlayPosition() == 0) {
                this.networkRoot.getChannel().glPushMatrix();
                this.networkRoot.getChannel().glTranslate(0.0, 0.0, -this.extrusionDepth);
            }
            this.networkRoot.getChannel().gluProject(d, d1);
            if (this.getOverlayPosition() == 0) {
                this.networkRoot.getChannel().glPopMatrix();
            }
            FitLineOverlay.computeBestAlignment((String)this.label.string.getValue(), (int)((int)d1[0]), (int)((int)d1[1]), (Rectangle)this.clipRect, (FontMetrics)this.fm, (boolean)true, (boolean)true, (TextStyle)this.labelStyle);
            this.label.horizontalJustification.setValue(this.labelStyle.getHorizontalJustification());
            this.label.verticalJustification.setValue(this.labelStyle.getVerticalJustification());
            adjV = 3.0;
            adjH = 3.0;
            if (this.lineStyle.getWidth() > 3) {
                if (this.isHorizontal()) {
                    adjV += (double)this.lineStyle.getWidth() * 0.5;
                } else {
                    adjH += (double)this.lineStyle.getWidth() * 0.5;
                }
            }
            if (this.labelStyle.getHorizontalJustification() == 0) {
                d[0] = d[0] + adjH;
            } else if (this.labelStyle.getHorizontalJustification() == 2) {
                d[0] = d[0] - adjH;
            }
            if (this.labelStyle.getVerticalJustification() == 3) {
                d[1] = d[1] + adjV;
            } else if (this.labelStyle.getVerticalJustification() == 0) {
                d[1] = d[1] - adjV;
            }
            if (this.clipping) {
                if (this.isHorizontal()) {
                    if (d[1] < ((PositionEncoder)this.yEncoder).getOutputMin() || d[1] > ((PositionEncoder)this.yEncoder).getOutputMax()) {
                        d[1] = NaN;
                    }
                } else if (d[0] < ((PositionEncoder)this.xEncoder).getOutputMin() || d[0] > ((PositionEncoder)this.xEncoder).getOutputMax()) {
                    d[0] = NaN;
                }
            }
            this.label.transform.translateX.setValue(d[0]);
            this.label.transform.translateY.setValue(d[1]);
            if (this.curveLabelSplit) {
                this.label.transform.translateX.setValue(this.makeSplitLabelXOffset(this.label.transform.translateX.getValue(), this.label.string.getValue(), this.labelStyle.getHorizontalJustification(), this.curveLabelSplitJustify, this.fm));
                this.label.horizontalJustification.setValue(this.makeSplitLabelHJustification(this.label.horizontalJustification.getValue(), this.curveLabelSplitJustify));
            }
        } else {
            if (this.curveLabelSplit) {
                this.label.string.connectFrom(this.splitCurveLabelVariable((Variable)this.curveLabelVar, (FontMetrics)this.fm, (boolean)false).value);
            } else if (this.curveLabelVar instanceof StringVectorVariable) {
                this.label.string.connectFrom(((StringVectorVariable)this.curveLabelVar).formattedValue);
            } else {
                this.label.string.connectFrom(((NumericVectorVariable)this.curveLabelVar).formattedValue);
            }
            nLines = this.isHorizontal() != false ? this.yvalueVar.getValueCount() : this.xvalueVar.getValueCount();
            y = new double[nLines];
            tx = new double[nLines];
            ty = new double[nLines];
            hj = new int[nLines];
            vj = new int[nLines];
            d = new double[3];
            d1 = new double[3];
            txv = new NumericVectorVariable();
            tyv = new NumericVectorVariable();
            hjv = new IntegerVector();
            vjv = new IntegerVector();
            adj = 3.0;
            if (this.lineStyle.getWidth() > 3) {
                adj += (double)this.lineStyle.getWidth() * 0.5;
            }
            if (this.isHorizontal()) {
                xMin = ((PositionEncoder)this.xEncoder).getLowerLimit();
                xMax = ((PositionEncoder)this.xEncoder).getUpperLimit();
                xMin += (double)this.leftReservedSpace;
                xMax -= (double)this.rightReservedSpace;
                for (i = 0; i < nLines; ++i) {
                    if (this.phase != null) {
                        xd = index[i];
                        if (Double.isNaN(xd)) {
                            d[0] = xMin + (double)this.labelPosition * (xMax - xMin);
                        } else {
                            ix = (int)xd;
                            phaseMin = beginx[i];
                            phaseMax = endx[i];
                            d[0] = (phaseMin += (double)this.leftReservedSpace) + (double)this.labelPosition * ((phaseMax -= (double)this.rightReservedSpace) - phaseMin);
                        }
                    } else {
                        d[0] = xMin + (double)this.labelPosition * (xMax - xMin);
                    }
                    str = null;
                    try {
                        d[1] = this.yvalueVar instanceof NumericVectorVariable != false ? ((ContinuousRangeToNumericMap)ymap).getValue(((NumericVectorVariable)this.yvalueVar).value.getValue(i)) : ((StringToNumericMap)ymap).getValue((Object)((StringVectorVariable)this.yvalueVar).value.getValue(i));
                        str = this.label.string.getValue(i);
                    }
                    catch (MissingValueException var41_60) {
                        // empty catch block
                    }
                    tx[i] = d[0];
                    outMin = ((PositionEncoder)this.yEncoder).getOutputMin();
                    outMax = ((PositionEncoder)this.yEncoder).getOutputMax();
                    ty[i] = this.clipping != false && (d[1] < outMin || d[1] > outMax) ? NaN : d[1];
                    if (this.getOverlayPosition() == 0) {
                        this.networkRoot.getChannel().glPushMatrix();
                        this.networkRoot.getChannel().glTranslate(0.0, 0.0, -this.extrusionDepth);
                    }
                    this.networkRoot.getChannel().gluProject(d, d1);
                    if (this.getOverlayPosition() == 0) {
                        this.networkRoot.getChannel().glPopMatrix();
                    }
                    hj[i] = this.labelPosition == 0 ? 0 : 2;
                    labelStyle = new TextStyle();
                    labelStyle.setHorizontalJustification(hj[i]);
                    FitLineOverlay.computeBestAlignment((String)str, (int)((int)d1[0]), (int)((int)d1[1]), (Rectangle)this.clipRect, (FontMetrics)this.fm, (boolean)false, (boolean)true, (TextStyle)labelStyle);
                    vj[i] = labelStyle.getVerticalJustification();
                    if (hj[i] == 0) {
                        v1 = i;
                        tx[v1] = tx[v1] + 3.0;
                    } else if (hj[i] == 2) {
                        v2 = i;
                        tx[v2] = tx[v2] - 3.0;
                    }
                    if (vj[i] == 3) {
                        v3 = i;
                        ty[v3] = ty[v3] + adj;
                        continue;
                    }
                    if (vj[i] != 0) continue;
                    v4 = i;
                    ty[v4] = ty[v4] - adj;
                }
            } else {
                yMin = ((PositionEncoder)this.yEncoder).getLowerLimit();
                yMax = ((PositionEncoder)this.yEncoder).getUpperLimit();
                yMin += (double)this.bottomReservedSpace;
                yMax -= (double)this.topReservedSpace;
                for (i = 0; i < nLines; ++i) {
                    d[1] = yMin + (double)this.labelPosition * (yMax - yMin);
                    str = null;
                    try {
                        d[0] = this.xvalueVar instanceof NumericVectorVariable != false ? ((ContinuousRangeToNumericMap)xmap).getValue(((NumericVectorVariable)this.xvalueVar).value.getValue(i)) : ((StringToNumericMap)xmap).getValue((Object)((StringVectorVariable)this.xvalueVar).value.getValue(i));
                        str = this.label.string.getValue(i);
                    }
                    catch (MissingValueException phaseMax) {
                        // empty catch block
                    }
                    tx[i] = this.clipping != false && (d[0] < ((PositionEncoder)this.xEncoder).getOutputMin() || d[0] > ((PositionEncoder)this.xEncoder).getOutputMax()) ? NaN : d[0];
                    ty[i] = d[1];
                    vj[i] = this.labelPosition == 0 ? 3 : 0;
                    labelStyle = new TextStyle();
                    labelStyle.setVerticalJustification(vj[i]);
                    FitLineOverlay.computeBestAlignment((String)str, (int)((int)d[0]), (int)((int)d[1]), (Rectangle)this.clipRect, (FontMetrics)this.fm, (boolean)true, (boolean)false, (TextStyle)labelStyle);
                    hj[i] = labelStyle.getHorizontalJustification();
                    if (hj[i] == 0) {
                        v5 = i;
                        tx[v5] = tx[v5] + adj;
                    } else if (hj[i] == 2) {
                        v6 = i;
                        tx[v6] = tx[v6] - adj;
                    }
                    if (vj[i] == 3) {
                        v7 = i;
                        ty[v7] = ty[v7] + 3.0;
                        continue;
                    }
                    if (vj[i] != 0) continue;
                    v8 = i;
                    ty[v8] = ty[v8] - 3.0;
                }
            }
            txv.connectFrom(tx);
            tyv.connectFrom(ty);
            for (i = 0; i < nLines; ++i) {
                hjv.addValue(hj[i]);
            }
            for (i = 0; i < nLines; ++i) {
                vjv.addValue(vj[i]);
            }
            this.label.horizontalJustification.connectFrom(this.makeCurveLabelHJustification((IntegerPipe)hjv));
            this.label.verticalJustification.connectFrom((IntegerPipe)vjv);
            this.label.transform.translateX.connectFrom(this.makeCurveLabelXOffset(txv.value, (IntegerPipe)hjv, nLines));
            this.label.transform.translateY.connectFrom(tyv.value);
        }
        this.needConnect = false;
        return true;
    }

    public double getPreferredOffset(byte dimension) {
        double scale = this.lineStyle.getWidth();
        return 2.0 * scale;
    }

    protected void connectVars() {
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.probeID != null) {
            this.probe.addString(this.probeIDLabel, "" + this.probeID);
        }
        if (this.model != null) {
            SASFormat fmt;
            if (this.model.isAvailable(10)) {
                this.xvalueVar = this.discreteX ? this.connectCategory((short)10, this.missingCategoryOn) : this.connectRaw((short)10);
                if (this.numericX && this.discreteX) {
                    this.numericXVar = new NumericVectorVariable();
                    this.numericXVar.connectFrom(this.model.getDoubleColumn(10));
                    fmt = ((ColumnMetadata)this.model.getColumnLabel(10)).getFormat();
                    if (fmt == null) {
                        fmt = DataModel.defaultFormat;
                    }
                    this.numericXVar.setFormat(new GTKFormat((Format)fmt));
                }
                if (this.discreteX) {
                    this.numericDiscreteX = this.numericX;
                    this.numericX = false;
                }
            } else {
                this.xvalueVar = null;
            }
            if (this.model.isAvailable(11)) {
                this.yvalueVar = this.discreteY ? this.connectCategory((short)11, this.missingCategoryOn) : this.connectRaw((short)11);
                if (this.numericY && this.discreteY) {
                    this.numericYVar = new NumericVectorVariable();
                    this.numericYVar.connectFrom(this.model.getDoubleColumn(11));
                    fmt = ((ColumnMetadata)this.model.getColumnLabel(11)).getFormat();
                    if (fmt == null) {
                        fmt = DataModel.defaultFormat;
                    }
                    this.numericYVar.setFormat(new GTKFormat((Format)fmt));
                }
                if (this.discreteY) {
                    this.numericDiscreteY = this.numericY;
                    this.numericY = false;
                }
            } else {
                this.yvalueVar = null;
            }
            this.yvaluePhaseVar = this.model.isAvailable(783) ? this.connectRaw((short)783) : null;
            this.yvalueIndexVar = this.model.isAvailable(784) ? this.connectRaw((short)784) : (this.model.isAvailable(786) ? this.connectRaw((short)786) : null);
            StringVector labels = new StringVector();
            if (this.model.isAvailable(48)) {
                boolean bl = this.numericLabel = this.model.getColumnClass(48) == Double.class;
                if (this.numericLabel) {
                    this.curveLabelVar = this.connectCategory((short)48, false);
                } else {
                    String[] labs = this.getSubsettedStringAsClassColumn((short)48);
                    int num = labs.length;
                    for (int i = 0; i < num; ++i) {
                        String s = QCStylizedTextElement.replaceUnicodeStrings(labs[i]);
                        labels.addValue(s);
                    }
                    ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(48);
                    this.curveLabelVar = new StringVectorVariable();
                    ((StringVectorVariable)this.curveLabelVar).connectFrom((StringPipe)labels);
                    if (cmd.getFormat() != null) {
                        this.curveLabelVar.setFormat(new GTKFormat((Format)cmd.getFormat()));
                    }
                    this.curveLabelVar.setLabel(this.getLabel((short)48));
                }
            } else {
                this.curveLabelVar = null;
            }
            VariableProcessor vp = null;
            if (this.model.whereExpression != null) {
                vp = new VariableProcessor();
                this.addVarToVP(vp, this.xvalueVar);
                this.addVarToVP(vp, this.yvalueVar);
                this.addVarToVP(vp, this.yvaluePhaseVar);
                this.addVarToVP(vp, this.yvalueIndexVar);
                this.addVarToVP(vp, this.curveLabelVar);
                this.addVarToVP(vp, (Variable)this.numericXVar);
                this.addVarToVP(vp, (Variable)this.numericYVar);
                this.addCRDWhereClause(vp);
            }
            this.addTooltip(vp, "X");
            this.addTooltip(vp, "Y");
            if (vp != null) {
                vp.init();
            }
        } else if (this.isHorizontal()) {
            if (this.yvalue instanceof String) {
                this.probe.addString("Y", (String)this.yvalue);
            } else {
                this.probe.addString("Y", DataModel.formatNumber((Double)((Double)this.yvalue)));
            }
        } else if (this.xvalue instanceof String) {
            this.probe.addString("X", (String)this.xvalue);
        } else {
            this.probe.addString("X", DataModel.formatNumber((Double)((Double)this.xvalue)));
        }
    }

    private void connectOutsideLabel() {
        int numLines = this.curveLabelVar == null ? 1 : this.curveLabelVar.getValueCount();
        Object[] cLabels = new String[numLines];
        double[] xEnds = new double[numLines];
        double[] yEnds = new double[numLines];
        double xMin = ((PositionEncoder)this.xEncoder).getOutputMin();
        double xMax = ((PositionEncoder)this.xEncoder).getOutputMax();
        double yMin = ((PositionEncoder)this.yEncoder).getOutputMin();
        double yMax = ((PositionEncoder)this.yEncoder).getOutputMax();
        IntegerVector closestAxis = new IntegerVector();
        for (int i = 0; i < numLines; ++i) {
            try {
                cLabels[i] = numLines == 1 && this.curveLabelVar == null ? this.curveLabelString : (this.curveLabelVar instanceof NumericVectorVariable ? ((NumericVectorVariable)this.curveLabelVar).formattedValue.getValue(i) : ((StringVectorVariable)this.curveLabelVar).formattedValue.getValue(i));
                if (this.isHorizontal()) {
                    xEnds[i] = this.labelPosition == 0 ? xMin : xMax;
                    yEnds[i] = this.line.beginY.getValue(i);
                    if (yEnds[i] < ((PositionEncoder)this.yEncoder).getLowerLimit() || yEnds[i] > ((PositionEncoder)this.yEncoder).getUpperLimit()) {
                        yEnds[i] = Double.NaN;
                    }
                } else {
                    yEnds[i] = this.labelPosition == 0 ? yMin : yMax;
                    xEnds[i] = this.line.beginX.getValue(i);
                    if (xEnds[i] < ((PositionEncoder)this.xEncoder).getLowerLimit() || xEnds[i] > ((PositionEncoder)this.xEncoder).getUpperLimit()) {
                        xEnds[i] = Double.NaN;
                    }
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            if (this.isHorizontal()) {
                if (this.labelPosition == 1) {
                    closestAxis.addValue(3);
                    continue;
                }
                closestAxis.addValue(2);
                continue;
            }
            if (this.labelPosition == 1) {
                closestAxis.addValue(1);
                continue;
            }
            closestAxis.addValue(0);
        }
        if (this.curveLabelSplit) {
            cLabels = this.splitCurveLabels(cLabels, StatGraph.getFontMetrics((Font)this.labelStyle.getFont()), true);
        }
        StringVectorVariable clVar = new StringVectorVariable();
        clVar.connectFrom((String[])cLabels);
        NumericVectorVariable xEndVar = new NumericVectorVariable();
        xEndVar.connectFrom(xEnds);
        NumericVectorVariable yEndVar = new NumericVectorVariable();
        yEndVar.connectFrom(yEnds);
        this.boundaryLabel = new RasterLabel();
        this.networkRoot2 = new NetworkRoot(this.networkRoot.getChannel());
        this.networkRoot2.addElement((Element)this.boundaryLabel);
        this.clLayout.x.connectFrom(xEndVar.value);
        this.clLayout.y.connectFrom(yEndVar.value);
        this.clLayout.label.connectFrom(clVar.value);
        this.clLayout.color.setValue(this.labelStyle.getColor());
        this.clLayout.closestAxis.connectFrom((IntegerPipe)closestAxis);
        this.boundaryLabel.transform.translateX.connectFrom(this.makeCurveLabelXOffset(this.clLayout.xout, this.clLayout.hAlign, cLabels.length));
        this.boundaryLabel.transform.translateY.connectFrom(this.clLayout.yout);
        this.boundaryLabel.horizontalJustification.connectFrom(this.makeCurveLabelHJustification(this.clLayout.hAlign));
        this.boundaryLabel.verticalJustification.connectFrom(this.clLayout.vAlign);
        this.boundaryLabel.string.connectFrom((StringPipe)this.clLayout.labelOut);
        this.boundaryLabel.color.connectFrom((ColorPipe)this.clLayout.labelColor);
        Font fnt = this.labelStyle.getFont();
        this.boundaryLabel.fontName.setValue(fnt.getFamily());
        this.boundaryLabel.fontStyle.setValue(fnt.getStyle());
        this.boundaryLabel.fontSize.setValue(fnt.getSize());
        this.boundaryLabel.angle.connectFrom((NumericPipe)this.clLayout.angle);
    }

    public void setRotateXCurveLabels(boolean b) {
        this.rotateXCurveLabels = b;
    }

    public void setRotateX2CurveLabels(boolean b) {
        this.rotateX2CurveLabels = b;
    }

    public void addXBBoxes(ArrayList xb, ArrayList x2b) {
        block17: {
            if (this.isHorizontal()) {
                return;
            }
            FontMetrics fm = StatGraph.getFontMetrics((Font)this.labelStyle.getFont());
            ValueMap xmap = this.xEncoder.getValueMap();
            ValueMap ymap = this.yEncoder.getValueMap();
            if (this.curveLabelVar == null) {
                try {
                    int len;
                    double x = xmap instanceof ContinuousRangeToNumericMap ? ((ContinuousRangeToNumericMap)xmap).getValue(((Double)this.xvalue).doubleValue()) : ((StringToNumericMap)xmap).getValue(this.xvalue instanceof Double ? DataModel.defaultFormat.format(this.xvalue).trim() : this.xvalue);
                    String cLabel = this.curveLabelString;
                    if (this.curveLabelSplit) {
                        cLabel = QCReferenceLineOverlay.makeMultiLineLabel((String[])QCReferenceLineOverlay.splitLabel((String)cLabel, (boolean)true, (double)-1.0, (boolean)this.curveLabelSplitCharDrop, (char[])this.curveLabelSplitChar, (FontMetrics)fm), (boolean)true);
                        len = QCReferenceLineOverlay.getTextWidth((FontMetrics)fm, (String)cLabel);
                    } else {
                        len = fm.stringWidth(" " + cLabel + " ");
                    }
                    x = x + (double)(len / 2) > ((PositionEncoder)this.xEncoder).getUpperLimit() ? ((PositionEncoder)this.xEncoder).getUpperLimit() - (double)len : (x - (double)(len / 2) < ((PositionEncoder)this.xEncoder).getLowerLimit() ? ((PositionEncoder)this.xEncoder).getLowerLimit() : (x -= (double)(len / 2)));
                    if (this.labelPosition == 0) {
                        xb.add(new Rectangle((int)x, 0, len, 3));
                        break block17;
                    }
                    x2b.add(new Rectangle((int)x, 0, len, 3));
                }
                catch (MissingValueException len) {}
            } else {
                int numLines = this.getSubsettedValueCount(this.xvalueVar, (short)10, this.xvalueVar instanceof NumericVariable);
                double[] dxv = null;
                String[] sxv = null;
                if (this.xvalueVar instanceof NumericVectorVariable) {
                    dxv = this.getSubsettedDoubleColumn((short)10);
                } else {
                    sxv = this.discreteX ? (this.numericDiscreteX ? this.getSubsettedDoubleAsClassColumn((short)10) : this.getSubsettedStringAsClassColumn((short)10)) : this.getSubsettedStringColumn((short)10);
                }
                Object[] labels = this.getSubsettedColumnAsClassColumn((short)48, this.numericLabel);
                if (this.curveLabelSplit) {
                    labels = this.splitCurveLabels(labels, StatGraph.getFontMetrics((Font)this.labelStyle.getFont()), true);
                }
                for (int i = 0; i < numLines; ++i) {
                    Object cLabel;
                    double x;
                    if (dxv != null) {
                        int len;
                        if (Double.isNaN(dxv[i]) || !(xmap instanceof ContinuousRangeToNumericMap)) continue;
                        x = ((ContinuousRangeToNumericMap)xmap).getValue(dxv[i]);
                        cLabel = labels[i];
                        int n = len = this.curveLabelSplit ? QCReferenceLineOverlay.getTextWidth((FontMetrics)fm, (String)cLabel) : fm.stringWidth(" " + (String)cLabel + " ");
                        x = x + (double)(len / 2) > ((PositionEncoder)this.xEncoder).getUpperLimit() ? ((PositionEncoder)this.xEncoder).getUpperLimit() - (double)len : (x - (double)(len / 2) < ((PositionEncoder)this.xEncoder).getLowerLimit() ? ((PositionEncoder)this.xEncoder).getLowerLimit() : (x -= (double)(len / 2)));
                        if (this.labelPosition == 0) {
                            xb.add(new Rectangle((int)x, 0, len, 3));
                            continue;
                        }
                        x2b.add(new Rectangle((int)x, 0, len, 3));
                        continue;
                    }
                    if (sxv[i].length() <= 0) continue;
                    try {
                        int len;
                        x = ((StringToNumericMap)xmap).getValue((Object)sxv[i]);
                        cLabel = labels[i];
                        int n = len = this.curveLabelSplit ? QCReferenceLineOverlay.getTextWidth((FontMetrics)fm, (String)cLabel) : fm.stringWidth(" " + (String)cLabel + " ");
                        x = x + (double)(len / 2) > ((PositionEncoder)this.xEncoder).getUpperLimit() ? ((PositionEncoder)this.xEncoder).getUpperLimit() - (double)len : (x - (double)(len / 2) < ((PositionEncoder)this.xEncoder).getLowerLimit() ? ((PositionEncoder)this.xEncoder).getLowerLimit() : (x -= (double)(len / 2)));
                        if (this.labelPosition == 0) {
                            xb.add(new Rectangle((int)x, 0, len, 3));
                            continue;
                        }
                        x2b.add(new Rectangle((int)x, 0, len, 3));
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private Insets getLabelMargin() {
        Insets labelMargin = new Insets(0, 0, 0, 0);
        FontMetrics fm = StatGraph.getFontMetrics((Font)this.labelStyle.getFont());
        double ra = Math.toRadians(CurveGraph.rotationAngle);
        int tw = 0;
        int th = fm.getHeight();
        if (this.curveLabelVar == null) {
            String cLabel = this.curveLabelString;
            if (this.curveLabelSplit) {
                cLabel = QCReferenceLineOverlay.makeMultiLineLabel((String[])QCReferenceLineOverlay.splitLabel((String)cLabel, (boolean)true, (double)-1.0, (boolean)this.curveLabelSplitCharDrop, (char[])this.curveLabelSplitChar, (FontMetrics)fm), (boolean)true);
                tw = QCReferenceLineOverlay.getTextWidth((FontMetrics)fm, (String)cLabel);
                th = QCReferenceLineOverlay.getTextHeight((FontMetrics)fm, (String)cLabel);
            } else {
                tw = fm.stringWidth(" " + cLabel + " ");
            }
            if (!this.isHorizontal()) {
                if (this.labelPosition == 0) {
                    labelMargin.bottom = this.rotateXCurveLabels ? Math.max(labelMargin.bottom, (int)((double)tw * Math.sin(ra) + 0.5 * (double)th * Math.cos(ra)) + 3) : Math.max(labelMargin.bottom, th + 3);
                } else {
                    labelMargin.top = this.rotateX2CurveLabels ? Math.max(labelMargin.top, (int)((double)tw * Math.sin(ra) + 0.5 * (double)th * Math.cos(ra)) + 3) : Math.max(labelMargin.top, th + 3);
                }
            } else if (this.labelPosition == 0) {
                labelMargin.left = Math.max(labelMargin.left, tw + 3);
            } else {
                labelMargin.right = Math.max(labelMargin.right, tw + 3);
            }
        } else {
            int numLines = this.curveLabelVar.getValueCount();
            for (int i = 0; i < numLines; ++i) {
                try {
                    String cLabel = this.curveLabelVar instanceof NumericVectorVariable ? ((NumericVectorVariable)this.curveLabelVar).formattedValue.getValue(i) : ((StringVectorVariable)this.curveLabelVar).formattedValue.getValue(i);
                    if (this.curveLabelSplit) {
                        cLabel = QCReferenceLineOverlay.makeMultiLineLabel((String[])QCReferenceLineOverlay.splitLabel((String)cLabel, (boolean)true, (double)-1.0, (boolean)this.curveLabelSplitCharDrop, (char[])this.curveLabelSplitChar, (FontMetrics)fm), (boolean)true);
                        tw = QCReferenceLineOverlay.getTextWidth((FontMetrics)fm, (String)cLabel);
                        th = QCReferenceLineOverlay.getTextHeight((FontMetrics)fm, (String)cLabel);
                    } else {
                        tw = fm.stringWidth(" " + cLabel + " ");
                    }
                    if (!this.isHorizontal()) {
                        if (this.labelPosition == 0) {
                            if (this.rotateXCurveLabels) {
                                labelMargin.bottom = Math.max(labelMargin.bottom, (int)((double)tw * Math.sin(ra) + 0.5 * (double)th * Math.cos(ra)) + 3);
                                continue;
                            }
                            labelMargin.bottom = Math.max(labelMargin.bottom, th + 3);
                            continue;
                        }
                        if (this.rotateX2CurveLabels) {
                            labelMargin.top = Math.max(labelMargin.top, (int)((double)tw * Math.sin(ra) + 0.5 * (double)th * Math.cos(ra)) + 3);
                            continue;
                        }
                        labelMargin.top = Math.max(labelMargin.top, th + 3);
                        continue;
                    }
                    if (this.labelPosition == 0) {
                        labelMargin.left = Math.max(labelMargin.left, tw + 3);
                        continue;
                    }
                    labelMargin.right = Math.max(labelMargin.right, tw + 3);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
        return labelMargin;
    }

    public Insets getPreferredOuterMargin() {
        if (this.curveLabelVar == null && this.curveLabelString == null || this.curveLabelLocation == 0) {
            return zeroInsets;
        }
        return this.getLabelMargin();
    }

    public int[] getLineWidths() {
        int[] lw = new int[]{this.lineStyle.getWidth()};
        return lw;
    }

    public Color[] getLineColors() {
        Color[] lc = new Color[]{this.applyDataTransparency((ColorAttr)this.lineStyle)};
        return lc;
    }

    public int[] getLinePatterns() {
        int[] lp = new int[]{this.lineStyle.getLinePattern()};
        return lp;
    }

    public String[] getGroupValues() {
        String[] gv = new String[]{this.legendLabel};
        return gv;
    }

    public String[] getLineColorValues() {
        return this.getGroupValues();
    }

    public String[] getLinePatternValues() {
        return this.getGroupValues();
    }

    public boolean isComputedOverlay() {
        return true;
    }

    public void updateNetworkElements() {
        double val;
        ValueMap xmap = this.xEncoder.getValueMap();
        ValueMap ymap = this.yEncoder.getValueMap();
        if (this.isHorizontal()) {
            if (this.model == null) {
                val = 0.0;
                if (ymap instanceof StringToNumericMap) {
                    try {
                        val = ((StringToNumericMap)ymap).getValue(this.yvalue instanceof Double ? DataModel.defaultFormat.format(this.yvalue).trim() : this.yvalue);
                    }
                    catch (MissingValueException missingValueException) {}
                } else {
                    val = ((ContinuousRangeToNumericMap)ymap).getValue(((Double)this.yvalue).doubleValue());
                }
                this.line.beginY.setValue(val);
                this.line.endY.setValue(val);
            }
        } else if (this.model == null) {
            val = 0.0;
            if (xmap instanceof StringToNumericMap) {
                try {
                    val = ((StringToNumericMap)xmap).getValue(this.xvalue instanceof Double ? DataModel.defaultFormat.format(this.xvalue).trim() : this.xvalue);
                }
                catch (MissingValueException missingValueException) {}
            } else {
                val = ((ContinuousRangeToNumericMap)xmap).getValue(((Double)this.xvalue).doubleValue());
            }
            this.line.beginX.setValue(val);
            this.line.endX.setValue(val);
        }
        if (this.curveLabelLocation == 1 || this.curveLabelString == null && this.curveLabelVar == null) {
            return;
        }
        if (this.model == null) {
            double xMin = this.line.beginX.getValue();
            double yMin = this.line.beginY.getValue();
            double xMax = this.line.endX.getValue();
            double yMax = this.line.endY.getValue();
            double[] d = new double[]{xMin + (double)this.labelPosition * (xMax - xMin), yMin + (double)this.labelPosition * (yMax - yMin), 0.0};
            double[] d1 = new double[3];
            this.networkRoot.getChannel().gluProject(d, d1);
            FitLineOverlay.computeBestAlignment((String)this.label.string.getValue(), (int)((int)d1[0]), (int)((int)d1[1]), (Rectangle)this.clipRect, (FontMetrics)this.fm, (boolean)true, (boolean)true, (TextStyle)this.labelStyle);
            if (this.labelStyle.getHorizontalJustification() == 0) {
                d[0] = d[0] + 3.0;
            } else if (this.labelStyle.getHorizontalJustification() == 2) {
                d[0] = d[0] - 3.0;
            }
            if (this.labelStyle.getVerticalJustification() == 3) {
                d[1] = d[1] + 3.0;
            } else if (this.labelStyle.getVerticalJustification() == 0) {
                d[1] = d[1] - 3.0;
            }
            if (this.isHorizontal()) {
                this.label.transform.translateY.setValue(d[1]);
            } else {
                this.label.transform.translateX.setValue(d[0]);
            }
        } else {
            int nLines = this.isHorizontal() ? this.yvalueVar.getValueCount() : this.xvalueVar.getValueCount();
            double[] tx = new double[nLines];
            double[] ty = new double[nLines];
            int[] hj = new int[nLines];
            int[] vj = new int[nLines];
            double xMin = ((PositionEncoder)this.xEncoder).getLowerLimit();
            double xMax = ((PositionEncoder)this.xEncoder).getUpperLimit();
            double yMin = ((PositionEncoder)this.yEncoder).getLowerLimit();
            double yMax = ((PositionEncoder)this.yEncoder).getUpperLimit();
            double[] d = new double[3];
            double[] d1 = new double[3];
            NumericVectorVariable txv = new NumericVectorVariable();
            NumericVectorVariable tyv = new NumericVectorVariable();
            IntegerVector hjv = new IntegerVector();
            IntegerVector vjv = new IntegerVector();
            if (this.isHorizontal()) {
                for (int i = 0; i < nLines; ++i) {
                    d[0] = xMin + (double)this.labelPosition * (xMax - xMin);
                    String str = null;
                    try {
                        d[1] = this.yvalueVar instanceof NumericVectorVariable ? ((ContinuousRangeToNumericMap)ymap).getValue(((NumericVectorVariable)this.yvalueVar).value.getValue(i)) : ((StringToNumericMap)ymap).getValue((Object)((StringVectorVariable)this.yvalueVar).value.getValue(i));
                        str = this.label.string.getValue(i);
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    ty[i] = d[1];
                    this.networkRoot.getChannel().gluProject(d, d1);
                    FitLineOverlay.computeBestAlignment((String)str, (int)((int)d1[0]), (int)((int)d1[1]), (Rectangle)this.clipRect, (FontMetrics)this.fm, (boolean)false, (boolean)true, (TextStyle)this.labelStyle);
                    vj[i] = this.labelStyle.getVerticalJustification();
                    if (vj[i] == 3) {
                        int n = i;
                        ty[n] = ty[n] + 3.0;
                    } else if (vj[i] == 0) {
                        int n = i;
                        ty[n] = ty[n] - 3.0;
                    }
                    vjv.addValue(vj[i]);
                }
                tyv.connectFrom(ty);
                this.label.verticalJustification.connectFrom((IntegerPipe)vjv);
                this.label.transform.translateY.connectFrom(tyv.value);
            } else {
                for (int i = 0; i < nLines; ++i) {
                    d[1] = yMin + (double)this.labelPosition * (yMax - yMin);
                    String str = null;
                    try {
                        d[0] = this.xvalueVar instanceof NumericVectorVariable ? ((ContinuousRangeToNumericMap)xmap).getValue(((NumericVectorVariable)this.xvalueVar).value.getValue(i)) : ((StringToNumericMap)xmap).getValue((Object)((StringVectorVariable)this.xvalueVar).value.getValue(i));
                        str = this.label.string.getValue(i);
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    tx[i] = d[0];
                    this.networkRoot.getChannel().gluProject(d, d1);
                    FitLineOverlay.computeBestAlignment((String)str, (int)((int)d1[0]), (int)((int)d1[1]), (Rectangle)this.clipRect, (FontMetrics)this.fm, (boolean)true, (boolean)false, (TextStyle)this.labelStyle);
                    hj[i] = this.labelStyle.getHorizontalJustification();
                    if (hj[i] == 0) {
                        int n = i;
                        tx[n] = tx[n] + 3.0;
                    } else if (hj[i] == 2) {
                        int n = i;
                        tx[n] = tx[n] - 3.0;
                    }
                    hjv.addValue(hj[i]);
                }
                txv.connectFrom(tx);
                this.label.horizontalJustification.connectFrom((IntegerPipe)hjv);
                this.label.transform.translateX.connectFrom(txv.value);
            }
        }
    }

    public void updateCurveLabelElements() {
        if (this.isCurveLabeled()) {
            this.updateNetworkElements();
            this.connectOutsideLabel();
        }
    }

    public void addObstacles(LabelPlacementInterface lp, PointLabelLayout l, int yOutputRange) {
        block16: {
            if (!this.labelProtected) break block16;
            double xMin = 0.0;
            double yMin = 0.0;
            double xMax = 0.0;
            double yMax = 0.0;
            if (this.isHorizontal()) {
                xMin = ((PositionEncoder)this.xEncoder).getLowerLimit();
                xMax = ((PositionEncoder)this.xEncoder).getUpperLimit();
                ValueMap map = this.yEncoder.getValueMap();
                double y = 0.0;
                if (this.yvalue != null) {
                    try {
                        y = map instanceof ContinuousRangeToNumericMap ? ((ContinuousRangeToNumericMap)map).getValue(((Double)this.yvalue).doubleValue()) : ((StringToNumericMap)map).getValue(this.yvalue instanceof Double ? DataModel.defaultFormat.format(this.yvalue).trim() : this.yvalue);
                        yMax = yMin = (double)yOutputRange - y;
                        Rectangle obstacle = new Rectangle((int)xMin, (int)yMin - this.lineStyle.getWidth() / 2, (int)(xMax - xMin), this.lineStyle.getWidth());
                        lp.addObstacle((Shape)obstacle);
                    }
                    catch (MissingValueException obstacle) {}
                } else {
                    for (int i = 0; i < this.yvalueVar.getValueCount(); ++i) {
                        try {
                            y = map instanceof ContinuousRangeToNumericMap ? ((ContinuousRangeToNumericMap)map).getValue(((NumericVariable)this.yvalueVar).value.getValue(i)) : ((StringToNumericMap)map).getValue((Object)((StringVariable)this.yvalueVar).value.getValue(i));
                        }
                        catch (MissingValueException mve) {
                            continue;
                        }
                        yMax = yMin = (double)yOutputRange - y;
                        Rectangle obstacle = new Rectangle((int)xMin, (int)yMin - this.lineStyle.getWidth() / 2, (int)(xMax - xMin), this.lineStyle.getWidth());
                        lp.addObstacle((Shape)obstacle);
                    }
                }
            } else {
                yMin = ((PositionEncoder)this.yEncoder).getLowerLimit();
                yMax = ((PositionEncoder)this.yEncoder).getUpperLimit();
                ValueMap map = this.xEncoder.getValueMap();
                double x = 0.0;
                if (this.xvalue != null) {
                    try {
                        x = map instanceof ContinuousRangeToNumericMap ? ((ContinuousRangeToNumericMap)map).getValue(((Double)this.xvalue).doubleValue()) : ((StringToNumericMap)map).getValue(this.xvalue instanceof Double ? DataModel.defaultFormat.format(this.xvalue).trim() : this.xvalue);
                        xMax = xMin = x;
                        Rectangle obstacle = new Rectangle((int)xMin - this.lineStyle.getWidth() / 2, (int)yMin, this.lineStyle.getWidth(), (int)(yMax - yMin));
                        lp.addObstacle((Shape)obstacle);
                    }
                    catch (MissingValueException obstacle) {}
                } else {
                    for (int i = 0; i < this.xvalueVar.getValueCount(); ++i) {
                        try {
                            x = map instanceof ContinuousRangeToNumericMap ? ((ContinuousRangeToNumericMap)map).getValue(((NumericVariable)this.xvalueVar).value.getValue(i)) : ((StringToNumericMap)map).getValue((Object)((StringVariable)this.xvalueVar).value.getValue(i));
                        }
                        catch (MissingValueException mve) {
                            continue;
                        }
                        xMax = xMin = x;
                        Rectangle obstacle = new Rectangle((int)xMin - this.lineStyle.getWidth() / 2, (int)yMin, this.lineStyle.getWidth(), (int)(yMax - yMin));
                        lp.addObstacle((Shape)obstacle);
                    }
                }
            }
        }
    }

    public double getDiscreteOffset() {
        return this.discreteOffset;
    }

    public void setDiscreteOffset(double discreteOffset) {
        this.discreteOffset = discreteOffset;
    }

    public boolean isOneDimensional() {
        return true;
    }

    public boolean isDataOnHorizontalSide() {
        return !this.isHorizontal();
    }

    public int getPreferredSizeOnDataLessSide() {
        return 10;
    }

    @Override
    public QCOverlay.QCClipType getClipType() {
        return QCOverlay.QCClipType.OUTER;
    }
}

