/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.overlays;

import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCPhaseBoxConnector;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.util.QCMargins;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.Marker;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.text.Format;

public class QCPhaseBoxOverlay
extends QCOverlay {
    public static final String RB_KEY = "QCPhaseBoxOverlay.";
    private QCPhaseBoxConnector connector;
    protected boolean boundingBox;
    protected boolean fill;
    protected boolean outline;
    protected boolean header;
    protected boolean connectBox;
    protected boolean connectMean;
    protected boolean mean;
    protected boolean legend;
    protected float opacity = 1.0f;
    protected Variable xMinVar = null;
    protected Variable xMaxVar = null;
    protected Variable yMinVar = null;
    protected Variable yMaxVar = null;
    protected Variable meanVar = null;
    protected Variable connectVar = null;
    protected Variable markerVar = null;
    protected Variable indexVar = null;
    protected Variable valueVar = null;
    protected Variable labelVar = null;
    protected int phaseBoxLabelHeight = 0;
    private FillAttrs fillStyle = new FillAttrs();
    private FillAttrs altFillStyle = new FillAttrs();
    private FillAttrs headerStyle = new FillAttrs();
    private LineAttrs borderStyle = new LineAttrs();
    private LineAttrs connectStyle = new LineAttrs();
    private TextStyle labelStyle = new TextStyle();
    private MarkerAttrs meanStyle = new MarkerAttrs();
    private LineAttrs meanOutlineStyle = new LineAttrs();
    private MarkerAttrs markerStyle = new MarkerAttrs();
    private LineAttrs markerOutlineStyle = new LineAttrs();
    private TextStyle unicodeStyle;
    protected Font scaledLabelFont;
    protected Font uniCodeFont;
    protected Font scaledUniCodeFont;
    protected CRD subgrpModel = null;
    protected DataRange xRange = null;
    private NumericVectorVariable numericXVar = null;
    protected int trackHeight = 0;
    protected int trackHeightPad = 0;
    protected int trackAscent = 0;
    protected int trackDescent = 0;
    protected int legendHeight = 0;
    protected int xOffset = 0;
    protected int yOffset = 0;
    private double yMin = Double.MAX_VALUE;
    private double yMax = Double.MIN_VALUE;

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4 || dimension == 17 || dimension == 15) {
            // empty if block
        }
        this.needConnect = true;
    }

    protected void connectVars() {
        double d;
        int i;
        this.connectSubgrpVar(false);
        double[] xvalue = null;
        Object value = null;
        String[] s = null;
        if (this.subgrpModel.isAvailable(10)) {
            int nvalue = this.subgrpModel.getRowCount();
            int nindex = this.model.getRowCount();
            value = nvalue > 0 ? Variable.getValue((Variable)this.xvalueVar, (int)0, (boolean)false) : null;
            value = nvalue > 1 ? Variable.getValue((Variable)this.xvalueVar, (int)1, (boolean)false) : null;
            xvalue = this.subgrpModel.getDoubleColumn(10);
            double[] istart = null;
            double[] iend = null;
            double[] xstart = new double[nindex];
            double[] xend = new double[nindex];
            if (this.model.isAvailable(754)) {
                this.xMinVar = (NumericVariable)this.connectRaw((short)754);
                value = nindex > 0 ? Variable.getValue((Variable)this.xMinVar, (int)0, (boolean)false) : null;
                value = nindex > 1 ? Variable.getValue((Variable)this.xMinVar, (int)1, (boolean)false) : null;
                istart = this.model.getDoubleColumn(754);
            }
            if (this.model.isAvailable(755)) {
                this.xMaxVar = (NumericVariable)this.connectRaw((short)755);
                value = nindex > 0 ? Variable.getValue((Variable)this.xMaxVar, (int)0, (boolean)false) : null;
                value = nindex > 1 ? Variable.getValue((Variable)this.xMaxVar, (int)1, (boolean)false) : null;
                iend = this.model.getDoubleColumn(755);
            }
            for (int i2 = 0; i2 < nindex; ++i2) {
                int index = (int)istart[i2] - 1;
                xstart[i2] = xvalue[index];
                index = (int)iend[i2] - 1;
                xend[i2] = xvalue[index];
            }
            this.xMinVar = new NumericVectorVariable();
            ((NumericVectorVariable)this.xMinVar).connectFrom(xstart);
            this.xMaxVar = new NumericVectorVariable();
            ((NumericVectorVariable)this.xMaxVar).connectFrom(xend);
        }
        int nx = this.model.getRowCount();
        if (this.model.isAvailable(765)) {
            this.indexVar = (NumericVariable)this.connectRaw((short)765);
            value = nx > 0 ? Variable.getValue((Variable)this.indexVar, (int)0, (boolean)false) : null;
            value = nx > 1 ? Variable.getValue((Variable)this.indexVar, (int)1, (boolean)false) : null;
            xvalue = this.model.getDoubleColumn(765);
        }
        if (this.model.isAvailable(766)) {
            this.valueVar = this.connectRaw((short)766);
            value = nx > 0 ? Variable.getValue((Variable)this.valueVar, (int)0, (boolean)false) : null;
            value = nx > 1 ? Variable.getValue((Variable)this.valueVar, (int)1, (boolean)false) : null;
            s = this.model.getStringColumn(766);
        }
        if (this.model.isAvailable(767)) {
            this.labelVar = this.connectRaw((short)767);
            value = nx > 0 ? Variable.getValue((Variable)this.labelVar, (int)0, (boolean)false) : null;
            value = nx > 1 ? Variable.getValue((Variable)this.labelVar, (int)1, (boolean)false) : null;
            s = this.model.getStringColumn(767);
        }
        if (this.model.isAvailable(778)) {
            this.yMinVar = (NumericVariable)this.connectRaw((short)778);
            value = nx > 0 ? Variable.getValue((Variable)this.yMinVar, (int)0, (boolean)false) : null;
            value = nx > 1 ? Variable.getValue((Variable)this.yMinVar, (int)1, (boolean)false) : null;
            xvalue = this.model.getDoubleColumn(778);
            this.yMin = Double.MAX_VALUE;
            for (i = 0; i < nx; ++i) {
                d = xvalue[i];
                if (Double.isNaN(d)) continue;
                this.yMin = Math.min(this.yMin, d);
            }
        }
        if (this.model.isAvailable(779)) {
            this.yMaxVar = (NumericVariable)this.connectRaw((short)779);
            value = nx > 0 ? Variable.getValue((Variable)this.yMaxVar, (int)0, (boolean)false) : null;
            value = nx > 1 ? Variable.getValue((Variable)this.yMaxVar, (int)1, (boolean)false) : null;
            xvalue = this.model.getDoubleColumn(779);
            this.yMax = -1.7976931348623157E308;
            for (i = 0; i < nx; ++i) {
                d = xvalue[i];
                if (Double.isNaN(d)) continue;
                this.yMax = Math.max(this.yMax, d);
            }
        }
        if (this.model.isAvailable(780)) {
            this.meanVar = (NumericVariable)this.connectRaw((short)780);
            value = nx > 0 ? Variable.getValue((Variable)this.meanVar, (int)0, (boolean)false) : null;
            value = nx > 1 ? Variable.getValue((Variable)this.meanVar, (int)1, (boolean)false) : null;
            xvalue = this.model.getDoubleColumn(780);
        }
        if (this.model.isAvailable(781)) {
            this.connectVar = (NumericVariable)this.connectRaw((short)781);
            value = nx > 0 ? Variable.getValue((Variable)this.connectVar, (int)0, (boolean)false) : null;
            value = nx > 1 ? Variable.getValue((Variable)this.connectVar, (int)1, (boolean)false) : null;
            xvalue = this.model.getDoubleColumn(781);
        }
    }

    public boolean connectNetwork() {
        if (this.needSubgrpConnect) {
            this.connectSubgrpVar(true);
            this.updateXRange();
        }
        if (this.xRange == null) {
            return false;
        }
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        ValueMap xMap = this.xEncoder.getValueMap();
        if (this.numericX) {
            if (!(xMap instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            if (!(this.xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                this.xvalueMapper = new ContinuousRangeToNumericMapper();
            }
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)xMap);
        } else {
            if (!(xMap instanceof StringToNumericMap)) {
                return false;
            }
            if (!(this.xvalueMapper instanceof StringToNumericMapper)) {
                this.xvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)xMap);
        }
        if (this.numericX) {
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).input.connectFrom(((NumericVariable)this.xvalueVar).value);
        } else {
            ((StringToNumericMapper)this.xvalueMapper).input.connectFrom(((StringVariable)this.xvalueVar).value);
        }
        ValueMap yMap = this.yEncoder.getValueMap();
        if (!(yMap instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        if (this.yvalueMapper == null || !(this.yvalueMapper instanceof ContinuousRangeToNumericMapper)) {
            this.yvalueMapper = new ContinuousRangeToNumericMapper();
        }
        ((ContinuousRangeToNumericMapper)this.yvalueMapper).setMap((ContinuousRangeToNumericMap)yMap);
        this.buildConnector();
        this.needConnect = false;
        return true;
    }

    private void buildConnector() {
        Color color;
        if (this.connector == null) {
            this.connector = new QCPhaseBoxConnector();
        }
        ContinuousRangeToNumericMapper xMinMapper = new ContinuousRangeToNumericMapper();
        ContinuousRangeToNumericMapper xMaxMapper = new ContinuousRangeToNumericMapper();
        ContinuousRangeToNumericMapper yMinMapper = new ContinuousRangeToNumericMapper();
        ContinuousRangeToNumericMapper yMaxMapper = new ContinuousRangeToNumericMapper();
        xMinMapper.shareMap((ContinuousRangeToNumericMapper)this.xvalueMapper);
        xMaxMapper.shareMap((ContinuousRangeToNumericMapper)this.xvalueMapper);
        yMinMapper.shareMap((ContinuousRangeToNumericMapper)this.yvalueMapper);
        yMaxMapper.shareMap((ContinuousRangeToNumericMapper)this.yvalueMapper);
        if (this.numericX) {
            xMinMapper.input.connectFrom(((NumericVariable)this.xMinVar).value);
            xMaxMapper.input.connectFrom(((NumericVariable)this.xMaxVar).value);
        }
        yMinMapper.input.connectFrom(((NumericVariable)this.yMinVar).value);
        yMaxMapper.input.connectFrom(((NumericVariable)this.yMaxVar).value);
        this.connector.pointXMin.connectFrom((NumericPipe)xMinMapper);
        this.connector.pointXMax.connectFrom((NumericPipe)xMaxMapper);
        this.connector.pointYMin.connectFrom((NumericPipe)yMinMapper);
        this.connector.pointYMax.connectFrom((NumericPipe)yMaxMapper);
        this.connector.outline = this.outline;
        this.connector.fill = this.fill;
        this.connector.header = this.header;
        this.connector.text = this.header;
        this.connector.connectBox = this.connectBox;
        this.connector.connectMean = this.connectMean;
        this.connector.mean = this.mean;
        this.connector.outlineColor = this.borderStyle.getColor();
        this.connector.fillColor = this.fillStyle.getColor();
        if (this.header) {
            this.connector.headerColor = this.headerStyle.getColor();
            this.connector.labelFont = this.labelStyle.getFont();
            this.connector.labelColor = this.labelStyle.getColor();
            this.connector.labelVar = this.valueVar;
        }
        if (this.mean || this.connectBox || this.connectMean) {
            ContinuousRangeToNumericMapper meanMapper = new ContinuousRangeToNumericMapper();
            meanMapper.shareMap((ContinuousRangeToNumericMapper)this.yvalueMapper);
            meanMapper.input.connectFrom(((NumericVariable)this.meanVar).value);
            Marker meanMarker = new Marker();
            meanMarker.setSVGRender(StatGraph.VGF);
            int i = this.meanStyle.getShape();
            meanMarker.type.setValue(i);
            i = this.meanStyle.getSize();
            meanMarker.size.setValue(i);
            meanMarker.coordY.connectFrom((NumericPipe)meanMapper);
            color = this.meanStyle.getColor();
            meanMarker.color.setValue(this.applyDataTransparency(color));
            color = this.meanOutlineStyle.getColor();
            meanMarker.edgeColor.setValue(this.applyDataTransparency(color));
            meanMarker.edgeWeight.setValue(this.meanStyle.getWeight());
            meanMarker.edgeWidth.setValue(1);
            meanMarker.weightedEdgeEnabled.setValue(false);
            this.connector.meanMarker = meanMarker;
            this.connector.connectVar = this.connectVar;
        } else {
            this.connector.meanMarker = null;
            this.connector.connectVar = null;
        }
        if (this.connectBox || this.connectMean) {
            color = this.connectStyle.getColor();
            double d = this.connectStyle.getTransparency();
            this.connector.connectColor = d >= 0.0 && d < 1.0 ? QCPhaseBoxOverlay.applyTransparency((Color)color, (double)d) : color;
            this.connector.connectWidth = this.connectStyle.getWidth();
            this.connector.connectFactor = this.connectStyle.getStippleFactor();
            this.connector.connectPattern = this.connectStyle.getLinePattern();
        }
        double yFuzz = -0.5;
        double dx = QCShewhart.getBlockOffset((byte)1);
        double dy = 0.0;
        dy -= (double)(this.trackAscent + this.trackHeightPad);
        this.connector.xOffset = dx;
        this.connector.yOffset = dy += yFuzz;
        this.connector.headerHeight = this.trackHeight;
        this.connector.innerMarginX = this.getInnerMarginX();
        this.connector.innerMarginY = this.getInnerMarginY();
        this.networkRoot.addElement((Element)this.connector);
    }

    public int getLegendHeight() {
        this.xOffset = (int)this.getInnerMarginX();
        this.yOffset = (int)this.getInnerMarginY();
        if (this.header) {
            this.computeTrackHeight();
            this.legendHeight = this.trackHeight;
        } else {
            this.legendHeight = 0;
        }
        if (this.boundingBox) {
            this.legendHeight += this.yOffset;
        }
        return this.legendHeight;
    }

    public double getInnerMarginX() {
        double innerMarginX;
        double fuzz = 2.0;
        double glyphOffsetX = QCShewhart.getGlyphOffset((byte)1);
        if (glyphOffsetX <= fuzz) {
            innerMarginX = 0.0;
        } else {
            innerMarginX = this.chart.getPhaseBoxMargin((byte)1);
            innerMarginX += (double)QCMargins.getPhaseBoxInnerX();
        }
        return innerMarginX;
    }

    public double getInnerMarginY() {
        double innerMarginY = this.chart.getPhaseBoxMargin((byte)2);
        return innerMarginY += (double)QCMargins.getPhaseBoxInnerY();
    }

    private void computeTrackHeight() {
        if (this.header) {
            boolean useScaledFonts = false;
            Font font = useScaledFonts ? this.scaledLabelFont : this.labelStyle.getFont();
            this.channel.glSelect2DFont(font);
            int FUZZ = 1;
            this.trackDescent = (int)this.channel.glGetTextDescent() + FUZZ;
            this.trackAscent = (int)this.channel.glGetTextAscent();
            this.trackHeight = this.trackAscent + this.trackDescent;
            this.trackHeight += 2 * this.trackHeightPad;
        } else {
            this.trackDescent = 0;
            this.trackAscent = 0;
            this.trackHeight = 0;
        }
    }

    public Insets getPreferredInnerMargin(double glyphHeight) {
        Insets insets = new Insets(0, 0, 0, 0);
        Insets preferred = this.getPreferredInnerMarginInsets(glyphHeight);
        if (this.boundingBox) {
            int nTop = this.chart.getInnerMarginOverlaySize(1);
            int nBottom = this.chart.getInnerMarginOverlaySize(2);
            if (nTop == 0) {
                insets.top = preferred.top;
            }
            if (nBottom == 0) {
                insets.bottom = preferred.bottom;
            }
        }
        return insets;
    }

    public Insets getPreferredInnerMarginInsets() {
        return this.getPreferredInnerMarginInsets(0.0);
    }

    public Insets getPreferredInnerMarginInsets(double glyphHeight) {
        int top = 0;
        int bottom = 0;
        if (this.boundingBox) {
            ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
            double omax = map.getOutputMax();
            double omin = map.getOutputMin();
            double imax = map.getInputMax();
            double imin = map.getInputMin();
            double ratio = Math.abs((omax - omin) / (imax - imin));
            int header = this.getLegendHeight();
            int footer = QCShewhart.getBlockOffset((byte)1);
            double y = this.yMax;
            double d = imax - y;
            double space = Math.max(d * ratio, 0.0);
            if ((space -= glyphHeight) <= (double)header) {
                d = Math.ceil((double)header - space);
                top += (int)d;
            }
            footer += QCShewhart.getBlockOffset((byte)1);
            y = this.yMin;
            d = y - imin;
            space = Math.max(d * ratio, 0.0);
            if ((space -= glyphHeight) <= (double)footer) {
                d = Math.ceil((double)footer - space);
                bottom += (int)d;
            }
        }
        return new Insets(top, 0, bottom, 0);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle clip;
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        if (QCShewhart.singlePage()) {
            clip = this.outerAxisBounds;
        } else {
            QCOverlay.QCClipType rc = this.getClipType();
            switch (rc) {
                case INNER: {
                    clip = this.innerAxisBounds;
                    break;
                }
                default: {
                    clip = this.outerAxisBounds;
                }
            }
        }
        this.connector.init();
        g.setClip(clip);
        channel.glPushAttrib(0);
        this.networkRoot.draw(channel, false);
        channel.glPopAttrib();
    }

    public void drawWall(Graphics g, boolean highlightDraw) {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        if (!this.fill) {
            return;
        }
        this.connector.fill = true;
        this.connector.outline = false;
        this.connector.text = false;
        this.connector.mean = false;
        this.connector.connectBox = false;
        this.connector.connectMean = false;
        this.draw(g, highlightDraw);
        this.connector.fill = this.fill;
        this.connector.outline = this.outline;
        this.connector.text = this.header;
        this.connector.mean = this.mean;
        this.connector.connectBox = this.connectBox;
        this.connector.connectMean = this.connectMean;
    }

    @Override
    public void drawOutline(Graphics g, boolean highlightDraw) {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        if (!this.outline) {
            return;
        }
        this.connector.fill = false;
        this.connector.outline = true;
        this.connector.text = false;
        this.connector.mean = false;
        this.connector.connectBox = false;
        this.connector.connectMean = false;
        this.draw(g, highlightDraw);
        this.connector.fill = this.fill;
        this.connector.outline = this.outline;
        this.connector.text = this.header;
        this.connector.mean = this.mean;
        this.connector.connectBox = this.connectBox;
        this.connector.connectMean = this.connectMean;
    }

    public void drawText(Graphics g, boolean highlightDraw) {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        if (!this.header) {
            return;
        }
        this.connector.fill = false;
        this.connector.outline = false;
        this.connector.text = true;
        this.connector.mean = false;
        this.connector.connectBox = false;
        this.connector.connectMean = false;
        this.draw(g, highlightDraw);
        this.connector.fill = this.fill;
        this.connector.outline = this.outline;
        this.connector.text = this.header;
        this.connector.mean = this.mean;
        this.connector.connectBox = this.connectBox;
        this.connector.connectMean = this.connectMean;
    }

    public void drawMean(Graphics g, boolean highlightDraw) {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        if (!this.mean) {
            return;
        }
        this.connector.fill = false;
        this.connector.outline = false;
        this.connector.text = false;
        this.connector.mean = true;
        this.connector.connectBox = false;
        this.connector.connectMean = false;
        this.draw(g, highlightDraw);
        this.connector.fill = this.fill;
        this.connector.outline = this.outline;
        this.connector.text = this.header;
        this.connector.mean = this.mean;
        this.connector.connectBox = this.connectBox;
        this.connector.connectMean = this.connectMean;
    }

    public void drawConnect(Graphics g, boolean highlightDraw) {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        if (!this.connectBox && !this.connectMean) {
            return;
        }
        this.connector.fill = false;
        this.connector.outline = false;
        this.connector.text = false;
        this.connector.mean = false;
        this.connector.connectBox = this.connectBox;
        this.connector.connectMean = this.connectMean;
        this.draw(g, highlightDraw);
        this.connector.fill = this.fill;
        this.connector.outline = this.outline;
        this.connector.text = this.header;
        this.connector.mean = this.mean;
        this.connector.connectBox = this.connectBox;
        this.connector.connectMean = this.connectMean;
    }

    public double getOffsetX() {
        double offset = QCMargins.getPhaseBoxInnerX() + QCMargins.getPhaseBoxOuterX();
        offset = 0.0;
        return offset;
    }

    public double getOffsetY() {
        double offset = QCMargins.getPhaseBoxInnerY() + QCMargins.getPhaseBoxOuterY();
        offset = 0.0;
        return offset;
    }

    @Override
    public boolean overrideGTLRenderingOrder(boolean highlight) {
        return true;
    }

    public FillAttrs getFillAttrs() {
        return this.fillStyle;
    }

    public void setFillAttrs(FillAttrs style) {
        this.fillStyle = style;
    }

    public FillAttrs getAltFillAttrs() {
        return this.altFillStyle;
    }

    public void setAltFillAttrs(FillAttrs style) {
        this.altFillStyle = style;
    }

    public LineAttrs getBorderAttrs() {
        return this.borderStyle;
    }

    public void setBorderAttrs(LineAttrs style) {
        this.borderStyle = style;
    }

    public LineAttrs getConnectAttrs() {
        return this.connectStyle;
    }

    public void setConnectAttrs(LineAttrs style) {
        this.connectStyle = style;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextStyle style) {
        this.labelStyle = style;
    }

    public TextStyle getUnicodeLabelStyle() {
        return this.unicodeStyle;
    }

    public void setUnicodeLabelStyle(TextStyle style) {
        this.unicodeStyle = style;
    }

    public FillAttrs getHeaderAttrs() {
        return this.headerStyle;
    }

    public void setHeaderAttrs(FillAttrs style) {
        this.headerStyle = style;
    }

    public MarkerAttrs getMeanAttrs() {
        return this.meanStyle;
    }

    public void setMeanAttrs(MarkerAttrs style) {
        this.meanStyle = style;
    }

    public LineAttrs getMeanOutlineAttrs() {
        return this.meanOutlineStyle;
    }

    public void setMeanOutlineAttrs(LineAttrs style) {
        this.meanOutlineStyle = style;
    }

    public MarkerAttrs getMarkerAttrs() {
        return this.markerStyle;
    }

    public void setMarkerAttrs(MarkerAttrs style) {
        this.markerStyle = style;
    }

    public LineAttrs getMarkerOutlineAttrs() {
        return this.markerOutlineStyle;
    }

    public void setMarkerOutlineAttrs(LineAttrs style) {
        this.markerOutlineStyle = style;
    }

    public void connectSubgrpVar(boolean printError) {
        CRD primaryModel;
        this.needSubgrpConnect = true;
        boolean test = true;
        CRD cRD = primaryModel = test ? this.subgrpModel : QCShewhart.getPrimaryModel();
        if (primaryModel == null) {
            if (printError) {
                boolean supress = !printError;
                StatGraph.printError((String)"The primaryModel is null in QCBlockOverlay.connectSubgrpVar().", (boolean)supress);
            }
            return;
        }
        if (primaryModel.isAvailable(10)) {
            CRD save = this.model;
            this.model = primaryModel;
            this.numericX = this.model.getColumnClass(10) == Double.class;
            Variable variable = this.xvalueVar = this.discreteX ? this.connectCategory((short)10, this.missingCategoryOn) : this.connectRaw((short)10);
            if (this.numericX && this.discreteX) {
                this.numericXVar = new NumericVectorVariable();
                this.numericXVar.connectFrom(this.model.getDoubleColumn(10));
                SASFormat fmt = ((ColumnMetadata)this.model.getColumnLabel(10)).getFormat();
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                }
                this.numericXVar.setFormat(new GTKFormat((Format)fmt));
            }
            if (this.discreteX) {
                this.numericDiscreteX = this.numericX;
                this.numericX = false;
            }
            this.model = save;
        } else {
            this.xvalueVar = null;
        }
        this.needSubgrpConnect = false;
    }

    public void setSubgrpModel(CRD model) {
        this.subgrpModel = model;
        if (QCShewhart.getPrimaryModel() == null) {
            QCShewhart.setPrimaryModel(model);
        }
    }

    public boolean hasSubgrpModel() {
        return this.subgrpModel != null;
    }

    public CRD getSubgrpModel() {
        return this.subgrpModel;
    }

    protected void updateXRange() {
        Object newRange = null;
        DataRange oldRange = this.xRange;
        if (this.xvalueVar != null) {
            int num;
            int n = num = this.numericX ? this.xvalueVar.getValueCount() : this.xvalueVar.getUniqueValueCount();
            if (num > 0) {
                newRange = this.numericX ? this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, !this.xUnionAllPages) : (this.numericDiscreteX ? this.makeOrdinalRange((StringVariable)this.xvalueVar, num, (NumericVariable)this.numericXVar, (short)10, !this.xUnionAllPages) : this.makeDiscreteRange((StringVariable)this.xvalueVar, num, (short)10, !this.xUnionAllPages));
                if (newRange != null) {
                    newRange.setLabel(this.xvalueVar.getLabel());
                }
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 10);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateXRange(CRD model2) {
        Object newRange = null;
        DataRange oldRange = this.xRange;
        CRD save = this.model;
        this.model = model2;
        if (this.xvalueVar != null) {
            int num;
            int n = num = this.numericX ? this.xvalueVar.getValueCount() : this.xvalueVar.getUniqueValueCount();
            if (num > 0) {
                newRange = this.numericX ? this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, !this.xUnionAllPages) : (this.numericDiscreteX ? this.makeOrdinalRange((StringVariable)this.xvalueVar, num, (NumericVariable)this.numericXVar, (short)10, !this.xUnionAllPages) : this.makeDiscreteRange((StringVariable)this.xvalueVar, num, (short)10, !this.xUnionAllPages));
                if (newRange != null) {
                    newRange.setLabel(this.xvalueVar.getLabel());
                }
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 10);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
        this.model = save;
    }

    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        if (this.subgrpModel != null) {
            this.updateXRange(this.subgrpModel);
        } else {
            this.updateXRange();
        }
    }

    public boolean getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(boolean b) {
        this.boundingBox = b;
    }

    public boolean getFill() {
        return this.fill;
    }

    public void setFill(boolean b) {
        this.fill = b;
        if (this.connector != null) {
            this.connector.fill = this.fill;
        }
    }

    public boolean getOutline() {
        return this.outline;
    }

    public void setOutline(boolean b) {
        this.outline = b;
        if (this.connector != null) {
            this.connector.outline = this.outline;
        }
    }

    public boolean getHeader() {
        return this.header;
    }

    public void setHeader(boolean b) {
        this.header = b;
        if (this.connector != null) {
            this.connector.header = this.header;
        }
    }

    public boolean getConnect() {
        return this.connectBox || this.connectMean;
    }

    public boolean getConnectBox() {
        return this.connectBox;
    }

    public void setConnectBox(boolean b) {
        this.connectBox = b;
        if (this.connector != null) {
            this.connector.connectBox = this.connectBox;
        }
    }

    public boolean getConnectMean() {
        return this.connectMean;
    }

    public void setConnectMean(boolean b) {
        this.connectMean = b;
        if (this.connector != null) {
            this.connector.connectMean = this.connectMean;
        }
    }

    public boolean getMean() {
        return this.mean;
    }

    public void setMean(boolean b) {
        this.mean = b;
        if (this.connector != null) {
            this.connector.mean = this.mean;
        }
    }

    @Override
    public QCOverlay.QCClipType getClipType() {
        return QCOverlay.QCClipType.OUTER_X;
    }

    public void setLegendLabel(String aString) {
        this.legendLabel = aString;
        this.legend = this.legendLabel != null;
    }

    public LegendItem[] getLegendItems(int attrType) {
        int i;
        double d;
        Color color;
        if (!this.legend) {
            return null;
        }
        LegendItem[] entries = null;
        boolean filledOutlinedMarker = true;
        boolean connect = this.connectBox || this.connectMean;
        boolean rc = false;
        MarkerAttrs attr = null;
        LineAttrs attr2 = null;
        LineAttrs outlineAttrs = null;
        if (this.mean) {
            attr = new MarkerAttrs();
            rc = true;
            color = this.meanStyle.getColor();
            d = this.meanStyle.getTransparency();
            if (d >= 0.0 && d < 1.0) {
                color = QCPhaseBoxOverlay.applyTransparency((Color)color, (double)d);
            }
            attr.setColor(color);
            i = this.meanStyle.getShape();
            attr.setShape(i);
            i = this.meanStyle.getSize();
            attr.setSize(i);
            i = this.meanStyle.getWeight();
            attr.setWeight(i);
            if (filledOutlinedMarker) {
                outlineAttrs = new LineAttrs();
                color = this.meanOutlineStyle.getColor();
                d = this.meanOutlineStyle.getTransparency();
                if (d >= 0.0 && d < 1.0) {
                    color = QCPhaseBoxOverlay.applyTransparency((Color)color, (double)d);
                }
                outlineAttrs.setColor(color);
                outlineAttrs.setWidth(1);
            }
        }
        if (connect) {
            attr2 = new LineAttrs();
            rc = true;
            color = this.connectStyle.getColor();
            d = this.connectStyle.getTransparency();
            if (d >= 0.0 && d < 1.0) {
                color = QCPhaseBoxOverlay.applyTransparency((Color)color, (double)d);
            }
            attr2.setColor(color);
            i = this.connectStyle.getLinePattern();
            attr2.setLinePattern(i);
            i = this.connectStyle.getWidth();
            i = Math.min(i, 3);
            attr2.setWidth(i);
        }
        if (rc) {
            entries = new LegendItem[1];
            String label = this.getLegendLabel();
            entries[0] = attr == null ? new LegendItem((ColorAttr)attr2, null, label, null) : new LegendItem((ColorAttr)attr, (ColorAttr)attr2, label, null);
            entries[0].setMarkerOutlineAttrs(outlineAttrs);
        }
        return entries;
    }
}

