/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.overlays;

import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.QCStylizedTextElement;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCLimitsOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCPhaseBoxOverlay;
import com.sas.analytics.qc.statgraph.sgchart.util.BBox;
import com.sas.analytics.qc.statgraph.sgchart.util.QCMargins;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.text.AttributedString;
import java.text.Format;
import java.util.HashMap;
import java.util.Vector;

public class QCBlockOverlay
extends QCOverlay {
    public static final String RB_KEY = "QCBlockOverlay.";
    public static final int TRUNCATE = 0;
    public static final int SHRINK = 1;
    public static final int SPLIT = 2;
    public static final int SPLITALWAYS = 3;
    public static final int NONE = 4;
    private int valueFitStrategy = 1;
    private double yFuzz = 0.0;
    private int only = -1;
    protected StringVariable phaseUCL1Var = null;
    protected StringVariable phaseCTL1Var = null;
    protected StringVariable phaseLCL1Var = null;
    protected StringVariable phaseUCL2Var = null;
    protected StringVariable phaseCTL2Var = null;
    protected StringVariable phaseLCL2Var = null;
    protected CRD subgrpModel = null;
    protected DataRange xRange = null;
    protected boolean vref = false;
    protected String vrefPhase = null;
    protected String vrefIndex = null;
    protected boolean sref = false;
    protected String srefPhase = null;
    protected String srefIndex = null;
    private NumericVectorVariable numericXVar;
    private NumericProperty pointX = new NumericProperty();
    private FillAttrs wallStyle = new FillAttrs();
    private FillAttrs blockStyle = new FillAttrs();
    private FillAttrs altBlockStyle = new FillAttrs();
    private LineAttrs refLineStyle = new LineAttrs();
    private FillAttrs refFillStyle = new FillAttrs();
    private FillAttrs altRefFillStyle = new FillAttrs();
    private FillAttrs headerStyle = new FillAttrs();
    private LineAttrs borderStyle = new LineAttrs();
    private TextStyle textStyle = new TextStyle();
    private TextStyle labelStyle = new TextStyle();
    private TextStyle unicodeStyle;
    public boolean selectable = false;
    protected ColorEncoder colorEncoder;
    private HashMap groupValue2Category;
    private Variable blockFillIndexVar;
    protected double blockFillTransparency = 1.0;
    protected boolean debug = false;
    protected int nObs = 0;
    protected int nDisplay = 0;
    protected Vector<Block> blocks;
    protected int nBlocks = 0;
    protected BlockType type = BlockType.BLOCK;
    protected int[] refList;
    protected int[] refListScreen;
    protected int[] refListLevels;
    protected LegendPosition legendPosition;
    protected LabelPosition labelPosition;
    protected boolean legendOn = false;
    protected boolean labelsOn;
    protected boolean legendFillOn = true;
    protected boolean legendOutlineOn = true;
    protected LabelFit fitType;
    protected String fillType;
    protected boolean repeatValues;
    protected boolean userSetLabelFont = false;
    protected boolean clipChartArea = true;
    protected boolean phaseLimits = false;
    protected boolean phaseRefLine = false;
    protected int phaseRefLineType = 1;
    protected boolean phaseRefFill = false;
    protected float phaseRefFillOpacity = 0.15f;
    protected boolean vFrame;
    protected boolean hFrame;
    protected boolean regionOutlines;
    protected int trackTextHeight = 0;
    protected int trackTextHeightPad = 0;
    protected int trackTextAscent = 0;
    protected int trackTextDescent = 0;
    protected int trackLabelHeight = 0;
    protected int trackLabelHeightPad = 0;
    protected int trackLabelAscent = 0;
    protected int trackLabelDescent = 0;
    protected int legendHeight = 0;
    protected int legendOffset = 0;
    protected int legendWidth = 0;
    protected int xLineOffset = 0;
    protected int xTextOffset = 0;
    protected int yOffset = 0;
    protected Point origin;
    private boolean useScaledFonts = false;
    protected Font scaledLabelFont;
    protected Font uniCodeFont;
    protected Font scaledUniCodeFont;
    protected Font qcFontSans;
    protected Font scaledQCFontSans;
    protected Font qcFontSerif;
    protected Font scaledQCFontSerif;
    protected boolean updateData = true;
    protected boolean updateLayout = true;
    protected boolean updateGraph = true;

    public QCBlockOverlay() {
        this.blocks = new Vector();
        this.origin = new Point();
        this.legendPosition = LegendPosition.MAX;
        this.labelPosition = LabelPosition.ABOVE;
    }

    public void setBlockType(BlockType t) {
        this.type = t;
    }

    public BlockType getBlockType() {
        return this.type;
    }

    public void setLegendOutline(boolean b) {
        this.legendOutlineOn = b;
    }

    public boolean getLegendOutline() {
        return this.legendOutlineOn;
    }

    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.nObs = this.model.getRowCount();
        this.connectVars();
        if (this.subgrpModel != null) {
            this.updateXRange(this.subgrpModel);
        } else {
            this.updateXRange();
        }
        this.initBlocks();
    }

    protected void connectVars() {
        Block block = null;
        this.connectSubgrpVar(false);
        Variable var = null;
        Variable altVar = null;
        Object value = null;
        int nx = this.model.getRowCount();
        if (this.model.isAvailable(754)) {
            var = this.connectRaw((short)754);
            Object object = value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
        }
        if (this.model.isAvailable(755)) {
            var = this.connectRaw((short)755);
            Object object = value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
        }
        if (this.model.isAvailable(787)) {
            var = this.connectRaw((short)787);
            value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
            Object object = value = nx > 1 ? Variable.getValue((Variable)var, (int)1, (boolean)false) : null;
        }
        if (this.model.isAvailable(757)) {
            var = this.connectRaw((short)757);
            Object object = value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
        }
        if (this.model.isAvailable(768)) {
            var = this.connectRaw((short)768);
            Object object = value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
        }
        if (this.model.isAvailable(771)) {
            var = this.connectRaw((short)771);
            value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
            this.phaseUCL1Var = (StringVariable)var;
        }
        if (this.model.isAvailable(772)) {
            var = this.connectRaw((short)772);
            value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
            this.phaseCTL1Var = (StringVariable)var;
        }
        if (this.model.isAvailable(773)) {
            var = this.connectRaw((short)773);
            value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
            this.phaseLCL1Var = (StringVariable)var;
        }
        if (this.model.isAvailable(774)) {
            var = this.connectRaw((short)774);
            value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
            this.phaseUCL2Var = (StringVariable)var;
        }
        if (this.model.isAvailable(775)) {
            var = this.connectRaw((short)775);
            value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
            this.phaseCTL2Var = (StringVariable)var;
        }
        if (this.model.isAvailable(776)) {
            var = this.connectRaw((short)776);
            value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
            this.phaseLCL2Var = (StringVariable)var;
        }
        boolean numeric = false;
        if (this.model.isAvailable(758)) {
            var = this.connectRaw((short)758);
            value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
            numeric = this.model.getColumnClass(758) == Double.class;
        }
        this.blockFillIndexVar = null;
        if (this.model.isAvailable(761)) {
            var = this.connectRaw((short)761);
            value = nx > 0 ? Variable.getValue((Variable)var, (int)0, (boolean)false) : null;
            this.blockFillIndexVar = var;
        }
        altVar = this.model.isAvailable(760) ? this.connectRaw((short)760) : null;
        if (this.model.isAvailable(759)) {
            var = this.connectRaw((short)759);
            String label = "";
            String altLabel = "";
            String prevLabel = "";
            SASFormat fmt = this.model.getColumnFormat((short)759);
            this.nBlocks = 0;
            for (int i = 0; i < this.nObs; ++i) {
                label = Variable.getValue((Variable)var, (int)i, (boolean)true).toString().trim();
                if (label.equals(".")) {
                    prevLabel = label;
                    continue;
                }
                if (label.equals(prevLabel)) {
                    if (block == null) continue;
                    block.labelLastObs = i;
                    continue;
                }
                prevLabel = label;
                block = new Block(this.type);
                block.label = label;
                block.alternateLabel = altVar == null ? label : Variable.getValue((Variable)altVar, (int)i, (boolean)true).toString().trim();
                block.role = 758;
                block.numeric = numeric;
                block.labelFirstObs = i;
                block.labelLastObs = i;
                block.fillType = this.fillType;
                block.display = true;
                block.labelDisplay = this.labelPosition != LabelPosition.NONE;
                block.rotateEntry = this.fitType == LabelFit.ROTATED;
                this.addBlock(block);
                ++this.nBlocks;
            }
        } else {
            block = new Block(this.type);
            block.label = null;
            block.alternateLabel = null;
            block.role = 758;
            block.numeric = numeric;
            block.labelFirstObs = 0;
            block.labelLastObs = this.nObs - 1;
            block.fillType = this.fillType;
            block.display = true;
            block.labelDisplay = this.labelPosition != LabelPosition.NONE;
            block.rotateEntry = this.fitType == LabelFit.ROTATED;
            this.addBlock(block);
            this.nBlocks = 1;
        }
    }

    public void connectSubgrpVar(boolean printError) {
        this.needSubgrpConnect = true;
        CRD primaryModel = this.subgrpModel;
        if (primaryModel == null) {
            if (printError) {
                boolean supress = !printError;
                StatGraph.printError((String)"The primaryModel is null in QCBlockOverlay.connectSubgrpVar().", (boolean)supress);
            }
            return;
        }
        if (primaryModel.isAvailable(10)) {
            CRD save = this.model;
            this.model = primaryModel;
            this.numericX = this.model.getColumnClass(10) == Double.class;
            Variable variable = this.xvalueVar = this.discreteX ? this.connectCategory((short)10, this.missingCategoryOn) : this.connectRaw((short)10);
            if (this.numericX && this.discreteX) {
                this.numericXVar = new NumericVectorVariable();
                this.numericXVar.connectFrom(this.model.getDoubleColumn(10));
                SASFormat fmt = ((ColumnMetadata)this.model.getColumnLabel(10)).getFormat();
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                }
                this.numericXVar.setFormat(new GTKFormat((Format)fmt));
            }
            if (this.discreteX) {
                this.numericDiscreteX = this.numericX;
                this.numericX = false;
            }
            this.model = save;
        } else {
            this.xvalueVar = null;
        }
        this.needSubgrpConnect = false;
    }

    public void setSubgrpModel(CRD model) {
        this.subgrpModel = model;
        if (QCShewhart.getPrimaryModel() == null) {
            QCShewhart.setPrimaryModel(model);
        }
    }

    public boolean hasSubgrpModel() {
        return this.subgrpModel != null;
    }

    public CRD getSubgrpModel() {
        return this.subgrpModel;
    }

    public void setVRefPhaseVar(String var) {
        this.vrefPhase = var;
        this.vref = true;
    }

    public void setVRefIndexVar(String var) {
        this.vrefIndex = var;
        this.vref = true;
    }

    public boolean hasVRefs() {
        return this.vref;
    }

    public String getVRefPhaseVar() {
        return this.vref ? this.vrefPhase : null;
    }

    public String getVRefIndexVar() {
        return this.vref ? this.vrefIndex : null;
    }

    public void setSRefPhaseVar(String var) {
        this.srefPhase = var;
        this.sref = true;
    }

    public void setSRefIndexVar(String var) {
        this.srefIndex = var;
        this.sref = true;
    }

    public boolean hasSRefs() {
        return this.sref;
    }

    public String getSRefPhaseVar() {
        return this.sref ? this.srefPhase : null;
    }

    public String getSRefIndexVar() {
        return this.sref ? this.srefIndex : null;
    }

    public boolean initBlocks() {
        if (!this.updateData) {
            return false;
        }
        this.nDisplay = 0;
        if (this.nBlocks == 0) {
            return false;
        }
        this.buildBlocks();
        this.buildRefList();
        this.updateData = false;
        this.updateLayout = true;
        return true;
    }

    private boolean buildBlocks() {
        int iBlockVal0;
        Object o = null;
        boolean firstPage = QCShewhart.isFirstPage();
        boolean lastPage = QCShewhart.isLastPage();
        boolean singlePage = QCShewhart.singlePage();
        int igrpLower = QCShewhart.getLowerSubgrpIndex();
        int igrpUpper = QCShewhart.getUpperSubgrpIndex();
        int n = singlePage ? 0 : (firstPage ? igrpLower : (iBlockVal0 = lastPage ? 0 : 0));
        int nBlockValue = singlePage ? this.nObs : (firstPage ? this.nObs - 1 : (lastPage ? this.nObs - 1 : this.nObs));
        SASFormat fmt = this.model.getColumnFormat((short)758);
        double[] xStart = this.model.getDoubleColumn(754);
        double[] xEnd = this.model.getDoubleColumn(755);
        FontMetrics fmLabel = StatGraph.getFontMetrics((Font)this.labelStyle.getFont());
        FontMetrics fmText = StatGraph.getFontMetrics((Font)this.textStyle.getFont());
        int splitWidth = -1;
        double[] index = this.model.getDoubleColumn(757);
        double[] limits = this.getDoubleColumn(768);
        double[] fillIndex = this.getDoubleColumn(761);
        for (int iBlock = 0; iBlock < this.nBlocks; ++iBlock) {
            Block block = this.blocks.get(iBlock);
            Vector<BlockEntry> entries = block.entries;
            boolean numeric = block.numeric;
            double[] y = numeric ? this.model.getDoubleColumn(block.role) : null;
            int first = block.labelFirstObs;
            int last = block.labelLastObs;
            for (int iValue = first; iValue <= last; ++iValue) {
                int iLower;
                String s;
                boolean displayLabel = true;
                if (numeric) {
                    s = fmt == null ? String.valueOf(y[iValue]) : fmt.format((Object)new Double(y[iValue])).trim();
                } else {
                    s = this.model.getStringColumn(block.role)[iValue];
                    if (s == null) {
                        s = "-" + (iValue + 1) + "-";
                        displayLabel = false;
                    } else {
                        if (fmt != null) {
                            s = fmt.format((Object)s).trim();
                        }
                        s = QCStylizedTextElement.replaceUStrings(s);
                        s = QCStylizedTextElement.replaceUnicodeStrings(s);
                        s = this.getSplitValue(s, fmLabel, fmText, splitWidth);
                    }
                }
                int iStart = (int)xStart[iValue];
                int iEnd = iValue == block.labelLastObs ? (int)xEnd[iValue] + 1 : (int)xStart[iValue + 1];
                if (--iStart >= igrpUpper + 1 || --iEnd < (iLower = igrpLower)) continue;
                BlockEntry entry = new BlockEntry(s, iStart, iEnd);
                entry.alternate = index == null ? iValue : (int)index[iValue];
                int n2 = entry.level = index == null ? iValue : (int)index[iValue];
                if (this.fillType.equalsIgnoreCase("Alternate") || fillIndex == null) {
                    entry.alternate %= 2;
                } else if (this.fillType.equalsIgnoreCase("Variable")) {
                    int f;
                    entry.fillIndex = f = (int)fillIndex[iValue];
                    if (f == -98) {
                        entry.alternate %= 2;
                    } else if (f == -99) {
                        entry.alternate %= 2;
                    }
                }
                entry.limits = limits == null ? false : limits[iValue] != 0.0;
                entry.displayLabel = displayLabel;
                entries.addElement(entry);
            }
            block.nEntries = entries.size();
        }
        return true;
    }

    public void buildRefList() {
        Block block;
        int i;
        if (this.nBlocks == 0 || this.blocks == null) {
            return;
        }
        int index = -1;
        if (this.phaseRefLineType == 2) {
            for (i = this.nBlocks - 1; i >= 0; --i) {
                block = this.blocks.get(i);
                if (!block.display) continue;
                index = i;
                break;
            }
        } else if (this.phaseRefLineType == 1) {
            for (i = 0; i < this.nBlocks; ++i) {
                block = this.blocks.get(i);
                if (!block.display) continue;
                index = i;
                break;
            }
        }
        if (index == -1) {
            int n = index = (this.phaseRefLine || this.phaseRefFill) && this.phaseRefLineType != 3 ? 0 : -1;
        }
        if (index == -1) {
            return;
        }
        block = this.blocks.get(index);
        Vector<BlockEntry> entries = block.entries;
        int n = entries.size();
        if (n == 0) {
            this.refList = null;
            this.refListLevels = null;
            this.refListScreen = null;
        } else {
            int[] refs = new int[n];
            int[] levels = new int[n];
            int[] screen = new int[n];
            for (i = 0; i < n; ++i) {
                BlockEntry entry = entries.get(i);
                refs[i] = entry.first;
                levels[i] = entry.alternate;
                screen[i] = -1;
            }
            this.refList = refs;
            this.refListLevels = levels;
            this.refListScreen = screen;
        }
    }

    public int[] getRefList() {
        return this.refList;
    }

    public int[] getRefListLevels() {
        return this.refListLevels;
    }

    public int getIGrpLower() {
        int igrpLower = 0;
        return igrpLower;
    }

    public int getIGrpUpper() {
        int igrpUpper = this.model.getRowCount() - 1;
        return igrpUpper;
    }

    public double getPreferredOffset(byte dimension) {
        double offset = 0.0;
        if (dimension == 1) {
            offset = 0.0;
        } else if (dimension == 2) {
            offset = 0.0;
        }
        return offset;
    }

    public int getOverlayMargin() {
        QCPhaseBoxOverlay phaseBox;
        int just = this.getOverlayJustification();
        QCBlockOverlay[] overlays = this.chart.getInnerMarginOverlays(just);
        int n = this.chart.getInnerMarginOverlaySize(just);
        int h = 0;
        if (n == 0) {
            return 0;
        }
        if (!this.legendOn) {
            return 0;
        }
        if (!this.isInnerMarginOverlay()) {
            return 0;
        }
        int phaseBoxTop = 0;
        int phaseBoxBottom = 0;
        if (this == overlays[0] && (phaseBox = this.chart.getPhaseBoxOverlay()) != null) {
            Insets insets = phaseBox.getPreferredInnerMarginInsets();
            phaseBoxTop = insets.top;
            phaseBoxBottom = insets.bottom;
        }
        switch (just) {
            case 1: {
                h = this.getLegendHeight();
                h += phaseBoxTop;
                break;
            }
            case 2: {
                h = this.getLegendHeight();
                h += phaseBoxBottom;
                break;
            }
            default: {
                h = 0;
            }
        }
        return h;
    }

    public Insets getPreferredInnerMargin() {
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        if (this.legendOn && this.isInnerMarginOverlay()) {
            int just = this.getOverlayJustification();
            QCBlockOverlay[] overlays = this.chart.getInnerMarginOverlays(just);
            int n = this.chart.getInnerMarginOverlaySize(just);
            int height = 0;
            for (int i = 0; i < n; ++i) {
                height += overlays[i].getLegendHeight();
            }
            switch (just) {
                case 1: {
                    top = height;
                    break;
                }
                case 2: {
                    bottom = height;
                    break;
                }
            }
            QCPhaseBoxOverlay phaseBox = this.chart.getPhaseBoxOverlay();
            if (phaseBox != null) {
                Insets insets = phaseBox.getPreferredInnerMarginInsets();
                top += insets.top;
                bottom += insets.bottom;
            }
        }
        this.chart.preferedInnerMargin = new Insets(top, left, bottom, right);
        top = 0;
        bottom = 0;
        return new Insets(top, 0, bottom, 0);
    }

    public Insets getPreferredOuterMargin() {
        int left = 0;
        int right = 0;
        int lineWidth = this.borderStyle.width;
        int labelOffset = QCMargins.getAxisOuterX() + (int)((double)lineWidth / 2.0);
        if (this.legendOn) {
            switch (this.labelPosition.ordinal()) {
                case 2: {
                    left = this.legendWidth;
                    left += labelOffset;
                    break;
                }
                case 3: {
                    right = this.legendWidth;
                    right += labelOffset;
                    break;
                }
            }
        }
        return new Insets(0, left, 0, right);
    }

    public int getLegendHeight() {
        boolean test = this.updateLayout;
        if (this.updateLayout) {
            this.xLineOffset = QCShewhart.getPhaseBoxOffset((byte)1);
            this.xTextOffset = QCShewhart.getTextOffset((byte)1);
            this.yOffset = QCShewhart.getBlockOffset((byte)1);
            this.computeLayout();
            this.computeTrackHeight();
            if (this.sizeFonts()) {
                this.computeLayout();
                this.computeTrackHeight();
            }
            this.computeLegendSize();
        }
        return this.legendHeight;
    }

    private void computeTrackHeight() {
        int FUZZ = 1;
        Font font = this.useScaledFonts ? this.scaledLabelFont : this.textStyle.getFont();
        this.channel.glSelect2DFont(font);
        this.trackTextDescent = (int)this.channel.glGetTextDescent() + FUZZ;
        this.trackTextAscent = (int)this.channel.glGetTextAscent();
        this.trackTextHeight = this.trackTextAscent + this.trackTextDescent;
        this.trackTextHeight += 2 * this.trackTextHeightPad;
        font = this.useScaledFonts ? this.scaledLabelFont : this.labelStyle.getFont();
        this.channel.glSelect2DFont(font);
        this.trackLabelDescent = (int)this.channel.glGetTextDescent() + FUZZ;
        this.trackLabelAscent = (int)this.channel.glGetTextAscent();
        this.trackLabelHeight = this.trackLabelAscent + this.trackLabelDescent;
        this.trackLabelHeight += 2 * this.trackLabelHeightPad;
    }

    private void computeLayout() {
        double d2;
        double d1;
        Block block;
        int iBlockVar;
        Font font = null;
        if (!this.legendOn) {
            this.legendHeight = 0;
            this.legendWidth = 0;
            return;
        }
        int width = 0;
        int alternateWidth = 0;
        double wd = this.outerAxisBounds == null ? 1.0 : (double)this.outerAxisBounds.width;
        StatGraph graph = QCShewhart.getStatGraph();
        if (graph != null) {
            wd = graph.size.getWidth();
        }
        for (iBlockVar = 0; iBlockVar < this.nBlocks; ++iBlockVar) {
            block = this.blocks.get(iBlockVar);
            font = this.useScaledFonts ? this.scaledLabelFont : this.labelStyle.getFont();
            this.channel.glSelect2DFont(font);
            block.labelHeight = (int)this.channel.glGetTextHeight(block.label);
            block.labelWidth = block.label == null ? 0 : (int)this.channel.glGetTextWidth(block.label);
            block.alternateWidth = block.alternateLabel == null ? 0 : (int)this.channel.glGetTextWidth(block.alternateLabel);
            width = Math.max(width, block.labelWidth);
            alternateWidth = Math.max(alternateWidth, block.alternateWidth);
            d1 = (double)width / wd;
            d2 = (double)alternateWidth / wd;
            block.alternateDisplay = d1 > 0.85;
            block.alternateDisplay = false;
            int maxValueWidth = 0;
            int maxValueHeight = 0;
            Vector<BlockEntry> entries = block.entries;
            int n = entries.size();
            for (int iBlockValue = 0; iBlockValue < n; ++iBlockValue) {
                BlockEntry entry = entries.get(iBlockValue);
                font = this.useScaledFonts ? this.scaledLabelFont : this.textStyle.getFont();
                this.channel.glSelect2DFont(font);
                Vector attributes = entry.labelAttributes;
                if (attributes != null) {
                    entry.labelWidth = (int)this.channel.glGetTextWidth(entry.label);
                    entry.labelHeight = (int)this.channel.glGetTextHeight(entry.label);
                } else if (entry.label != null) {
                    entry.labelWidth = (int)this.channel.glGetTextWidth(entry.label);
                    entry.labelHeight = (int)this.channel.glGetTextHeight(entry.label);
                } else {
                    entry.labelWidth = 0;
                    entry.labelHeight = 0;
                }
                maxValueWidth = Math.max(entry.labelWidth, maxValueWidth);
                maxValueHeight = Math.max(entry.labelHeight, maxValueHeight);
            }
            if (this.labelPosition == LabelPosition.ROTATED) {
                maxValueWidth = Math.max(block.labelWidth, maxValueWidth);
            }
            block.maxValueWidth = maxValueWidth;
            block.maxValueHeight = maxValueHeight;
        }
        if (this.labelPosition == LabelPosition.ABOVE || this.labelPosition == LabelPosition.NONE) {
            this.legendWidth = 0;
        } else {
            d1 = (double)width / wd;
            d2 = (double)alternateWidth / wd;
            if (d1 > 0.25) {
                for (iBlockVar = 0; iBlockVar < this.nBlocks; ++iBlockVar) {
                    block = this.blocks.get(iBlockVar);
                    block.alternateDisplay = true;
                }
                this.legendWidth = this.labelsOn ? alternateWidth : 0;
            } else {
                this.legendWidth = this.labelsOn ? width : 0;
            }
        }
    }

    public boolean isEntryInRange(Block block, int i) {
        Vector<BlockEntry> entries = block.entries;
        int n = block.nEntries;
        BlockEntry entry = entries.get(i);
        int igrp = entry.last;
        BlockEntry next = null;
        int jgrp = -1;
        boolean rc = true;
        int igrpLower = QCShewhart.getLowerSubgrpIndex();
        if (igrp <= igrpLower) {
            rc = false;
            int j = i + 1;
            if (j < n) {
                next = entries.get(j);
                jgrp = next.first;
            }
        }
        return rc;
    }

    public boolean isEntryInRange(BlockEntry entry) {
        String label = entry.label;
        int first = entry.first;
        int last = entry.last;
        int igrpLower = QCShewhart.getLowerSubgrpIndex();
        int igrpUpper = QCShewhart.getUpperSubgrpIndex();
        if (last <= igrpLower) {
            return this.isEntryFromPrevPage(entry);
        }
        return first <= igrpUpper;
    }

    public boolean isEntryFromPrevPage(BlockEntry entry) {
        int igrpLower = QCShewhart.getLowerSubgrpIndex();
        boolean ifirst = entry.first < igrpLower;
        boolean ilast = entry.last == igrpLower;
        boolean extend = false;
        extend = ifirst && ilast;
        return extend;
    }

    public boolean isEntryFromNextPage(BlockEntry entry) {
        return false;
    }

    private void computeLegendXY() {
        double x;
        int iBlockValue;
        int n;
        BlockEntry entry;
        Vector<BlockEntry> entries;
        boolean firstEntry;
        Block block;
        int j;
        int iBlockVar;
        if (!this.legendOn) {
            return;
        }
        BlockType blockType = this.type;
        boolean legendAbove = this.legendPosition == LegendPosition.ABOVE || this.legendPosition == LegendPosition.MAX;
        double x0 = this.outerAxisBounds.x - this.innerAxisBounds.x;
        double x1 = this.outerAxisBounds.width;
        double xl = 0.0;
        double xr = 0.0;
        double xc = 0.0;
        int blockOffset = QCShewhart.getAdjustedBlockOffset();
        int igrpLower = QCShewhart.getLowerSubgrpIndex();
        int igrpUpper = QCShewhart.getUpperSubgrpIndex() + igrpLower;
        int fuzz = 1;
        int halfWidth = this.borderStyle.width / 2;
        int labelOffset = QCMargins.getAxisOuterX() + halfWidth - fuzz;
        BlockEntry last = null;
        for (iBlockVar = 0; iBlockVar < this.nBlocks; ++iBlockVar) {
            j = legendAbove ? this.nBlocks - (iBlockVar + 1) : iBlockVar;
            block = this.blocks.get(j);
            if (!block.display) continue;
            firstEntry = true;
            entries = block.entries;
            entry = null;
            BlockEntry prev = null;
            n = entries.size();
            double xLeft = Double.NaN;
            double prevXLeft = Double.NaN;
            for (iBlockValue = 0; iBlockValue < n; ++iBlockValue) {
                entry = entries.get(iBlockValue);
                if (!this.isEntryInRange(entry)) continue;
                last = entry;
                if (firstEntry) {
                    entry.x = x0;
                    entry.xLeft = xLeft = x0;
                } else {
                    int igrp = entry.first;
                    try {
                        xc = x = this.pointX.getValue(igrp);
                        entry.x = xc -= (double)(blockOffset - this.xTextOffset);
                        entry.xLeft = xLeft = x - (double)blockOffset;
                    }
                    catch (MissingValueException mve) {
                        StatGraph.printDebug((String)"pointX index problem");
                    }
                }
                if (prev != null) {
                    prev.blockWidth = xLeft - prevXLeft;
                    this.truncateEntry(prev, x0 + x1, labelOffset);
                    labelOffset = 0;
                }
                firstEntry = false;
                prev = entry;
                prevXLeft = xLeft;
            }
            if (last == null) continue;
            last.blockWidth = x1 + x0 - prevXLeft;
            this.truncateEntry(last, x0 + x1);
        }
        int rtPad = this.xTextOffset / 2;
        for (iBlockVar = 0; iBlockVar < this.nBlocks; ++iBlockVar) {
            j = legendAbove ? this.nBlocks - (iBlockVar + 1) : iBlockVar;
            block = this.blocks.get(j);
            if (!block.display) continue;
            firstEntry = true;
            entries = block.entries;
            n = entries.size();
            for (iBlockValue = 0; iBlockValue < n; ++iBlockValue) {
                entry = entries.get(iBlockValue);
                entry.display = true;
                double xMin = entry.x - (double)(this.xLineOffset + this.xTextOffset);
                double xMax = xMin + entry.blockWidth - (double)rtPad;
                if (xMax < x0) {
                    entry.display = false;
                    continue;
                }
                if (!this.isEntryInRange(entry)) {
                    entry.display = false;
                    continue;
                }
                x = entry.x;
                double blockWidth = entry.blockWidth;
                if (x + blockWidth <= 0.0) {
                    entry.display = false;
                    continue;
                }
                if (firstEntry) {
                    entry.blockWidth += entry.xLeft - x0;
                    entry.x = x0;
                    entry.xLeft = x0;
                }
                firstEntry = false;
                if (entry.first <= igrpUpper) continue;
                entry.display = false;
            }
        }
    }

    private void truncateEntry(BlockEntry entry, double rtmargin) {
        this.truncateEntry(entry, rtmargin, 0.0);
    }

    private void truncateEntry(BlockEntry entry, double rtmargin, double labelOffset) {
        if (this.fitType != LabelFit.TRUNCATED) {
            return;
        }
        double width = entry.blockWidth;
        double max = width - (double)(this.xTextOffset + QCMargins.getBlockRightOffset());
        if ((double)entry.labelWidth > max) {
            this.truncateString(entry, max);
        } else {
            this.truncateReset(entry);
        }
    }

    private void truncateReset(BlockEntry entry) {
        entry.truncated = false;
        entry.truncatedLabel = null;
        entry.truncatedWidth = 0;
    }

    private void truncateString(BlockEntry entry, double blockWidth) {
        this.channel.glSelect2DFont(this.textStyle.getFont());
        entry.truncated = false;
        entry.truncatedLabel = null;
        if (entry.label == null) {
            return;
        }
        if ((double)entry.labelWidth > blockWidth) {
            String string = entry.label;
            int n = string.length();
            entry.truncated = true;
            for (int i = n - 1; i > 0; --i) {
                String substring = string.substring(0, i);
                substring = substring.trim();
                i = substring.length();
                String temp = substring + "...";
                double width = this.channel.glGetTextWidth(temp);
                if (!(width <= blockWidth)) continue;
                entry.truncatedLabel = temp;
                entry.truncatedWidth = (int)width;
                break;
            }
        }
    }

    private String truncateBlockLabel(Block block, double max) {
        if (block.alternateLabel != null && (double)block.alternateWidth < max) {
            return block.alternateLabel;
        }
        this.channel.glSelect2DFont(this.labelStyle.getFont());
        String temp = null;
        String string = block.label;
        int n = string.length();
        for (int i = n - 1; i > 0; --i) {
            String substring = string.substring(0, i);
            substring = substring.trim();
            i = substring.length();
            temp = substring + "...";
            double width = this.channel.glGetTextWidth(temp);
            if (width <= max) break;
        }
        return temp;
    }

    private boolean sizeFonts() {
        Graphics2D g = (Graphics2D)StatGraph.getGraphics();
        boolean prior = this.useScaledFonts;
        this.useScaledFonts = this.fitType == LabelFit.SCALED ? this.getScaledTextFonts(g) : false;
        Font font = this.useScaledFonts ? this.scaledLabelFont : this.textStyle.getFont();
        g.setFont(font);
        boolean recompute = this.useScaledFonts != prior;
        recompute = true;
        return recompute;
    }

    private boolean getScaledTextFonts(Object p) {
        Graphics2D g = (Graphics2D)p;
        FontRenderContext frc = g.getFontRenderContext();
        int blockOffset = QCShewhart.getAdjustedBlockOffset();
        int rtPad = QCShewhart.getBlockOffset((byte)1) / 2;
        Font font = this.textStyle.getFont();
        int size = font.getSize();
        FontMetrics fmText = StatGraph.getFontMetrics((Font)this.textStyle.getFont());
        this.useScaledFonts = false;
        this.scaledLabelFont = font;
        this.scaledUniCodeFont = this.uniCodeFont;
        this.scaledQCFontSans = this.qcFontSans;
        this.scaledQCFontSerif = this.qcFontSerif;
        for (int iBlockVar = 0; iBlockVar < this.nBlocks; ++iBlockVar) {
            Block block = this.blocks.get(iBlockVar);
            Vector<BlockEntry> entries = block.entries;
            int n = entries.size();
            for (int iBlockValue = 0; iBlockValue < n; ++iBlockValue) {
                BlockEntry entry = entries.get(iBlockValue);
                double blockWidth = entry.blockWidth;
                if (blockWidth == 0.0) continue;
                blockWidth -= (double)(blockOffset + rtPad);
                if (fmText == null) {
                    entry.labelWidth = 0;
                    continue;
                }
                if (entry.labelAS != null) continue;
                if (entry.label != null) {
                    int labelWidth = fmText.stringWidth(entry.label);
                    while (size > 0 && blockWidth > 0.0 && (double)labelWidth > blockWidth) {
                        --size;
                        this.useScaledFonts = true;
                        if (this.scaledLabelFont != null) {
                            this.scaledLabelFont = this.scaledLabelFont.deriveFont((float)size);
                        }
                        if (this.scaledUniCodeFont != null) {
                            this.scaledUniCodeFont = this.scaledUniCodeFont.deriveFont((float)size);
                        }
                        if (this.scaledQCFontSans != null) {
                            this.scaledQCFontSans = this.scaledQCFontSans.deriveFont((float)size);
                        }
                        if (this.scaledQCFontSerif != null) {
                            this.scaledQCFontSerif = this.scaledQCFontSerif.deriveFont((float)size);
                        }
                        fmText = StatGraph.getFontMetrics((Font)this.scaledLabelFont);
                        labelWidth = fmText.stringWidth(entry.label);
                    }
                    entry.labelWidth = labelWidth;
                    continue;
                }
                entry.labelWidth = 0;
            }
        }
        if (size == font.getSize()) {
            this.useScaledFonts = false;
        } else {
            int FUZZ = 1;
            this.trackTextHeight = fmText.getHeight() + FUZZ;
            this.trackTextDescent = fmText.getDescent() + FUZZ;
            this.trackTextAscent = fmText.getAscent();
            this.trackLabelHeight = fmText.getHeight() + FUZZ;
            this.trackLabelDescent = fmText.getDescent() + FUZZ;
            this.trackLabelAscent = fmText.getAscent();
        }
        if (!this.useScaledFonts) {
            this.scaledLabelFont = null;
            this.scaledUniCodeFont = null;
            this.scaledQCFontSans = null;
            this.scaledQCFontSerif = null;
        }
        return this.useScaledFonts;
    }

    private void computeLegendSize() {
        int lineWidth;
        Block block;
        int iBlockVar;
        if (!this.legendOn) {
            this.legendHeight = 0;
            this.legendWidth = 0;
            return;
        }
        this.nDisplay = 0;
        for (iBlockVar = 0; iBlockVar < this.nBlocks; ++iBlockVar) {
            block = this.blocks.get(iBlockVar);
            this.nDisplay += block.display ? 1 : 0;
        }
        boolean addLineWidthToHeight = false;
        this.legendHeight = lineWidth = addLineWidthToHeight ? this.borderStyle.getWidth() : 0;
        for (iBlockVar = 0; iBlockVar < this.nBlocks; ++iBlockVar) {
            int height;
            block = this.blocks.get(iBlockVar);
            if (!block.display) continue;
            block.entryHeight = height = block.rotateEntry ? block.maxValueWidth + 2 * this.yOffset : block.maxValueHeight;
            block.totalHeight = height += 2 * this.trackTextHeightPad;
            this.legendHeight += height + lineWidth;
            if (!this.labelsOn || !block.labelDisplay) continue;
            height = block.labelHeight;
            height += 2 * this.trackLabelHeightPad;
            if (this.labelPosition != LabelPosition.ABOVE) continue;
            block.totalHeight += height + lineWidth;
            this.legendHeight += height + lineWidth;
        }
        this.legendHeight += this.getLegendOffset();
    }

    protected int getLegendOffset() {
        this.legendOffset = 0;
        if (this.nDisplay == 0) {
            return 0;
        }
        switch (this.legendPosition.ordinal()) {
            case 1: {
                if (this.labelPosition == LabelPosition.RIGHT) {
                    QCLimitsOverlay limits = this.chart.getLimitsOverlay();
                    if (limits != null && limits.isSigmaLegendOn()) {
                        int top = limits.getPreferredMarginTop();
                        top = Math.max(QCMargins.getAxisOuterY(), top);
                        this.legendOffset += top;
                        break;
                    }
                    this.legendOffset += QCMargins.getAxisOuterY();
                    break;
                }
                this.legendOffset += QCMargins.getAxisOuterY();
                break;
            }
            case 4: {
                this.legendOffset += QCMargins.getAxisOuterY();
                break;
            }
        }
        return this.legendOffset;
    }

    public void translateLegendPosition(double x, double y, double z) {
        double dy;
        this.channel.glTranslate(x, y, z);
        int just = this.getOverlayJustification();
        if (just != 1 && just != 2) {
            return;
        }
        double ymin = 0.0;
        double ymax = this.outerAxisBounds.height;
        QCBlockOverlay[] overlays = this.chart.getInnerMarginOverlays(just);
        int n = this.chart.getInnerMarginOverlaySize(just);
        int total = 0;
        int[] h = new int[2];
        for (int i = 0; i < n; ++i) {
            QCBlockOverlay o = overlays[i];
            h[i] = o.getLegendHeight();
            total += h[i];
        }
        double dx = 0.0;
        int index = this.chart.getInnerMarginOverlayIndex(just, this);
        switch (just) {
            case 1: {
                dy = index == 0 ? ymax - (double)h[0] : (index == 1 ? ymax - (double)total : ymax);
                break;
            }
            case 2: {
                dy = index == 0 ? ymin + (double)h[1] : (index == 1 ? ymin : ymin);
                break;
            }
            default: {
                dy = 0.0;
            }
        }
        this.channel.glTranslate(dx, dy, 0.0);
    }

    public void translateLegendPosition(int newest) {
        double y;
        int phaseHeight;
        double x = 0.0;
        double ymin = 0.0;
        double ymax = this.outerAxisBounds.height;
        boolean linewidth = true;
        QCBlockOverlay phase = this.chart.getBlockOverlay(BlockType.PHASE);
        QCBlockOverlay block = this.chart.getBlockOverlay(BlockType.BLOCK);
        int current = this.getOverlayJustification();
        int n = phase == null ? 0 : (phaseHeight = phase.getOverlayJustification() == current ? phase.getLegendHeight() : 0);
        int blockHeight = block == null ? 0 : (block.getOverlayJustification() == current ? block.getLegendHeight() : 0);
        int upperMarginHeight = this.innerAxisBounds.y - this.outerAxisBounds.y;
        int lowerMarginHeight = this.innerAxisBounds.y - this.outerAxisBounds.y;
        block0 : switch (this.type.ordinal()) {
            case 0: {
                switch (current) {
                    case 1: {
                        y = ymax - (double)blockHeight;
                        y -= (double)phaseHeight;
                        break block0;
                    }
                    case 2: {
                        int d = this.innerAxisBounds.y - this.outerAxisBounds.y;
                        y = ymin - (double)linewidth;
                        y -= (double)d;
                        break block0;
                    }
                }
                y = 0.0;
                break;
            }
            case 1: {
                switch (current) {
                    case 1: {
                        y = ymax - (double)phaseHeight;
                        break block0;
                    }
                    case 2: {
                        int d = this.innerAxisBounds.y - this.outerAxisBounds.y;
                        y = ymin - (double)linewidth;
                        y -= (double)blockHeight;
                        y -= (double)d;
                        break block0;
                    }
                }
                y = 0.0;
                break;
            }
            default: {
                y = 0.0;
            }
        }
        this.channel.glTranslate(x, y, 0.0);
    }

    @Override
    public boolean overrideGTLRenderingOrder(boolean highlight) {
        boolean rc = false;
        switch (this.type.ordinal()) {
            case 0: 
            case 1: 
            case 6: {
                rc = false;
                break;
            }
            default: {
                rc = highlight;
            }
        }
        return rc;
    }

    @Override
    public void draw(Graphics g) {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        Shape old = g.getClip();
        g.setClip(null);
        this.drawGLLegend(g, false);
        g.setClip(old);
    }

    public void drawGLLegend(Graphics g, boolean highlightDraw) {
        double y;
        boolean exteriorLabels;
        double x;
        BlockEntry entry;
        int iBlockValue;
        int n;
        Vector<BlockEntry> entries;
        double y2;
        double h;
        Block block;
        int j;
        int iBlockVar;
        double y0;
        LabelJustify justify = LabelJustify.LEFT;
        Rectangle clip = new Rectangle();
        if (this.nDisplay == 0 || !this.legendOn) {
            return;
        }
        boolean subpixel = this.channel.isSubpixelRendering();
        if (this.updateLayout) {
            this.computeLegendXY();
            this.applyLegendFill();
        }
        LabelPosition labelPosTemp = this.labelPosition;
        boolean legendAbove = this.legendPosition == LegendPosition.ABOVE || this.legendPosition == LegendPosition.MAX;
        boolean legendOut = this.legendPosition == LegendPosition.ABOVE || this.legendPosition == LegendPosition.BELOW;
        boolean legendBelow = this.legendPosition == LegendPosition.BELOW || this.legendPosition == LegendPosition.MIN;
        boolean labelsAbove = this.labelsOn && labelPosTemp == LabelPosition.ABOVE;
        Color labelColor = this.textStyle.getColor();
        Color headerColor = this.headerStyle.getColor();
        int lineWidth = this.borderStyle.width;
        int lineHalf = lineWidth / 2;
        int ulyAdj = 0;
        int labelOffset = QCMargins.getAxisOuterX() + (int)((double)lineWidth / 2.0);
        int xrtOffset = QCMargins.getBlockRightOffset();
        int blockOffset = QCShewhart.getAdjustedBlockOffset();
        int height = this.legendHeight - (legendOut ? this.legendOffset : 0);
        int just = this.getOverlayJustification();
        if (just == 2) {
            height += lineWidth;
            if (subpixel) {
                --height;
            }
        }
        this.only = -1;
        if (this.only != -1) {
            StatGraph.printNote((String)("height=" + height), (boolean)false);
            StatGraph.printNote((String)("lineWidth=" + lineWidth), (boolean)false);
        }
        int topOffset = lineWidth / 2;
        int bottomOffset = (lineWidth - 1) / 2;
        int leftOffset = topOffset;
        int rightOffset = bottomOffset;
        boolean lengthOffset = lineWidth > 1;
        int width = this.outerAxisBounds.width;
        double x0 = this.outerAxisBounds.x - this.innerAxisBounds.x;
        double x1 = (x0 += (double)leftOffset) + (double)width;
        x1 -= (double)(leftOffset + rightOffset);
        double y1 = y0 = (double)(height - topOffset);
        this.channel.glLineWidth((float)lineWidth);
        this.channel.lineCapStyle(0);
        this.channel.setLineJoinStyle(1);
        int igrpLower = QCShewhart.getLowerSubgrpIndex();
        int igrpUpper = QCShewhart.getUpperSubgrpIndex() + igrpLower;
        int onlyBlockVar = -1;
        int onlyBlockValue = -1;
        switch (this.only) {
            case 1: {
                onlyBlockVar = 0;
                onlyBlockValue = 999;
                break;
            }
            case 2: {
                onlyBlockVar = 0;
                onlyBlockValue = 0;
                break;
            }
            case 3: {
                onlyBlockVar = 1;
                onlyBlockValue = 999;
                break;
            }
            case 4: {
                onlyBlockVar = 1;
                onlyBlockValue = 0;
            }
        }
        this.yFuzz = subpixel && !legendOut ? 0.0 : -0.5;
        boolean addLineWidthToHeight = false;
        y1 = y0;
        this.legendFillOn = true;
        if (!this.legendFillOn) {
            this.channel.glBegin(1);
            this.channel.glLineWidth(1.0f);
            this.channel.glVertex(x0, y1, 0.0);
            this.channel.glVertex(x1, y1, 0.0);
            this.channel.glEnd();
        }
        for (iBlockVar = 0; iBlockVar < this.nBlocks; ++iBlockVar) {
            j = legendAbove ? this.nBlocks - (iBlockVar + 1) : iBlockVar;
            block = this.blocks.get(j);
            if (!block.display) continue;
            if (this.only != -1) {
                StatGraph.printNote((String)("y1=" + y1), (boolean)false);
            }
            if (labelsAbove && block.labelDisplay) {
                h = block.labelHeight;
                h += (double)(2 * this.trackLabelHeightPad);
                if (onlyBlockVar == -1 || onlyBlockVar > -1 && iBlockVar == onlyBlockVar && onlyBlockValue == 999) {
                    y2 = y1 - h;
                    if (this.legendFillOn) {
                        this.drawGLEntryFill(x0, y1, x1, y2, headerColor, false, false);
                    }
                    if (this.only != -1) {
                        StatGraph.printNote((String)("y1=" + y1), (boolean)false);
                        StatGraph.printNote((String)(" h=" + h), (boolean)false);
                    }
                }
                y1 -= h;
                y1 -= addLineWidthToHeight ? (double)lineWidth : 0.0;
            }
            h = block.entryHeight;
            h += (double)(2 * this.trackTextHeightPad);
            entries = block.entries;
            n = entries.size();
            if (this.only != -1) {
                StatGraph.printNote((String)("y1=" + y1), (boolean)false);
                StatGraph.printNote((String)(" h=" + h), (boolean)false);
            }
            if (this.legendFillOn) {
                for (iBlockValue = 0; iBlockValue < n; ++iBlockValue) {
                    entry = entries.get(iBlockValue);
                    int last = entry.last;
                    if (!entry.display) continue;
                    x = entry.xLeft;
                    x = Math.max(x, x0);
                    double blockWidth = entry.blockWidth;
                    blockWidth = Math.min(blockWidth, x1 - x);
                    if (onlyBlockValue != -1 && (onlyBlockVar <= -1 || iBlockVar != onlyBlockVar || onlyBlockValue <= -1 || iBlockValue != onlyBlockValue)) continue;
                    y2 = y1 - h;
                    ulyAdj = iBlockVar == 0 ? 0 : lineWidth;
                    Color color = entry.fill;
                    boolean lside = !(x <= x0);
                    boolean rside = false;
                    this.drawGLEntryFill(x, y1 + (double)ulyAdj, x + blockWidth, y2, color, lside, rside);
                }
            }
            y1 -= h;
            y1 -= addLineWidthToHeight ? (double)lineWidth : 0.0;
        }
        Font textFont = this.useScaledFonts ? this.scaledLabelFont : this.textStyle.getFont();
        Font labelFont = this.useScaledFonts ? this.scaledLabelFont : this.labelStyle.getFont();
        boolean bl = exteriorLabels = this.labelsOn && labelPosTemp == LabelPosition.LEFT || labelPosTemp == LabelPosition.RIGHT || labelPosTemp == LabelPosition.ROTATED;
        if (exteriorLabels) {
            int nBlockVarLabels = 0;
            int angle = 0;
            this.channel.glColor(labelColor);
            this.channel.glSelect2DFont(labelFont);
            x = 0.0;
            y1 = y0;
            switch (labelPosTemp.ordinal()) {
                case 2: {
                    x = x0 - (double)labelOffset;
                    nBlockVarLabels = this.nBlocks;
                    this.channel.glAlignment(2, 2);
                    break;
                }
                case 3: {
                    x = x1 + (double)labelOffset;
                    nBlockVarLabels = this.nBlocks;
                    this.channel.glAlignment(0, 2);
                    break;
                }
                case 4: {
                    x = x0 - (double)labelOffset;
                    x -= (double)(this.trackLabelAscent + this.trackLabelHeightPad);
                    angle = 90;
                    nBlockVarLabels = this.nBlocks;
                    this.channel.glAlignment(0, 3);
                    break;
                }
                default: {
                    nBlockVarLabels = 0;
                }
            }
            y1 -= (double)lineWidth;
            for (iBlockVar = 0; iBlockVar < nBlockVarLabels; ++iBlockVar) {
                j = this.legendPosition == LegendPosition.ABOVE ? this.nBlocks - (iBlockVar + 1) : iBlockVar;
                block = this.blocks.get(j);
                if (!block.display) continue;
                String s = block.alternateDisplay ? block.alternateLabel : block.label;
                double d = y = labelPosTemp == LabelPosition.ROTATED ? y1 - (double)block.totalHeight + (double)this.yOffset : y1 - (double)(this.trackLabelAscent + this.trackLabelHeightPad);
                if (onlyBlockVar == -1 || onlyBlockVar > -1 && iBlockVar == onlyBlockVar && onlyBlockValue == 999) {
                    this.channel.gl2DText(s, x, y += this.yFuzz, 0.0, angle);
                }
                y1 -= (double)block.entryHeight;
                y1 -= (double)(2 * this.trackLabelHeightPad);
                y1 -= (double)lineWidth;
            }
        }
        double clipULX = 0.0;
        double clipLRX = 0.0;
        double clipULY = 0.0;
        double clipLRY = 0.0;
        int rtPad = this.xTextOffset / 2;
        y1 = y0;
        for (iBlockVar = 0; iBlockVar < this.nBlocks; ++iBlockVar) {
            j = legendAbove ? this.nBlocks - (iBlockVar + 1) : iBlockVar;
            block = this.blocks.get(j);
            if (!block.display) continue;
            if (labelsAbove && block.labelDisplay) {
                this.channel.glSelect2DFont(labelFont);
                x = x0 + (double)this.xTextOffset;
                y = y1 - (double)(this.trackTextHeight + lineWidth) + (double)this.trackTextDescent;
                if (onlyBlockVar == -1 || onlyBlockVar > -1 && iBlockVar == onlyBlockVar && onlyBlockValue == 999) {
                    this.drawGLLabel(block, x, x0, x1, y0, y1);
                }
                h = block.labelHeight;
                y1 -= (h += (double)(2 * this.trackLabelHeightPad));
            }
            if (this.fitType == LabelFit.CLIPPED) {
                switch (this.legendPosition.ordinal()) {
                    case 1: {
                        clipULY = y0 - y1;
                        clipLRY = block.entryHeight + 2 * lineWidth;
                        break;
                    }
                    case 2: {
                        clipULY = y0 - y1;
                        clipLRY = block.entryHeight + 3 * lineWidth;
                        break;
                    }
                    case 3: {
                        clipULY = (double)(this.outerAxisBounds.y + this.outerAxisBounds.height - height) + (y0 - y1) - (double)lineWidth;
                        clipLRY = block.entryHeight + 2 * lineWidth;
                        break;
                    }
                    case 4: {
                        clipULY = this.outerAxisBounds.y;
                        clipLRY = block.entryHeight + 3 * lineWidth;
                        break;
                    }
                    default: {
                        clipULY = this.outerAxisBounds.y;
                        clipLRY = block.entryHeight + 3 * lineWidth;
                    }
                }
            }
            entries = block.entries;
            n = entries.size();
            boolean firstEntry = true;
            this.channel.glSelect2DFont(textFont);
            for (iBlockValue = 0; iBlockValue < n; ++iBlockValue) {
                double xrt;
                entry = entries.get(iBlockValue);
                if (!entry.display) continue;
                double xMin = entry.x - (double)(this.xLineOffset + this.xTextOffset);
                double xMax = xMin + entry.blockWidth - (double)rtPad;
                if (firstEntry) {
                    if (justify == LabelJustify.CENTER) {
                        x = entry.x + (entry.blockWidth - (double)entry.labelWidth) / 2.0;
                        xrt = x + (double)entry.labelWidth;
                    } else {
                        if (justify != LabelJustify.LEFT) continue;
                        x = x0 + (double)this.xTextOffset;
                        xrt = x + (double)entry.labelWidth;
                    }
                    if (onlyBlockValue == -1 || onlyBlockVar > -1 && iBlockVar == onlyBlockVar && onlyBlockValue > -1 && iBlockValue == onlyBlockValue) {
                        if (xrt <= xMax) {
                            this.drawGLEntryText(entry, x, x0, x1, y0, y1, block.rotateEntry);
                        } else if (this.fitType == LabelFit.TRUNCATED) {
                            this.drawGLEntryText(entry, x, x0, x1, y0, y1, false);
                        } else if (this.fitType == LabelFit.CLIPPED) {
                            clipULX = (double)this.innerAxisBounds.x + entry.x - (double)this.xTextOffset;
                            clipLRX = entry.blockWidth - (double)xrtOffset;
                            clip.setRect(clipULX, clipULY, clipLRX, clipLRY);
                            this.channel.setClip(clip);
                            this.drawGLEntryText(entry, x, x0, x1, y0, y1, false);
                            this.channel.resetClip();
                        }
                    }
                } else if (entry.x < x0 && entry.x + entry.blockWidth > x0) {
                    if (justify == LabelJustify.CENTER) {
                        x = entry.x + (entry.blockWidth - (double)entry.labelWidth) / 2.0;
                        xrt = x + (double)entry.labelWidth;
                    } else {
                        if (justify != LabelJustify.LEFT) continue;
                        x = x0;
                        xrt = x + (double)entry.labelWidth;
                    }
                    if (onlyBlockValue == -1 || onlyBlockVar > -1 && iBlockVar == onlyBlockVar && onlyBlockValue > -1 && iBlockValue == onlyBlockValue) {
                        if (xrt <= xMax) {
                            this.drawGLEntryText(entry, x, x0, x1, y0, y1, block.rotateEntry);
                        } else if (this.fitType == LabelFit.TRUNCATED) {
                            this.drawGLEntryText(entry, x, x0, x1, y0, y1, false);
                        } else if (this.fitType == LabelFit.CLIPPED) {
                            clipULX = (double)this.innerAxisBounds.x + entry.x - (double)this.xTextOffset;
                            clipLRX = entry.blockWidth - (double)xrtOffset;
                            clip.setRect(clipULX, clipULY, clipLRX, clipLRY);
                            this.channel.setClip(clip);
                            this.drawGLEntryText(entry, x, x0, x1, y0, y1, false);
                            this.channel.resetClip();
                        }
                        x = entry.xLeft;
                        y = y1 - (double)(block.entryHeight + lineWidth);
                    }
                } else if (entry.x >= x0 && entry.x <= x1) {
                    xMax = Math.min(xMax, x1);
                    if (justify == LabelJustify.CENTER) {
                        x = entry.x + (entry.blockWidth - (double)entry.labelWidth) / 2.0;
                        x = (xMin + xMax - (double)entry.labelWidth) / 2.0;
                        xrt = x + (double)entry.labelWidth;
                    } else {
                        if (justify != LabelJustify.LEFT) continue;
                        x = entry.x;
                        xrt = x + (double)entry.labelWidth;
                    }
                    if (onlyBlockValue == -1 || onlyBlockVar > -1 && iBlockVar == onlyBlockVar && onlyBlockValue > -1 && iBlockValue == onlyBlockValue) {
                        if (xrt <= xMax) {
                            this.drawGLEntryText(entry, x, x0, x1, y0, y1, block.rotateEntry);
                        } else if (this.fitType == LabelFit.TRUNCATED) {
                            this.drawGLEntryText(entry, x, x0, x1, y0, y1, false);
                        } else if (this.fitType == LabelFit.CLIPPED) {
                            clipULX = (double)this.innerAxisBounds.x + entry.x - (double)this.xTextOffset;
                            clipLRX = entry.blockWidth - (double)xrtOffset;
                            clip.setRect(clipULX, clipULY, clipLRX, clipLRY);
                            this.channel.setClip(clip);
                            this.channel.glColor(Color.RED);
                            this.channel.glRect(0.0, 150.0, 550.0, -500.0);
                            this.drawGLEntryText(entry, x, x0, x1, y0, y1, false);
                            this.channel.resetClip();
                        }
                        x = entry.xLeft;
                        y = y1 - (double)(block.entryHeight + lineWidth);
                        y -= (double)this.trackTextHeightPad;
                    }
                }
                firstEntry = false;
            }
            h = block.entryHeight;
            y1 -= (h += (double)(2 * this.trackLabelHeightPad));
            if (iBlockVar >= this.nBlocks - 1) continue;
            y2 = y1 - (double)lineHalf;
            y2 += this.yFuzz;
        }
        boolean frameOutline = this.regionOutlines;
        if (frameOutline) {
            switch (this.getOverlayJustification()) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    Color outlineColor;
                    Color backgroundColor = this.backgroundStyle.getColor();
                    Color borderColor = this.borderStyle.getColor();
                    switch (this.type.ordinal()) {
                        case 0: 
                        case 1: {
                            outlineColor = this.legendOutlineOn ? borderColor : backgroundColor;
                            break;
                        }
                        default: {
                            outlineColor = backgroundColor;
                        }
                    }
                    y0 = height;
                    y1 = 0.0;
                    if (!StatGraph.VGF) {
                        this.channel.setSubpixelRendering(false);
                    }
                    this.channel.glBegin(2);
                    this.channel.glPolygonMode(2);
                    this.channel.glColor(outlineColor);
                    this.channel.glLineWidth((float)lineWidth);
                    this.channel.lineCapStyle(2);
                    this.channel.setLineJoinStyle(1);
                    double xc = (x0 + x1) / 2.0;
                    this.channel.glVertex(xc, y1, 0.0);
                    this.channel.glVertex(x1, y1, 0.0);
                    this.channel.glVertex(x1, y0, 0.0);
                    this.channel.glVertex(x0, y0, 0.0);
                    this.channel.glVertex(x0, y1, 0.0);
                    this.channel.glVertex(xc, y1, 0.0);
                    this.channel.glEnd();
                }
            }
        }
        this.updateGraph = false;
        if (this.only != -1) {
            StatGraph.printNote((String)"=========================================================", (boolean)false);
        }
        this.channel.setSubpixelRendering(subpixel);
    }

    private void drawGLEntryBounds(BlockEntry entry, double y, double height, Color color) {
        double x;
        int lineWidth = 11;
        int dx = (int)((double)lineWidth / 2.0 + 0.5);
        int dy = (int)((double)lineWidth / 2.0 + 0.5);
        this.channel.glColor(color);
        double x0 = x = entry.x;
        double x1 = x + entry.blockWidth - (double)(this.xLineOffset + this.xTextOffset);
        double y0 = y;
        double y1 = y - height;
        this.channel.glRect(x0, y0 += this.yFuzz, x1, y1 += this.yFuzz);
    }

    private void drawGLEntryFrame(double ulx, double uly, double lrx, double lry, int vLine, int hLine) {
        Color outlineColor;
        Color backgroundColor = this.backgroundStyle.getColor();
        Color borderColor = this.borderStyle.getColor();
        switch (this.type.ordinal()) {
            case 0: 
            case 1: {
                outlineColor = this.legendOutlineOn ? borderColor : backgroundColor;
                break;
            }
            default: {
                outlineColor = backgroundColor;
            }
        }
        int lineWidth = this.borderStyle.width;
        this.channel.glColor(outlineColor);
        this.channel.glLineWidth((float)lineWidth);
        this.channel.lineCapStyle(2);
        this.channel.setLineJoinStyle(1);
        block3 : switch (hLine) {
            case 3: {
                switch (vLine) {
                    case 1: {
                        this.channel.glBegin(1);
                        this.channel.glVertex(lrx, uly);
                        this.channel.glVertex(ulx, uly);
                        this.channel.glVertex(ulx, lry);
                        this.channel.glEnd();
                        break block3;
                    }
                    case 0: {
                        this.channel.glBegin(1);
                        this.channel.glVertex(ulx, uly);
                        this.channel.glVertex(lrx, uly);
                        this.channel.glEnd();
                        break block3;
                    }
                }
                break;
            }
            case 2: {
                switch (vLine) {
                    case 1: {
                        this.channel.glBegin(1);
                        this.channel.glVertex(lrx, uly);
                        this.channel.glVertex(ulx, uly);
                        this.channel.glVertex(ulx, lry);
                        this.channel.glVertex(lrx, lry);
                        this.channel.glEnd();
                        break block3;
                    }
                    case 0: {
                        this.channel.glBegin(1);
                        this.channel.glVertex(ulx, uly);
                        this.channel.glVertex(lrx, uly);
                        this.channel.glEnd();
                        this.channel.glBegin(1);
                        this.channel.glVertex(ulx, lry);
                        this.channel.glVertex(lrx, lry);
                        this.channel.glEnd();
                        break block3;
                    }
                }
                break;
            }
            case 1: {
                switch (vLine) {
                    case 1: {
                        this.channel.glBegin(1);
                        this.channel.glVertex(ulx, uly);
                        this.channel.glVertex(ulx, lry);
                        this.channel.glVertex(lrx, lry);
                        this.channel.glEnd();
                        break block3;
                    }
                    case 0: {
                        this.channel.glBegin(1);
                        this.channel.glVertex(ulx, lry);
                        this.channel.glVertex(lrx, lry);
                        this.channel.glEnd();
                        break block3;
                    }
                }
                break;
            }
            case 0: {
                switch (vLine) {
                    case 1: {
                        this.channel.glBegin(1);
                        this.channel.glVertex(ulx, uly);
                        this.channel.glVertex(ulx, lry);
                        this.channel.glEnd();
                        break block3;
                    }
                }
            }
        }
    }

    private void drawGLEntryFill(double ulx, double uly, double lrx, double lry, Color fillColor, boolean left, boolean right) {
        Color outlineColor;
        boolean subpixel = this.channel.isSubpixelRendering();
        this.channel.setSubpixelRendering(false);
        uly += this.yFuzz;
        lry += this.yFuzz;
        uly = Math.max(uly, 0.0);
        lry = Math.max(lry, 0.0);
        Color backgroundColor = this.backgroundStyle.getColor();
        this.channel.glBegin(2);
        this.channel.glPolygonMode(3);
        this.channel.glColor(backgroundColor);
        this.channel.glVertex(ulx, uly);
        this.channel.glVertex(ulx, lry);
        this.channel.glVertex(lrx, lry);
        this.channel.glVertex(lrx, uly);
        this.channel.glEnd();
        this.channel.glBegin(2);
        this.channel.glPolygonMode(3);
        this.channel.glColor(fillColor);
        this.channel.glVertex(ulx, uly);
        this.channel.glVertex(ulx, lry);
        this.channel.glVertex(lrx, lry);
        this.channel.glVertex(lrx, uly);
        this.channel.glEnd();
        int lineWidth = this.borderStyle.width;
        if (this.legendOutlineOn) {
            Color borderColor = this.borderStyle.getColor();
            switch (this.type.ordinal()) {
                case 0: 
                case 1: {
                    outlineColor = this.legendOutlineOn ? borderColor : backgroundColor;
                    break;
                }
                default: {
                    outlineColor = backgroundColor;
                    break;
                }
            }
        } else {
            outlineColor = fillColor;
        }
        boolean outline = true;
        boolean top = true;
        boolean bottom = true;
        if (outline) {
            if (subpixel) {
                if (top) {
                    this.channel.glBegin(1);
                    this.channel.glColor(outlineColor);
                    this.channel.glLineWidth((float)lineWidth);
                    this.channel.glVertex(ulx, uly);
                    this.channel.glVertex(lrx, uly);
                    this.channel.glEnd();
                }
                if (bottom) {
                    this.channel.glBegin(1);
                    this.channel.glColor(outlineColor);
                    this.channel.glLineWidth((float)lineWidth);
                    this.channel.glVertex(ulx, lry);
                    this.channel.glVertex(lrx, lry);
                    this.channel.glEnd();
                }
                this.channel.setSubpixelRendering(subpixel);
                if (left) {
                    this.channel.glBegin(1);
                    this.channel.glColor(outlineColor);
                    this.channel.glLineWidth((float)lineWidth);
                    this.channel.glVertex(ulx, uly);
                    this.channel.glVertex(ulx, lry);
                    this.channel.glEnd();
                }
                if (right) {
                    this.channel.glBegin(1);
                    this.channel.glColor(outlineColor);
                    this.channel.glLineWidth((float)lineWidth);
                    this.channel.glVertex(lrx, uly);
                    this.channel.glVertex(lrx, lry);
                    this.channel.glEnd();
                }
                this.channel.setSubpixelRendering(false);
            } else {
                this.channel.glBegin(2);
                this.channel.glPolygonMode(2);
                this.channel.glColor(outlineColor);
                this.channel.glLineWidth((float)lineWidth);
                this.channel.glVertex(ulx, uly);
                this.channel.glVertex(ulx, lry);
                this.channel.glVertex(lrx, lry);
                this.channel.glVertex(lrx, uly);
                this.channel.glEnd();
            }
        }
        this.channel.setSubpixelRendering(subpixel);
    }

    private void drawGLEntryText(BlockEntry entry, double x, double x0, double x1, double y0, double y1, boolean rotated) {
        double y;
        if (entry.label == null) {
            return;
        }
        if (!entry.displayLabel) {
            return;
        }
        Color borderColor = this.borderStyle.getColor();
        Color labelColor = this.textStyle.getColor();
        BasicStroke borderStroke = new BasicStroke();
        int lineWidth = (int)borderStroke.getLineWidth();
        int lineHalf = lineWidth / 2;
        this.channel.glColor(labelColor);
        this.channel.glAlignment(0, 2);
        String label = entry.label;
        if (entry.labelAS != null) {
            y = 0.0;
            y -= (double)this.trackTextHeightPad;
            this.channel.gl2DText(label, x, y += this.yFuzz, 0.0);
        } else if (rotated) {
            y = y1 + (double)this.yOffset;
            this.channel.gl2DText(label, x, y += this.yFuzz, 0.0, 90);
            x += (double)this.trackTextHeight;
        } else {
            label = entry.truncated ? entry.truncatedLabel : entry.label;
            y = y1 - (double)(this.trackTextAscent + this.trackTextHeightPad);
            y += this.yFuzz;
            if (label != null) {
                Font textFont;
                Font labelFont = this.labelStyle.getFont();
                Font font = textFont = this.useScaledFonts ? this.scaledLabelFont : this.textStyle.getFont();
                if (this.labelStyle.getFont().isBold()) {
                    int i = label.indexOf(10);
                    if (i <= 0) {
                        if (this.type == BlockType.PHASE) {
                            this.channel.glSelect2DFont(labelFont);
                        } else {
                            this.channel.glSelect2DFont(textFont);
                        }
                        this.channel.gl2DText(label, x, y, 0.0);
                    } else {
                        String s1 = label.substring(0, i);
                        String s2 = label.substring(i + 1);
                        y = y1 - (double)(this.trackLabelAscent + this.trackLabelHeightPad);
                        this.channel.glSelect2DFont(labelFont);
                        this.channel.gl2DText(s1, x, y += this.yFuzz, 0.0);
                        y -= (double)(this.trackTextAscent + this.trackTextHeightPad);
                        this.channel.glSelect2DFont(textFont);
                        this.channel.gl2DText(s2, x, y += this.yFuzz, 0.0);
                    }
                } else {
                    this.channel.gl2DText(label, x, y, 0.0);
                }
            }
        }
        if (this.only != -1) {
            StatGraph.printNote((String)(label + ".y=" + y), (boolean)false);
        }
        if (this.debug) {
            this.channel.glColor(borderColor);
            this.channel.glBegin(1);
            this.channel.glVertex(x0, y -= (double)(this.trackTextDescent + lineHalf), 0.0);
            this.channel.glVertex(x1, y, 0.0);
            this.channel.glEnd();
        }
    }

    private void drawGLLabel(Block block, double x, double x0, double x1, double y0, double y1) {
        String label;
        String string = label = block.alternateDisplay ? block.alternateLabel : block.label;
        if (label == null) {
            return;
        }
        Color borderColor = this.borderStyle.getColor();
        Color labelColor = this.textStyle.getColor();
        BasicStroke borderStroke = new BasicStroke();
        int lineWidth = (int)borderStroke.getLineWidth();
        int lineHalf = lineWidth / 2;
        this.channel.glColor(labelColor);
        this.channel.glAlignment(0, 2);
        double y = y1 - (double)(this.trackLabelAscent + this.trackLabelHeightPad);
        y += this.yFuzz;
        double width = block.labelWidth;
        double max = x1 - x0;
        max -= (double)(this.xTextOffset + QCMargins.getBlockRightOffset());
        if (width > max) {
            label = this.truncateBlockLabel(block, max);
        }
        if (label != null) {
            this.channel.gl2DText(label, x, y, 0.0);
        }
        if (this.only != -1) {
            StatGraph.printNote((String)(label + ".y=" + y), (boolean)false);
        }
        if (this.debug) {
            this.channel.glColor(borderColor);
            this.channel.glBegin(1);
            this.channel.glVertex(x0, y -= (double)(this.trackLabelDescent + lineHalf), 0.0);
            this.channel.glVertex(x1, y, 0.0);
            this.channel.glEnd();
        }
    }

    public BBox[] getRefFillFrames(BBox axes) {
        if (this.needConnect && !this.connectNetwork()) {
            return null;
        }
        if (this.refList == null) {
            return null;
        }
        int n = this.refList.length;
        double uly = axes.getULY();
        double lry = axes.getLRY();
        BBox[] frames = new BBox[n];
        double[] temp = new double[3];
        int blockOffset = QCShewhart.getAdjustedBlockOffset();
        double x0 = -(this.innerAxisBounds.x - this.outerAxisBounds.x);
        int igrpLower = QCShewhart.getLowerSubgrpIndex();
        int igrpUpper = QCShewhart.getUpperSubgrpIndex() + igrpLower;
        double xMin = this.numericX ? ((ContinuousRangeToNumericMap)this.xEncoder.getValueMap()).getInputMin() : 0.0;
        double xMax = this.numericX ? ((ContinuousRangeToNumericMap)this.xEncoder.getValueMap()).getInputMax() : 1.0;
        for (int i = 0; i < n - 1; ++i) {
            int igrp = this.refList[i + 1];
            if (igrp < igrpLower) continue;
            if (igrp > igrpUpper) break;
            double x = this.getSubgrp(igrp);
            try {
                double xc = this.pointX.getValue(igrp);
                if (xc == 0.0) continue;
                frames[i] = new BBox(x0, uly, xc -= (double)blockOffset, lry);
                x0 = xc;
                continue;
            }
            catch (MissingValueException mve) {
                StatGraph.printDebug((String)"pointX index problem");
            }
        }
        int lInner = this.innerAxisBounds.x - this.outerAxisBounds.x;
        double xl = this.outerAxisBounds.width - lInner;
        frames[i] = new BBox(x0, uly, xl, lry);
        return frames;
    }

    private int getValueIndex(double value) {
        NumericPipe np = ((NumericVariable)this.xvalueVar).uniqueValue;
        int num = this.xvalueVar.getUniqueValueCount();
        int index = -1;
        try {
            for (int i = 0; i < num; ++i) {
                double test = np.getValue(i);
                if (value != test) continue;
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return index;
    }

    public void drawRefLines(Object p, boolean highlightDraw) {
        Graphics2D g = (Graphics2D)p;
        if (!this.phaseRefLine) {
            return;
        }
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        int[] refList = this.getRefList();
        if (refList == null || refList.length <= 1) {
            return;
        }
        boolean subpixel = this.channel.isSubpixelRendering();
        Composite old = g.getComposite();
        if (highlightDraw) {
            AlphaComposite ac = AlphaComposite.getInstance(3, this.phaseRefFillOpacity);
            g.setComposite(ac);
        }
        Color color = this.refLineStyle.getColor();
        double thickness = this.refLineStyle.getWidth();
        int factor = this.refLineStyle.getStippleFactor();
        int pattern = this.refLineStyle.getStipplePattern();
        int topOffset = (int)thickness / 2;
        int bottomOffset = (int)(thickness - 1.0) / 2;
        boolean lengthOffset = thickness > 1.0;
        lengthOffset = false;
        int blockOffset = QCShewhart.getAdjustedBlockOffset();
        double height = this.outerAxisBounds.height;
        int igrpLower = QCShewhart.getLowerSubgrpIndex();
        int igrpUpper = QCShewhart.getUpperSubgrpIndex() + igrpLower;
        double xMin = this.numericX ? ((ContinuousRangeToNumericMap)this.xEncoder.getValueMap()).getInputMin() : 0.0;
        double xMax = this.numericX ? ((ContinuousRangeToNumericMap)this.xEncoder.getValueMap()).getInputMax() : 1.0;
        for (int i = 0; i < refList.length; ++i) {
            int igrp = refList[i];
            if (igrp < igrpLower) continue;
            if (igrp > igrpUpper) break;
            double x = this.getSubgrp(igrp);
            if (i == 0 && igrp == igrpLower) continue;
            double subgrp = this.model.isAvailable(10) ? (this.numericX ? this.model.getDoubleColumn(10)[igrp] : (double)igrp) : (double)igrp;
            try {
                x = this.pointX.getValue(igrp);
                if (x == 0.0) continue;
                this.channel.glBegin(1);
                this.channel.glColor(color);
                this.channel.glLineWidth((float)((int)thickness));
                this.channel.lineCapStyle(0);
                this.channel.glVertex(x -= (double)blockOffset, (double)bottomOffset, 0.0);
                this.channel.glVertex(x, height + (double)lengthOffset, 0.0);
                this.channel.glEnd();
                continue;
            }
            catch (MissingValueException mve) {
                StatGraph.printDebug((String)("igrp=" + igrp + " x=."));
            }
        }
        if (highlightDraw) {
            g.setComposite(old);
        }
        this.channel.setSubpixelRendering(subpixel);
    }

    public void drawRefFills(Object p, boolean highlightDraw) {
        Graphics2D g = (Graphics2D)p;
        if (!this.phaseRefFill) {
            return;
        }
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        int[] refList = this.getRefList();
        if (refList == null) {
            return;
        }
        boolean subpixel = this.channel.isSubpixelRendering();
        this.channel.setSubpixelRendering(false);
        Composite old = g.getComposite();
        float op = highlightDraw ? this.phaseRefFillOpacity : 1.0f;
        AlphaComposite ac = AlphaComposite.getInstance(3, op);
        g.setComposite(ac);
        Color[] blockFillColor = new Color[]{this.refFillStyle.getColor(), this.altRefFillStyle.getColor()};
        int lInner = this.innerAxisBounds.x - this.outerAxisBounds.x;
        int rInner = this.outerAxisBounds.width - lInner;
        boolean x = false;
        boolean y = false;
        int width = this.innerAxisBounds.width;
        int height = this.outerAxisBounds.height;
        BBox frame = new BBox((double)x, (double)y, width, height);
        BBox[] phaseFrames = this.getRefFillFrames(frame);
        int n = phaseFrames.length;
        for (int i = 0; i < n; ++i) {
            int k;
            int j;
            if (phaseFrames[i] == null || (j = (k = this.refListLevels == null ? i : this.refListLevels[i] + 1) - k / 2 * 2) != 1) continue;
            double ulx = phaseFrames[i].getULX();
            double uly = phaseFrames[i].getULY();
            double lrx = phaseFrames[i].getLRX();
            double lry = phaseFrames[i].getLRY();
            this.channel.glColor(blockFillColor[1]);
            this.channel.glRect(ulx, uly, lrx, lry);
        }
        g.setComposite(old);
        this.channel.setSubpixelRendering(subpixel);
    }

    public int getPhaseEntryLevel(int i) {
        if (!this.isPhaseOverlay()) {
            return -1;
        }
        Block phase = this.blocks.get(0);
        BlockEntry entry = phase.entries.get(i);
        return entry.level;
    }

    public int[] getPhaseIndexArray() {
        double[] d = this.model.getDoubleColumn(757);
        int n = d.length;
        int[] index = new int[n];
        for (int i = 0; i < n; ++i) {
            index[i] = (int)d[i];
        }
        return index;
    }

    public Vector<BlockEntry> getPhaseIndices() {
        if (!this.isPhaseOverlay()) {
            return null;
        }
        int iPhase = 0;
        Block phase = this.blocks.get(iPhase);
        return phase.entries;
    }

    public int getPhaseIndicesN() {
        if (!this.isPhaseOverlay()) {
            return 0;
        }
        int iPhase = 0;
        Block phase = this.blocks.get(iPhase);
        return phase.nEntries;
    }

    public boolean isPhaseOverlay() {
        return this.type == BlockType.PHASE || this.type == BlockType.PHASEREF;
    }

    public int[] getPhaseBoundaries() {
        if (!this.isPhaseOverlay()) {
            return null;
        }
        int iPhase = 0;
        Block phase = this.blocks.get(iPhase);
        Vector<BlockEntry> entries = phase.entries;
        int nEntries = phase.nEntries;
        int[] list = null;
        if (this.refList != null) {
            list = this.refList;
        } else if (nEntries == 0) {
            list = null;
        } else {
            list = new int[nEntries];
            for (int i = 0; i < nEntries; ++i) {
                BlockEntry entry = entries.get(i);
                list[i] = entry.first;
            }
        }
        return list;
    }

    public boolean usePhaseLimits() {
        if (this.blocks == null) {
            return false;
        }
        if (this.type == BlockType.PHASE || this.type == BlockType.PHASEREF) {
            if (this.blocks.isEmpty()) {
                return false;
            }
            int iPhase = 0;
            Block phase = this.blocks.get(iPhase);
            if (phase == null) {
                return false;
            }
            Vector<BlockEntry> entries = phase.entries;
            return entries != null && this.refList != null;
        }
        return false;
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                return null;
            }
            case 4: {
                return null;
            }
            case 17: {
                return null;
            }
            case 15: {
                return null;
            }
        }
        return null;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension != 2) {
            if (dimension == 4) {
                this.colorEncoder = (ColorEncoder)encoder;
            } else if (dimension == 17 || dimension == 15) {
                // empty if block
            }
        }
        this.needConnect = true;
    }

    public void setLegend(boolean on) {
        this.legendOn = on;
    }

    public boolean getLegend() {
        return this.legendOn;
    }

    public void setLabels(boolean on) {
        this.labelsOn = on;
    }

    public boolean getLabels() {
        return this.labelsOn;
    }

    public void setFrame(boolean on) {
        this.regionOutlines = on;
    }

    public boolean getFrame() {
        return this.regionOutlines;
    }

    public void setLegendFill(boolean on) {
        this.legendFillOn = on;
    }

    public boolean getLegendFill() {
        return this.legendFillOn;
    }

    public void setVFrame(boolean on) {
        this.vFrame = on;
    }

    public boolean getVFrame() {
        return this.vFrame;
    }

    public void setHFrame(boolean on) {
        this.hFrame = on;
    }

    public boolean getHFrame() {
        return this.hFrame;
    }

    public void setLabelPosition(LabelPosition pos) {
        this.labelPosition = pos;
    }

    public LabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public void setFitType(LabelFit type) {
        this.fitType = type;
    }

    public LabelFit getFitType() {
        return this.fitType;
    }

    public void setBlockFillType(String type) {
        this.fillType = type;
    }

    public String getBlockFillType() {
        return this.fillType;
    }

    public void setLegendPosition(LegendPosition pos) {
        this.legendPosition = pos;
    }

    public LegendPosition getLegendPosition() {
        return this.legendPosition;
    }

    public void setRepeat(boolean on) {
        this.repeatValues = on;
    }

    public boolean getRepeat() {
        return this.repeatValues;
    }

    public void setRefLine(boolean on) {
        this.phaseRefLine = on;
    }

    public boolean getRefLines() {
        return this.phaseRefLine;
    }

    public void setRefLineType(int type) {
        this.phaseRefLineType = type;
    }

    public int getRefLineType() {
        return this.phaseRefLineType;
    }

    public void setRefFill(boolean fill) {
        this.phaseRefFill = fill;
    }

    public boolean getRefFill() {
        return this.phaseRefFill;
    }

    public void setRefFillOpacity(double opacity) {
        this.phaseRefFillOpacity = (float)opacity;
    }

    public double getRefFillOpacity() {
        return this.phaseRefFillOpacity;
    }

    public void setPhaseLimits(boolean b) {
        this.phaseLimits = b;
    }

    public void setHeightPadding(int pad) {
        this.trackTextHeightPad = pad;
        this.trackLabelHeightPad = pad;
    }

    public void addBlock(Block block) {
        if (this.blocks == null) {
            this.blocks = new Vector();
        }
        this.blocks.addElement(block);
    }

    public Vector<Block> getBlocks() {
        return this.blocks;
    }

    public int getNBlocks() {
        return this.nBlocks;
    }

    public FillAttrs getBlockAttrs() {
        return this.blockStyle;
    }

    public void setBlockAttrs(FillAttrs style) {
        this.blockStyle = style;
    }

    public FillAttrs getAltBlockAttrs() {
        return this.altBlockStyle;
    }

    public void setAltBlockAttrs(FillAttrs style) {
        this.altBlockStyle = style;
    }

    public LineAttrs getRefLineAttrs() {
        return this.refLineStyle;
    }

    public void setRefLineAttrs(LineAttrs style) {
        this.refLineStyle = style;
    }

    public FillAttrs getRefFillAttrs() {
        return this.refFillStyle;
    }

    public void setRefFillAttrs(FillAttrs style) {
        this.refFillStyle = style;
    }

    public FillAttrs getAltRefFillAttrs() {
        return this.altRefFillStyle;
    }

    public void setAltRefFillAttrs(FillAttrs style) {
        this.altRefFillStyle = style;
    }

    public LineAttrs getBorderAttrs() {
        return this.borderStyle;
    }

    public void setBorderAttrs(LineAttrs style) {
        this.borderStyle = style;
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(TextStyle style) {
        this.textStyle = style;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextStyle style) {
        this.labelStyle = style;
    }

    public TextStyle getUnicodeLabelStyle() {
        return this.unicodeStyle;
    }

    public void setUnicodeLabelStyle(TextStyle style) {
        this.unicodeStyle = style;
    }

    public FillAttrs getWallAttrs() {
        return this.wallStyle;
    }

    public void setWallAttrs(FillAttrs style) {
        this.wallStyle = style;
    }

    public FillAttrs getHeaderAttrs() {
        return this.headerStyle;
    }

    public void setHeaderAttrs(FillAttrs style) {
        this.headerStyle = style;
    }

    private double getSubgrp(double igrp) {
        return this.getSubgrp((int)igrp);
    }

    private double getSubgrp(long igrp) {
        return this.getSubgrp((int)igrp);
    }

    private double getSubgrp(int igrp) {
        int n = this.model.getRowCount();
        if (igrp < 0 || igrp >= n) {
            return Double.NaN;
        }
        double subgrp = this.model.isAvailable(10) ? (this.numericX ? this.model.getDoubleColumn(10)[igrp] : (double)igrp) : (double)igrp;
        return subgrp;
    }

    public void setOrigin(int ulx, int uly) {
        this.origin.setLocation(ulx, uly);
        this.updateLayout = true;
    }

    public void applyLegendFill() {
        Object subset = null;
        boolean igrpLower = subset != null ? subset[0] : false;
        Color wallColor = this.wallStyle.getColor();
        Color backgroundColor = this.backgroundStyle.getColor();
        Color blockHeaderColor = this.headerStyle.getColor();
        Color[] blockFillColor = new Color[]{this.blockStyle.getColor(), this.altBlockStyle.getColor()};
        Color[] cl = this.colorEncoder == null ? null : this.colorEncoder.colorArray;
        for (int iBlockVar = 0; iBlockVar < this.nBlocks; ++iBlockVar) {
            BlockEntry entry;
            int iBlockValue;
            Block block = this.blocks.get(iBlockVar);
            Vector<BlockEntry> entries = block.entries;
            String type = block.fillType;
            int n = entries.size();
            if (type == null || type.equalsIgnoreCase("None") || type.equalsIgnoreCase("Empty")) {
                for (iBlockValue = 0; iBlockValue < n; ++iBlockValue) {
                    entry = entries.get(iBlockValue);
                    entry.fill = blockFillColor[1];
                }
                continue;
            }
            if (type.equalsIgnoreCase("Alternate")) {
                for (iBlockValue = 0; iBlockValue < n; ++iBlockValue) {
                    entry = entries.get(iBlockValue);
                    entry.fill = blockFillColor[entry.alternate];
                }
                continue;
            }
            if (type.equalsIgnoreCase("Variable")) {
                if (cl == null) {
                    for (iBlockValue = 0; iBlockValue < n; ++iBlockValue) {
                        entry = entries.get(iBlockValue);
                        entry.fill = blockFillColor[entry.alternate];
                    }
                    continue;
                }
                for (iBlockValue = 0; iBlockValue < n; ++iBlockValue) {
                    Color color;
                    entry = entries.get(iBlockValue);
                    int index = entry.fillIndex;
                    switch (index) {
                        case -99: {
                            color = blockFillColor[entry.alternate];
                            break;
                        }
                        case -98: {
                            color = backgroundColor;
                            break;
                        }
                        default: {
                            color = index < 0 || index > cl.length - 1 ? blockFillColor[entry.alternate] : QCBlockOverlay.applyTransparency((Color)cl[index], (double)this.blockFillTransparency);
                        }
                    }
                    if (index == -1) {
                        // empty if block
                    }
                    entry.fill = color;
                }
                continue;
            }
            for (iBlockValue = 0; iBlockValue < n; ++iBlockValue) {
                entry = entries.get(iBlockValue);
                entry.fill = blockFillColor[entry.alternate];
            }
        }
    }

    public int computeStartingColor(Object var, int i) {
        int level = 0;
        if (this.model.isAvailable(757 + i)) {
            int igrpLower = QCShewhart.getLowerSubgrpIndex();
            int index = (int)this.model.getDoubleColumn(757 + i)[igrpLower];
            level = index - 2 * (index / 2);
        }
        return level;
    }

    protected void updateXRange() {
        Object newRange = null;
        DataRange oldRange = this.xRange;
        if (this.xvalueVar != null) {
            int num;
            int n = num = this.numericX ? this.xvalueVar.getValueCount() : this.xvalueVar.getUniqueValueCount();
            if (num > 0) {
                newRange = this.numericX ? this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, !this.xUnionAllPages) : (this.numericDiscreteX ? this.makeOrdinalRange((StringVariable)this.xvalueVar, num, (NumericVariable)this.numericXVar, (short)10, !this.xUnionAllPages) : this.makeDiscreteRange((StringVariable)this.xvalueVar, num, (short)10, !this.xUnionAllPages));
                if (newRange != null) {
                    newRange.setLabel(this.xvalueVar.getLabel());
                }
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 10);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateXRange(CRD model2) {
        Object newRange = null;
        DataRange oldRange = this.xRange;
        CRD save = this.model;
        this.model = model2;
        if (this.xvalueVar != null) {
            int num;
            int n = num = this.numericX ? this.xvalueVar.getValueCount() : this.xvalueVar.getUniqueValueCount();
            if (num > 0) {
                newRange = this.numericX ? this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, !this.xUnionAllPages) : (this.numericDiscreteX ? this.makeOrdinalRange((StringVariable)this.xvalueVar, num, (NumericVariable)this.numericXVar, (short)10, !this.xUnionAllPages) : this.makeDiscreteRange((StringVariable)this.xvalueVar, num, (short)10, !this.xUnionAllPages));
                if (newRange != null) {
                    newRange.setLabel(this.xvalueVar.getLabel());
                }
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 10);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
        this.model = save;
    }

    public boolean connectNetwork() {
        if (this.needSubgrpConnect) {
            this.connectSubgrpVar(true);
            this.updateXRange();
        }
        if (this.xRange == null) {
            return false;
        }
        if (this.xEncoder == null) {
            return false;
        }
        ValueMap xMap = this.xEncoder.getValueMap();
        if (this.numericX) {
            if (!(xMap instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            if (!(this.xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                this.xvalueMapper = new ContinuousRangeToNumericMapper();
            }
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)xMap);
        } else {
            if (!(xMap instanceof StringToNumericMap)) {
                return false;
            }
            if (!(this.xvalueMapper instanceof StringToNumericMapper)) {
                this.xvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)xMap);
        }
        if (this.numericX) {
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).input.connectFrom(((NumericVariable)this.xvalueVar).value);
        } else {
            ((StringToNumericMapper)this.xvalueMapper).input.connectFrom(((StringVariable)this.xvalueVar).value);
        }
        this.pointX.connectFrom((NumericPipe)this.xvalueMapper);
        ColorVector colorPipe = null;
        if (this.colorEncoder != null) {
            Object c = null;
            StringToColorMap cmap = (StringToColorMap)this.colorEncoder.getValueMap();
            cmap.init(new AInitAction());
            colorPipe = new ColorVector();
            if (this.blockFillIndexVar != null) {
                for (int i = 0; i < this.nObs; ++i) {
                    Object value = Variable.getValue((Variable)this.blockFillIndexVar, (int)i, (boolean)true);
                }
            }
        }
        this.needConnect = false;
        return true;
    }

    private Color getIndexColor(ColorEncoder encoder, String groupValue, ColorAttr defaultAttr) {
        Color[] cl = encoder.colorArray;
        Integer gCat = (Integer)this.groupValue2Category.get(groupValue);
        Color c = null;
        return c;
    }

    private boolean isSplitValue() {
        return true;
    }

    private String getSplitValue(String value, FontMetrics fmLabel, FontMetrics fmText, double splitWidth) {
        boolean splitAlways;
        int valueFitStrategy = 3;
        boolean valueSplitCharDrop = true;
        char[] valueSplitChar = new String("/").toCharArray();
        String str = value;
        boolean bl = splitAlways = valueFitStrategy == 3;
        if (splitAlways || (double)fmText.stringWidth(value.trim()) > splitWidth) {
            str = QCBlockOverlay.makeMultiLineLabel((String[])QCBlockOverlay.splitLabel((String)value.trim(), (boolean)splitAlways, (double)splitWidth, (boolean)valueSplitCharDrop, (char[])valueSplitChar, (FontMetrics)fmText), (boolean)false);
        }
        return str;
    }

    private String getTruncatedValue(String value, FontMetrics fm, double len) {
        int JUSTIFICATION_START = 10;
        int valueHAlign = 0;
        boolean valueVAlign = true;
        boolean numericLabel = false;
        if (valueHAlign == JUSTIFICATION_START) {
            return value;
        }
        String str = value;
        if ((double)fm.stringWidth(value) > len) {
            if (numericLabel) {
                return "*";
            }
            if (len < (double)fm.stringWidth("X...")) {
                if (str.length() > 1 && (double)fm.stringWidth(str.substring(0, 2)) < len) {
                    return str.substring(0, 2);
                }
                if (str.length() > 0 && (double)fm.stringWidth(str.substring(0, 1)) < len) {
                    return str.substring(0, 1);
                }
                return str.substring(0, 0);
            }
            for (int lastIndex = str.length() - 1; (double)fm.stringWidth(str) > len && lastIndex >= 0; --lastIndex) {
                str = value.substring(0, lastIndex - 2) + "...";
            }
        }
        return str;
    }

    @Override
    public boolean createPhaseIndexVar(QCBlockOverlay phase) {
        return false;
    }

    public boolean isOneDimensional() {
        return true;
    }

    public boolean isDataOnHorizontalSide() {
        return true;
    }

    public int getPreferredSizeOnDataLessSide() {
        return this.getLegendHeight();
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public void setTooltipEnabled(boolean tooltipEnabled) {
        this.tooltipEnabled = tooltipEnabled;
    }

    public void setBlockFillTransparency(double d) {
        this.blockFillTransparency = d;
    }

    public StringVariable getPhaseUCLVar(int i) {
        return i == 0 ? this.phaseUCL1Var : this.phaseUCL2Var;
    }

    public StringVariable getPhaseCTLVar(int i) {
        return i == 0 ? this.phaseCTL1Var : this.phaseCTL2Var;
    }

    public StringVariable getPhaseLCLVar(int i) {
        return i == 0 ? this.phaseLCL1Var : this.phaseLCL2Var;
    }

    public Color getBlockRefFillColor(int igrp) {
        int k;
        int j;
        Color fillColor = null;
        if (this.refListLevels == null) {
            return fillColor;
        }
        int n = this.refListLevels.length;
        int iFill = -1;
        for (int i = n - 1; i >= 0; --i) {
            if (igrp < this.refList[i]) continue;
            iFill = i;
            break;
        }
        if (iFill > -1 && (j = (k = this.refListLevels == null ? iFill : this.refListLevels[iFill] + 1) - k / 2 * 2) == 1) {
            fillColor = this.altRefFillStyle.getColor();
        }
        return fillColor;
    }

    public class BlockEntry {
        public String label;
        public Vector labelAttributes;
        public AttributedString labelAS;
        public int labelWidth;
        public int labelHeight;
        public boolean truncated;
        public String truncatedLabel;
        public int truncatedWidth;
        public boolean display;
        public boolean displayLabel;
        public boolean uclBreak = false;
        public boolean ctlBreak = false;
        public boolean lclBreak = false;
        public double x = 0.0;
        public double xLeft = 0.0;
        public double blockWidth = 0.0;
        public int first = -1;
        public int last = -1;
        public int[] real = new int[2];
        public int level = 0;
        public int alternate = 0;
        public boolean limits = false;
        public int fillIndex = 0;
        public Color fill = null;
        public static final boolean useLastEQNext = true;

        public BlockEntry() {
            this.display = true;
        }

        public BlockEntry(String s, int index) {
            this.label = s;
            this.first = index;
            this.display = true;
        }

        public BlockEntry(String s, int a, int b) {
            this.label = s;
            this.first = a;
            this.last = b;
            this.display = true;
        }

        public BlockEntry(String s, String limits, String subgrpN, int index) {
            this.label = s + " \n " + limits + " \n " + subgrpN;
            this.first = index;
            this.display = true;
        }
    }

    public static enum BlockType {
        BLOCK,
        PHASE,
        REFERENCE,
        BLOCKREF,
        PHASEREF,
        PHASEBOX,
        NONE;


        public static BlockType fromInteger(int i) {
            return BlockType.fromInteger(i, BLOCK);
        }

        public static BlockType fromInteger(int i, BlockType dflt) {
            BlockType rc;
            switch (i) {
                case 0: {
                    rc = BLOCK;
                    break;
                }
                case 1: {
                    rc = PHASE;
                    break;
                }
                case 2: {
                    rc = BLOCKREF;
                    break;
                }
                case 3: {
                    rc = PHASEREF;
                    break;
                }
                case 4: {
                    rc = PHASEBOX;
                    break;
                }
                default: {
                    rc = dflt;
                }
            }
            return rc;
        }
    }

    public static enum LegendPosition {
        NONE,
        ABOVE,
        MAX,
        MIN,
        BELOW,
        BOX;


        public static LegendPosition fromInteger(int i) {
            return LegendPosition.fromInteger(i, NONE);
        }

        public static LegendPosition fromInteger(int i, LegendPosition dflt) {
            LegendPosition rc;
            switch (i) {
                case 0: {
                    rc = NONE;
                    break;
                }
                case 1: {
                    rc = ABOVE;
                    break;
                }
                case 2: {
                    rc = MAX;
                    break;
                }
                case 3: {
                    rc = MIN;
                    break;
                }
                case 4: {
                    rc = BELOW;
                    break;
                }
                case 5: {
                    rc = BOX;
                    break;
                }
                default: {
                    rc = dflt;
                }
            }
            return rc;
        }
    }

    public static enum LabelPosition {
        NONE,
        ABOVE,
        LEFT,
        RIGHT,
        ROTATED;


        public static LabelPosition fromInteger(int i) {
            return LabelPosition.fromInteger(i, NONE);
        }

        public static LabelPosition fromInteger(int i, LabelPosition dflt) {
            LabelPosition rc;
            switch (i) {
                case 0: {
                    rc = NONE;
                    break;
                }
                case 1: {
                    rc = ABOVE;
                    break;
                }
                case 2: {
                    rc = LEFT;
                    break;
                }
                case 3: {
                    rc = RIGHT;
                    break;
                }
                case 4: {
                    rc = ROTATED;
                    break;
                }
                default: {
                    rc = dflt;
                }
            }
            return rc;
        }

        public static LabelPosition fromString(String s, LabelPosition dflt) {
            LabelPosition rc = s.equalsIgnoreCase("none") ? NONE : (s.equalsIgnoreCase("above") ? ABOVE : (s.equalsIgnoreCase("top") ? ABOVE : (s.equalsIgnoreCase("left") ? LEFT : (s.equalsIgnoreCase("right") ? RIGHT : (s.equalsIgnoreCase("rotated") ? ROTATED : dflt)))));
            return rc;
        }
    }

    public class Block {
        public boolean display = true;
        public int role;
        public int labelFirstObs = -1;
        public int labelLastObs = -1;
        public Object fill = null;
        public String fillType;
        public String label;
        public int labelWidth;
        public boolean labelDisplay;
        public String alternateLabel;
        public int alternateWidth;
        public boolean alternateDisplay;
        public boolean numeric = true;
        public boolean rotateEntry = false;
        public boolean phaseLimits = false;
        public Vector<BlockEntry> entries = new Vector();
        public int nEntries = 0;
        protected int maxValueWidth = 0;
        protected int maxValueHeight = 0;
        protected int entryHeight = 0;
        protected int labelHeight = 0;
        protected int totalHeight = 0;

        public Block() {
            QCBlockOverlay.this.type = BlockType.BLOCK;
        }

        public Block(BlockType t) {
            QCBlockOverlay.this.type = t;
        }

        public int getTrackHeight() {
            int h = QCBlockOverlay.this.trackTextHeight;
            if (QCBlockOverlay.this.labelsOn && QCBlockOverlay.this.labelPosition == LabelPosition.ABOVE && this.labelDisplay) {
                h += QCBlockOverlay.this.trackLabelHeight;
            }
            return h;
        }
    }

    public static enum LabelFit {
        SKIP,
        SCALED,
        TRUNCATED,
        CLIPPED,
        ROTATED;


        public static LabelFit fromInteger(int i) {
            return LabelFit.fromInteger(i, TRUNCATED);
        }

        public static LabelFit fromInteger(int i, LabelFit dflt) {
            LabelFit rc;
            switch (i) {
                case 0: {
                    rc = SKIP;
                    break;
                }
                case 1: {
                    rc = SCALED;
                    break;
                }
                case 2: {
                    rc = TRUNCATED;
                    break;
                }
                case 3: {
                    rc = CLIPPED;
                    break;
                }
                case 4: {
                    rc = ROTATED;
                    break;
                }
                default: {
                    rc = dflt;
                }
            }
            return rc;
        }
    }

    public static enum LabelJustify {
        LEFT,
        CENTER;


        public static LabelJustify fromInteger(int i) {
            return LabelJustify.fromInteger(i, LEFT);
        }

        public static LabelJustify fromInteger(int i, LabelJustify dflt) {
            LabelJustify rc;
            switch (i) {
                case 0: {
                    rc = LEFT;
                    break;
                }
                case 1: {
                    rc = CENTER;
                    break;
                }
                default: {
                    rc = dflt;
                }
            }
            return rc;
        }
    }

    public static enum PhaseConnect {
        NONE,
        BOX,
        MEAN,
        DEFAULT;


        public static PhaseConnect fromInteger(int i) {
            return PhaseConnect.fromInteger(i, NONE);
        }

        public static PhaseConnect fromInteger(int i, PhaseConnect dflt) {
            PhaseConnect rc;
            switch (i) {
                case 0: {
                    rc = NONE;
                    break;
                }
                case 1: {
                    rc = BOX;
                    break;
                }
                case 2: {
                    rc = MEAN;
                    break;
                }
                default: {
                    rc = dflt;
                }
            }
            return rc;
        }
    }
}

