/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.gtk.gl;

import com.sas.analytics.qc.statgraph.sgchart.gtk.AQCTukeyBox;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.util.QCMargins;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.ComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class QCTukeyBox
extends AQCTukeyBox {
    int nIndices;
    int nValues;

    public QCTukeyBox() {
        super((ATransform)new Transform());
    }

    private int getFirst(int index) {
        int i;
        try {
            if (this.outlierCount.getValue(index) >= 0) {
                int idx = 0;
                for (int i2 = 0; i2 < index; ++i2) {
                    idx += 7 + this.outlierCount.getValue(i2);
                }
                return idx;
            }
        }
        catch (MissingValueException idx) {
            // empty catch block
        }
        int j = -1;
        double value0 = Double.NaN;
        double value1 = Double.NaN;
        for (i = 0; i < this.nValues && j < index; ++i) {
            try {
                value1 = this.x.getValue(i);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            if (value0 != value1) {
                ++j;
            }
            value0 = value1;
        }
        return i - 1;
    }

    public void init(AInitAction ia) {
        super.init(ia);
        this.nIndices = ia.getValueCount();
        ia.pushValueCount();
        this.x.init(ia);
        this.y.init(ia);
        this.nValues = ia.getValueCount();
        ia.popValueCount();
    }

    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction action = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel channel = action.getChannel();
        int index = action.getValueIndex();
        this.renderVerticalBox(channel, index);
    }

    private void renderVerticalBox(Channel channel, int index) throws MissingValueException {
        int cap;
        double adj;
        int i = this.getFirst(index);
        double minX = 0.0;
        double maxX = this.boxWidth.getValue(index);
        double halfX = (maxX - minX) / 2.0;
        boolean hasMinValue = this.graphed.getValue(i);
        double minY = this.y.getValue(i);
        boolean hasQ1Value = this.graphed.getValue(++i);
        double q1 = this.y.getValue(i);
        boolean hasMedianValue = this.graphed.getValue(++i);
        double median = this.y.getValue(i);
        boolean hasQ3Value = this.graphed.getValue(++i);
        double q3 = this.y.getValue(i);
        boolean hasMaxValue = this.graphed.getValue(++i);
        double maxY = this.y.getValue(i);
        boolean hasMeanValue = this.graphed.getValue(++i);
        double mean = this.y.getValue(i);
        ++i;
        boolean hasFillValue = this.fillOn.getValue(index);
        boolean hasLineOn = this.outlineOn.getValue(index);
        boolean hasOutlineValue = !hasFillValue || this.getSkinType() == 0;
        boolean hasWhiskers = this.graphWhiskers && (this.graphMin && hasMinValue || this.graphMax && hasMaxValue);
        hasOutlineValue = hasOutlineValue && hasLineOn;
        hasMedianValue = hasMedianValue && (hasLineOn || hasFillValue);
        hasMeanValue = hasMeanValue && (hasLineOn || hasFillValue);
        hasWhiskers = hasWhiskers && (hasLineOn || hasFillValue);
        double n = this.rawY.getValue(i);
        ++i;
        minX = -halfX;
        maxX = halfX;
        halfX = 0.0;
        boolean ex = this.extreme.getValue(index);
        if (ex) {
            int end = this.nValues;
            if (index + 1 < this.nIndices) {
                end = this.getFirst(index + 1);
            }
            for (int j = i; j < end; ++j) {
                double v = this.y.getValue(j);
                if (v > maxY) {
                    maxY = v;
                }
                if (!(v < minY)) continue;
                minY = v;
            }
        }
        boolean notch = this.notched.getValue(index) && n > 0.0;
        double endY = 1.58 * (q3 - q1) / Math.sqrt(n);
        double endX = notch ? 0.25 * (maxX - minX) : 0.0;
        int dy = 0;
        switch (this.context) {
            case BOXPOINTSBOX: {
                dy = (int)(this.markerWidth.getValue(index) / 2.0);
                dy = (int)QCMargins.adjustForDPI(dy);
                dy += QCMargins.getPointsBoxInnerY();
                break;
            }
            default: {
                dy = 0;
            }
        }
        if (this.graphFill && hasFillValue) {
            channel.glSkinType(this.getSkinType());
            channel.glSkinImage(this.getSkin());
            channel.glPixelBenderImages(this.getPixelBenderImages(1));
            channel.glDPIScaleFactor(this.getDPIScaleFactor());
            channel.glSkinCategory(1);
            Color c = this.fillColor.getValue(index);
            channel.glColor(c);
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            channel.glPolygonMode(3);
            channel.glVertex(minX, q1 - (double)dy);
            if (notch) {
                channel.glVertex(minX, median - endY);
                channel.glVertex(minX + endX, median);
                channel.glVertex(minX, median + endY);
            }
            channel.glVertex(minX, q3 + (double)dy);
            channel.glVertex(maxX, q3 + (double)dy);
            if (notch) {
                channel.glVertex(maxX, median + endY);
                channel.glVertex(maxX - endX, median);
                channel.glVertex(maxX, median - endY);
            }
            channel.glVertex(maxX, q1 - (double)dy);
            channel.glEnd();
            channel.glSkinType(0);
            channel.glSkinImage(null);
            channel.glPixelBenderImages(null);
            channel.glSkinCategory(0);
        }
        int o_stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.outlineStippleFactor.getValue(index));
        int o_stipplePattern = this.outlineStipplePattern.getValue(index);
        if (this.graphOutline && hasOutlineValue) {
            Color c = this.outlineColor.getValue(index);
            channel.glColor(c);
            double w = this.outlineWidth.getValue(index);
            channel.glLineWidth((float)w);
            if (o_stippleFactor > 0) {
                channel.glEnable(6);
                channel.glLineStipple(o_stippleFactor, (int)((short)o_stipplePattern));
            }
            double midX = Math.floor((minX + maxX) / 2.0);
            channel.glBegin(1);
            if (this.context == QCOverlay.QCResponseContext.BOXPOINTSJOIN || this.context == QCOverlay.QCResponseContext.BOXPOINTSJOINID) {
                channel.glVertex(midX, q3);
                channel.glVertex(midX, q1);
            } else {
                if (w > 1.0) {
                    channel.glVertex(midX, q1 - (double)dy);
                }
                channel.glVertex(minX, q1 - (double)dy);
                if (notch) {
                    channel.glVertex(minX, median - endY);
                    channel.glVertex(minX + endX, median);
                    channel.glVertex(minX, median + endY);
                }
                channel.glVertex(minX, q3 + (double)dy);
                channel.glVertex(maxX, q3 + (double)dy);
                if (notch) {
                    channel.glVertex(maxX, median + endY);
                    channel.glVertex(maxX - endX, median);
                    channel.glVertex(maxX, median - endY);
                }
                channel.glVertex(maxX, q1 - (double)dy);
                if (w > 1.0) {
                    channel.glVertex(midX, q1 - (double)dy);
                } else {
                    channel.glVertex(minX, q1 - (double)dy);
                }
            }
            channel.glEnd();
        }
        double d = adj = this.getSkinType() == 0 ? 0.0 : 1.0;
        if (this.graphMedian && hasMedianValue) {
            channel.glColor(this.medianColor.getValue(index));
            if (this.medianShape.getValue(index) >= 0) {
                channel.glEdgeColor(this.medianColor.getValue(index));
                channel.setMarkerSize((int)this.medianWidth.getValue(index));
                channel.setMarkerType(this.medianShape.getValue(index));
                if (this.weightedMarkerEnabled.getValue(index)) {
                    channel.glEnable(28);
                } else {
                    channel.glDisable(28);
                }
                channel.setMarkerWeight(this.markerWeight.getValue(index));
                channel.glBegin(4);
                channel.glVertex(halfX, median);
                channel.glEnd();
            } else {
                channel.glLineWidth((float)this.medianWidth.getValue(index));
                int m_stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.medianStippleFactor.getValue(index));
                int m_stipplePattern = this.medianStipplePattern.getValue(index);
                if (m_stippleFactor > 0) {
                    channel.glEnable(6);
                    channel.glLineStipple(m_stippleFactor, (int)((short)m_stipplePattern));
                }
                channel.glBegin(1);
                if (notch) {
                    channel.glVertex(minX + endX, median);
                    channel.glVertex(maxX - endX - adj, median);
                } else {
                    channel.glVertex(minX, median);
                    channel.glVertex(maxX - adj, median);
                }
                channel.glEnd();
                if (m_stippleFactor > 0) {
                    channel.glDisable(6);
                }
            }
        }
        if (this.graphMean && hasMeanValue) {
            int size;
            int sizeMax = (int)(maxX - adj - minX);
            channel.glSkinType(this.getSkinType());
            channel.glPixelBenderImages(this.getPixelBenderImages(4));
            channel.glDPIScaleFactor(this.getDPIScaleFactor());
            double d2 = this.runsTests.getValue(index);
            if (this.runsTestMarker != null && (d2 == 1.0 || d2 == 3.0)) {
                size = this.runsTestMarker.size.getValue();
                size = Math.min(size, sizeMax);
                channel.setMarkerType(this.runsTestMarker.type.getValue());
                channel.setMarkerSize(size);
                channel.setMarkerWeight(this.runsTestMarker.edgeWeight.getValue());
                channel.glColor(this.runsTestMarker.color.getValue());
                channel.glEdgeColor(this.runsTestMarker.edgeColor.getValue());
                channel.glLineWidth((float)this.runsTestMarker.edgeWidth.getValue());
                channel.glEnable(28);
                channel.glBegin(4);
                channel.glVertex(halfX, mean);
                channel.glEnd();
                channel.glLineWidth(1.0f);
            } else if (this.meanMarker != null && this.graphFill && hasFillValue) {
                Color c = this.fillColor.getValue(index);
                size = (int)this.meanWidth.getValue(index);
                size = Math.min(size, sizeMax);
                channel.setMarkerType(this.meanMarker.type.getValue());
                channel.glColor(c);
                channel.setMarkerSize(size);
                channel.setMarkerWeight(this.markerWeight.getValue(index));
                channel.glEdgeColor(this.meanColor.getValue(index));
                channel.glLineWidth((float)((int)this.meanEdgeWidth.getValue(index)));
                channel.glEnable(28);
                channel.glBegin(4);
                channel.glVertex(halfX, mean);
                channel.glEnd();
                channel.glLineWidth(1.0f);
            } else {
                size = (int)this.meanWidth.getValue(index);
                size = Math.min(size, sizeMax);
                channel.glColor(this.meanColor.getValue(index));
                if (this.meanShape.getValue(index) >= 0) {
                    channel.glEdgeColor(this.meanColor.getValue(index));
                    channel.setMarkerSize(size);
                    channel.setMarkerType(this.meanShape.getValue(index));
                    if (this.weightedMarkerEnabled.getValue(index)) {
                        channel.glEnable(28);
                    } else {
                        channel.glDisable(28);
                    }
                    channel.setMarkerWeight(this.markerWeight.getValue(index));
                    channel.glLineWidth((float)((int)this.meanEdgeWidth.getValue(index)));
                    if (this.skinType == 0) {
                        channel.glBegin(4);
                        channel.glVertex(halfX, mean);
                        channel.glEnd();
                    } else {
                        channel.glMarker(halfX, mean, 0.0);
                    }
                    channel.glLineWidth(1.0f);
                } else {
                    channel.glLineWidth((float)this.meanWidth.getValue(index));
                    channel.glBegin(1);
                    if (notch) {
                        double deltaX = 0.0;
                        double dist = Math.abs(median - mean);
                        deltaX = dist >= endY ? 0.0 : (endY - dist) * endX / endY;
                        channel.glVertex(minX + deltaX, mean);
                        channel.glVertex(maxX - deltaX, mean);
                    } else {
                        channel.glVertex(minX, mean);
                        channel.glVertex(maxX, mean);
                    }
                    channel.glEnd();
                }
                channel.glSkinType(0);
                channel.glPixelBenderImages(null);
            }
        }
        if (o_stippleFactor > 0) {
            channel.glDisable(6);
        }
        if (this.graphWhiskers && hasWhiskers) {
            double w;
            int w_stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.whiskerStippleFactor.getValue(index));
            int w_stipplePattern = this.whiskerStipplePattern.getValue(index);
            Color c = this.whiskerColor.getValue(index);
            channel.glColor(c);
            channel.glLineWidth((float)this.whiskerWidth.getValue(index));
            if (w_stippleFactor > 0) {
                channel.glEnable(6);
                channel.glLineStipple(w_stippleFactor, (int)((short)w_stipplePattern));
            }
            double d3 = w = (w = this.outlineWidth.getValue(index)) == 1.0 ? 0.0 : w / 2.0 - 1.0;
            if (this.graphMin && hasMinValue) {
                channel.glBegin(1);
                channel.glVertex(halfX, q1 + adj - w);
                channel.glVertex(halfX, minY);
                channel.glEnd();
            }
            if (this.graphMax && hasMaxValue) {
                channel.glBegin(1);
                channel.glVertex(halfX, q3 + w);
                channel.glVertex(halfX, maxY);
                channel.glEnd();
            }
            if (w_stippleFactor > 0) {
                channel.glDisable(6);
            }
        }
        if ((cap = this.capShape.getValue(index)) == 1 || cap == 2 || cap == 3 && this.graphWhiskers && hasWhiskers) {
            double quarterX = (maxX - minX) / 4.0;
            int c_stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.capStippleFactor.getValue(index));
            int c_stipplePattern = this.capStipplePattern.getValue(index);
            channel.glColor(this.capColor.getValue(index));
            channel.glLineWidth((float)this.capWidth.getValue(index));
            if (c_stippleFactor > 0) {
                channel.glEnable(6);
                channel.glLineStipple(c_stippleFactor, (int)((short)c_stipplePattern));
            }
            if (cap == 1) {
                if (this.graphMin && hasMinValue) {
                    channel.glBegin(1);
                    channel.glVertex(minX + quarterX, minY);
                    channel.glVertex(maxX - quarterX, minY);
                    channel.glEnd();
                }
                if (this.graphMax && hasMaxValue) {
                    channel.glBegin(1);
                    channel.glVertex(minX + quarterX, maxY);
                    channel.glVertex(maxX - quarterX, maxY);
                    channel.glEnd();
                }
            } else if (cap == 2) {
                if (this.graphMin && hasMinValue) {
                    channel.glBegin(1);
                    channel.glVertex(minX, minY);
                    channel.glVertex(maxX, minY);
                    channel.glEnd();
                }
                if (this.graphMax && hasMaxValue) {
                    channel.glBegin(1);
                    channel.glVertex(minX, maxY);
                    channel.glVertex(maxX, maxY);
                    channel.glEnd();
                }
            } else if (cap == 3) {
                double quarterY = Math.min(q1 - minY, maxY - q3) / 4.0;
                if (this.graphMin && hasMinValue) {
                    channel.glBegin(1);
                    channel.glVertex(minX, minY + quarterY);
                    channel.glVertex(minX, minY);
                    channel.glVertex(maxX, minY);
                    channel.glVertex(maxX, minY + quarterY);
                    channel.glEnd();
                }
                if (this.graphMax && hasMaxValue) {
                    channel.glBegin(1);
                    channel.glVertex(minX, maxY - quarterY);
                    channel.glVertex(minX, maxY);
                    channel.glVertex(maxX, maxY);
                    channel.glVertex(maxX, maxY - quarterY);
                    channel.glEnd();
                }
            }
            if (c_stippleFactor > 0) {
                channel.glDisable(6);
            }
        }
        if (this.graphOutliers && this.markerOn.getValue(index) && !ex) {
            channel.glColor(this.markerColor.getValue(index));
            channel.glEdgeColor(this.markerColor.getValue(index));
            channel.setMarkerSize((int)this.markerWidth.getValue(index));
            channel.setMarkerType(this.markerShape.getValue(index));
            if (this.weightedMarkerEnabled.getValue(index)) {
                channel.glEnable(28);
            } else {
                channel.glDisable(28);
            }
            channel.setMarkerWeight(this.markerWeight.getValue(index));
            channel.glBegin(4);
            int j = this.nValues;
            if (index + 1 < this.nIndices) {
                j = this.getFirst(index + 1);
            }
            while (i < j) {
                channel.glVertex(halfX, this.y.getValue(i));
                ++i;
            }
            channel.glEnd();
        }
    }

    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        Vec3d size;
        Vec3d center;
        ComputeBoundingBoxAction bba = ComputeBoundingBoxAction.castComputeBoundingBoxAction((AComputeBoundingBoxAction)bBoxAction);
        int index = bba.getValueIndex();
        BoundingBox box = bba.getElementBoundingBox();
        int i = this.getFirst(index);
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        try {
            maxX = this.boxWidth.getValue(index);
            minY = this.y.getValue(i);
            maxY = this.y.getValue(i += 4);
            i += 3;
            int j = this.nValues;
            if (index + 1 < this.nIndices) {
                j = this.getFirst(index + 1);
            }
            while (i < j) {
                double outY = this.y.getValue(i);
                if (minY > outY) {
                    minY = outY;
                }
                if (maxY < outY) {
                    maxY = outY;
                }
                ++i;
            }
        }
        catch (MissingValueException j) {
            // empty catch block
        }
        int orient = 0;
        try {
            orient = this.orientation.getValue(index);
        }
        catch (MissingValueException outY) {
            // empty catch block
        }
        if (orient == 0) {
            center = new Vec3d((maxX - minX) / 2.0, (maxY - minY) / 2.0, 0.0);
            size = new Vec3d(maxX - minX, maxY - minY, 0.0);
        } else {
            center = new Vec3d((maxY - minY) / 2.0, (maxX - minX) / 2.0, 0.0);
            size = new Vec3d(maxY - minY, maxX - minX, 0.0);
        }
        box.union(center, size);
    }
}

