/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.gtk.gl;

import com.sas.analytics.qc.statgraph.sgchart.util.BBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.ALineConnector;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.FilledLineConnector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.ResetAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.util.Vector;

public class QCStepConnector
extends ALineConnector {
    public static final byte LINE = 0;
    public static final byte STEP_LEFT = 1;
    public static final byte STEP_RIGHT = 2;
    public static final byte STEP_CENTER = 3;
    private Vec3d v1 = new Vec3d();
    private Vec3d v2 = new Vec3d();
    protected Color myColor = ColorProperty.getDefaultColor();
    protected Color myFillColor = ColorProperty.getDefaultColor();
    protected float myLineWidth;
    protected BBox frame = null;
    protected BBox[] phaseFrames = null;
    protected int iPhase = 0;
    protected double prevPointX = Double.NaN;
    protected double prevPointY = Double.NaN;
    protected boolean outOfRange = false;

    public QCStepConnector() {
        super((ATransform)new Transform());
    }

    public void setFrame(BBox frame) {
        this.frame = frame;
    }

    public void setPhaseFrames(BBox[] frames) {
        this.phaseFrames = frames;
    }

    public void setPhase(int i) {
        this.iPhase = i;
    }

    public void initPhaseFlags() {
        this.iPhase = 0;
    }

    protected void drawSelectableGeometry(Channel channel, int valueIndex, boolean fill, double lineWidth, Vec3d point2) {
        Vector v = this.getCurrentPolyline();
        if (v == null) {
            return;
        }
        Vec3d point1 = this.v2;
        int previousValueIndex = (Integer)v.elementAt(v.size() - 1);
        try {
            point1.x = this.pointX.getValue(previousValueIndex);
            point1.y = this.pointY.getValue(previousValueIndex);
            point1.z = this.pointZ.getValue(previousValueIndex);
            channel.glLineWidth((float)lineWidth);
            double midx = point1.x + (point2.x - point1.x) / 2.0;
            double midy = point1.y + (point2.y - point1.y) / 2.0;
            channel.glBegin(1);
            channel.glVertex(midx, point2.y, point2.z);
            channel.glVertex(point2.x, point2.y, point2.z);
            channel.glEnd();
            this.replaceObservation(channel, previousValueIndex);
            channel.glBegin(1);
            channel.glVertex(point1.x, point1.y, point1.z);
            channel.glVertex(midx, point1.y, point1.z);
            channel.glEnd();
            this.replaceObservation(channel, valueIndex);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    public void reset(AResetAction resetAction) {
        double extremeXMax;
        double extremeXMin;
        if (this.multipleGroup) {
            return;
        }
        super.reset(resetAction);
        ResetAction ra = (ResetAction)resetAction;
        Channel channel = ra.getChannel();
        int polyLineCount = this.renderIndices.size();
        if (polyLineCount <= 0) {
            return;
        }
        if (this.phaseFrames != null) {
            int nPhase = this.phaseFrames.length;
            if (this.iPhase >= nPhase || this.phaseFrames[this.iPhase] == null) {
                return;
            }
            extremeXMin = this.phaseFrames[this.iPhase].getULX();
            extremeXMax = this.phaseFrames[this.iPhase].getLRX();
            ++this.iPhase;
        } else if (this.frame != null) {
            extremeXMin = this.frame.getULX();
            extremeXMax = this.frame.getLRX();
        } else {
            return;
        }
        Color c = ColorProperty.getDefaultColor();
        Color fc = ColorProperty.getDefaultColor();
        float w = 1.0f;
        boolean isFill = false;
        int firstIndex = this.getFirstIndex();
        try {
            w = (float)this.lineWidth.getValue(firstIndex);
            c = this.color.getValue(firstIndex);
            fc = this.fillColor.getValue(firstIndex);
            isFill = this.fillOn.getValue(firstIndex);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        channel.glPushAttrib(0);
        channel.glLineWidth(w);
        channel.glColor(c);
        channel.lineCapStyle(0);
        channel.setLineJoinStyle(1);
        if (this.stippleFactor > 0) {
            channel.glEnable(6);
            channel.glLineStipple(this.stippleFactor, (int)((short)this.stipplePattern));
        }
        double endX = Double.NaN;
        double beginX = Double.NaN;
        boolean extendLeft = false;
        boolean extendRight = false;
        for (int i = 0; i < polyLineCount; ++i) {
            int index;
            int intersectionCount;
            Vector v = (Vector)this.renderIndices.elementAt(i);
            if (v == null || (intersectionCount = v.size()) == 0) continue;
            try {
                index = (Integer)v.elementAt(0);
                beginX = this.pointX.getValue(index);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            try {
                index = (Integer)v.elementAt(intersectionCount - 1);
                endX = this.pointX.getValue(index);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            for (int j = 1; j < intersectionCount; ++j) {
                try {
                    index = (Integer)v.elementAt(j - 1);
                    this.v1.x = this.pointX.getValue(index);
                    this.v1.y = this.pointY.getValue(index);
                    this.v1.z = this.pointZ.getValue(index);
                    index = (Integer)v.elementAt(j);
                    this.v2.x = this.pointX.getValue(index);
                    this.v2.y = this.pointY.getValue(index);
                    this.v2.z = this.pointZ.getValue(index);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                if (!extendLeft) {
                    this.v1.x = extremeXMin;
                    extendLeft = true;
                    if (!Double.isNaN(this.prevPointX) && !Double.isNaN(this.prevPointY)) {
                        channel.glBegin(1);
                        channel.glVertex(this.prevPointX, this.prevPointY, 0.0);
                        channel.glEnd();
                        this.prevPointX = Double.NaN;
                        this.prevPointY = Double.NaN;
                    }
                }
                if (i == polyLineCount - 1 && j == intersectionCount - 1) {
                    this.prevPointX = this.v2.x = extremeXMax;
                    this.prevPointY = this.v2.y;
                }
                double middleX = this.v1.x + (this.v2.x - this.v1.x) / 2.0;
                double middleY = this.v1.y + (this.v2.y - this.v1.y) / 2.0;
                channel.glBegin(1);
                channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                channel.glVertex(middleX, this.v1.y, this.v1.z);
                channel.glEnd();
                channel.glBegin(1);
                channel.glVertex(middleX, this.v2.y, this.v1.z);
                channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
                channel.glEnd();
            }
        }
        channel.glPopAttrib();
        this.resetRenderIndices();
    }

    protected void renderPolylineGroup(ABuildAction buildAction, FilledLineConnector.PolylineGroup group, boolean fillOn) {
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel channel = ba.getChannel();
        int polyLineCount = group.getPolylineCount();
        if (polyLineCount <= 0) {
            return;
        }
        for (int i = 0; i < polyLineCount; ++i) {
            Vector line = group.getPolyline(i);
            if (line == null) continue;
            this.drawStep(channel, line, ba.isUseNameStack());
        }
    }

    private void drawJoinedStep(Channel channel, Vector aLine, boolean useNameStack) {
        if (useNameStack) {
            this.drawStep(channel, aLine, useNameStack);
            return;
        }
        int intersectionCount = aLine.size();
        channel.glBegin(1);
        for (int j = 1; j < intersectionCount; ++j) {
            try {
                int index = (Integer)aLine.elementAt(j - 1);
                this.v1.x = this.pointX.getValue(index);
                this.v1.y = this.pointY.getValue(index);
                this.v1.z = this.pointZ.getValue(index);
                index = (Integer)aLine.elementAt(j);
                this.v2.x = this.pointX.getValue(index);
                this.v2.y = this.pointY.getValue(index);
                this.v2.z = this.pointZ.getValue(index);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            double middleX = this.v1.x + (this.v2.x - this.v1.x) / 2.0;
            double middleY = this.v1.y + (this.v2.y - this.v1.y) / 2.0;
            channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
            channel.glVertex(middleX, this.v1.y, this.v1.z);
            channel.glVertex(middleX, this.v2.y, this.v1.z);
            channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
        }
        channel.glEnd();
    }

    private void drawStep(Channel channel, Vector aLine, boolean useNameStack) {
        int index1 = 0;
        int index2 = 0;
        int intersectionCount = aLine.size();
        for (int j = 1; j < intersectionCount; ++j) {
            try {
                index1 = (Integer)aLine.elementAt(j - 1);
                this.v1.x = this.pointX.getValue(index1);
                this.v1.y = this.pointY.getValue(index1);
                this.v1.z = this.pointZ.getValue(index1);
                index2 = (Integer)aLine.elementAt(j);
                this.v2.x = this.pointX.getValue(index2);
                this.v2.y = this.pointY.getValue(index2);
                this.v2.z = this.pointZ.getValue(index2);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            double middleX = this.v1.x + (this.v2.x - this.v1.x) / 2.0;
            double middleY = this.v1.y + (this.v2.y - this.v1.y) / 2.0;
            if (useNameStack) {
                this.replaceObservation(channel, index1);
                channel.glLoadName((Object)this.currentGroup);
            }
            channel.glBegin(1);
            channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
            channel.glVertex(middleX - 1.0, this.v1.y, this.v1.z);
            channel.glEnd();
            if (useNameStack) {
                this.replaceObservation(channel, index2);
                channel.glLoadName((Object)this.currentGroup);
            }
            channel.glBegin(1);
            channel.glVertex(middleX, this.v2.y, this.v1.z);
            channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
            channel.glEnd();
        }
    }
}

