/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.gtk.gl;

import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.ALineSegment;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class QCNeedleConnector
extends ALineSegment {
    public final NumericProperty pointUCL = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty pointLCL = new NumericProperty((PropertyContainer)this, true);
    protected QCOverlay.QCDrawMode drawingMode;
    public ColorProperty runsTestColor = new ColorProperty((PropertyContainer)this, true);

    public QCNeedleConnector() {
        super((ATransform)new Transform());
    }

    public void setDrawingMode(QCOverlay.QCDrawMode mode) {
        this.drawingMode = mode;
    }

    public QCOverlay.QCDrawMode getDrawingMode() {
        return this.drawingMode;
    }

    public static void drawLineSegment(Channel channel, double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, double lineWidth, int stipplePat, int stippleFac) {
        QCNeedleConnector.drawLineSegment(channel, beginX, beginY, beginZ, endX, endY, endZ, color, lineWidth, stipplePat, stippleFac, false);
    }

    public static void drawLineSegment(Channel channel, double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, double lineWidth, int stipplePat, int stippleFac, boolean disableAntialiasForHorizontalOrVertical) {
        QCNeedleConnector.drawLineSegment(channel, beginX, beginY, beginZ, endX, endY, endZ, color, lineWidth, stipplePat, stippleFac, disableAntialiasForHorizontalOrVertical, 1);
    }

    public static void drawLineSegment(Channel channel, double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, double lineWidth, int stipplePat, int stippleFac, boolean disableAntialiasForHorizontalOrVertical, int drawCount) {
        boolean stippleNeeded;
        boolean bl = stippleNeeded = stippleFac > 0 && (stipplePat & 0xFFFF) != 65535;
        if (stippleNeeded) {
            channel.glEnable(6);
            channel.glLineStipple(stippleFac, (int)((short)stipplePat));
        }
        if (disableAntialiasForHorizontalOrVertical) {
            channel.glEnable(17);
        }
        channel.glLineWidth((float)lineWidth);
        channel.glColor(color);
        for (int i = 0; i < drawCount; ++i) {
            channel.glBegin(1);
            channel.glVertex(beginX, beginY, beginZ);
            channel.glVertex(endX, endY, endZ);
            channel.glEnd();
        }
        channel.glLineWidth(1.0f);
        if (disableAntialiasForHorizontalOrVertical) {
            channel.glDisable(17);
        }
        if (stippleNeeded) {
            channel.glDisable(6);
        }
    }

    public static void drawLineSegment(Channel channel, double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, double lineWidth, int stipplePat, int stippleFac, boolean disableAntialiasForHorizontalOrVertical, int drawCount, int skinType, float dpiFactor) {
        boolean stippleNeeded;
        boolean bl = stippleNeeded = stippleFac > 0 && (stipplePat & 0xFFFF) != 65535;
        if (stippleNeeded) {
            channel.glEnable(6);
            channel.glLineStipple(stippleFac, (int)((short)stipplePat));
        }
        if (disableAntialiasForHorizontalOrVertical) {
            channel.glEnable(17);
        }
        channel.glLineWidth((float)lineWidth);
        channel.glColor(color);
        channel.glSkinType(skinType);
        channel.glDPIScaleFactor(dpiFactor);
        for (int i = 0; i < drawCount; ++i) {
            channel.glBegin(1);
            channel.glVertex(beginX, beginY, beginZ);
            channel.glVertex(endX, endY, endZ);
            channel.glEnd();
        }
        channel.glLineWidth(1.0f);
        if (disableAntialiasForHorizontalOrVertical) {
            channel.glDisable(17);
        }
        if (stippleNeeded) {
            channel.glDisable(6);
        }
        channel.glSkinType(0);
    }

    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel channel = ba.getChannel();
        int index = ba.getValueIndex();
        Color needleColor = this.color.getValue(index);
        double bx = this.beginX.getValue(index);
        double by = this.beginY.getValue(index);
        double bz = this.beginZ.getValue(index);
        double ex = this.endX.getValue(index);
        double ey = this.endY.getValue(index);
        double ez = this.endZ.getValue(index);
        double lx = ex;
        double ly = Double.NaN;
        double lz = ez;
        double ucl = Double.NaN;
        double lcl = Double.NaN;
        boolean ooc = false;
        boolean testFlagged = false;
        if (this.pointUCL.isConnected()) {
            try {
                ucl = this.pointUCL.getValue(index);
                if (ey > ucl) {
                    ooc = true;
                    ly = ucl;
                }
            }
            catch (MissingValueException mve) {
                ucl = Double.NaN;
            }
        } else {
            ucl = Double.NaN;
        }
        if (this.pointLCL.isConnected()) {
            try {
                lcl = this.pointLCL.getValue(index);
                if (ey < lcl) {
                    ooc = true;
                    ly = lcl;
                }
            }
            catch (MissingValueException mve) {
                lcl = Double.NaN;
            }
        } else {
            lcl = Double.NaN;
        }
        boolean disableHV = true;
        int stippleFactor_sav = this.stippleFactor;
        if (this.linePattern.isConnected()) {
            int patternIndex = this.linePattern.getValue(index);
            this.stipplePattern = SASLinePatterns.getStipplePattern((int)patternIndex);
            this.stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)SASLinePatterns.getStippleFactor((int)patternIndex));
        } else if (this.linePattern.getValue() != -1) {
            int patternIndex = this.linePattern.getValue();
            this.stipplePattern = SASLinePatterns.getStipplePattern((int)patternIndex);
            this.stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)SASLinePatterns.getStippleFactor((int)patternIndex));
        } else if (this.stippleScaleFactor != 1.0) {
            this.stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.stippleFactor);
        }
        if (this.skinType == 0) {
            if (this.drawingMode == QCOverlay.QCDrawMode.DEFAULT || !ooc || testFlagged) {
                LineSegment.drawLineSegment((Channel)channel, (double)bx, (double)by, (double)bz, (double)ex, (double)ey, (double)ez, (Color)needleColor, (double)this.lineWidth.getValue(index), (int)this.stipplePattern, (int)this.stippleFactor, (boolean)disableHV, (int)((int)this.drawCount.getValue(index)));
            } else if (this.drawingMode == QCOverlay.QCDrawMode.HIGHLIGHT) {
                LineSegment.drawLineSegment((Channel)channel, (double)bx, (double)by, (double)bz, (double)ex, (double)ey, (double)ez, (Color)this.color.getValue(index), (double)this.lineWidth.getValue(index), (int)this.stipplePattern, (int)this.stippleFactor, (boolean)disableHV, (int)((int)this.drawCount.getValue(index)));
            } else if (this.drawingMode == QCOverlay.QCDrawMode.INNER) {
                LineSegment.drawLineSegment((Channel)channel, (double)bx, (double)by, (double)bz, (double)lx, (double)ly, (double)lz, (Color)this.color.getValue(index), (double)this.lineWidth.getValue(index), (int)this.stipplePattern, (int)this.stippleFactor, (boolean)disableHV, (int)((int)this.drawCount.getValue(index)));
            } else if (this.drawingMode == QCOverlay.QCDrawMode.OUTER) {
                LineSegment.drawLineSegment((Channel)channel, (double)lx, (double)ly, (double)lz, (double)ex, (double)ey, (double)ez, (Color)this.runsTestColor.getValue(), (double)this.lineWidth.getValue(index), (int)this.stipplePattern, (int)this.stippleFactor, (boolean)disableHV, (int)((int)this.drawCount.getValue(index)));
            }
        } else {
            LineSegment.drawLineSegment((Channel)channel, (double)bx, (double)by, (double)bz, (double)ex, (double)ey, (double)ez, (Color)this.color.getValue(index), (double)this.lineWidth.getValue(index), (int)this.stipplePattern, (int)this.stippleFactor, (boolean)disableHV, (int)((int)this.drawCount.getValue(index)), (int)this.skinType, (float)this.DPIScaleFactor);
        }
        this.stippleFactor = stippleFactor_sav;
    }
}

