/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.gtk.gl;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.FilledLineConnector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.LineConnector;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class QCLineConnector
extends LineConnector {
    public final NumericProperty pointUCL = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty pointLCL = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty runsTestIndex = new NumericProperty((PropertyContainer)this, true);
    protected int igrpLower = -1;
    protected int igrpUpper = -1;
    protected int drawAttr = 0;
    protected Color groupColor;

    public void setLowerSubgrpIndex(int i) {
        this.igrpLower = i;
    }

    public void setUpperSubgrpIndex(int i) {
        this.igrpUpper = i;
    }

    public void render(ABuildAction buildAction) throws MissingValueException {
        boolean is3d;
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel ch = ba.getChannel();
        int index = ba.getValueIndex();
        if (this.igrpLower != -1 && !this.multipleGroup && index < this.igrpLower) {
            return;
        }
        if (this.igrpUpper != -1 && !this.multipleGroup && index > this.igrpUpper) {
            return;
        }
        boolean bl = is3d = this.depth.length() > 0.0;
        if (is3d) {
            return;
        }
        Collection groups = this.perGroupPolylines.values();
        Iterator iter = groups.iterator();
        ch.glPushAttrib(0);
        while (iter.hasNext()) {
            FilledLineConnector.PolylineGroup group = (FilledLineConnector.PolylineGroup)iter.next();
            if (group.getPolylineCount() <= 0) continue;
            this.renderGroup(buildAction, group);
        }
        ch.glPopAttrib();
    }

    private void renderGroup(ABuildAction buildAction, FilledLineConnector.PolylineGroup group) {
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel channel = ba.getChannel();
        group.setDrawAttributes(channel);
        channel.lineCapStyle(1);
        channel.setLineJoinStyle(2);
        int polyLineCount = group.getPolylineCount();
        Vector line = null;
        for (int i = 0; i < polyLineCount; ++i) {
            line = group.getPolyline(i);
            Color color = this.groupColor = group.isHighlightOn() ? group.getHighlightColor() : group.getLineColor();
            if (line == null || line.size() <= 1) continue;
            this.drawPolyline(channel, line, ba.isUseNameStack());
        }
        channel.lineCapStyle(0);
        channel.setLineJoinStyle(0);
    }

    private void drawPolyline(Channel channel, Vector aLine, boolean useNameStack) {
        Vec3d v1 = new Vec3d();
        int intersectionCount = aLine.size();
        channel.setVertexBufferReallocationSize(intersectionCount);
        if (useNameStack) {
            this.drawSelectableGeometryForGroup(channel, aLine);
        } else {
            channel.glBegin(1);
            channel.glColor(this.groupColor);
            for (int j = 0; j < intersectionCount; ++j) {
                int index1 = (Integer)aLine.elementAt(j);
                try {
                    v1.x = this.pointX.getValue(index1);
                    v1.y = this.pointY.getValue(index1);
                    v1.z = this.pointZ.getValue(index1);
                    channel.glVertex(v1.x, v1.y, v1.z);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            channel.glEnd();
        }
        channel.setVertexBufferReallocationSize(10);
    }
}

