/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.gtk.gl;

import com.sas.analytics.qc.statgraph.sgchart.gtk.AQCLimitsConnector;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarLabel;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBlockOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCZone;
import com.sas.analytics.qc.statgraph.sgchart.util.BBox;
import com.sas.analytics.qc.statgraph.sgchart.util.QCMargins;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Bbox;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.Action;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.FilledLineConnector;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;

public class QCLimitsConnector
extends AQCLimitsConnector {
    public static final byte LINE = 0;
    public static final byte STEP_ = 1;
    public static final byte STEP_RIGHT = 2;
    public static final byte STEP_CENTER = 3;
    protected LineType type;
    protected double beginPointX2;
    protected double beginPointY2;
    protected double endPointX2;
    protected double endPointY2;
    protected double beginPointZoneALower;
    protected double beginPointZoneAUpper;
    protected double beginPointZoneBLower;
    protected double beginPointZoneBUpper;
    protected double beginPointZoneCLower;
    protected double beginPointZoneCUpper;
    protected Color myColor = ColorProperty.getDefaultColor();
    protected Color myFillColor = ColorProperty.getDefaultColor();
    protected float myLineWidth;
    protected Vector<QCBlockOverlay.BlockEntry> phaseEntries = null;
    protected BBox frame = null;
    protected BBox[] phaseFrames = null;
    protected int[] refList = null;
    protected int currentPhase;
    protected boolean outOfRangeMin = false;
    protected boolean outOfRangeMax = false;
    protected boolean extendXMin = false;
    protected double extremeXMin;
    protected boolean extendXMax = false;
    protected double extremeXMax;
    protected boolean phaseLimitLabelsOn = false;
    public QCStarLabel phaseLimitLabel = null;
    public QCStarLabel phaseUCL = null;
    public QCStarLabel phaseCTL = null;
    public QCStarLabel phaseLCL = null;
    private Vector<PhaseLabel> phaseLimitCoord = null;
    private Vector<PhaseLabel> phaseUCLCoord = null;
    private Vector<PhaseLabel> phaseCTLCoord = null;
    private Vector<PhaseLabel> phaseLCLCoord = null;
    protected boolean zoneLabelsOn = false;
    protected boolean zoneValuesOn = false;
    protected QCZone.ZoneLabelPos zoneLabelPosition = QCZone.ZoneLabelPos.INNER_LEFT;
    protected QCZone.ZoneValuePos zoneValuePosition = QCZone.ZoneValuePos.INNER_LEFT;
    public QCStarLabel zoneALabel = null;
    public QCStarLabel zoneAUpper = null;
    public QCStarLabel zoneALower = null;
    public QCStarLabel zoneBLabel = null;
    public QCStarLabel zoneBUpper = null;
    public QCStarLabel zoneBLower = null;
    public QCStarLabel zoneCLabel = null;
    public QCStarLabel zoneCUpper = null;
    public QCStarLabel zoneCLower = null;
    public final BooleanProperty uclLineOn = new BooleanProperty((PropertyContainer)this, true);
    public final BooleanProperty ctlLineOn = new BooleanProperty((PropertyContainer)this, true);
    public final BooleanProperty lclLineOn = new BooleanProperty((PropertyContainer)this, true);
    private double phasePointX;
    private double phasePointY;
    private double phasePointZ;
    private boolean lineBreak;
    protected NumericProperty pointY;
    protected NumericProperty pointY2;
    public final NumericProperty pointCTL = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty pointUCL = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty pointLCL = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty pointZoneALower = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty pointZoneAUpper = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty pointZoneBLower = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty pointZoneBUpper = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty pointZoneCLower = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty pointZoneCUpper = new NumericProperty((PropertyContainer)this, true);
    public final ColorProperty limitFillColor = new ColorProperty((PropertyContainer)this, true);
    public final BooleanProperty limitFillOn = new BooleanProperty((PropertyContainer)this, true);
    public final ColorProperty uclLineColor = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty ctlLineColor = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty lclLineColor = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty zoneAFillColor = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty zoneBFillColor = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty zoneCFillColor = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty zoneALineColor = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty zoneBLineColor = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty zoneCLineColor = new ColorProperty((PropertyContainer)this, true);
    public NumericProperty uclLineWidth = new NumericProperty((PropertyContainer)this, true);
    public IntegerProperty uclLinePattern = new IntegerProperty((PropertyContainer)this, true);
    public NumericProperty ctlLineWidth = new NumericProperty((PropertyContainer)this, true);
    public IntegerProperty ctlLinePattern = new IntegerProperty((PropertyContainer)this, true);
    public NumericProperty lclLineWidth = new NumericProperty((PropertyContainer)this, true);
    public IntegerProperty lclLinePattern = new IntegerProperty((PropertyContainer)this, true);
    public NumericProperty zoneALineWidth = new NumericProperty((PropertyContainer)this, true);
    public IntegerProperty zoneALinePattern = new IntegerProperty((PropertyContainer)this, true);
    public NumericProperty zoneBLineWidth = new NumericProperty((PropertyContainer)this, true);
    public IntegerProperty zoneBLinePattern = new IntegerProperty((PropertyContainer)this, true);
    public NumericProperty zoneCLineWidth = new NumericProperty((PropertyContainer)this, true);
    public IntegerProperty zoneCLinePattern = new IntegerProperty((PropertyContainer)this, true);
    public int igrpLower;
    public int igrpUpper;
    protected boolean SVGRender;

    public QCLimitsConnector() {
        super((ATransform)new Transform());
        this.multipleGroup = true;
        this.SVGRender = false;
    }

    public void setSVGRender(boolean SVG) {
        this.SVGRender = SVG;
    }

    public boolean isSVGRender() {
        return this.SVGRender;
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        this.beginPointX2 = Double.NaN;
        this.beginPointY2 = Double.NaN;
        this.endPointX = Double.NaN;
        this.endPointX2 = Double.NaN;
        this.endPointY = Double.NaN;
        this.endPointY2 = Double.NaN;
        this.phasePointX = Double.NaN;
        this.phasePointY = Double.NaN;
        this.phasePointZ = Double.NaN;
    }

    public void setFrame(BBox frame) {
        this.frame = frame;
    }

    public void setPhaseEntries(Vector<QCBlockOverlay.BlockEntry> entries) {
        this.phaseEntries = entries;
    }

    public void setPhaseFrames(BBox[] frames) {
        this.phaseFrames = frames;
    }

    public void setPhaseRefList(int[] refs) {
        this.refList = refs;
    }

    public void setLimitLineOn(int i, boolean b) {
        switch (i) {
            case 0: {
                this.uclLineOn.setValue(b);
                break;
            }
            case 2: {
                this.ctlLineOn.setValue(b);
                break;
            }
            case 1: {
                this.lclLineOn.setValue(b);
            }
        }
    }

    public void setPhaseLimitLabels(boolean on) {
        this.phaseLimitLabelsOn = on;
    }

    public void setZoneLabels(boolean on) {
        this.zoneLabelsOn = on;
    }

    public void setZoneValues(boolean on) {
        this.zoneValuesOn = on;
    }

    public void setZoneValuePosition(QCZone.ZoneValuePos pos) {
        this.zoneValuePosition = pos;
    }

    public void setPoints() {
        this.pointY = this.pointUCL;
        this.pointY2 = this.pointLCL;
        this.fillColor.connectFrom((ColorPipe)this.limitFillColor);
        this.fillOn.connectFrom((BooleanPipe)this.limitFillOn);
        this.currentPhase = -1;
        this.phaseLimitLabel = null;
    }

    public void setPoints(ZoneFill type) {
        this.currentPhase = -1;
        this.phaseLimitLabel = null;
        switch (type.ordinal()) {
            case 0: {
                this.pointY = this.pointUCL;
                this.pointY2 = this.pointZoneBUpper;
                this.fillColor.connectFrom((ColorPipe)this.zoneAFillColor);
                break;
            }
            case 1: {
                this.pointY = this.pointZoneBUpper;
                this.pointY2 = this.pointZoneCUpper;
                this.fillColor.connectFrom((ColorPipe)this.zoneBFillColor);
                break;
            }
            case 2: {
                this.pointY = this.pointZoneCUpper;
                this.pointY2 = this.pointCTL;
                this.fillColor.connectFrom((ColorPipe)this.zoneCFillColor);
                break;
            }
            case 3: {
                this.pointY = this.pointZoneCUpper;
                this.pointY2 = this.pointZoneCLower;
                this.fillColor.connectFrom((ColorPipe)this.zoneCFillColor);
                break;
            }
            case 4: {
                this.pointY = this.pointCTL;
                this.pointY2 = this.pointZoneCLower;
                this.fillColor.connectFrom((ColorPipe)this.zoneCFillColor);
                break;
            }
            case 5: {
                this.pointY = this.pointZoneCLower;
                this.pointY2 = this.pointZoneBLower;
                this.fillColor.connectFrom((ColorPipe)this.zoneBFillColor);
                break;
            }
            case 6: {
                this.pointY = this.pointZoneBLower;
                this.pointY2 = this.pointLCL;
                this.fillColor.connectFrom((ColorPipe)this.zoneAFillColor);
            }
        }
    }

    public NumericProperty[] getPoints(ZoneFill type) {
        NumericProperty[] points = new NumericProperty[2];
        switch (type.ordinal()) {
            case 0: {
                points[0] = this.pointUCL;
                points[1] = this.pointZoneBUpper;
                break;
            }
            case 1: {
                points[0] = this.pointZoneBUpper;
                points[1] = this.pointZoneCUpper;
                break;
            }
            case 2: {
                points[0] = this.pointZoneCUpper;
                points[1] = this.pointCTL;
                break;
            }
            case 3: {
                points[0] = this.pointZoneCUpper;
                points[1] = this.pointZoneCLower;
                break;
            }
            case 4: {
                points[0] = this.pointCTL;
                points[1] = this.pointZoneCLower;
                break;
            }
            case 5: {
                points[0] = this.pointZoneCLower;
                points[1] = this.pointZoneBLower;
                break;
            }
            case 6: {
                points[0] = this.pointZoneBLower;
                points[1] = this.pointLCL;
            }
        }
        return points;
    }

    public void set(LineType type) {
        this.type = type;
        this.lineBreak = false;
        this.currentPhase = -1;
        this.phaseLimitLabel = null;
        switch (type.ordinal()) {
            case 0: {
                this.pointY = this.pointUCL;
                if (this.phaseUCLCoord == null) {
                    this.phaseUCLCoord = new Vector();
                } else {
                    this.phaseUCLCoord.clear();
                }
                this.phaseLimitCoord = this.phaseUCLCoord;
                this.phaseLimitLabel = this.phaseUCL;
                this.color.connectFrom((ColorPipe)this.uclLineColor);
                this.linePattern.connectFrom((IntegerPipe)this.uclLinePattern);
                this.lineWidth.connectFrom((NumericPipe)this.uclLineWidth);
                break;
            }
            case 1: {
                this.phaseLimitCoord = this.phaseUCLCoord;
                this.phaseLimitLabel = this.phaseUCL;
                break;
            }
            case 2: {
                this.pointY = this.pointUCL;
                this.color.connectFrom((ColorPipe)this.zoneALineColor);
                this.linePattern.connectFrom((IntegerPipe)this.zoneALinePattern);
                this.lineWidth.connectFrom((NumericPipe)this.zoneALineWidth);
                break;
            }
            case 3: {
                this.pointY = this.pointZoneBUpper;
                this.color.connectFrom((ColorPipe)this.zoneBLineColor);
                this.linePattern.connectFrom((IntegerPipe)this.zoneBLinePattern);
                this.lineWidth.connectFrom((NumericPipe)this.zoneBLineWidth);
                break;
            }
            case 4: {
                this.pointY = this.pointZoneCUpper;
                this.color.connectFrom((ColorPipe)this.zoneCLineColor);
                this.linePattern.connectFrom((IntegerPipe)this.zoneCLinePattern);
                this.lineWidth.connectFrom((NumericPipe)this.zoneCLineWidth);
                break;
            }
            case 5: {
                this.pointY = this.pointCTL;
                if (this.phaseCTLCoord == null) {
                    this.phaseCTLCoord = new Vector();
                } else {
                    this.phaseCTLCoord.clear();
                }
                this.phaseLimitCoord = this.phaseCTLCoord;
                this.phaseLimitLabel = this.phaseCTL;
                this.lineBreak = true;
                this.color.connectFrom((ColorPipe)this.ctlLineColor);
                this.linePattern.connectFrom((IntegerPipe)this.ctlLinePattern);
                this.lineWidth.connectFrom((NumericPipe)this.ctlLineWidth);
                break;
            }
            case 6: {
                this.phaseLimitCoord = this.phaseCTLCoord;
                this.phaseLimitLabel = this.phaseCTL;
                break;
            }
            case 7: {
                this.pointY = this.pointZoneCLower;
                this.color.connectFrom((ColorPipe)this.zoneCLineColor);
                this.linePattern.connectFrom((IntegerPipe)this.zoneCLinePattern);
                this.lineWidth.connectFrom((NumericPipe)this.zoneCLineWidth);
                break;
            }
            case 8: {
                this.pointY = this.pointZoneBLower;
                this.color.connectFrom((ColorPipe)this.zoneBLineColor);
                this.linePattern.connectFrom((IntegerPipe)this.zoneBLinePattern);
                this.lineWidth.connectFrom((NumericPipe)this.zoneBLineWidth);
                break;
            }
            case 9: {
                this.pointY = this.pointLCL;
                this.color.connectFrom((ColorPipe)this.zoneALineColor);
                this.linePattern.connectFrom((IntegerPipe)this.zoneALinePattern);
                this.lineWidth.connectFrom((NumericPipe)this.zoneALineWidth);
                break;
            }
            case 10: {
                this.pointY = this.pointLCL;
                if (this.phaseLCLCoord == null) {
                    this.phaseLCLCoord = new Vector();
                } else {
                    this.phaseLCLCoord.clear();
                }
                this.phaseLimitCoord = this.phaseLCLCoord;
                this.phaseLimitLabel = this.phaseLCL;
                this.color.connectFrom((ColorPipe)this.lclLineColor);
                this.linePattern.connectFrom((IntegerPipe)this.lclLinePattern);
                this.lineWidth.connectFrom((NumericPipe)this.lclLineWidth);
                break;
            }
            case 11: {
                this.phaseLimitCoord = this.phaseLCLCoord;
                this.phaseLimitLabel = this.phaseLCL;
            }
        }
    }

    private boolean applyPhaseBoundary(Vector aBand) {
        int nRef;
        this.currentPhase = -1;
        int n = nRef = this.refList == null ? 0 : this.refList.length;
        if (nRef < 1 || this.phaseFrames == null) {
            if (this.frame == null) {
                return false;
            }
            this.extremeXMin = this.frame.getULX();
            this.extremeXMax = this.frame.getLRX();
            return true;
        }
        int iPhase = -1;
        int nPhase = this.phaseEntries.size();
        int nFrame = this.phaseFrames.length;
        int index = (Integer)aBand.elementAt(0);
        for (int i = 0; i < nPhase; ++i) {
            QCBlockOverlay.BlockEntry entry = this.phaseEntries.get(i);
            if (entry.first > index || index >= entry.last) continue;
            iPhase = i;
            break;
        }
        BBox[] phase = this.phaseFrames;
        if (iPhase == -1 || iPhase >= nPhase || phase[iPhase] == null) {
            this.extremeXMin = this.frame.getULX();
            this.extremeXMax = this.frame.getLRX();
            return false;
        }
        double ulx = phase[iPhase].getULX();
        double lrx = phase[iPhase].getLRX();
        this.extremeXMin = Math.max(ulx, this.frame.getULX());
        this.extremeXMax = Math.min(lrx, this.frame.getLRX());
        this.currentPhase = iPhase;
        return true;
    }

    private void drawFilled(ABuildAction buildAction, Vector aBand) {
        boolean drawInfill;
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel channel = ba.getChannel();
        ArrayList<Vec3d> upper = new ArrayList<Vec3d>();
        ArrayList<Vec3d> lower = new ArrayList<Vec3d>();
        int index = -1;
        boolean extend = true;
        int intersectionCount = aBand.size();
        int indexInit = this.stripMissing(aBand, true);
        int indexTerm = this.stripMissing(aBand, false);
        boolean empty = false;
        try {
            index = (Integer)aBand.elementAt(indexInit);
            empty = !this.fillOn.getValue(index);
        }
        catch (MissingValueException mve) {
            empty = true;
        }
        if (empty) {
            return;
        }
        if (indexInit > 0) {
            try {
                index = (Integer)aBand.elementAt(indexInit - 1);
                this.beginPointX = this.pointX.getValue(index);
                index = (Integer)aBand.elementAt(indexInit);
                this.beginPointX2 = this.beginPointX = (this.pointX.getValue(index) + this.beginPointX) / 2.0;
                this.beginPointY = this.pointY.getValue(index);
                this.beginPointY2 = this.pointY2.getValue(index);
                this.beginPointZ = this.pointZ.getValue(index);
            }
            catch (MissingValueException mve) {
                // empty catch block
            }
        }
        double adj = this.SVGRender ? 0.0 : 1.0;
        for (int j = indexInit; j < indexTerm && !this.outOfRangeMax; ++j) {
            index = (Integer)aBand.elementAt(j);
            if (index < this.igrpLower) continue;
            if (index == this.igrpUpper) {
                j = intersectionCount - 1;
            } else if (index > this.igrpUpper) break;
            if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointY2) || Double.isNaN(this.beginPointZ)) {
                try {
                    this.beginPointX2 = this.beginPointX = this.pointX.getValue(index);
                    this.beginPointY = this.pointY.getValue(index);
                    this.beginPointY2 = this.pointY2.getValue(index);
                    this.beginPointZ = this.pointZ.getValue(index);
                }
                catch (MissingValueException mve) {
                    continue;
                }
                if (!extend || !(this.beginPointX > this.extremeXMin) || indexInit != 0) continue;
                this.extendXMin = true;
            }
            try {
                this.endPointX2 = this.endPointX = this.pointX.getValue(index);
                this.endPointY = this.pointUCL.getValue(index);
                this.endPointY2 = this.pointLCL.getValue(index);
                this.endPointY = this.pointY.getValue(index);
                this.endPointY2 = this.pointY2.getValue(index);
                this.endPointZ = this.pointZ.getValue(index);
                if (this.endPointX < this.extremeXMin) continue;
                if (this.beginPointX < this.extremeXMin) {
                    this.outOfRangeMin = true;
                    this.beginPointX = this.beginPointX2 = this.extremeXMin;
                }
                if (this.endPointX > this.extremeXMax) {
                    this.outOfRangeMax = true;
                    this.endPointX = this.endPointX2 = Math.min(this.endPointX, this.extremeXMax);
                } else if (j == intersectionCount - 1) {
                    this.extendXMax = true;
                }
                this.addVertex((Action)ba, upper, lower, j >= indexTerm - 1);
                this.beginPointX = this.endPointX;
                this.beginPointX2 = this.endPointX2;
                this.beginPointY = this.endPointY;
                this.beginPointY2 = this.endPointY2;
                this.beginPointZ = this.endPointZ;
                this.outOfRangeMin = false;
                this.outOfRangeMax = false;
                continue;
            }
            catch (MissingValueException mve) {
                if (!this.skipMissing) continue;
                this.beginPointX = Double.NaN;
                this.beginPointX2 = Double.NaN;
                this.beginPointY = Double.NaN;
                this.beginPointY2 = Double.NaN;
            }
        }
        if (indexTerm < intersectionCount) {
            try {
                this.beginPointX = this.endPointX;
                this.beginPointX2 = this.endPointX2;
                this.beginPointY = this.endPointY;
                this.beginPointY2 = this.endPointY2;
                this.beginPointZ = this.endPointZ;
                index = (Integer)aBand.elementAt(indexTerm);
                this.endPointX2 = this.endPointX = (this.pointX.getValue(index) + this.beginPointX) / 2.0;
                this.addVertex((Action)ba, upper, lower);
            }
            catch (MissingValueException mve) {
                // empty catch block
            }
        }
        if (drawInfill = true) {
            int nLower;
            int nUpper = upper == null ? 0 : upper.size();
            int n = nLower = lower == null ? 0 : lower.size();
            if (nUpper > 0 || nLower > 0) {
                Vec3d v;
                int i;
                channel.glPolygonMode(3);
                channel.glBegin(2);
                channel.glNormal(0.0, 0.0, 1.0);
                for (i = nUpper - 1; i >= 0; --i) {
                    v = (Vec3d)upper.get(i);
                    channel.glVertex(v.x, v.y, v.z);
                }
                for (i = 0; i < nLower; ++i) {
                    v = (Vec3d)lower.get(i);
                    channel.glVertex(v.x, v.y, v.z);
                }
                channel.glEnd();
            }
        }
    }

    private int stripMissing(Vector aBand, boolean min) {
        int intersectionCount = aBand.size();
        int rc = min ? 0 : intersectionCount;
        boolean ignore = false;
        if (ignore) {
            return rc;
        }
        double ucl = Double.NaN;
        double lcl = Double.NaN;
        for (int i = 0; i < intersectionCount; ++i) {
            int k = min ? i : intersectionCount - (i + 1);
            int index = (Integer)aBand.elementAt(k);
            if (this.uclLineOn.getValue()) {
                try {
                    ucl = this.pointUCL.getValue(index);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            if (this.lclLineOn.getValue()) {
                try {
                    lcl = this.pointLCL.getValue(index);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            if (Double.isNaN(ucl) && Double.isNaN(lcl)) continue;
            rc = min ? k : k + 1;
            break;
        }
        return rc;
    }

    private void drawPolyline(ABuildAction buildAction, Vector aBand) {
        boolean debug;
        Channel channel;
        block54: {
            double z;
            double y2;
            double y1;
            double x2;
            double x1;
            BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
            channel = ba.getChannel();
            double rightBeginPtX = -1.0;
            double rightBeginPtY = -1.0;
            double rightEndPtX = -1.0;
            double rightEndPtY = -1.0;
            double rightPtZ = Double.NaN;
            int index = -1;
            int intersectionCount = aBand.size();
            int indexInit = this.stripMissing(aBand, true);
            int indexTerm = this.stripMissing(aBand, false);
            if (indexTerm - indexInit <= 0) {
                // empty if block
            }
            boolean validPoint = false;
            boolean extraPoint = false;
            boolean extend = true;
            this.beginPointX = Double.NaN;
            this.beginPointY = Double.NaN;
            this.beginPointZ = Double.NaN;
            this.endPointX = Double.NaN;
            this.endPointY = Double.NaN;
            this.endPointZ = Double.NaN;
            double phaseLimitLabelX = Double.NaN;
            double phaseLimitLabelY = Double.NaN;
            double phaseLimitLabelZ = Double.NaN;
            boolean phaseLimitLabelXY = false;
            boolean rightPt = true;
            this.outOfRangeMin = false;
            this.outOfRangeMax = false;
            channel.glBegin(1);
            if (indexInit > 0) {
                try {
                    index = (Integer)aBand.elementAt(indexInit - 1);
                    this.beginPointX = this.pointX.getValue(index);
                    index = (Integer)aBand.elementAt(indexInit);
                    this.endPointX = this.pointX.getValue(index);
                    this.beginPointX = (this.beginPointX + this.endPointX) / 2.0;
                    this.beginPointY = this.pointY.getValue(index);
                    this.beginPointZ = this.pointZ.getValue(index);
                    x1 = this.beginPointX;
                    x2 = this.endPointX;
                    y1 = this.beginPointY;
                    y2 = this.beginPointY;
                    z = this.beginPointZ;
                    channel.glVertex(x1, y1, z);
                    channel.glVertex(x2, y2, z);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            boolean degenerate = true;
            for (int j = indexInit; (j < indexTerm || extraPoint) && !this.outOfRangeMax; ++j) {
                if (!extraPoint) {
                    index = (Integer)aBand.elementAt(j);
                    if (index < this.igrpLower) continue;
                    if (index > this.igrpUpper) {
                        if (!(this.endPointX < this.extremeXMax)) break;
                        rightPt = false;
                        rightBeginPtX = this.endPointX;
                        rightBeginPtY = this.endPointY;
                        rightPtZ = this.endPointZ;
                        rightEndPtX = this.extremeXMax;
                        rightEndPtY = this.endPointY;
                        break;
                    }
                }
                degenerate = false;
                if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointZ)) {
                    try {
                        this.beginPointX = this.pointX.getValue(index);
                        this.beginPointY = this.pointY.getValue(index);
                        this.beginPointZ = this.pointZ.getValue(index);
                        phaseLimitLabelX = this.beginPointX;
                        phaseLimitLabelY = this.beginPointY;
                        phaseLimitLabelZ = this.beginPointZ;
                        phaseLimitLabelXY = true;
                    }
                    catch (MissingValueException mve) {
                        continue;
                    }
                    if (!extend || !(this.beginPointX > this.extremeXMin) || indexInit != 0) continue;
                    extraPoint = true;
                    extend = false;
                    if (!(Double.isNaN(this.phasePointX) || Double.isNaN(this.phasePointY) || Double.isNaN(this.phasePointZ))) {
                        x1 = this.phasePointX;
                        y1 = this.phasePointY;
                        z = this.phasePointZ;
                        if (!this.lineBreak) {
                            channel.glVertex(x1, y1, z);
                        }
                        this.phasePointX = Double.NaN;
                        this.phasePointY = Double.NaN;
                        this.phasePointZ = Double.NaN;
                        this.extremeXMin = x1;
                    }
                    this.endPointX = this.beginPointX;
                    this.endPointY = this.beginPointY;
                    this.endPointZ = this.beginPointZ;
                    phaseLimitLabelX = this.beginPointX = this.extremeXMin;
                }
                rightPt = false;
                try {
                    if (!extraPoint) {
                        this.endPointX = this.pointX.getValue(index);
                        this.endPointY = this.pointY.getValue(index);
                        this.endPointZ = this.pointZ.getValue(index);
                    } else {
                        extraPoint = false;
                    }
                    if (this.endPointX < this.extremeXMin) continue;
                    if (this.beginPointX <= this.extremeXMin) {
                        this.outOfRangeMin = true;
                        this.beginPointX = this.extremeXMin;
                        this.beginPointY = this.endPointY;
                    }
                    if (this.endPointX >= this.extremeXMax) {
                        rightPt = true;
                        this.outOfRangeMax = true;
                        this.endPointX = Math.min(this.endPointX, this.extremeXMax);
                        this.endPointY = this.beginPointY;
                    } else if (this.endPointX <= this.extremeXMax && j == intersectionCount - 1) {
                        rightPt = true;
                        extraPoint = true;
                    }
                    rightBeginPtX = this.beginPointX;
                    rightBeginPtY = this.beginPointY;
                    rightEndPtX = this.endPointX;
                    rightEndPtY = this.endPointY;
                    rightPtZ = this.beginPointZ;
                    x1 = this.beginPointX;
                    x2 = this.endPointX;
                    y1 = this.beginPointY;
                    y2 = this.endPointY;
                    z = this.beginPointZ;
                    validPoint = true;
                    if (this.outOfRangeMin) {
                        channel.glVertex(x1, y1, z);
                        channel.glVertex(x2, y2, z);
                    } else if (this.outOfRangeMax) {
                        this.endPointY = rightEndPtY;
                        channel.glVertex(x1, y1, z);
                        channel.glVertex(x2, y2, z);
                    } else {
                        channel.glVertex(x1, y1, z);
                        if (y1 != y2) {
                            double cx = (x1 + x2) * 0.5;
                            channel.glVertex(cx, y1, z);
                            if (this.lineBreak) {
                                channel.glEnd();
                                channel.glBegin(1);
                            }
                            channel.glVertex(cx, y2, z);
                        }
                        channel.glVertex(x2, y2, z);
                    }
                    this.outOfRangeMin = false;
                    this.outOfRangeMax = false;
                    this.beginPointX = this.endPointX;
                    this.beginPointY = this.endPointY;
                    this.beginPointZ = this.endPointZ;
                    if (!extraPoint) continue;
                    this.endPointX = this.extremeXMax;
                    this.endPointY = this.beginPointY;
                    this.endPointZ = this.beginPointZ;
                    continue;
                }
                catch (MissingValueException mve) {
                    rightBeginPtX = this.beginPointX;
                    rightBeginPtX = (this.beginPointX + this.endPointX) / 2.0;
                    rightBeginPtY = this.beginPointY;
                    rightEndPtX = this.extremeXMax;
                    rightEndPtY = this.beginPointY;
                    rightPtZ = this.beginPointZ;
                    if (!this.skipMissing) continue;
                    channel.glVertex(rightBeginPtX, rightBeginPtY, rightPtZ);
                    if (index + 1 < indexTerm) {
                        try {
                            double nextX = this.pointX.getValue(index + 1);
                            double nextY = this.pointY.getValue(index + 1);
                            double nextZ = this.pointZ.getValue(index + 1);
                            this.beginPointX = (this.endPointX + nextX) / 2.0;
                            this.beginPointY = nextY;
                            this.beginPointZ = nextZ;
                        }
                        catch (MissingValueException mve2) {
                            this.beginPointX = this.endPointX;
                            this.beginPointY = this.endPointY;
                            this.beginPointZ = this.endPointZ;
                        }
                    } else {
                        this.beginPointX = Double.NaN;
                        this.beginPointY = Double.NaN;
                        this.beginPointZ = Double.NaN;
                    }
                    channel.glEnd();
                    channel.glBegin(1);
                }
            }
            if (degenerate) {
                try {
                    index = (Integer)aBand.elementAt(indexInit);
                    x1 = this.extremeXMin;
                    x2 = this.extremeXMax;
                    y2 = y1 = this.pointY.getValue(index);
                    z = this.pointZ.getValue(index);
                    channel.glVertex(x1, y1, z);
                    channel.glVertex(x2, y2, z);
                    rightEndPtX = x2;
                    phaseLimitLabelX = x1;
                    phaseLimitLabelY = y1;
                    phaseLimitLabelZ = z;
                    phaseLimitLabelXY = true;
                }
                catch (MissingValueException mve) {}
            } else if (indexTerm < intersectionCount) {
                try {
                    this.beginPointX = this.endPointX;
                    index = (Integer)aBand.elementAt(indexTerm);
                    this.endPointX = (this.pointX.getValue(index) + this.beginPointX) / 2.0;
                    x1 = this.beginPointX;
                    x2 = this.endPointX;
                    y1 = this.endPointY;
                    y2 = this.endPointY;
                    z = this.endPointZ;
                    channel.glVertex(x1, y1, z);
                    channel.glVertex(x2, y2, z);
                }
                catch (MissingValueException mve) {}
            } else {
                if (!rightPt) {
                    channel.glVertex(rightBeginPtX, rightBeginPtY, rightPtZ);
                    channel.glVertex(rightEndPtX, rightEndPtY, rightPtZ);
                }
                if (!validPoint) {
                    this.phasePointX = Double.NaN;
                    this.phasePointY = Double.NaN;
                    this.phasePointZ = Double.NaN;
                } else if (!this.lineBreak) {
                    this.phasePointX = this.extremeXMax;
                    this.phasePointY = this.endPointY;
                    this.phasePointZ = this.endPointZ;
                }
            }
            channel.glEnd();
            if (this.phaseLimitLabel != null) {
                if (phaseLimitLabelXY) {
                    try {
                        double y;
                        String str = this.phaseLimitLabel.string.getValue(this.currentPhase);
                        if (str == null || str.length() <= 0) break block54;
                        int offset = QCMargins.getBlockX();
                        int width = (int)channel.glGetTextWidth(str);
                        int height = (int)(0.75 * channel.glGetTextAscent());
                        double uly = this.frame.getULY();
                        double ulx = this.frame.getULX();
                        double lry = this.frame.getLRY();
                        double lrx = this.frame.getLRX();
                        double x = phaseLimitLabelX + (double)offset;
                        if (rightEndPtX - x < (double)width) {
                            this.phaseLimitCoord.add(null);
                            break block54;
                        }
                        switch (this.type.ordinal()) {
                            case 0: {
                                y = phaseLimitLabelY + (double)offset;
                                if (!(y + (double)height > lry)) break;
                                y = phaseLimitLabelY - (double)(height + offset);
                                break;
                            }
                            case 5: {
                                y = phaseLimitLabelY + (double)offset;
                                break;
                            }
                            case 10: {
                                y = phaseLimitLabelY - (double)(height + offset);
                                if (!(y < uly)) break;
                                y = phaseLimitLabelY + (double)offset;
                                break;
                            }
                            default: {
                                y = phaseLimitLabelY + (double)offset;
                            }
                        }
                        this.phaseLimitCoord.add(new PhaseLabel(x, y, phaseLimitLabelZ, str));
                    }
                    catch (MissingValueException mve) {
                        this.phaseLimitCoord.add(null);
                    }
                } else {
                    this.phaseLimitCoord.add(null);
                }
            }
        }
        if ((debug = false) && this.currentPhase > 0) {
            channel.glPolygonMode(2);
            channel.glBegin(1);
            channel.glLineWidth(1.0f);
            channel.glColor(Color.RED);
            channel.glVertex(this.extremeXMin, this.frame.getULY(), this.phasePointZ);
            channel.glVertex(this.extremeXMin, this.frame.getLRY(), this.phasePointZ);
            channel.glEnd();
            channel.glLineWidth(this.myLineWidth);
            channel.glColor(this.myColor);
        }
    }

    protected void addVertex(Action action, ArrayList<Vec3d> upper, ArrayList<Vec3d> lower, boolean lastPoint) {
        if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointX2) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointY2) || Double.isNaN(this.beginPointZ) || Double.isNaN(this.endPointX) || Double.isNaN(this.endPointX2) || Double.isNaN(this.endPointY) || Double.isNaN(this.endPointY2) || Double.isNaN(this.endPointZ)) {
            return;
        }
        Vec3d v1 = new Vec3d();
        Vec3d v2 = new Vec3d();
        Vec3d v3 = new Vec3d();
        Vec3d v4 = new Vec3d();
        boolean equalY = false;
        boolean equalY2 = false;
        if (this.outOfRangeMin) {
            this.beginPointY = this.endPointY;
            this.beginPointY2 = this.endPointY2;
            if (this.extendXMax) {
                this.endPointX = this.extremeXMax;
                this.endPointX2 = this.extremeXMax;
                this.extendXMax = false;
            }
            v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
            v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
            v3.set(this.endPointX2, this.endPointY2, this.endPointZ);
            v4.set(this.endPointX, this.endPointY, this.endPointZ);
            upper.add(v1);
            lower.add(v2);
            lower.add(v3);
            upper.add(v4);
        } else if (this.outOfRangeMax) {
            this.endPointY = this.beginPointY;
            this.endPointY2 = this.beginPointY2;
            if (this.extendXMin) {
                this.beginPointX = this.extremeXMin;
                this.beginPointX2 = this.extremeXMin;
                this.extendXMin = false;
            }
            v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
            v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
            v3.set(this.endPointX2, this.endPointY2, this.endPointZ);
            v4.set(this.endPointX, this.endPointY, this.endPointZ);
            upper.add(v1);
            lower.add(v2);
            lower.add(v3);
            upper.add(v4);
        } else {
            boolean debugClippingAreas;
            Vec3d v5 = new Vec3d();
            Vec3d v6 = new Vec3d();
            Vec3d v7 = new Vec3d();
            Vec3d v8 = new Vec3d();
            equalY = Math.abs(this.beginPointY - this.endPointY) < 1.0E-6;
            equalY2 = Math.abs(this.beginPointY2 - this.endPointY2) < 1.0E-6;
            equalY = false;
            equalY2 = false;
            if (!equalY || equalY2) {
                // empty if block
            }
            double cx = (this.beginPointX + this.endPointX) * 0.5;
            double cx2 = (this.beginPointX2 + this.endPointX2) * 0.5;
            if (this.extendXMin) {
                this.beginPointX = this.extremeXMin;
                this.beginPointX2 = this.extremeXMin;
                this.extendXMin = false;
            }
            if (this.extendXMax) {
                this.endPointX = this.extremeXMax;
                this.endPointX2 = this.extremeXMax;
                this.extendXMax = false;
            }
            v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
            v2.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
            v3.set(cx2, this.beginPointY2, this.beginPointZ);
            v4.set(cx, this.beginPointY, this.beginPointZ);
            v5.set(cx, this.endPointY, this.beginPointZ);
            v6.set(cx2, this.endPointY2, this.beginPointZ);
            v7.set(this.endPointX2, this.endPointY2, this.endPointZ);
            v8.set(this.endPointX, this.endPointY, this.endPointZ);
            upper.add(v1);
            lower.add(v2);
            lower.add(v3);
            upper.add(v4);
            upper.add(v5);
            lower.add(v6);
            if (lastPoint) {
                lower.add(v7);
                upper.add(v8);
            }
            if (debugClippingAreas = false) {
                float lry;
                float lrx;
                float uly;
                float ulx;
                boolean debug = true;
                Channel channel = (Channel)action.getGraphicsContext();
                if (equalY) {
                    ulx = (float)this.beginPointX;
                    uly = (float)this.frame.getLRY();
                    lrx = (float)this.endPointX;
                    lry = (float)this.beginPointY;
                    if (debug) {
                        channel.glColor(Color.LIGHT_GRAY);
                        channel.glRect((double)ulx, (double)uly, (double)lrx, (double)lry);
                    }
                } else {
                    ulx = (float)this.beginPointX;
                    uly = (float)this.frame.getLRY();
                    lrx = (float)cx;
                    lry = (float)this.beginPointY;
                    if (debug) {
                        channel.glColor(Color.RED);
                        channel.glRect((double)ulx, (double)uly, (double)lrx, (double)lry);
                    }
                    ulx = (float)cx;
                    uly = (float)this.frame.getLRY();
                    lrx = (float)this.endPointX;
                    lry = (float)this.endPointY;
                    if (debug) {
                        channel.glColor(Color.GREEN);
                        channel.glRect((double)ulx, (double)uly, (double)lrx, (double)lry);
                    }
                }
                if (equalY2) {
                    ulx = (float)this.beginPointX2;
                    uly = (float)this.beginPointY2;
                    lrx = (float)this.endPointX2;
                    lry = (float)this.frame.getULY();
                    if (debug) {
                        channel.glColor(Color.MAGENTA);
                        channel.glRect((double)ulx, (double)uly, (double)lrx, (double)lry);
                    }
                } else {
                    ulx = (float)this.beginPointX2;
                    uly = (float)this.beginPointY2;
                    lrx = (float)cx;
                    lry = (float)this.frame.getULY();
                    if (debug) {
                        channel.glColor(Color.GREEN);
                        channel.glRect((double)ulx, (double)uly, (double)lrx, (double)lry);
                    }
                    ulx = (float)cx;
                    uly = (float)this.endPointY2;
                    lrx = (float)this.endPointX2;
                    lry = (float)this.frame.getULY();
                    if (debug) {
                        channel.glColor(Color.YELLOW);
                        channel.glRect((double)ulx, (double)uly, (double)lrx, (double)lry);
                    }
                }
                if (equalY && equalY2) {
                    ulx = (float)this.beginPointX;
                    uly = (float)this.beginPointY;
                    lrx = (float)this.endPointX2;
                    lry = (float)this.endPointY2;
                    if (debug) {
                        channel.glColor(Color.DARK_GRAY);
                        channel.glRect((double)ulx, (double)uly, (double)lrx, (double)lry);
                    }
                } else {
                    ulx = (float)this.beginPointX;
                    uly = (float)this.beginPointY;
                    lrx = (float)cx;
                    lry = (float)this.beginPointY2;
                    if (debug) {
                        channel.glColor(Color.PINK);
                        channel.glRect((double)ulx, (double)uly, (double)lrx, (double)lry);
                    }
                    ulx = (float)cx;
                    uly = (float)this.endPointY;
                    lrx = (float)this.endPointX2;
                    lry = (float)this.endPointY2;
                    if (debug) {
                        channel.glColor(Color.CYAN);
                        channel.glRect((double)ulx, (double)uly, (double)lrx, (double)lry);
                    }
                }
                if (debug) {
                    channel.glColor(this.myFillColor);
                }
            }
        }
    }

    protected void addVertex(Action action, ArrayList<Vec3d> upper, ArrayList<Vec3d> lower) {
        if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointX2) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointY2) || Double.isNaN(this.beginPointZ) || Double.isNaN(this.endPointX) || Double.isNaN(this.endPointX2) || Double.isNaN(this.endPointY) || Double.isNaN(this.endPointY2) || Double.isNaN(this.endPointZ)) {
            return;
        }
        Vec3d v1 = new Vec3d();
        Vec3d v2 = new Vec3d();
        Vec3d v3 = new Vec3d();
        Vec3d v4 = new Vec3d();
        v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
        v2.set(this.endPointX, this.endPointY, this.endPointZ);
        upper.add(v1);
        upper.add(v2);
        v3.set(this.beginPointX2, this.beginPointY2, this.beginPointZ);
        v4.set(this.endPointX2, this.endPointY2, this.endPointZ);
        lower.add(v3);
        lower.add(v4);
    }

    public static void drawConstantBand(Channel channel, double beginX, double endX, double beginZ, double upperY, double lowerY, boolean joinOn, Color color, double lineWidth, int stipplePat, int stippleFac, boolean fillOn, Color fillColor) {
        if (fillOn) {
            channel.glColor(fillColor);
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            channel.glVertex(beginX, upperY, beginZ);
            channel.glVertex(beginX, lowerY, beginZ);
            channel.glVertex(endX, lowerY, beginZ);
            channel.glVertex(endX, upperY, beginZ);
            channel.glEnd();
        }
        if (stippleFac > 0) {
            channel.glEnable(6);
            channel.glLineStipple(stippleFac, (int)((short)stipplePat));
        }
        channel.glLineWidth((float)lineWidth);
        channel.glColor(color);
        channel.glBegin(1);
        channel.glVertex((double)((float)beginX), (double)((float)upperY), (double)((float)beginZ));
        channel.glVertex((double)((float)endX), (double)((float)upperY), (double)((float)beginZ));
        channel.glEnd();
        channel.glBegin(1);
        channel.glVertex((double)((float)beginX), (double)((float)lowerY), (double)((float)beginZ));
        channel.glVertex((double)((float)endX), (double)((float)lowerY), (double)((float)beginZ));
        channel.glEnd();
        channel.glLineWidth(1.0f);
        if (stippleFac > 0) {
            channel.glDisable(6);
        }
    }

    protected void renderPolylineGroup(ABuildAction buildAction, FilledLineConnector.PolylineGroup group, boolean fillOn) {
        int polyLineCount = group.getPolylineCount();
        if (polyLineCount <= 0) {
            return;
        }
        this.stipplePattern = group.getStipplePattern();
        this.stippleFactor = group.getStippleFactor();
        this.myLineWidth = (float)group.getLineWidth();
        this.myColor = group.getLineColor();
        this.myFillColor = group.getFillColor();
        for (int i = 0; i < polyLineCount; ++i) {
            Vector band = group.getPolyline(i);
            if (band == null) continue;
            this.beginPointX2 = Double.NaN;
            this.beginPointY2 = Double.NaN;
            this.outOfRangeMin = false;
            this.outOfRangeMax = false;
            int intersectionCount = band.size();
            if (intersectionCount < 1 || !this.applyPhaseBoundary(band)) continue;
            if (fillOn) {
                this.drawFilled(buildAction, band);
                continue;
            }
            this.drawPolyline(buildAction, band);
        }
    }

    private void drawZoneLabels(ABuildAction buildAction) {
        double x;
        double y;
        double d2;
        double d;
        double width;
        String str;
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel channel = ba.getChannel();
        double xLabel = 0.0;
        double xValue = 0.0;
        double z = 0.0;
        NumericProperty[] points = this.getPoints(ZoneFill.ZONE_A_UPPER);
        if (this.zoneLabelsOn) {
            xLabel = this.frame.getULX() + (double)QCMargins.getDefaultX();
            if (this.zoneValuesOn) {
                switch (this.zoneValuePosition) {
                    default: {
                        str = this.zoneALabel.string.getValue();
                        width = channel.glGetTextWidth(str);
                        str = this.zoneBLabel.string.getValue();
                        width = Math.max(channel.glGetTextWidth(str), width);
                        str = this.zoneCLabel.string.getValue();
                        width = Math.max(channel.glGetTextWidth(str), width);
                        xValue = xLabel + width;
                        xValue += (double)QCMargins.getDefaultX();
                        break;
                    }
                    case INNER_RIGHT: {
                        xValue = this.frame.getLRX() - (double)QCMargins.getDefaultX();
                        break;
                    }
                    case OUTER_RIGHT: {
                        xValue = this.frame.getLRX() + (double)QCMargins.getDefaultX();
                        break;
                    }
                }
            }
        } else {
            switch (this.zoneValuePosition) {
                default: {
                    xValue = this.frame.getULX() + (double)QCMargins.getDefaultX();
                    break;
                }
                case INNER_RIGHT: {
                    xValue = this.frame.getLRX() - (double)QCMargins.getDefaultX();
                    break;
                }
                case OUTER_RIGHT: {
                    xValue = this.frame.getLRX() + (double)QCMargins.getDefaultX();
                }
            }
        }
        Bbox bbox = new Bbox();
        double height = 0.0;
        boolean draw = true;
        if (points[0] != null && points[1] != null) {
            try {
                str = this.zoneLabelsOn ? this.zoneALabel.string.getValue() : (this.zoneValuesOn ? this.zoneAUpper.string.getValue() : " ");
                channel.glGetText2DBbox(str, 0.0, 0.0, 0.0, 0, bbox);
                d = points[0].getValue(0);
                d2 = points[1].getValue(0);
                height = bbox.ymax;
                boolean bl = draw = Math.abs(d - d2) >= height;
                if (draw) {
                    y = (d + d2 - height) / 2.0;
                    if (this.zoneLabelsOn) {
                        this.zoneALabel.coordX.setValue(xLabel);
                        this.zoneALabel.coordY.setValue(y);
                        this.zoneALabel.coordZ.setValue(z);
                        this.zoneALabel.render((ABuildAction)ba);
                    }
                    if (this.zoneValuesOn) {
                        x = xValue;
                        if (this.zoneValuePosition == QCZone.ZoneValuePos.INNER_RIGHT) {
                            str = this.zoneAUpper.string.getValue();
                            width = channel.glGetTextWidth(str);
                            x = xValue - width;
                        }
                        this.zoneAUpper.coordX.setValue(x);
                        this.zoneAUpper.coordY.setValue(y);
                        this.zoneAUpper.coordZ.setValue(z);
                        this.zoneAUpper.render((ABuildAction)ba);
                    }
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if ((points = this.getPoints(ZoneFill.ZONE_B_UPPER))[0] != null && points[1] != null) {
            try {
                str = this.zoneLabelsOn ? this.zoneBLabel.string.getValue() : (this.zoneValuesOn ? this.zoneBUpper.string.getValue() : " ");
                channel.glGetText2DBbox(str, 0.0, 0.0, 0.0, 0, bbox);
                d = points[0].getValue(0);
                d2 = points[1].getValue(0);
                height = bbox.ymax;
                boolean bl = draw = Math.abs(d - d2) >= height;
                if (draw) {
                    y = (d + d2 - height) / 2.0;
                    if (this.zoneLabelsOn) {
                        this.zoneBLabel.coordX.setValue(xLabel);
                        this.zoneBLabel.coordY.setValue(y);
                        this.zoneBLabel.coordZ.setValue(z);
                        this.zoneBLabel.render((ABuildAction)ba);
                    }
                    if (this.zoneValuesOn) {
                        x = xValue;
                        if (this.zoneValuePosition == QCZone.ZoneValuePos.INNER_RIGHT) {
                            str = this.zoneBUpper.string.getValue();
                            width = channel.glGetTextWidth(str);
                            x = xValue - width;
                        }
                        this.zoneBUpper.coordX.setValue(x);
                        this.zoneBUpper.coordY.setValue(y);
                        this.zoneBUpper.coordZ.setValue(z);
                        this.zoneBUpper.render((ABuildAction)ba);
                    }
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if ((points = this.getPoints(ZoneFill.ZONE_C_UPPER))[0] != null && points[1] != null) {
            try {
                str = this.zoneLabelsOn ? this.zoneCLabel.string.getValue() : (this.zoneValuesOn ? this.zoneCUpper.string.getValue() : " ");
                channel.glGetText2DBbox(str, 0.0, 0.0, 0.0, 0, bbox);
                d = points[0].getValue(0);
                d2 = points[1].getValue(0);
                height = bbox.ymax;
                boolean bl = draw = Math.abs(d - d2) >= height;
                if (draw) {
                    y = (d + d2 - height) / 2.0;
                    if (this.zoneLabelsOn) {
                        this.zoneCLabel.coordX.setValue(xLabel);
                        this.zoneCLabel.coordY.setValue(y);
                        this.zoneCLabel.coordZ.setValue(z);
                        this.zoneCLabel.render((ABuildAction)ba);
                    }
                    if (this.zoneValuesOn) {
                        x = xValue;
                        if (this.zoneValuePosition == QCZone.ZoneValuePos.INNER_RIGHT) {
                            str = this.zoneCUpper.string.getValue();
                            width = channel.glGetTextWidth(str);
                            x = xValue - width;
                        }
                        this.zoneCUpper.coordX.setValue(x);
                        this.zoneCUpper.coordY.setValue(y);
                        this.zoneCUpper.coordZ.setValue(z);
                        this.zoneCUpper.render((ABuildAction)ba);
                    }
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if ((points = this.getPoints(ZoneFill.ZONE_C_LOWER))[0] != null && points[1] != null) {
            try {
                str = this.zoneLabelsOn ? this.zoneCLabel.string.getValue() : (this.zoneValuesOn ? this.zoneCUpper.string.getValue() : " ");
                channel.glGetText2DBbox(str, 0.0, 0.0, 0.0, 0, bbox);
                d = points[0].getValue(0);
                d2 = points[1].getValue(0);
                height = bbox.ymax;
                boolean bl = draw = Math.abs(d - d2) >= height;
                if (draw) {
                    y = (d + d2 - height) / 2.0;
                    if (this.zoneLabelsOn) {
                        this.zoneCLabel.coordX.setValue(xLabel);
                        this.zoneCLabel.coordY.setValue(y);
                        this.zoneCLabel.coordZ.setValue(z);
                        this.zoneCLabel.render((ABuildAction)ba);
                    }
                    if (this.zoneValuesOn) {
                        x = xValue;
                        if (this.zoneValuePosition == QCZone.ZoneValuePos.INNER_RIGHT) {
                            str = this.zoneCLower.string.getValue();
                            width = channel.glGetTextWidth(str);
                            x = xValue - width;
                        }
                        this.zoneCLower.coordX.setValue(x);
                        this.zoneCLower.coordY.setValue(y);
                        this.zoneCLower.coordZ.setValue(z);
                        this.zoneCLower.render((ABuildAction)ba);
                    }
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if ((points = this.getPoints(ZoneFill.ZONE_B_LOWER))[0] != null && points[1] != null) {
            try {
                str = this.zoneLabelsOn ? this.zoneBLabel.string.getValue() : (this.zoneValuesOn ? this.zoneBUpper.string.getValue() : " ");
                channel.glGetText2DBbox(str, 0.0, 0.0, 0.0, 0, bbox);
                d = points[0].getValue(0);
                d2 = points[1].getValue(0);
                height = bbox.ymax;
                boolean bl = draw = Math.abs(d - d2) >= height;
                if (draw) {
                    y = (d + d2 - height) / 2.0;
                    if (this.zoneLabelsOn) {
                        this.zoneBLabel.coordX.setValue(xLabel);
                        this.zoneBLabel.coordY.setValue(y);
                        this.zoneBLabel.coordZ.setValue(z);
                        this.zoneBLabel.render((ABuildAction)ba);
                    }
                    if (this.zoneValuesOn) {
                        x = xValue;
                        if (this.zoneValuePosition == QCZone.ZoneValuePos.INNER_RIGHT) {
                            str = this.zoneBLower.string.getValue();
                            width = channel.glGetTextWidth(str);
                            x = xValue - width;
                        }
                        this.zoneBLower.coordX.setValue(x);
                        this.zoneBLower.coordY.setValue(y);
                        this.zoneBLower.coordZ.setValue(z);
                        this.zoneBLower.render((ABuildAction)ba);
                    }
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if ((points = this.getPoints(ZoneFill.ZONE_A_LOWER))[0] != null && points[1] != null) {
            try {
                str = this.zoneLabelsOn ? this.zoneALabel.string.getValue() : (this.zoneValuesOn ? this.zoneAUpper.string.getValue() : " ");
                channel.glGetText2DBbox(str, 0.0, 0.0, 0.0, 0, bbox);
                d = points[0].getValue(0);
                d2 = points[1].getValue(0);
                height = bbox.ymax;
                boolean bl = draw = Math.abs(d - d2) >= height;
                if (draw) {
                    y = (d + d2 - height) / 2.0;
                    if (this.zoneLabelsOn) {
                        this.zoneALabel.coordX.setValue(xLabel);
                        this.zoneALabel.coordY.setValue(y);
                        this.zoneALabel.coordZ.setValue(z);
                        this.zoneALabel.render((ABuildAction)ba);
                    }
                    if (this.zoneValuesOn) {
                        x = xValue;
                        if (this.zoneValuePosition == QCZone.ZoneValuePos.INNER_RIGHT) {
                            str = this.zoneALower.string.getValue();
                            width = channel.glGetTextWidth(str);
                            x = xValue - width;
                        }
                        this.zoneALower.coordX.setValue(x);
                        this.zoneALower.coordY.setValue(y);
                        this.zoneALower.coordZ.setValue(z);
                        this.zoneALower.render((ABuildAction)ba);
                    }
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    private void drawPhaseLimitLabels(ABuildAction buildAction) {
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel channel = ba.getChannel();
        if (!this.phaseLimitLabelsOn || this.phaseLimitLabel == null) {
            return;
        }
        QCStarLabel label = new QCStarLabel();
        Vector<PhaseLabel> v = this.phaseLimitCoord;
        int n = v.size();
        PhaseLabel pl = null;
        for (int i = 0; i < n; ++i) {
            String str;
            pl = v.get(i);
            if (pl == null || (str = pl.str) == null || str.length() == 0) continue;
            label.coordX.setValue(pl.x);
            label.coordY.setValue(pl.y);
            label.coordZ.setValue(pl.z);
            label.color.setValue(this.phaseLimitLabel.getColor());
            label.fontName.setValue(this.phaseLimitLabel.getFont().getName());
            label.fontSize.setValue(this.phaseLimitLabel.getFont().getSize());
            label.fontStyle.setValue(this.phaseLimitLabel.getFont().getStyle());
            label.string.setValue(str);
            try {
                label.render((ABuildAction)ba);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    public void render(ABuildAction buildAction) throws MissingValueException {
        boolean drawZoneLabels;
        boolean zoneValues = this.zoneValuesOn && (this.zoneValuePosition == QCZone.ZoneValuePos.INNER_LEFT || this.zoneValuePosition == QCZone.ZoneValuePos.INNER_RIGHT);
        boolean drawPhaseLimits = this.phaseLimitLabelsOn;
        boolean bl = drawZoneLabels = this.zoneLabelsOn || zoneValues;
        if (drawPhaseLimits) {
            this.drawPhaseLimitLabels(buildAction);
        } else if (drawZoneLabels) {
            this.drawZoneLabels(buildAction);
        } else {
            super.render(buildAction);
        }
    }

    public static enum ZoneFill {
        ZONE_A_UPPER,
        ZONE_B_UPPER,
        ZONE_C_UPPER,
        ZONE_C,
        ZONE_C_LOWER,
        ZONE_B_LOWER,
        ZONE_A_LOWER,
        DEFAULT;

    }

    public static enum LineType {
        UCL,
        PHASELIMITS_UCL,
        ZONE_A_UPPER,
        ZONE_B_UPPER,
        ZONE_C_UPPER,
        CTL,
        PHASELIMITS_CTL,
        ZONE_C_LOWER,
        ZONE_B_LOWER,
        ZONE_A_LOWER,
        LCL,
        PHASELIMITS_LCL;

    }

    private class PhaseLabel {
        double x;
        double y;
        double z;
        String str;

        public PhaseLabel(double x, double y, double z, String str) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.str = str;
        }
    }
}

