/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.gtk;

import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarDataModel;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarGraphModel;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarLabel;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.TextStyle;
import java.awt.Image;

public abstract class AQCStar
extends Element {
    public StarType type;
    public final ColorProperty color = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty outfillColor = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty outspokeColor = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty edgeColor = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty refColor = new ColorProperty((PropertyContainer)this, true);
    public final TextStyle labelStyle = new TextStyle();
    public final BooleanProperty edgeOn = new BooleanProperty((PropertyContainer)this, true);
    public final BooleanProperty spokesOn = new BooleanProperty((PropertyContainer)this, true);
    public final BooleanProperty fillOn = new BooleanProperty((PropertyContainer)this, true);
    public final BooleanProperty outfillOn = new BooleanProperty((PropertyContainer)this, true);
    public final BooleanProperty spokeOutOn = new BooleanProperty((PropertyContainer)this, false);
    public final BooleanProperty labelsOn = new BooleanProperty((PropertyContainer)this, true);
    public final BooleanProperty refsOn = new BooleanProperty((PropertyContainer)this, true);
    public final NumericProperty labelType = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty lineWidth = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty spokeWidth = new NumericProperty((PropertyContainer)this, true);
    public int stipplePattern;
    public int stippleFactor;
    public int oocstipplePattern;
    public int oocstippleFactor;
    protected double stippleScaleFactor = 1.0;
    protected Image skin = null;
    protected int skinType = 0;
    protected Image[] pixelBenderImages_box = null;
    protected Image[] pixelBenderImages_mean = null;
    protected float DPIScaleFactor = 1.0f;
    protected final NumericProperty xCenter = new NumericProperty((PropertyContainer)this, true);
    protected final NumericProperty yCenter = new NumericProperty((PropertyContainer)this, true);
    protected QCStarGraphModel graphModel = new QCStarGraphModel();
    protected QCStarDataModel dataModel = new QCStarDataModel();
    protected int igrpLower = -1;
    protected int igrpUpper = -1;

    public void setLowerSubgrpIndex(int i) {
        this.igrpLower = i;
    }

    public void setUpperSubgrpIndex(int i) {
        this.igrpUpper = i;
    }

    public int getLowerSubgrpIndex() {
        return this.igrpLower;
    }

    public int getUpperSubgrpIndex() {
        return this.igrpUpper;
    }

    public AQCStar(ATransform transform) {
        super(transform);
        this.graphModel.setDataModel(this.dataModel);
        this.dataModel.setGraphModel(this.graphModel);
        this.xCenter.setValue(0.0);
        this.yCenter.setValue(0.0);
        this.edgeOn.setValue(true);
        this.spokesOn.setValue(false);
        this.fillOn.setValue(false);
        this.labelType.setValue((double)QCStarLabel.StarLabel.toInteger(QCStarLabel.StarLabel.DEFAULT));
    }

    public void setStipple(int pattern, int factor) {
        this.stipplePattern = pattern;
        this.stippleFactor = factor;
    }

    public int getStipplePattern() {
        return this.stipplePattern;
    }

    public int getStippleFactor() {
        return this.stippleFactor;
    }

    public void setOOCStipple(int pattern, int factor) {
        this.oocstipplePattern = pattern;
        this.oocstippleFactor = factor;
    }

    public int getOOCStipplePattern() {
        return this.oocstipplePattern;
    }

    public int getOOCStippleFactor() {
        return this.oocstippleFactor;
    }

    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        double xo = this.xCenter.getValue(index);
        double yo = this.yCenter.getValue(index);
        double xrad = 10.0;
        double yrad = 10.0;
        size.set(xrad * 2.0, yrad * 2.0, 0.0);
        center.set(xo, yo, 0.0);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(center, size);
    }

    public QCStarGraphModel getGraphModel() {
        return this.graphModel;
    }

    public QCStarDataModel getDataModel() {
        return this.dataModel;
    }

    public void build() {
        this.dataModel.build();
        this.graphModel.build();
    }

    public void buildJ2D() {
        this.graphModel.buildJ2D();
    }

    public void setStarType(StarType i) {
        this.type = i;
    }

    public StarType getStarType() {
        return this.type;
    }

    public void setStartDegree(double d) {
        this.graphModel.startDegrees = d;
    }

    public void setUserRadius(double graphIn, double graphOut, double graphClip) {
        double radiusOut = 1.0;
        double radiusIn = this.type == StarType.CORONA ? radiusOut / 2.0 : radiusOut / 3.0;
        double radiusDif = radiusOut - radiusIn;
        double radiusMid = (radiusIn + radiusOut) / 2.0;
        double radiusClip = graphClip == -1.0 ? 2.0 * radiusOut : graphClip / graphOut;
        this.dataModel.setRadiusOuter(radiusOut);
        this.dataModel.setRadiusInner(radiusIn);
        this.dataModel.setRadiusDif(radiusDif);
        this.dataModel.setRadiusMid(radiusMid);
        this.dataModel.setRadiusClip(radiusClip);
        double graphDif = graphOut - graphIn;
        double graphMid = (graphOut + graphIn) / 2.0;
        if (graphClip == -1.0) {
            graphClip = 2.0 * graphOut;
        }
        this.graphModel.setRadiusOuter(graphOut);
        this.graphModel.setRadiusInner(graphIn);
        this.graphModel.setRadiusDif(graphDif);
        this.graphModel.setRadiusMid(graphMid);
        this.graphModel.setRadiusClip(graphClip);
    }

    public void setDefaultRadius(double radius) {
        this.dataModel.setRadiusOut(radius);
    }

    public double getDataRadius() {
        return this.dataModel.getRadius();
    }

    public void setDataRadiusInner(double d) {
        this.dataModel.setRadiusInner(d);
    }

    public double getDataRadiusInner() {
        return this.dataModel.getRadiusInner();
    }

    public void setDataRadiusOuter(double d) {
        this.dataModel.setRadiusOuter(d);
    }

    public double getDataRadiusOuter() {
        return this.dataModel.getRadiusOuter();
    }

    public void setDataRadiusClip(double d) {
        this.dataModel.setRadiusClip(d);
    }

    public double getDataRadiusClip() {
        return this.dataModel.getRadiusClip();
    }

    public void setGraphRadius(double radius) {
        this.graphModel.setRadiusOut(radius, -1.0);
    }

    public double getGraphRadius() {
        return this.graphModel.getRadius();
    }

    public void setGraphRadiusInner(double d) {
        this.graphModel.setRadiusInner(d);
    }

    public double getGraphRadiusInner() {
        return this.graphModel.getRadiusInner();
    }

    public void setGraphRadiusOuter(double d) {
        this.graphModel.setRadiusOuter(d);
    }

    public double getGraphRadiusOuter() {
        return this.graphModel.getRadiusOuter();
    }

    public void setGraphRadiusClip(double d) {
        this.graphModel.setRadiusClip(d);
    }

    public double getGraphRadiusClip() {
        return this.graphModel.getRadiusClip();
    }

    public void setStippleScaleFactor(double fac) {
        this.stippleScaleFactor = fac;
    }

    public double getStippleScaleFactor() {
        return this.stippleScaleFactor;
    }

    public void setSkin(Image newImage) {
        this.skin = newImage;
    }

    public Image getSkin() {
        return this.skin;
    }

    public void setSkinType(int t) {
        this.skinType = t;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setPixelBenderImages(Image[] newImages, int skinCategory) {
        if (skinCategory == 1 || skinCategory == 2) {
            this.pixelBenderImages_box = newImages;
        } else if (skinCategory == 4) {
            this.pixelBenderImages_mean = newImages;
        }
    }

    public Image[] getPixelBenderImages(int skinCategory) {
        if (skinCategory == 1 || skinCategory == 2) {
            return this.pixelBenderImages_box;
        }
        if (skinCategory == 4) {
            return this.pixelBenderImages_mean;
        }
        return null;
    }

    public void setDPIScaleFactor(float fac) {
        this.DPIScaleFactor = fac;
    }

    public float getDPIScaleFactor() {
        return this.DPIScaleFactor;
    }

    public double getRValue(double r) {
        return this.graphModel.getRValue(r);
    }

    public static enum StarType {
        POLYGON,
        SPOKE,
        RADIAL,
        WEDGE,
        CORONA,
        OFFSET,
        NONE,
        DEFAULT;


        public static boolean fill(StarType type) {
            boolean rc;
            switch (type.ordinal()) {
                case 1: {
                    rc = false;
                    break;
                }
                case 2: {
                    rc = false;
                    break;
                }
                case 3: {
                    rc = true;
                    break;
                }
                case 4: {
                    rc = true;
                    break;
                }
                case 5: {
                    rc = false;
                    break;
                }
                case 6: {
                    rc = false;
                    break;
                }
                default: {
                    rc = true;
                }
            }
            return rc;
        }

        public static boolean spokes(StarType type) {
            boolean rc;
            switch (type.ordinal()) {
                case 1: {
                    rc = true;
                    break;
                }
                case 2: {
                    rc = true;
                    break;
                }
                case 3: {
                    rc = true;
                    break;
                }
                case 4: {
                    rc = false;
                    break;
                }
                case 5: {
                    rc = false;
                    break;
                }
                case 6: {
                    rc = false;
                    break;
                }
                default: {
                    rc = false;
                }
            }
            return rc;
        }

        public static boolean edge(StarType type) {
            boolean rc;
            switch (type.ordinal()) {
                case 1: {
                    rc = false;
                    break;
                }
                case 2: {
                    rc = false;
                    break;
                }
                case 3: {
                    rc = true;
                    break;
                }
                case 4: {
                    rc = true;
                    break;
                }
                case 5: {
                    rc = true;
                    break;
                }
                case 6: {
                    rc = false;
                    break;
                }
                default: {
                    rc = true;
                }
            }
            return rc;
        }

        public static StarType fromInteger(int i) {
            return StarType.fromInteger(i, POLYGON);
        }

        public static StarType fromInteger(int i, StarType dflt) {
            StarType rc;
            switch (i) {
                case 0: {
                    rc = POLYGON;
                    break;
                }
                case 1: {
                    rc = SPOKE;
                    break;
                }
                case 2: {
                    rc = RADIAL;
                    break;
                }
                case 3: {
                    rc = WEDGE;
                    break;
                }
                case 4: {
                    rc = CORONA;
                    break;
                }
                case 5: {
                    rc = OFFSET;
                    break;
                }
                case 6: {
                    rc = NONE;
                    break;
                }
                default: {
                    rc = dflt;
                }
            }
            return rc;
        }

        public static int toInteger(StarType type) {
            int rc;
            switch (type.ordinal()) {
                case 0: {
                    rc = 0;
                    break;
                }
                case 1: {
                    rc = 1;
                    break;
                }
                case 2: {
                    rc = 2;
                    break;
                }
                case 3: {
                    rc = 3;
                    break;
                }
                case 4: {
                    rc = 4;
                    break;
                }
                case 5: {
                    rc = 5;
                    break;
                }
                case 6: {
                    rc = 6;
                    break;
                }
                default: {
                    rc = 7;
                }
            }
            return rc;
        }
    }

    public static enum StarLegend {
        NONE,
        CLOCK,
        CLOCK0,
        DEGREES,
        MJC,
        DEFAULT;


        public static StarLegend fromInteger(int i) {
            return StarLegend.fromInteger(i, NONE);
        }

        public static StarLegend fromInteger(int i, StarLegend dflt) {
            StarLegend rc;
            switch (i) {
                case 0: {
                    rc = NONE;
                    break;
                }
                case 1: {
                    rc = CLOCK;
                    break;
                }
                case 2: {
                    rc = CLOCK0;
                    break;
                }
                case 3: {
                    rc = DEGREES;
                    break;
                }
                case 4: {
                    rc = MJC;
                    break;
                }
                default: {
                    rc = dflt;
                }
            }
            return rc;
        }

        public static int toInteger(StarLegend type) {
            int rc;
            switch (type.ordinal()) {
                case 0: {
                    rc = 0;
                    break;
                }
                case 1: {
                    rc = 1;
                    break;
                }
                case 2: {
                    rc = 2;
                    break;
                }
                case 3: {
                    rc = 3;
                    break;
                }
                case 4: {
                    rc = 4;
                    break;
                }
                default: {
                    rc = 5;
                }
            }
            return rc;
        }
    }
}

