/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.composite;

import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.QCShewhartChart;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBlockOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBoxParmOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCLimitsOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCPhaseBoxOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCReferenceLineOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCScatterOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCVaryLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectGridLines;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.CurveLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.CurveLabelLayoutManager;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayoutManager;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ReferenceLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.gl.LineSegment;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class QCSimple2DOverlayComposite
extends Simple2DOverlayComposite {
    protected QCShewhartChart chart = new QCShewhartChart();
    private boolean origin_px;
    private boolean origin_py;
    private boolean origin_sx;
    private boolean origin_sy;
    private boolean debugOutFill = false;
    private boolean debugOutLine = false;
    boolean CLOverlappingChecked = false;
    boolean xCLOverlapped = false;
    boolean x2CLOverlapped = false;
    boolean curveLabelSplit = false;

    private boolean isPrimariablePlot(Overlay overlay) {
        return !(overlay instanceof QCLimitsOverlay) && !(overlay instanceof QCBlockOverlay) && !(overlay instanceof QCReferenceLineOverlay) && !(overlay instanceof ReferenceLineOverlay);
    }

    public QCShewhartChart getChart() {
        return this.chart;
    }

    public synchronized void drawParts(Graphics g) {
        QCShewhart.setGraphics2D((Graphics2D)g);
        QCShewhart.setCurrentChart(this.chart);
        this.drawQCParts(g);
    }

    private synchronized void drawTransparentParts(Graphics g, int xorigin, int yorigin, boolean blockRefFill) {
        boolean phaseBoxConnect;
        QCOverlay qc2 = null;
        QCShewhartChart chart = QCShewhart.getCurrentChart();
        QCBlockOverlay blockRef = blockRefFill ? chart.getBlockOverlay(QCBlockOverlay.BlockType.REFERENCE) : null;
        QCPhaseBoxOverlay phaseBox = chart.getPhaseBoxOverlay();
        QCLimitsOverlay limits = chart.getLimitsOverlay();
        Vector<QCOverlay> transparents = chart.getTransparentOverlays();
        Vector<QCOverlay> responses = chart.getResponseOverlays();
        Iterator<QCOverlay> iter = null;
        QCOverlay response2 = null;
        int nResponses = responses.size();
        boolean drawLimits = limits != null && limits.displayLimits();
        int done = 0;
        if (blockRefFill) {
            this.channel.glPushMatrix();
            this.channel.glTranslate((double)xorigin, (double)yorigin, 0.0);
            blockRef.drawRefFills(g, true);
            this.channel.glPopMatrix();
            if (done == 1) {
                return;
            }
        }
        if (transparents != null) {
            for (QCOverlay qc2 : transparents) {
                this.channel.glPushMatrix();
                this.translateOverlay(qc2);
                qc2.drawInFill(g, false);
                this.channel.glPopMatrix();
            }
            if (done == 2) {
                return;
            }
        }
        if (drawLimits) {
            this.qcSetClip(g, limits);
            this.channel.glPushMatrix();
            this.translateOverlay(limits);
            limits.drawInFill(g, false);
            limits.drawLimits(g, false);
            this.channel.glPopMatrix();
            this.qcResetClip(g);
            if (done == 3) {
                return;
            }
        }
        boolean phaseBoxOn = phaseBox != null;
        boolean phaseBoxFill = phaseBox == null ? false : phaseBox.getFill();
        boolean phaseBoxOutline = phaseBox == null ? false : phaseBox.getOutline();
        boolean bl = phaseBoxConnect = phaseBox == null ? false : phaseBox.getConnect();
        if (phaseBoxFill) {
            this.channel.glPushMatrix();
            this.translateOverlay(phaseBox);
            phaseBox.drawWall(g, false);
            this.channel.glPopMatrix();
            if (done == 4) {
                return;
            }
        }
        this.drawGrid(g);
        if (blockRefFill) {
            this.channel.glPushMatrix();
            this.channel.glTranslate((double)xorigin, (double)yorigin, 0.0);
            blockRef.drawRefFills(g, true);
            this.channel.glPopMatrix();
            if (done == 5) {
                return;
            }
        }
        if (phaseBoxFill) {
            this.channel.glPushMatrix();
            this.translateOverlay(phaseBox);
            phaseBox.drawWall(g, true);
            this.channel.glPopMatrix();
            if (done == 6) {
                return;
            }
        }
        if (phaseBoxConnect) {
            this.channel.glPushMatrix();
            this.translateOverlay(phaseBox);
            phaseBox.drawConnect(g, false);
            this.channel.glPopMatrix();
        }
        this.drawQCReferenceLines(g);
        if (transparents != null) {
            for (QCOverlay qc2 : transparents) {
                this.channel.glPushMatrix();
                this.translateOverlay(qc2);
                qc2.drawInFill(g, !blockRefFill);
                this.channel.glPopMatrix();
            }
            if (done == 7) {
                return;
            }
        }
        if (drawLimits) {
            if (phaseBoxOn) {
                this.qcSetClip(g, limits);
                this.channel.glPushMatrix();
                this.translateOverlay(limits);
                limits.drawInFill(g, true);
                limits.drawLimits(g, true);
                this.channel.glPopMatrix();
                this.qcResetClip(g);
            } else if (blockRefFill) {
                this.qcSetClip(g, limits);
                this.channel.glPushMatrix();
                this.translateOverlay(limits);
                limits.drawInFill(g, true);
                this.channel.glPopMatrix();
                this.qcResetClip(g);
            }
            if (done == 8) {
                return;
            }
            if (done == 9) {
                return;
            }
            for (QCOverlay response2 : responses) {
                if (response2 == null || !response2.getProperty(QCOverlay.QCDrawProperty.OUTFILL) || !limits.isOutOfControl(response2)) continue;
                response2.drawOutFill(g, limits, true);
            }
            if (done == 11) {
                return;
            }
            this.qcSetClip(g, limits);
            this.channel.glPushMatrix();
            this.translateOverlay(limits);
            limits.drawLimits(g, true);
            limits.drawLabels(g);
            this.channel.glPopMatrix();
            if (done == 12) {
                return;
            }
            this.qcResetClip(g);
            if (phaseBoxOutline) {
                this.channel.glPushMatrix();
                this.translateOverlay(phaseBox);
                phaseBox.drawOutline(g, true);
                phaseBox.drawText(g, true);
                this.channel.glPopMatrix();
                if (done == 13) {
                    return;
                }
            }
            for (QCOverlay response2 : responses) {
                if (response2 == null || !response2.getProperty(QCOverlay.QCDrawProperty.RUNSTESTHIGHLIGHT)) continue;
                this.qcSetClip(g, response2);
                this.channel.glPushMatrix();
                this.translateOverlay(response2);
                response2.drawRunsTestHighlight(g);
                this.channel.glPopMatrix();
                this.qcResetClip(g);
            }
            if (done == 14) {
                return;
            }
            for (QCOverlay response2 : responses) {
                if (response2 == null || !response2.getProperty(QCOverlay.QCDrawProperty.OUTLINE)) continue;
                this.qcSetClip(g, response2);
                this.channel.glPushMatrix();
                this.translateOverlay(response2);
                response2.drawOutLine(g, limits, false);
                this.channel.glPopMatrix();
                this.qcResetClip(g);
            }
            if (done == 15) {
                return;
            }
        } else {
            if (phaseBoxOutline) {
                this.channel.glPushMatrix();
                this.translateOverlay(phaseBox);
                phaseBox.drawOutline(g, true);
                phaseBox.drawText(g, true);
                this.channel.glPopMatrix();
            }
            this.drawQCReferenceLines(g);
            if (done == 9) {
                return;
            }
        }
        if (transparents != null) {
            for (QCOverlay qc2 : transparents) {
                this.channel.glPushMatrix();
                this.translateOverlay(qc2);
                qc2.drawOutline(g, !blockRefFill);
                this.channel.glPopMatrix();
            }
        }
    }

    private synchronized void drawOpaqueParts(Graphics g, int xorigin, int yorigin, boolean blockRefFills) {
        boolean phaseBoxOutline;
        boolean drawLimits;
        QCShewhartChart chart = QCShewhart.getCurrentChart();
        QCBlockOverlay blockRef = blockRefFills ? chart.getBlockOverlay(QCBlockOverlay.BlockType.REFERENCE) : null;
        QCPhaseBoxOverlay phaseBox = chart.getPhaseBoxOverlay();
        QCLimitsOverlay limits = chart.getLimitsOverlay();
        Vector<QCOverlay> glyphs = chart.getGlyphOverlays();
        Iterator<QCOverlay> iter = null;
        boolean bl = drawLimits = limits != null && limits.displayLimits();
        if (blockRefFills) {
            this.channel.glPushMatrix();
            this.channel.glTranslate((double)xorigin, (double)yorigin, 0.0);
            blockRef.drawRefFills(g, true);
            blockRef.drawRefFills(g, true);
            this.channel.glPopMatrix();
        }
        this.drawGrid(g);
        this.drawQCReferenceLines(g);
        boolean phaseBoxFill = phaseBox != null ? phaseBox.getFill() : false;
        boolean bl2 = phaseBoxOutline = phaseBox != null ? phaseBox.getOutline() : false;
        if (phaseBoxFill) {
            this.channel.glPushMatrix();
            this.translateOverlay(phaseBox);
            phaseBox.drawWall(g, true);
            this.channel.glPopMatrix();
        }
        if (drawLimits) {
            QCOverlay response2;
            int i;
            Vector<QCOverlay> responses = chart.getResponseOverlays();
            int nResponses = responses == null ? 0 : responses.size();
            for (i = 0; i < nResponses; ++i) {
                response2 = responses.get(i);
                if (response2 == null || !response2.getProperty(QCOverlay.QCDrawProperty.OUTFILL)) continue;
                response2.drawOutFill(g, limits, false);
            }
            this.qcSetClip(g, limits);
            this.channel.glPushMatrix();
            this.translateOverlay(limits);
            limits.draw(g);
            this.channel.glPopMatrix();
            this.qcResetClip(g);
            if (phaseBoxOutline) {
                this.channel.glPushMatrix();
                this.translateOverlay(phaseBox);
                phaseBox.drawOutline(g, true);
                phaseBox.drawText(g, true);
                this.channel.glPopMatrix();
            }
            if (glyphs != null) {
                for (QCOverlay response2 : glyphs) {
                    boolean skip = response2.overrideGTLRenderingOrder(false);
                    if (!skip || !(skip = response2.isTransparent())) continue;
                    this.channel.glPushMatrix();
                    this.translateOverlay(response2);
                    response2.draw(g, false);
                    this.channel.glPopMatrix();
                }
            }
            for (i = 0; i < nResponses; ++i) {
                response2 = responses.get(i);
                if (response2 == null || !response2.getProperty(QCOverlay.QCDrawProperty.RUNSTESTHIGHLIGHT) || response2.isGlyph()) continue;
                this.qcSetClip(g, response2);
                this.channel.glPushMatrix();
                this.translateOverlay(response2);
                response2.drawRunsTestHighlight(g);
                this.channel.glPopMatrix();
                this.qcResetClip(g);
            }
            for (i = 0; i < nResponses; ++i) {
                response2 = responses.get(i);
                if (response2 == null || !response2.getProperty(QCOverlay.QCDrawProperty.OUTLINE) || response2.isGlyph()) continue;
                this.qcSetClip(g, response2);
                this.channel.glPushMatrix();
                this.translateOverlay(response2);
                response2.drawOutLine(g, limits, false);
                this.channel.glPopMatrix();
                this.qcResetClip(g);
            }
        }
    }

    private void drawGrid(Graphics g) {
        int xi1 = this.innerRegion.x;
        int yi1 = this.ymax - (this.innerRegion.y + this.innerRegion.height);
        int xi2 = this.innerRegion2.x;
        int yi2 = this.ymax - (this.innerRegion2.y + this.innerRegion2.height);
        for (int j = 0; j < this.axes.size(); ++j) {
            VRectAxis vra = (VRectAxis)this.axes.get(j);
            Vector glv = (Vector)this.A2GLV.get(vra);
            if (glv == null) continue;
            if (!vra.getAxisStyle().isShowThinnedTicks()) {
                vra.updateGridLines(glv);
            }
            this.channel.glPushMatrix();
            if (vra.getPrimary()) {
                this.channel.glTranslate((double)xi1, (double)yi1, 0.0);
            } else {
                this.channel.glTranslate((double)xi2, (double)yi2, 0.0);
            }
            for (int i = 0; i < glv.size(); ++i) {
                VRectGridLines rgl = (VRectGridLines)glv.get(i);
                if (rgl.isGreenBarOn() || !rgl.isVisible()) continue;
                rgl.draw(g);
            }
            this.channel.glPopMatrix();
        }
    }

    private synchronized void drawQCParts(Graphics g) {
        boolean wallOutline;
        QCPhaseBoxOverlay phaseBox;
        boolean phaseBoxMean;
        boolean highlightDraw;
        QCOverlay qc;
        Overlay o;
        int i;
        if (this.channel == null) {
            return;
        }
        if (this.width < 0 || this.height < 0) {
            return;
        }
        if (!this.visible) {
            return;
        }
        boolean subpixel = this.channel.isSubpixelRendering();
        this.channel.setSubpixelRendering(this.subpixelRendering);
        int xi1 = this.innerRegion.x;
        int yi1 = this.ymax - (this.innerRegion.y + this.innerRegion.height);
        int xo1 = this.outerRegion.x;
        int xo2 = this.outerRegion.x + this.outerRegion.width;
        int yo1 = this.ymax - (this.outerRegion.y + this.outerRegion.height);
        int yo2 = this.ymax - this.outerRegion.y;
        int xi2 = this.innerRegion2.x;
        int yi2 = this.ymax - (this.innerRegion2.y + this.innerRegion2.height);
        Object response = null;
        boolean drawQCOverlays = true;
        Shape save = g.getClip();
        int onum = drawQCOverlays ? this.overlays.size() : 0;
        for (i = 0; i < onum; ++i) {
            o = (Overlay)this.overlays.get(i);
            if (!(o instanceof QCOverlay)) continue;
            qc = (QCOverlay)o;
            qc.setDrawingArea(this.innerRegion, this.innerRegion2, this.outerRegion);
        }
        QCShewhartChart chart = QCShewhart.getCurrentChart();
        chart.setDrawingArea(this.ymax, this.innerRegion, this.innerRegion2, this.outerRegion);
        if (!this.labelingInited) {
            this.initLabeling(g);
            this.initQCReferenceLineLabels(g);
        } else {
            this.updateLabelingBounds();
            this.initQCReferenceLineLabels(g);
        }
        QCBlockOverlay blockRef = chart.getBlockOverlay(QCBlockOverlay.BlockType.REFERENCE);
        boolean blockRefFills = false;
        boolean blockRefLines = false;
        if (blockRef != null) {
            blockRef.setChannel(this.channel);
            blockRefFills = blockRef.getRefFill();
            blockRefLines = blockRef.getRefLines();
        }
        Color wallColor = null;
        if (this.wall != null) {
            this.channel.glPushMatrix();
            this.channel.glTranslate((double)xo1, (double)yo1, 0.0);
            this.wall.drawFill(g);
            this.channel.glPopMatrix();
            wallColor = this.wall.getFillStyle().getColor();
        }
        if (highlightDraw = QCShewhart.getHighlight()) {
            this.drawTransparentParts(g, xi1, yo1, blockRefFills);
        } else {
            this.drawOpaqueParts(g, xi1, yo1, blockRefFills);
        }
        if (blockRefLines) {
            this.channel.glPushMatrix();
            this.channel.glTranslate((double)xi1, (double)yo1, 0.0);
            blockRef.drawRefLines(g, false);
            this.channel.glPopMatrix();
        }
        boolean skip = false;
        for (i = 0; i < onum; ++i) {
            o = (Overlay)this.overlays.get(i);
            if (!o.isVisible() || !(o instanceof QCOverlay) || (skip = (qc = (QCOverlay)o).overrideGTLRenderingOrder(highlightDraw))) continue;
            boolean bl = skip = highlightDraw && qc.isTransparent();
            if (skip) continue;
            this.qcSetClip(g, qc);
            this.channel.glPushMatrix();
            this.translateOverlay(qc);
            qc.draw(g);
            this.channel.glPopMatrix();
            this.qcResetClip(g);
        }
        this.setClipOuter(g);
        Shape oldClip = g.getClip();
        for (i = 0; i < onum; ++i) {
            o = (Overlay)this.overlays.get(i);
            if (!o.isVisible() || o instanceof QCOverlay || o instanceof ReferenceLineOverlay) continue;
            this.channel.glPushMatrix();
            this.translateOverlay(o);
            if (o.isInnerMarginOverlay()) {
                Rectangle r = new Rectangle(this.outerRegion.x, this.outerRegion.y, this.outerRegion.width, this.outerRegion.height);
                Rectangle r2 = save == null ? r : r.intersection(save.getBounds());
                g.setClip(r2);
                o.draw(g);
            } else {
                g.setClip(this.outerRegion);
                o.draw(g);
            }
            g.setClip(oldClip);
            this.channel.glPopMatrix();
        }
        Vector<QCBoxParmOverlay> boxes = chart.getBoxParmOverlays();
        if (boxes != null) {
            Iterator<QCBoxParmOverlay> iter = boxes.iterator();
            QCBoxParmOverlay box = null;
            while (iter.hasNext()) {
                box = iter.next();
                this.channel.glPushMatrix();
                this.translateOverlay(box);
                box.drawMeans();
                this.channel.glPopMatrix();
            }
        }
        boolean bl = phaseBoxMean = (phaseBox = chart.getPhaseBoxOverlay()) == null ? false : phaseBox.getMean();
        if (phaseBoxMean) {
            this.channel.glPushMatrix();
            this.translateOverlay(phaseBox);
            phaseBox.drawMean(g, false);
            this.channel.glPopMatrix();
        }
        if (QCShewhart.getFrontRef()) {
            this.drawQCReferenceLabels(g);
        }
        this.drawQCDataLabels(g, wallColor, blockRefFills ? blockRef : null);
        QCLimitsOverlay limits = chart.getLimitsOverlay();
        if (limits != null && limits.displayLimits()) {
            boolean drawZoneLabels;
            boolean drawPhaseLimits = limits.getPhaseLimitLabels();
            boolean bl2 = drawZoneLabels = limits.getZoneLabels() || limits.getZoneValues();
            if (drawPhaseLimits || drawZoneLabels) {
                this.qcSetClip(g, limits);
                this.channel.glPushMatrix();
                this.translateOverlay(limits);
                if (drawPhaseLimits) {
                    limits.drawPhaseLimits(g, false);
                }
                if (drawZoneLabels) {
                    limits.drawZoneLabels(g, false);
                }
                this.channel.glPopMatrix();
                this.qcResetClip(g);
            }
        }
        if (this.channel.getBackbufferId() == -1) {
            this.channel.resetClip();
        } else {
            g.setClip(save);
        }
        boolean bl3 = wallOutline = this.wall != null;
        if (wallOutline) {
            this.channel.glPushMatrix();
            this.channel.glTranslate((double)xo1, (double)yo1, 0.0);
            this.wall.drawOutline(g);
            this.channel.glPopMatrix();
        }
        if (this.axesVisible) {
            boolean textAntialiased = this.channel.glIsEnabled(14);
            if (this.axisDisplayAntialiased) {
                this.channel.glEnable(14);
            } else {
                this.channel.glDisable(14);
            }
            for (i = 0; i < this.axes.size(); ++i) {
                AbstractAxis a = (AbstractAxis)this.axes.get(i);
                if (!a.isVisible()) continue;
                boolean drawLine = a.getAxisStyle().isAxisLineOn() && a.getAxisStyle().getLineWidth() > 1;
                boolean labelOnly = false;
                boolean primary = true;
                if (a instanceof VRectAxis) {
                    primary = ((VRectAxis)a).getPrimary();
                }
                this.channel.glPushMatrix();
                if (a.getDimension() == 2) {
                    if (primary) {
                        if (this.origin_px) {
                            this.channel.glTranslate((double)xi1 + ((VRectAxis)this.getAxis((byte)1, true)).getOutputOrigin(), (double)yi1, 0.0);
                            labelOnly = true;
                        } else {
                            this.channel.glTranslate((double)xo1, (double)yi1, 0.0);
                        }
                    } else if (this.origin_sx) {
                        this.channel.glTranslate((double)xi2 + ((VRectAxis)this.getAxis((byte)1, false)).getOutputOrigin(), (double)yi2, 0.0);
                        labelOnly = true;
                    } else {
                        this.channel.glTranslate((double)xo2, (double)yi2, 0.0);
                    }
                } else if (a.getDimension() == 1) {
                    if (primary) {
                        if (this.origin_py) {
                            this.channel.glTranslate((double)xi1, (double)yi1 + ((VRectAxis)this.getAxis((byte)2, true)).getOutputOrigin(), 0.0);
                            labelOnly = true;
                        } else {
                            this.channel.glTranslate((double)xi1, (double)yo1, 0.0);
                        }
                    } else if (this.origin_sy) {
                        this.channel.glTranslate((double)xi2, (double)yi2 + ((VRectAxis)this.getAxis((byte)2, false)).getOutputOrigin(), 0.0);
                        labelOnly = true;
                    } else {
                        this.channel.glTranslate((double)xi2, (double)yo2, 0.0);
                    }
                }
                if (drawLine) {
                    this.drawAxisLine(this.channel, a, labelOnly);
                    a.getAxisStyle().setAxisLineOn(false);
                }
                if (labelOnly) {
                    ((VRectAxis)a).drawLabels(g);
                } else {
                    a.draw(g);
                }
                this.channel.glPopMatrix();
                if (labelOnly) {
                    this.channel.glPushMatrix();
                    if (a.getDimension() == 2) {
                        if (primary) {
                            this.channel.glTranslate((double)xo1, (double)yi1, 0.0);
                        } else {
                            this.channel.glTranslate((double)xo2, (double)yi2, 0.0);
                        }
                    } else if (a.getDimension() == 1) {
                        if (primary) {
                            this.channel.glTranslate((double)xi1, (double)yo1, 0.0);
                        } else {
                            this.channel.glTranslate((double)xi2, (double)yo2, 0.0);
                        }
                    }
                    ((VRectAxis)a).drawTitle(g);
                    this.channel.glPopMatrix();
                }
                if (!drawLine) continue;
                a.getAxisStyle().setAxisLineOn(true);
            }
            if (textAntialiased) {
                this.channel.glEnable(14);
            } else {
                this.channel.glDisable(14);
            }
        }
        if (this.curveLabelsOn) {
            for (i = 0; i < onum; ++i) {
                o = (Overlay)this.overlays.get(i);
                if (!o.isVisible()) continue;
                this.channel.glPushMatrix();
                this.translateOverlay(o);
                o.drawNoneClipped(g);
                this.channel.glPopMatrix();
            }
        }
        this.channel.setSubpixelRendering(subpixel);
    }

    private void initQCReferenceLineLabels(Graphics g) {
        int left = Math.max(this.innerMargin.left, this.innerMargin2.left);
        int top = Math.max(this.innerMargin.top, this.innerMargin2.top);
        int bottom = Math.max(this.innerMargin.bottom, this.innerMargin2.bottom);
        int iw = Math.min(this.innerRegion.width, this.innerRegion2.width);
        int ih = Math.min(this.innerRegion.height, this.innerRegion2.height);
        int fuzz = 50;
        fuzz = 0;
        Rectangle clipBounds = new Rectangle(-left, -bottom, this.outerRegion.width, this.outerRegion.height);
        Insets fringe = this.getFringeMargin();
        for (int i = 0; i < this.overlays.size(); ++i) {
            Rectangle clipRect;
            Overlay o = (Overlay)this.overlays.get(i);
            if (!o.isVisible()) continue;
            if (o instanceof QCReferenceLineOverlay) {
                QCReferenceLineOverlay qcLine = (QCReferenceLineOverlay)o;
                if (qcLine.isCurveLabeled()) {
                    clipRect = new Rectangle();
                    clipRect.x = this.outerRegion.x + this.overlayMargin.left;
                    clipRect.y = this.outerRegion.y + this.overlayMargin.top;
                    clipRect.width = this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right;
                    clipRect.height = this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom;
                    qcLine.setClipRect(clipRect);
                    if (this.cmgr == null) {
                        this.cmgr = new CurveLabelLayoutManager(clipBounds, new Rectangle(0, 0, iw, ih));
                    }
                    CurveLabelLayout cl = new CurveLabelLayout();
                    cl.setLocation(qcLine.getCurveLabelLocation());
                    cl.setPosition(qcLine.getCurveLabelPosition());
                    cl.setFontMetrics(g.getFontMetrics(qcLine.getLabelStyle().getFont()));
                    qcLine.setCurveLabelLayout(cl);
                    this.cmgr.addLayout(cl);
                    continue;
                }
                clipRect = new Rectangle();
                clipRect.x = this.outerRegion.x;
                clipRect.y = this.outerRegion.y + fuzz;
                clipRect.width = this.outerRegion.width;
                clipRect.height = this.outerRegion.height - fuzz;
                clipRect.y += fringe.top;
                clipRect.height -= fringe.top;
                qcLine.setClipRect(clipRect);
                continue;
            }
            if (o instanceof QCVaryLineOverlay) {
                QCVaryLineOverlay varyLine = (QCVaryLineOverlay)o;
                clipRect = new Rectangle();
                clipRect.x = this.outerRegion.x;
                clipRect.y = this.outerRegion.y + fuzz;
                clipRect.width = this.outerRegion.width;
                clipRect.height = this.outerRegion.height - fuzz;
                clipRect.y += fringe.top;
                clipRect.height -= fringe.top;
                varyLine.setClipRect(clipRect);
                continue;
            }
            if (!(o instanceof ReferenceLineOverlay)) continue;
            ReferenceLineOverlay sgLine = (ReferenceLineOverlay)o;
            clipRect = new Rectangle();
            clipRect.x = this.outerRegion.x;
            clipRect.y = this.outerRegion.y + fuzz;
            clipRect.y = this.outerRegion.y + this.innerMargin.top;
            clipRect.width = this.outerRegion.width;
            clipRect.height = this.outerRegion.height - fuzz;
            clipRect.height = this.outerRegion.height - this.innerMargin.top;
            sgLine.setClipRect(clipRect);
        }
    }

    private void drawQCReferenceLines(Graphics g) {
        boolean drawQCOverlays = true;
        int onum = drawQCOverlays ? this.overlays.size() : 0;
        Shape save = g.getClip();
        for (int i = 0; i < onum; ++i) {
            Overlay o = (Overlay)this.overlays.get(i);
            if (!o.isVisible() || !(o instanceof QCVaryLineOverlay) && !(o instanceof QCReferenceLineOverlay)) continue;
            this.setClipOuter(g);
            this.channel.glPushMatrix();
            this.translateOverlay(o);
            int margin = this.chart.getPreferedQCTopMargin();
            o.setTopReservedSpace(margin);
            margin = this.chart.getPreferedQCBottomMargin();
            o.setBottomReservedSpace(margin);
            if (o instanceof QCVaryLineOverlay) {
                ((QCVaryLineOverlay)o).drawLines(g);
            } else if (o instanceof QCReferenceLineOverlay) {
                o.draw(g);
            }
            this.channel.glPopMatrix();
        }
        if (this.channel.getBackbufferId() == -1) {
            this.channel.resetClip();
        } else {
            g.setClip(save);
        }
    }

    private void drawQCDataLabels(Graphics g, Color wallColor, QCBlockOverlay blockRef) {
        int onum = this.overlays.size();
        for (int i = 0; i < onum; ++i) {
            Overlay o = (Overlay)this.overlays.get(i);
            if (!o.isVisible() || !(o instanceof QCOverlay)) continue;
            QCOverlay qc = (QCOverlay)o;
            this.qcSetClip(g, QCOverlay.QCClipType.OUTER);
            this.channel.glPushMatrix();
            this.translateOverlay(qc);
            qc.drawDataLabels(g, wallColor, blockRef);
            this.channel.glPopMatrix();
            this.qcResetClip(g);
        }
    }

    private void drawQCReferenceLabels(Graphics g) {
        boolean drawQCOverlays = true;
        int onum = drawQCOverlays ? this.overlays.size() : 0;
        Shape save = g.getClip();
        for (int i = 0; i < onum; ++i) {
            Overlay o = (Overlay)this.overlays.get(i);
            if (!o.isVisible() || !(o instanceof QCVaryLineOverlay) && !(o instanceof QCReferenceLineOverlay)) continue;
            this.setClipOuter(g);
            this.channel.glPushMatrix();
            this.translateOverlay(o);
            int margin = this.chart.getPreferedQCTopMargin();
            o.setTopReservedSpace(margin);
            margin = this.chart.getPreferedQCBottomMargin();
            o.setBottomReservedSpace(margin);
            if (o instanceof QCVaryLineOverlay) {
                ((QCVaryLineOverlay)o).drawLabels(g);
            } else if (o instanceof QCReferenceLineOverlay) {
                ((QCReferenceLineOverlay)o).drawLabels(g);
            }
            this.channel.glPopMatrix();
        }
        if (this.channel.getBackbufferId() == -1) {
            this.channel.resetClip();
        } else {
            g.setClip(save);
        }
    }

    private void debugChannel(Graphics g, String prefix) {
        int iChart = 0;
        double[] zero = new double[]{0.0, 0.0, 0.0};
        double[] out = new double[3];
        boolean debug = true;
        if (debug) {
            this.channel.glPushMatrix();
            this.channel.glTranslate((double)this.outerRegion.x, (double)this.outerRegion.y, 0.0);
            this.channel.gluUnProject(zero, out);
            System.out.println(prefix + " ichart=" + iChart + ": (0,0) = " + (int)out[0] + "   " + (int)out[1]);
            this.channel.glColor(Color.darkGray);
            this.channel.glLineWidth(3.0f);
            this.channel.glRect(0.0, 0.0, (double)this.outerRegion.width, (double)this.outerRegion.height);
            this.channel.glPopMatrix();
        }
        if (debug = false) {
            this.channel.glPushMatrix();
            g.setColor(Color.RED);
            g.drawRect(this.outerRegion.x, this.outerRegion.y, this.outerRegion.width, this.outerRegion.height);
            g.setColor(Color.GREEN);
            g.drawRect(this.innerRegion.x, this.innerRegion.y, this.innerRegion.width, this.innerRegion.height);
            this.channel.glPopMatrix();
        }
        if (debug = false) {
            this.channel.glPushMatrix();
            this.channel.glTranslate((double)(this.outerRegion.x + this.outerRegion.width), (double)(this.outerRegion.y + this.outerRegion.height), 0.0);
            this.channel.glColor(iChart == 0 ? Color.BLACK : Color.pink);
            this.channel.glRect(0.0, 0.0, -20.0, -20.0);
            this.channel.glPopMatrix();
            this.channel.glPushMatrix();
            this.channel.glTranslate((double)this.outerRegion.x, (double)this.outerRegion.y, 0.0);
            this.channel.glColor(iChart == 0 ? Color.BLACK : Color.pink);
            this.channel.glRect(0.0, 0.0, 20.0, 20.0);
            this.channel.glPopMatrix();
            this.channel.glPushMatrix();
            this.channel.glTranslate((double)(this.outerRegion.x + this.outerRegion.width), (double)this.outerRegion.y, 0.0);
            this.channel.glColor(iChart == 0 ? Color.BLACK : Color.pink);
            this.channel.glRect(0.0, 0.0, -20.0, 20.0);
            this.channel.glPopMatrix();
            this.channel.glPushMatrix();
            this.channel.glTranslate((double)this.outerRegion.x, (double)(this.outerRegion.y + this.outerRegion.height), 0.0);
            this.channel.glColor(iChart == 0 ? Color.BLACK : Color.pink);
            this.channel.glRect(0.0, 0.0, 20.0, -20.0);
            this.channel.glPopMatrix();
        }
    }

    public void project(double x, double y, double z, double[] r) {
        double xValue;
        ContinuousRangeToNumericMapper xvalueMapper;
        VRectAxis xAxis = (VRectAxis)this.getAxis((byte)1, true);
        VRectAxis yAxis = (VRectAxis)this.getAxis((byte)2, true);
        PositionEncoder xEncoder = (PositionEncoder)xAxis.getEncoder((byte)1);
        PositionEncoder yEncoder = (PositionEncoder)yAxis.getEncoder((byte)2);
        ValueMap xMap = xEncoder.getValueMap();
        if (xMap instanceof ContinuousRangeToNumericMap) {
            xvalueMapper = new ContinuousRangeToNumericMapper();
            xvalueMapper.setMap((ContinuousRangeToNumericMap)xMap);
            xValue = xvalueMapper.getValue(x);
        } else if (xMap instanceof StringToNumericMap) {
            xvalueMapper = new StringToNumericMapper();
            xvalueMapper.setMap((StringToNumericMap)xMap);
            try {
                xValue = xvalueMapper.getValue((Object)x);
            }
            catch (MissingValueException e) {
                return;
            }
        } else {
            return;
        }
        ValueMap yMap = yEncoder.getValueMap();
        if (!(yMap instanceof ContinuousRangeToNumericMap)) {
            return;
        }
        ContinuousRangeToNumericMapper yvalueMapper = new ContinuousRangeToNumericMapper();
        yvalueMapper.setMap((ContinuousRangeToNumericMap)yMap);
        double yValue = yvalueMapper.getValue(y);
        double xorigin = this.innerRegion.getX();
        double yorigin = this.outerRegion.getY();
        double yAxisUpper = yEncoder.getUpperLimit();
        r[0] = xorigin + xValue;
        r[1] = yorigin + yAxisUpper - yValue;
        r[2] = 0.0;
    }

    public double clipResponse(double y) {
        VRectAxis yAxis = (VRectAxis)this.getAxis((byte)2, true);
        PositionEncoder yEncoder = (PositionEncoder)yAxis.getEncoder((byte)2);
        ContinuousRange ycr = (ContinuousRange)yEncoder.getInput();
        double yAxisMax = ycr.getMax();
        double yAxisMin = ycr.getMin();
        double d = y < yAxisMin ? yAxisMin : (y > yAxisMax ? yAxisMax : y);
        d = y;
        return d;
    }

    private void setClip(Graphics g) {
        Rectangle r2;
        Rectangle r = new Rectangle(this.outerRegion.x + this.overlayMargin.left, this.outerRegion.y + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom);
        Rectangle rectangle = r2 = g.getClipBounds() == null ? r : r.intersection(g.getClipBounds());
        if (this.channel.getBackbufferId() == -1) {
            this.channel.setClip(r2);
        } else {
            g.setClip(r2);
        }
    }

    private void setClipOuter(Graphics g) {
        Rectangle r2 = this.getClipOuter(g);
        if (this.channel.getBackbufferId() == -1) {
            this.channel.setClip(r2);
        } else {
            g.setClip(r2);
        }
    }

    private void setClipInner(Graphics g) {
        Rectangle r2 = this.getClipInner(g);
        if (this.channel.getBackbufferId() == -1) {
            this.channel.setClip(r2);
        } else {
            g.setClip(r2);
        }
    }

    private void setClipOuterX(Graphics g) {
        Rectangle outer = this.getClipOuter(g);
        Rectangle inner = this.getClipInner(g);
        int x = outer.x;
        int width = outer.width;
        int y = inner.y;
        int height = inner.height;
        Rectangle r2 = new Rectangle(x, y, width, height);
        if (this.channel.getBackbufferId() == -1) {
            this.channel.setClip(r2);
        } else {
            g.setClip(r2);
        }
    }

    private void setClipVMask(Graphics g) {
        int y;
        int height;
        Rectangle outer = this.getClipOuter(g);
        Rectangle inner = this.getClipInner(g);
        int x = outer.x;
        int width = outer.width;
        int offset = 0;
        boolean adjustTop = this.chart.getAdjustedTopOffsetOn();
        boolean adjustBottom = this.chart.getAdjustedBottomOffsetOn();
        if (adjustTop) {
            height = outer.height;
            y = outer.y;
        } else if (adjustBottom) {
            height = outer.height - inner.y;
            y = inner.y;
        } else {
            height = inner.height;
            y = inner.y;
        }
        if (adjustTop) {
            offset = (int)this.chart.getAdjustedTopOffset();
            height -= offset;
            y += offset;
        }
        if (adjustBottom) {
            offset = (int)this.chart.getAdjustedBottomOffset();
            height -= offset;
        }
        Rectangle r2 = new Rectangle(x, y, width, height);
        if (this.channel.getBackbufferId() == -1) {
            this.channel.setClip(r2);
        } else {
            g.setClip(r2);
        }
    }

    private Rectangle getClipOuter(Graphics g) {
        int qcTop = this.chart.getPreferedQCTopMargin();
        int qcBottom = this.chart.getPreferedQCBottomMargin();
        Rectangle r = new Rectangle(this.outerRegion.x + this.overlayMargin.left, this.outerRegion.y + qcTop, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - qcTop - qcBottom);
        Rectangle r2 = g.getClipBounds() == null ? r : r.intersection(g.getClipBounds());
        return r2;
    }

    private Rectangle getClipInner(Graphics g) {
        Rectangle r = new Rectangle(this.innerRegion.x + this.overlayMargin.left, this.innerRegion.y, this.innerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.innerRegion.height);
        Rectangle r2 = g.getClipBounds() == null ? r : r.intersection(g.getClipBounds());
        return r2;
    }

    private void qcResetClip(Graphics g) {
        if (this.channel.getBackbufferId() == -1) {
            this.channel.setClip(null);
        } else {
            g.setClip(null);
        }
    }

    private void qcSetClip(Graphics g, QCOverlay o) {
        if (o == null) {
            return;
        }
        QCOverlay.QCClipType clipType = o.getClipType();
        switch (clipType) {
            case OUTER: {
                this.setClipOuter(g);
                break;
            }
            case OUTER_X: {
                this.setClipOuterX(g);
                break;
            }
            case VMASK: {
                this.setClipVMask(g);
                break;
            }
            default: {
                this.setClipInner(g);
            }
        }
    }

    private void qcSetClip(Graphics g, QCOverlay.QCClipType clipType) {
        switch (clipType) {
            case OUTER: {
                this.setClipOuter(g);
                break;
            }
            case OUTER_X: {
                this.setClipOuterX(g);
                break;
            }
            case VMASK: {
                this.setClipVMask(g);
                break;
            }
            default: {
                this.setClipInner(g);
            }
        }
    }

    private void translateOverlay(Overlay o) {
        boolean pya;
        int xi = this.innerRegion.x;
        int yi = this.ymax - (this.innerRegion.y + this.innerRegion.height);
        int xi2 = this.innerRegion2.x;
        int yi2 = this.ymax - (this.innerRegion2.y + this.innerRegion2.height);
        VRectAxis xa = (VRectAxis)this.getAxis(o, (byte)1);
        VRectAxis ya = (VRectAxis)this.getAxis(o, (byte)2);
        boolean pxa = xa == null ? true : xa.getPrimary();
        boolean bl = pya = ya == null ? true : ya.getPrimary();
        if (o instanceof QCBlockOverlay) {
            int yo1 = this.ymax - (this.outerRegion.y + this.outerRegion.height);
            ((QCBlockOverlay)o).translateLegendPosition(xi, yo1, 0.0);
        } else if (pxa && pya) {
            this.channel.glTranslate((double)xi, (double)yi, 0.0);
        } else if (pxa && !pya) {
            this.channel.glTranslate((double)xi, (double)yi2, 0.0);
        } else if (!pxa && pya) {
            this.channel.glTranslate((double)xi2, (double)yi, 0.0);
        } else {
            this.channel.glTranslate((double)xi2, (double)yi2, 0.0);
        }
    }

    private Rectangle getOverlayDataRegion(Overlay o) {
        boolean px = ((VRectAxis)this.getAxis(o, (byte)1)).getPrimary();
        boolean py = ((VRectAxis)this.getAxis(o, (byte)2)).getPrimary();
        Rectangle r = px && py ? new Rectangle(this.innerRegion.x, this.innerRegion.y, this.innerRegion.width, this.innerRegion.height) : (px && !py ? new Rectangle(this.innerRegion.x, this.innerRegion2.y, this.innerRegion.width, this.innerRegion2.height) : (!px && py ? new Rectangle(this.innerRegion2.x, this.innerRegion.y, this.innerRegion2.width, this.innerRegion.height) : new Rectangle(this.innerRegion2.x, this.innerRegion2.y, this.innerRegion2.width, this.innerRegion2.height)));
        --r.x;
        --r.y;
        r.width += 2;
        r.height += 2;
        return r;
    }

    private AbstractAxis getAxis(byte dimension, boolean primary) {
        for (int i = 0; i < this.axes.size(); ++i) {
            AbstractAxis a = (AbstractAxis)this.axes.get(i);
            boolean prim = true;
            if (a instanceof VRectAxis) {
                prim = ((VRectAxis)a).getPrimary();
            }
            if (prim != primary || a.getDimension() != dimension) continue;
            return a;
        }
        return null;
    }

    private void drawAxisLine(Channel channel, AbstractAxis axis, boolean inside) {
        int lineWidth = axis.getAxisStyle().getLineWidth();
        Color color = axis.getAxisStyle().getAxisLineColor();
        int pattern = axis.getAxisStyle().getLineStipplePattern();
        int factor = axis.getAxisStyle().getLineStippleFactor();
        double axisLength = ((VRectAxis)axis).getVTKAxis().getLength();
        double lineOffset = ((VRectAxis)axis).getVTKAxis().getLineOffset();
        boolean subpixel = channel.isSubpixelRendering();
        if (inside) {
            if (axis.getDimension() == 1) {
                LineSegment.drawLineSegment((Channel)channel, (double)lineOffset, (double)0.0, (double)0.0, (double)(axisLength + lineOffset), (double)0.0, (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
            } else {
                LineSegment.drawLineSegment((Channel)channel, (double)0.0, (double)lineOffset, (double)0.0, (double)0.0, (double)(axisLength + lineOffset), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
            }
        } else if (axis.getDimension() == 1) {
            if (((VRectAxis)axis).getPrimary()) {
                int offset = (lineWidth - 1) / 2;
                LineSegment.drawLineSegment((Channel)channel, (double)lineOffset, (double)offset, (double)0.0, (double)(axisLength + lineOffset), (double)offset, (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
            } else {
                int offset = lineWidth / 2;
                LineSegment.drawLineSegment((Channel)channel, (double)lineOffset, (double)(-offset), (double)0.0, (double)(axisLength + lineOffset), (double)(-offset), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
            }
        } else if (((VRectAxis)axis).getPrimary()) {
            int offset = lineWidth / 2;
            LineSegment.drawLineSegment((Channel)channel, (double)offset, (double)lineOffset, (double)0.0, (double)offset, (double)(axisLength + lineOffset), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
        } else {
            int offset = (lineWidth - 1) / 2;
            LineSegment.drawLineSegment((Channel)channel, (double)(-offset), (double)lineOffset, (double)0.0, (double)(-offset), (double)(axisLength + lineOffset), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
        }
        channel.setSubpixelRendering(subpixel);
    }

    public void updatePrefs() {
        super.updatePrefs();
        AbstractAxis axis_px = this.getAxis((byte)1, true);
        AbstractAxis axis_py = this.getAxis((byte)2, true);
        AbstractAxis axis_sx = this.getAxis((byte)1, false);
        AbstractAxis axis_sy = this.getAxis((byte)2, false);
        this.origin_px = axis_px instanceof VRectAxis && ((VRectAxis)axis_px).isOriginOn();
        this.origin_py = axis_py instanceof VRectAxis && ((VRectAxis)axis_py).isOriginOn();
        this.origin_sx = axis_sx instanceof VRectAxis && ((VRectAxis)axis_sx).isOriginOn();
        this.origin_sy = axis_sy instanceof VRectAxis && ((VRectAxis)axis_sy).isOriginOn();
    }

    public Insets getFringeMargin() {
        int i;
        QCShewhartChart chart = QCShewhart.getCurrentChart();
        if (chart == null) {
            return this.overlayMargin;
        }
        QCBlockOverlay[] topMarginOverlays = chart.getInnerMarginOverlays(1);
        QCBlockOverlay[] bottomMarginOverlays = chart.getInnerMarginOverlays(2);
        int topMarginN = chart.getInnerMarginOverlaySize(1);
        int bottomMarginN = chart.getInnerMarginOverlaySize(2);
        Insets margin = new Insets(0, 0, 0, 0);
        int h = 0;
        for (i = 0; i < topMarginN; ++i) {
            h += topMarginOverlays[i].getLegendHeight();
        }
        margin.top = h;
        h = 0;
        for (i = 0; i < bottomMarginN; ++i) {
            h += bottomMarginOverlays[i].getLegendHeight();
        }
        margin.bottom = h;
        return margin;
    }

    protected boolean hasCurveLabels() {
        if (super.hasCurveLabels()) {
            return true;
        }
        for (int i = 0; i < this.overlays.size(); ++i) {
            QCLimitsOverlay limits;
            Overlay ov = (Overlay)this.overlays.get(i);
            if (!(ov instanceof QCLimitsOverlay) || !(limits = (QCLimitsOverlay)ov).isCurveLabeled()) continue;
            return true;
        }
        return false;
    }

    protected void initLabeling(Graphics g) {
        Overlay ov;
        int i;
        int left = Math.max(this.innerMargin.left, this.innerMargin2.left);
        int top = Math.max(this.innerMargin.top, this.innerMargin2.top);
        int bottom = Math.max(this.innerMargin.bottom, this.innerMargin2.bottom);
        int iw = Math.min(this.innerRegion.width, this.innerRegion2.width);
        int ih = Math.min(this.innerRegion.height, this.innerRegion2.height);
        Rectangle clipBounds = new Rectangle(-left, -bottom, this.outerRegion.width, this.outerRegion.height);
        for (i = 0; i < this.overlays.size(); ++i) {
            QCScatterOverlay scat;
            ov = (Overlay)this.overlays.get(i);
            if (ov instanceof QCScatterOverlay) {
                scat = (QCScatterOverlay)ov;
                boolean needConnect = false;
                if (scat.isLabelVisible() && scat.isLabelCollisionAvoidance() || scat.isObstacle() || scat.isVertexLabelOn()) {
                    if (this.pmgr == null) {
                        Rectangle innerBounds = new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom);
                        this.pmgr = new PointLabelLayoutManager(innerBounds, ih);
                        this.setLabelPlacementOptions(this.pmgr);
                    }
                    scat.setPointLabelLayout(new PointLabelLayout());
                    this.pmgr.addLayout(scat.getPointLabelLayout());
                    needConnect = true;
                }
                if (scat.isCurveLabeled()) {
                    if (this.cmgr == null) {
                        this.cmgr = new CurveLabelLayoutManager(clipBounds, new Rectangle(0, 0, iw, ih));
                    }
                    CurveLabelLayout cl = new CurveLabelLayout();
                    cl.setLocation(scat.getCurveLabelLocation());
                    cl.setPosition(scat.getCurveLabelPosition());
                    cl.setFontMetrics(g.getFontMetrics(scat.getCurveLabelStyle().getFont()));
                    scat.setCurveLabelLayout(cl);
                    this.cmgr.addLayout(cl);
                    needConnect = true;
                }
                if (scat.isPointCurveLabeled()) {
                    if (this.isSALabeling()) {
                        if (this.pmgr == null) {
                            this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                            this.setLabelPlacementOptions(this.pmgr);
                        }
                        this.pcmgr = this.pmgr;
                        if (scat.getPointLabelLayout() != null) {
                            boolean dataLabeled;
                            boolean bl = dataLabeled = scat.isLabelVisible() && scat.isLabelCollisionAvoidance();
                            if (!dataLabeled) {
                                scat.setPointCurveLabelLayout(scat.getPointLabelLayout());
                            } else {
                                scat.setPointCurveLabelLayout(new PointLabelLayout());
                                this.pcmgr.addLayout(scat.getPointCurveLabelLayout());
                                needConnect = true;
                            }
                        } else {
                            scat.setPointCurveLabelLayout(new PointLabelLayout());
                            this.pcmgr.addLayout(scat.getPointCurveLabelLayout());
                            needConnect = true;
                        }
                    } else {
                        if (this.pcmgr == null) {
                            this.pcmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih, true);
                            this.setLabelPlacementOptions(this.pcmgr);
                        }
                        scat.setPointCurveLabelLayout(new PointLabelLayout());
                        this.pcmgr.addLayout(scat.getPointCurveLabelLayout());
                        needConnect = true;
                    }
                }
                if (!needConnect) continue;
                scat.connectNetwork();
                continue;
            }
            if (ov instanceof ScatterOverlay) {
                scat = (ScatterOverlay)ov;
                boolean needConnect = false;
                if (scat.isLabelVisible() && scat.isLabelCollisionAvoidance() || scat.isObstacle() || scat.isVertexLabelOn()) {
                    if (this.pmgr == null) {
                        this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                        this.setLabelPlacementOptions(this.pmgr);
                    }
                    scat.setPointLabelLayout(new PointLabelLayout());
                    this.pmgr.addLayout(scat.getPointLabelLayout());
                    needConnect = true;
                }
                if (scat.isCurveLabeled()) {
                    if (this.cmgr == null) {
                        this.cmgr = new CurveLabelLayoutManager(clipBounds, new Rectangle(0, 0, iw, ih));
                    }
                    CurveLabelLayout cl = new CurveLabelLayout();
                    cl.setLocation(scat.getCurveLabelLocation());
                    cl.setPosition(scat.getCurveLabelPosition());
                    cl.setFontMetrics(g.getFontMetrics(scat.getCurveLabelStyle().getFont()));
                    scat.setCurveLabelLayout(cl);
                    this.cmgr.addLayout(cl);
                    needConnect = true;
                }
                if (scat.isPointCurveLabeled()) {
                    if (this.isSALabeling()) {
                        if (this.pmgr == null) {
                            this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                            this.setLabelPlacementOptions(this.pmgr);
                        }
                        this.pcmgr = this.pmgr;
                        if (scat.getPointLabelLayout() != null) {
                            boolean dataLabeled;
                            boolean bl = dataLabeled = scat.isLabelVisible() && scat.isLabelCollisionAvoidance();
                            if (!dataLabeled) {
                                scat.setPointCurveLabelLayout(scat.getPointLabelLayout());
                            } else {
                                scat.setPointCurveLabelLayout(new PointLabelLayout());
                                this.pcmgr.addLayout(scat.getPointCurveLabelLayout());
                                needConnect = true;
                            }
                        } else {
                            scat.setPointCurveLabelLayout(new PointLabelLayout());
                            this.pcmgr.addLayout(scat.getPointCurveLabelLayout());
                            needConnect = true;
                        }
                    } else {
                        if (this.pcmgr == null) {
                            this.pcmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih, true);
                            this.setLabelPlacementOptions(this.pcmgr);
                        }
                        scat.setPointCurveLabelLayout(new PointLabelLayout());
                        this.pcmgr.addLayout(scat.getPointCurveLabelLayout());
                        needConnect = true;
                    }
                }
                if (!needConnect) continue;
                scat.connectNetwork();
                continue;
            }
            if (!(ov instanceof ReferenceLineOverlay)) continue;
            ReferenceLineOverlay line = (ReferenceLineOverlay)ov;
            Rectangle clipRect = new Rectangle(this.outerRegion.x + this.overlayMargin.left, this.outerRegion.y + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom);
            line.setClipRect(clipRect);
            if (line.isCurveLabeled()) {
                if (this.cmgr == null) {
                    this.cmgr = new CurveLabelLayoutManager(clipBounds, new Rectangle(0, 0, iw, ih));
                }
                CurveLabelLayout cl = new CurveLabelLayout();
                cl.setLocation(line.getCurveLabelLocation());
                cl.setPosition(line.getCurveLabelPosition());
                cl.setFontMetrics(g.getFontMetrics(line.getLabelStyle().getFont()));
                line.setCurveLabelLayout(cl);
                this.cmgr.addLayout(cl);
            }
            if (!line.isProtectedLine()) continue;
            if (this.pmgr == null) {
                this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                this.setLabelPlacementOptions(this.pmgr);
            }
            line.setPointLabelLayout(new PointLabelLayout());
            this.pmgr.addLayout(line.getPointLabelLayout());
        }
        if (this.cmgr != null) {
            this.cmgr.xRotated = this.xCLOverlapped;
            this.cmgr.x2Rotated = this.x2CLOverlapped;
        }
        if (this.pcmgr != null && this.pcmgr != this.pmgr) {
            this.pcmgr.setMaxHLabelShift(this.maxHLabelShift);
            this.pcmgr.setMaxVLabelShift(this.maxVLabelShift);
            this.pcmgr.setHLabelShiftDelta(0);
            this.pcmgr.setVLabelShiftDelta(this.vLabelShiftDelta);
            this.pcmgr.layoutReady = true;
        }
        if (this.pmgr != null) {
            this.pmgr.setMaxHLabelShift(this.maxHLabelShift);
            this.pmgr.setMaxVLabelShift(this.maxVLabelShift);
            this.pmgr.setHLabelShiftDelta(this.hLabelShiftDelta);
            this.pmgr.setVLabelShiftDelta(this.vLabelShiftDelta);
            switch (this.showPointLabels) {
                default: {
                    break;
                }
                case 1: {
                    this.showAllPointLabels();
                    break;
                }
                case 2: {
                    this.hideAllPointLabels();
                    break;
                }
                case 3: {
                    for (i = 0; i < this.getOverlays().size(); ++i) {
                        Overlay plot = (Overlay)this.getOverlays().get(i);
                        if (plot.getInitialHideLabelObs() == null) continue;
                        plot.hidePointLabels(plot.getInitialHideLabelObs());
                    }
                }
            }
            this.pmgr.layoutReady = true;
        }
        if (this.cmgr != null) {
            this.cmgr.setInnerMargin(this.overlayMargin);
        }
        this.labelingInited = true;
        for (i = 0; i < this.overlays.size(); ++i) {
            ov = (Overlay)this.overlays.get(i);
            if (!ov.isCurveLabelSplit() || ov.getCurveLabelSplitJustify() == Overlay.SPLIT_JUSTIFY_AUTO) continue;
            ov.reconnect();
        }
    }

    private void setLabelPlacementOptions(PointLabelLayoutManager mgr) {
        boolean labelVerbose = this.isLabelVerbose();
        boolean labelDisplaceable = this.isLabelDisplaceable();
        boolean saLabeling = this.isSALabeling();
        HashMap saWeightMap = this.getSAWeightMap();
        int saMaxIterations = this.getSAMaxIterations();
        mgr.setLabelVerbose(labelVerbose);
        mgr.setLabelDisplaceable(labelDisplaceable);
        mgr.setSALabeling(saLabeling);
        mgr.setSAWeightMap(saWeightMap);
        mgr.setSAMaxIterations(saMaxIterations);
    }
}

