/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.QCParserUtils;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCVaryLine;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCVaryLineOverlay;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.gtk.TextStyle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class QCVaryLineParser {
    public static final String RB_KEY = "QCVaryLineParser.";

    public static QCVaryLineOverlay load(StatGraph graph, Element elem) {
        QCVaryLineOverlay line = (QCVaryLineOverlay)((Object)graph.getObjectFromElement(elem));
        if (line == null) {
            line = new QCVaryLineOverlay();
        }
        return QCVaryLineParser.load(graph, line, elem) ? line : null;
    }

    public static boolean load(StatGraph graph, QCVaryLineOverlay line, Element e) {
        String var;
        String dataName;
        DataModel m;
        String str;
        Element labelElem = null;
        Element lineElem = null;
        String elemTag = "";
        for (Node node = e.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("CurveLabelAttrs")) {
                labelElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("LineAttrs")) continue;
            lineElem = (Element)node;
        }
        String lineAttrs = e.getAttribute("lineAttrs");
        String labelAttrs = e.getAttribute("curveLabelAttrs");
        LineAttrs ls = line.getLineAttrs();
        GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)lineAttrs, (LineAttrs)ls, (String)"Reference");
        if (lineElem != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)lineElem, (LineAttrs)ls);
        }
        TextStyle ts = line.getLabelAttrs();
        GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)labelAttrs, (TextStyle)ts, (String)"ValueText");
        if (labelElem != null) {
            StatGraph.parseTextAttrs((StatGraph)graph, (Element)labelElem, (TextStyle)ts);
        }
        if ((str = e.getAttribute("curveLabel")).length() > 0) {
            line.setLabelString(str);
        }
        boolean location = false;
        str = e.getAttribute("curveLabelLocation");
        if (str.equalsIgnoreCase("INSIDE")) {
            location = false;
        } else if (str.equalsIgnoreCase("OUTSIDE")) {
            location = true;
        } else {
            location = false;
            if (str.length() > 0) {
                StatGraph.printOptionError((String)"CURVELABELLOCATION", (String)str);
            }
        }
        QCVaryLine.LabelPos position = QCVaryLine.LabelPos.INNER_LEFT;
        str = e.getAttribute("curveLabelPosition");
        if (str.equalsIgnoreCase("MIN")) {
            position = QCVaryLine.LabelPos.INNER_LEFT;
        } else if (str.equalsIgnoreCase("MAX")) {
            position = QCVaryLine.LabelPos.INNER_RIGHT;
        } else if (str.equalsIgnoreCase("START") && !location) {
            position = QCVaryLine.LabelPos.INNER_LEFT;
        } else if (str.equalsIgnoreCase("END") && !location) {
            position = QCVaryLine.LabelPos.INNER_RIGHT;
        } else if (str.equalsIgnoreCase("AUTO") && location) {
            position = QCVaryLine.LabelPos.OUTER_RIGHT;
        } else {
            position = location ? QCVaryLine.LabelPos.OUTER_RIGHT : QCVaryLine.LabelPos.INNER_LEFT;
            if (str.length() > 0) {
                StatGraph.printOptionError((String)"CURVELABELPOSITION", (String)str);
            }
        }
        line.setLabelPosition(position);
        Element _internal = ParserUtils.getChildWithTagName((String)"_internal", (Element)e);
        if (!QCVaryLineParser.loadInternal(graph, line, _internal)) {
            // empty if block
        }
        if ((m = graph.getData(dataName = StatGraph.getDataName((String)(var = e.getAttribute("x"))))) == null) {
            graph.removeNamedGraph((Overlay)line);
            return false;
        }
        RoleColumnMap map = new RoleColumnMap();
        var = e.getAttribute("x");
        String varID = StatGraph.getVarID((String)var);
        int col = m.getColumn(varID);
        if (!StatGraph.checkVariable((String)"X", (Object)m.getColumnLabel(col), null, (int)1, (boolean)true)) {
            graph.removeNamedGraph((Overlay)line);
            return false;
        }
        map.map(10, col);
        line.addRole("X", m.getColumnLabel(col));
        var = e.getAttribute("y");
        varID = StatGraph.getVarID((String)var);
        col = m.getColumn(varID);
        if (!StatGraph.checkVariable((String)"Y", (Object)m.getColumnLabel(col), null, (int)1, (boolean)true)) {
            graph.removeNamedGraph((Overlay)line);
            return false;
        }
        map.map(11, col);
        line.addRole("Y", m.getColumnLabel(col));
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere((StatGraph)graph, (CRD)crd, (Overlay)line);
        line.setModel(crd);
        return true;
    }

    static boolean loadInternal(StatGraph graph, QCVaryLineOverlay plot, Element _internal) {
        if (_internal == null) {
            // empty if block
        }
        boolean b = QCParserUtils.getBoolean("debug", _internal, false);
        plot.setDebug(b);
        int i = QCParserUtils.getInteger("context", _internal, -1);
        QCOverlay.QCResponseContext type = QCOverlay.QCResponseContext.fromInteger(i, QCOverlay.QCResponseContext.Y);
        b = QCParserUtils.getBoolean("phaseBoxResponse", _internal, false);
        plot.setPhaseBoxResponse(b);
        b = QCParserUtils.getBoolean("above", _internal, true);
        plot.setLabelAbove(b);
        i = QCParserUtils.getInteger("phaseIndex", _internal, -1);
        plot.setPhaseIndex(i);
        return true;
    }
}

