/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.QCLayoutOverlayParser;
import com.sas.analytics.qc.statgraph.QCParserUtils;
import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.sgchart.gtk.AQCStar;
import com.sas.analytics.qc.statgraph.sgchart.gtk.gl.QCStarLabel;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCStarOverlay;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.gtk.TextStyle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class QCStarParser {
    public static final String RB_KEY = "QCStarParser.";

    public static QCStarOverlay load(StatGraph graph, Element elem) {
        QCStarOverlay star = (QCStarOverlay)((Object)graph.getObjectFromElement(elem));
        if (star == null) {
            star = new QCStarOverlay();
        }
        return QCStarParser.load(graph, star, elem) ? star : null;
    }

    public static boolean load(StatGraph graph, QCStarOverlay plot, Element e) {
        Element _internal;
        String s;
        double d;
        Object cmd;
        String indexVarID;
        int col;
        RoleColumnMap map = new RoleColumnMap();
        String str = e.getAttribute("x");
        String dataName = StatGraph.getDataName((String)str);
        DataModel m = graph.getData(dataName);
        if (m == null) {
            return false;
        }
        boolean ok = true;
        String xVarID = StatGraph.getVarID((String)str);
        int xcol = m.getColumn(xVarID);
        if (!StatGraph.checkVariable((String)"X", (Object)m.getColumnLabel(xcol), null, (int)1, (boolean)true)) {
            graph.removeNamedGraph((Overlay)plot);
            return false;
        }
        map.map(10, xcol);
        plot.addRole("X", m.getColumnLabel(xcol));
        str = e.getAttribute("y");
        String yVarID = StatGraph.getVarID((String)str);
        int ycol = m.getColumn(yVarID);
        if (!StatGraph.checkVariable((String)"Y", (Object)m.getColumnLabel(ycol), Double.class, (int)2, (boolean)true)) {
            return false;
        }
        map.map(11, ycol);
        plot.addRole("Y", m.getColumnLabel(ycol));
        str = e.getAttribute("group");
        String gVarID = StatGraph.getVarID((String)str);
        str = e.getAttribute("index");
        if (str.length() > 0 && StatGraph.checkVariable((String)"INDEX", (Object)m.getColumnLabel(col = m.getColumn(indexVarID = StatGraph.getVarID((String)str))), Double.class, (int)2, (boolean)true, (boolean)false) && ScatterParser.checkIndexColumn((DataModel)m, (int)col, (String)"INDEX", (String)indexVarID)) {
            map.map(44, col);
            cmd = m.getColumnLabel(col);
            plot.addRole("INDEX", cmd);
        }
        int nVertex = 0;
        Element child = ParserUtils.getChildWithTagName((String)"VertexVars", (Element)e);
        if (child != null) {
            NodeList vertices = child.getElementsByTagName("Value");
            int n = vertices.getLength();
            if (n < 0) {
                graph.removeNamedGraph((Overlay)plot);
                return false;
            }
            plot.vertex = new QCStarOverlay.Vertex[n];
            for (int j = 0; j < n; ++j) {
                String varID;
                child = (Element)vertices.item(j);
                String var = ParserUtils.getElementText((Element)child);
                if (!StatGraph.checkVariable((String)var, (Object)(cmd = m.getColumnLabel(col = m.getColumn(varID = StatGraph.getVarID((String)var)))), Double.class, (int)1, (boolean)true)) {
                    graph.removeNamedGraph((Overlay)plot);
                    return false;
                }
                map.map(740 + j, col);
                plot.addRole("VERTEX" + (j + 1), cmd);
                QCStarOverlay.Vertex vertex = new QCStarOverlay.Vertex();
                vertex.var = var;
                vertex.varID = varID;
                plot.vertex[nVertex] = vertex;
                ++nVertex;
            }
        }
        if (nVertex == 0) {
            graph.removeNamedGraph((Overlay)plot);
            return false;
        }
        Element roleElement = StatGraph.getOptionAttrsElement((Element)e, (String)"Roles");
        DataModel m2 = null;
        RoleColumnMap map2 = null;
        boolean internal_outline = false;
        if (roleElement != null) {
            String data2Name;
            QCLayoutOverlayParser.parseRoleNames(roleElement, m, (Overlay)plot);
            String var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SUBGRPLABEL");
            if (m.hasColumn(var)) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                map.map(798, col);
                plot.addRole("SUBGRPLABEL", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_IGRP"))) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                map.map(802, col);
                plot.addRole("IGRP", cmd);
                QCShewhart.subsetX(m, xcol, col);
                QCShewhart.subsetY(m, ycol, col);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_OUTLINE"))) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                map.map(46, col);
                plot.addRole("LINECOLOR", cmd);
                internal_outline = true;
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_OUTLINEINDEX"))) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                map.map(795, col);
                plot.addRole("LINECOLORINDEX", cmd);
                internal_outline = true;
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_OOC"))) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                map.map(796, col);
                plot.addRole("OOC", cmd);
            }
            if ((data2Name = QCLayoutOverlayParser.getRoleDataName(roleElement, "INTERNAL_SPOKENAME")) != null) {
                m2 = graph.getData(data2Name);
                map2 = new RoleColumnMap();
                var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SPOKEENTRY");
                if (m2.hasColumn(var)) {
                    col = m2.getColumn(var);
                    cmd = m2.getColumnLabel(col);
                    map2.map(733, col);
                    plot.addRole("SPOKEENTRY", cmd);
                }
                if (m2.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SPOKENAME"))) {
                    col = m2.getColumn(var);
                    cmd = m2.getColumnLabel(col);
                    map2.map(734, col);
                    plot.addRole("SPOKENAME", cmd);
                }
                if (m2.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SPOKELABEL"))) {
                    col = m2.getColumn(var);
                    cmd = m2.getColumnLabel(col);
                    map2.map(735, col);
                    plot.addRole("SPOKELABEL", cmd);
                }
                if (m2.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SPOKECOLORINDEX"))) {
                    col = m2.getColumn(var);
                    cmd = m2.getColumnLabel(col);
                    map2.map(736, col);
                    plot.addRole("SPOKECOLORINDEX", cmd);
                }
                if (m2.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SPOKELINEINDEX"))) {
                    col = m2.getColumn(var);
                    cmd = m2.getColumnLabel(col);
                    map2.map(737, col);
                    plot.addRole("SPOKELINEINDEX", cmd);
                }
            }
        }
        if (!gVarID.equals("")) {
            col = m.getColumn(gVarID);
            cmd = m.getColumnLabel(col);
            map.map(3, col);
            map.map(6, col);
            plot.addRole("GROUP", cmd);
            plot.addRole("COLOR", cmd);
            if (!internal_outline) {
                map.map(46, col);
                map.map(45, col);
                map.map(68, col);
            }
            if ((str = e.getAttribute("includeMissingGroup")).length() > 0 && str.equalsIgnoreCase("false")) {
                plot.setMissingGroupOn(false);
            }
            if ((str = e.getAttribute("groupAttrVar")).length() > 0) {
                plot.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
            }
            str = e.getAttribute("groupOrder");
        }
        QCLayoutOverlayParser.parseRoleTipStuff(e, m, map, plot);
        StatGraph.parseURLOpt((Element)e, (DataModel)m, (RoleColumnMap)map, (Overlay)plot);
        plot.setFillOn(false);
        plot.setRefsOn(false);
        int i = QCParserUtils.getInteger("starType", e);
        plot.starType = AQCStar.StarType.fromInteger(i, AQCStar.StarType.DEFAULT);
        str = QCParserUtils.getString("display", e);
        String[] opts = StatGraph.parseList2String((String)str);
        boolean fill = false;
        boolean tips = true;
        for (i = 0; i < opts.length; ++i) {
            str = opts[i];
            if (str.equalsIgnoreCase("fill")) {
                fill = true;
                plot.setFillOn(true);
                continue;
            }
            if (!str.equalsIgnoreCase("refs")) continue;
            plot.setRefsOn(true);
        }
        boolean fillType = AQCStar.StarType.fill(plot.starType);
        if (!(!tips || fillType && fill)) {
            plot.setFillOn(true);
            plot.setTransparentFill(true);
        }
        plot.nVertex = nVertex;
        double[] a = QCParserUtils.getDoubleArray("circles", e);
        plot.refValues = a;
        plot.radius[0] = d = QCParserUtils.getDouble("radiusInner", e, -1.0);
        plot.radius[1] = d = QCParserUtils.getDouble("radiusOuter", e, -1.0);
        plot.clipRadius = d = QCParserUtils.getDouble("radiusMax", e, -1.0);
        i = QCParserUtils.getInteger("dataLabelType", e);
        plot.labelType = QCStarLabel.StarLabel.fromInteger(i, QCStarLabel.StarLabel.DEFAULT);
        i = QCParserUtils.getInteger("legendType", e);
        plot.legendType = AQCStar.StarLegend.fromInteger(i, AQCStar.StarLegend.DEFAULT);
        plot.legendLabel = s = QCParserUtils.getString("legendLabel", e);
        d = QCParserUtils.getDouble("start", e, -1.0);
        plot.startDegrees = d == -1.0 ? 90.0 : d;
        str = e.getAttribute("primary");
        plot.setPrimary(str.equalsIgnoreCase("true"));
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        CRD crd2 = null;
        if (m2 != null) {
            crd2 = new CRD();
            crd2.setSrcModel(m2);
            crd2.setSrcMap(map2);
        }
        String contextName = graph.style.getContextName();
        plot.setContextName(contextName);
        LineAttrs ls = plot.getOutlineAttrs();
        GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)e.getAttribute("outlineAttrs"), (LineAttrs)ls, (String)"Stars");
        Element e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"OutlineAttrs");
        if (e2 != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)e2, (LineAttrs)ls);
        }
        FillAttrs fs = plot.getFillAttrs();
        GraphStyle.setDefaultDataFillStyle((StatGraph)graph, (String)e.getAttribute("fillAttrs"), (FillAttrs)fs, (String)"Stars");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"FillAttrs");
        if (e2 != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)e2, (FillAttrs)fs);
        }
        ls = plot.getRefsAttrs();
        GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)e.getAttribute("circleAttrs"), (LineAttrs)ls, (String)"Stars");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"CircleAttrs");
        if (e2 != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)e2, (LineAttrs)ls);
        }
        ls = plot.getSpokeAttrs();
        GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)e.getAttribute("spokeAttrs"), (LineAttrs)ls, (String)"Stars");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"SpokeAttrs");
        if (e2 != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)e2, (LineAttrs)ls);
        }
        fs = plot.getOOCFillAttrs();
        GraphStyle.setDefaultDataFillStyle((StatGraph)graph, (String)e.getAttribute("oocFillAttrs"), (FillAttrs)fs, (String)"KPIRange1");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"OOCFillAttrs");
        if (e2 != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)e2, (FillAttrs)fs);
        }
        ls = plot.getOOCLineStyle();
        GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)e.getAttribute("oocOutlineAttrs"), (LineAttrs)ls, (String)"KPIRange1");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"OOCOutlineAttrs");
        if (e2 != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)e2, (LineAttrs)ls);
        }
        ls = plot.getOOCSpokeStyle();
        GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)e.getAttribute("oocOutlineAttrs"), (LineAttrs)ls, (String)"KPIRange1");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"OOCOutlineAttrs");
        if (e2 != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)e2, (LineAttrs)ls);
        }
        TextStyle ts = plot.getLabelStyle();
        GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)e.getAttribute("dataLabelAttrs"), (TextStyle)ts, (String)"DataText");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"LabelAttrs");
        if (e2 != null) {
            StatGraph.parseTextAttrs((StatGraph)graph, (Element)e2, (TextStyle)ts);
        }
        ts = plot.getLegendStyle();
        GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)e.getAttribute("valueAttrs"), (TextStyle)ts, (String)"ValueText");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"ValueAttrs");
        if (e2 != null) {
            StatGraph.parseTextAttrs((StatGraph)graph, (Element)e2, (TextStyle)ts);
        }
        if (!QCStarParser.loadInternal(graph, plot, _internal = ParserUtils.getChildWithTagName((String)"_internal", (Element)e))) {
            // empty if block
        }
        if (!ok) {
            return false;
        }
        LayoutOverlayParser.parseGraphOpts((StatGraph)graph, (Element)e, (Overlay)plot);
        plot.setModel(crd, crd2);
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (crd.isAvailable(6)) {
            graph.style.setContextCount(contextCount);
            QCLayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)4, plot.getFillAttrs().getTransparency());
        }
        if (crd.isAvailable(46)) {
            graph.style.setContextCount(contextCount);
            QCLayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)17, plot.getOutlineAttrs().getTransparency());
        }
        if (crd.isAvailable(36)) {
            graph.style.setContextCount(contextCount);
            QCLayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)15);
        }
        if (crd2 != null) {
            plot.switchModels();
            if (crd2.isAvailable(736)) {
                graph.style.setContextCount(contextCount);
                QCLayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)54, (short)736);
            }
            if (crd2.isAvailable(737)) {
                graph.style.setContextCount(contextCount);
                QCLayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)55, (short)737);
            }
            plot.switchModels();
        }
        if (LayoutOverlayParser.isIndexVarAssigned((CRD)crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    static boolean loadInternal(StatGraph graph, QCStarOverlay plot, Element _internal) {
        Element child;
        float f;
        double d;
        if (_internal == null) {
            // empty if block
        }
        boolean b = QCParserUtils.getBoolean("phaseBoxResponse", _internal, false);
        plot.setPhaseBoxResponse(b);
        QCParserUtils.setDebug(false);
        plot.specs = d = QCParserUtils.getDouble("specs", _internal, 0.0);
        plot.lineOut = b = QCParserUtils.getBoolean("lineOut", _internal, false);
        plot.fillOut = b = QCParserUtils.getBoolean("fillOut", _internal, false);
        plot.fillIn = b = QCParserUtils.getBoolean("fillIn", _internal, false);
        plot.starOut = b = QCParserUtils.getBoolean("starOut", _internal, false);
        plot.spokeOut = b = QCParserUtils.getBoolean("spokeOut", _internal, false);
        plot.infillOpacity = f = QCParserUtils.getOpacity("inFillOpacity", _internal, 1.0f);
        plot.overlapOpacity = f = QCParserUtils.getOpacity("overlapOpacity", _internal, 0.75f);
        plot.fillVar = QCParserUtils.getAttribute("fill", _internal);
        plot.fillIndexVar = QCParserUtils.getAttribute("fillIndex", _internal);
        plot.outlineVar = QCParserUtils.getAttribute("outline", _internal);
        plot.outlineIndexVar = QCParserUtils.getAttribute("outlineIndex", _internal);
        plot.htmlVar = QCParserUtils.getAttribute("html", _internal);
        QCParserUtils.setDebug(false);
        int i = QCParserUtils.getInteger("context", _internal, -1);
        QCOverlay.QCResponseContext type = QCOverlay.QCResponseContext.fromInteger(i, QCOverlay.QCResponseContext.Y);
        plot.setContext(type);
        d = QCParserUtils.getDouble("interval", _internal, -1.0);
        if (d > 0.0) {
            plot.setInterval(d);
        }
        b = QCParserUtils.getBoolean("hideLegendItems", _internal, false);
        plot.setHideLegendItems(b);
        Element element = child = _internal == null ? null : ParserUtils.getChildWithTagName((String)"VertexLegend", (Element)_internal);
        if (child != null) {
            int n;
            NodeList nodes = child.getElementsByTagName("Entry");
            int n2 = n = nodes == null ? 0 : nodes.getLength();
            if (n != plot.nVertex) {
                return false;
            }
            for (int j = 0; j < n; ++j) {
                String label;
                child = (Element)nodes.item(j);
                QCStarOverlay.Vertex vertex = plot.vertex[j];
                vertex.entryLabel = label = QCParserUtils.getString("label", child);
                vertex.entryValue = label = QCParserUtils.getString("value", child);
            }
        }
        return true;
    }
}

