/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBlockOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBoxParmOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCLimit;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCLimitsOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCPhaseBoxOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCStarOverlay;
import com.sas.analytics.qc.statgraph.sgchart.util.QCMargins;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Vector;

public class QCShewhartChart {
    protected Vector<QCOverlay> responses = null;
    protected Vector<QCOverlay> transparents = null;
    protected QCLimitsOverlay limits = null;
    protected QCBlockOverlay blocks = null;
    protected QCBlockOverlay phases = null;
    protected QCPhaseBoxOverlay phaseBox = null;
    protected QCBlockOverlay refs = null;
    protected QCBlockOverlay[] topMarginOverlays = new QCBlockOverlay[2];
    protected QCBlockOverlay[] bottomMarginOverlays = new QCBlockOverlay[2];
    protected int nTopMarginOverlays;
    protected int nBottomMarginOverlays;
    protected int level;
    public Insets preferedInnerMargin = null;
    protected Rectangle innerRegion = null;
    protected Rectangle innerRegion2 = null;
    protected Rectangle outerRegion = null;
    protected boolean adjustedTopOffsetOn = false;
    protected double adjustedTopOffset = 0.0;
    protected boolean adjustedBottomOffsetOn = false;
    protected double adjustedBottomOffset = 0.0;

    private void init() {
        this.responses = new Vector();
        this.transparents = new Vector();
        this.limits = null;
        this.blocks = null;
        this.phases = null;
        this.refs = null;
        this.topMarginOverlays[0] = null;
        this.topMarginOverlays[1] = null;
        this.nTopMarginOverlays = 0;
        this.bottomMarginOverlays[0] = null;
        this.bottomMarginOverlays[1] = null;
        this.nBottomMarginOverlays = 0;
        this.level = -1;
    }

    public void reset() {
        this.init();
    }

    public void setChartLevel(int i) {
        this.level = i;
    }

    public int getChartLevel() {
        return this.level;
    }

    public void addQCOverlay(QCOverlay o) {
        o.setChart(this);
    }

    public void addResponseOverlay(QCOverlay o) {
        o.setChart(this);
        QCOverlay.QCResponseContext context = o.getContext();
        switch (context) {
            default: {
                this.responses.add(o);
                QCShewhart.addDriver(o);
            }
            case CONNECT: 
            case DEADBEEF: 
            case VARYREF: 
        }
        if (o.isTransparent()) {
            this.transparents.add(o);
        }
    }

    public Vector<QCOverlay> getResponseOverlays() {
        return this.responses;
    }

    public Vector<QCOverlay> getTransparentOverlays() {
        return this.transparents;
    }

    public Vector<QCOverlay> getGlyphOverlays() {
        return this.transparents;
    }

    public void addPhaseBoxOverlay(QCPhaseBoxOverlay o) {
        o.setChart(this);
        this.phaseBox = o;
        QCShewhart.addPassenger(o);
        CRD primaryModel = QCShewhart.getPrimaryModel();
        if (primaryModel == null) {
            CRD model;
            QCShewhart.primaryModel = model = o.getSubgrpModel();
        }
    }

    public void addBlockOverlay(QCBlockOverlay o) {
        o.setChart(this);
        QCBlockOverlay.BlockType context = o.getBlockType();
        switch (context) {
            case BLOCK: {
                this.blocks = o;
                break;
            }
            case PHASE: {
                this.phases = o;
                break;
            }
            case REFERENCE: 
            case BLOCKREF: 
            case PHASEREF: {
                this.refs = o;
                break;
            }
        }
        int just = o.isInnerMarginOverlay() ? o.getOverlayJustification() : -1;
        switch (just) {
            case 1: {
                this.topMarginOverlays[this.nTopMarginOverlays++] = o;
                break;
            }
            case 2: {
                this.bottomMarginOverlays[this.nBottomMarginOverlays++] = o;
            }
        }
        QCShewhart.addPassenger(o);
        CRD primaryModel = QCShewhart.getPrimaryModel();
        if (primaryModel == null) {
            CRD model;
            QCShewhart.primaryModel = model = o.getSubgrpModel();
        }
    }

    public QCBlockOverlay getRefOverlay() {
        QCBlockOverlay phaseRef = this.getRefOverlay(QCBlockOverlay.BlockType.PHASEREF);
        QCBlockOverlay blockRef = this.getRefOverlay(QCBlockOverlay.BlockType.BLOCKREF);
        return phaseRef != null ? phaseRef : blockRef;
    }

    public QCBlockOverlay getRefOverlay(QCBlockOverlay.BlockType type) {
        QCBlockOverlay b;
        switch (type) {
            case PHASEREF: {
                if (this.phases != null) {
                    b = this.phases;
                    break;
                }
                if (this.refs != null && this.refs.getBlockType() == QCBlockOverlay.BlockType.PHASEREF) {
                    b = this.refs;
                    break;
                }
                b = null;
                break;
            }
            case BLOCKREF: {
                if (this.blocks != null) {
                    b = this.blocks;
                    break;
                }
                if (this.refs != null && this.refs.getBlockType() == QCBlockOverlay.BlockType.BLOCKREF) {
                    b = this.refs;
                    break;
                }
                b = null;
                break;
            }
            default: {
                b = null;
            }
        }
        if (b == null) {
            return null;
        }
        int[] list = b.getRefList();
        int n = list == null ? 0 : list.length;
        return b;
    }

    public QCBlockOverlay getBlockOverlay(QCBlockOverlay.BlockType context) {
        QCBlockOverlay o = null;
        switch (context) {
            case BLOCK: {
                o = this.blocks;
                break;
            }
            case PHASE: {
                o = this.phases;
                break;
            }
            case REFERENCE: 
            case BLOCKREF: 
            case PHASEREF: {
                o = this.refs;
                break;
            }
        }
        return o;
    }

    public boolean hasBlockOverlay(QCBlockOverlay.BlockType context) {
        QCBlockOverlay o = null;
        switch (context) {
            case BLOCK: {
                o = this.blocks;
                break;
            }
            case PHASE: {
                o = this.phases;
                break;
            }
            case REFERENCE: 
            case BLOCKREF: 
            case PHASEREF: {
                o = this.refs;
                break;
            }
        }
        return o != null;
    }

    public boolean hasBlockOverlay() {
        return this.blocks != null;
    }

    public boolean hasPhaseOverlay() {
        return this.phases != null;
    }

    public boolean hasReferenceOverlay() {
        return this.refs != null;
    }

    public boolean hasPhaseBoxOverlay() {
        return this.phaseBox != null;
    }

    public QCPhaseBoxOverlay getPhaseBoxOverlay() {
        return this.phaseBox;
    }

    public QCBlockOverlay[] getInnerMarginOverlays(int just) {
        if (just == 1) {
            return this.topMarginOverlays;
        }
        if (just == 2) {
            return this.bottomMarginOverlays;
        }
        return null;
    }

    public int getInnerMarginOverlaySize(int just) {
        if (just == 1) {
            return this.nTopMarginOverlays;
        }
        if (just == 2) {
            return this.nBottomMarginOverlays;
        }
        return 0;
    }

    public int getInnerMarginOverlayIndex(int just, QCBlockOverlay o) {
        int n;
        QCBlockOverlay[] list = null;
        if (just == 1) {
            list = this.topMarginOverlays;
            n = this.nTopMarginOverlays;
        } else if (just == 2) {
            list = this.bottomMarginOverlays;
            n = this.nBottomMarginOverlays;
        } else {
            n = 0;
        }
        int index = -1;
        for (int i = 0; i < n; ++i) {
            if (o != list[i]) continue;
            index = i;
        }
        return index;
    }

    public void addLimitsOverlay(QCLimitsOverlay o) {
        o.setChart(this);
        this.limits = o;
        QCShewhart.addPassenger(this.limits);
    }

    public QCLimitsOverlay getLimitsOverlay() {
        return this.limits;
    }

    public QCStarOverlay getStarOverlay() {
        int n = this.responses == null ? 0 : this.responses.size();
        for (int i = 0; i < n; ++i) {
            QCOverlay o = this.responses.get(i);
            if (!(o instanceof QCStarOverlay)) continue;
            return (QCStarOverlay)o;
        }
        return null;
    }

    public Vector<QCBoxParmOverlay> getBoxParmOverlays() {
        int n;
        int n2 = n = this.responses == null ? 0 : this.responses.size();
        if (n == 0) {
            return null;
        }
        Vector<QCBoxParmOverlay> boxes = new Vector<QCBoxParmOverlay>();
        boolean hasBox = false;
        for (int i = 0; i < n; ++i) {
            QCOverlay o = this.responses.get(i);
            if (!(o instanceof QCBoxParmOverlay)) continue;
            hasBox = true;
            boxes.add((QCBoxParmOverlay)o);
        }
        return hasBox ? boxes : null;
    }

    public boolean isGlyphChart() {
        boolean rc = false;
        if (this.responses == null) {
            return rc;
        }
        int n = this.responses.size();
        for (int j = 0; j < n; ++j) {
            QCOverlay response = this.responses.get(j);
            if (response == null || !response.isGlyph()) continue;
            rc = true;
            break;
        }
        return rc;
    }

    public boolean isResponseOOC(QCOverlay response) {
        if (this.limits == null) {
            return false;
        }
        return this.limits.isOutOfControl(response);
    }

    public boolean isResponseOOC(double y, int igrp) {
        if (this.limits == null) {
            return false;
        }
        QCLimit lower = this.limits.getLimit(1);
        QCLimit upper = this.limits.getLimit(0);
        double ucl = upper.getValue(igrp);
        double lcl = lower.getValue(igrp);
        boolean ooc = y < lcl || y > ucl;
        return ooc;
    }

    public boolean isResponseOOC(QCOverlay response, int igrp) {
        double[] y;
        if (this.limits == null) {
            return false;
        }
        CRD sm = response.getModel();
        double[] x = sm.isAvailable(10) ? sm.getDoubleColumn(10) : null;
        double[] dArray = y = sm.isAvailable(11) ? sm.getDoubleColumn(11) : null;
        if (y == null) {
            return false;
        }
        double d = y[igrp];
        QCLimit lower = this.limits.getLimit(1);
        QCLimit upper = this.limits.getLimit(0);
        double ucl = upper.getValue(igrp);
        double lcl = lower.getValue(igrp);
        boolean ooc = d < lcl || d > ucl;
        return ooc;
    }

    public boolean isResponseOOC(int igrp) {
        if (this.limits == null) {
            return false;
        }
        QCOverlay response = this.responses.firstElement();
        return this.isResponseOOC(response, igrp);
    }

    public void initializeLimits() {
        if (this.limits != null) {
            this.limits.initLastNonMissingIndex();
            this.limits.createInfillColorPipe();
        }
    }

    public void setDrawingArea(int ymax, Rectangle inner, Rectangle inner2, Rectangle outer) {
        this.innerRegion = inner;
        this.innerRegion2 = inner2;
        this.outerRegion = outer;
        int xi1 = this.innerRegion.x;
        int yi1 = ymax - (this.innerRegion.y + this.innerRegion.height);
        int xo1 = this.outerRegion.x;
        int xo2 = this.outerRegion.x + this.outerRegion.width;
        int yo1 = ymax - (this.outerRegion.y + this.outerRegion.height);
        int yo2 = ymax - this.outerRegion.y;
        int xi2 = this.innerRegion2.x;
        int yi2 = ymax - (this.innerRegion2.y + this.innerRegion2.height);
    }

    public int getPreferedQCTopMargin() {
        return this.preferedInnerMargin == null ? 0 : this.preferedInnerMargin.top;
    }

    public int getPreferedQCBottomMargin() {
        return this.preferedInnerMargin == null ? 0 : this.preferedInnerMargin.bottom;
    }

    public int getPreferedQCLeftMargin() {
        return this.preferedInnerMargin == null ? 0 : this.preferedInnerMargin.left;
    }

    public int getPreferedQCRightMargin() {
        return this.preferedInnerMargin == null ? 0 : this.preferedInnerMargin.right;
    }

    public double getPhaseBoxYOffset() {
        return this.hasPhaseBoxOverlay() ? (double)(QCMargins.getPhaseBoxInnerY() + QCMargins.getPhaseBoxOuterY()) : 0.0;
    }

    public double getPhaseBoxInnerXOffset() {
        return this.hasPhaseBoxOverlay() ? (double)QCMargins.getPhaseBoxInnerX() : 0.0;
    }

    public double getPhaseBoxOuterXOffset() {
        return this.hasPhaseBoxOverlay() ? (double)QCMargins.getPhaseBoxOuterX() : 0.0;
    }

    public double getPhaseBoxInnerYOffset() {
        return this.hasPhaseBoxOverlay() ? (double)QCMargins.getPhaseBoxInnerY() : 0.0;
    }

    public double getPhaseBoxOuterYOffset() {
        return this.hasPhaseBoxOverlay() ? (double)QCMargins.getPhaseBoxOuterY() : 0.0;
    }

    public double getPhaseBoxMargin(byte dim) {
        if (this.responses == null) {
            return 0.0;
        }
        int n = this.responses.size();
        double margin = 0.0;
        for (int i = 0; i < n; ++i) {
            QCOverlay o = this.responses.get(i);
            if (o == null) continue;
            double d = o.getPhaseBoxMargin(dim);
            margin = Math.max(d, margin);
        }
        return margin;
    }

    public double getAdjustedTopOffset() {
        return this.adjustedTopOffset;
    }

    public void setAdjustedTopOffset(double d) {
        this.adjustedTopOffset = Math.max(this.adjustedTopOffset, d);
    }

    public boolean getAdjustedTopOffsetOn() {
        return this.adjustedTopOffsetOn;
    }

    public void setAdjustedTopOffsetOn(boolean b) {
        if (b) {
            this.adjustedTopOffsetOn = true;
        }
    }

    public void initAdjustedTopOffset() {
        this.adjustedTopOffsetOn = false;
        this.adjustedTopOffset = 0.0;
    }

    public double getAdjustedBottomOffset() {
        return this.adjustedBottomOffset;
    }

    public void setAdjustedBottomOffset(double d) {
        this.adjustedBottomOffset = Math.max(this.adjustedBottomOffset, d);
    }

    public boolean getAdjustedBottomOffsetOn() {
        return this.adjustedBottomOffsetOn;
    }

    public void setAdjustedBottomOffsetOn(boolean b) {
        if (b) {
            this.adjustedBottomOffsetOn = true;
        }
    }

    public void initAdjustedBottomOffset() {
        this.adjustedBottomOffsetOn = false;
        this.adjustedBottomOffset = 0.0;
    }
}

