/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.QCLayoutOverlayParser;
import com.sas.analytics.qc.statgraph.QCParserUtils;
import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.QCStylizedTextElement;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCScatterOverlay;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class QCScatterParser {
    public static final String RB_KEY = "QCScatterParser.";

    public static QCScatterOverlay load(StatGraph graph, Element elem) {
        QCScatterOverlay scatter = (QCScatterOverlay)((Object)graph.getObjectFromElement(elem));
        if (scatter == null) {
            scatter = new QCScatterOverlay();
        }
        return QCScatterParser.load(graph, scatter, elem) ? scatter : null;
    }

    public static boolean load(StatGraph graph, QCScatterOverlay plot, Element elem) {
        Element roleElement;
        String freqVarID;
        int ii;
        String groupVarID;
        int mscol;
        String str;
        RoleColumnMap map = new RoleColumnMap();
        DataModel m = QCScatterParser.parseXYVariables(plot, graph, elem, map);
        if (m == null) {
            return false;
        }
        boolean ok = true;
        plot.setScaleMarkers(false);
        QCLayoutOverlayParser.parseGraphOpts(graph, elem, plot);
        Element _internal = ParserUtils.getChildWithTagName((String)"_internal", (Element)elem);
        if (!QCScatterParser.loadInternal(graph, plot, _internal)) {
            // empty if block
        }
        if (!StatGraph.VGF && (str = elem.getAttribute("subPixel")).equalsIgnoreCase("off")) {
            plot.setSubpixelOff(true);
        }
        str = elem.getAttribute("primary");
        plot.setPrimary(str.equalsIgnoreCase("true"));
        if (plot.getXAxis().equalsIgnoreCase("x2")) {
            plot.setDiscreteX(QCLayoutOverlayParser.x2AxisType == 2);
        } else {
            plot.setDiscreteX(QCLayoutOverlayParser.xAxisType == 2);
        }
        if (plot.getYAxis().equalsIgnoreCase("y2")) {
            plot.setDiscreteY(QCLayoutOverlayParser.y2AxisType == 2);
        } else {
            plot.setDiscreteY(QCLayoutOverlayParser.yAxisType == 2);
        }
        boolean errorbarUnmapped = false;
        if (plot.isDiscreteX()) {
            if (map.isRoleMapped(26)) {
                map.unmapRole(26);
                errorbarUnmapped = true;
            }
            if (map.isRoleMapped(27)) {
                map.unmapRole(27);
                errorbarUnmapped = true;
            }
        }
        if (plot.isDiscreteY()) {
            if (map.isRoleMapped(28)) {
                map.unmapRole(28);
                errorbarUnmapped = true;
            }
            if (map.isRoleMapped(29)) {
                map.unmapRole(29);
                errorbarUnmapped = true;
            }
        }
        if (errorbarUnmapped) {
            StatGraph.printNote((String)RB.getStringResource((String)RB_KEY, (String)"errorbar.txt"));
        }
        Element labelElem = null;
        Element markerElem = null;
        Element markerFillElem = null;
        Element markerOutlineElem = null;
        Element markerCharacterElem = null;
        Element errorElem = null;
        Element oocLineElem = null;
        Element oocFillElem = null;
        Element oocMarkerElem = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("DataLabelAttrs")) {
                labelElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerCharacterAttrs")) {
                markerCharacterElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerAttrs")) {
                markerElem = (Element)node;
                continue;
            }
            if (elemTag.equals("ErrorBarAttrs")) {
                errorElem = (Element)node;
                continue;
            }
            if (elemTag.equals("OOCLineAttrs")) {
                oocLineElem = (Element)node;
                continue;
            }
            if (elemTag.equals("OOCFillAttrs")) {
                oocFillElem = (Element)node;
                continue;
            }
            if (elemTag.equals("OOCMarkerAttrs")) {
                oocMarkerElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerFillAttrs")) {
                markerFillElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("MarkerOutlineAttrs")) continue;
            markerOutlineElem = (Element)node;
        }
        String oocLineAttr = elem.getAttribute("OOCLineAttrs");
        String oocFillAttr = elem.getAttribute("OOCFillAttrs");
        String oocMarkerAttr = elem.getAttribute("OOCMarkerAttrs");
        String msgVarID = null;
        boolean labelsAsMarkers = false;
        str = elem.getAttribute("markerCharacter");
        if (str.length() > 0) {
            msgVarID = StatGraph.getVarID((String)str);
        }
        if (msgVarID != null && msgVarID.length() > 0) {
            labelsAsMarkers = true;
            int msgcol = m.getColumn(msgVarID);
            map.map(5, msgcol);
            plot.addRole("MARKERCHARACTER", m.getColumnLabel(msgcol));
        }
        boolean gradientMarkerColor = false;
        boolean groupedMarkerColor = false;
        str = elem.getAttribute("markerColorGradient");
        String mcgVarID = StatGraph.getVarID((String)str);
        if (mcgVarID.length() > 0) {
            int mcgcol = m.getColumn(mcgVarID);
            if (StatGraph.checkVariable((String)"MARKERCOLORGRADIENT", (Object)m.getColumnLabel(mcgcol), Double.class, (int)1, (boolean)false)) {
                gradientMarkerColor = true;
                map.map(45, mcgcol);
                plot.addRole("MARKERCOLORGRADIENT", m.getColumnLabel(mcgcol));
                str = elem.getAttribute("markerColorGradientAttrVar");
                if (str.length() > 0) {
                    plot.addAttrVar("MARKERCOLORGRADIENT", (AttrMapper)graph.getRangeAttrVar(str));
                }
            }
        } else {
            groupedMarkerColor = StatGraph.parseMarkerColorGroup((StatGraph)graph, (Element)elem, (RoleColumnMap)map, (DataModel)m, (Overlay)plot);
        }
        boolean markerSizeVar = false;
        str = elem.getAttribute("markerSizeResponse");
        String msVarID = StatGraph.getVarID((String)str);
        if (msVarID.length() > 0 && StatGraph.checkVariable((String)"MARKERSIZERESPONSE", (Object)m.getColumnLabel(mscol = m.getColumn(msVarID)), Double.class, (int)1, (boolean)false)) {
            markerSizeVar = true;
            map.map(7, mscol);
            plot.addRole("MARKERSIZERESPONSE", m.getColumnLabel(mscol));
        }
        String contextName = graph.style.getContextName();
        plot.setContextName(contextName);
        MarkerAttrs ms = new MarkerAttrs();
        String mrkAttr = elem.getAttribute("markerAttrs");
        GraphStyle.setDefaultMarkerStyle((StatGraph)graph, (String)mrkAttr, (MarkerAttrs)ms, (String)contextName);
        int defaultMarkerSize = ms.getSize();
        if (markerElem != null) {
            StatGraph.parseMarkerAttrs((StatGraph)graph, (Element)markerElem, (MarkerAttrs)ms);
        }
        boolean markersVisible = ms.getSize() > 0;
        boolean filledOutlinedMarker = false;
        String mrkFillAttr = elem.getAttribute("markerFillAttrs");
        String mrkOutlineAttr = elem.getAttribute("markerOutlineAttrs");
        str = elem.getAttribute("filledOutlinedMarkers");
        if (str.equalsIgnoreCase("true") && !labelsAsMarkers) {
            plot.setFilledOutlinedMarker(true);
            filledOutlinedMarker = true;
            if (!groupedMarkerColor && (mrkAttr.length() > 0 || markerElem != null && markerElem.hasAttribute("color"))) {
                plot.setUseMarkerAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || markerOutlineElem != null && markerOutlineElem.hasAttribute("color")) {
                plot.setUseMarkerOutlineAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || markerOutlineElem != null && markerOutlineElem.hasAttribute("thickness")) {
                plot.setUseMarkerOutlineAttrsThickness(true);
            }
            GraphStyle.setDefaultFillStyle((StatGraph)graph, (String)mrkFillAttr, (FillAttrs)plot.getMarkerFillStyle(), (String)contextName);
            if (markerFillElem != null) {
                StatGraph.parseFillAttrs((StatGraph)graph, (Element)markerFillElem, (FillAttrs)plot.getMarkerFillStyle());
            }
            GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)mrkOutlineAttr, (LineAttrs)plot.getMarkerOutlineStyle(), (String)contextName);
            if (markerOutlineElem != null) {
                StatGraph.parseLineAttrs((StatGraph)graph, (Element)markerOutlineElem, (LineAttrs)plot.getMarkerOutlineStyle());
            }
        }
        if (QCLayoutOverlayParser.hasTooManyGroups(graph, m, groupVarID = StatGraph.getVarID((String)(str = elem.getAttribute("group"))))) {
            groupVarID = "";
        }
        if (groupVarID.length() > 0) {
            String indexVarID;
            String[] s;
            boolean numericLabel;
            int gcol = m.getColumn(groupVarID);
            boolean bl = numericLabel = m.getColumnClass(gcol) == Double.class;
            if (!numericLabel && (s = m.getStringColumn(gcol)) != null) {
                int num = s.length;
                for (int i = 0; i < num; ++i) {
                    s[i] = QCStylizedTextElement.replaceUnicodeStrings(s[i]);
                }
            }
            if (!gradientMarkerColor) {
                if (labelsAsMarkers) {
                    map.map(45, gcol);
                } else if (filledOutlinedMarker) {
                    map.map(45, gcol);
                    if (!(mrkFillAttr.length() != 0 || markerFillElem != null && markerFillElem.hasAttribute("color"))) {
                        map.map(69, gcol);
                    }
                } else if (!(mrkAttr.length() != 0 || markerElem != null && markerElem.hasAttribute("color"))) {
                    map.map(45, gcol);
                }
            }
            if (!(gradientMarkerColor || mrkAttr.length() != 0 || markerElem != null && markerElem.hasAttribute("color"))) {
                map.map(45, gcol);
            }
            if (!(!markersVisible || labelsAsMarkers || mrkAttr.length() != 0 || markerElem != null && markerElem.hasAttribute("symbol"))) {
                map.map(8, gcol);
            }
            map.map(3, gcol);
            plot.addRole("GROUP", m.getColumnLabel(gcol));
            if ((map.isRoleMapped(8) || map.isRoleMapped(45)) && (str = elem.getAttribute("groupAttrVar")).length() > 0) {
                plot.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
            }
            if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable((String)"INDEX", (Object)m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID((String)str))), Double.class, (int)2, (boolean)true, (boolean)false) && QCScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
                if (map.isRoleMapped(45) && !gradientMarkerColor) {
                    map.map(41, ii);
                }
                if (markersVisible && !labelsAsMarkers && map.isRoleMapped(8)) {
                    map.map(42, ii);
                }
                plot.addRole("INDEX", m.getColumnLabel(ii));
            }
            if ((str = elem.getAttribute("includeMissingGroup")).length() > 0 && str.equalsIgnoreCase("false")) {
                plot.setMissingGroupOn(false);
            }
        }
        if (groupVarID.length() > 0) {
            str = elem.getAttribute("groupOrder");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("Ascending")) {
                    plot.setGroupOrder(1);
                } else if (str.equalsIgnoreCase("Descending")) {
                    plot.setGroupOrder(2);
                } else if (str.equalsIgnoreCase("Data")) {
                    plot.setGroupOrder(0);
                } else {
                    plot.setGroupOrder(0);
                    StatGraph.printOptionError((String)"GROUPORDER", (String)str);
                }
            }
            if (StatGraph.isNumber((String)(str = elem.getAttribute("clusterWidth")))) {
                plot.setClusterWidth(Double.parseDouble(str));
            }
            if ((str = elem.getAttribute("groupDisplay")).equalsIgnoreCase("Cluster")) {
                plot.setGroupDisplay(0);
            } else {
                plot.setGroupDisplay(1);
            }
        }
        StatGraph.parseURLOpt((Element)elem, (DataModel)m, (RoleColumnMap)map, (Overlay)plot);
        boolean labelVisible = false;
        boolean labelingEnabled = true;
        if (labelsAsMarkers) {
            labelVisible = true;
        } else {
            str = elem.getAttribute("dataLabel");
            String labelVarID = StatGraph.getVarID((String)str);
            if (labelVarID.length() > 0) {
                String[] s;
                boolean numericLabel;
                int lcol = m.getColumn(labelVarID);
                boolean bl = numericLabel = m.getColumnClass(lcol) == Double.class;
                if (!numericLabel && (s = m.getStringColumn(lcol)) != null) {
                    int num = s.length;
                    for (int i = 0; i < num; ++i) {
                        s[i] = QCStylizedTextElement.replaceUnicodeStrings(s[i]);
                    }
                }
                map.map(5, lcol);
                labelVisible = true;
                ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(lcol);
                int nms = cmd.getNobs() - cmd.getMissings();
                if (nms == 0) {
                    labelVisible = false;
                    labelingEnabled = false;
                } else {
                    labelVisible = true;
                    boolean bl2 = labelingEnabled = nms <= graph.labelingThreshold;
                    if (!labelingEnabled) {
                        Message msg = new Message(RB.getStringResource((String)"StatGraph.", (String)"labeling.fmt.txt"));
                        StatGraph.printNote((String)msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds((int)nms))), (boolean)false);
                    } else if (cmd.getNobs() > 5 * graph.labelingThreshold) {
                        labelingEnabled = false;
                        Message msg = new Message(RB.getStringResource((String)"StatGraph.", (String)"labeling.fmt.txt"));
                        StatGraph.printNote((String)msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds((int)cmd.getNobs()))), (boolean)false);
                    }
                }
                plot.addRole("DATALABEL", m.getColumnLabel(lcol));
            }
        }
        if (labelVisible) {
            plot.setLabelVisible(true);
        }
        if (!labelsAsMarkers) {
            int position = QCScatterParser.parseDataLabelPosition(elem);
            if (position != -1) {
                labelingEnabled = false;
                plot.setFixedDataLabelPosition(position);
            }
            if (plot.getDataLabelRotate()) {
                plot.setFixedDataLabelPosition(10);
            }
        }
        if ((str = elem.getAttribute("freq")).length() > 0 && StatGraph.checkVariable((String)"FREQ", (Object)m.getColumnLabel(ii = m.getColumn(freqVarID = StatGraph.getVarID((String)str))), Double.class, (boolean)false)) {
            map.map(51, ii);
            plot.addRole("FREQ", m.getColumnLabel(ii));
        }
        if ((roleElement = StatGraph.getOptionAttrsElement((Element)elem, (String)"Roles")) != null) {
            String var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_Y");
            if (m.hasColumn(var)) {
                int col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(792, col);
                plot.addRole("OUTFILL", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SUBGRPLABEL"))) {
                int col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(798, col);
                plot.addRole("SUBGRPLABEL", cmd);
            }
            int xcol = map.getColumn(10);
            int ycol = map.getColumn(11);
            var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_IGRP");
            if (m.hasColumn(var)) {
                int col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(802, col);
                plot.addRole("IGRP", cmd);
                QCShewhart.subsetX(m, xcol, col);
                QCShewhart.subsetY(m, ycol, col);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_OOC"))) {
                int col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(796, col);
                plot.addRole("OOC", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_GROUPPHASE"))) {
                int col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(793, col);
                plot.addRole("GROUPPHASE", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SHAPECOLORINDEX"))) {
                int col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(109, col);
                plot.addRole("ShapeColorIndex", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SHAPEINDEX"))) {
                int col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(42, col);
                plot.addRole("ShapeIndex", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_PLUS"))) {
                int col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(797, col);
                plot.addRole("YVALUEPLUS", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_RUNSTESTINFO"))) {
                int col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(799, col);
                plot.addRole("RUNSTESTINFO", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_GROUPALT"))) {
                int col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(801, col);
                plot.addRole("GROUPALT", cmd);
            }
        }
        QCLayoutOverlayParser.parseRoleTipStuff(elem, m, map, plot);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        QCLayoutOverlayParser.parseWhere(graph, crd, plot);
        plot.setLabelsAsMarkers(labelsAsMarkers);
        if (labelsAsMarkers) {
            plot.setLabelCollisionAvoidance(false);
        } else {
            plot.setLabelCollisionAvoidance(labelingEnabled);
        }
        plot.setGradientMarkerColor(gradientMarkerColor);
        str = elem.getAttribute("dataSelectable");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            plot.setDataSelectable(true);
        }
        if ((str = elem.getAttribute("discreteOffset")).length() > 0 && !QCScatterParser.isDiscreteOffsetSupported(plot)) {
            Message msg = new Message(RB.getStringResource((String)"StatGraph.", (String)"doffset.fmt.txt"));
            StatGraph.printNote((String)msg.toString((Object)str));
        } else if (StatGraph.isNumber((String)str)) {
            double offset = Double.parseDouble(str);
            if (offset >= -0.5 && offset <= 0.5) {
                plot.setDiscreteOffset(offset);
            } else {
                StatGraph.printOptionError((String)"DISCRETEOFFSET", (String)str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError((String)"DISCRETEOFFSET", (String)str);
        }
        str = elem.getAttribute("dataSkin");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("pressed")) {
                plot.setSkinType(3);
            } else if (str.equalsIgnoreCase("sheen")) {
                plot.setSkinType(4);
            } else if (str.equalsIgnoreCase("crisp")) {
                plot.setSkinType(5);
            } else if (str.equalsIgnoreCase("gloss")) {
                plot.setSkinType(6);
            } else if (str.equalsIgnoreCase("matte")) {
                plot.setSkinType(7);
            } else if (str.equalsIgnoreCase("none")) {
                plot.setSkinType(0);
            } else {
                StatGraph.printOptionError((String)"DATASKIN", (String)str);
            }
        }
        plot.setModel(crd);
        if (!markersVisible || labelsAsMarkers) {
            plot.setDefaultMarkerShape((short)-1);
            plot.setDefaultMarkerColor(ms.getColor());
            if (labelsAsMarkers) {
                String mca = elem.getAttribute("markerCharacterAttrs");
                GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)mca, (TextStyle)plot.getMarkerCharacterStyle(), (String)"DataText");
                if (markerCharacterElem != null) {
                    StatGraph.parseTextAttrs((StatGraph)graph, (Element)markerCharacterElem, (TextStyle)plot.getMarkerCharacterStyle());
                    if (markerCharacterElem.hasAttribute("color") && !gradientMarkerColor && map.isRoleMapped(45)) {
                        map.unmapRole(45);
                    }
                } else if (mca.length() > 0 && map.isRoleMapped(45)) {
                    map.unmapRole(45);
                }
            }
        } else {
            plot.setDefaultMarkerColor(ms.getColor());
            if (!QCShewhart.useQCSymbols()) {
                Style style = graph.style.getGraphStyle();
                int[] symbols = style.getDataMarkerSymbols();
                if (symbols[0] == 16) {
                    symbols[0] = 188;
                }
                int defaultSymbol = symbols[0];
                String symbol = markerElem == null ? null : StatGraph.parseAttrString((String)"symbol", (StatGraph)graph, (Element)markerElem);
                int shape = symbol == null ? defaultSymbol : ms.getShape();
                String name = Markers.getShapeName((int)shape);
                plot.setDefaultMarkerShape((short)shape);
            } else if (plot.getFilledOutlinedMarkers()) {
                plot.setDefaultMarkerShape((short)16);
                plot.setDefaultMarkerShape((short)ms.getShape());
            } else {
                plot.setDefaultMarkerShape((short)ms.getShape());
            }
            plot.setDefaultMarkerWeight(ms.getWeight());
            if (!markerSizeVar) {
                plot.setMinMarkerSize(ms.getSize());
                plot.setMaxMarkerSize(ms.getSize());
                plot.setDefaultMarkerScale(0.0);
                int size = Markers.getAdjustedSize((int)ms.getShape(), (int)ms.getSize(), (boolean)true);
                plot.setAdjustedMarkerSize(size);
            } else {
                int minMarker = defaultMarkerSize;
                int maxMarker = 3 * defaultMarkerSize;
                str = elem.getAttribute("markerSizeMin");
                if (StatGraph.isNumber((String)str)) {
                    minMarker = graph.unit2MarkerSize(str);
                } else if (str.indexOf(":") >= 0) {
                    String en = GraphStyle.parseStyleElementName((String)str);
                    String an = GraphStyle.parseStyleAttributeName((String)str);
                    if (en != null) {
                        minMarker = graph.unit2MarkerSize(graph.style.getStyleAttribute(en, an));
                    }
                }
                str = elem.getAttribute("markerSizeMax");
                if (StatGraph.isNumber((String)str)) {
                    maxMarker = graph.unit2MarkerSize(str);
                } else if (str.indexOf(":") >= 0) {
                    String en = GraphStyle.parseStyleElementName((String)str);
                    String an = GraphStyle.parseStyleAttributeName((String)str);
                    if (en != null) {
                        maxMarker = graph.unit2MarkerSize(graph.style.getStyleAttribute(en, an));
                    }
                }
                if (minMarker < maxMarker) {
                    plot.setMinMarkerSize(minMarker);
                    plot.setMaxMarkerSize(maxMarker);
                } else {
                    plot.setMinMarkerSize(defaultMarkerSize);
                    plot.setMaxMarkerSize(3 * defaultMarkerSize);
                    StatGraph.printNote((String)RB.getStringResource((String)RB_KEY, (String)"mmmarker.txt"));
                }
            }
        }
        if (plot.getContext() == QCOverlay.QCResponseContext.BOXMEANSID) {
            plot.setDefaultMarkerShape((short)-1);
        }
        if (labelVisible && !labelsAsMarkers) {
            GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)elem.getAttribute("dataLabelAttrs"), (TextStyle)plot.getLabelStyle(), (String)"DataText");
            if (groupVarID.length() <= 0 && !gradientMarkerColor || StatGraph.isBundleAttributeFixed((Element)elem, (String)"dataLabelAttrs", (String)"color")) {
                if (graph.style.isCycleAttrs()) {
                    plot.getLabelStyle().setColor(ms.getColor());
                }
                plot.setUseLabelColor(true);
            }
            if (labelElem != null) {
                StatGraph.parseTextAttrs((StatGraph)graph, (Element)labelElem, (TextStyle)plot.getLabelStyle());
            }
            if ((str = elem.getAttribute("dataLabelFormat")).length() > 0) {
                plot.setLabelFormat(SASFormat.getInstance((String)str));
            }
        }
        if (StatGraph.isNumber((String)(str = elem.getAttribute("jitter")))) {
            plot.setJitter(Double.parseDouble(str));
        }
        if ((str = elem.getAttribute("useDiscreteSize")).length() > 0 && str.equalsIgnoreCase("true")) {
            plot.setUseDiscreteSizs(true);
        }
        if (StatGraph.isNumber((String)(str = elem.getAttribute("discreteMarkerSize")))) {
            double size = Double.parseDouble(str);
            plot.setDiscreteMarkerSize(size);
        }
        GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)elem.getAttribute("errorBarAttrs"), (LineAttrs)plot.getErrorBarStyle(), (String)"Error");
        if (groupVarID.length() <= 0 || StatGraph.isBundleAttributeFixed((Element)elem, (String)"errorBarAttrs", (String)"color")) {
            plot.setUseErrorBarStyle(1);
        }
        if (errorElem != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)errorElem, (LineAttrs)plot.getErrorBarStyle());
        }
        QCScatterParser.parseSelectionColor(plot, graph);
        QCScatterParser.parseLabelVisibles(plot, elem);
        MarkerAttrs markerStyle = plot.getOOCMarkerAttrs();
        GraphStyle.setDefaultMarkerStyle((StatGraph)graph, (String)oocMarkerAttr, (MarkerAttrs)markerStyle, (String)"RunTest");
        if (oocMarkerElem != null) {
            StatGraph.parseMarkerAttrs((StatGraph)graph, (Element)oocMarkerElem, (MarkerAttrs)markerStyle);
        }
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (crd.isAvailable(45)) {
            if (gradientMarkerColor) {
                ColorEncoder encoder = StatGraph.parseColorModelOpt((byte)16, (StatGraph)graph, (Element)elem, (Overlay)plot);
                if (encoder != null) {
                    plot.setEncoder((byte)16, (Encoder)encoder);
                }
            } else {
                graph.style.setContextCount(contextCount);
                QCLayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)16);
            }
        }
        if (crd.isAvailable(69)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder((StatGraph)graph, (Overlay)plot, (byte)24, (double)plot.getMarkerTransparency(), (!groupedMarkerColor ? 1 : 0) != 0);
        }
        if (crd.isAvailable(8)) {
            graph.style.setContextCount(contextCount);
            QCLayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)6);
        }
        if (crd.isAvailable(26)) {
            QCLayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)7);
        }
        if (crd.isAvailable(27)) {
            QCLayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)8);
        }
        if (crd.isAvailable(28)) {
            QCLayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)9);
        }
        if (crd.isAvailable(29)) {
            QCLayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)10);
        }
        if (QCLayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    private static boolean isDiscreteOffsetSupported(QCScatterOverlay plot) {
        return plot.isDiscreteX() || plot.isDiscreteY();
    }

    public static void parseSelectionColor(QCScatterOverlay plot, StatGraph graph) {
        MarkerAttrs ms = new MarkerAttrs();
        GraphStyle.setDefaultMarkerStyle((StatGraph)graph, (String)"", (MarkerAttrs)ms, (String)"Selection");
    }

    public static void parseLabelVisibles(QCScatterOverlay plot, Element elem) {
        String str = elem.getAttribute("invisiblePointLabels");
        if (str.length() > 0) {
            int[] obs = StatGraph.parseList2Int((String)str);
            plot.setInitialHideLabelObs(obs);
        }
    }

    public static DataModel parseXYVariables(QCScatterOverlay plot, StatGraph graph, Element elem, RoleColumnMap map) {
        String xelVarID;
        int xelcol;
        String xeuVarID;
        int xeucol;
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName((String)str);
        String xVarID = StatGraph.getVarID((String)str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID((String)str);
        DataModel model = graph.getData(dataName);
        int xcol = model.getColumn(xVarID);
        int ycol = model.getColumn(yVarID);
        switch (plot.getPlotType()) {
            case 0: {
                if (!StatGraph.checkVariable((String)"X", (Object)model.getColumnLabel(xcol), null, (int)1, (boolean)true)) {
                    return null;
                }
                if (StatGraph.checkVariable((String)"Y", (Object)model.getColumnLabel(ycol), null, (int)1, (boolean)true)) break;
                return null;
            }
            case 1: {
                str = elem.getAttribute("orient");
                if (str.equalsIgnoreCase("horizontal")) {
                    int t = xcol;
                    xcol = ycol;
                    ycol = t;
                    plot.setVerticalFill(false);
                }
                if (!StatGraph.checkVariable((String)"X", (Object)model.getColumnLabel(xcol), null, (int)1, (boolean)true)) {
                    return null;
                }
                if (StatGraph.checkVariable((String)"Y", (Object)model.getColumnLabel(ycol), null, (int)1, (boolean)true)) break;
                return null;
            }
            case 5: {
                str = elem.getAttribute("orient");
                String cat = "X";
                String res = "Y";
                int catcol = xcol;
                int rescol = ycol;
                if (str.equalsIgnoreCase("horizontal")) {
                    int t = xcol;
                    xcol = ycol;
                    ycol = t;
                    plot.setVerticalFill(false);
                    cat = "Y";
                    res = "X";
                    catcol = ycol;
                    rescol = xcol;
                }
                if (!StatGraph.checkVariable((String)cat, (Object)model.getColumnLabel(catcol), null, (int)1, (boolean)true)) {
                    return null;
                }
                if (StatGraph.checkVariable((String)res, (Object)model.getColumnLabel(rescol), Double.class, (int)1, (boolean)true)) break;
                return null;
            }
            case 2: 
            case 3: {
                if (!StatGraph.checkVariable((String)"X", (Object)model.getColumnLabel(xcol), null, (int)1, (boolean)true)) {
                    return null;
                }
                if (StatGraph.checkVariable((String)"Y", (Object)model.getColumnLabel(ycol), Double.class, (int)1, (boolean)true)) break;
                return null;
            }
            case 4: {
                if (!StatGraph.checkVariable((String)"X", (Object)model.getColumnLabel(xcol), Double.class, (int)1, (boolean)true)) {
                    return null;
                }
                if (StatGraph.checkVariable((String)"Y", (Object)model.getColumnLabel(ycol), Double.class, (int)1, (boolean)true)) break;
                return null;
            }
        }
        map.map(10, xcol);
        map.map(11, ycol);
        plot.addRole("X", model.getColumnLabel(xcol));
        plot.addRole("Y", model.getColumnLabel(ycol));
        str = elem.getAttribute("xErrorUpper");
        if (str.length() > 0 && StatGraph.checkVariable((String)"XERRORUPPER", (Object)model.getColumnLabel(xeucol = model.getColumn(xeuVarID = StatGraph.getVarID((String)str))), Double.class, (boolean)false)) {
            map.map(26, xeucol);
            plot.addRole("XERRORUPPER", model.getColumnLabel(xeucol));
        }
        if ((str = elem.getAttribute("xErrorLower")).length() > 0 && StatGraph.checkVariable((String)"XERRORLOWER", (Object)model.getColumnLabel(xelcol = model.getColumn(xelVarID = StatGraph.getVarID((String)str))), Double.class, (boolean)false)) {
            map.map(27, xelcol);
            plot.addRole("XERRORLOWER", model.getColumnLabel(xelcol));
        }
        if ((str = elem.getAttribute("yErrorUpper")).length() > 0) {
            String yeuVarID = StatGraph.getVarID((String)str);
            int yeucol = model.getColumn(yeuVarID);
            if (StatGraph.checkVariable((String)"YERRORUPPER", (Object)model.getColumnLabel(yeucol), Double.class, (boolean)false)) {
                map.map(28, yeucol);
                plot.addRole("YERRORUPPER", model.getColumnLabel(yeucol));
            }
        } else {
            String euVarID;
            int eucol;
            str = elem.getAttribute("errorUpper");
            if (str.length() > 0 && StatGraph.checkVariable((String)"ERRORUPPER", (Object)model.getColumnLabel(eucol = model.getColumn(euVarID = StatGraph.getVarID((String)str))), Double.class, (boolean)false)) {
                map.map(28, eucol);
                plot.addRole("ERRORUPPER", model.getColumnLabel(eucol));
            }
        }
        str = elem.getAttribute("yErrorLower");
        if (str.length() > 0) {
            String yelVarID = StatGraph.getVarID((String)str);
            int yelcol = model.getColumn(yelVarID);
            if (StatGraph.checkVariable((String)"YERRORLOWER", (Object)model.getColumnLabel(yelcol), Double.class, (boolean)false)) {
                map.map(29, yelcol);
                plot.addRole("YERRORLOWER", model.getColumnLabel(yelcol));
            }
        } else {
            String elVarID;
            int elcol;
            str = elem.getAttribute("errorLower");
            if (str.length() > 0 && StatGraph.checkVariable((String)"ERRORLOWER", (Object)model.getColumnLabel(elcol = model.getColumn(elVarID = StatGraph.getVarID((String)str))), Double.class, (boolean)false)) {
                map.map(29, elcol);
                plot.addRole("ERRORLOWER", model.getColumnLabel(elcol));
            }
        }
        return model;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int[] types = new int[3];
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName((String)str);
        String xVarID = StatGraph.getVarID((String)str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID((String)str);
        DataModel model = graph.getData(dataName);
        int xcol = model.getColumn(xVarID);
        int ycol = model.getColumn(yVarID);
        ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(xcol);
        if (cmd.getType() == 2) {
            if (QCLayoutOverlayParser.valueCountHasExceededMaximum(model, xVarID, graph.discreteMax)) {
                return null;
            }
            types[0] = 2;
        } else {
            types[0] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        }
        cmd = (ColumnMetadata)model.getColumnLabel(ycol);
        if (cmd.getType() == 2) {
            if (QCLayoutOverlayParser.valueCountHasExceededMaximum(model, yVarID, graph.discreteMax)) {
                return null;
            }
            types[1] = 2;
        } else {
            types[1] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        }
        types[2] = 0;
        return types;
    }

    protected static int parseDataLabelPosition(Element elem) {
        String str = elem.getAttribute("dataLabelPosition");
        if (str.equalsIgnoreCase("QC")) {
            return 9;
        }
        if (str.equalsIgnoreCase("QC_ROTATED")) {
            return 10;
        }
        if (str.equalsIgnoreCase("QC_ROTATED_TOP")) {
            return 11;
        }
        if (str.equalsIgnoreCase("QC_ROTATED_BOTTOM")) {
            return 12;
        }
        if (str.equalsIgnoreCase("AUTO")) {
            return -1;
        }
        if (str.equalsIgnoreCase("TOP")) {
            return 0;
        }
        if (str.equalsIgnoreCase("BOTTOM")) {
            return 1;
        }
        if (str.equalsIgnoreCase("LEFT")) {
            return 2;
        }
        if (str.equalsIgnoreCase("RIGHT")) {
            return 3;
        }
        if (str.equalsIgnoreCase("CENTER")) {
            return 4;
        }
        if (str.equalsIgnoreCase("TOPLEFT")) {
            return 5;
        }
        if (str.equalsIgnoreCase("TOPRIGHT")) {
            return 6;
        }
        if (str.equalsIgnoreCase("BOTTOMLEFT")) {
            return 7;
        }
        if (str.equalsIgnoreCase("BOTTOMRIGHT")) {
            return 8;
        }
        if (str.length() > 0) {
            StatGraph.printOptionError((String)"DATALABELPOSITION", (String)str);
        }
        return 9;
    }

    public static boolean checkIndexColumn(DataModel m, int col, String option, String colName) {
        boolean ok = true;
        double[] data = m.getDoubleColumn(col);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == (double)((int)data[i])) continue;
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"index.fmt.txt"));
            StatGraph.printWarning((String)msg.toString((Object)option, (Object)colName));
            return false;
        }
        return ok;
    }

    static boolean loadInternal(StatGraph graph, QCScatterOverlay plot, Element _internal) {
        Element child;
        if (_internal == null) {
            // empty if block
        }
        boolean b = QCParserUtils.getBoolean("phaseBoxResponse", _internal, false);
        plot.setPhaseBoxResponse(b);
        int i = QCOverlay.QCOutfillType.toInteger(QCOverlay.QCOutfillType.FALSE);
        i = QCParserUtils.getInteger("outFill", _internal, i);
        plot.setOOCFillType(QCOverlay.QCOutfillType.fromInteger(i));
        b = QCParserUtils.getBoolean("expandFilledOutlinedMarkers", _internal, false);
        plot.setExpandFilledOutlinedMarkers(b);
        b = QCParserUtils.getBoolean("legendMarkers", _internal, true);
        plot.setLegendMarkers(b);
        b = QCParserUtils.getBoolean("dataLabelRotate", _internal, false);
        plot.setDataLabelRotate(b);
        i = QCOverlay.QCOutlineType.toInteger(QCOverlay.QCOutlineType.FALSE);
        i = QCParserUtils.getInteger("outLine", _internal, i);
        plot.setOOCLineType(QCOverlay.QCOutlineType.fromInteger(i));
        b = QCParserUtils.getBoolean("maximizeInnerMargin", _internal, false);
        plot.setMaximizeInnerMargin(b);
        i = QCParserUtils.getInteger("context", _internal, -1);
        QCOverlay.QCResponseContext context = QCOverlay.QCResponseContext.fromInteger(i, QCOverlay.QCResponseContext.Y);
        plot.setContext(context);
        b = QCParserUtils.getBoolean("scaleMarkers", _internal, false);
        plot.setQCScaling(b);
        double d = QCParserUtils.getDouble("interval", _internal, -1.0);
        if (d > 0.0) {
            plot.setInterval(d);
        }
        d = plot.getDataTransparency();
        d = QCParserUtils.getDouble("labelTransparency", _internal, d);
        plot.setLabelTransparency(d);
        b = QCParserUtils.getBoolean("dataLabelBox", _internal, false);
        plot.setDataLabelBox(b);
        b = QCParserUtils.getBoolean("dataLabelRotate", _internal, false);
        plot.setDataLabelRotate(b);
        d = QCParserUtils.getDouble("dataLabelThreshold", _internal, Double.NaN);
        plot.setDataLabelThreshold(d);
        b = QCParserUtils.getBoolean("hideLegendItems", _internal, false);
        plot.setHideLegendItems(b);
        Element element = child = _internal == null ? null : ParserUtils.getChildWithTagName((String)"LegendItems", (Element)_internal);
        if (child != null) {
            String name = null;
            String type = null;
            String label = null;
            double key = -1.0;
            NodeList nodes = child.getElementsByTagName("Item");
            int n = nodes == null ? 0 : nodes.getLength();
            for (int j = 0; j < n; ++j) {
                child = (Element)nodes.item(j);
                name = QCParserUtils.getString("name", child, null);
                type = QCParserUtils.getString("type", child, null);
                key = QCParserUtils.getDouble("key", child, -1.0);
                label = ParserUtils.getElementText((Element)child);
                label = QCStylizedTextElement.replaceUStrings(label);
            }
        }
        return true;
    }
}

