/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBlockOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCReferenceLineOverlay;
import com.sas.graphics.applets.statgraph.BandParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.labeling.SALabeling;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class QCReferenceLineParser {
    public static final String RB_KEY = "QCReferenceLineParser.";

    public static QCReferenceLineOverlay load(StatGraph graph, Element elem, int autoCurveLabelPosition, QCBlockOverlay phase) {
        QCReferenceLineOverlay line = (QCReferenceLineOverlay)((Object)graph.getObjectFromElement(elem));
        if (line == null) {
            line = new QCReferenceLineOverlay();
        }
        return QCReferenceLineParser.load(graph, line, elem, autoCurveLabelPosition, phase) ? line : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean load(StatGraph graph, QCReferenceLineOverlay line, Element elem, int autoCurveLabelPosition, QCBlockOverlay phase) {
        boolean curveLabeled;
        String str;
        block79: {
            Object cmd;
            int col;
            String var;
            String yVarID;
            String xVarID;
            String dataName;
            block84: {
                block78: {
                    int type;
                    block83: {
                        block77: {
                            block82: {
                                dataName = null;
                                xVarID = null;
                                yVarID = null;
                                str = elem.getAttribute("y");
                                if (str.length() <= 0) break block77;
                                type = StatGraph.getAttributeType((Element)elem, (String)"y");
                                if (type >= 0) break block82;
                                if (StatGraph.getDataName((String)str).length() > 0) {
                                    if (dataName == null) {
                                        dataName = StatGraph.getDataName((String)str);
                                    }
                                    yVarID = StatGraph.getVarID((String)str);
                                    break block77;
                                } else if (line.isDiscreteY()) {
                                    line.setYValue(QCReferenceLineParser.trimMissing(str));
                                    break block77;
                                } else {
                                    if (!StatGraph.isNumber((String)str)) {
                                        Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"y.fmt.txt"));
                                        StatGraph.printWarning((String)msg.toString((Object)str));
                                        graph.removeNamedGraph((Overlay)line);
                                        return false;
                                    }
                                    line.setYValue(new Double(str));
                                }
                                break block77;
                            }
                            if (type == 0) {
                                if (dataName == null) {
                                    dataName = StatGraph.getDataName((String)str);
                                }
                                yVarID = StatGraph.getVarID((String)str);
                            } else if (type == 1) {
                                if (!line.isDiscreteY()) {
                                    Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"y.fmt.txt"));
                                    StatGraph.printWarning((String)msg.toString((Object)("'" + str + "'")));
                                    graph.removeNamedGraph((Overlay)line);
                                    return false;
                                }
                                line.setYValue(QCReferenceLineParser.trimMissing(str));
                            } else if (line.isDiscreteY()) {
                                line.setYValue(QCReferenceLineParser.trimMissing(str));
                            } else {
                                if (!StatGraph.isNumber((String)str)) return false;
                                line.setYValue(new Double(str));
                            }
                        }
                        if ((str = elem.getAttribute("x")).length() <= 0) break block78;
                        type = StatGraph.getAttributeType((Element)elem, (String)"x");
                        if (type >= 0) break block83;
                        if (StatGraph.getDataName((String)str).length() > 0) {
                            if (dataName == null) {
                                dataName = StatGraph.getDataName((String)str);
                            }
                            xVarID = StatGraph.getVarID((String)str);
                            break block78;
                        } else if (line.isDiscreteX()) {
                            line.setXValue(QCReferenceLineParser.trimMissing(str));
                            break block78;
                        } else {
                            if (!StatGraph.isNumber((String)str)) {
                                Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"x.fmt.txt"));
                                StatGraph.printWarning((String)msg.toString((Object)str));
                                graph.removeNamedGraph((Overlay)line);
                                return false;
                            }
                            line.setXValue(new Double(str));
                        }
                        break block78;
                    }
                    if (type == 0) {
                        if (dataName == null) {
                            dataName = StatGraph.getDataName((String)str);
                        }
                        xVarID = StatGraph.getVarID((String)str);
                    } else if (type == 1) {
                        if (!line.isDiscreteX()) {
                            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"x.fmt.txt"));
                            StatGraph.printWarning((String)msg.toString((Object)("'" + str + "'")));
                            graph.removeNamedGraph((Overlay)line);
                            return false;
                        }
                        line.setXValue(QCReferenceLineParser.trimMissing(str));
                    } else if (line.isDiscreteX()) {
                        line.setXValue(QCReferenceLineParser.trimMissing(str));
                    } else {
                        if (!StatGraph.isNumber((String)str)) return false;
                        line.setXValue(new Double(str));
                    }
                }
                curveLabeled = false;
                StatGraph.printError((String)("dataName = " + dataName), (boolean)true);
                if (dataName != null && dataName.length() > 0) break block84;
                str = elem.getAttribute("curveLabel");
                if (str.length() > 0) {
                    int type = StatGraph.getAttributeType((Element)elem, (String)"curveLabel");
                    if (type < 0) {
                        line.setCurveLabelString(str);
                        curveLabeled = true;
                        break block79;
                    } else if (type != 0) {
                        line.setCurveLabelString(str);
                        curveLabeled = true;
                        break block79;
                    } else {
                        Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"label2.fmt.txt"));
                        StatGraph.printNote((String)msg.toString((Object)StatGraph.getVarID((String)str)));
                    }
                }
                break block79;
            }
            DataModel m = graph.getData(dataName);
            RoleColumnMap map = new RoleColumnMap();
            if (yVarID != null) {
                int ycol = m.getColumn(yVarID);
                if (!line.isDiscreteY() && !StatGraph.checkVariable((String)"y", (Object)m.getColumnLabel(ycol), Double.class, (boolean)true)) {
                    graph.removeNamedGraph((Overlay)line);
                    return false;
                }
                map.map(11, ycol);
                line.addRole("Y", m.getColumnLabel(ycol));
            }
            if (xVarID != null) {
                int xcol = m.getColumn(xVarID);
                if (!line.isDiscreteX() && !StatGraph.checkVariable((String)"x", (Object)m.getColumnLabel(xcol), Double.class, (boolean)true)) {
                    graph.removeNamedGraph((Overlay)line);
                    return false;
                }
                map.map(10, xcol);
                line.addRole("X", m.getColumnLabel(xcol));
            }
            boolean phaseVRefs = phase != null && yVarID != null ? phase.hasVRefs() : false;
            boolean phaseSRefs = phase != null && yVarID != null ? phase.hasSRefs() : false;
            StatGraph.printError((String)("phase = " + (Object)((Object)phase)), (boolean)true);
            StatGraph.printError((String)("yVarID = " + yVarID), (boolean)true);
            StatGraph.printError((String)("phaseRefs = " + phaseVRefs), (boolean)true);
            line.phase = null;
            if (phaseVRefs) {
                var = phase.getVRefPhaseVar();
                if (m.hasColumn(var)) {
                    col = m.getColumn(var);
                    cmd = m.getColumnLabel(col);
                    map.map(783, col);
                    line.addRole("VREF_PHASE", cmd);
                    line.phase = phase;
                }
                var = phase.getVRefIndexVar();
                StatGraph.printError((String)("var = " + var), (boolean)true);
                if (m.hasColumn(var)) {
                    col = m.getColumn(var);
                    cmd = m.getColumnLabel(col);
                    map.map(784, col);
                    line.addRole("VREF_PHASEINDEX", cmd);
                    line.phase = phase;
                }
            }
            if (phaseSRefs) {
                var = phase.getSRefPhaseVar();
                if (m.hasColumn(var)) {
                    col = m.getColumn(var);
                    cmd = m.getColumnLabel(col);
                    map.map(785, col);
                    line.addRole("SREF_PHASE", cmd);
                    line.phase = phase;
                }
                var = phase.getSRefIndexVar();
                StatGraph.printError((String)("var = " + var), (boolean)true);
                if (m.hasColumn(var)) {
                    col = m.getColumn(var);
                    cmd = m.getColumnLabel(col);
                    map.map(786, col);
                    line.addRole("SREF_PHASEINDEX", cmd);
                    line.phase = phase;
                }
            }
            if ((str = elem.getAttribute("curveLabel")).length() > 0) {
                int clcol;
                String curveLabelVarID;
                int type = StatGraph.getAttributeType((Element)elem, (String)"curveLabel");
                if (type < 0) {
                    curveLabelVarID = StatGraph.getVarID((String)str);
                    if (m.hasColumn(curveLabelVarID)) {
                        clcol = m.getColumn(curveLabelVarID);
                        map.map(48, clcol);
                        curveLabeled = true;
                    } else {
                        Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"label.fmt.txt"));
                        StatGraph.printNote((String)msg.toString((Object)str));
                    }
                } else if (type == 0) {
                    curveLabelVarID = StatGraph.getVarID((String)str);
                    if (m.hasColumn(curveLabelVarID)) {
                        clcol = m.getColumn(curveLabelVarID);
                        map.map(48, clcol);
                        curveLabeled = true;
                    }
                } else {
                    Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"label.fmt.txt"));
                    String val = type == 2 ? str : "'" + str + "'";
                    StatGraph.printNote((String)msg.toString((Object)val));
                }
            }
            CRD crd = new CRD();
            crd.setSrcModel(m);
            crd.setSrcMap(map);
            LayoutOverlayParser.parseWhere((StatGraph)graph, (CRD)crd, (Overlay)line);
            line.setModel(crd);
        }
        StatGraph.parseDataSkinOpt((StatGraph)graph, (Element)elem, (Overlay)line);
        LineAttrs ls = line.getLineStyle();
        GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)elem.getAttribute("lineAttrs"), (LineAttrs)ls, (String)"Reference");
        TextStyle labelStyle = null;
        if (curveLabeled) {
            str = elem.getAttribute("curveLabelLocation");
            if (str.equalsIgnoreCase("INSIDE")) {
                line.setCurveLabelLocation(0);
            } else if (str.equalsIgnoreCase("OUTSIDE")) {
                if (BandParser.isUnderLatticeLayout((Element)elem)) {
                    line.setCurveLabelLocation(0);
                    StatGraph.printNote((String)RB.getStringResource((String)RB_KEY, (String)"outsidelabel.txt"));
                } else {
                    line.setCurveLabelLocation(1);
                }
            } else {
                if (BandParser.isUnderLatticeLayout((Element)elem)) {
                    line.setCurveLabelLocation(0);
                } else {
                    line.setCurveLabelLocation(1);
                }
                if (str.length() > 0) {
                    StatGraph.printOptionError((String)"CURVELABELLOCATION", (String)str);
                }
            }
            str = elem.getAttribute("curveLabelPosition");
            if (str.equalsIgnoreCase("MIN")) {
                line.setCurveLabelPosition(0);
            } else if (str.equalsIgnoreCase("MAX")) {
                line.setCurveLabelPosition(1);
            } else if (str.equalsIgnoreCase("AUTO")) {
                line.setCurveLabelPosition(autoCurveLabelPosition);
            } else {
                line.setCurveLabelPosition(autoCurveLabelPosition);
                if (str.length() > 0) {
                    StatGraph.printOptionError((String)"CURVELABELPOSITION", (String)str);
                }
            }
            labelStyle = new TextStyle();
            GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)elem.getAttribute("curveLabelAttrs"), (TextStyle)labelStyle, (String)"ValueText");
            line.setLabelStyle(labelStyle);
            str = elem.getAttribute("curveLabelFormat");
            if (str.length() > 0) {
                SASFormat lf = SASFormat.getInstance((String)str);
                line.setLabelFormat(lf);
            }
            ScatterParser.parseCurveLabelSplitting((StatGraph)graph, (Overlay)line, (Element)elem);
        }
        if ((str = elem.getAttribute("clip")).length() > 0 && str.equalsIgnoreCase("true")) {
            line.setClipping(true);
        }
        if (graph.isSALabeling()) {
            line.setProtectedLine(SALabeling.getWeight((HashMap)graph.getSAWeightMap(), (String)"OBSTACLE") > 0.0);
        } else {
            line.setProtectedLine(false);
        }
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("CurveLabelAttrs") && labelStyle != null) {
                StatGraph.parseTextAttrs((StatGraph)graph, (Element)((Element)node), (TextStyle)labelStyle);
                continue;
            }
            if (!elemTag.equals("LineAttrs")) continue;
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)((Element)node), (LineAttrs)ls);
        }
        str = elem.getAttribute("discreteOffset");
        if (str.length() > 0 && !QCReferenceLineParser.isDiscreteOffsetSupported(line)) {
            Message msg = new Message(RB.getStringResource((String)"StatGraph.", (String)"doffset.fmt.txt"));
            StatGraph.printNote((String)msg.toString((Object)str));
            return true;
        }
        if (!StatGraph.isNumber((String)str)) {
            if (str.length() <= 0) return true;
            StatGraph.printOptionError((String)"DISCRETEOFFSET", (String)str);
            return true;
        }
        double offset = Double.parseDouble(str);
        if (offset >= -0.5 && offset <= 0.5) {
            line.setDiscreteOffset(offset);
            return true;
        }
        StatGraph.printOptionError((String)"DISCRETEOFFSET", (String)str);
        return true;
    }

    static boolean isDiscreteOffsetSupported(QCReferenceLineOverlay line) {
        return line.isDiscreteX() || line.isDiscreteY();
    }

    public static String trimMissing(String str) {
        if (str.trim().length() == 0) {
            str = str.trim();
        }
        return str;
    }
}

