/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.QCParserUtils;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBlockOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCPhaseOverlay;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.gtk.TextStyle;
import java.awt.Color;
import java.util.Objects;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class QCPhaseParser {
    public static final String RB_KEY = "QCPhaseParser.";

    public static QCPhaseOverlay load(StatGraph graph, Element elem, Element qcPhaseInternal) {
        QCPhaseOverlay phase = (QCPhaseOverlay)((Object)graph.getObjectFromElement(elem));
        if (phase == null) {
            phase = new QCPhaseOverlay();
        }
        return QCPhaseParser.load(graph, phase, elem, qcPhaseInternal) ? phase : null;
    }

    public static boolean load(StatGraph graph, QCPhaseOverlay plot, Element e, Element qcPhaseInternal) {
        String dataName = StatGraph.getDataName((String)e.getAttribute("xStart"));
        DataModel m = graph.getData(dataName);
        if (m == null) {
            return false;
        }
        RoleColumnMap map = new RoleColumnMap();
        boolean ok = true;
        if (qcPhaseInternal != null) {
            ok = QCPhaseParser.loadInternal(plot, graph, qcPhaseInternal, map, m);
        }
        if (!ok) {
            return false;
        }
        String var = e.getAttribute("xStart");
        String varID = StatGraph.getVarID((String)var);
        int col = m.getColumn(varID);
        Object cLabel = m.getColumnLabel(col);
        if (!StatGraph.checkVariable((String)"XSTART", (Object)cLabel, null, (int)1, (boolean)true)) {
            graph.removeNamedGraph((Overlay)plot);
            return false;
        }
        map.map(754, col);
        plot.addRole("XSTART", cLabel);
        var = e.getAttribute("xEnd");
        varID = StatGraph.getVarID((String)var);
        col = m.getColumn(varID);
        cLabel = m.getColumnLabel(col);
        if (!StatGraph.checkVariable((String)"XEND", (Object)cLabel, null, (int)1, (boolean)true)) {
            graph.removeNamedGraph((Overlay)plot);
            return false;
        }
        map.map(755, col);
        plot.addRole("XEND", cLabel);
        var = e.getAttribute("phaseIndex");
        boolean valid = StatGraph.isValidVar((String)var);
        if (valid) {
            varID = StatGraph.getVarID((String)var);
            col = m.getColumn(varID);
            cLabel = m.getColumnLabel(col);
            if (!StatGraph.checkVariable((String)"PHASEINDEX", (Object)cLabel, null, (int)1, (boolean)true)) {
                graph.removeNamedGraph((Overlay)plot);
                return false;
            }
            map.map(765, col);
            plot.addRole("PHASEINDEX", cLabel);
        }
        if (valid = StatGraph.isValidVar((String)(var = e.getAttribute("phaseValue")))) {
            varID = StatGraph.getVarID((String)var);
            col = m.getColumn(varID);
            cLabel = m.getColumnLabel(col);
            if (!StatGraph.checkVariable((String)"PHASEVALUE", (Object)cLabel, null, (int)1, (boolean)true)) {
                graph.removeNamedGraph((Overlay)plot);
                return false;
            }
            map.map(766, col);
            plot.addRole("PHASEVALUE", cLabel);
        }
        if (valid = StatGraph.isValidVar((String)(var = e.getAttribute("class")))) {
            varID = StatGraph.getVarID((String)var);
            col = m.getColumn(varID);
            cLabel = m.getColumnLabel(col);
            if (!StatGraph.checkVariable((String)"PHASELABEL", (Object)cLabel, null, (int)1, (boolean)true)) {
                graph.removeNamedGraph((Overlay)plot);
                return false;
            }
            map.map(767, col);
            plot.addRole("PHASELABEL", cLabel);
        }
        String contextName = graph.style.getContextName();
        plot.setContextName(contextName);
        TextStyle uni = new TextStyle();
        GraphStyle.setDefaultTextStyle((StatGraph)graph, null, (TextStyle)uni, (String)"UnicodeText");
        plot.setUnicodeLabelStyle(uni);
        FillAttrs fs = plot.getBackgroundAttrs();
        GraphStyle.setDefaultFillStyle((StatGraph)graph, (String)e.getAttribute("backgroundAttrs"), (FillAttrs)fs, (String)"Backfill");
        Element e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"BackgroundAttrs");
        if (e2 != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)e2, (FillAttrs)fs);
        }
        LineAttrs ls = plot.getBorderAttrs();
        GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)e.getAttribute("axisAttrs"), (LineAttrs)ls, (String)"AxisLines");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"AxisAttrs");
        if (e2 != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)e2, (LineAttrs)ls);
        }
        TextStyle ts = plot.getTextStyle();
        GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)e.getAttribute("valueAttrs"), (TextStyle)ts, (String)"ValueText");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"ValueAttrs");
        if (e2 != null) {
            StatGraph.parseTextAttrs((StatGraph)graph, (Element)e2, (TextStyle)ts);
        }
        fs = plot.getBlockAttrs();
        GraphStyle.setDefaultFillStyle((StatGraph)graph, (String)e.getAttribute("blockAttrs"), (FillAttrs)fs, (String)"Block");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"BlockAttrs");
        if (e2 != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)e2, (FillAttrs)fs);
        }
        fs = plot.getAltBlockAttrs();
        GraphStyle.setDefaultFillStyle((StatGraph)graph, (String)e.getAttribute("altBlockAttrs"), (FillAttrs)fs, (String)"AltBlock");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"AltBlockAttrs");
        if (e2 != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)e2, (FillAttrs)fs);
        }
        fs = plot.getHeaderAttrs();
        GraphStyle.setDefaultFillStyle((StatGraph)graph, (String)e.getAttribute("headerAttrs"), (FillAttrs)fs, (String)"AltBlock");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"HeaderAttrs");
        if (e2 != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)e2, (FillAttrs)fs);
        }
        Color color = ColorUtilities.brighter((Color)plot.getAltBlockAttrs().getColor());
        fs.setColor(color);
        ls = plot.getRefLineAttrs();
        GraphStyle.setDefaultLineStyle((StatGraph)graph, null, (LineAttrs)ls, (String)"Reference");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"ReferenceLineAttrs");
        if (e2 != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)e2, (LineAttrs)ls);
        }
        fs = plot.getRefFillAttrs();
        GraphStyle.setDefaultFillStyle((StatGraph)graph, null, (FillAttrs)fs, (String)"GraphDataStyleDefault");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"DataDefaultAttrs");
        if (e2 != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)e2, (FillAttrs)fs);
        }
        LineAttrs grid = new LineAttrs();
        GraphStyle.setDefaultLineStyle((StatGraph)graph, null, (LineAttrs)grid, (String)"GridLines");
        fs = plot.getAltRefFillAttrs();
        fs.setColor(grid.getColor());
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere((StatGraph)graph, (CRD)crd, (Overlay)plot);
        plot.setModel(crd);
        return true;
    }

    static boolean loadInternal(QCPhaseOverlay plot, StatGraph graph, Element _internal, RoleColumnMap map, DataModel model) {
        boolean nPhases = false;
        int nIndex = 0;
        if (_internal == null) {
            return false;
        }
        boolean b = QCParserUtils.getBoolean("show", _internal, true);
        plot.setLegend(b);
        b = QCParserUtils.getBoolean("phaseBoxResponse", _internal, false);
        plot.setPhaseBoxResponse(b);
        int i = QCParserUtils.getInteger("position", _internal);
        QCBlockOverlay.LegendPosition position = QCBlockOverlay.LegendPosition.fromInteger(i, QCBlockOverlay.LegendPosition.MAX);
        plot.setLegendPosition(position);
        b = QCParserUtils.getBoolean("frame", _internal, true);
        plot.setFrame(b);
        b = true;
        plot.setHFrame(b);
        b = true;
        plot.setLegendFill(b);
        b = QCParserUtils.getBoolean("separate", _internal, true);
        plot.setVFrame(b);
        b = QCParserUtils.getBoolean("showLabels", _internal, true);
        plot.setLabels(b);
        b = false;
        plot.setRepeat(b);
        i = QCParserUtils.getInteger("labelPosition", _internal);
        QCBlockOverlay.LabelPosition labelPos = QCBlockOverlay.LabelPosition.fromInteger(i, QCBlockOverlay.LabelPosition.NONE);
        plot.setLabelPosition(labelPos);
        i = QCParserUtils.getInteger("labelType", _internal);
        QCBlockOverlay.LabelFit labelFit = QCBlockOverlay.LabelFit.fromInteger(i, QCBlockOverlay.LabelFit.TRUNCATED);
        plot.setFitType(labelFit);
        b = QCParserUtils.getBoolean("border", _internal, true);
        plot.setLegendOutline(b);
        b = QCParserUtils.getBoolean("limits", _internal, true);
        plot.setPhaseLimits(b);
        b = QCParserUtils.getBoolean("refLines", _internal, true);
        plot.setRefLine(b);
        i = QCParserUtils.getInteger("refLineType", _internal, 1);
        plot.setRefLineType(i);
        b = QCParserUtils.getBoolean("refFill", _internal, true);
        plot.setRefFill(b);
        double d = QCParserUtils.getOpacity("refFillOpacity", _internal, 0.15f);
        plot.setRefFillOpacity((float)d);
        b = QCParserUtils.getBoolean("lineBreak", _internal, false);
        plot.setPhaseBreak(b);
        Element child = ParserUtils.getChildWithTagName((String)"Indices", (Element)_internal);
        if (child != null) {
            NodeList nodes = child.getElementsByTagName("Index");
            nIndex = nodes.getLength();
            if (nIndex == 0) {
                return false;
            }
            boolean[] tracks = new boolean[]{false, false, false};
            int ilevel = 1;
            QCPhaseOverlay qCPhaseOverlay = plot;
            Objects.requireNonNull(qCPhaseOverlay);
            QCBlockOverlay.Block phase = new QCBlockOverlay.Block(qCPhaseOverlay, QCBlockOverlay.BlockType.PHASE);
            nPhases = true;
            phase.fillType = QCParserUtils.getString("fillType", _internal, "Alternate");
            for (i = 0; i < nIndex; ++i) {
                child = (Element)nodes.item(i);
                QCBlockOverlay.BlockEntry entry = new QCBlockOverlay.BlockEntry(plot);
                entry.first = QCParserUtils.getInteger("first", child) - 1;
                entry.last = QCParserUtils.getInteger("last", child) - 1;
                entry.limits = QCParserUtils.getBoolean("limits", child, true);
                ++entry.last;
                ilevel = ilevel == 0 ? 1 : 0;
                entry.level = QCParserUtils.getInteger("level", child, ilevel);
                entry.alternate = entry.level % 2 == 0 ? 0 : 1;
                _internal = ParserUtils.getChildWithTagName((String)"Labels", (Element)child);
                if (_internal != null) {
                    NodeList labels = _internal.getElementsByTagName("Label");
                    int n = labels.getLength();
                    for (int j = 0; j < n; ++j) {
                        Vector v;
                        child = (Element)labels.item(j);
                        String s = QCParserUtils.getAttributedText(child, v = new Vector());
                        if (s == null || s.length() <= 0) continue;
                        tracks[j] = true;
                    }
                }
                phase.nEntries = nIndex;
                phase.entries.add(entry);
            }
            plot.addBlock(phase);
        }
        return nPhases;
    }
}

