/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.QCLayoutOverlayParser;
import com.sas.analytics.qc.statgraph.QCParserUtils;
import com.sas.analytics.qc.statgraph.QCScatterParser;
import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCNeedleOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCScatterOverlay;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class QCNeedleParser {
    public static final String RB_KEY = "QCNeedleParser.";

    public static QCNeedleOverlay load(StatGraph graph, Element elem) {
        QCNeedleOverlay needle = (QCNeedleOverlay)((Object)graph.getObjectFromElement(elem));
        if (needle == null) {
            needle = new QCNeedleOverlay();
        }
        return QCNeedleParser.load(graph, needle, elem) ? needle : null;
    }

    public static boolean load(StatGraph graph, QCNeedleOverlay plot, Element elem) {
        Element ba;
        int col;
        Element roleElement;
        String indexVarID;
        int ii;
        RoleColumnMap map = new RoleColumnMap();
        DataModel m = QCScatterParser.parseXYVariables(plot, graph, elem, map);
        if (m == null) {
            return false;
        }
        boolean ok = true;
        QCLayoutOverlayParser.parseGraphOpts(graph, elem, plot);
        Element _internal = ParserUtils.getChildWithTagName((String)"_internal", (Element)elem);
        if (!QCNeedleParser.loadInternal(graph, plot, _internal)) {
            // empty if block
        }
        String str = elem.getAttribute("primary");
        plot.setPrimary(str.equalsIgnoreCase("true"));
        if (plot.getXAxis().equalsIgnoreCase("x2")) {
            plot.setDiscreteX(QCLayoutOverlayParser.x2AxisType == 2);
        } else {
            plot.setDiscreteX(QCLayoutOverlayParser.xAxisType == 2);
        }
        str = elem.getAttribute("group");
        String groupVarID = StatGraph.getVarID((String)str);
        if (QCLayoutOverlayParser.hasTooManyGroups(graph, m, groupVarID)) {
            groupVarID = "";
        }
        Element labelElem = null;
        Element lineElem = null;
        Element markerElem = null;
        Element markerFillElem = null;
        Element markerOutlineElem = null;
        Element oocLineElem = null;
        Element oocFillElem = null;
        Element oocMarkerElem = null;
        Element runTestElem = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("DataLabelAttrs")) {
                labelElem = (Element)node;
                continue;
            }
            if (elemTag.equals("LineAttrs")) {
                lineElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerAttrs")) {
                markerElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerFillAttrs")) {
                markerFillElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerOutlineAttrs")) {
                markerOutlineElem = (Element)node;
                continue;
            }
            if (elemTag.equals("OOCLineAttrs")) {
                oocLineElem = (Element)node;
                continue;
            }
            if (elemTag.equals("OOCFillAttrs")) {
                oocFillElem = (Element)node;
                continue;
            }
            if (elemTag.equals("OOCMarkerAttrs")) {
                oocMarkerElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("RunTestAttrs")) continue;
            runTestElem = (Element)node;
        }
        String lineAttr = elem.getAttribute("lineAttrs");
        String mrkAttr = elem.getAttribute("markerAttrs");
        String mrkFillAttr = elem.getAttribute("markerFillAttrs");
        String mrkOutlineAttr = elem.getAttribute("markerOutlineAttrs");
        String oocLineAttr = elem.getAttribute("OOCLineAttrs");
        String oocFillAttr = elem.getAttribute("OOCFillAttrs");
        String oocMarkerAttr = elem.getAttribute("OOCMarkerAttrs");
        if (mrkAttr.length() > 0 || markerElem != null && markerElem.hasAttribute("size")) {
            plot.setUseMarkerSize(true);
        }
        boolean hasMarkers = StatGraph.parseDisplayMarkers((Element)elem);
        boolean filledOutlinedMarker = false;
        str = elem.getAttribute("filledOutlinedMarkers");
        if (str.equalsIgnoreCase("true")) {
            plot.setFilledOutlinedMarker(true);
            filledOutlinedMarker = true;
            if (mrkAttr.length() > 0 || markerElem != null && markerElem.hasAttribute("color")) {
                plot.setUseMarkerAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || markerOutlineElem != null && markerOutlineElem.hasAttribute("color")) {
                plot.setUseMarkerOutlineAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || markerOutlineElem != null && markerOutlineElem.hasAttribute("thickness")) {
                plot.setUseMarkerOutlineAttrsThickness(true);
            }
        }
        if (groupVarID.length() > 0) {
            int gcol = m.getColumn(groupVarID);
            boolean groupMapped = false;
            if (!(lineElem != null && lineElem.hasAttribute("color") || lineAttr.length() != 0)) {
                map.map(46, gcol);
                groupMapped = true;
            }
            if (!(lineElem != null && lineElem.hasAttribute("pattern") || lineAttr.length() != 0)) {
                map.map(36, gcol);
                groupMapped = true;
            }
            if (hasMarkers) {
                groupMapped = StatGraph.mapMarkerRoles((StatGraph)graph, (Element)elem, (RoleColumnMap)map, (Element)markerElem, (String)mrkAttr, (int)gcol, (boolean)groupMapped, (DataModel)m, (Overlay)plot);
                if (filledOutlinedMarker) {
                    if (!map.isRoleMapped(45) && map.isRoleMapped(46)) {
                        map.map(45, gcol);
                    }
                    if (!(map.isRoleMapped(69) || mrkFillAttr.length() != 0 || markerFillElem != null && markerFillElem.hasAttribute("color"))) {
                        map.map(69, gcol);
                    }
                }
            }
            map.map(3, gcol);
            plot.addRole("GROUP", m.getColumnLabel(gcol));
            if (groupMapped && (str = elem.getAttribute("groupAttrVar")).length() > 0) {
                plot.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
            }
            if ((str = elem.getAttribute("includeMissingGroup")).length() > 0 && str.equalsIgnoreCase("false")) {
                plot.setMissingGroupOn(false);
            }
        }
        if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable((String)"INDEX", (Object)m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID((String)str))), Double.class, (int)2, (boolean)true, (boolean)false) && ScatterParser.checkIndexColumn((DataModel)m, (int)ii, (String)"INDEX", (String)indexVarID)) {
            if (map.isRoleMapped(46) || map.isRoleMapped(45)) {
                map.map(41, ii);
            }
            if (map.isRoleMapped(36)) {
                map.map(43, ii);
            }
            if (map.isRoleMapped(8)) {
                map.map(42, ii);
            }
            plot.addRole("INDEX", m.getColumnLabel(ii));
        }
        if (groupVarID.length() > 0) {
            str = elem.getAttribute("groupOrder");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("Ascending")) {
                    plot.setGroupOrder(1);
                } else if (str.equalsIgnoreCase("Descending")) {
                    plot.setGroupOrder(2);
                } else if (str.equalsIgnoreCase("Data")) {
                    plot.setGroupOrder(0);
                } else {
                    plot.setGroupOrder(0);
                    StatGraph.printOptionError((String)"GROUPORDER", (String)str);
                }
            }
            if (StatGraph.isNumber((String)(str = elem.getAttribute("clusterWidth")))) {
                plot.setClusterWidth(Double.parseDouble(str));
            }
            if ((str = elem.getAttribute("groupDisplay")).equalsIgnoreCase("Cluster")) {
                plot.setGroupDisplay(0);
            } else {
                plot.setGroupDisplay(1);
            }
        }
        StatGraph.parseURLOpt((Element)elem, (DataModel)m, (RoleColumnMap)map, (Overlay)plot);
        str = elem.getAttribute("dataLabel");
        String labelVarID = StatGraph.getVarID((String)str);
        boolean labelVisible = false;
        boolean labelingEnabled = false;
        if (labelVarID.length() > 0) {
            int lcol = m.getColumn(labelVarID);
            map.map(5, lcol);
            ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(lcol);
            int nms = cmd.getNobs() - cmd.getMissings();
            if (nms == 0) {
                labelVisible = false;
                labelingEnabled = false;
            } else {
                Message msg;
                labelVisible = true;
                boolean bl = labelingEnabled = nms <= graph.labelingThreshold;
                if (!labelingEnabled) {
                    msg = new Message(RB.getStringResource((String)"StatGraph.", (String)"labeling.fmt.txt"));
                    StatGraph.printNote((String)msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds((int)nms))), (boolean)false);
                } else if (cmd.getNobs() > 5 * graph.labelingThreshold) {
                    labelingEnabled = false;
                    msg = new Message(RB.getStringResource((String)"StatGraph.", (String)"labeling.fmt.txt"));
                    StatGraph.printNote((String)msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds((int)cmd.getNobs()))), (boolean)false);
                }
            }
            plot.addRole("DATALABEL", m.getColumnLabel(lcol));
        }
        if ((roleElement = StatGraph.getOptionAttrsElement((Element)elem, (String)"Roles")) != null) {
            String var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_Y");
            if (m.hasColumn(var)) {
                col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(792, col);
                plot.addRole("OUTFILL", cmd);
            }
            int xcol = map.getColumn(10);
            int ycol = map.getColumn(11);
            var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_IGRP");
            if (m.hasColumn(var)) {
                col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(802, col);
                plot.addRole("IGRP", cmd);
                QCShewhart.subsetX(m, xcol, col);
                QCShewhart.subsetY(m, ycol, col);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SUBGRPLABEL"))) {
                col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(798, col);
                plot.addRole("SUBGRPLABEL", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_OOC"))) {
                col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(796, col);
                plot.addRole("OOC", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_GROUPPHASE"))) {
                col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(793, col);
                plot.addRole("GROUPPHASE", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_PLUS"))) {
                col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(797, col);
                plot.addRole("YVALUEPLUS", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_RUNSTESTINFO"))) {
                col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(799, col);
                plot.addRole("RUNSTESTINFO", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_GROUPALT"))) {
                col = m.getColumn(var);
                Object cmd = m.getColumnLabel(col);
                map.map(801, col);
                plot.addRole("GROUPALT", cmd);
            }
        }
        QCLayoutOverlayParser.parseRoleTipStuff(elem, m, map, plot);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere((StatGraph)graph, (CRD)crd, (Overlay)plot);
        str = elem.getAttribute("dataSelectable");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            plot.setDataSelectable(true);
        }
        if ((str = elem.getAttribute("baselineIntercept")).length() > 0) {
            if (str.equalsIgnoreCase("RELATIVE")) {
                plot.setRelativeNeedle(true);
            } else if (StatGraph.isNumber((String)str)) {
                plot.setNeedleBase(Double.parseDouble(str));
            } else {
                String var = StatGraph.getVarID((String)str);
                if (m.hasColumn(var)) {
                    col = m.getColumn(var);
                    Object cLabel = m.getColumnLabel(col);
                    map.map(788, col);
                    plot.addRole("NEEDLEBASE", cLabel);
                    plot.setNeedleBase(Double.NaN);
                } else {
                    StatGraph.printOptionError((String)"BASELINEINTERCEPT", (String)str);
                    plot.setNeedleBase(0.0);
                }
            }
        }
        if ((ba = StatGraph.getOptionAttrsElement((Element)elem, (String)"BaselineAttrs")) != null || elem.hasAttribute("baselineAttrs")) {
            GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)elem.getAttribute("baselineAttrs"), (LineAttrs)plot.getBaselineStyle(), (String)"AxisLines");
            if (ba != null) {
                StatGraph.parseLineAttrs((StatGraph)graph, (Element)ba, (LineAttrs)plot.getBaselineStyle());
            }
        } else {
            plot.setBaselineStyle(null);
        }
        if ((str = elem.getAttribute("discreteOffset")).length() > 0 && !QCNeedleParser.isDiscreteOffsetSupported(plot)) {
            Message msg = new Message(RB.getStringResource((String)"StatGraph.", (String)"doffset.fmt.txt"));
            StatGraph.printNote((String)msg.toString((Object)str));
        } else if (StatGraph.isNumber((String)str)) {
            double offset = Double.parseDouble(str);
            if (offset >= -0.5 && offset <= 0.5) {
                plot.setDiscreteOffset(offset);
            } else {
                StatGraph.printOptionError((String)"DISCRETEOFFSET", (String)str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError((String)"DISCRETEOFFSET", (String)str);
        }
        plot.setModel(crd);
        String contextName = graph.style.getContextName();
        plot.setContextName(contextName);
        if (hasMarkers) {
            MarkerAttrs ms = new MarkerAttrs();
            GraphStyle.setDefaultMarkerStyle((StatGraph)graph, (String)mrkAttr, (MarkerAttrs)ms, (String)contextName);
            if (markerElem != null) {
                StatGraph.parseMarkerAttrs((StatGraph)graph, (Element)markerElem, (MarkerAttrs)ms);
            }
            plot.setDefaultMarkerColor(ms.getColor());
            plot.setDefaultMarkerShape((short)ms.getShape());
            plot.setMinMarkerSize(ms.getSize());
            plot.setMaxMarkerSize(ms.getSize());
            plot.setDefaultMarkerScale(0.0);
        } else {
            plot.setDefaultMarkerShape((short)-1);
        }
        LineAttrs ls = plot.getLineStyle();
        GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)lineAttr, (LineAttrs)ls, (String)contextName);
        if (lineElem != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)lineElem, (LineAttrs)ls);
            if (groupVarID.length() > 0 && lineElem.hasAttribute("color") && (markerElem == null || !markerElem.hasAttribute("color"))) {
                plot.setDefaultMarkerColor(ls.getColor());
            }
        }
        ls = plot.getOOCLineStyle();
        GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)oocLineAttr, (LineAttrs)ls, (String)"KPIRange1");
        if (oocLineElem != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)oocLineElem, (LineAttrs)ls);
        }
        plot.setNeedleVisible(true);
        if (labelVisible) {
            int position = QCScatterParser.parseDataLabelPosition(elem);
            plot.setFixedDataLabelPosition(position);
            if (position != -1) {
                labelingEnabled = false;
            }
            if (position == 9) {
                labelingEnabled = false;
            }
            if (plot.getDataLabelRotate()) {
                labelingEnabled = false;
                plot.setFixedDataLabelPosition(10);
            }
            plot.setLabelVisible(true);
            plot.setLabelCollisionAvoidance(labelingEnabled);
            GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)elem.getAttribute("dataLabelAttrs"), (TextStyle)plot.getLabelStyle(), (String)"DataText");
            if (groupVarID.length() <= 0 || StatGraph.isBundleAttributeFixed((Element)elem, (String)"dataLabelAttrs", (String)"color")) {
                if (graph.style.isCycleAttrs()) {
                    plot.getLabelStyle().setColor(plot.getLineStyle().getColor());
                }
                plot.setUseLabelColor(true);
            }
            if (labelElem != null) {
                StatGraph.parseTextAttrs((StatGraph)graph, (Element)labelElem, (TextStyle)plot.getLabelStyle());
            }
            if ((str = elem.getAttribute("dataLabelFormat")).length() > 0) {
                plot.setLabelFormat(SASFormat.getInstance((String)str));
            }
        }
        if ((str = elem.getAttribute("dataLabelProtected")).equalsIgnoreCase("true")) {
            plot.setProtectedNeedle(true);
        } else {
            plot.setProtectedNeedle(false);
        }
        QCScatterParser.parseSelectionColor(plot, graph);
        QCScatterParser.parseLabelVisibles(plot, elem);
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        int startContrastColorIndex = -1;
        if (crd.isAvailable(46)) {
            graph.style.setContextCount(contextCount);
            startContrastColorIndex = graph.style.getContrastColorCount();
            QCLayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)17);
        }
        if (crd.isAvailable(36)) {
            graph.style.setContextCount(contextCount);
            QCLayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)15);
        }
        if (crd.isAvailable(45)) {
            graph.style.setContextCount(contextCount);
            if (startContrastColorIndex >= 0) {
                graph.style.setContrastColorCount(startContrastColorIndex);
            }
            QCLayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)16);
        }
        if (crd.isAvailable(8)) {
            graph.style.setContextCount(contextCount);
            QCLayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)6);
        }
        if (QCLayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    static boolean isDiscreteOffsetSupported(QCScatterOverlay plot) {
        return plot.isDiscreteX();
    }

    static boolean loadInternal(StatGraph graph, QCNeedleOverlay plot, Element _internal) {
        if (_internal == null) {
            // empty if block
        }
        boolean debug = QCParserUtils.getBoolean("debug", _internal, false);
        boolean rotate = QCParserUtils.getBoolean("rotate", _internal, false);
        boolean b = QCParserUtils.getBoolean("phaseBoxResponse", _internal, false);
        plot.setPhaseBoxResponse(b);
        int i = QCOverlay.QCOutlineType.toInteger(QCOverlay.QCOutlineType.TRUE);
        i = QCParserUtils.getInteger("outLine", _internal, i);
        plot.setOOCLineType(QCOverlay.QCOutlineType.fromInteger(i));
        b = QCParserUtils.getBoolean("scaleMarkers", _internal, true);
        plot.setQCScaling(b);
        b = QCParserUtils.getBoolean("maximizeInnerMargin", _internal, true);
        plot.setMaximizeInnerMargin(b);
        i = QCParserUtils.getInteger("context", _internal, -1);
        QCOverlay.QCResponseContext type = QCOverlay.QCResponseContext.fromInteger(i, QCOverlay.QCResponseContext.Y);
        plot.setContext(type);
        plot.setNeedleBaseVisible(false);
        double d = QCParserUtils.getDouble("interval", _internal, -1.0);
        if (d > 0.0) {
            plot.setInterval(d);
        }
        d = plot.getDataTransparency();
        d = QCParserUtils.getDouble("labelTransparency", _internal, d);
        plot.setLabelTransparency(d);
        b = QCParserUtils.getBoolean("dataLabelBox", _internal, false);
        plot.setDataLabelBox(b);
        b = QCParserUtils.getBoolean("dataLabelRotate", _internal, false);
        plot.setDataLabelRotate(b);
        d = QCParserUtils.getDouble("dataLabelThreshold", _internal, Double.NaN);
        plot.setDataLabelThreshold(d);
        b = QCParserUtils.getBoolean("hideLegendItems", _internal, false);
        plot.setHideLegendItems(b);
        return true;
    }
}

