/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.QCLayoutOverlayParser;
import com.sas.analytics.qc.statgraph.QCParserUtils;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBoxParmOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BlockOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.NumericFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class QCBoxParmParser {
    public static final String RB_KEY = "QCBoxParmParser.";

    public static QCBoxParmOverlay load(StatGraph graph, Element elem) {
        QCBoxParmOverlay plot = (QCBoxParmOverlay)((Object)graph.getObjectFromElement(elem));
        if (plot == null) {
            plot = new QCBoxParmOverlay();
        }
        return QCBoxParmParser.load(graph, plot, elem) ? plot : null;
    }

    public static boolean load(StatGraph graph, QCBoxParmOverlay plot, Element e) {
        int i;
        String[] opts;
        String indexVarID;
        int ii;
        QCLayoutOverlayParser.parseGraphOpts(graph, e, plot);
        Element _internal = ParserUtils.getChildWithTagName((String)"_internal", (Element)e);
        if (!QCBoxParmParser.loadInternal(graph, plot, _internal)) {
            // empty if block
        }
        String str = e.getAttribute("primary");
        plot.setPrimary(str.equalsIgnoreCase("true"));
        str = e.getAttribute("y");
        String dataName = StatGraph.getDataName((String)str);
        String yVarID = StatGraph.getVarID((String)str);
        str = e.getAttribute("stat");
        String sVarID = StatGraph.getVarID((String)str);
        str = e.getAttribute("x");
        String xVarID = StatGraph.getVarID((String)str);
        str = e.getAttribute("dataLabel");
        String lVarID = StatGraph.getVarID((String)str);
        str = e.getAttribute("group");
        String gVarID = StatGraph.getVarID((String)str);
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        int ycol = m.getColumn(yVarID);
        if (!StatGraph.checkVariable((String)"Y", (Object)m.getColumnLabel(ycol), Double.class, (int)2, (boolean)true)) {
            graph.removeNamedGraph((Overlay)plot);
            return false;
        }
        map.map(11, ycol);
        plot.addRole("Y", m.getColumnLabel(ycol));
        int scol = m.getColumn(sVarID);
        if (!StatGraph.checkVariable((String)"STAT", (Object)m.getColumnLabel(scol), String.class, (int)-1, (boolean)true, (boolean)true)) {
            graph.removeNamedGraph((Overlay)plot);
            return false;
        }
        map.map(47, scol);
        plot.addRole("STAT", m.getColumnLabel(scol));
        int xcol = m.getColumn(xVarID);
        if (!StatGraph.checkVariable((String)"X", (Object)m.getColumnLabel(xcol), null, (int)2, (boolean)true)) {
            graph.removeNamedGraph((Overlay)plot);
            return false;
        }
        map.map(10, xcol);
        plot.addRole("X", m.getColumnLabel(xcol));
        Element roleElement = StatGraph.getOptionAttrsElement((Element)e, (String)"Roles");
        ColumnMetadata cmd = null;
        DataModel m2 = null;
        RoleColumnMap map2 = new RoleColumnMap();
        boolean internal_outline = false;
        if (roleElement != null) {
            int col;
            String var;
            String data2Name = QCLayoutOverlayParser.getRoleDataName(roleElement, "INTERNAL_IGRP");
            m2 = graph.getData(data2Name);
            if (data2Name != null && m2 != null && m2.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_IGRP"))) {
                col = m2.getColumn(var);
                cmd = (ColumnMetadata)m2.getColumnLabel(col);
                map2.map(802, col);
                plot.addRole("IGRP", cmd);
            }
            data2Name = QCLayoutOverlayParser.getRoleDataName(roleElement, "INTERNAL_SUBGRPLABEL");
            m2 = graph.getData(data2Name);
            if (data2Name != null && m2 != null && m2.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SUBGRPLABEL"))) {
                col = m2.getColumn(var);
                cmd = (ColumnMetadata)m2.getColumnLabel(col);
                map2.map(798, col);
                plot.addRole("SUBGRPLABEL", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_OUTLINE"))) {
                col = m.getColumn(var);
                cmd = (ColumnMetadata)m.getColumnLabel(col);
                map.map(46, col);
                plot.addRole("LINECOLOR", cmd);
                map.map(45, col);
                map.map(68, col);
                internal_outline = true;
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_OUTLINEINDEX"))) {
                col = m.getColumn(var);
                cmd = (ColumnMetadata)m.getColumnLabel(col);
                map.map(795, col);
                plot.addRole("LINECOLORINDEX", cmd);
                internal_outline = true;
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_OOC"))) {
                col = m.getColumn(var);
                cmd = (ColumnMetadata)m.getColumnLabel(col);
            }
        }
        boolean labelsOn = false;
        if (!lVarID.equals("")) {
            int lcol = m.getColumn(lVarID);
            map.map(5, lcol);
            labelsOn = true;
            plot.addRole("DATALABEL", m.getColumnLabel(lcol));
        }
        if (!gVarID.equals("")) {
            int gcol = m.getColumn(gVarID);
            map.map(3, gcol);
            map.map(6, gcol);
            map.map(36, gcol);
            if (!internal_outline) {
                map.map(46, gcol);
                map.map(45, gcol);
                map.map(68, gcol);
            }
            map.map(8, gcol);
            plot.addRole("GROUP", m.getColumnLabel(gcol));
            str = e.getAttribute("includeMissingGroup");
            if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                plot.setMissingGroupOn(false);
            }
            if ((str = e.getAttribute("groupAttrVar")).length() > 0) {
                plot.addAttrVar("TUKEYGROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                plot.addAttrVar("OUTLIERGROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
            }
            if ((str = e.getAttribute("groupOrder")).length() > 0) {
                if (str.equalsIgnoreCase("Ascending")) {
                    plot.setGroupFillOrder(1);
                } else if (str.equalsIgnoreCase("Descending")) {
                    plot.setGroupFillOrder(2);
                } else if (str.equalsIgnoreCase("Data")) {
                    plot.setGroupFillOrder(0);
                } else {
                    plot.setGroupFillOrder(0);
                    StatGraph.printOptionError((String)"GROUPORDER", (String)str);
                }
            }
        }
        if ((str = e.getAttribute("index")).length() > 0 && StatGraph.checkVariable((String)"INDEX", (Object)m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID((String)str))), Double.class, (int)2, (boolean)true, (boolean)false) && ScatterParser.checkIndexColumn((DataModel)m, (int)ii, (String)"INDEX", (String)indexVarID)) {
            map.map(44, ii);
            plot.addRole("INDEX", m.getColumnLabel(ii));
        }
        QCBoxParmParser.parseRoleTipStuff(e, m, map, plot);
        StatGraph.parseURLOpt((Element)e, (DataModel)m, (RoleColumnMap)map, (Overlay)plot);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        CRD crd2 = null;
        if (m2 != null) {
            crd2 = new CRD();
            crd2.setSrcModel(m2);
            crd2.setSrcMap(map2);
        }
        if (StatGraph.isNumber((String)(str = e.getAttribute("panelByCount")))) {
            StatGraph.MPC = Integer.parseInt(str);
        }
        String oldWhereExp = graph.whereExpression;
        String oldModel = graph.whereDataModelName;
        StringVariable[] oldWhereVars = graph.whereVars;
        if (StatGraph.MPC > 0) {
            int page = 0;
            str = e.getAttribute("panelNumber");
            if (str.length() > 0) {
                if (!StatGraph.isNumber((String)str)) {
                    Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"page.fmt.txt"));
                    StatGraph.printWarning((String)msg.toString((Object)str));
                    graph.removeNamedGraph((Overlay)plot);
                    return false;
                }
                page = Integer.parseInt(str) - 1;
                if (page < 0) {
                    Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"page.fmt.txt"));
                    StatGraph.printWarning((String)msg.toString((Object)str));
                    graph.removeNamedGraph((Overlay)plot);
                    return false;
                }
            }
            graph.whereDataModelName = crd.getSrcModel().name;
            xcol = crd.getSrcModel().getColumn(xVarID);
            cmd = (ColumnMetadata)crd.getSrcModel().getColumnLabel(xcol);
            StringVectorVariable xWhereVar = new StringVectorVariable();
            xWhereVar.setName(cmd.getName());
            xWhereVar.setLabel(cmd.getLabel());
            xWhereVar.connectFrom(crd.getSrcModel().getColumnAsClassColumn(xcol, StatGraph.includeMissingDiscrete));
            graph.whereExpression = QCBoxParmParser.buildWhereExpression(xWhereVar, StatGraph.MPC, page, graph);
            graph.whereVars = new StringVectorVariable[]{xWhereVar};
        }
        if (graph.whereExpression != null) {
            LayoutOverlayParser.parseWhere((StatGraph)graph, (CRD)crd, (Overlay)plot);
        }
        graph.whereExpression = oldWhereExp;
        graph.whereDataModelName = oldModel;
        graph.whereVars = oldWhereVars;
        str = e.getAttribute("orient");
        if (str.equalsIgnoreCase("Horizontal")) {
            plot.setOrientation(1);
        } else if (str.equalsIgnoreCase("Vertical")) {
            plot.setOrientation(0);
        } else {
            plot.setOrientation(0);
            if (str.length() > 0) {
                StatGraph.printOptionError((String)"ORIENT", (String)str);
            }
        }
        str = e.getAttribute("sortRole");
        if (str.length() > 0 && str.equalsIgnoreCase("x")) {
            crd.setSortRole(10);
        }
        if (labelsOn && (str = e.getAttribute("labelFar")).equalsIgnoreCase("true")) {
            plot.setLabelFar(true);
        }
        if ((str = e.getAttribute("spread")).equalsIgnoreCase("true")) {
            plot.setSpread(true);
        }
        if (plot.getOrientation() == 0) {
            if (plot.getXAxis().equalsIgnoreCase("x2")) {
                plot.setDiscreteX(QCLayoutOverlayParser.x2AxisType == 2);
            } else {
                plot.setDiscreteX(QCLayoutOverlayParser.xAxisType == 2);
            }
        } else if (plot.getYAxis().equalsIgnoreCase("y2")) {
            plot.setDiscreteX(QCLayoutOverlayParser.y2AxisType == 2);
        } else {
            plot.setDiscreteX(QCLayoutOverlayParser.yAxisType == 2);
        }
        StatGraph.parseDataSkinOpt((StatGraph)graph, (Element)e, (Overlay)plot);
        GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)e.getAttribute("outlineAttrs"), (LineAttrs)plot.getOutlineStyle(), (String)"Outlines");
        str = e.getAttribute("display");
        boolean fill = false;
        boolean tips = true;
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                QCBoxParmParser.setDisplayAll(plot, true);
            } else if (str.equalsIgnoreCase("none")) {
                QCBoxParmParser.setDisplayAll(plot, false);
            } else {
                opts = StatGraph.parseList2String((String)str);
                QCBoxParmParser.setDisplayAll(plot, false);
                for (i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("connect")) {
                        plot.setConnectOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("caps")) {
                        plot.setCapOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        fill = true;
                        plot.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("median")) {
                        plot.setMedianOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("mean")) {
                        plot.setMeanOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("outliers")) {
                        plot.setMarkersOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("clip")) continue;
                    if (opts[i].equalsIgnoreCase("notches")) {
                        plot.setNotched(true);
                        continue;
                    }
                    QCBoxParmParser.setDisplayAll(plot, true);
                    StatGraph.printOptionError((String)"DISPLAY", (String)opts[i]);
                    break;
                }
            }
        } else {
            str = graph.style.getStyleAttribute("Box", "displayOpts");
            if (str != null) {
                opts = StatGraph.parseList2String((String)str);
                QCBoxParmParser.setDisplayAll(plot, false);
                for (i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("connect")) {
                        plot.setConnectOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("caps")) {
                        plot.setCapOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        fill = true;
                        plot.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("median")) {
                        plot.setMedianOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("mean")) {
                        plot.setMeanOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("outliers")) {
                        plot.setMarkersOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("clip") || !opts[i].equalsIgnoreCase("notches")) continue;
                    plot.setNotched(true);
                }
                if (!QCBoxParmParser.isBoxOn(plot)) {
                    plot.setCapOn(true);
                    plot.setFillOn(true);
                    plot.setMeanOn(true);
                    plot.setMedianOn(true);
                    plot.setMarkersOn(true);
                }
            }
        }
        if (tips && !fill) {
            plot.setFillOn(true);
            plot.setTransparentFill(true);
        }
        plot.setModel(crd, crd2);
        LineAttrs lineAttrs = null;
        FillAttrs fillAttrs = null;
        FillAttrs oocFillAttrs = null;
        String contextName = graph.style.getContextName();
        plot.setContextName(contextName);
        if (plot.getFillOn()) {
            fillAttrs = plot.getFillStyle();
            GraphStyle.setDefaultDataFillStyle((StatGraph)graph, (String)e.getAttribute("fillAttrs"), (FillAttrs)fillAttrs, (String)contextName);
            oocFillAttrs = plot.getOOCFillStyle();
            GraphStyle.setDefaultDataFillStyle((StatGraph)graph, (String)e.getAttribute("oocFillAttrs"), (FillAttrs)oocFillAttrs, (String)"RunTest");
        }
        lineAttrs = plot.getOOCLineStyle();
        if (plot.getFillOn() && !plot.getTransparentFill()) {
            GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)e.getAttribute("oocOutLineAttrs"), (LineAttrs)lineAttrs, (String)"Outlines");
        } else {
            GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)e.getAttribute("oocOutLineAttrs"), (LineAttrs)lineAttrs, (String)"KPIRange1");
        }
        if (plot.isCapOn()) {
            int capShape = 1;
            str = e.getAttribute("capShape");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("line")) {
                    capShape = 2;
                } else if (str.equalsIgnoreCase("bracket")) {
                    capShape = 3;
                } else if (str.equalsIgnoreCase("serif")) {
                    capShape = 1;
                } else if (str.equalsIgnoreCase("none")) {
                    capShape = 0;
                } else {
                    StatGraph.printOptionError((String)"CAPSHAPE", (String)str);
                }
            } else {
                str = graph.style.getStyleAttribute("Box", "capStyle");
                if (str != null) {
                    if (str.equalsIgnoreCase("line")) {
                        capShape = 2;
                    } else if (str.equalsIgnoreCase("bracket")) {
                        capShape = 3;
                    }
                }
            }
            plot.setCapShape(capShape);
        }
        if (plot.isWhiskersOn()) {
            GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)e.getAttribute("whiskerAttrs"), (LineAttrs)plot.getWhiskerStyle(), (String)"BoxWhisker");
        }
        if (plot.isMedianOn()) {
            GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)e.getAttribute("medianAttrs"), (LineAttrs)plot.getMedianStyle(), (String)"BoxMedian");
        }
        MarkerAttrs meanStyle = null;
        if (plot.isMeanOn()) {
            meanStyle = new MarkerAttrs();
            GraphStyle.setDefaultMarkerStyle((StatGraph)graph, null, (MarkerAttrs)meanStyle, (String)"BoxMean");
            Color defaultColor = meanStyle.getColor();
            GraphStyle.setDefaultMarkerStyle((StatGraph)graph, (String)e.getAttribute("meanAttrs"), (MarkerAttrs)meanStyle, (String)"BoxMean");
            Color meanColor = meanStyle.getColor();
            plot.setMeanColor(meanColor);
            plot.setMeanSymbol(meanStyle.getShape());
            plot.setMeanSize(meanStyle.getSize());
            plot.setMeanWeight(meanStyle.getWeight());
            int rgb1 = defaultColor.getRGB();
            int rgb2 = meanColor.getRGB();
            if (rgb1 == rgb2) {
                MarkerAttrs gd1Style = new MarkerAttrs();
                GraphStyle.setDefaultMarkerStyle((StatGraph)graph, null, (MarkerAttrs)gd1Style, (String)"GraphDataStyle1");
                plot.setMeanColor(gd1Style.getColor());
            }
        }
        boolean extreme = false;
        str = e.getAttribute("extreme");
        if (str.equalsIgnoreCase("true")) {
            extreme = true;
            plot.setExtreme(extreme);
        }
        MarkerAttrs outlierStyle = null;
        if (plot.isMarkersOn() && !extreme) {
            outlierStyle = new MarkerAttrs();
            GraphStyle.setDefaultMarkerStyle((StatGraph)graph, (String)e.getAttribute("outlierAttrs"), (MarkerAttrs)outlierStyle, (String)"Outlier");
            plot.setMarkerColor(outlierStyle.getColor());
            plot.setMarkerSymbol(outlierStyle.getShape());
            plot.setMarkerSize(outlierStyle.getSize());
            plot.setMarkerWeight(outlierStyle.getWeight());
        }
        MarkerAttrs clipStyle = null;
        clipStyle = new MarkerAttrs();
        GraphStyle.setDefaultMarkerStyle((StatGraph)graph, (String)e.getAttribute("clipAttrs"), (MarkerAttrs)clipStyle, (String)"Clipping");
        if (plot.isConnectOn()) {
            int connect = 6;
            str = e.getAttribute("connect");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("min")) {
                    connect = 1;
                } else if (str.equalsIgnoreCase("q1")) {
                    connect = 2;
                } else if (str.equalsIgnoreCase("median")) {
                    connect = 3;
                } else if (str.equalsIgnoreCase("q3")) {
                    connect = 4;
                } else if (str.equalsIgnoreCase("max")) {
                    connect = 5;
                } else if (str.equalsIgnoreCase("mean")) {
                    connect = 6;
                } else {
                    StatGraph.printOptionError((String)"CONNECT", (String)str);
                }
                plot.setConnectBy(connect);
            } else {
                str = graph.style.getStyleAttribute("Box", "connect");
                if (str != null) {
                    connect = str.equalsIgnoreCase("min") ? 1 : (str.equalsIgnoreCase("q1") ? 2 : (str.equalsIgnoreCase("median") ? 3 : (str.equalsIgnoreCase("q3") ? 4 : (str.equalsIgnoreCase("max") ? 5 : (str.equalsIgnoreCase("mean") ? 6 : 6)))));
                    plot.setConnectBy(connect);
                }
            }
            GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)e.getAttribute("connectAttrs"), (LineAttrs)plot.getLineStyle(), (String)"ConnectLine");
        }
        if (labelsOn) {
            GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)e.getAttribute("dataLabelAttrs"), (TextStyle)plot.getLabelStyle(), (String)"DataText");
            str = e.getAttribute("dataLabelFormat");
            if (str.length() > 0) {
                plot.setLabelFormat(SASFormat.getInstance((String)str));
            }
            ScatterParser.parseDataLabelSplitting((Overlay)plot, (Element)e);
        }
        plot.setUseDataLabelColor(StatGraph.isBundleAttributeFixed((Element)e, (String)"dataLabelAttrs", (String)"color"));
        plot.setUseOutlineColor(StatGraph.isBundleAttributeFixed((Element)e, (String)"outlineAttrs", (String)"color"));
        plot.setUseOutlinePattern(StatGraph.isBundleAttributeFixed((Element)e, (String)"outlineAttrs", (String)"pattern") || plot.getFillOn());
        plot.setUseConnectLineColor(StatGraph.isBundleAttributeFixed((Element)e, (String)"connectAttrs", (String)"color"));
        plot.setUseConnectLinePattern(StatGraph.isBundleAttributeFixed((Element)e, (String)"connectAttrs", (String)"pattern") || plot.getFillOn());
        plot.setUseWhiskerColor(StatGraph.isBundleAttributeFixed((Element)e, (String)"whiskerAttrs", (String)"color"));
        plot.setUseWhiskerPattern(StatGraph.isBundleAttributeFixed((Element)e, (String)"whiskerAttrs", (String)"pattern") || plot.getFillOn());
        plot.setUseMedianColor(StatGraph.isBundleAttributeFixed((Element)e, (String)"medianAttrs", (String)"color"));
        plot.setUseMedianPattern(StatGraph.isBundleAttributeFixed((Element)e, (String)"medianAttrs", (String)"pattern") || plot.getFillOn());
        plot.setUseMeanSymbol(StatGraph.isBundleAttributeFixed((Element)e, (String)"meanAttrs", (String)"symbol"));
        plot.setUseMeanColor(StatGraph.isBundleAttributeFixed((Element)e, (String)"meanAttrs", (String)"color"));
        plot.setUseMeanSize(StatGraph.isBundleAttributeFixed((Element)e, (String)"meanAttrs", (String)"size"));
        plot.setUseOutlierSymbol(StatGraph.isBundleAttributeFixed((Element)e, (String)"outlierAttrs", (String)"symbol"));
        plot.setUseOutlierColor(StatGraph.isBundleAttributeFixed((Element)e, (String)"outlierAttrs", (String)"color"));
        plot.setUseOutlierSize(StatGraph.isBundleAttributeFixed((Element)e, (String)"outlierAttrs", (String)"size"));
        plot.setUseFillColor(StatGraph.isBundleAttributeFixed((Element)e, (String)"fillAttrs", (String)"color"));
        String elemTag = "";
        for (Node node = e.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("DataLabelAttrs") && labelsOn) {
                StatGraph.parseTextAttrs((StatGraph)graph, (Element)((Element)node), (TextStyle)plot.getLabelStyle());
                continue;
            }
            if (elemTag.equals("OutlineAttrs")) {
                StatGraph.parseLineAttrs((StatGraph)graph, (Element)((Element)node), (LineAttrs)plot.getOutlineStyle());
                continue;
            }
            if (elemTag.equals("ConnectAttrs") && plot.isConnectOn()) {
                StatGraph.parseLineAttrs((StatGraph)graph, (Element)((Element)node), (LineAttrs)plot.getLineStyle());
                continue;
            }
            if (elemTag.equals("WhiskerAttrs") && plot.isWhiskersOn()) {
                StatGraph.parseLineAttrs((StatGraph)graph, (Element)((Element)node), (LineAttrs)plot.getWhiskerStyle());
                continue;
            }
            if (elemTag.equals("MedianAttrs") && plot.isMedianOn()) {
                StatGraph.parseLineAttrs((StatGraph)graph, (Element)((Element)node), (LineAttrs)plot.getMedianStyle());
                continue;
            }
            if (elemTag.equals("MeanAttrs") && plot.isMeanOn()) {
                StatGraph.parseMarkerAttrs((StatGraph)graph, (Element)((Element)node), (MarkerAttrs)meanStyle);
                plot.setMeanColor(meanStyle.getColor());
                if (((Element)node).hasAttribute("symbol")) {
                    plot.setMeanSymbol(meanStyle.getShape());
                }
                if (((Element)node).hasAttribute("size")) {
                    plot.setMeanSize(meanStyle.getSize());
                }
                if (((Element)node).hasAttribute("weight")) {
                    plot.setMeanWeight(meanStyle.getWeight());
                }
                if (!((Element)node).hasAttribute("transparency")) continue;
                plot.setMeanTransparency(meanStyle.getTransparency());
                continue;
            }
            if (elemTag.equals("OutlierAttrs") && plot.isMarkersOn() && !extreme) {
                StatGraph.parseMarkerAttrs((StatGraph)graph, (Element)((Element)node), (MarkerAttrs)outlierStyle);
                plot.setMarkerColor(outlierStyle.getColor());
                if (((Element)node).hasAttribute("symbol")) {
                    plot.setMarkerSymbol(outlierStyle.getShape());
                }
                if (((Element)node).hasAttribute("size")) {
                    plot.setMarkerSize(outlierStyle.getSize());
                }
                if (((Element)node).hasAttribute("weight")) {
                    plot.setMarkerWeight(outlierStyle.getWeight());
                }
                if (!((Element)node).hasAttribute("transparency")) continue;
                plot.setMarkerTransparency(outlierStyle.getTransparency());
                continue;
            }
            if (elemTag.equals("FillAttrs") && plot.getFillOn()) {
                StatGraph.parseFillAttrs((StatGraph)graph, (Element)((Element)node), (FillAttrs)fillAttrs);
                continue;
            }
            if (elemTag.equals("OOCFillAttrs") && plot.getFillOn()) {
                StatGraph.parseFillAttrs((StatGraph)graph, (Element)((Element)node), (FillAttrs)oocFillAttrs);
                continue;
            }
            if (!elemTag.equals("OOCOutlineAttrs") || plot.getFillOn()) continue;
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)((Element)node), (LineAttrs)plot.getOOCLineStyle());
        }
        if (plot.isCapOn()) {
            plot.getCapStyle().setColor(plot.getWhiskerStyle().getColor());
            plot.getCapStyle().setWidth(plot.getWhiskerStyle().getWidth());
        }
        if ((str = e.getAttribute("discreteOffset")).length() > 0) {
            String dStat = e.getAttribute("displayStats");
            if (dStat.length() > 0 && !dStat.equalsIgnoreCase("none")) {
                Message msg = new Message(RB.getStringResource((String)"StatGraph.", (String)"doffset.fmt.txt"));
                StatGraph.printNote((String)msg.toString((Object)str));
            } else if (StatGraph.isNumber((String)str)) {
                double offset = Double.parseDouble(str);
                if (offset >= -0.5 && offset <= 0.5) {
                    plot.setDiscreteOffset(offset);
                } else {
                    StatGraph.printOptionError((String)"DISCRETEOFFSET", (String)str);
                }
            } else if (str.length() > 0) {
                StatGraph.printOptionError((String)"DISCRETEOFFSET", (String)str);
            }
        }
        if ((str = e.getAttribute("displayStats")).length() > 0 && !str.equalsIgnoreCase("none")) {
            Object[] xValues;
            if (plot.getOrientation() == 1) {
                StatGraph.printNote((String)RB.getStringResource((String)RB_KEY, (String)"stat.txt"));
                return true;
            }
            String[] opts2 = str.equalsIgnoreCase("all") ? new String[]{"N", "Min", "Q1", "Median", "Q3", "Max", "Mean", "STD", "Range", "IQR"} : (str.equalsIgnoreCase("standard") ? new String[]{"N", "mean", "STD"} : StatGraph.parseList2String((String)str));
            DataModel model = new DataModel();
            if (plot.isContinuousBox()) {
                xValues = plot.getDoubleXValues();
                model.addDoubleColumn("X", "X", null, xValues[0], xValues[xValues.length - 1], 0, xValues);
            } else {
                xValues = plot.getXValues();
                model.addStringColumn("X", "X", null, xValues.length, 0, (String[])xValues);
            }
            cmd = (ColumnMetadata)m.getColumnLabel(ycol);
            String fmt = NumericFormat.isNamedFormat((SASFormat)cmd.getFormat()) ? cmd.getFormat().getName() : DataModel.defaultFormat.getName();
            int num = 0;
            for (int i2 = 0; i2 < opts2.length; ++i2) {
                String[] sValues;
                if (!QCBoxParmParser.isValidStatistic(opts2[i2])) continue;
                if (opts2[i2].equalsIgnoreCase("N")) {
                    sValues = plot.getNumberOfObservations();
                    model.addStringColumn(opts2[i2], QCBoxParmParser.getNLSName(opts2[i2]), null, sValues.length, 0, sValues);
                } else {
                    sValues = (String[])plot.getStatistics(opts2[i2]);
                    model.addDoubleColumn(opts2[i2], QCBoxParmParser.getNLSName(opts2[i2]), fmt, -1.0, -1.0, 0, (double[])sValues);
                }
                ++num;
            }
            if (num < 1) {
                return true;
            }
            BlockOverlay[] blocks = new BlockOverlay[num];
            num = 0;
            for (int i3 = 0; i3 < opts2.length; ++i3) {
                if (!QCBoxParmParser.isValidStatistic(opts2[i3])) continue;
                blocks[num] = new BlockOverlay();
                RoleColumnMap map3 = new RoleColumnMap();
                xcol = model.getColumn("X");
                map3.map(10, xcol);
                blocks[num].addRole("X", model.getColumnLabel(xcol));
                int lcol = model.getColumn(opts2[i3]);
                map3.map(5, lcol);
                blocks[num].addRole("BLOCK", model.getColumnLabel(lcol));
                CRD crd3 = new CRD();
                crd3.setSrcModel(model);
                crd3.setSrcMap(map3);
                blocks[num].setModel(crd3);
                blocks[num].colorList = graph.style.fillColorList;
                blocks[num].setFillOn(false);
                blocks[num].setEdgeOn(false);
                blocks[num].setRepeatValue(true);
                blocks[num].setValueFitStrategy(0);
                GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)e.getAttribute("dataLabelAttrs"), (TextStyle)blocks[num].getValueStyle(), (String)"DataText");
                GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)"", (TextStyle)blocks[num].getLabelStyle(), (String)"ValueText");
                blocks[num].setOverlayJustification(2);
                blocks[num].setXAxis(plot.getXAxis());
                if (plot.isContinuousBox()) {
                    blocks[num].setValueHAlign(10);
                }
                ++num;
            }
            plot.setBlockOverlays((Overlay[])blocks);
        }
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (crd.isAvailable(6)) {
            graph.style.setContextCount(contextCount);
            QCLayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)4, plot.getFillStyle().getTransparency());
        }
        if (crd.isAvailable(36)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder((StatGraph)graph, (Overlay)plot, (byte)15);
        }
        if (crd.isAvailable(46)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder((StatGraph)graph, (Overlay)plot, (byte)17);
            ColorEncoder lcEncoder = plot.getLineColorEncoder();
            DiscreteRange dr = (DiscreteRange)lcEncoder.getInput();
            HashMap lcTable = lcEncoder.colorList;
            HashMap scTable = new HashMap();
            HashMap sc2Table = new HashMap();
            for (Object key : lcTable.keySet()) {
                Color c = (Color)lcTable.get(key);
                scTable.put(key, plot.applyDataTransparency(c, plot.getMeanTransparency()));
                sc2Table.put(key, plot.applyDataTransparency(c, plot.getMarkerTransparency()));
            }
            ColorEncoder scEncoder = new ColorEncoder(dr, scTable);
            scEncoder.colorArray = lcEncoder.colorArray;
            plot.setEncoder((byte)16, (Encoder)scEncoder);
            ColorEncoder s2cEncoder = new ColorEncoder(dr, sc2Table);
            s2cEncoder.colorArray = lcEncoder.colorArray;
            plot.setEncoder((byte)23, (Encoder)s2cEncoder);
        }
        if (crd.isAvailable(8)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder((StatGraph)graph, (Overlay)plot, (byte)6);
        }
        if (LayoutOverlayParser.isIndexVarAssigned((CRD)crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    private static void setDisplayAll(QCBoxParmOverlay box, boolean on) {
        box.setCapOn(on);
        box.setConnectOn(on);
        box.setMedianOn(on);
        box.setMeanOn(on);
        box.setMarkersOn(on);
        box.setFillOn(on);
        box.setNotched(on);
    }

    private static boolean isBoxOn(QCBoxParmOverlay box) {
        return box.isCapOn() || box.isConnectOn() || box.isMedianOn() || box.isMeanOn() || box.isMarkersOn() || box.getFillOn() || box.isNotched();
    }

    private static boolean isValidStatistic(String statname) {
        return statname.equalsIgnoreCase("MIN") || statname.equalsIgnoreCase("Q1") || statname.equalsIgnoreCase("MEDIAN") || statname.equalsIgnoreCase("Q3") || statname.equalsIgnoreCase("MAX") || statname.equalsIgnoreCase("MEAN") || statname.equalsIgnoreCase("N") || statname.equalsIgnoreCase("STD") || statname.equalsIgnoreCase("RANGE") || statname.equalsIgnoreCase("IQR");
    }

    private static String getNLSName(String name) {
        String NLS = name;
        if (name.equalsIgnoreCase("MIN")) {
            NLS = RB.getStringResource((String)RB_KEY, (String)"MIN.txt");
        } else if (name.equalsIgnoreCase("Q1")) {
            NLS = RB.getStringResource((String)RB_KEY, (String)"Q1.txt");
        } else if (name.equalsIgnoreCase("MEDIAN")) {
            NLS = RB.getStringResource((String)RB_KEY, (String)"MEDIAN.txt");
        } else if (name.equalsIgnoreCase("Q3")) {
            NLS = RB.getStringResource((String)RB_KEY, (String)"Q3.txt");
        } else if (name.equalsIgnoreCase("MAX")) {
            NLS = RB.getStringResource((String)RB_KEY, (String)"MAX.txt");
        } else if (name.equalsIgnoreCase("MEAN")) {
            NLS = RB.getStringResource((String)RB_KEY, (String)"MEAN.txt");
        } else if (name.equalsIgnoreCase("N")) {
            NLS = RB.getStringResource((String)RB_KEY, (String)"N.txt");
        } else if (name.equalsIgnoreCase("STD")) {
            NLS = RB.getStringResource((String)RB_KEY, (String)"STD.txt");
        } else if (name.equalsIgnoreCase("RANGE")) {
            NLS = RB.getStringResource((String)RB_KEY, (String)"RANGE.txt");
        } else if (name.equalsIgnoreCase("IQR")) {
            NLS = RB.getStringResource((String)RB_KEY, (String)"IQR.txt");
        }
        return NLS;
    }

    private static String buildWhereExpression(StringVectorVariable whereVar, int mpc, int page, StatGraph graph) {
        int n = whereVar.getUniqueValueCount();
        if (mpc >= n) {
            return null;
        }
        int maxPages = (int)Math.ceil((double)n / (double)mpc);
        if (page >= maxPages) {
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"page2.fmt.txt"));
            StatGraph.printWarning((String)msg.toString((Object)Integer.toString(page + 1), (Object)Integer.toString(maxPages)));
            page = maxPages - 1;
        }
        graph.pageNo = page;
        StringBuffer where = new StringBuffer();
        int s = mpc * page;
        int e = Math.min(s + mpc, n);
        String v = "";
        for (int i = s; i < e; ++i) {
            try {
                v = whereVar.uniqueValue.getValue(i);
            }
            catch (MissingValueException mve) {
                continue;
            }
            if (where.length() > 0) {
                where = where.append(" OR ");
            }
            where = where.append(whereVar.getColumnName() + " = \"" + v + "\"");
        }
        return where.toString();
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        String yVarID;
        int ycol;
        int[] types = new int[3];
        String str = elem.getAttribute("y");
        String dataName = StatGraph.getDataName((String)str);
        DataModel model = graph.getData(dataName);
        if (!StatGraph.checkVariable((String)"Y", (Object)model.getColumnLabel(ycol = model.getColumn(yVarID = StatGraph.getVarID((String)str))), Double.class, (int)2, (boolean)true)) {
            return null;
        }
        str = elem.getAttribute("x");
        String xVarID = StatGraph.getVarID((String)str);
        if (QCLayoutOverlayParser.valueCountHasExceededMaximum(model, xVarID, graph.discreteMax)) {
            return null;
        }
        ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(ycol);
        str = elem.getAttribute("orient");
        if (str.equalsIgnoreCase("Horizontal")) {
            types[0] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
            types[1] = 2;
        } else {
            types[0] = 2;
            types[1] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        }
        types[2] = 0;
        return types;
    }

    private static boolean isStat(String name) {
        return name.equalsIgnoreCase("MIN") || name.equalsIgnoreCase("Q1") || name.equalsIgnoreCase("MEDIAN") || name.equalsIgnoreCase("MEAN") || name.equalsIgnoreCase("Q3") || name.equalsIgnoreCase("MAX") || name.equalsIgnoreCase("STD") || name.equalsIgnoreCase("N");
    }

    private static boolean isOtherStat(String name) {
        return name.equalsIgnoreCase("OUTLIER") || name.equalsIgnoreCase("FAROUTLIER") || name.equalsIgnoreCase("BOXWIDTH");
    }

    private static void parseRoleTipStuff(Element elem, DataModel model, RoleColumnMap map, QCBoxParmOverlay overlay) {
        String tipVarID;
        ColumnMetadata cmd;
        HashMap<Integer, String> roleMap;
        String[] tipRoles;
        Element labelElem;
        Element formatElem;
        Element roleElem = StatGraph.getOptionAttrsElement((Element)elem, (String)"Roles");
        if (roleElem != null) {
            QCLayoutOverlayParser.parseRoleNames(roleElem, model, (Overlay)overlay);
        }
        if ((formatElem = StatGraph.getOptionAttrsElement((Element)elem, (String)"TipFormats")) != null) {
            String elemTag = "";
            HashMap<String, String> formatMap = null;
            for (Node node = formatElem.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element thisElem;
                if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("TipFormat")) continue;
                String role = thisElem.getAttribute("name");
                Node child = thisElem.getFirstChild();
                if (child == null) continue;
                String format = child.getNodeValue();
                if (QCBoxParmParser.isStat(role.toUpperCase())) {
                    if (formatMap == null) {
                        formatMap = new HashMap<String, String>();
                    }
                    formatMap.put(role.toUpperCase(), format);
                    continue;
                }
                ColumnMetadata cmd2 = overlay.getRoleMetadata(role.toUpperCase());
                if (cmd2 == null) continue;
                cmd2.setFormat(format);
            }
            overlay.setStatTipFormat(formatMap);
        }
        if ((labelElem = StatGraph.getOptionAttrsElement((Element)elem, (String)"TipLabels")) != null) {
            String elemTag = "";
            HashMap<String, String> labelMap = null;
            for (Node node = labelElem.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element thisElem;
                if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("TipLabel")) continue;
                String role = thisElem.getAttribute("name");
                Node child = thisElem.getFirstChild();
                if (child == null) continue;
                String label = child.getNodeValue();
                if (QCBoxParmParser.isStat(role.toUpperCase())) {
                    if (labelMap == null) {
                        labelMap = new HashMap<String, String>();
                    }
                    labelMap.put(role.toUpperCase(), label);
                    continue;
                }
                ColumnMetadata cmd3 = overlay.getRoleMetadata(role.toUpperCase());
                if (cmd3 == null) continue;
                cmd3.setLabel(label);
            }
            overlay.setStatTipLabel(labelMap);
        }
        overlay.clearStatTips();
        String str = elem.getAttribute("tip");
        if (str.length() > 0) {
            tipRoles = StatGraph.parseList2String((String)str);
            overlay.setCustomTips(true);
            int cnt = 0;
            roleMap = new HashMap<Integer, String>();
            for (int i = 0; i < tipRoles.length; ++i) {
                if (QCBoxParmParser.isStat(tipRoles[i].toUpperCase())) {
                    overlay.addStatTip(tipRoles[i].toUpperCase());
                    continue;
                }
                if (QCBoxParmParser.isOtherStat(tipRoles[i].toUpperCase())) {
                    tipRoles[i] = null;
                    continue;
                }
                cmd = overlay.getRoleMetadata(tipRoles[i].toUpperCase());
                if (cmd == null) continue;
                roleMap.put(new Integer(300 + cnt), tipRoles[i].toUpperCase());
                tipVarID = cmd.getName();
                int tipcol = model.getColumn(tipVarID);
                map.map(300 + cnt++, tipcol);
            }
            overlay.setCustomTipList(tipRoles);
            overlay.setTipRoleMap(roleMap);
        }
        if ((str = elem.getAttribute("outlierTip")).length() > 0) {
            tipRoles = StatGraph.parseList2String((String)str);
            overlay.setCustomOutlierTips(true);
            int cnt = 0;
            roleMap = new HashMap();
            for (int i = 0; i < tipRoles.length; ++i) {
                cmd = overlay.getRoleMetadata(tipRoles[i].toUpperCase());
                if (cmd == null) continue;
                roleMap.put(new Integer(350 + cnt), tipRoles[i].toUpperCase());
                tipVarID = cmd.getName();
                int tipcol = model.getColumn(tipVarID);
                map.map(350 + cnt++, tipcol);
            }
            overlay.setOutlierTipRoleMap(roleMap);
        }
    }

    static boolean loadInternal(StatGraph graph, QCBoxParmOverlay plot, Element _internal) {
        float f;
        if (_internal == null) {
            return false;
        }
        Element e = _internal;
        plot.infillOpacity = f = QCParserUtils.getOpacity("opacity", e, 0.75f);
        QCParserUtils.setDebug(false);
        int i = QCParserUtils.getInteger("context", e, -1);
        QCOverlay.QCResponseContext type = QCOverlay.QCResponseContext.fromInteger(i, QCOverlay.QCResponseContext.Y);
        plot.setContext(type);
        boolean b = QCParserUtils.getBoolean("phaseBoxResponse", _internal, false);
        plot.setPhaseBoxResponse(b);
        b = QCParserUtils.getBoolean("maximizeInnerMargin", _internal, true);
        plot.setMaximizeInnerMargin(b);
        i = QCParserUtils.getInteger("runsTestMarker", _internal, 0);
        plot.setRunsTestMarkerType(i);
        String s = QCParserUtils.getString("runsTestMarkerAttrs", _internal, null);
        FillAttrs fs = plot.getRunsTestFillStyle();
        GraphStyle.setDefaultDataFillStyle((StatGraph)graph, (String)s, (FillAttrs)fs, (String)"Error");
        LineAttrs ls = plot.getRunsTestOutlineStyle();
        GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)s, (LineAttrs)ls, (String)"Error");
        double d = QCParserUtils.getDouble("interval", e, -1.0);
        if (d > 0.0) {
            plot.setInterval(d);
        }
        b = QCParserUtils.getBoolean("scaleMarkers", _internal, false);
        plot.setQCScaling(b);
        plot.infillOpacity = f = QCParserUtils.getOpacity("inFillOpacity", _internal, 1.0f);
        plot.overlapOpacity = f = QCParserUtils.getOpacity("overlapOpacity", _internal, 0.75f);
        d = QCParserUtils.getDouble("width", _internal, -1.0);
        plot.setIntervalBoxWidth(d);
        d = QCParserUtils.getDouble("scale", _internal, -1.0);
        plot.setBoxWidthScale(d);
        b = QCParserUtils.getBoolean("notches", _internal, false);
        plot.setNotched(b);
        b = QCParserUtils.getBoolean("boxOut", _internal, false);
        plot.setBoxOut(b);
        d = QCParserUtils.getDouble("dataLabelThreshold", _internal, Double.NaN);
        plot.setDataLabelThreshold(d);
        b = QCParserUtils.getBoolean("hideLegendItems", _internal, false);
        plot.setHideLegendItems(b);
        return true;
    }
}

