/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.exceptions.UserErrorException;
import org.apache.logging.log4j.Logger;

public class ManagementUtils {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    public static final FileFilter JAR_FILE_FILTER = new CustomFileFilter(".jar");

    public static Set<DistributedMember> getAllNormalMembers(InternalCache cache) {
        return new HashSet<DistributedMember>(cache.getDistributionManager().getNormalDistributionManagerIds());
    }

    public static Set<DistributedMember> getAllLocators(InternalCache cache) {
        return new HashSet<DistributedMember>(cache.getDistributionManager().getLocatorDistributionManagerIds());
    }

    public static Set<DistributedMember> getNormalMembersWithSameOrNewerVersion(InternalCache cache, KnownVersion version) {
        return ManagementUtils.getAllNormalMembers(cache).stream().filter(member -> ((InternalDistributedMember)member).getVersion().compareTo((Object)version) >= 0).collect(Collectors.toSet());
    }

    public static Set<DistributedMember> getAllMembers(InternalCache cache) {
        return ManagementUtils.getAllMembers(cache.getInternalDistributedSystem());
    }

    public static Set<DistributedMember> getAllMembers(InternalDistributedSystem internalDS) {
        return new HashSet<DistributedMember>(internalDS.getDistributionManager().getDistributionManagerIds());
    }

    public static ResultCollector<?, ?> executeFunction(Function function, Object args, Set<DistributedMember> targetMembers) {
        Execution execution = args != null ? FunctionService.onMembers(targetMembers).setArguments(args) : FunctionService.onMembers(targetMembers);
        ((AbstractExecution)execution).setIgnoreDepartedMembers(true);
        return execution.execute(function);
    }

    public static <K> Class<K> forName(String classToLoadName, String neededFor) {
        Class<?> loadedClass = null;
        try {
            ClassPathLoader classPathLoader = ClassPathLoader.getLatest();
            if (classToLoadName != null && !classToLoadName.isEmpty()) {
                loadedClass = classPathLoader.forName(classToLoadName);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new RuntimeException(MessageFormat.format("Could not find class \"{0}\" specified for \"{1}\".", classToLoadName, neededFor), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(MessageFormat.format("Class \"{0}\" specified for \"{1}\" is not of an expected type.", classToLoadName, neededFor), e);
        }
        return loadedClass;
    }

    public static DistributedMember getDistributedMemberByNameOrId(String memberNameOrId, InternalCache cache) {
        if (memberNameOrId == null) {
            return null;
        }
        Set<DistributedMember> memberSet = ManagementUtils.getAllMembers(cache);
        return memberSet.stream().filter(member -> memberNameOrId.equalsIgnoreCase(member.getId()) || memberNameOrId.equalsIgnoreCase(member.getName())).findFirst().orElse(null);
    }

    public static Set<String> getAllRegionNames(Cache cache) {
        HashSet<String> regionNames = new HashSet<String>();
        Set<Region<?, ?>> rootRegions = cache.rootRegions();
        for (Region<?, ?> rootRegion : rootRegions) {
            try {
                Set<Region<?, ?>> subRegions = rootRegion.subregions(true);
                for (Region<?, ?> subRegion : subRegions) {
                    regionNames.add(subRegion.getFullPath().substring(1));
                }
            }
            catch (Exception e) {
                logger.debug("Cannot get subregions of " + rootRegion.getFullPath() + ". Omitting from the set of region names.", (Throwable)e);
                continue;
            }
            regionNames.add(rootRegion.getFullPath().substring(1));
        }
        return regionNames;
    }

    public static List<String> bytesToFiles(Byte[][] fileData, String parentDirPath) throws IOException, UnsupportedOperationException {
        ArrayList<String> filesPaths = new ArrayList<String>();
        FileOutputStream fos = null;
        File file = null;
        File parentDir = new File(parentDirPath);
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new UnsupportedOperationException("Couldn't create required directory structure for " + parentDirPath);
        }
        for (int i = 0; i < fileData.length; ++i) {
            byte[] bytes = ArrayUtils.toPrimitive((Byte[])fileData[i]);
            if (i % 2 == 0) {
                String fileName = new String(bytes);
                file = new File(parentDir, fileName);
                fos = new FileOutputStream(file);
                continue;
            }
            fos.write(bytes);
            fos.close();
            filesPaths.add(file.getAbsolutePath());
        }
        return filesPaths;
    }

    public static Set<DistributedMember> getRegionAssociatedMembers(String region, InternalCache cache, boolean returnAll) {
        DistributedRegionMXBean regionMXBean;
        if (region == null || ((String)region).isEmpty()) {
            return Collections.emptySet();
        }
        if (!((String)region).startsWith("/")) {
            region = "/" + (String)region;
        }
        if ((regionMXBean = ManagementService.getManagementService(cache).getDistributedRegionMXBean((String)region)) == null) {
            return Collections.emptySet();
        }
        String[] regionAssociatedMemberNames = regionMXBean.getMembers();
        HashSet<DistributedMember> matchedMembers = new HashSet<DistributedMember>();
        HashSet<DistributedMember> allClusterMembers = new HashSet<DistributedMember>(cache.getMembers());
        allClusterMembers.add(cache.getDistributedSystem().getDistributedMember());
        for (DistributedMember member : allClusterMembers) {
            String name;
            List<String> regionAssociatedMemberNamesList = Arrays.asList(regionAssociatedMemberNames);
            if (!regionAssociatedMemberNamesList.contains(name = MBeanJMXAdapter.getMemberNameOrUniqueId(member))) continue;
            matchedMembers.add(member);
            if (returnAll) continue;
            return matchedMembers;
        }
        return matchedMembers;
    }

    public static Set<DistributedMember> getQueryRegionsAssociatedMembers(Set<String> regions, InternalCache cache, boolean returnAll) {
        Set results = regions.stream().map(region -> ManagementUtils.getRegionAssociatedMembers(region, cache, true)).reduce((s1, s2) -> {
            s1.retainAll((Collection<?>)s2);
            return s1;
        }).get();
        if (returnAll || results.size() <= 1) {
            return results;
        }
        return Collections.singleton((DistributedMember)results.iterator().next());
    }

    public static Set<DistributedMember> findMembers(Set<DistributedMember> membersToConsider, String[] groups, String[] members) {
        if (groups == null) {
            groups = new String[]{};
        }
        if (members == null) {
            members = new String[]{};
        }
        if (members.length > 0 && groups.length > 0) {
            throw new UserErrorException("Please provide either \"member\" or \"group\" option.");
        }
        if (members.length == 0 && groups.length == 0) {
            return membersToConsider;
        }
        HashSet<DistributedMember> matchingMembers = new HashSet<DistributedMember>();
        for (String memberNameOrId : members) {
            for (DistributedMember member : membersToConsider) {
                if (!memberNameOrId.equalsIgnoreCase(member.getId()) && !memberNameOrId.equalsIgnoreCase(member.getName())) continue;
                matchingMembers.add(member);
            }
        }
        for (String group : groups) {
            for (DistributedMember member : membersToConsider) {
                if (!member.getGroups().contains(group)) continue;
                matchingMembers.add(member);
            }
        }
        return matchingMembers;
    }

    public static Set<DistributedMember> findMembersIncludingLocators(String[] groups, String[] members, InternalCache cache) {
        Set<DistributedMember> allMembers = ManagementUtils.getAllMembers(cache);
        return ManagementUtils.findMembers(allMembers, groups, members);
    }

    public static Set<DistributedMember> findMembers(String[] groups, String[] members, InternalCache cache) {
        Set<DistributedMember> allNormalMembers = ManagementUtils.getAllNormalMembers(cache);
        return ManagementUtils.findMembers(allNormalMembers, groups, members);
    }

    public static Set<DistributedMember> findMembers(String[] groups, String[] members, DistributionManager distributionManager) {
        HashSet<DistributedMember> allNormalMembers = new HashSet<DistributedMember>(distributionManager.getNormalDistributionManagerIds());
        return ManagementUtils.findMembers(allNormalMembers, groups, members);
    }

    public static Byte[][] filesToBytes(List<String> fileNames) throws IOException {
        ArrayList<byte[]> filesDataList = new ArrayList<byte[]>();
        for (String fileName : fileNames) {
            File file = new File(fileName);
            if (!file.exists()) {
                throw new FileNotFoundException("Could not find " + file.getCanonicalPath());
            }
            if (file.isDirectory()) {
                File[] childrenFiles;
                for (File childrenFile : childrenFiles = file.listFiles(JAR_FILE_FILTER)) {
                    filesDataList.add(childrenFile.getName().getBytes());
                    filesDataList.add(ManagementUtils.toByteArray(new FileInputStream(childrenFile)));
                }
                continue;
            }
            filesDataList.add(file.getName().getBytes());
            filesDataList.add(ManagementUtils.toByteArray(new FileInputStream(file)));
        }
        return (Byte[][])filesDataList.stream().map(ArrayUtils::toObject).toArray(x$0 -> new Byte[x$0][]);
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        int n;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    static class CustomFileFilter
    implements FileFilter {
        private final String extensionWithDot;

        public CustomFileFilter(String extensionWithDot) {
            this.extensionWithDot = extensionWithDot;
        }

        @Override
        public boolean accept(File pathname) {
            String name = pathname.getName();
            return name.endsWith(this.extensionWithDot);
        }
    }
}

