/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.validators;

import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.internal.CacheElementOperation;
import org.apache.geode.management.internal.configuration.validators.ConfigurationValidator;

public class CommonConfigurationValidator
implements ConfigurationValidator<AbstractConfiguration> {
    @Override
    public void validate(CacheElementOperation operation, AbstractConfiguration config) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)config.getId())) {
            throw new IllegalArgumentException(config.getClass().getSimpleName() + " identifier is required.");
        }
        switch (operation) {
            case UPDATE: 
            case CREATE: {
                this.validateCreate(config);
                break;
            }
            case DELETE: {
                break;
            }
        }
    }

    private void validateCreate(AbstractConfiguration config) {
        String group = config.getGroup();
        if ("cluster".equalsIgnoreCase(group)) {
            throw new IllegalArgumentException("'cluster' is a reserved group name. Do not use it for member groups.");
        }
        if (group != null && group.contains(",")) {
            throw new IllegalArgumentException("Group name should not contain comma.");
        }
        String id = config.getId();
        if (id.contains("/")) {
            throw new IllegalArgumentException("Identifier should not contain slash.");
        }
    }
}

