/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.configuration.EnumActionDestroyOverflow;
import org.apache.geode.cache.configuration.RegionAttributesDataPolicy;
import org.apache.geode.cache.configuration.RegionAttributesScope;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.management.configuration.ClassName;
import org.apache.geode.management.configuration.Region;
import org.apache.geode.management.configuration.RegionType;
import org.apache.geode.management.internal.configuration.converters.ClassNameConverter;
import org.apache.geode.management.internal.configuration.converters.ConfigurationConverter;

public class RegionConverter
extends ConfigurationConverter<Region, RegionConfig> {
    private final ClassNameConverter classNameConverter = new ClassNameConverter();

    @Override
    protected Region fromNonNullXmlObject(RegionConfig xmlObject) {
        Region region = new Region();
        region.setName(xmlObject.getName());
        RegionAttributesType regionAttributes = xmlObject.getRegionAttributes();
        region.setType(this.getRegionType(xmlObject.getType(), regionAttributes));
        if (regionAttributes != null) {
            RegionAttributesType.ExpirationAttributesType regionTimeToLive;
            RegionAttributesType.ExpirationAttributesType regionIdleTime;
            RegionAttributesType.ExpirationAttributesType entryTimeToLive;
            region.setDiskStoreName(regionAttributes.getDiskStoreName());
            region.setKeyConstraint(regionAttributes.getKeyConstraint());
            region.setValueConstraint(regionAttributes.getValueConstraint());
            Optional.ofNullable(regionAttributes.getPartitionAttributes()).flatMap(partitionAttributes -> Optional.ofNullable(partitionAttributes.getRedundantCopies())).ifPresent(copies -> region.setRedundantCopies(Integer.valueOf(Integer.parseInt(copies))));
            RegionAttributesType.ExpirationAttributesType entryIdleTime = regionAttributes.getEntryIdleTime();
            ArrayList<Region.Expiration> expirations = new ArrayList<Region.Expiration>();
            if (entryIdleTime != null) {
                expirations.add(this.convertFrom(Region.ExpirationType.ENTRY_IDLE_TIME, entryIdleTime));
            }
            if ((entryTimeToLive = regionAttributes.getEntryTimeToLive()) != null) {
                expirations.add(this.convertFrom(Region.ExpirationType.ENTRY_TIME_TO_LIVE, entryTimeToLive));
            }
            if ((regionIdleTime = regionAttributes.getRegionIdleTime()) != null) {
                expirations.add(this.convertFrom(Region.ExpirationType.LEGACY, regionIdleTime));
            }
            if ((regionTimeToLive = regionAttributes.getRegionTimeToLive()) != null) {
                expirations.add(this.convertFrom(Region.ExpirationType.LEGACY, regionTimeToLive));
            }
            if (!expirations.isEmpty()) {
                region.setExpirations(expirations);
            }
            if (regionAttributes.getEvictionAttributes() != null) {
                RegionAttributesType.EvictionAttributes evictionAttributes = regionAttributes.getEvictionAttributes();
                if (evictionAttributes.getLruMemorySize() != null) {
                    region.setEviction(this.convertFrom(evictionAttributes.getLruMemorySize()));
                }
                if (evictionAttributes.getLruEntryCount() != null) {
                    region.setEviction(this.convertFrom(evictionAttributes.getLruEntryCount()));
                }
                if (evictionAttributes.getLruHeapPercentage() != null) {
                    region.setEviction(this.convertFrom(evictionAttributes.getLruHeapPercentage()));
                }
            }
        }
        return region;
    }

    @Override
    protected RegionConfig fromNonNullConfigObject(Region configObject) {
        List expirations;
        RegionConfig region = new RegionConfig();
        region.setName(configObject.getName());
        region.setType(configObject.getType().name());
        RegionAttributesType attributesType = this.createRegionAttributesByType(configObject.getType().name());
        attributesType.setStatisticsEnabled(true);
        attributesType.setDiskStoreName(configObject.getDiskStoreName());
        attributesType.setKeyConstraint(configObject.getKeyConstraint());
        attributesType.setValueConstraint(configObject.getValueConstraint());
        if (configObject.getRedundantCopies() != null) {
            RegionAttributesType.PartitionAttributes partitionAttributes = new RegionAttributesType.PartitionAttributes();
            partitionAttributes.setRedundantCopies(configObject.getRedundantCopies().toString());
            attributesType.setPartitionAttributes(partitionAttributes);
        }
        if ((expirations = configObject.getExpirations()) != null) {
            for (Region.Expiration expiration : expirations) {
                switch (expiration.getType()) {
                    case ENTRY_IDLE_TIME: {
                        attributesType.setEntryIdleTime(this.convertFrom(expiration));
                        break;
                    }
                    case ENTRY_TIME_TO_LIVE: {
                        attributesType.setEntryTimeToLive(this.convertFrom(expiration));
                    }
                }
            }
        }
        if (configObject.getEviction() != null) {
            attributesType.setEvictionAttributes(this.convertFrom(configObject.getEviction()));
        }
        region.setRegionAttributes(attributesType);
        return region;
    }

    private RegionAttributesType.EvictionAttributes convertFrom(Region.Eviction eviction) {
        return RegionAttributesType.EvictionAttributes.generate(this.getEvictionActionString(eviction), eviction.getMemorySizeMb(), eviction.getEntryCount(), eviction.getObjectSizer());
    }

    private String getEvictionActionString(Region.Eviction eviction) {
        if (eviction.getAction() == null) {
            return "local-destroy";
        }
        switch (eviction.getAction()) {
            case LOCAL_DESTROY: {
                return "local-destroy";
            }
            case OVERFLOW_TO_DISK: {
                return "overflow-to-disk";
            }
        }
        throw new IllegalStateException("Unhandled eviction action: " + String.valueOf(eviction.getAction()));
    }

    private Region.EvictionAction getEvictionAction(EnumActionDestroyOverflow evictionAction) {
        switch (evictionAction) {
            case LOCAL_DESTROY: {
                return Region.EvictionAction.LOCAL_DESTROY;
            }
            case OVERFLOW_TO_DISK: {
                return Region.EvictionAction.OVERFLOW_TO_DISK;
            }
        }
        throw new IllegalStateException("Unhandled eviction action xml: " + String.valueOf((Object)evictionAction));
    }

    Region.Eviction convertFrom(RegionAttributesType.EvictionAttributes.LruMemorySize evictionAttributes) {
        Region.Eviction eviction = new Region.Eviction();
        eviction.setAction(this.getEvictionAction(evictionAttributes.getAction()));
        eviction.setMemorySizeMb(Integer.valueOf(Integer.parseInt(evictionAttributes.getMaximum())));
        eviction.setObjectSizer((ClassName)this.classNameConverter.fromXmlObject(evictionAttributes));
        return eviction;
    }

    Region.Eviction convertFrom(RegionAttributesType.EvictionAttributes.LruEntryCount evictionAttributes) {
        Region.Eviction eviction = new Region.Eviction();
        eviction.setAction(this.getEvictionAction(evictionAttributes.getAction()));
        eviction.setEntryCount(Integer.valueOf(Integer.parseInt(evictionAttributes.getMaximum())));
        return eviction;
    }

    Region.Eviction convertFrom(RegionAttributesType.EvictionAttributes.LruHeapPercentage evictionAttributes) {
        Region.Eviction eviction = new Region.Eviction();
        eviction.setAction(this.getEvictionAction(evictionAttributes.getAction()));
        eviction.setObjectSizer((ClassName)this.classNameConverter.fromXmlObject(evictionAttributes));
        eviction.setType(Region.EvictionType.HEAP_PERCENTAGE);
        return eviction;
    }

    RegionAttributesType.ExpirationAttributesType convertFrom(Region.Expiration expiration) {
        RegionAttributesType.ExpirationAttributesType xmlExpiration = new RegionAttributesType.ExpirationAttributesType();
        xmlExpiration.setTimeout(expiration.getTimeInSeconds().toString());
        if (expiration.getAction() == null) {
            xmlExpiration.setAction(Region.ExpirationAction.DESTROY.name().toLowerCase());
        } else {
            xmlExpiration.setAction(expiration.getAction().name().toLowerCase());
        }
        return xmlExpiration;
    }

    Region.Expiration convertFrom(Region.ExpirationType type, RegionAttributesType.ExpirationAttributesType xmlExpiration) {
        Region.Expiration expiration = new Region.Expiration();
        expiration.setType(type);
        if (StringUtils.isBlank((CharSequence)xmlExpiration.getTimeout())) {
            expiration.setTimeInSeconds(Integer.valueOf(0));
        } else {
            expiration.setTimeInSeconds(Integer.valueOf(Integer.parseInt(xmlExpiration.getTimeout())));
        }
        if (StringUtils.isBlank((CharSequence)xmlExpiration.getAction())) {
            expiration.setAction(Region.ExpirationAction.INVALIDATE);
        } else {
            try {
                expiration.setAction(Region.ExpirationAction.valueOf((String)xmlExpiration.getAction().toUpperCase()));
            }
            catch (Exception e) {
                expiration.setAction(Region.ExpirationAction.LEGACY);
            }
        }
        return expiration;
    }

    public RegionType getRegionType(String refid, RegionAttributesType regionAttributes) {
        if (refid != null) {
            try {
                return RegionType.valueOf((String)refid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (regionAttributes == null) {
            return RegionType.LEGACY;
        }
        RegionAttributesDataPolicy dataPolicy = regionAttributes.getDataPolicy();
        if (dataPolicy == null) {
            return RegionType.LEGACY;
        }
        switch (dataPolicy) {
            case PARTITION: {
                RegionAttributesType.PartitionAttributes partitionAttributes = regionAttributes.getPartitionAttributes();
                if (partitionAttributes != null && "0".equals(partitionAttributes.getLocalMaxMemory())) {
                    return RegionType.PARTITION_PROXY;
                }
                return RegionType.PARTITION;
            }
            case PERSISTENT_PARTITION: {
                return RegionType.PARTITION_PERSISTENT;
            }
            case PERSISTENT_REPLICATE: {
                return RegionType.REPLICATE_PERSISTENT;
            }
            case REPLICATE: {
                return RegionType.REPLICATE;
            }
            case EMPTY: {
                return RegionType.REPLICATE_PROXY;
            }
        }
        return RegionType.LEGACY;
    }

    public RegionAttributesType createRegionAttributesByType(String type) {
        RegionAttributesType regionAttributes = new RegionAttributesType();
        switch (type) {
            case "PARTITION": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                break;
            }
            case "PARTITION_PERSISTENT": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_PARTITION);
                break;
            }
            case "PARTITION_PROXY": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                regionAttributes.setLocalMaxMemory("0");
                break;
            }
            case "REPLICATE": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.REPLICATE);
                regionAttributes.setScope(RegionAttributesScope.DISTRIBUTED_ACK);
                break;
            }
            case "REPLICATE_PERSISTENT": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_REPLICATE);
                regionAttributes.setScope(RegionAttributesScope.DISTRIBUTED_ACK);
                break;
            }
            case "REPLICATE_PROXY": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.EMPTY);
                regionAttributes.setScope(RegionAttributesScope.DISTRIBUTED_ACK);
                break;
            }
            case "PARTITION_REDUNDANT": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                regionAttributes.setRedundantCopy("1");
                break;
            }
            case "PARTITION_REDUNDANT_PERSISTENT": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_PARTITION);
                regionAttributes.setRedundantCopy("1");
                break;
            }
            case "PARTITION_OVERFLOW": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                regionAttributes.setLruHeapPercentageEvictionAction(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "PARTITION_REDUNDANT_OVERFLOW": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                regionAttributes.setRedundantCopy("1");
                regionAttributes.setLruHeapPercentageEvictionAction(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "PARTITION_PERSISTENT_OVERFLOW": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_PARTITION);
                regionAttributes.setLruHeapPercentageEvictionAction(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "PARTITION_REDUNDANT_PERSISTENT_OVERFLOW": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_PARTITION);
                regionAttributes.setRedundantCopy("1");
                regionAttributes.setLruHeapPercentageEvictionAction(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "PARTITION_HEAP_LRU": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                regionAttributes.setLruHeapPercentageEvictionAction(EnumActionDestroyOverflow.LOCAL_DESTROY);
                break;
            }
            case "PARTITION_REDUNDANT_HEAP_LRU": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                regionAttributes.setRedundantCopy("1");
                regionAttributes.setLruHeapPercentageEvictionAction(EnumActionDestroyOverflow.LOCAL_DESTROY);
                break;
            }
            case "REPLICATE_OVERFLOW": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.REPLICATE);
                regionAttributes.setScope(RegionAttributesScope.DISTRIBUTED_ACK);
                regionAttributes.setLruHeapPercentageEvictionAction(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "REPLICATE_PERSISTENT_OVERFLOW": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_REPLICATE);
                regionAttributes.setScope(RegionAttributesScope.DISTRIBUTED_ACK);
                regionAttributes.setLruHeapPercentageEvictionAction(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "REPLICATE_HEAP_LRU": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PRELOADED);
                regionAttributes.setScope(RegionAttributesScope.DISTRIBUTED_ACK);
                regionAttributes.setInterestPolicy("all");
                regionAttributes.setLruHeapPercentageEvictionAction(EnumActionDestroyOverflow.LOCAL_DESTROY);
                break;
            }
            case "LOCAL": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.NORMAL);
                regionAttributes.setScope(RegionAttributesScope.LOCAL);
                break;
            }
            case "LOCAL_PERSISTENT": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_REPLICATE);
                regionAttributes.setScope(RegionAttributesScope.LOCAL);
                break;
            }
            case "LOCAL_HEAP_LRU": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.NORMAL);
                regionAttributes.setScope(RegionAttributesScope.LOCAL);
                regionAttributes.setLruHeapPercentageEvictionAction(EnumActionDestroyOverflow.LOCAL_DESTROY);
                break;
            }
            case "LOCAL_OVERFLOW": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.NORMAL);
                regionAttributes.setScope(RegionAttributesScope.LOCAL);
                regionAttributes.setLruHeapPercentageEvictionAction(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "LOCAL_PERSISTENT_OVERFLOW": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PERSISTENT_REPLICATE);
                regionAttributes.setScope(RegionAttributesScope.LOCAL);
                regionAttributes.setLruHeapPercentageEvictionAction(EnumActionDestroyOverflow.OVERFLOW_TO_DISK);
                break;
            }
            case "PARTITION_PROXY_REDUNDANT": {
                regionAttributes.setDataPolicy(RegionAttributesDataPolicy.PARTITION);
                regionAttributes.setLocalMaxMemory("0");
                regionAttributes.setRedundantCopy("1");
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type " + type);
            }
        }
        return regionAttributes;
    }
}

