/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.internal.statistics.StatisticId;
import org.apache.geode.internal.statistics.StatisticNotFoundException;
import org.apache.geode.internal.statistics.StatisticsListener;
import org.apache.geode.internal.statistics.StatisticsNotification;
import org.apache.geode.internal.statistics.ValueMonitor;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;

public class MemberLevelDiskMonitor
extends MBeanStatsMonitor {
    private volatile long flushes = 0L;
    private volatile int queueSize = 0;
    private volatile long flushTime = 0L;
    private volatile long flushedBytes = 0L;
    private volatile long diskReadBytes = 0L;
    private volatile int backupsCompleted = 0;
    private volatile long diskWrittenBytes = 0L;
    private volatile int backupsInProgress = 0;
    private final Map<Statistics, ValueMonitor> monitors = new HashMap<Statistics, ValueMonitor>();
    private final Map<Statistics, MemberLevelDiskStatisticsListener> listeners = new HashMap<Statistics, MemberLevelDiskStatisticsListener>();

    public long getFlushes() {
        return this.flushes;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    long getFlushTime() {
        return this.flushTime;
    }

    long getFlushedBytes() {
        return this.flushedBytes;
    }

    long getDiskReadBytes() {
        return this.diskReadBytes;
    }

    public int getBackupsCompleted() {
        return this.backupsCompleted;
    }

    long getDiskWrittenBytes() {
        return this.diskWrittenBytes;
    }

    public int getBackupsInProgress() {
        return this.backupsInProgress;
    }

    Map<Statistics, ValueMonitor> getMonitors() {
        return this.monitors;
    }

    Map<Statistics, MemberLevelDiskStatisticsListener> getListeners() {
        return this.listeners;
    }

    public MemberLevelDiskMonitor(String name) {
        super(name);
    }

    Number computeDelta(Map<String, Number> statsMap, String name, Number currentValue) {
        if (name.equals("readBytes")) {
            Number prevValue = statsMap.getOrDefault("readBytes", 0);
            return currentValue.longValue() - prevValue.longValue();
        }
        if (name.equals("recoveredBytes")) {
            Number prevValue = statsMap.getOrDefault("recoveredBytes", 0);
            return currentValue.longValue() - prevValue.longValue();
        }
        if (name.equals("writtenBytes")) {
            Number prevValue = statsMap.getOrDefault("writtenBytes", 0);
            return currentValue.longValue() - prevValue.longValue();
        }
        if (name.equals("backupsInProgress")) {
            Number prevValue = statsMap.getOrDefault("backupsInProgress", 0);
            return currentValue.intValue() - prevValue.intValue();
        }
        if (name.equals("backupsCompleted")) {
            Number prevValue = statsMap.getOrDefault("backupsCompleted", 0);
            return currentValue.intValue() - prevValue.intValue();
        }
        if (name.equals("flushedBytes")) {
            Number prevValue = statsMap.getOrDefault("flushedBytes", 0);
            return currentValue.longValue() - prevValue.longValue();
        }
        if (name.equals("flushes")) {
            Number prevValue = statsMap.getOrDefault("flushes", 0);
            return currentValue.longValue() - prevValue.longValue();
        }
        if (name.equals("flushTime")) {
            Number prevValue = statsMap.getOrDefault("flushTime", 0);
            return currentValue.longValue() - prevValue.longValue();
        }
        if (name.equals("queueSize")) {
            Number prevValue = statsMap.getOrDefault("queueSize", 0);
            return currentValue.intValue() - prevValue.intValue();
        }
        return 0;
    }

    void increaseStats(String name, Number value) {
        if (name.equals("readBytes") || name.equals("recoveredBytes")) {
            this.diskReadBytes += value.longValue();
            return;
        }
        if (name.equals("writtenBytes")) {
            this.diskWrittenBytes += value.longValue();
            return;
        }
        if (name.equals("backupsInProgress")) {
            this.backupsInProgress += value.intValue();
            return;
        }
        if (name.equals("backupsCompleted")) {
            this.backupsCompleted += value.intValue();
            return;
        }
        if (name.equals("flushedBytes")) {
            this.flushedBytes += value.longValue();
            return;
        }
        if (name.equals("flushes")) {
            this.flushes += value.longValue();
            return;
        }
        if (name.equals("flushTime")) {
            this.flushTime += value.longValue();
            return;
        }
        if (name.equals("queueSize")) {
            this.queueSize += value.intValue();
            return;
        }
    }

    @Override
    public Number getStatistic(String name) {
        if (name.equals("readBytes")) {
            return this.getDiskReadBytes();
        }
        if (name.equals("writtenBytes")) {
            return this.getDiskWrittenBytes();
        }
        if (name.equals("backupsInProgress")) {
            return this.getBackupsInProgress();
        }
        if (name.equals("backupsCompleted")) {
            return this.getBackupsCompleted();
        }
        if (name.equals("flushedBytes")) {
            return this.getFlushedBytes();
        }
        if (name.equals("flushes")) {
            return this.getFlushes();
        }
        if (name.equals("flushTime")) {
            return this.getFlushTime();
        }
        if (name.equals("queueSize")) {
            return this.getQueueSize();
        }
        return 0;
    }

    @Override
    public void addStatisticsToMonitor(Statistics stats) {
        ValueMonitor diskMonitor = new ValueMonitor();
        MemberLevelDiskStatisticsListener listener = new MemberLevelDiskStatisticsListener();
        diskMonitor.addListener(listener);
        diskMonitor.addStatistics(stats);
        this.monitors.put(stats, diskMonitor);
        this.listeners.put(stats, listener);
    }

    @Override
    public void stopListener() {
        for (Statistics stat : this.listeners.keySet()) {
            ValueMonitor monitor = this.monitors.get(stat);
            monitor.removeListener(this.listeners.get(stat));
            monitor.removeStatistics(stat);
        }
        this.monitors.clear();
        this.listeners.clear();
    }

    @Override
    public void removeStatisticsFromMonitor(Statistics stats) {
        MemberLevelDiskStatisticsListener listener;
        ValueMonitor monitor = this.monitors.remove(stats);
        if (monitor != null) {
            monitor.removeStatistics(stats);
        }
        if ((listener = this.listeners.remove(stats)) != null) {
            if (monitor != null) {
                monitor.removeListener(listener);
            }
            listener.decreaseDiskStoreStats();
        }
    }

    class MemberLevelDiskStatisticsListener
    implements StatisticsListener {
        Map<String, Number> statsMap = new HashMap<String, Number>();
        private boolean removed = false;

        MemberLevelDiskStatisticsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(StatisticsNotification notification) {
            Map<String, Number> map = this.statsMap;
            synchronized (map) {
                if (this.removed) {
                    return;
                }
                for (StatisticId statId : notification) {
                    Number value;
                    StatisticDescriptor descriptor = statId.getStatisticDescriptor();
                    String name = descriptor.getName();
                    try {
                        value = notification.getValue(statId);
                    }
                    catch (StatisticNotFoundException e) {
                        value = 0;
                    }
                    MemberLevelDiskMonitor.this.log(name, value);
                    Number deltaValue = MemberLevelDiskMonitor.this.computeDelta(this.statsMap, name, value);
                    this.statsMap.put(name, value);
                    MemberLevelDiskMonitor.this.increaseStats(name, deltaValue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void decreaseDiskStoreStats() {
            Map<String, Number> map = this.statsMap;
            synchronized (map) {
                MemberLevelDiskMonitor.this.queueSize -= this.statsMap.getOrDefault("queueSize", 0).intValue();
                MemberLevelDiskMonitor.this.backupsInProgress -= this.statsMap.getOrDefault("backupsInProgress", 0).intValue();
                this.removed = true;
            }
        }
    }
}

