/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.internal.statistics.StatisticId;
import org.apache.geode.internal.statistics.StatisticNotFoundException;
import org.apache.geode.internal.statistics.StatisticsListener;
import org.apache.geode.internal.statistics.StatisticsNotification;
import org.apache.geode.internal.statistics.ValueMonitor;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;

public class AggregateRegionStatsMonitor
extends MBeanStatsMonitor {
    private volatile long diskSpace = 0L;
    private volatile int bucketCount = 0;
    private volatile long lruDestroys = 0L;
    private volatile long lruEvictions = 0L;
    private volatile int totalBucketSize = 0;
    private volatile int primaryBucketCount = 0;
    private final Map<Statistics, ValueMonitor> monitors = new HashMap<Statistics, ValueMonitor>();
    private final Map<Statistics, MemberLevelRegionStatisticsListener> listeners = new HashMap<Statistics, MemberLevelRegionStatisticsListener>();

    public long getDiskSpace() {
        return this.diskSpace;
    }

    public int getTotalBucketCount() {
        return this.bucketCount;
    }

    long getLruDestroys() {
        return this.lruDestroys;
    }

    long getLruEvictions() {
        return this.lruEvictions;
    }

    public int getTotalBucketSize() {
        return this.totalBucketSize;
    }

    public int getTotalPrimaryBucketCount() {
        return this.primaryBucketCount;
    }

    Map<Statistics, ValueMonitor> getMonitors() {
        return this.monitors;
    }

    Map<Statistics, MemberLevelRegionStatisticsListener> getListeners() {
        return this.listeners;
    }

    public AggregateRegionStatsMonitor(String name) {
        super(name);
    }

    Number computeDelta(Map<String, Number> statsMap, String name, Number currentValue) {
        if (name.equals("primaryBucketCount")) {
            Number prevValue = statsMap.getOrDefault("primaryBucketCount", 0);
            return currentValue.intValue() - prevValue.intValue();
        }
        if (name.equals("bucketCount")) {
            Number prevValue = statsMap.getOrDefault("bucketCount", 0);
            return currentValue.intValue() - prevValue.intValue();
        }
        if (name.equals("dataStoreEntryCount")) {
            Number prevValue = statsMap.getOrDefault("dataStoreEntryCount", 0);
            return currentValue.intValue() - prevValue.intValue();
        }
        if (name.equals("lruEvictions")) {
            Number prevValue = statsMap.getOrDefault("lruEvictions", 0);
            return currentValue.longValue() - prevValue.longValue();
        }
        if (name.equals("lruDestroys")) {
            Number prevValue = statsMap.getOrDefault("lruDestroys", 0);
            return currentValue.longValue() - prevValue.longValue();
        }
        if (name.equals("diskSpace")) {
            Number prevValue = statsMap.getOrDefault("diskSpace", 0);
            return currentValue.longValue() - prevValue.longValue();
        }
        return 0;
    }

    void increaseStats(String name, Number value) {
        if (name.equals("primaryBucketCount")) {
            this.primaryBucketCount += value.intValue();
            return;
        }
        if (name.equals("bucketCount")) {
            this.bucketCount += value.intValue();
            return;
        }
        if (name.equals("dataStoreEntryCount")) {
            this.totalBucketSize += value.intValue();
            return;
        }
        if (name.equals("lruEvictions")) {
            this.lruEvictions += value.longValue();
            return;
        }
        if (name.equals("lruDestroys")) {
            this.lruDestroys += value.longValue();
            return;
        }
        if (name.equals("diskSpace")) {
            this.diskSpace += value.longValue();
            return;
        }
    }

    private MemberLevelRegionStatisticsListener removeListener(Statistics stats) {
        MemberLevelRegionStatisticsListener listener;
        ValueMonitor monitor = this.monitors.remove(stats);
        if (monitor != null) {
            monitor.removeStatistics(stats);
        }
        if ((listener = this.listeners.remove(stats)) != null && monitor != null) {
            monitor.removeListener(listener);
        }
        return listener;
    }

    public void removeLRUStatistics(Statistics stats) {
        this.removeListener(stats);
    }

    public void removeDirectoryStatistics(Statistics stats) {
        this.removeListener(stats);
    }

    public void removePartitionStatistics(Statistics stats) {
        MemberLevelRegionStatisticsListener listener = this.removeListener(stats);
        if (listener != null) {
            listener.decreaseParStats();
        }
    }

    @Override
    public Number getStatistic(String name) {
        if (name.equals("lruEvictions")) {
            return this.getLruEvictions();
        }
        if (name.equals("lruDestroys")) {
            return this.getLruDestroys();
        }
        if (name.equals("primaryBucketCount")) {
            return this.getTotalPrimaryBucketCount();
        }
        if (name.equals("bucketCount")) {
            return this.getTotalBucketCount();
        }
        if (name.equals("dataStoreEntryCount")) {
            return this.getTotalBucketSize();
        }
        if (name.equals("diskSpace")) {
            return this.getDiskSpace();
        }
        return 0;
    }

    @Override
    public void addStatisticsToMonitor(Statistics stats) {
        ValueMonitor regionMonitor = new ValueMonitor();
        MemberLevelRegionStatisticsListener listener = new MemberLevelRegionStatisticsListener();
        regionMonitor.addListener(listener);
        regionMonitor.addStatistics(stats);
        this.monitors.put(stats, regionMonitor);
        this.listeners.put(stats, listener);
    }

    @Override
    public void stopListener() {
        for (Statistics stat : this.listeners.keySet()) {
            ValueMonitor monitor = this.monitors.get(stat);
            monitor.removeListener(this.listeners.get(stat));
            monitor.removeStatistics(stat);
        }
        this.listeners.clear();
        this.monitors.clear();
    }

    @Override
    public void removeStatisticsFromMonitor(Statistics stats) {
    }

    class MemberLevelRegionStatisticsListener
    implements StatisticsListener {
        final Map<String, Number> statsMap = new HashMap<String, Number>();
        private boolean removed = false;

        MemberLevelRegionStatisticsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(StatisticsNotification notification) {
            Map<String, Number> map = this.statsMap;
            synchronized (map) {
                if (this.removed) {
                    return;
                }
                for (StatisticId statId : notification) {
                    Number value;
                    StatisticDescriptor descriptor = statId.getStatisticDescriptor();
                    String name = descriptor.getName();
                    try {
                        value = notification.getValue(statId);
                    }
                    catch (StatisticNotFoundException e) {
                        value = 0;
                    }
                    AggregateRegionStatsMonitor.this.log(name, value);
                    Number deltaValue = AggregateRegionStatsMonitor.this.computeDelta(this.statsMap, name, value);
                    this.statsMap.put(name, value);
                    AggregateRegionStatsMonitor.this.increaseStats(name, deltaValue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void decreaseParStats() {
            Map<String, Number> map = this.statsMap;
            synchronized (map) {
                AggregateRegionStatsMonitor.this.bucketCount -= this.statsMap.getOrDefault("bucketCount", 0).intValue();
                AggregateRegionStatsMonitor.this.totalBucketSize -= this.statsMap.getOrDefault("dataStoreEntryCount", 0).intValue();
                AggregateRegionStatsMonitor.this.primaryBucketCount -= this.statsMap.getOrDefault("primaryBucketCount", 0).intValue();
                this.removed = true;
            }
        }
    }
}

